/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.exporter;

import ghidra.app.util.DomainObjectService;
import ghidra.app.util.Option;
import ghidra.app.util.OptionException;
import ghidra.app.util.exporter.Exporter;
import ghidra.app.util.exporter.ExporterException;
import ghidra.app.util.xml.ProgramXmlMgr;
import ghidra.app.util.xml.XmlProgramOptions;
import ghidra.framework.model.DomainObject;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.listing.Program;
import ghidra.util.HelpLocation;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.TaskMonitor;
import java.io.File;
import java.io.IOException;
import java.util.List;

public class XmlExporter
extends Exporter {
    private XmlProgramOptions options = new XmlProgramOptions();

    public XmlExporter() {
        super("XML", "xml", new HelpLocation("ExporterPlugin", "xml"));
    }

    @Override
    public List<Option> getOptions(DomainObjectService domainObjectService) {
        if (this.options == null) {
            this.options = new XmlProgramOptions();
        }
        return this.options.getOptions(false);
    }

    @Override
    public void setOptions(List<Option> options) throws OptionException {
        this.options.setOptions(options);
    }

    @Override
    public boolean export(File file, DomainObject domainObj, AddressSetView addrSet, TaskMonitor monitor) throws IOException, ExporterException {
        this.log.clear();
        if (!(domainObj instanceof Program)) {
            this.log.appendMsg("Unsupported type: " + domainObj.getClass().getName());
            return false;
        }
        Program program = (Program)domainObj;
        if (addrSet == null) {
            addrSet = program.getMemory();
        }
        ProgramXmlMgr mgr = new ProgramXmlMgr(file);
        try {
            this.log = mgr.write(program, addrSet, monitor, this.options);
        }
        catch (CancelledException e) {
            throw new ExporterException("User cancelled XML export.");
        }
        this.options = null;
        return true;
    }
}

