/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import com.typesafe.scalalogging.Logger;
import com.yammer.metrics.core.Meter;
import java.io.Serializable;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import kafka.server.CachedPartition;
import kafka.server.EvictableKey;
import kafka.server.FetchSession;
import kafka.server.FetchSession$;
import kafka.server.FetchSessionCache$;
import kafka.server.LastUsedKey;
import kafka.utils.Logging;
import org.apache.kafka.common.requests.FetchMetadata;
import org.apache.kafka.common.utils.ImplicitLinkedHashCollection;
import scala.Function0;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.collection.mutable.HashMap;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0005\u0005\rf\u0001B\u0013'\u0001-B\u0001\u0002\u000f\u0001\u0003\u0006\u0004%I!\u000f\u0005\t{\u0001\u0011\t\u0011)A\u0005u!Aa\b\u0001BC\u0002\u0013%q\b\u0003\u0005D\u0001\t\u0005\t\u0015!\u0003A\u0011!!\u0005A!b\u0001\n\u0003I\u0004\u0002C#\u0001\u0005\u0003\u0005\u000b\u0011\u0002\u001e\t\u0011\u0019\u0003!Q1A\u0005\neB\u0001b\u0012\u0001\u0003\u0002\u0003\u0006IA\u000f\u0005\u0006\u0011\u0002!\t!\u0013\u0005\b!\u0002\u0001\r\u0011\"\u0003@\u0011\u001d\t\u0006\u00011A\u0005\nICa\u0001\u0017\u0001!B\u0013\u0001\u0005bB-\u0001\u0005\u0004%IA\u0017\u0005\u0007M\u0002\u0001\u000b\u0011B.\t\u000f\u001d\u0004!\u0019!C\u0005Q\"1A\u000f\u0001Q\u0001\n%Dq!\u001e\u0001C\u0002\u0013%a\u000f\u0003\u0004|\u0001\u0001\u0006Ia\u001e\u0005\by\u0002\u0011\r\u0011\"\u0003w\u0011\u0019i\b\u0001)A\u0005o\"Aa\u0010\u0001b\u0001\n\u00031s\u0010\u0003\u0005\u0002\u001a\u0001\u0001\u000b\u0011BA\u0001\u0011\u001d\tY\u0002\u0001C\u0001\u0003;Aa!!\u000b\u0001\t\u0003I\u0004BBA\u0016\u0001\u0011\u0005q\bC\u0004\u0002.\u0001!\t!a\f\t\u000f\u0005E\u0002\u0001\"\u0001\u00024!9\u0011\u0011\r\u0001\u0005\n\u0005\r\u0004bBA7\u0001\u0011\u0005\u0011q\u000e\u0005\b\u0003[\u0002A\u0011AA:\u0011\u001d\tI\b\u0001C\u0001\u0003w:\u0011\"!!'\u0003\u0003E\t!a!\u0007\u0011\u00152\u0013\u0011!E\u0001\u0003\u000bCa\u0001S\u0011\u0005\u0002\u0005\u001d\u0005\"CAECE\u0005I\u0011AAF\u0011%\t\t+II\u0001\n\u0003\tYI\u0001\fGKR\u001c\u0007nU3tg&|gnQ1dQ\u0016\u001c\u0006.\u0019:e\u0015\t9\u0003&\u0001\u0004tKJ4XM\u001d\u0006\u0002S\u0005)1.\u00194lC\u000e\u00011c\u0001\u0001-eA\u0011Q\u0006M\u0007\u0002])\tq&A\u0003tG\u0006d\u0017-\u0003\u00022]\t1\u0011I\\=SK\u001a\u0004\"a\r\u001c\u000e\u0003QR!!\u000e\u0015\u0002\u000bU$\u0018\u000e\\:\n\u0005]\"$a\u0002'pO\u001eLgnZ\u0001\u000b[\u0006DXI\u001c;sS\u0016\u001cX#\u0001\u001e\u0011\u00055Z\u0014B\u0001\u001f/\u0005\rIe\u000e^\u0001\f[\u0006DXI\u001c;sS\u0016\u001c\b%\u0001\u0006fm&\u001cG/[8o\u001bN,\u0012\u0001\u0011\t\u0003[\u0005K!A\u0011\u0018\u0003\t1{gnZ\u0001\fKZL7\r^5p]6\u001b\b%\u0001\btKN\u001c\u0018n\u001c8JIJ\u000bgnZ3\u0002\u001fM,7o]5p]&#'+\u00198hK\u0002\n\u0001b\u001d5be\u0012tU/\\\u0001\ng\"\f'\u000f\u001a(v[\u0002\na\u0001P5oSRtD#\u0002&M\u001b:{\u0005CA&\u0001\u001b\u00051\u0003\"\u0002\u001d\n\u0001\u0004Q\u0004\"\u0002 \n\u0001\u0004\u0001\u0005b\u0002#\n!\u0003\u0005\rA\u000f\u0005\b\r&\u0001\n\u00111\u0001;\u00035qW/\u001c)beRLG/[8og\u0006\tb.^7QCJ$\u0018\u000e^5p]N|F%Z9\u0015\u0005M3\u0006CA\u0017U\u0013\t)fF\u0001\u0003V]&$\bbB,\f\u0003\u0003\u0005\r\u0001Q\u0001\u0004q\u0012\n\u0014A\u00048v[B\u000b'\u000f^5uS>t7\u000fI\u0001\tg\u0016\u001c8/[8ogV\t1\f\u0005\u0003]Cj\u001aW\"A/\u000b\u0005y{\u0016aB7vi\u0006\u0014G.\u001a\u0006\u0003A:\n!bY8mY\u0016\u001cG/[8o\u0013\t\u0011WLA\u0004ICNDW*\u00199\u0011\u0005-#\u0017BA3'\u000511U\r^2i'\u0016\u001c8/[8o\u0003%\u0019Xm]:j_:\u001c\b%\u0001\u0005mCN$Xk]3e+\u0005I\u0007\u0003\u00026pc\u000el\u0011a\u001b\u0006\u0003Y6\fA!\u001e;jY*\ta.\u0001\u0003kCZ\f\u0017B\u00019l\u0005\u001d!&/Z3NCB\u0004\"a\u0013:\n\u0005M4#a\u0003'bgR,6/\u001a3LKf\f\u0011\u0002\\1tiV\u001bX\r\u001a\u0011\u0002\u001d\u00154\u0018n\u0019;bE2,')_!mYV\tq\u000f\u0005\u0003k_b\u001c\u0007CA&z\u0013\tQhE\u0001\u0007Fm&\u001cG/\u00192mK.+\u00170A\bfm&\u001cG/\u00192mK\nK\u0018\t\u001c7!\u0003U)g/[2uC\ndWMQ=Qe&4\u0018\u000e\\3hK\u0012\fa#\u001a<jGR\f'\r\\3CsB\u0013\u0018N^5mK\u001e,G\rI\u0001\u000fKZL7\r^5p]NlU\r^3s+\t\t\t\u0001\u0005\u0003\u0002\u0004\u0005UQBAA\u0003\u0015\u0011\t9!!\u0003\u0002\t\r|'/\u001a\u0006\u0005\u0003\u0017\ti!A\u0004nKR\u0014\u0018nY:\u000b\t\u0005=\u0011\u0011C\u0001\u0007s\u0006lW.\u001a:\u000b\u0005\u0005M\u0011aA2p[&!\u0011qCA\u0003\u0005\u0015iU\r^3s\u0003=)g/[2uS>t7/T3uKJ\u0004\u0013aA4fiR!\u0011qDA\u0013!\u0011i\u0013\u0011E2\n\u0007\u0005\rbF\u0001\u0004PaRLwN\u001c\u0005\u0007\u0003O9\u0002\u0019\u0001\u001e\u0002\u0013M,7o]5p]&#\u0017\u0001B:ju\u0016\fq\u0002^8uC2\u0004\u0016M\u001d;ji&|gn]\u0001\r]\u0016<8+Z:tS>t\u0017\n\u001a\u000b\u0002u\u0005\u0011R.Y=cK\u000e\u0013X-\u0019;f'\u0016\u001c8/[8o)-Q\u0014QGA\u001d\u0003\u0007\n)%!\u0013\t\r\u0005]2\u00041\u0001A\u0003\rqwn\u001e\u0005\b\u0003wY\u0002\u0019AA\u001f\u0003)\u0001(/\u001b<jY\u0016<W\r\u001a\t\u0004[\u0005}\u0012bAA!]\t9!i\\8mK\u0006t\u0007BBA\u00157\u0001\u0007!\bC\u0004\u0002Hm\u0001\r!!\u0010\u0002\u0019U\u001cXm\u001d+pa&\u001c\u0017\nZ:\t\u000f\u0005-3\u00041\u0001\u0002N\u0005\u00012M]3bi\u0016\u0004\u0016M\u001d;ji&|gn\u001d\t\u0006[\u0005=\u00131K\u0005\u0004\u0003#r#!\u0003$v]\u000e$\u0018n\u001c81!\u0011\t)&a\u0017\u000f\u0007-\u000b9&C\u0002\u0002Z\u0019\nABR3uG\"\u001cVm]:j_:LA!!\u0018\u0002`\tI1)Q\"I\u000b~k\u0015\t\u0015\u0006\u0004\u000332\u0013\u0001\u0003;ss\u00163\u0018n\u0019;\u0015\u0011\u0005u\u0012QMA4\u0003WBq!a\u000f\u001d\u0001\u0004\ti\u0004\u0003\u0004\u0002jq\u0001\r\u0001_\u0001\u0004W\u0016L\bBBA\u001c9\u0001\u0007\u0001)\u0001\u0004sK6|g/\u001a\u000b\u0005\u0003?\t\t\b\u0003\u0004\u0002(u\u0001\rA\u000f\u000b\u0005\u0003?\t)\b\u0003\u0004\u0002xy\u0001\raY\u0001\bg\u0016\u001c8/[8o\u0003\u0015!x.^2i)\u0015\u0019\u0016QPA@\u0011\u0019\t9h\ba\u0001G\"1\u0011qG\u0010A\u0002\u0001\u000baCR3uG\"\u001cVm]:j_:\u001c\u0015m\u00195f'\"\f'\u000f\u001a\t\u0003\u0017\u0006\u001a\"!\t\u0017\u0015\u0005\u0005\r\u0015a\u0007\u0013mKN\u001c\u0018N\\5uI\u001d\u0014X-\u0019;fe\u0012\"WMZ1vYR$3'\u0006\u0002\u0002\u000e*\u001a!(a$,\u0005\u0005E\u0005\u0003BAJ\u0003;k!!!&\u000b\t\u0005]\u0015\u0011T\u0001\nk:\u001c\u0007.Z2lK\u0012T1!a'/\u0003)\tgN\\8uCRLwN\\\u0005\u0005\u0003?\u000b)JA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016\f1\u0004\n7fgNLg.\u001b;%OJ,\u0017\r^3sI\u0011,g-Y;mi\u0012\"\u0004")
public class FetchSessionCacheShard
implements Logging {
    private final int maxEntries;
    private final long evictionMs;
    private final int sessionIdRange;
    private final int shardNum;
    private long numPartitions;
    private final HashMap<Object, FetchSession> sessions;
    private final TreeMap<LastUsedKey, FetchSession> lastUsed;
    private final TreeMap<EvictableKey, FetchSession> evictableByAll;
    private final TreeMap<EvictableKey, FetchSession> evictableByPrivileged;
    private final Meter evictionsMeter;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    public static int $lessinit$greater$default$4() {
        return 0;
    }

    public static int $lessinit$greater$default$3() {
        return Integer.MAX_VALUE;
    }

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    private int maxEntries() {
        return this.maxEntries;
    }

    private long evictionMs() {
        return this.evictionMs;
    }

    public int sessionIdRange() {
        return this.sessionIdRange;
    }

    private int shardNum() {
        return this.shardNum;
    }

    private long numPartitions() {
        return this.numPartitions;
    }

    private void numPartitions_$eq(long x$1) {
        this.numPartitions = x$1;
    }

    private HashMap<Object, FetchSession> sessions() {
        return this.sessions;
    }

    private TreeMap<LastUsedKey, FetchSession> lastUsed() {
        return this.lastUsed;
    }

    private TreeMap<EvictableKey, FetchSession> evictableByAll() {
        return this.evictableByAll;
    }

    private TreeMap<EvictableKey, FetchSession> evictableByPrivileged() {
        return this.evictableByPrivileged;
    }

    public Meter evictionsMeter() {
        return this.evictionsMeter;
    }

    public synchronized Option<FetchSession> get(int sessionId) {
        return this.sessions().get((Object)BoxesRunTime.boxToInteger((int)sessionId));
    }

    public synchronized int size() {
        return this.sessions().size();
    }

    public synchronized long totalPartitions() {
        return this.numPartitions();
    }

    public synchronized int newSessionId() {
        int id;
        do {
            id = ThreadLocalRandom.current().nextInt(Math.max(1, this.shardNum() * this.sessionIdRange()), (this.shardNum() + 1) * this.sessionIdRange());
        } while (this.sessions().contains((Object)BoxesRunTime.boxToInteger((int)id)) || id == 0);
        return id;
    }

    public synchronized int maybeCreateSession(long now, boolean privileged, int size, boolean usesTopicIds, Function0<ImplicitLinkedHashCollection<CachedPartition>> createPartitions) {
        if (this.sessions().size() < this.maxEntries() || this.tryEvict(privileged, new EvictableKey(privileged, size, 0), now)) {
            ImplicitLinkedHashCollection partitionMap = (ImplicitLinkedHashCollection)createPartitions.apply();
            FetchSession session = new FetchSession(this.newSessionId(), privileged, (ImplicitLinkedHashCollection<CachedPartition>)partitionMap, usesTopicIds, now, now, FetchMetadata.nextEpoch((int)0));
            this.debug((Function0<String>)(Function0 & Serializable)() -> "Created fetch session " + session.toString());
            this.sessions().put((Object)BoxesRunTime.boxToInteger((int)session.id()), (Object)session);
            this.touch(session, now);
            return session.id();
        }
        this.debug((Function0<String>)(Function0 & Serializable)() -> "No fetch session created for privileged=" + privileged + ", size=" + size + ".");
        return 0;
    }

    private synchronized boolean tryEvict(boolean privileged, EvictableKey key, long now) {
        Map.Entry<LastUsedKey, FetchSession> lastUsedEntry = this.lastUsed().firstEntry();
        if (lastUsedEntry == null) {
            this.trace((Function0<String>)(Function0 & Serializable)() -> "There are no cache entries to evict.");
            return false;
        }
        if (now - lastUsedEntry.getKey().lastUsedMs() > this.evictionMs()) {
            FetchSession session = lastUsedEntry.getValue();
            this.trace((Function0<String>)(Function0 & Serializable)() -> "Evicting stale FetchSession " + session.id() + ".");
            this.remove(session);
            this.evictionsMeter().mark();
            return true;
        }
        Map.Entry<EvictableKey, FetchSession> evictableEntry = (privileged ? this.evictableByPrivileged() : this.evictableByAll()).firstEntry();
        if (evictableEntry == null) {
            this.trace((Function0<String>)(Function0 & Serializable)() -> "No evictable entries found.");
            return false;
        }
        if (key.compareTo(evictableEntry.getKey()) < 0) {
            this.trace((Function0<String>)(Function0 & Serializable)() -> "Can't evict " + evictableEntry.getKey() + " with " + key.toString());
            return false;
        }
        this.trace((Function0<String>)(Function0 & Serializable)() -> "Evicting " + evictableEntry.getKey() + " with " + key.toString() + ".");
        this.remove(evictableEntry.getValue());
        this.evictionsMeter().mark();
        return true;
    }

    public synchronized Option<FetchSession> remove(int sessionId) {
        Option<FetchSession> option = this.get(sessionId);
        if (None$.MODULE$.equals(option)) {
            return None$.MODULE$;
        }
        if (option instanceof Some) {
            FetchSession session = (FetchSession)((Some)option).value();
            return this.remove(session);
        }
        throw new MatchError(option);
    }

    public synchronized Option<FetchSession> remove(FetchSession session) {
        EvictableKey evictableKey;
        synchronized (session) {
            this.lastUsed().remove(session.lastUsedKey());
            evictableKey = session.evictableKey();
        }
        this.evictableByAll().remove(evictableKey);
        this.evictableByPrivileged().remove(evictableKey);
        Option removeResult = this.sessions().remove((Object)BoxesRunTime.boxToInteger((int)session.id()));
        if (removeResult.isDefined()) {
            this.numPartitions_$eq(this.numPartitions() - (long)session.cachedSize());
        }
        return removeResult;
    }

    public synchronized void touch(FetchSession session, long now) {
        synchronized (session) {
            this.lastUsed().remove(session.lastUsedKey());
            session.lastUsedMs_$eq(now);
            this.lastUsed().put(session.lastUsedKey(), session);
            int oldSize = session.cachedSize();
            if (oldSize != -1) {
                EvictableKey oldEvictableKey = session.evictableKey();
                this.evictableByPrivileged().remove(oldEvictableKey);
                this.evictableByAll().remove(oldEvictableKey);
                this.numPartitions_$eq(this.numPartitions() - (long)oldSize);
            }
            session.cachedSize_$eq(session.size());
            EvictableKey newEvictableKey = session.evictableKey();
            if (!session.privileged() || now - session.creationMs() > this.evictionMs()) {
                this.evictableByPrivileged().put(newEvictableKey, session);
            }
            if (now - session.creationMs() > this.evictionMs()) {
                this.evictableByAll().put(newEvictableKey, session);
            }
            this.numPartitions_$eq(this.numPartitions() + (long)session.cachedSize());
            return;
        }
    }

    public FetchSessionCacheShard(int maxEntries, long evictionMs, int sessionIdRange, int shardNum) {
        this.maxEntries = maxEntries;
        this.evictionMs = evictionMs;
        this.sessionIdRange = sessionIdRange;
        this.shardNum = shardNum;
        this.logIdent_$eq("[Shard " + shardNum + "] ");
        this.numPartitions = 0L;
        this.sessions = new HashMap();
        this.lastUsed = new TreeMap();
        this.evictableByAll = new TreeMap();
        this.evictableByPrivileged = new TreeMap();
        this.evictionsMeter = FetchSessionCache$.MODULE$.metricsGroup().newMeter(FetchSession$.MODULE$.INCREMENTAL_FETCH_SESSIONS_EVICTIONS_PER_SEC(), FetchSession$.MODULE$.EVICTIONS(), TimeUnit.SECONDS);
    }
}

