/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.representations.workflows;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import org.keycloak.common.util.MultivaluedHashMap;
import org.keycloak.representations.workflows.AbstractWorkflowComponentRepresentation;
import org.keycloak.representations.workflows.WorkflowConcurrencyRepresentation;
import org.keycloak.representations.workflows.WorkflowScheduleRepresentation;
import org.keycloak.representations.workflows.WorkflowStateRepresentation;
import org.keycloak.representations.workflows.WorkflowStepRepresentation;

@JsonPropertyOrder(value={"id", "name", "uses", "enabled", "on", "schedule", "concurrency", "if", "steps", "state"})
@JsonIgnoreProperties(value={"with"})
@JsonInclude(value=JsonInclude.Include.NON_NULL)
public final class WorkflowRepresentation
extends AbstractWorkflowComponentRepresentation {
    private List<WorkflowStepRepresentation> steps;
    private WorkflowStateRepresentation state;
    @JsonProperty(value="concurrency")
    private WorkflowConcurrencyRepresentation concurrency;
    @JsonProperty(value="schedule")
    private WorkflowScheduleRepresentation schedule;

    public static Builder withName(String name) {
        return new Builder().withName(name);
    }

    public WorkflowRepresentation() {
        super(null, null);
    }

    public WorkflowRepresentation(String id, String name, MultivaluedHashMap<String, String> config, List<WorkflowStepRepresentation> steps) {
        super(id, config);
        this.setName(name);
        this.steps = steps;
    }

    public String getOn() {
        return this.getConfigValue("on", String.class);
    }

    public void setOn(String eventConditions) {
        this.setConfigValue("on", eventConditions);
    }

    public WorkflowScheduleRepresentation getSchedule() {
        if (this.schedule == null) {
            String after = this.getConfigValue("schedule.after", String.class);
            Integer batchSize = this.getConfigValue("schedule.batch-size", Integer.class);
            if (after != null || batchSize != null) {
                this.schedule = new WorkflowScheduleRepresentation();
                this.schedule.setAfter(after);
                this.schedule.setBatchSize(batchSize);
            }
        }
        return this.schedule;
    }

    public void setSchedule(WorkflowScheduleRepresentation schedule) {
        this.schedule = schedule;
        if (schedule != null) {
            this.setConfigValue("schedule.after", schedule.getAfter());
            this.setConfigValue("schedule.batch-size", schedule.getBatchSize());
        }
    }

    public String getName() {
        return this.getConfigValue("name", String.class);
    }

    public void setName(String name) {
        this.setConfigValue("name", name);
    }

    public Boolean getEnabled() {
        return this.getConfigValue("enabled", Boolean.class);
    }

    public void setEnabled(Boolean enabled) {
        this.setConfigValue("enabled", enabled);
    }

    @JsonProperty(value="if")
    public String getConditions() {
        return this.getConfigValue("conditions", String.class);
    }

    public void setConditions(String conditions) {
        this.setConfigValue("conditions", conditions);
    }

    public void setSteps(List<WorkflowStepRepresentation> steps) {
        this.steps = steps;
    }

    public List<WorkflowStepRepresentation> getSteps() {
        return this.steps;
    }

    public WorkflowStateRepresentation getState() {
        if (this.state == null) {
            this.state = new WorkflowStateRepresentation(this);
        }
        if (this.state.getErrors().isEmpty()) {
            return null;
        }
        return this.state;
    }

    public void setState(WorkflowStateRepresentation state) {
        this.state = state;
    }

    public WorkflowConcurrencyRepresentation getConcurrency() {
        String cancelInProgress = this.getConfigValue("cancel-in-progress", String.class);
        String restartInProgress = this.getConfigValue("restart-in-progress", String.class);
        if (this.concurrency == null && (cancelInProgress != null || restartInProgress != null)) {
            this.concurrency = new WorkflowConcurrencyRepresentation();
            this.concurrency.setCancelInProgress(cancelInProgress);
            this.concurrency.setRestartInProgress(restartInProgress);
        }
        return this.concurrency;
    }

    public void setConcurrency(WorkflowConcurrencyRepresentation concurrency) {
        this.concurrency = concurrency;
        if (concurrency != null) {
            this.setConfigValue("cancel-in-progress", concurrency.getCancelInProgress());
            this.setConfigValue("restart-in-progress", concurrency.getRestartInProgress());
        }
    }

    @JsonIgnore
    public String getCancelInProgress() {
        return this.concurrency != null ? this.concurrency.getCancelInProgress() : null;
    }

    @JsonIgnore
    public String getRestartInProgress() {
        return this.concurrency != null ? this.concurrency.getRestartInProgress() : null;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof WorkflowRepresentation)) {
            return false;
        }
        WorkflowRepresentation that = (WorkflowRepresentation)obj;
        return Objects.equals(this.getConfig(), that.getConfig()) && Objects.equals(this.getSteps(), that.getSteps());
    }

    public static class Builder {
        private WorkflowRepresentation representation = new WorkflowRepresentation();

        private Builder() {
        }

        public Builder onEvent(String operation) {
            this.representation.addConfigValue("on", operation);
            return this;
        }

        public Builder onEvent(String ... operation) {
            return this.onEvent(String.join((CharSequence)" or ", operation).toUpperCase());
        }

        public Builder onCondition(String condition) {
            this.representation.setConditions(condition);
            return this;
        }

        public Builder concurrency() {
            if (this.representation.getConcurrency() == null) {
                this.representation.setConcurrency(new WorkflowConcurrencyRepresentation());
            }
            return this;
        }

        public Builder cancelInProgress(String cancelInProgress) {
            if (this.representation.getConcurrency() == null) {
                this.representation.setConcurrency(new WorkflowConcurrencyRepresentation());
            }
            this.representation.getConcurrency().setCancelInProgress(cancelInProgress);
            return this;
        }

        public Builder restartInProgress(String restartInProgress) {
            if (this.representation.getConcurrency() == null) {
                this.representation.setConcurrency(new WorkflowConcurrencyRepresentation());
            }
            this.representation.getConcurrency().setRestartInProgress(restartInProgress);
            return this;
        }

        public Builder withSteps(WorkflowStepRepresentation ... steps) {
            this.representation.setSteps(Arrays.asList(steps));
            return this;
        }

        public Builder withConfig(String key, String value) {
            this.representation.addConfigValue(key, value);
            return this;
        }

        public Builder withConfig(String key, List<String> values) {
            this.representation.setConfigValue(key, values);
            return this;
        }

        public Builder withName(String name) {
            this.representation.setName(name);
            return this;
        }

        public Builder schedule(WorkflowScheduleRepresentation schedule) {
            this.representation.setSchedule(schedule);
            return this;
        }

        public WorkflowRepresentation build() {
            return this.representation;
        }
    }
}

