/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.project.ngm.math;

import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.Map;
import java.util.NavigableMap;
import java.util.TreeMap;
import net.sourceforge.plantuml.project.ngm.math.AbstractPiecewiseConstant;
import net.sourceforge.plantuml.project.ngm.math.Fraction;
import net.sourceforge.plantuml.project.ngm.math.Segment;
import net.sourceforge.plantuml.project.ngm.math.TimeDirection;

public final class PiecewiseConstantHours
extends AbstractPiecewiseConstant {
    private final Fraction defaultValue;
    private final NavigableMap<LocalTime, Fraction> timeBoundaries = new TreeMap<LocalTime, Fraction>();

    private PiecewiseConstantHours(Fraction defaultValue) {
        this.defaultValue = defaultValue;
    }

    public static PiecewiseConstantHours of(Fraction defaultValue) {
        return new PiecewiseConstantHours(defaultValue);
    }

    @Override
    public Segment segmentAt(LocalDateTime instant, TimeDirection direction) {
        return direction == TimeDirection.FORWARD ? this.segmentForwardAt(instant) : this.segmentBackwardAt(instant);
    }

    private Segment segmentForwardAt(LocalDateTime instant) {
        LocalDate day = instant.toLocalDate();
        LocalDateTime dayStart = day.atStartOfDay();
        LocalTime t = instant.toLocalTime();
        Map.Entry<LocalTime, Fraction> ent = this.timeBoundaries.floorEntry(t);
        LocalTime startKey = ent != null ? ent.getKey() : LocalTime.MIDNIGHT;
        Fraction v = (Fraction)this.timeBoundaries.get(startKey);
        Fraction value = v != null ? v : this.defaultValue;
        LocalTime endKey = this.timeBoundaries.higherKey(startKey);
        LocalDateTime start = dayStart.with(startKey);
        LocalDateTime end = endKey == null ? dayStart.plusDays(1L) : dayStart.with(endKey);
        return Segment.forward(start, end, value);
    }

    private Segment segmentBackwardAt(LocalDateTime instant) {
        LocalTime t = instant.toLocalTime();
        if (t.equals(LocalTime.MIDNIGHT)) {
            LocalDateTime dayStart = instant.toLocalDate().minusDays(1L).atStartOfDay();
            Map.Entry<LocalTime, Fraction> last = this.timeBoundaries.lastEntry();
            LocalTime startKey = last == null ? LocalTime.MIDNIGHT : last.getKey();
            Fraction value = last == null ? this.defaultValue : last.getValue();
            LocalDateTime start = dayStart.plusDays(1L);
            LocalDateTime end = dayStart.with(startKey);
            return Segment.backward(start, end, value);
        }
        LocalDateTime dayStart = instant.toLocalDate().atStartOfDay();
        Map.Entry<LocalTime, Fraction> ent = this.timeBoundaries.lowerEntry(t);
        LocalTime startKey = ent == null ? LocalTime.MIDNIGHT : ent.getKey();
        Fraction value = ent == null ? this.defaultValue : ent.getValue();
        LocalTime endKey = this.timeBoundaries.higherKey(startKey);
        LocalDateTime start = endKey == null ? dayStart.plusDays(1L) : dayStart.with(endKey);
        LocalDateTime end = dayStart.with(startKey);
        return Segment.backward(start, end, value);
    }

    public PiecewiseConstantHours with(LocalTime start, LocalTime end, Fraction fraction) {
        if (!end.equals(LocalTime.MIDNIGHT) && start.compareTo(end) >= 0) {
            throw new IllegalArgumentException("start must be strictly before end");
        }
        PiecewiseConstantHours result = new PiecewiseConstantHours(this.defaultValue);
        result.timeBoundaries.putAll(this.timeBoundaries);
        result.timeBoundaries.put(start, fraction);
        if (!end.equals(LocalTime.MIDNIGHT)) {
            result.timeBoundaries.put(end, this.defaultValue);
        }
        return result;
    }
}

