# ------------------------------------------------------------
# This file was generated using create_marin_data.py
#
# on    : Version 2022.3.1
# under : SymPy 1.10.1
# using : Python 3.8.10
# ------------------------------------------------------------

# generated data function for cubic Hecke algebra
def _read_regr(u, v, w):
    r"""
    Return precomputed representation matrices of Ivan Marin

    This code has been generated by ``create_marin_data.py`` (from
    the `database_cubic_hecke repository  <https://github.com/soehms/database_cubic_hecke>`__),
    please don't edit.

    INPUT:

    ``u, v, w`` -- values for the variables of the representation matrices

    OUTPUT:

    A triple ``dim_list, repr_list, repr_list_inv`` where each member
    is a list indexed by the number of the representation.

    ``dim_list`` is a list of integers representing the dimension of
    the corresponding representation
    ``repr_list`` is a triple of dictionaries each describing the
    representation matrix of the corresponding generator of the
    cubic Hecke algebra.
    ``repr_list_inv`` is a triple of dictionaries each describing the
    inverse of the correspondig matrix of ``repr_list``.

    EXAMPLES::

        >>> from database_cubic_hecke import _read_regr
        >>> dim_list, repr_list, repr_list_inv = _read_regr(3, 5, 7)
        >>> dim_list
        [648]
        >>> len(repr_list)
        1
        >>> g1, g2, g3 = repr_list[0]
        >>> list(g1.items())[0]
        ((0, 27), -5)
    """

    data = ([648], [[{(0, 27): -v, (0, 54): 1, (1, 28): -v, (1, 55): 1, (2, 29):
        -v, (2, 56): 1, (3, 30): -v, (3, 57): 1, (4, 31): -v, (4, 58):
        1, (5, 9): 1, (5, 10): -v, (5, 45): v*(u*v - w)/w, (5, 158):
        v**2, (5, 159): -v**3, (5, 185): -v, (5, 186): v**2, (5, 212):
        -u*v**2/w, (5, 213): v**2, (5, 239): u*v/w, (5, 240): -v, (5,
        406): v**2, (5, 433): -u*v**2/w, (5, 460): -v, (5, 487):
        u*v/w, (5, 595): u*v**3/w, (5, 622): -u*v**2/w, (6, 11): 1,
        (6, 12): -v, (6, 45): u*v/w, (6, 72): -u/w, (6, 157): -v*w,
        (6, 161): -v**3, (6, 184): u*v, (6, 188): v**2, (6, 211): u*v,
        (6, 215): v**2, (6, 238): -u**2*v/w, (6, 242): -v, (7, 13): 1,
        (7, 14): -v, (7, 44): v*(u*v - w)/w, (8, 15): 1, (8, 16): -v,
        (8, 44): u*v/w, (8, 71): -u/w, (8, 184): u*(u*v - w)/w, (8,
        238): -u**2*(u*v - w)/w**2, (8, 407): -u*v**2/w, (8, 434):
        u*v/w, (8, 461): u*v/w, (8, 488): -u/w, (8, 596): -u*v**2/w,
        (8, 623): u*v/w, (9, 10): w, (9, 18): v, (9, 49): -v**2*w, (9,
        76): v*w, (10, 5): 1, (10, 10): u, (10, 18): u*v/w, (10, 50):
        v, (10, 77): -u*v/w, (10, 82): v, (10, 109): -u*v/w, (11, 12):
        w, (11, 28): u*v**2/w, (11, 55): -u*v/w, (12, 6): 1, (12, 12):
        u, (12, 18): u/w, (12, 28): u*v/w, (12, 51): v, (12, 53):
        -v**2, (12, 55): -u**2*v/w**2, (12, 78): -u*v/w, (12, 80): v,
        (13, 14): w, (13, 17): v, (13, 49): -u*v**2, (13, 76): u*v,
        (13, 158): u*v, (13, 185): -u, (13, 212): -u**2*v/w, (13,
        239): u**2/w, (13, 406): u**2*v**2/w, (13, 433): -u**2*v/w,
        (13, 460): -u**2*v/w, (13, 487): u**2/w, (13, 595):
        u**2*v**2/w, (13, 622): -u**2*v/w, (14, 7): 1, (14, 14): u,
        (14, 17): u*v/w, (14, 49): -u*v, (14, 76): u**2*v/w, (14,
        158): u, (14, 185): -u**2/w, (14, 212): -u**2/w, (14, 239):
        u**3/w**2, (14, 406): u**2*v/w, (14, 433): -u**2/w, (14, 460):
        -u**3*v/w**2, (14, 487): u**3/w**2, (14, 595): u**2*v/w, (14,
        622): u**3*v*(u*v - 2*w)/w**3, (15, 16): w, (15, 22): u**2,
        (15, 161): -u*v**2, (15, 188): u*v, (15, 215): u*v, (15, 242):
        -u, (16, 8): 1, (16, 16): u, (16, 17): u/w, (16, 83): -u*v/w,
        (16, 110): u/w, (16, 159): u, (16, 161): -u*v, (16, 186):
        -u**2/w, (16, 188): u**2*v/w, (16, 213): -u**2/w, (16, 215):
        u, (16, 240): u**3/w**2, (16, 242): -u**2/w, (17, 44): -v,
        (17, 49): u*w, (17, 71): 1, (17, 76): -u**2, (17, 105): u*v,
        (17, 132): -u, (18, 45): -v, (18, 72): 1, (19, 20): -v, (19,
        21): 1, (19, 29): v*(u*v - w)/w, (20, 2): u*v/w, (20, 19): 1,
        (20, 20): u, (20, 406): -u*v/w, (20, 433): u/w, (20, 460):
        u**2*v/w**2, (20, 487): -u**2/w**2, (20, 595): -u*v/w, (20,
        622): -u**2*v*(u*v - 2*w)/w**3, (21, 2): v, (21, 20): w, (21,
        406): -u*v**2/w, (21, 433): u*v/w, (21, 460): u*v/w, (21,
        487): -u/w, (21, 595): -u*v**2/w, (21, 622): u*v/w, (22, 22):
        u, (22, 25): 1, (23, 104): -v, (23, 131): 1, (24, 103): w,
        (24, 130): -u, (25, 22): -v, (25, 105): -v, (25, 132): 1, (26,
        107): -v, (26, 134): 1, (27, 0): 1, (27, 27): u, (28, 1): 1,
        (28, 28): u, (29, 2): 1, (29, 29): u, (30, 3): 1, (30, 30): u,
        (31, 4): 1, (31, 31): u, (32, 18): -u*v/w, (32, 36): 1, (32,
        37): -v, (32, 45): -u**2*v/w, (32, 72): -v/w, (32, 105): v**2,
        (32, 132): -v, (32, 159): u*v**2, (32, 186): -u*v, (32, 212):
        v**2/w, (32, 239): -v/w, (32, 244): v**2, (32, 271): -v, (32,
        352): -u*v**2/w, (32, 514): u*v/w, (32, 568): -u*v**2/w, (32,
        595): -u**2*v**2/w, (33, 18): -u/w, (33, 38): 1, (33, 39): -v,
        (33, 45): -u**2/w, (33, 107): v**2, (33, 134): -v, (33, 161):
        u*v**2, (33, 188): -u*v, (33, 211): -v, (33, 238): u*v/w, (34,
        17): -u*v/w, (34, 40): 1, (34, 41): -v, (34, 44): -u**2*v/w,
        (34, 71): -v/w, (35, 17): -u/w, (35, 42): 1, (35, 43): -v,
        (35, 44): -u**2/w, (35, 238): u*(u*v - w)/w**2, (35, 245):
        -u*v**2/w, (35, 272): u*v/w, (35, 353): u*v/w, (35, 515):
        -u/w, (35, 569): u*v/w, (35, 596): u**2*v/w, (36, 22): v*w,
        (36, 37): w, (36, 45): v, (36, 49): u*v*w, (37, 32): 1, (37,
        37): u, (37, 45): u*v/w, (37, 77): v/w, (37, 136): v, (37,
        163): -u*v/w, (38, 1): -u*v/w, (38, 28): -u**2*v/w, (38, 39):
        w, (39, 26): v, (39, 33): 1, (39, 39): u, (39, 45): u/w, (39,
        53): u*v, (39, 55): u*v/w**2, (39, 78): v/w, (40, 22): u*v,
        (40, 41): w, (40, 44): v, (40, 49): u**2*v, (40, 212): u*v/w,
        (40, 239): -u/w, (40, 244): u**2*v**2/w, (40, 271): -u**2*v/w,
        (40, 352): -u**2*v/w, (40, 514): u**2/w, (40, 568): -u**2*v/w,
        (40, 595): -u**3*v/w, (41, 34): 1, (41, 41): u, (41, 44):
        u*v/w, (41, 76): -u*v/w, (41, 212): u/w, (41, 239):
        -u**2/w**2, (41, 244): u**2*v/w, (41, 271): -u**3*v/w**2, (41,
        352): -u**2/w, (41, 514): u**3/w**2, (41, 568): -u**3*v/w**2,
        (41, 595): -u**4*v/w**2, (41, 622): -u**2*v*(u*v - w)/w**3,
        (42, 43): w, (42, 49): u**2, (42, 107): u*v, (42, 134): -u,
        (42, 161): u**2*v, (42, 188): -u**2, (43, 35): 1, (43, 43): u,
        (43, 44): u/w, (43, 107): u, (43, 134): -u**2/w, (43, 137):
        -u*v/w, (43, 161): u**2, (43, 164): u/w, (43, 188): -u**3/w,
        (43, 213): u/w, (43, 240): -u**2/w**2, (44, 17): 1, (44, 44):
        u, (44, 76): u, (44, 159): u*v, (44, 186): -u, (45, 18): 1,
        (45, 45): u, (46, 2): -u*v/w, (46, 29): -u**2*v/w, (46, 47):
        -v, (46, 48): 1, (46, 56): -v/w, (47, 29): u*v/w, (47, 46): 1,
        (47, 47): u, (47, 244): -u*v/w, (47, 271): u**2*v/w**2, (47,
        352): u/w, (47, 514): -u**2/w**2, (47, 568): u**2*v/w**2, (47,
        595): u**3*v/w**2, (47, 622): u*v*(u*v - w)/w**3, (48, 29): v,
        (48, 47): w, (48, 244): -u*v**2/w, (48, 271): u*v/w, (48,
        352): u*v/w, (48, 514): -u/w, (48, 568): u*v/w, (48, 595):
        u**2*v/w, (49, 49): u, (49, 52): 1, (50, 158): -v, (50, 185):
        1, (51, 157): w, (51, 184): -u, (52, 49): -v, (52, 159): -v,
        (52, 186): 1, (53, 161): -v, (53, 188): 1, (54, 27): w, (55,
        28): w, (56, 29): w, (57, 30): w, (58, 31): w, (59, 18): -v,
        (59, 45): -u*v, (59, 63): 1, (59, 64): -v, (59, 72): -v**2/w,
        (59, 104): v**2, (59, 131): -v, (59, 159): v**2*w, (59, 186):
        -v*w, (59, 212): v**3/w, (59, 239): -v**2/w, (59, 298): v**2,
        (59, 325): -v, (59, 379): -u*v**2/w, (59, 541): u*v/w, (59,
        595): -u*v**2, (60, 45): -u, (60, 65): 1, (60, 66): -v, (60,
        103): -v*w, (60, 130): u*v, (60, 161): v**2*w, (60, 188):
        -v*w, (60, 211): -v**2, (60, 238): u*v**2/w, (61, 17): -v,
        (61, 44): -u*v, (61, 67): 1, (61, 68): -v, (61, 71): -v**2/w,
        (62, 44): -u, (62, 69): 1, (62, 70): -v, (62, 130): u*(u*v -
        w)/w, (62, 238): u*v*(u*v - w)/w**2, (62, 299): -u*v**2/w,
        (62, 326): u*v/w, (62, 380): u*v/w, (62, 542): -u/w, (62,
        596): u*v, (63, 49): v*w**2, (63, 64): w, (63, 72): v, (64,
        23): v, (64, 59): 1, (64, 64): u, (64, 72): u*v/w, (64, 77):
        v**2/w, (64, 190): v, (64, 217): -u*v/w, (65, 28): -u*v, (65,
        66): w, (66, 1): u*v/w, (66, 24): v, (66, 53): v*w, (66, 55):
        u*v**2/w**2, (66, 60): 1, (66, 66): u, (66, 72): u/w, (66,
        78): v**2/w, (67, 49): u*v*w, (67, 68): w, (67, 71): v, (67,
        104): u*v, (67, 131): -u, (67, 212): u*v**2/w, (67, 239):
        -u*v/w, (67, 298): u**2*v**2/w, (67, 325): -u**2*v/w, (67,
        379): -u**2*v/w, (67, 541): u**2/w, (67, 595): -u**2*v, (68,
        22): -u*v, (68, 61): 1, (68, 68): u, (68, 71): u*v/w, (68,
        76): -u*v**2/w, (68, 104): u, (68, 131): -u**2/w, (68, 212):
        u*v/w, (68, 239): -u**2*v/w**2, (68, 298): u**2*v/w, (68,
        325): -u**3*v/w**2, (68, 379): -u**2/w, (68, 541): u**3/w**2,
        (68, 568): -u**2*v*(u*v - w)/w**2, (68, 595): -u**3*v/w, (68,
        622): -u**2*v**2*(u*v - w)/w**3, (69, 70): w, (69, 76): u**2,
        (69, 161): u*v*w, (69, 188): -u*w, (70, 62): 1, (70, 70): u,
        (70, 71): u/w, (70, 105): u, (70, 132): -u**2/w, (70, 161):
        u*w, (70, 188): -u**2, (70, 191): -u*v/w, (70, 213): u*v/w,
        (70, 218): u/w, (70, 240): -u**2*v/w**2, (71, 22): u*w, (71,
        44): w, (71, 76): u*v, (71, 213): u*v, (71, 240): -u, (72,
        45): w, (73, 2): -v, (73, 29): -u*v, (73, 56): -v**2/w, (73,
        74): -v, (73, 75): 1, (74, 56): u*v/w, (74, 73): 1, (74, 74):
        u, (74, 298): -u*v/w, (74, 325): u**2*v/w**2, (74, 379): u/w,
        (74, 541): -u**2/w**2, (74, 568): u*v*(u*v - w)/w**2, (74,
        595): u**2*v/w, (74, 622): u*v**2*(u*v - w)/w**3, (75, 56): v,
        (75, 74): w, (75, 298): -u*v**2/w, (75, 325): u*v/w, (75,
        379): u*v/w, (75, 541): -u/w, (75, 595): u*v, (76, 76): u,
        (76, 79): 1, (77, 212): -v, (77, 239): 1, (78, 211): w, (78,
        238): -u, (79, 76): -v, (79, 213): -v, (79, 240): 1, (80,
        215): -v, (80, 242): 1, (81, 405): -v, (81, 459): 1, (82,
        406): -v, (82, 460): 1, (83, 407): -v, (83, 461): 1, (84,
        408): -v, (84, 462): 1, (85, 409): -v, (85, 463): 1, (86, 90):
        1, (86, 91): -v, (86, 266): v**2, (86, 267): -v**3, (86, 320):
        -v, (86, 321): v**2, (86, 347): -u*v*(u*v - w)/w**2, (86,
        374): -u*v**2/w, (86, 375): v**2, (86, 401): u*v/w, (86, 402):
        -v, (86, 423): v*(u*v - w)/w, (86, 433): v**2/w, (86, 487):
        -v/w, (86, 590): -u*v**2/w, (86, 591): v**2, (86, 595):
        -v**3/w, (86, 622): v**2/w, (86, 639): -u*v*(u*v - w)/w**2,
        (86, 644): -u**2*v*(u*v - w)/w**2, (87, 92): 1, (87, 93): -v,
        (87, 265): -v*w, (87, 269): -v**3, (87, 319): u*v, (87, 323):
        v**2, (87, 373): u*v, (87, 377): v**2, (87, 400): -u**2*v/w,
        (87, 404): -v, (87, 423): u*v/w, (87, 477): -u/w, (87, 589):
        u*v, (87, 593): v**2, (88, 94): 1, (88, 95): -v, (88, 422):
        v*(u*v - w)/w, (88, 638): -u*v*(u*v - w)/w**2, (89, 29):
        u*v/w, (89, 56): -u/w, (89, 96): 1, (89, 97): -v, (89, 319):
        u*(u*v - w)/w, (89, 346): -u**2*(u*v - w)/w**2, (89, 400):
        -u**2*(u*v - w)/w**2, (89, 407): u**2*v/w, (89, 422): u*v/w,
        (89, 461): -u**2/w, (89, 476): -u/w, (89, 643): -u**3*(u*v -
        w)/w**2, (90, 91): w, (90, 99): v, (90, 427): -v**2*w, (90,
        481): v*w, (91, 86): 1, (91, 91): u, (91, 99): u*v/w, (91,
        109): v/w, (91, 428): v, (91, 482): -u*v/w, (91, 644):
        u*v*(u*v - w)/w**2, (92, 93): w, (92, 406): u*v**2/w, (92,
        460): -u*v/w, (93, 87): 1, (93, 93): u, (93, 99): u/w, (93,
        406): u*v/w, (93, 429): v, (93, 431): -v**2, (93, 460):
        -u**2*v/w**2, (93, 483): -u*v/w, (93, 485): v, (93, 622):
        u**2*v*(u*v - w)/w**3, (93, 645): u*v*(u*v - w)/w**2, (94,
        28): -u**2*v/w, (94, 55): u**2/w, (94, 95): w, (94, 98): v,
        (94, 266): u*v, (94, 320): -u, (94, 347): -u**2*(u*v -
        w)/w**2, (94, 374): -u**2*v/w, (94, 401): u**2/w, (94, 406):
        -u**3*v/w, (94, 427): -u*v**2, (94, 460): u**3/w, (94, 481):
        u*v, (94, 590): -u**2*v/w, (94, 644): -u**3*(u*v - w)/w**2,
        (95, 28): -u**2/w, (95, 55): u**3/w**2, (95, 88): 1, (95, 95):
        u, (95, 98): u*v/w, (95, 266): u, (95, 320): -u**2/w, (95,
        374): -u**2/w, (95, 401): u**3/w**2, (95, 406): -u**3/w, (95,
        427): -u*v, (95, 460): u**4/w**2, (95, 481): u**2*v/w, (95,
        590): -u**2/w, (95, 622): -u**4*(u*v - w)/w**3, (95, 643):
        -u**2*v*(u*v - w)/w**2, (96, 97): w, (96, 103): u**2, (96,
        269): -u*v**2, (96, 323): u*v, (96, 377): u*v, (96, 404): -u,
        (96, 593): u*v, (97, 2): u/w, (97, 83): u**2/w, (97, 89): 1,
        (97, 97): u, (97, 98): u/w, (97, 267): u, (97, 269): -u*v,
        (97, 321): -u**2/w, (97, 323): u**2*v/w, (97, 375): -u**2/w,
        (97, 377): u**2*v/w, (97, 402): u**3/w**2, (97, 404): -u**2/w,
        (97, 591): -u**2/w, (97, 593): u, (98, 24): -u, (98, 105):
        -u**2, (98, 422): -v, (98, 427): u*w, (98, 476): 1, (98, 481):
        -u**2, (98, 643): u**2*(u*v - w)/w, (99, 423): -v, (99, 477):
        1, (100, 101): -v, (100, 102): 1, (100, 407): v*(u*v - w)/w,
        (100, 623): -u*v*(u*v - w)/w**2, (101, 28): u/w, (101, 55):
        -u**2/w**2, (101, 83): u*v/w, (101, 100): 1, (101, 101): u,
        (101, 406): u**2/w, (101, 460): -u**3/w**2, (101, 622):
        u**3*(u*v - w)/w**3, (102, 28): u*v/w, (102, 55): -u/w, (102,
        83): v, (102, 101): w, (102, 406): u**2*v/w, (102, 460):
        -u**2/w, (103, 103): u, (103, 106): 1, (104, 23): 1, (104,
        104): u, (105, 130): 1, (106, 24): 1, (106, 103): -v, (106,
        105): u, (107, 26): 1, (107, 107): u, (108, 432): -v, (108,
        486): 1, (108, 594): v**2, (108, 621): -v, (109, 433): -v,
        (109, 487): 1, (109, 595): v**2, (109, 622): -v, (110, 434):
        -v, (110, 488): 1, (110, 596): v**2, (110, 623): -v, (111,
        435): -v, (111, 489): 1, (111, 597): v**2, (111, 624): -v,
        (112, 436): -v, (112, 490): 1, (112, 598): v**2, (112, 625):
        -v, (113, 28): v**2, (113, 55): -v, (113, 117): 1, (113, 118):
        -v, (113, 293): v**2, (113, 294): -v**3, (113, 347):
        -u*v**2/w, (113, 348): v**2, (113, 433): v**3/w, (113, 450):
        v*(u*v - w)/w, (113, 487): -v**2/w, (113, 536): -u*v**2/w,
        (113, 537): v**2, (113, 563): u*v/w, (113, 564): -v, (113,
        595): -v**4/w, (113, 612): -v**2*(u*v - w)/w, (113, 617):
        v*(u*v - w), (113, 618): -v**2*(u*v - w), (113, 622): v**3/w,
        (113, 644): -u*v*(u*v - w)/w, (114, 119): 1, (114, 120): -v,
        (114, 292): -v*w, (114, 296): -v**3, (114, 346): u*v, (114,
        350): v**2, (114, 450): u*v/w, (114, 504): -u/w, (114, 535):
        u*v, (114, 539): v**2, (114, 562): -u**2*v/w, (114, 566): -v,
        (114, 612): -u*v**2/w, (114, 620): -v**2*(u*v - w), (114,
        639): u*v/w, (115, 121): 1, (115, 122): -v, (115, 449): v*(u*v
        - w)/w, (115, 611): -v**2*(u*v - w)/w, (116, 123): 1, (116,
        124): -v, (116, 407): u*v, (116, 449): u*v/w, (116, 461): -u,
        (116, 503): -u/w, (116, 562): -u**2*(u*v - w)/w**2, (116,
        611): -u*v**2/w, (116, 616): u*(u*v - w), (116, 638): u*v/w,
        (116, 643): -u**2*(u*v - w)/w, (117, 118): w, (117, 126): v,
        (117, 454): -v**2*w, (117, 508): v*w, (117, 616): v**3*w,
        (117, 643): -v**2*w, (118, 1): v, (118, 109): v**2/w, (118,
        113): 1, (118, 118): u, (118, 126): u*v/w, (118, 455): v,
        (118, 509): -u*v/w, (118, 617): -v**2, (118, 644): u*v**2/w,
        (119, 120): w, (119, 433): u*v**2/w, (119, 487): -u*v/w, (119,
        595): -u*v**3/w, (119, 622): u*v**2/w, (120, 114): 1, (120,
        120): u, (120, 126): u/w, (120, 433): u*v/w, (120, 456): v,
        (120, 458): -v**2, (120, 487): -u**2*v/w**2, (120, 510):
        -u*v/w, (120, 512): v, (120, 595): -u*v**2/w, (120, 618):
        -v**2, (120, 620): v**3, (120, 622): u**2*v**2/w**2, (120,
        645): u*v**2/w, (120, 647): -v**2, (121, 122): w, (121, 125):
        v, (121, 293): u*v, (121, 347): -u**2*v/w, (121, 406):
        -u**2*v, (121, 454): -u*v**2, (121, 460): u**2, (121, 508):
        u*v, (121, 536): -u**2*v/w, (121, 563): u**2/w, (121, 616):
        u*v**3, (121, 617): u*(u*v - w), (121, 643): -u*v**2, (121,
        644): -u**2*(u*v - w)/w, (122, 115): 1, (122, 122): u, (122,
        125): u*v/w, (122, 293): u, (122, 347): -u**2/w, (122, 406):
        -u**2, (122, 454): -u*v, (122, 460): u**3/w, (122, 508):
        u**2*v/w, (122, 536): -u**2/w, (122, 563): u**3/w**2, (122,
        616): u*v**2, (122, 622): -u**3*(u*v - w)/w**2, (122, 643):
        -u**2*v**2/w, (123, 124): w, (123, 130): u**2, (123, 296):
        -u*v**2, (123, 350): u*v, (123, 539): u*v, (123, 566): -u,
        (123, 620): -u*v*(u*v - w), (124, 83): u, (124, 116): 1, (124,
        124): u, (124, 125): u/w, (124, 294): u, (124, 296): -u*v,
        (124, 348): -u**2/w, (124, 350): u**2*v/w, (124, 377):
        u*v*(u*v - w)/w, (124, 537): -u**2/w, (124, 539): u, (124,
        564): u**3/w**2, (124, 566): -u**2/w, (125, 105): -u*w, (125,
        449): -v, (125, 454): u*w, (125, 503): 1, (125, 508): -u**2,
        (125, 611): v**2, (125, 616): -u*v*w, (125, 638): -v, (125,
        643): u**2*v, (126, 450): -v, (126, 504): 1, (126, 612): v**2,
        (126, 639): -v, (127, 128): -v, (127, 129): 1, (127, 434):
        v*(u*v - w)/w, (127, 596): -v**2*(u*v - w)/w, (128, 110):
        u*v/w, (128, 127): 1, (128, 128): u, (128, 406): u, (128,
        460): -u**2/w, (128, 622): u**2*(u*v - w)/w**2, (129, 110): v,
        (129, 128): w, (129, 406): u*v, (129, 460): -u, (130, 130): u,
        (130, 133): 1, (131, 104): w, (132, 22): w, (132, 130): v,
        (133, 105): w, (133, 130): -v, (134, 107): w, (135, 243): -v,
        (135, 270): 1, (136, 244): -v, (136, 271): 1, (137, 245): -v,
        (137, 272): 1, (138, 246): -v, (138, 273): 1, (139, 247): -v,
        (139, 274): 1, (140, 144): 1, (140, 145): -v, (140, 261):
        v*(u*v - w)/w, (140, 266): -u*v, (140, 267): u*v**2, (140,
        293): u**2*v/w, (140, 347): u*v**2/w**2, (140, 352): v**2/w,
        (140, 374): u**2*v/w, (140, 375): -u*v, (140, 428): -v, (140,
        429): v**2, (140, 455): u*v/w, (140, 456): -v, (140, 482):
        u*v/w, (140, 514): -v/w, (140, 568): v**2/w, (140, 585):
        u*v/w, (140, 590): u**2*v/w, (140, 595): u*v**2/w, (140, 612):
        u**2*v/w, (140, 617): u*v*(u**2 - v)/w, (140, 618): v**2,
        (140, 639): u*v**2/w**2, (140, 644): u**2*v**2/w**2, (141,
        146): 1, (141, 147): -v, (141, 261): u*v/w, (141, 269):
        u*v**2, (141, 288): -u/w, (141, 319): -v, (141, 377): -u*v,
        (141, 400): u*v/w, (141, 431): v**2, (141, 458): -v, (141,
        616): u*v, (141, 620): v**2, (142, 148): 1, (142, 149): -v,
        (142, 260): v*(u*v - w)/w, (142, 584): u*v/w, (142, 611):
        u**2*v/w, (142, 638): u*v**2/w**2, (143, 2): -u/w, (143, 29):
        -u**2/w, (143, 150): 1, (143, 151): -v, (143, 245): u**2*v/w,
        (143, 260): u*v/w, (143, 265): -u**2, (143, 272): -u**2/w,
        (143, 287): -u/w, (143, 292): u**3/w, (143, 319): -u*v/w,
        (143, 346): u**2*v/w**2, (143, 373): u**3/w, (143, 400):
        u**2*v/w**2, (143, 427): -u, (143, 454): u**2/w, (143, 481):
        u**2/w, (143, 589): u**3/w, (143, 616): u**4/w, (143, 643):
        u**3*v/w**2, (144, 145): w, (144, 153): v, (144, 265):
        -v**2*w, (144, 292): v*w, (145, 140): 1, (145, 145): u, (145,
        153): u*v/w, (145, 163): v/w, (145, 266): v, (145, 293):
        -u*v/w, (145, 590): -u*v/w, (145, 617): -u**2*v/w, (145, 644):
        -u*v**2/w**2, (146, 147): w, (146, 244): u*v**2/w, (146, 271):
        -u*v/w, (147, 141): 1, (147, 147): u, (147, 153): u/w, (147,
        244): u*v/w, (147, 267): v, (147, 269): -v**2, (147, 271):
        -u**2*v/w**2, (147, 294): -u*v/w, (147, 296): v, (147, 568):
        -u**2*v/w**2, (147, 591): -u*v/w, (147, 595): -u**3*v/w**2,
        (147, 618): -u**2*v/w, (147, 622): -u**2*v**2/w**3, (147,
        645): -u*v**2/w**2, (148, 1): u**2/w, (148, 28): u**3/w, (148,
        149): w, (148, 152): v, (148, 244): -u**3*v/w, (148, 265):
        -u*v**2, (148, 266): -u**2, (148, 271): u**3/w, (148, 292):
        u*v, (148, 293): u**3/w, (148, 347): u**2*v/w**2, (148, 374):
        u**3/w, (148, 428): -u, (148, 455): u**2/w, (148, 482):
        u**2/w, (148, 590): u**3/w, (148, 617): u**2*(u**2 - v)/w,
        (148, 644): u**3*v/w**2, (149, 55): -u**2/w**2, (149, 142): 1,
        (149, 149): u, (149, 152): u*v/w, (149, 244): -u**3/w, (149,
        265): -u*v, (149, 271): u**4/w**2, (149, 292): u**2*v/w, (149,
        320): u/w, (149, 401): -u**2/w**2, (149, 568): u**4/w**2,
        (149, 589): u**2*v/w, (149, 595): u**5/w**2, (149, 616):
        u**3*v/w, (149, 617): -u**2/w, (149, 622): u**4*v/w**3, (149,
        643): u**2*v**2/w**2, (150, 151): w, (150, 157): u**2, (150,
        269): u**2*v, (150, 377): -u**2, (150, 431): u*v, (150, 458):
        -u, (150, 620): u*v, (151, 29): u/w, (151, 137): u**2/w, (151,
        143): 1, (151, 151): u, (151, 152): u/w, (151, 321): u/w,
        (151, 323): -u*v/w, (151, 377): -u**3/w, (151, 402):
        -u**2/w**2, (151, 458): -u**2/w, (151, 618): -u**2/w, (151,
        620): u, (152, 51): -u, (152, 159): -u**2, (152, 260): -v,
        (152, 265): u*w, (152, 287): 1, (152, 292): -u**2, (152, 589):
        -u**2, (152, 616): -u**3, (152, 643): -u**2*v/w, (153, 261):
        -v, (153, 288): 1, (154, 155): -v, (154, 156): 1, (154, 245):
        v*(u*v - w)/w, (154, 569): u*v/w, (154, 596): u**2*v/w, (154,
        623): u*v**2/w**2, (155, 55): u/w**2, (155, 137): u*v/w, (155,
        154): 1, (155, 155): u, (155, 244): u**2/w, (155, 271):
        -u**3/w**2, (155, 568): -u**3/w**2, (155, 595): -u**4/w**2,
        (155, 622): -u**3*v/w**3, (156, 1): -u/w, (156, 28): -u**2/w,
        (156, 137): v, (156, 155): w, (156, 244): u**2*v/w, (156,
        271): -u**2/w, (157, 157): u, (157, 160): 1, (158, 50): 1,
        (158, 158): u, (159, 184): 1, (160, 51): 1, (160, 157): -v,
        (160, 159): u, (161, 53): 1, (161, 161): u, (162, 351): -v,
        (162, 513): 1, (162, 567): -v, (162, 594): -u*v, (163, 352):
        -v, (163, 514): 1, (163, 568): -v, (163, 595): -u*v, (164,
        353): -v, (164, 515): 1, (164, 569): -v, (164, 596): -u*v,
        (165, 354): -v, (165, 516): 1, (165, 570): -v, (165, 597):
        -u*v, (166, 355): -v, (166, 517): 1, (166, 571): -v, (166,
        598): -u*v, (167, 1): -v, (167, 28): -u*v, (167, 171): 1,
        (167, 172): -v, (167, 294): u*v**2, (167, 347): v**2/w, (167,
        352): v**3/w, (167, 369): v*(u*v - w)/w, (167, 483): v**2,
        (167, 509): u*v/w, (167, 510): -v, (167, 514): -v**2/w, (167,
        536): u**2*v/w, (167, 537): -u*v, (167, 568): v**3/w, (167,
        585): u*v**2/w, (167, 591): u*v**2, (167, 595): u*v**3/w,
        (167, 612): u**2*v**2/w, (167, 618): u**2*v**2, (167, 639):
        v**2/w, (167, 644): v*(u*v - w)/w, (167, 645): v**2, (168,
        173): 1, (168, 174): -v, (168, 296): u*v**2, (168, 346): -v,
        (168, 369): u*v/w, (168, 485): v**2, (168, 512): -v, (168,
        531): -u/w, (168, 539): -u*v, (168, 562): u*v/w, (168, 585):
        u*v/w, (168, 593): u*v**2, (168, 612): u**2*v/w, (168, 620):
        u**2*v**2, (168, 647): v**2, (169, 175): 1, (169, 176): -v,
        (169, 368): v*(u*v - w)/w, (169, 584): u*v**2/w, (169, 611):
        u**2*v**2/w, (169, 638): v**2/w, (170, 177): 1, (170, 178):
        -v, (170, 245): u*v, (170, 272): -u, (170, 368): u*v/w, (170,
        508): u**2/w, (170, 530): -u/w, (170, 535): u**3/w, (170,
        562): u**2*v/w**2, (170, 584): u*v/w, (170, 611): u**2*v/w,
        (170, 643): u*(u*v - w)/w, (171, 172): w, (171, 180): v, (171,
        373): -v**2*w, (171, 535): v*w, (171, 589): -v**2*w, (171,
        616): -u*v**2*w, (172, 28): v, (172, 163): v**2/w, (172, 167):
        1, (172, 172): u, (172, 180): u*v/w, (172, 374): v, (172,
        536): -u*v/w, (172, 644): -v**2/w, (173, 174): w, (173, 352):
        u*v**2/w, (173, 514): -u*v/w, (173, 568): u*v**2/w, (173,
        595): u**2*v**2/w, (174, 168): 1, (174, 174): u, (174, 180):
        u/w, (174, 352): u*v/w, (174, 375): v, (174, 377): -v**2,
        (174, 514): -u**2*v/w**2, (174, 537): -u*v/w, (174, 539): v,
        (174, 593): -v**2, (174, 620): -u*v**2, (174, 622):
        -u*v**2/w**2, (174, 645): -v**2/w, (175, 176): w, (175, 179):
        v, (175, 244): -u**2*v, (175, 271): u**2, (175, 347): u*v/w,
        (175, 373): -u*v**2, (175, 509): u**2/w, (175, 535): u*v,
        (175, 536): u**3/w, (175, 589): -u*v**2, (175, 616):
        -u**2*v**2, (175, 644): u*(u*v - w)/w, (176, 169): 1, (176,
        176): u, (176, 179): u*v/w, (176, 244): -u**2, (176, 271):
        u**3/w, (176, 347): u/w, (176, 373): -u*v, (176, 535):
        u**2*v/w, (176, 563): -u**2/w**2, (176, 568): u**3/w, (176,
        595): u**4/w, (176, 622): u**3*v/w**2, (176, 643): u*v**2/w,
        (177, 178): w, (177, 184): u**2, (177, 296): u**2*v, (177,
        485): u*v, (177, 512): -u, (177, 539): -u**2, (177, 593):
        u**2*v, (177, 620): u**3*v, (177, 647): u*v, (178, 137): u,
        (178, 170): 1, (178, 178): u, (178, 179): u/w, (178, 348):
        u/w, (178, 350): -u*v/w, (178, 377): -u**3*v/w, (178, 404):
        -u*v/w, (178, 458): -u**2*v/w, (178, 564): -u**2/w**2, (178,
        566): u/w, (179, 159): -u*w, (179, 368): -v, (179, 373): u*w,
        (179, 530): 1, (179, 535): -u**2, (179, 584): -v, (179, 611):
        -u*v, (179, 643): -u*v, (180, 369): -v, (180, 531): 1, (180,
        585): -v, (180, 612): -u*v, (181, 182): -v, (181, 183): 1,
        (181, 353): v*(u*v - w)/w, (181, 569): u*v**2/w, (181, 596):
        u**2*v**2/w, (181, 623): v**2/w, (182, 164): u*v/w, (182,
        181): 1, (182, 182): u, (182, 244): u, (182, 271): -u**2/w,
        (182, 568): -u**2/w, (182, 595): -u**3/w, (182, 622):
        -u**2*v/w**2, (183, 164): v, (183, 182): w, (183, 244): u*v,
        (183, 271): -u, (184, 184): u, (184, 187): 1, (185, 158): w,
        (186, 49): w, (186, 184): v, (187, 159): w, (187, 184): -v,
        (188, 161): w, (189, 297): -v, (189, 324): 1, (190, 298): -v,
        (190, 325): 1, (191, 299): -v, (191, 326): 1, (192, 300): -v,
        (192, 327): 1, (193, 301): -v, (193, 328): 1, (194, 198): 1,
        (194, 199): -v, (194, 266): -v*w, (194, 267): v**2*w, (194,
        293): u*v, (194, 315): v*(u*v - w)/w, (194, 347): u*v**3/w**2,
        (194, 374): u*v, (194, 375): -v*w, (194, 379): v**2/w, (194,
        482): u*v**2/w, (194, 541): -v/w, (194, 585): u*v**2/w, (194,
        590): u**2*v**2/w, (194, 595): v**2, (194, 612): u*v, (194,
        617): u**2*v, (194, 639): u*v**3/w**2, (194, 644): u*v**2*(u*v
        - w)/w**2, (194, 645): v**2, (195, 200): 1, (195, 201): -v,
        (195, 269): v**2*w, (195, 315): u*v/w, (195, 319): -v**2,
        (195, 342): -u/w, (195, 377): -v*w, (195, 400): u*v**2/w,
        (195, 427): -v*w, (195, 454): u*v, (195, 643): u*v, (195,
        647): v**2, (196, 202): 1, (196, 203): -v, (196, 314): v*(u*v
        - w)/w, (196, 584): u*v**2/w, (196, 611): u*v, (196, 638):
        u*v**3/w**2, (197, 29): -u, (197, 204): 1, (197, 205): -v,
        (197, 265): -u*w, (197, 292): u**2, (197, 299): u**2*v/w,
        (197, 314): u*v/w, (197, 319): -u*v**2/w, (197, 326): -u**2/w,
        (197, 341): -u/w, (197, 346): u**2*v**2/w**2, (197, 373):
        u**2, (197, 400): u**2*v**2/w**2, (197, 427): -u*v, (197,
        454): u**2*v/w, (197, 481): u**2*v/w, (197, 589): u**3*v/w,
        (197, 616): u**3, (197, 643): u**3*v**2/w**2, (198, 199): w,
        (198, 207): v, (198, 319): -v**2*w, (198, 346): v*w, (199,
        194): 1, (199, 199): u, (199, 207): u*v/w, (199, 217): v/w,
        (199, 320): v, (199, 347): -u*v/w, (199, 590): -u*v**2/w,
        (199, 617): -u*v, (199, 644): -u*v**3/w**2, (200, 201): w,
        (200, 298): u*v**2/w, (200, 325): -u*v/w, (201, 195): 1, (201,
        201): u, (201, 207): u/w, (201, 298): u*v/w, (201, 321): v,
        (201, 323): -v**2, (201, 325): -u**2*v/w**2, (201, 348):
        -u*v/w, (201, 350): v, (201, 568): -u**2*v**2/w**2, (201,
        591): -u*v**2/w, (201, 595): -u**2*v/w, (201, 618): -u*v,
        (201, 622): -u**2*v**3/w**3, (201, 645): -u*v**3/w**2, (202,
        28): u**2, (202, 203): w, (202, 206): v, (202, 266): -u*w,
        (202, 293): u**2, (202, 298): -u**3*v/w, (202, 319): -u*v**2,
        (202, 325): u**3/w, (202, 346): u*v, (202, 347):
        u**2*v**2/w**2, (202, 374): u**2, (202, 482): u**2*v/w, (202,
        590): u**3*v/w, (202, 617): u**3, (202, 644): u**2*v*(u*v -
        w)/w**2, (203, 1): -u**2/w, (203, 55): -u**2*v/w**2, (203,
        196): 1, (203, 203): u, (203, 206): u*v/w, (203, 298):
        -u**3/w, (203, 319): -u*v, (203, 320): u*v/w, (203, 325):
        u**4/w**2, (203, 346): u**2*v/w, (203, 401): -u**2*v/w**2,
        (203, 428): u, (203, 455): -u**2/w, (203, 568): u**4*v/w**2,
        (203, 589): u**2*v**2/w, (203, 595): u**4/w, (203, 616):
        u**2*v, (203, 622): u**4*v**2/w**3, (203, 643):
        u**2*v**3/w**2, (203, 644): -u**2/w, (204, 205): w, (204,
        211): u**2, (204, 269): u*v*w, (204, 377): -u*w, (204, 647):
        u*v, (205, 56): u/w, (205, 191): u**2/w, (205, 197): 1, (205,
        205): u, (205, 206): u/w, (205, 321): u*v/w, (205, 323):
        -u*v**2/w, (205, 377): -u**2, (205, 402): -u**2*v/w**2, (205,
        429): u, (205, 431): -u*v, (205, 456): -u**2/w, (205, 645):
        -u**2/w, (205, 647): u, (206, 78): -u, (206, 213): -u**2,
        (206, 314): -v, (206, 319): u*w, (206, 341): 1, (206, 346):
        -u**2, (206, 589): -u**2*v, (206, 616): -u**2*w, (206, 643):
        -u**2*v**2/w, (207, 315): -v, (207, 342): 1, (208, 209): -v,
        (208, 210): 1, (208, 299): v*(u*v - w)/w, (208, 569):
        u*v**2/w, (208, 596): u*v, (208, 623): u*v**3/w**2, (209, 1):
        u/w, (209, 55): u*v/w**2, (209, 191): u*v/w, (209, 208): 1,
        (209, 209): u, (209, 298): u**2/w, (209, 325): -u**3/w**2,
        (209, 568): -u**3*v/w**2, (209, 595): -u**3/w, (209, 622):
        -u**3*v**2/w**3, (210, 28): -u, (210, 191): v, (210, 209): w,
        (210, 298): u**2*v/w, (210, 325): -u**2/w, (211, 211): u,
        (211, 214): 1, (212, 77): 1, (212, 212): u, (213, 238): 1,
        (214, 78): 1, (214, 211): -v, (214, 213): u, (215, 80): 1,
        (215, 215): u, (216, 378): -v, (216, 540): 1, (216, 594):
        -v*w, (217, 379): -v, (217, 541): 1, (217, 595): -v*w, (218,
        380): -v, (218, 542): 1, (218, 596): -v*w, (219, 381): -v,
        (219, 543): 1, (219, 597): -v*w, (220, 382): -v, (220, 544):
        1, (220, 598): -v*w, (221, 28): -v*w, (221, 225): 1, (221,
        226): -v, (221, 294): v**2*w, (221, 347): v**3/w, (221, 379):
        v**3/w, (221, 396): v*(u*v - w)/w, (221, 482): v**2, (221,
        536): u*v, (221, 537): -v*w, (221, 541): -v**2/w, (221, 585):
        v**2, (221, 590): v*(u*v - w), (221, 591): v**2*w, (221, 595):
        v**3, (221, 612): u*v**2, (221, 618): u*v**2*w, (221, 639):
        v**3/w, (221, 644): v**2*(u*v - w)/w, (221, 645): v**3, (222,
        227): 1, (222, 228): -v, (222, 296): v**2*w, (222, 346):
        -v**2, (222, 396): u*v/w, (222, 481): -v*w, (222, 508): u*v,
        (222, 539): -v*w, (222, 558): -u/w, (222, 562): u*v**2/w,
        (222, 593): v**2*w, (222, 612): u*v, (222, 620): u*v**2*w,
        (222, 647): v**3, (223, 229): 1, (223, 230): -v, (223, 395):
        v*(u*v - w)/w, (223, 584): v**2, (223, 611): u*v**2, (223,
        638): v**3/w, (224, 231): 1, (224, 232): -v, (224, 299): u*v,
        (224, 326): -u, (224, 395): u*v/w, (224, 508): u**2*v/w, (224,
        535): u**2, (224, 557): -u/w, (224, 562): u**2*v**2/w**2,
        (224, 589): u*(u*v - w), (224, 611): u*v, (224, 643): u*v*(u*v
        - w)/w, (225, 226): w, (225, 234): v, (225, 400): -v**2*w,
        (225, 562): v*w, (225, 616): -v**2*w**2, (226, 55): v, (226,
        217): v**2/w, (226, 221): 1, (226, 226): u, (226, 234): u*v/w,
        (226, 401): v, (226, 563): -u*v/w, (226, 590): -v**2, (226,
        644): -v**3/w, (227, 228): w, (227, 379): u*v**2/w, (227,
        541): -u*v/w, (227, 595): u*v**2, (228, 222): 1, (228, 228):
        u, (228, 234): u/w, (228, 379): u*v/w, (228, 402): v, (228,
        404): -v**2, (228, 541): -u**2*v/w**2, (228, 564): -u*v/w,
        (228, 566): v, (228, 568): -u*v**2/w, (228, 591): -v**2, (228,
        620): -v**2*w, (228, 622): -u*v**3/w**2, (228, 645): -v**3/w,
        (229, 230): w, (229, 233): v, (229, 298): -u**2*v, (229, 325):
        u**2, (229, 347): u*v**2/w, (229, 400): -u*v**2, (229, 482):
        u*v, (229, 536): u**2, (229, 562): u*v, (229, 590): u*(u*v -
        w), (229, 616): -u*v**2*w, (229, 644): u*v*(u*v - w)/w, (230,
        223): 1, (230, 230): u, (230, 233): u*v/w, (230, 298): -u**2,
        (230, 325): u**3/w, (230, 347): u*v/w, (230, 400): -u*v, (230,
        482): u, (230, 509): -u**2/w, (230, 562): u**2*v/w, (230,
        563): -u**2*v/w**2, (230, 568): u**3*v/w, (230, 589): u*v**2,
        (230, 595): u**3, (230, 622): u**3*v**2/w**2, (230, 643):
        u*v**3/w, (231, 232): w, (231, 238): u**2, (231, 296): u*v*w,
        (231, 539): -u*w, (231, 593): u*v*w, (231, 620): u**2*v*w,
        (231, 647): u*v**2, (232, 191): u, (232, 224): 1, (232, 232):
        u, (232, 233): u/w, (232, 348): u*v/w, (232, 350): -u*v**2/w,
        (232, 377): -u**2*v, (232, 404): -u*v**2/w, (232, 458): -u*v,
        (232, 483): u, (232, 485): -u*v, (232, 510): -u**2/w, (232,
        512): u, (232, 564): -u**2*v/w**2, (232, 566): u*v/w, (233,
        213): -u*w, (233, 395): -v, (233, 400): u*w, (233, 557): 1,
        (233, 562): -u**2, (233, 589): -u*v*w, (233, 611): -v*w, (233,
        643): -u*v**2, (234, 396): -v, (234, 558): 1, (234, 612):
        -v*w, (235, 236): -v, (235, 237): 1, (235, 380): v*(u*v -
        w)/w, (235, 569): v**2, (235, 596): u*v**2, (235, 623):
        v**3/w, (236, 218): u*v/w, (236, 235): 1, (236, 236): u, (236,
        298): u, (236, 325): -u**2/w, (236, 568): -u**2*v/w, (236,
        595): -u**2, (236, 622): -u**2*v**2/w**2, (237, 218): v, (237,
        236): w, (237, 298): u*v, (237, 325): -u, (238, 238): u, (238,
        241): 1, (239, 212): w, (240, 76): w, (240, 238): v, (241,
        213): w, (241, 238): -v, (242, 215): w, (243, 135): 1, (243,
        243): u, (243, 621): u/w, (244, 136): 1, (244, 244): u, (244,
        622): u/w, (245, 137): 1, (245, 245): u, (245, 623): u/w,
        (246, 138): 1, (246, 246): u, (246, 624): u/w, (247, 139): 1,
        (247, 247): u, (247, 625): u/w, (248, 51): -v, (248, 153):
        -u*v/w, (248, 159): -u*v, (248, 190): -v/w, (248, 252): 1,
        (248, 253): -v, (248, 261): -u**2*v/w, (248, 267): -u**2*v,
        (248, 288): -v/w, (248, 293): -u*v/w, (248, 298): -u*v/w,
        (248, 348): -u*v/w, (248, 374): -u*v/w, (248, 429): -u*v,
        (248, 455): -v/w, (248, 568): -u*v/w, (248, 612): -u*v/w,
        (248, 617): -v*(u**2 - v)/w, (248, 622): -u*v**2/w**2, (248,
        639): -u**2*v/w**2, (248, 645): -u**2*v/w, (249, 53): -v,
        (249, 153): -u/w, (249, 161): -u*v, (249, 254): 1, (249, 255):
        -v, (249, 261): -u**2/w, (249, 269): -u**2*v, (249, 350):
        -u*v/w, (249, 431): -u*v, (249, 616): -v, (249, 639):
        -u**2/w**2, (249, 647): -u**2*v/w, (250, 152): -u*v/w, (250,
        256): 1, (250, 257): -v, (250, 260): -u**2*v/w, (250, 287):
        -v/w, (250, 611): -u*v/w, (250, 638): -u**2*v/w**2, (251, 83):
        -u/w, (251, 137): -u**2/w, (251, 152): -u/w, (251, 245):
        -u**3/w, (251, 258): 1, (251, 259): -v, (251, 260): -u**2/w,
        (251, 292): -u**2/w, (251, 373): -u**2/w, (251, 407): -u**2/w,
        (251, 454): -u/w, (251, 596): -u**2/w, (251, 616): -u**3/w,
        (251, 638): -u**2/w**2, (252, 157): v*w, (252, 253): w, (252,
        261): v, (252, 265): u*v*w, (252, 643): u*v, (253, 248): 1,
        (253, 253): u, (253, 261): u*v/w, (253, 293): v/w, (253, 298):
        v/w, (253, 617): u*v/w, (254, 136): -u*v/w, (254, 244):
        -u**2*v/w, (254, 255): w, (254, 622): -u**2*v/w**2, (255,
        161): v, (255, 249): 1, (255, 255): u, (255, 261): u/w, (255,
        269): u*v, (255, 271): u*v/w**2, (255, 294): v/w, (255, 595):
        u**2*v/w**2, (255, 618): u*v/w, (255, 647): u*v/w, (256, 82):
        u**2/w, (256, 136): u**3/w, (256, 157): u*v, (256, 244):
        u**4/w, (256, 257): w, (256, 260): v, (256, 265): u**2*v,
        (256, 293): -u**2/w, (256, 374): -u**2/w, (256, 406): u**3/w,
        (256, 455): -u/w, (256, 595): u**3/w, (256, 617): -u*(u**2 -
        v)/w, (256, 643): u**2*v/w, (257, 250): 1, (257, 257): u,
        (257, 260): u*v/w, (257, 271): -u**3/w**2, (257, 292): -u*v/w,
        (257, 460): -u**2/w**2, (257, 568): -u**3/w**2, (257, 595):
        -u**4/w**2, (257, 616): -u**2*v/w, (257, 617): u/w, (258, 53):
        -u, (258, 161): -u**2, (258, 259): w, (258, 265): u**2, (258,
        269): -u**3, (258, 350): -u**2/w, (258, 431): -u**2, (258,
        647): -u**3/w, (259, 188): u/w, (259, 245): u**2/w, (259,
        251): 1, (259, 259): u, (259, 260): u/w, (259, 323): u**2/w,
        (259, 377): u**2/w, (259, 407): u/w, (259, 618): u/w, (260,
        152): 1, (260, 260): u, (260, 267): -u**2, (260, 292): u,
        (260, 429): -u, (260, 616): u**2, (260, 638): u/w, (261, 153):
        1, (261, 261): u, (261, 639): u/w, (262, 137): -u*v/w, (262,
        245): -u**2*v/w, (262, 263): -v, (262, 264): 1, (262, 272):
        -v/w, (262, 596): -u*v/w, (262, 623): -u**2*v/w**2, (263,
        245): u*v/w, (263, 262): 1, (263, 263): u, (263, 271):
        u**2/w**2, (263, 460): u/w**2, (263, 568): u**2/w**2, (263,
        595): u**3/w**2, (264, 82): -u/w, (264, 136): -u**2/w, (264,
        244): -u**3/w, (264, 245): v, (264, 263): w, (264, 406):
        -u**2/w, (264, 595): -u**2/w, (265, 265): u, (265, 268): 1,
        (266, 266): u, (266, 428): 1, (267, 319): 1, (268, 265): -v,
        (268, 267): u, (268, 429): 1, (269, 269): u, (269, 431): 1,
        (270, 243): w, (270, 567): -u, (270, 594): -u**2, (271, 244):
        w, (271, 568): -u, (271, 595): -u**2, (272, 245): w, (272,
        569): -u, (272, 596): -u**2, (273, 246): w, (273, 570): -u,
        (273, 597): -u**2, (274, 247): w, (274, 571): -u, (274, 598):
        -u**2, (275, 50): -v, (275, 109): u*v/w, (275, 153): -v, (275,
        158): -u*v, (275, 163): u**2*v/w, (275, 261): -u*v, (275,
        267): -u*v*w, (275, 279): 1, (275, 280): -v, (275, 288):
        -v**2/w, (275, 293): -u*v**2/w, (275, 294): u**2*v, (275,
        352): u**3*v/w, (275, 374): -u*v**2/w, (275, 429): -v*w, (275,
        433): u**2*v/w, (275, 455): -v**2/w, (275, 483): u*v, (275,
        568): v*(u*v - w)/w, (275, 585): u**2*v/w, (275, 591): u**2*v,
        (275, 595): u*v*(u*v - w)/w, (275, 612): u*v*(u**2 - v)/w,
        (275, 617): -v**2*(u**2 - v)/w, (275, 618): u**3*v, (276,
        184): -v, (276, 261): -u, (276, 269): -u*v*w, (276, 281): 1,
        (276, 282): -v, (276, 296): u**2*v, (276, 431): -v*w, (276,
        485): u*v, (276, 585): u**2/w, (276, 593): u**2*v, (276, 612):
        u**3/w, (276, 616): -v**2, (276, 620): u**3*v, (277, 152): -v,
        (277, 260): -u*v, (277, 283): 1, (277, 284): -v, (277, 287):
        -v**2/w, (277, 584): u**2*v/w, (277, 611): u*v*(u**2 - v)/w,
        (278, 49): -u, (278, 110): -u/w, (278, 157): -u**2, (278,
        164): -u**2/w, (278, 184): -u*v/w, (278, 260): -u, (278, 285):
        1, (278, 286): -v, (278, 292): -u**2*v/w, (278, 353): -u**3/w,
        (278, 373): -u**2*v/w, (278, 434): -u**2/w, (278, 454):
        -u*v/w, (278, 584): u**2/w, (278, 611): u**3/w, (278, 616):
        -u**3*v/w, (279, 265): v*w**2, (279, 280): w, (279, 288): v,
        (279, 589): -u*v*w, (279, 616): -u**2*v*w, (280, 158): v,
        (280, 275): 1, (280, 280): u, (280, 288): u*v/w, (280, 293):
        v**2/w, (280, 352): -u**2*v/w, (280, 433): -u*v/w, (280, 595):
        v, (280, 617): u*v**2/w, (281, 244): -u*v, (281, 282): w,
        (281, 568): u**2*v/w, (281, 595): u**3*v/w, (282, 136): u*v/w,
        (282, 159): v, (282, 269): v*w, (282, 271): u*v**2/w**2, (282,
        276): 1, (282, 282): u, (282, 288): u/w, (282, 294): v**2/w,
        (282, 593): -u*v, (282, 595): u**2*v**2/w**2, (282, 618):
        u*v**2/w, (282, 620): -u**2*v, (283, 50): -u, (283, 109):
        u**2/w, (283, 158): -u**2, (283, 163): u**3/w, (283, 265):
        u*v*w, (283, 284): w, (283, 287): v, (283, 293): -u**2*v/w,
        (283, 352): u**4/w, (283, 374): -u**2*v/w, (283, 433): u**3/w,
        (283, 455): -u*v/w, (283, 589): -u**2*v, (283, 616): -u**3*v,
        (283, 617): -u*v*(u**2 - v)/w, (284, 157): -u*v, (284, 185):
        u/w, (284, 277): 1, (284, 284): u, (284, 287): u*v/w, (284,
        292): -u*v**2/w, (284, 487): -u**2/w**2, (284, 514):
        -u**3/w**2, (284, 616): -u**2*v**2/w, (284, 617): u*v/w, (284,
        622): u**2*v/w**2, (285, 269): -u**2*w, (285, 286): w, (285,
        292): u**2, (285, 296): u**3, (285, 431): -u*w, (285, 485):
        u**2, (285, 593): u**3, (285, 620): u**4, (286, 186): u/w,
        (286, 278): 1, (286, 286): u, (286, 287): u/w, (286, 323): u,
        (286, 353): u**2/w, (286, 377): -u**2*(u**2 - v)/w, (286,
        404): -u**2/w, (286, 434): u/w, (286, 458): -u**3/w, (286,
        596): -u*v/w, (286, 618): u*v/w, (287, 157): u*w, (287, 260):
        w, (287, 292): u*v, (287, 375): -u**2, (287, 456): -u, (287,
        584): -u, (287, 611): -u**2, (287, 616): u**2*v, (287, 618):
        u*v, (288, 261): w, (288, 585): -u, (288, 612): -u**2, (289,
        137): -v, (289, 245): -u*v, (289, 272): -v**2/w, (289, 290):
        -v, (289, 291): 1, (289, 569): u**2*v/w, (289, 596): u*v*(u**2
        - v)/w, (290, 272): u*v/w, (290, 289): 1, (290, 290): u, (290,
        487): u/w**2, (290, 514): u**2/w**2, (290, 622): -u*v/w**2,
        (291, 109): -u/w, (291, 163): -u**2/w, (291, 272): v, (291,
        290): w, (291, 352): -u**3/w, (291, 433): -u**2/w, (292, 292):
        u, (292, 295): 1, (293, 374): u, (293, 455): 1, (293, 617):
        -v, (294, 373): -u**2, (294, 454): -u, (294, 616): w, (295,
        292): -v, (295, 375): u, (295, 456): 1, (295, 618): -v, (296,
        377): u, (296, 458): 1, (296, 620): -v, (297, 189): 1, (297,
        297): u, (297, 567): u, (297, 621): u*v/w, (298, 190): 1,
        (298, 298): u, (298, 568): u, (298, 622): u*v/w, (299, 191):
        1, (299, 299): u, (299, 569): u, (299, 623): u*v/w, (300,
        192): 1, (300, 300): u, (300, 570): u, (300, 624): u*v/w,
        (301, 193): 1, (301, 301): u, (301, 571): u, (301, 625):
        u*v/w, (302, 78): -v, (302, 82): -v, (302, 190): -v**2/w,
        (302, 207): -u*v/w, (302, 213): -u*v, (302, 267): -u*v*w,
        (302, 298): -u*v**2/w, (302, 306): 1, (302, 307): -v, (302,
        315): -u**2*v/w, (302, 342): -v/w, (302, 347): -u*v/w, (302,
        348): -u*v**2/w, (302, 374): -v, (302, 406): -u*v, (302, 483):
        -u*v, (302, 568): -u*v**2/w, (302, 585): -u**2*v/w, (302,
        591): -u**2*v, (302, 595): -u*v, (302, 622): u*v*(u*w -
        v**2)/w**2, (302, 639): -u*v*(u*v + w)/w**2, (302, 644):
        -v*(u**2 - v)/w, (302, 645): -u**2*v**2/w, (303, 80): -v,
        (303, 207): -u/w, (303, 215): -u*v, (303, 269): -u*v*w, (303,
        308): 1, (303, 309): -v, (303, 315): -u**2/w, (303, 350):
        -u*v**2/w, (303, 485): -u*v, (303, 585): -u**2/w, (303, 593):
        -u**2*v, (303, 639): -u**2*v/w**2, (303, 643): -v, (303, 647):
        -u**2*v**2/w, (304, 206): -u*v/w, (304, 310): 1, (304, 311):
        -v, (304, 314): -u**2*v/w, (304, 341): -v/w, (304, 584):
        -u**2*v/w, (304, 638): -u*v*(u*v + w)/w**2, (305, 137): -u,
        (305, 206): -u/w, (305, 245): -u**2, (305, 312): 1, (305,
        313): -v, (305, 314): -u**2/w, (305, 346): -u**2/w, (305,
        373): -u, (305, 584): -u**2/w, (305, 623): -u**2/w, (305,
        638): -u**2*v/w**2, (305, 643): -u**3/w, (306, 211): v*w,
        (306, 307): w, (306, 315): v, (306, 319): u*v*w, (306, 589):
        u*v*w, (306, 643): u*v**2, (307, 298): v**2/w, (307, 302): 1,
        (307, 307): u, (307, 315): u*v/w, (307, 347): v/w, (307, 406):
        v, (307, 644): u*v/w, (308, 190): -u*v/w, (308, 298):
        -u**2*v/w, (308, 309): w, (308, 568): -u**2*v/w, (308, 622):
        -u**2*v**2/w**2, (309, 215): v, (309, 303): 1, (309, 309): u,
        (309, 315): u/w, (309, 323): u*v, (309, 325): u*v/w**2, (309,
        348): v/w, (309, 593): u*v, (309, 622): u**2*v/w**2, (309,
        645): u*v/w, (309, 647): u*v**2/w, (310, 136): u**2, (310,
        211): u*v, (310, 244): u**3, (310, 311): w, (310, 314): v,
        (310, 319): u**2*v, (310, 347): -u**2/w, (310, 374): -u, (310,
        589): u**2*v, (310, 622): u**3/w, (310, 643): u**2*v**2/w,
        (310, 644): -u*(u**2 - v)/w, (311, 271): -u**2/w, (311, 304):
        1, (311, 311): u, (311, 314): u*v/w, (311, 346): -u*v/w, (311,
        595): -u**3/w, (311, 643): -u**2*v/w, (311, 644): u/w, (312,
        80): -u, (312, 215): -u**2, (312, 269): -u**2*w, (312, 313):
        w, (312, 319): u**2, (312, 350): -u**2*v/w, (312, 485): -u**2,
        (312, 593): -u**3, (312, 647): -u**3*v/w, (313, 242): u/w,
        (313, 245): u, (313, 305): 1, (313, 313): u, (313, 314): u/w,
        (313, 323): u**2*v/w, (313, 404): u**2/w, (313, 431): u**2,
        (313, 645): u/w, (314, 206): 1, (314, 267): -u*w, (314, 314):
        u, (314, 346): u, (314, 584): u, (314, 638): u*v/w, (314,
        643): u**2, (315, 207): 1, (315, 315): u, (315, 585): u, (315,
        639): u*v/w, (316, 191): -u*v/w, (316, 299): -u**2*v/w, (316,
        317): -v, (316, 318): 1, (316, 326): -v/w, (316, 569):
        -u**2*v/w, (316, 623): -u*v*(u*v + w)/w**2, (317, 271): u/w,
        (317, 299): u*v/w, (317, 316): 1, (317, 317): u, (317, 595):
        u**2/w, (318, 136): -u, (318, 244): -u**2, (318, 299): v,
        (318, 317): w, (318, 622): -u**2/w, (319, 319): u, (319, 322):
        1, (320, 266): w, (321, 319): v, (321, 427): w, (322, 267): w,
        (322, 319): -v, (323, 269): w, (324, 297): w, (324, 594):
        -u*w, (325, 298): w, (325, 595): -u*w, (326, 299): w, (326,
        596): -u*w, (327, 300): w, (327, 597): -u*w, (328, 301): w,
        (328, 598): -u*w, (329, 77): -v, (329, 163): u*v, (329, 207):
        -v, (329, 212): -u*v, (329, 267): -v*w**2, (329, 294): u*v*w,
        (329, 315): -u*v, (329, 333): 1, (329, 334): -v, (329, 342):
        -v**2/w, (329, 347): -u*v**2/w, (329, 352): u**2*v, (329,
        374): -v**2, (329, 595): v*(u*v - w), (329, 612): u**2*v,
        (329, 618): u**2*v*w, (329, 639): -u*v**2/w, (329, 644):
        -v**2*(u**2 - v)/w, (330, 238): -v, (330, 269): -v*w**2, (330,
        296): u*v*w, (330, 315): -u, (330, 335): 1, (330, 336): -v,
        (330, 612): u**2, (330, 620): u**2*v*w, (330, 643): -v**2,
        (331, 206): -v, (331, 314): -u*v, (331, 337): 1, (331, 338):
        -v, (331, 341): -v**2/w, (331, 611): u**2*v, (331, 638):
        -u*v**2/w, (332, 76): -u, (332, 164): -u, (332, 211): -u**2,
        (332, 238): -u*v/w, (332, 314): -u, (332, 339): 1, (332, 340):
        -v, (332, 346): -u**2*v/w, (332, 353): -u**2, (332, 373):
        -u*v, (332, 611): u**2, (332, 643): -u**3*v/w, (333, 319):
        v*w**2, (333, 334): w, (333, 342): v, (333, 616): -u*v*w**2,
        (334, 212): v, (334, 329): 1, (334, 334): u, (334, 342):
        u*v/w, (334, 347): v**2/w, (334, 352): -u*v, (334, 622): v,
        (334, 644): u*v**2/w, (335, 298): -u*v, (335, 336): w, (335,
        595): u**2*v, (336, 190): u*v/w, (336, 213): v, (336, 323):
        v*w, (336, 325): u*v**2/w**2, (336, 330): 1, (336, 336): u,
        (336, 342): u/w, (336, 348): v**2/w, (336, 620): -u*v*w, (336,
        622): u**2*v**2/w**2, (336, 645): u*v**2/w, (337, 77): -u,
        (337, 163): u**2, (337, 212): -u**2, (337, 319): u*v*w, (337,
        338): w, (337, 341): v, (337, 347): -u**2*v/w, (337, 352):
        u**3, (337, 374): -u*v, (337, 616): -u**2*v*w, (337, 644):
        -u*v*(u**2 - v)/w, (338, 211): -u*v, (338, 239): u/w, (338,
        331): 1, (338, 338): u, (338, 341): u*v/w, (338, 346):
        -u*v**2/w, (338, 514): -u**2/w, (338, 568): u**2*v/w, (338,
        622): u**2*v**2/w**2, (338, 643): -u**2*v**2/w, (338, 644):
        u*v/w, (339, 269): -u*w**2, (339, 296): u**2*w, (339, 340): w,
        (339, 346): u**2, (339, 620): u**3*w, (340, 240): u/w, (340,
        323): u*v, (340, 332): 1, (340, 340): u, (340, 341): u/w,
        (340, 353): u, (340, 377): -u**3, (340, 431): u*w, (340, 458):
        -u**2, (340, 623): -u*v/w, (340, 645): u*v/w, (341, 211): u*w,
        (341, 314): w, (341, 346): u*v, (341, 375): -u*w, (341, 611):
        -u*w, (341, 643): u**2*v, (341, 645): u*v, (342, 315): w,
        (342, 612): -u*w, (343, 191): -v, (343, 299): -u*v, (343,
        326): -v**2/w, (343, 344): -v, (343, 345): 1, (343, 596):
        u**2*v, (343, 623): -u*v**2/w, (344, 326): u*v/w, (344, 343):
        1, (344, 344): u, (344, 514): u/w, (344, 568): -u*v/w, (344,
        622): -u*v**2/w**2, (345, 163): -u, (345, 326): v, (345, 344):
        w, (345, 352): -u**2, (346, 346): u, (346, 349): 1, (347,
        374): w, (347, 644): -v, (348, 373): -u*w, (348, 643): w,
        (349, 346): -v, (349, 375): w, (349, 645): -v, (350, 377): w,
        (350, 647): -v, (351, 162): 1, (351, 351): u, (351, 594): v,
        (352, 163): 1, (352, 352): u, (352, 595): v, (353, 164): 1,
        (353, 353): u, (353, 596): v, (354, 165): 1, (354, 354): u,
        (354, 597): v, (355, 166): 1, (355, 355): u, (355, 598): v,
        (356, 159): -v*w, (356, 163): -v**2/w, (356, 180): -u*v/w,
        (356, 294): -v**2, (356, 298): -v, (356, 352): -u*v**2/w,
        (356, 360): 1, (356, 361): -v, (356, 369): -u**2*v/w, (356,
        509): -v/w, (356, 531): -v/w, (356, 536): -u*v/w, (356, 595):
        v*(u*w - v**2)/w, (356, 612): -u*v**2/w, (356, 618): -u*v**2,
        (356, 645): -u*v, (357, 161): -v*w, (357, 180): -u/w, (357,
        296): -v**2, (357, 362): 1, (357, 363): -v, (357, 369):
        -u**2/w, (357, 562): -v/w, (357, 612): -u*v/w, (357, 620):
        -u*v**2, (357, 647): -u*v, (358, 179): -u*v/w, (358, 364): 1,
        (358, 365): -v, (358, 368): -u**2*v/w, (358, 530): -v/w, (358,
        611): -u*v**2/w, (359, 179): -u/w, (359, 366): 1, (359, 367):
        -v, (359, 368): -u**2/w, (359, 508): -u/w, (359, 535):
        -u**2/w, (359, 562): -u*v/w**2, (359, 596): -u, (359, 611):
        -u*v/w, (360, 184): v*w, (360, 361): w, (360, 369): v, (360,
        373): u*v*w, (360, 616): v**2*w, (361, 325): v/w, (361, 352):
        v**2/w, (361, 356): 1, (361, 361): u, (361, 369): u*v/w, (361,
        536): v/w, (362, 163): -u*v/w, (362, 352): -u**2*v/w, (362,
        363): w, (362, 595): -u*v**2/w, (363, 188): v, (363, 357): 1,
        (363, 363): u, (363, 369): u/w, (363, 377): u*v, (363, 514):
        u*v/w**2, (363, 537): v/w, (363, 620): v**2, (364, 184): u*v,
        (364, 365): w, (364, 368): v, (364, 373): u**2*v, (364, 509):
        -u/w, (364, 536): -u**2/w, (364, 595): u**2, (364, 616):
        u*v**2, (365, 358): 1, (365, 365): u, (365, 368): u*v/w, (365,
        535): -u*v/w, (365, 563): u/w**2, (365, 568): -u**2/w, (365,
        622): -u**2*v/w**2, (366, 161): -u*w, (366, 296): -u*v, (366,
        367): w, (366, 373): u**2, (366, 620): -u**2*v, (366, 647):
        -u**2, (367, 53): u, (367, 188): u*v/w, (367, 350): u**2/w,
        (367, 359): 1, (367, 367): u, (367, 368): u/w, (367, 377):
        2*u**2*v/w, (367, 458): u*v/w, (367, 564): u/w**2, (367, 623):
        u/w, (368, 179): 1, (368, 368): u, (368, 535): u, (368, 611):
        v, (368, 645): -u, (369, 180): 1, (369, 369): u, (369, 612):
        v, (370, 164): -u*v/w, (370, 353): -u**2*v/w, (370, 371): -v,
        (370, 372): 1, (370, 515): -v/w, (370, 596): -u*v**2/w, (371,
        353): u*v/w, (371, 370): 1, (371, 371): u, (371, 568): u/w,
        (371, 622): u*v/w**2, (372, 353): v, (372, 371): w, (372,
        595): -u, (373, 373): u, (373, 376): 1, (374, 644): 1, (375,
        346): 1, (375, 373): v, (376, 373): -v, (376, 645): 1, (377,
        647): 1, (378, 216): 1, (378, 378): u, (378, 621): v, (379,
        217): 1, (379, 379): u, (379, 622): v, (380, 218): 1, (380,
        380): u, (380, 623): v, (381, 219): 1, (381, 381): u, (381,
        624): v, (382, 220): 1, (382, 382): u, (382, 625): v, (383,
        213): -v*w, (383, 217): -v**2/w, (383, 234): -u*v/w, (383,
        298): -v**2, (383, 348): -v**2, (383, 379): -u*v**2/w, (383,
        387): 1, (383, 388): -v, (383, 396): -u**2*v/w, (383, 406):
        -v*w, (383, 536): -v, (383, 558): -v/w, (383, 591): -u*v*w,
        (383, 622): v*(u*w - v**2)/w, (383, 639): -u*v**2/w, (383,
        645): -2*u*v**2, (384, 215): -v*w, (384, 234): -u/w, (384,
        350): -v**2, (384, 389): 1, (384, 390): -v, (384, 396):
        -u**2/w, (384, 508): -v, (384, 562): -v**2/w, (384, 593):
        -u*v*w, (384, 639): -u*v/w, (384, 647): -2*u*v**2, (385, 233):
        -u*v/w, (385, 391): 1, (385, 392): -v, (385, 395): -u**2*v/w,
        (385, 557): -v/w, (385, 638): -u*v**2/w, (386, 233): -u/w,
        (386, 393): 1, (386, 394): -v, (386, 395): -u**2/w, (386,
        508): -u*v/w, (386, 535): -u, (386, 562): -u*v**2/w**2, (386,
        623): -u, (386, 638): -u*v/w, (387, 238): v*w, (387, 388): w,
        (387, 396): v, (387, 400): u*v*w, (387, 643): v**2*w, (388,
        325): v**2/w, (388, 379): v**2/w, (388, 383): 1, (388, 388):
        u, (388, 396): u*v/w, (388, 460): v, (388, 563): v/w, (389,
        217): -u*v/w, (389, 379): -u**2*v/w, (389, 390): w, (389,
        622): -u*v**2/w, (390, 242): v, (390, 384): 1, (390, 390): u,
        (390, 396): u/w, (390, 404): u*v, (390, 541): u*v/w**2, (390,
        564): v/w, (390, 647): v**2, (391, 238): u*v, (391, 392): w,
        (391, 395): v, (391, 400): u**2*v, (391, 536): -u, (391, 622):
        u**2, (391, 643): u*v**2, (392, 385): 1, (392, 392): u, (392,
        395): u*v/w, (392, 509): u/w, (392, 562): -u*v/w, (392, 563):
        u*v/w**2, (392, 568): -u**2*v/w, (392, 595): -u**2, (392,
        622): u**2*(u*w - v**2)/w**2, (393, 215): -u*w, (393, 350):
        -u*v, (393, 394): w, (393, 400): u**2, (393, 593): -u**2*w,
        (393, 647): -2*u**2*v, (394, 80): u, (394, 242): u*v/w, (394,
        350): u**2*v/w, (394, 377): u*v, (394, 386): 1, (394, 394): u,
        (394, 395): u/w, (394, 404): u**2*v/w, (394, 485): u**2, (394,
        510): u/w, (394, 564): u*v/w**2, (394, 569): u, (394, 623):
        u*v/w, (395, 233): 1, (395, 395): u, (395, 562): u, (395,
        591): -u*w, (395, 638): v, (395, 645): -u*v, (396, 234): 1,
        (396, 396): u, (396, 639): v, (397, 218): -u*v/w, (397, 380):
        -u**2*v/w, (397, 398): -v, (397, 399): 1, (397, 542): -v/w,
        (397, 623): -u*v**2/w, (398, 380): u*v/w, (398, 397): 1, (398,
        398): u, (398, 568): u*v/w, (398, 595): u, (398, 622): -u*(u*w
        - v**2)/w**2, (399, 380): v, (399, 398): w, (399, 622): -u,
        (400, 400): u, (400, 403): 1, (401, 590): w, (401, 644): v,
        (402, 346): v, (402, 400): v, (402, 481): w, (403, 400): -v,
        (403, 591): w, (403, 645): v, (404, 593): w, (404, 647): v,
        (405, 81): 1, (405, 405): u, (405, 594): u, (405, 621):
        -u**2/w, (406, 82): 1, (406, 406): u, (406, 595): u, (406,
        622): -u**2/w, (407, 83): 1, (407, 407): u, (407, 596): u,
        (407, 623): -u**2/w, (408, 84): 1, (408, 408): u, (408, 597):
        u, (408, 624): -u**2/w, (409, 85): 1, (409, 409): u, (409,
        598): u, (409, 625): -u**2/w, (410, 24): -v, (410, 99):
        -u*v/w, (410, 105): -u*v, (410, 136): -v, (410, 190): u*v/w,
        (410, 244): -u*v, (410, 267): u*v**2, (410, 294): -u*v, (410,
        298): u**2*v/w, (410, 321): -u*v, (410, 348): u**2*v/w, (410,
        374): v**2/w, (410, 401): -v/w, (410, 414): 1, (410, 415): -v,
        (410, 423): -u**2*v/w, (410, 477): -v/w, (410, 482): -u*v/w,
        (410, 568): u**2*v/w, (410, 585): -u*v/w, (410, 590): -v*(u**2
        - v)/w, (410, 612): -u**2*v/w, (410, 618): -u**2*v, (410,
        622): u*v*(u*v - w)/w**2, (410, 639): u**3*v/w**2, (410, 645):
        u**3*v/w, (411, 26): -v, (411, 99): -u/w, (411, 107): -u*v,
        (411, 269): u*v**2, (411, 296): -u*v, (411, 323): -u*v, (411,
        350): u**2*v/w, (411, 416): 1, (411, 417): -v, (411, 423):
        -u**2/w, (411, 589): -v, (411, 612): -u**2/w, (411, 620):
        -u**2*v, (411, 639): u**3/w**2, (411, 647): u**3*v/w, (412,
        98): -u*v/w, (412, 418): 1, (412, 419): -v, (412, 422):
        -u**2*v/w, (412, 476): -v/w, (412, 584): -u*v/w, (412, 611):
        -u**2*v/w, (412, 638): u**3*v/w**2, (413, 98): -u/w, (413,
        137): u*v/w, (413, 191): -u/w, (413, 245): u**2*v/w, (413,
        299): -u**2/w, (413, 373): u*v/w, (413, 400): -u/w, (413,
        420): 1, (413, 421): -v, (413, 422): -u**2/w, (413, 481):
        -u**2/w, (413, 569): -u**2/w, (413, 589): -u**3/w, (413, 611):
        -u**2/w, (413, 638): u**3/w**2, (414, 103): v*w, (414, 415):
        w, (414, 423): v, (414, 427): u*v*w, (414, 616): u*v*w, (414,
        643): -u**2*v, (415, 244): v, (415, 298): -u*v/w, (415, 410):
        1, (415, 415): u, (415, 423): u*v/w, (415, 482): v/w, (415,
        590): u*v/w, (416, 82): -u*v/w, (416, 406): -u**2*v/w, (416,
        417): w, (416, 595): -u**2*v/w, (416, 622): u**3*v/w**2, (417,
        107): v, (417, 411): 1, (417, 417): u, (417, 423): u/w, (417,
        431): u*v, (417, 460): u*v/w**2, (417, 483): v/w, (417, 568):
        u**2*v/w**2, (417, 591): u*v/w, (417, 620): u*v, (417, 647):
        -u**2*v/w, (418, 103): u*v, (418, 136): -u**2*v/w, (418, 190):
        u**2/w, (418, 244): -u**3*v/w, (418, 298): u**3/w, (418, 374):
        u*v/w, (418, 401): -u/w, (418, 419): w, (418, 422): v, (418,
        427): u**2*v, (418, 482): -u**2/w, (418, 568): u**3/w, (418,
        590): -u*(u**2 - v)/w, (418, 616): u**2*v, (418, 643):
        -u**3*v/w, (419, 271): u**2*v/w**2, (419, 325): -u**2/w**2,
        (419, 412): 1, (419, 419): u, (419, 422): u*v/w, (419, 481):
        -u*v/w, (419, 589): -u**2*v/w, (419, 590): u/w, (419, 595):
        u**3*v/w**2, (419, 622): -u**3/w**2, (420, 26): -u, (420,
        107): -u**2, (420, 269): u**2*v, (420, 296): -u**2, (420,
        323): -u**2, (420, 350): u**3/w, (420, 421): w, (420, 427):
        u**2, (420, 620): -u**3, (420, 647): u**4/w, (421, 134): u/w,
        (421, 245): -u*v/w, (421, 269): u**2, (421, 299): u/w, (421,
        323): -u**3/w, (421, 413): 1, (421, 421): u, (421, 422): u/w,
        (421, 458): u**2/w, (421, 591): u/w, (422, 98): 1, (422, 267):
        u*v, (422, 321): -u, (422, 422): u, (422, 481): u, (422, 589):
        u**2, (422, 611): u, (422, 638): -u**2/w, (423, 99): 1, (423,
        423): u, (423, 612): u, (423, 639): -u**2/w, (424, 83):
        -u*v/w, (424, 407): -u**2*v/w, (424, 425): -v, (424, 426): 1,
        (424, 461): -v/w, (424, 569): -u*v/w, (424, 596): -u**2*v/w,
        (424, 623): u**3*v/w**2, (425, 271): -u*v/w**2, (425, 325):
        u/w**2, (425, 407): u*v/w, (425, 424): 1, (425, 425): u, (425,
        595): -u**2*v/w**2, (425, 622): u**2/w**2, (426, 136): u*v/w,
        (426, 190): -u/w, (426, 244): u**2*v/w, (426, 298): -u**2/w,
        (426, 407): v, (426, 425): w, (426, 568): -u**2/w, (427, 427):
        u, (427, 430): 1, (428, 266): -v, (428, 320): 1, (429, 265):
        w, (429, 319): -u, (430, 267): -v, (430, 321): 1, (430, 427):
        -v, (431, 269): -v, (431, 323): 1, (432, 108): 1, (432, 432):
        u, (432, 567): v, (433, 109): 1, (433, 433): u, (433, 568): v,
        (434, 110): 1, (434, 434): u, (434, 569): v, (435, 111): 1,
        (435, 435): u, (435, 570): v, (436, 112): 1, (436, 436): u,
        (436, 571): v, (437, 105): -v*w, (437, 109): -v**2/w, (437,
        126): -u*v/w, (437, 244): -v*w, (437, 298): u*v, (437, 433):
        -u*v**2/w, (437, 441): 1, (437, 442): -v, (437, 450):
        -u**2*v/w, (437, 483): -v**2, (437, 504): -v/w, (437, 536):
        v**2/w, (437, 563): -v/w, (437, 568): v*(u*w - v**2)/w, (437,
        585): -u*v**2/w, (437, 591): -u*v**2, (437, 618): -u*v*w,
        (437, 645): u**2*v, (438, 107): -v*w, (438, 126): -u/w, (438,
        443): 1, (438, 444): -v, (438, 450): -u**2/w, (438, 485):
        -v**2, (438, 535): -v, (438, 562): u*v/w, (438, 585): -u*v/w,
        (438, 593): -u*v**2, (438, 620): -u*v*w, (438, 647): u**2*v,
        (439, 125): -u*v/w, (439, 445): 1, (439, 446): -v, (439, 449):
        -u**2*v/w, (439, 503): -v/w, (439, 584): -u*v**2/w, (440,
        125): -u/w, (440, 447): 1, (440, 448): -v, (440, 449):
        -u**2/w, (440, 562): u*(u*v - w)/w**2, (440, 569): -u, (440,
        584): -u*v/w, (441, 130): v*w, (441, 442): w, (441, 450): v,
        (441, 454): u*v*w, (441, 589): v**2*w, (442, 271): v, (442,
        325): -u*v/w, (442, 433): v**2/w, (442, 437): 1, (442, 442):
        u, (442, 450): u*v/w, (442, 509): v/w, (443, 109): -u*v/w,
        (443, 433): -u**2*v/w, (443, 444): w, (443, 568): -u*v**2/w,
        (444, 134): v, (444, 438): 1, (444, 444): u, (444, 450): u/w,
        (444, 458): u*v, (444, 487): u*v/w**2, (444, 510): v/w, (444,
        593): v**2, (445, 130): u*v, (445, 446): w, (445, 449): v,
        (445, 454): u**2*v, (445, 536): u*v/w, (445, 563): -u/w, (445,
        568): u**2, (445, 589): u*v**2, (446, 439): 1, (446, 446): u,
        (446, 449): u*v/w, (446, 508): -u*v/w, (446, 536): u/w, (446,
        563): -u**2/w**2, (446, 568): u**3/w, (446, 622): u**2*(u*v -
        w)/w**2, (447, 107): -u*w, (447, 448): w, (447, 454): u**2,
        (447, 485): -u*v, (447, 593): -u**2*v, (447, 620): -u**2*w,
        (447, 647): u**3, (448, 26): u, (448, 134): u*v/w, (448, 296):
        u**2, (448, 350): -u**3/w, (448, 377): -u*v**2/w, (448, 404):
        u*v/w, (448, 440): 1, (448, 448): u, (448, 449): u/w, (448,
        458): u**2*v/w, (448, 537): u/w, (448, 564): -u**2/w**2, (448,
        596): u, (448, 623): -u**2/w, (449, 125): 1, (449, 449): u,
        (449, 508): u, (449, 584): v, (449, 618): -u*w, (449, 645):
        u**2, (450, 126): 1, (450, 450): u, (450, 585): v, (451, 110):
        -u*v/w, (451, 434): -u**2*v/w, (451, 452): -v, (451, 453): 1,
        (451, 488): -v/w, (451, 569): -u*v**2/w, (452, 434): u*v/w,
        (452, 451): 1, (452, 452): u, (452, 568): -u**2/w, (452, 622):
        -u*(u*v - w)/w**2, (453, 434): v, (453, 452): w, (453, 568):
        -u, (454, 454): u, (454, 457): 1, (455, 617): w, (455, 644):
        -u, (456, 292): w, (456, 346): -u, (456, 454): v, (457, 454):
        -v, (457, 618): w, (457, 645): -u, (458, 620): w, (458, 647):
        -u, (459, 405): w, (459, 594): u*v, (459, 621): -u, (460,
        406): w, (460, 595): u*v, (460, 622): -u, (461, 407): w, (461,
        596): u*v, (461, 623): -u, (462, 408): w, (462, 597): u*v,
        (462, 624): -u, (463, 409): w, (463, 598): u*v, (463, 625):
        -u, (464, 23): -v, (464, 99): -v, (464, 104): -u*v, (464,
        163): -u*v**2/w, (464, 217): u*v/w, (464, 267): v**2*w, (464,
        294): -u*v**2, (464, 321): -v*w, (464, 348): u*v, (464, 352):
        -u**2*v**2/w, (464, 374): v**3/w, (464, 379): u**2*v/w, (464,
        401): -v**2/w, (464, 423): -u*v, (464, 468): 1, (464, 469):
        -v, (464, 477): -v**2/w, (464, 482): -u*v**2/w, (464, 585):
        -u*v**2/w, (464, 590): -v**2*(u**2 - v)/w, (464, 595):
        -v**2*(u*v - w)/w, (464, 612): -u**2*v**2/w, (464, 618):
        -u**2*v**2, (464, 622): v*(u*v - w)/w, (464, 639): u**2*v/w,
        (464, 645): u**2*v, (465, 130): -v, (465, 269): v**2*w, (465,
        296): -u*v**2, (465, 323): -v*w, (465, 350): u*v, (465, 423):
        -u, (465, 470): 1, (465, 471): -v, (465, 589): -v**2, (465,
        612): -u**2*v/w, (465, 620): -u**2*v**2, (465, 639): u**2/w,
        (465, 647): u**2*v, (466, 98): -v, (466, 422): -u*v, (466,
        472): 1, (466, 473): -v, (466, 476): -v**2/w, (466, 584):
        -u*v**2/w, (466, 611): -u**2*v**2/w, (466, 638): u**2*v/w,
        (467, 22): -u, (467, 103): -u**2, (467, 130): -u*v/w, (467,
        164): u*v/w, (467, 218): -u/w, (467, 353): u**2*v/w, (467,
        373): u*v**2/w, (467, 380): -u**2/w, (467, 400): -u*v/w, (467,
        422): -u, (467, 474): 1, (467, 475): -v, (467, 481):
        -u**2*v/w, (467, 589): -u**3*v/w, (467, 611): -u**2*v/w, (467,
        638): u**2/w, (468, 427): v*w**2, (468, 469): w, (468, 477):
        v, (468, 616): u*v**2*w, (468, 643): -u*v*w, (469, 104): v,
        (469, 352): u*v**2/w, (469, 379): -u*v/w, (469, 464): 1, (469,
        469): u, (469, 477): u*v/w, (469, 482): v**2/w, (469, 568): v,
        (469, 590): u*v**2/w, (470, 406): -u*v, (470, 471): w, (470,
        595): -u**2*v**2/w, (470, 622): u**2*v/w, (471, 82): u*v/w,
        (471, 105): v, (471, 431): v*w, (471, 460): u*v**2/w**2, (471,
        465): 1, (471, 471): u, (471, 477): u/w, (471, 483): v**2/w,
        (471, 568): u**2*v**2/w**2, (471, 591): u*v**2/w, (471, 620):
        u*v**2, (471, 647): -u*v, (472, 23): -u, (472, 104): -u**2,
        (472, 163): -u**2*v/w, (472, 217): u**2/w, (472, 352):
        -u**3*v/w, (472, 374): u*v**2/w, (472, 379): u**3/w, (472,
        401): -u*v/w, (472, 427): u*v*w, (472, 473): w, (472, 476): v,
        (472, 482): -u**2*v/w, (472, 590): -u*v*(u**2 - v)/w, (472,
        616): u**2*v**2, (472, 643): -u**2*v, (473, 103): -u*v, (473,
        131): u/w, (473, 466): 1, (473, 473): u, (473, 476): u*v/w,
        (473, 481): -u*v**2/w, (473, 514): u**2*v/w**2, (473, 541):
        -u**2/w**2, (473, 589): -u**2*v**2/w, (473, 590): u*v/w, (473,
        595): u**2*v/w, (473, 622): -u**3*v/w**2, (474, 269): u*v*w,
        (474, 296): -u**2*v, (474, 323): -u*w, (474, 350): u**2, (474,
        475): w, (474, 481): u**2, (474, 620): -u**3*v, (474, 647):
        u**3, (475, 132): u/w, (475, 269): u*w, (475, 323): -u**2,
        (475, 353): -u*v/w, (475, 377): u**2*(u*v - w)/w, (475, 380):
        u/w, (475, 458): u**2*v/w, (475, 467): 1, (475, 475): u, (475,
        476): u/w, (475, 569): -u*v/w, (475, 591): u*v/w, (476, 103):
        u*w, (476, 375): u*v, (476, 402): -u, (476, 422): w, (476,
        481): u*v, (476, 589): u**2*v, (476, 591): u*v, (476, 611):
        u*v, (476, 638): -u, (477, 423): w, (477, 612): u*v, (477,
        639): -u, (478, 83): -v, (478, 407): -u*v, (478, 461):
        -v**2/w, (478, 479): -v, (478, 480): 1, (478, 569): -u*v**2/w,
        (478, 596): -u**2*v**2/w, (478, 623): u**2*v/w, (479, 461):
        u*v/w, (479, 478): 1, (479, 479): u, (479, 514): -u*v/w**2,
        (479, 541): u/w**2, (479, 595): -u*v/w, (479, 622):
        u**2*v/w**2, (480, 163): u*v/w, (480, 217): -u/w, (480, 352):
        u**2*v/w, (480, 379): -u**2/w, (480, 461): v, (480, 479): w,
        (481, 481): u, (481, 484): 1, (482, 374): -v, (482, 401): 1,
        (482, 590): -v, (483, 373): u*v, (483, 400): -u, (483, 589):
        w, (484, 375): -v, (484, 402): 1, (484, 481): -v, (484, 591):
        -v, (485, 377): -v, (485, 404): 1, (485, 593): -v, (486, 432):
        w, (487, 433): w, (488, 434): w, (489, 435): w, (490, 436): w,
        (491, 104): -v*w, (491, 126): -v, (491, 352): -v*w, (491,
        379): u*v, (491, 450): -u*v, (491, 482): -v**2, (491, 495): 1,
        (491, 496): -v, (491, 504): -v**2/w, (491, 536): v**3/w, (491,
        563): -v**2/w, (491, 585): -v**2, (491, 590): -u*v**2, (491,
        618): -v*w**2, (491, 645): u*v*w, (492, 22): -v*w, (492, 130):
        -v**2, (492, 373): v**3, (492, 400): -v**2, (492, 450): -u,
        (492, 497): 1, (492, 498): -v, (492, 535): -v**2, (492, 562):
        u*v**2/w, (492, 620): -v*w**2, (492, 647): u*v*w, (493, 125):
        -v, (493, 449): -u*v, (493, 499): 1, (493, 500): -v, (493,
        503): -v**2/w, (493, 584): -v**2, (494, 22): -u*v, (494, 103):
        -u*w, (494, 130): -u*v**2/w, (494, 353): u*v, (494, 373):
        u*v**3/w, (494, 380): -u, (494, 400): -u*v**2/w, (494, 449):
        -u, (494, 481): -u*v, (494, 501): 1, (494, 502): -v, (494,
        562): u*v*(u*v - w)/w**2, (494, 589): -u**2*v, (495, 454):
        v*w**2, (495, 496): w, (495, 504): v, (496, 131): v, (496,
        491): 1, (496, 496): u, (496, 504): u*v/w, (496, 509): v**2/w,
        (496, 514): v, (496, 541): -u*v/w, (496, 590): v**2, (497,
        433): -u*v, (497, 498): w, (498, 109): u*v/w, (498, 132): v,
        (498, 458): v*w, (498, 487): u*v**2/w**2, (498, 492): 1, (498,
        498): u, (498, 504): u/w, (498, 510): v**2/w, (498, 568):
        u*v**2/w, (498, 591): v**2, (499, 104): -u*w, (499, 352):
        -u**2*v, (499, 379): u**2, (499, 454): u*v*w, (499, 482):
        -u*v, (499, 500): w, (499, 503): v, (499, 536): u*v**2/w,
        (499, 563): -u*v/w, (499, 590): -u**2*v, (500, 23): u, (500,
        130): -u*v, (500, 131): u*v/w, (500, 163): u**2*v/w, (500,
        217): -u**2/w, (500, 374): -u*v**2/w, (500, 401): u*v/w, (500,
        493): 1, (500, 500): u, (500, 503): u*v/w, (500, 508):
        -u*v**2/w, (500, 514): u**2*v**2/w**2, (500, 536): u*v/w,
        (500, 541): -u**2*v/w**2, (500, 563): -u**2*v/w**2, (500,
        589): -u*v**2, (500, 595): u**2*v**2/w, (500, 622): -u**2*v/w,
        (501, 502): w, (501, 508): u**2, (501, 620): -u*w**2, (501,
        647): u**2*w, (502, 24): u, (502, 132): u*v/w, (502, 296):
        u*w, (502, 350): -u**2, (502, 375): -u*v**2/w, (502, 402):
        u*v/w, (502, 458): u*v, (502, 494): 1, (502, 502): u, (502,
        503): u/w, (502, 515): -u*v/w, (502, 537): u*v/w, (502, 542):
        u/w, (502, 564): -u**2*v/w**2, (503, 130): u*w, (503, 449): w,
        (503, 508): u*v, (503, 537): u*v, (503, 564): -u, (503, 589):
        u*v*w, (504, 450): w, (505, 110): -v, (505, 434): -u*v, (505,
        488): -v**2/w, (505, 506): -v, (505, 507): 1, (505, 569):
        -v**2, (506, 163): -u*v/w, (506, 217): u/w, (506, 488): u*v/w,
        (506, 505): 1, (506, 506): u, (506, 514): -u*v**2/w**2, (506,
        541): u*v/w**2, (506, 595): -u*v**2/w, (506, 622): u*v/w,
        (507, 352): u*v, (507, 379): -u, (507, 488): v, (507, 506): w,
        (508, 508): u, (508, 511): 1, (509, 536): -v, (509, 563): 1,
        (510, 535): w, (510, 562): -u, (511, 508): -v, (511, 537): -v,
        (511, 564): 1, (512, 539): -v, (512, 566): 1, (513, 351): w,
        (514, 352): w, (515, 353): w, (516, 354): w, (517, 355): w,
        (518, 158): -v*w, (518, 180): -v, (518, 293): -v**2, (518,
        369): -u*v, (518, 379): -v, (518, 509): -v**2/w, (518, 522):
        1, (518, 523): -v, (518, 531): -v**2/w, (518, 536): -u*v**2/w,
        (518, 612): -v**2, (518, 617): -u*v**2, (518, 645): -v*w,
        (519, 49): -v*w, (519, 184): -v**2, (519, 369): -u, (519,
        373): -u*v**2, (519, 454): -v**2, (519, 524): 1, (519, 525):
        -v, (519, 562): -v**2/w, (519, 647): -v*w, (520, 179): -v,
        (520, 368): -u*v, (520, 526): 1, (520, 527): -v, (520, 530):
        -v**2/w, (520, 611): -v**2, (521, 49): -u*v, (521, 157): -u*w,
        (521, 184): -u*v**2/w, (521, 292): -u*v, (521, 353): -u**2,
        (521, 368): -u, (521, 373): -u**2*v**2/w, (521, 434): -u,
        (521, 454): -u*v**2/w, (521, 508): -u*v/w, (521, 528): 1,
        (521, 529): -v, (521, 535): -u**2*v/w, (521, 562):
        -u*v**2/w**2, (521, 616): -u**2*v, (522, 373): v*w**2, (522,
        523): w, (522, 531): v, (523, 185): v, (523, 518): 1, (523,
        523): u, (523, 531): u*v/w, (523, 536): v**2/w, (523, 541):
        v/w, (523, 617): v**2, (524, 352): -u*v, (524, 525): w, (525,
        163): u*v/w, (525, 186): v, (525, 377): v*w, (525, 514):
        u*v**2/w**2, (525, 519): 1, (525, 525): u, (525, 531): u/w,
        (525, 537): v**2/w, (525, 595): u*v**2/w, (525, 618): v**2,
        (526, 158): -u*w, (526, 293): -u*v, (526, 352): u**3, (526,
        373): u*v*w, (526, 433): u**2, (526, 509): -u*v/w, (526, 527):
        w, (526, 530): v, (526, 536): -u**2*v/w, (526, 617): -u**2*v,
        (527, 50): u, (527, 109): -u**2/w, (527, 163): -u**3/w, (527,
        184): -u*v, (527, 185): u*v/w, (527, 374): u**2*v/w, (527,
        455): u*v/w, (527, 487): -u**2*v/w**2, (527, 514):
        -u**3*v/w**2, (527, 520): 1, (527, 527): u, (527, 530): u*v/w,
        (527, 535): -u*v**2/w, (527, 563): u*v/w**2, (527, 568):
        -u**2*v/w, (527, 595): -u**3*v/w, (527, 616): -u*v**2, (528,
        529): w, (528, 535): u**2, (528, 647): -u*w, (529, 51): u,
        (529, 186): u*v/w, (529, 350): u, (529, 375): u**2*v/w, (529,
        377): u*v, (529, 456): u*v/w, (529, 488): u/w, (529, 515):
        u**2/w, (529, 521): 1, (529, 529): u, (529, 530): u/w, (529,
        564): u*v/w**2, (530, 184): u*w, (530, 368): w, (530, 510):
        -u, (530, 535): u*v, (530, 537): -u**2, (530, 616): u*v*w,
        (531, 369): w, (532, 164): -v, (532, 353): -u*v, (532, 515):
        -v**2/w, (532, 533): -v, (532, 534): 1, (532, 596): -v**2,
        (533, 109): u/w, (533, 163): u**2/w, (533, 487): u*v/w**2,
        (533, 514): u**2*v/w**2, (533, 515): u*v/w, (533, 532): 1,
        (533, 533): u, (533, 568): u*v/w, (533, 595): u**2*v/w, (534,
        352): -u**2, (534, 433): -u, (534, 515): v, (534, 533): w,
        (535, 535): u, (535, 538): 1, (536, 509): 1, (536, 536): u,
        (537, 562): 1, (538, 510): 1, (538, 535): -v, (538, 537): u,
        (539, 512): 1, (539, 539): u, (540, 378): w, (541, 379): w,
        (542, 380): w, (543, 381): w, (544, 382): w, (545, 212): -v*w,
        (545, 234): -v, (545, 347): -v**2, (545, 379): -v**2, (545,
        396): -u*v, (545, 433): -v*w, (545, 536): -v**2, (545, 549):
        1, (545, 550): -v, (545, 558): -v**2/w, (545, 591): -v*w**2,
        (545, 639): -v**2, (545, 644): -u*v**2, (545, 645): -v**2*w,
        (546, 76): -v*w, (546, 238): -v**2, (546, 373): -v**2*w, (546,
        396): -u, (546, 508): -v**2, (546, 551): 1, (546, 552): -v,
        (546, 562): -v**3/w, (546, 593): -v*w**2, (546, 647): -v**2*w,
        (547, 233): -v, (547, 395): -u*v, (547, 553): 1, (547, 554):
        -v, (547, 557): -v**2/w, (547, 638): -v**2, (548, 76): -u*v,
        (548, 211): -u*w, (548, 238): -u*v**2/w, (548, 346): -u*v,
        (548, 353): -u*w, (548, 373): -u*v**2, (548, 395): -u, (548,
        508): -u*v**2/w, (548, 535): -u*v, (548, 555): 1, (548, 556):
        -v, (548, 562): -u*v**3/w**2, (548, 643): -u**2*v, (549, 400):
        v*w**2, (549, 550): w, (549, 558): v, (550, 239): v, (550,
        487): v, (550, 541): v**2/w, (550, 545): 1, (550, 550): u,
        (550, 558): u*v/w, (550, 563): v**2/w, (550, 644): v**2, (551,
        379): -u*v, (551, 552): w, (552, 217): u*v/w, (552, 240): v,
        (552, 404): v*w, (552, 541): u*v**2/w**2, (552, 546): 1, (552,
        552): u, (552, 558): u/w, (552, 564): v**2/w, (552, 622):
        u*v**2/w, (552, 645): v**2, (553, 212): -u*w, (553, 347):
        -u*v, (553, 352): u**2*w, (553, 400): u*v*w, (553, 536): -u*v,
        (553, 554): w, (553, 557): v, (553, 644): -u**2*v, (554, 77):
        u, (554, 163): -u**2, (554, 238): -u*v, (554, 239): u*v/w,
        (554, 374): u*v, (554, 509): u*v/w, (554, 514): -u**2*v/w,
        (554, 547): 1, (554, 554): u, (554, 557): u*v/w, (554, 562):
        -u*v**2/w, (554, 563): u*v**2/w**2, (554, 595): -u**2*v, (554,
        643): -u*v**2, (555, 556): w, (555, 562): u**2, (555, 593):
        -u*w**2, (555, 647): -u*v*w, (556, 78): u, (556, 240): u*v/w,
        (556, 350): u*v, (556, 375): u*v, (556, 404): u*v, (556, 485):
        u*w, (556, 510): u*v/w, (556, 515): u, (556, 548): 1, (556,
        556): u, (556, 557): u/w, (556, 564): u*v**2/w**2, (557, 238):
        u*w, (557, 395): w, (557, 537): -u*w, (557, 562): u*v, (557,
        643): u*v*w, (558, 396): w, (559, 218): -v, (559, 380): -u*v,
        (559, 542): -v**2/w, (559, 560): -v, (559, 561): 1, (559,
        623): -v**2, (560, 163): u, (560, 514): u*v/w, (560, 542):
        u*v/w, (560, 559): 1, (560, 560): u, (560, 595): u*v, (561,
        352): -u*w, (561, 542): v, (561, 560): w, (562, 562): u, (562,
        565): 1, (563, 536): w, (564, 508): w, (564, 562): v, (565,
        537): w, (565, 562): -v, (566, 539): w, (567, 594): -v, (567,
        621): 1, (568, 595): -v, (568, 622): 1, (569, 596): -v, (569,
        623): 1, (570, 597): -v, (570, 624): 1, (571, 598): -v, (571,
        625): 1, (572, 163): v**2/w, (572, 217): -v/w, (572, 293): -v,
        (572, 294): v**2, (572, 347): u*v/w, (572, 348): -v, (572,
        352): u*v**2/w, (572, 379): -u*v/w, (572, 576): 1, (572, 577):
        -v, (572, 595): v**3/w, (572, 612): v*(u*v - w)/w, (572, 617):
        -u*v, (572, 618): u*v**2, (572, 622): -v**2/w, (572, 644):
        u**2*v/w, (572, 645): -u*v, (573, 296): v**2, (573, 350): -v,
        (573, 454): -v, (573, 578): 1, (573, 579): -v, (573, 612):
        u*v/w, (573, 620): u*v**2, (573, 639): -u/w, (573, 647): -u*v,
        (574, 580): 1, (574, 581): -v, (574, 611): v*(u*v - w)/w,
        (575, 292): -u, (575, 346): u**2/w, (575, 407): -u, (575,
        454): -u*v/w, (575, 582): 1, (575, 583): -v, (575, 611):
        u*v/w, (575, 616): -u**2, (575, 638): -u/w, (575, 643):
        u**3/w, (576, 577): w, (576, 585): v, (576, 616): -v**2*w,
        (576, 643): v*w, (577, 352): -v**2/w, (577, 379): v/w, (577,
        572): 1, (577, 577): u, (577, 585): u*v/w, (577, 617): v,
        (577, 644): -u*v/w, (578, 579): w, (578, 595): u*v**2/w, (578,
        622): -u*v/w, (579, 573): 1, (579, 579): u, (579, 585): u/w,
        (579, 595): u*v/w, (579, 618): v, (579, 620): -v**2, (579,
        622): -u**2*v/w**2, (579, 645): -u*v/w, (579, 647): v, (580,
        293): -u, (580, 347): u**2/w, (580, 406): u**2, (580, 581): w,
        (580, 584): v, (580, 616): -u*v**2, (580, 617): -u**2, (580,
        643): u*v, (580, 644): u**3/w, (581, 82): -u**2/w, (581, 455):
        u/w, (581, 460): -u**2*v/w**2, (581, 568): -u**3*v/w**2, (581,
        574): 1, (581, 581): u, (581, 584): u*v/w, (581, 595):
        -u**3/w, (581, 616): -u*v, (581, 622): u**4/w**2, (581, 643):
        u**2*v/w, (582, 296): u*v, (582, 350): -u, (582, 583): w,
        (582, 589): u**2, (582, 620): u**2*v, (582, 647): -u**2, (583,
        377): -u*(u*v - w)/w, (583, 456): u/w, (583, 458): -u*v/w,
        (583, 461): u/w, (583, 569): u**2/w, (583, 575): 1, (583,
        583): u, (583, 584): u/w, (584, 483): -u, (584, 591): -u**2,
        (584, 611): -v, (584, 616): u*w, (584, 638): 1, (584, 643):
        -u**2, (585, 612): -v, (585, 639): 1, (586, 587): -v, (586,
        588): 1, (586, 596): v*(u*v - w)/w, (587, 82): u/w, (587,
        460): u*v/w**2, (587, 568): u**2*v/w**2, (587, 569): u*v/w,
        (587, 586): 1, (587, 587): u, (587, 595): u**2/w, (587, 622):
        -u**3/w**2, (588, 406): -u, (588, 569): v, (588, 587): w,
        (589, 589): u, (589, 592): 1, (590, 482): 1, (590, 590): u,
        (591, 373): -v, (591, 400): 1, (592, 483): 1, (592, 589): -v,
        (592, 591): u, (593, 485): 1, (593, 593): u, (594, 567): 1,
        (594, 594): u, (595, 568): 1, (595, 595): u, (596, 569): 1,
        (596, 596): u, (597, 570): 1, (597, 597): u, (598, 571): 1,
        (598, 598): u, (599, 109): -v/w, (599, 163): -u*v/w, (599,
        294): -u*v, (599, 347): -v/w, (599, 352): -u**2*v/w, (599,
        433): -u*v/w, (599, 483): -v, (599, 568): -v**2/w, (599, 585):
        -u*v/w, (599, 591): -u*v, (599, 595): -u*v**2/w, (599, 603):
        1, (599, 604): -v, (599, 612): -u**2*v/w, (599, 618): -u**2*v,
        (599, 639): -v/w, (599, 644): -u*v/w, (600, 296): -u*v, (600,
        373): -v, (600, 485): -v, (600, 585): -u/w, (600, 593): -u*v,
        (600, 605): 1, (600, 606): -v, (600, 612): -u**2/w, (600,
        620): -u**2*v, (601, 584): -u*v/w, (601, 607): 1, (601, 608):
        -v, (601, 611): -u**2*v/w, (601, 638): -v/w, (602, 245): -u,
        (602, 346): -u/w, (602, 373): -u*v/w, (602, 584): -u/w, (602,
        609): 1, (602, 610): -v, (602, 611): -u**2/w, (602, 643):
        -u**2/w, (603, 589): v*w, (603, 604): w, (603, 612): v, (603,
        616): u*v*w, (604, 352): u*v/w, (604, 433): v/w, (604, 599):
        1, (604, 604): u, (604, 612): u*v/w, (604, 644): v/w, (605,
        568): -u*v/w, (605, 595): -u**2*v/w, (605, 606): w, (606,
        593): v, (606, 600): 1, (606, 606): u, (606, 612): u/w, (606,
        620): u*v, (606, 622): u*v/w**2, (606, 645): v/w, (607, 244):
        u**2, (607, 347): -u/w, (607, 589): u*v, (607, 608): w, (607,
        611): v, (607, 616): u**2*v, (607, 644): -u**2/w, (608, 136):
        -u**2/w, (608, 271): -u**2*v/w**2, (608, 374): u/w, (608,
        595): -u**3*v/w**2, (608, 601): 1, (608, 608): u, (608, 611):
        u*v/w, (608, 622): -u**3/w**2, (608, 643): -u*v/w, (609, 296):
        -u**2, (609, 485): -u, (609, 593): -u**2, (609, 610): w, (609,
        616): u**2, (609, 620): -u**3, (610, 272): u/w, (610, 375):
        u/w, (610, 377): u*(u**2 - v)/w, (610, 404): u/w, (610, 458):
        u**2/w, (610, 596): u**2/w, (610, 602): 1, (610, 610): u,
        (610, 611): u/w, (611, 294): -u, (611, 584): 1, (611, 611): u,
        (611, 618): -u**2, (611, 643): u, (612, 585): 1, (612, 612):
        u, (613, 569): -u*v/w, (613, 596): -u**2*v/w, (613, 614): -v,
        (613, 615): 1, (613, 623): -v/w, (614, 136): u/w, (614, 271):
        u*v/w**2, (614, 595): u**2*v/w**2, (614, 596): u*v/w, (614,
        613): 1, (614, 614): u, (614, 622): u**2/w**2, (615, 244): -u,
        (615, 596): v, (615, 614): w, (616, 616): u, (616, 619): 1,
        (617, 293): 1, (617, 617): u, (618, 373): u, (618, 454): 1,
        (619, 294): 1, (619, 616): -v, (619, 618): u, (620, 296): 1,
        (620, 620): u, (621, 594): w, (622, 595): w, (623, 596): w,
        (624, 597): w, (625, 598): w, (626, 163): -v, (626, 294):
        -v*w, (626, 347): -v**2/w, (626, 352): -u*v, (626, 482): -v,
        (626, 585): -v, (626, 590): -u*v, (626, 595): -v**2, (626,
        612): -u*v, (626, 618): -u*v*w, (626, 630): 1, (626, 631): -v,
        (626, 639): -v**2/w, (626, 644): -u*v**2/w, (627, 296): -v*w,
        (627, 400): -v, (627, 612): -u, (627, 620): -u*v*w, (627,
        632): 1, (627, 633): -v, (628, 584): -v, (628, 611): -u*v,
        (628, 634): 1, (628, 635): -v, (628, 638): -v**2/w, (629,
        299): -u, (629, 346): -u*v/w, (629, 400): -u*v/w, (629, 481):
        -u, (629, 589): -u**2, (629, 611): -u, (629, 636): 1, (629,
        637): -v, (629, 643): -u**2*v/w, (630, 616): v*w**2, (630,
        631): w, (630, 639): v, (631, 352): v, (631, 590): v, (631,
        626): 1, (631, 631): u, (631, 639): u*v/w, (631, 644): v**2/w,
        (632, 595): -u*v, (632, 633): w, (633, 568): u*v/w, (633,
        591): v, (633, 620): v*w, (633, 622): u*v**2/w**2, (633, 627):
        1, (633, 633): u, (633, 639): u/w, (633, 645): v**2/w, (634,
        298): u**2, (634, 347): -u*v/w, (634, 482): -u, (634, 590):
        -u**2, (634, 616): u*v*w, (634, 635): w, (634, 638): v, (634,
        644): -u**2*v/w, (635, 190): -u**2/w, (635, 325):
        -u**2*v/w**2, (635, 401): u/w, (635, 568): -u**3/w, (635,
        589): -u*v, (635, 622): -2*u**3*v/w**2, (635, 628): 1, (635,
        635): u, (635, 638): u*v/w, (635, 643): -u*v**2/w, (636, 296):
        -u*w, (636, 620): -u**2*w, (636, 637): w, (636, 643): u**2,
        (637, 326): u/w, (637, 377): u**2, (637, 402): u/w, (637,
        458): u, (637, 623): u**2/w, (637, 629): 1, (637, 637): u,
        (637, 638): u/w, (638, 348): -u, (638, 589): u*w, (638, 611):
        w, (638, 643): u*v, (638, 645): -u**2, (639, 612): w, (640,
        569): -v, (640, 596): -u*v, (640, 623): -v**2/w, (640, 641):
        -v, (640, 642): 1, (641, 190): u/w, (641, 325): u*v/w**2,
        (641, 568): u**2/w, (641, 622): 2*u**2*v/w**2, (641, 623):
        u*v/w, (641, 640): 1, (641, 641): u, (642, 298): -u, (642,
        623): v, (642, 641): w, (643, 643): u, (643, 646): 1, (644,
        347): 1, (644, 644): u, (645, 373): w, (646, 348): 1, (646,
        643): -v, (646, 645): u, (647, 350): 1, (647, 647): u}, {(0,
        81): -v, (0, 108): 1, (1, 244): v**2, (1, 271): -u*v**2/w, (1,
        298): -v, (1, 325): u*v/w, (1, 352): -v, (1, 379): 1, (1,
        514): u*v/w, (1, 541): -u/w, (1, 568): -v, (1, 595): -u*v*(u*v
        - w)/w, (2, 245): v**2, (2, 272): -v, (2, 299): -u*v**2/w, (2,
        326): u*v/w, (2, 353): -v, (2, 380): u*v/w, (2, 515): 1, (2,
        542): -u/w, (2, 569): -v, (3, 7): 1, (3, 8): -v, (4, 5): 1,
        (4, 6): -v, (4, 100): v**2, (4, 127): -v, (4, 157): -v**3, (4,
        184): v**2, (4, 211): u*v**3/w, (4, 238): -u*v**2/w, (5, 6):
        w, (5, 157): u*v**3, (5, 184): -u*v**2, (5, 211): -u*v**2, (5,
        238): u*v, (6, 4): 1, (6, 6): u, (6, 19): v, (6, 49): -v**2,
        (6, 76): u*v**2/w, (6, 157): u*v**2, (6, 184): -u**2*v**2/w,
        (6, 211): -u*v, (6, 238): u**2*v/w, (7, 8): w, (7, 100): u*v,
        (7, 127): -u, (7, 157): u*v**2*(u*v - w)/w, (7, 184):
        -u*v*(u*v - w)/w, (8, 3): 1, (8, 8): u, (8, 100): u, (8, 127):
        -u**2/w, (8, 157): u*v*(u*v - w)/w, (8, 184): -u**2*v*(u*v -
        w)/w**2, (9, 36): -v, (9, 63): 1, (10, 18): 1, (10, 28):
        -v*(u*v - w)/w, (10, 38): -v, (10, 55): u*v*(u*v - w)/w**2,
        (10, 65): u*v/w, (10, 157): -v**3, (10, 184): v**2, (10, 211):
        v**2, (10, 238): -v, (11, 1): u**2*v/w, (11, 11): u, (11, 22):
        -v**2, (11, 37): -v, (11, 49): -v*(u*v - w), (11, 64): 1, (11,
        244): -v**2*(u*v - w)/w, (11, 271): u*v**2*(u*v - w)/w**2,
        (11, 298): v*(u*v - w)/w, (11, 325): -u*v*(u*v - w)/w**2, (11,
        595): u*v*(u*v - w)**2/w**2, (12, 39): -v, (12, 66): 1, (13,
        40): -v, (13, 67): 1, (14, 17): 1, (14, 42): -v, (14, 69):
        u*v/w, (14, 103): u**2*v**2/w, (14, 130): -u**2*v/w, (14,
        245): u*v**3/w, (14, 272): -u*v**2/w, (14, 299):
        -u**2*v**3/w**2, (14, 326): u**2*v**2/w**2, (14, 353):
        -u*v**2/w, (14, 380): u**2*v**2/w**2, (14, 515): u*v/w, (14,
        542): -u**2*v/w**2, (14, 569): -u*v**2/w, (15, 15): u, (15,
        29): u*v**2/w, (15, 41): -v, (15, 49): -u**2*v**2/w, (15, 56):
        -u*v/w, (15, 68): 1, (15, 76): u**2*v/w, (15, 103): -u*v, (15,
        130): u**2*v/w, (15, 157): u*w, (15, 184): -u**2, (15, 211):
        -u**2, (15, 238): u**3/w, (15, 407): -u*v, (15, 434):
        u**2*v/w, (15, 461): u, (15, 488): -u**2/w, (15, 596):
        -u**2*v**2/w, (15, 623): u**2*v/w, (16, 43): -v, (16, 49):
        -u**2*v/w, (16, 70): 1, (16, 76): u**2/w, (16, 103): u**2*v/w,
        (16, 130): -u**2/w, (17, 42): w, (17, 69): -u, (17, 103):
        -u**2*v, (17, 130): u**2, (17, 157): -u*v**2, (17, 184): u*v,
        (17, 211): u*v, (17, 238): -u, (17, 245): -u*v**2, (17, 272):
        u*v, (17, 299): u**2*v**2/w, (17, 326): -u**2*v/w, (17, 353):
        u*v, (17, 380): -u**2*v/w, (17, 515): -u, (17, 542): u**2/w,
        (17, 569): u*v, (18, 28): u*v, (18, 38): w, (18, 55):
        -u**2*v/w, (18, 65): -u, (19, 100): -v, (19, 127): 1, (20,
        25): 1, (20, 26): -v, (20, 245): -v**3/w, (20, 272): v**2/w,
        (20, 299): u*v**3/w**2, (20, 326): -u*v**2/w**2, (20, 353):
        v**2/w, (20, 380): -u*v**2/w**2, (20, 515): -v/w, (20, 542):
        u*v/w**2, (20, 569): v**2/w, (21, 23): 1, (21, 24): -v, (21,
        103): v**2, (21, 130): -v, (21, 136): -u*v**2/w, (21, 163):
        u*v/w, (21, 190): u*v/w, (21, 217): -u/w, (22, 103): -v, (22,
        130): 1, (23, 24): w, (24, 21): 1, (24, 22): v, (24, 24): u,
        (24, 82): -u*v/w, (24, 109): u/w, (25, 26): w, (25, 103): u*v,
        (25, 130): -u, (26, 2): v/w, (26, 20): 1, (26, 26): u, (26,
        103): u, (26, 130): -u**2/w, (27, 135): -v, (27, 162): 1, (28,
        244): -u*v, (28, 271): u**2*v/w, (28, 352): u, (28, 406): -v,
        (28, 433): 1, (28, 460): u*v/w, (28, 487): -u/w, (28, 514):
        -u**2/w, (28, 568): u**2*v/w, (28, 595): v*(u**3 - w)/w, (28,
        622): u*v/w, (29, 299): v**2/w, (29, 326): -v/w, (29, 380):
        -v/w, (29, 542): 1/w, (29, 596): -v, (30, 34): 1, (30, 35):
        -v, (31, 32): 1, (31, 33): -v, (31, 154): v**2, (31, 181): -v,
        (31, 211): -v**3/w, (31, 238): v**2/w, (32, 33): w, (32, 103):
        -u*v**2, (32, 130): u*v, (32, 157): -u**2*v**2, (32, 184):
        u**2*v, (33, 31): 1, (33, 33): u, (33, 46): v, (33, 76):
        -v**2/w, (33, 103): -u*v, (33, 130): u**2*v/w, (33, 157):
        -u**2*v, (33, 184): u**3*v/w, (34, 35): w, (34, 103):
        -u**2*v**2/w, (34, 130): u**2*v/w, (34, 154): u*v, (34, 157):
        -u**3*v**2/w, (34, 181): -u, (34, 184): u**3*v/w, (34, 211):
        -u*v**2/w, (34, 238): u*v/w, (35, 30): 1, (35, 35): u, (35,
        103): -u**2*v/w, (35, 130): u**3*v/w**2, (35, 154): u, (35,
        157): -u**3*v/w, (35, 181): -u**2/w, (35, 184): u**4*v/w**2,
        (35, 211): -u*v/w, (35, 238): u**2*v/w**2, (36, 9): 1, (36,
        36): u, (37, 45): 1, (37, 55): -v*(u*v - w)/w**2, (37, 65):
        -v/w, (37, 103): v**2, (37, 130): -v, (37, 157): u*v**2, (37,
        184): -u*v, (38, 10): 1, (38, 22): u*v, (38, 28): u**2*v/w,
        (38, 37): u, (38, 38): u, (38, 49): v*(u**2 - v), (38, 76): v,
        (38, 244): u*v*(u*v - w)/w, (38, 271): -u**2*v*(u*v - w)/w**2,
        (38, 406): v*(u*v - w)/w, (38, 460): -u*v*(u*v - w)/w**2, (38,
        568): -u**2*v*(u*v - w)/w**2, (38, 595): -u**3*v*(u*v -
        w)/w**2, (38, 622): -u*v*(u*v - w)/w**2, (39, 12): 1, (39,
        39): u, (40, 13): 1, (40, 40): u, (41, 44): 1, (41, 69): -v/w,
        (41, 157): u**2*v**2/w, (41, 184): -u**2*v/w, (41, 299):
        u*v**3/w**2, (41, 326): -u*v**2/w**2, (41, 380): -u*v**2/w**2,
        (41, 542): u*v/w**2, (41, 596): -u*v**2/w, (42, 2): -u*v/w,
        (42, 14): 1, (42, 22): u**2*v/w, (42, 29): -u**2*v/w, (42,
        41): u, (42, 42): u, (42, 49): u**3*v/w, (42, 157): -u*v, (42,
        184): u**2*v/w, (42, 211): u, (42, 238): -u**2/w, (42, 245):
        -u*v, (42, 272): u, (42, 353): u**2*v/w, (42, 515): -u**2/w,
        (42, 569): u**2*v/w, (42, 596): u**3*v/w, (43, 16): 1, (43,
        22): u**2/w, (43, 43): u, (43, 49): u**3/w, (43, 157):
        u**2*v/w, (43, 184): -u**2/w, (44, 69): 1, (44, 103): u*v,
        (44, 130): -u, (44, 299): -u*v**2/w, (44, 326): u*v/w, (44,
        380): u*v/w, (44, 542): -u/w, (44, 596): u*v, (45, 55): u*v/w,
        (45, 65): 1, (46, 154): -v, (46, 181): 1, (47, 52): 1, (47,
        53): -v, (47, 299): -v**3/w**2, (47, 326): v**2/w**2, (47,
        380): v**2/w**2, (47, 542): -v/w**2, (47, 596): v**2/w, (48,
        50): 1, (48, 51): -v, (48, 82): u*v/w, (48, 109): -u/w, (48,
        136): u**2*v/w, (48, 157): v**2, (48, 163): -u**2/w, (48,
        184): -v, (49, 157): -v, (49, 184): 1, (50, 51): w, (51, 48):
        1, (51, 49): v, (51, 51): u, (51, 136): -u*v/w, (51, 163):
        u/w, (52, 53): w, (52, 157): u*v, (52, 184): -u, (53, 29):
        v/w, (53, 47): 1, (53, 53): u, (53, 157): u, (53, 184):
        -u**2/w, (54, 189): -v, (54, 216): 1, (55, 244): -v*w, (55,
        271): u*v, (55, 352): w, (55, 514): -u, (55, 568): u*v, (55,
        595): u**2*v, (55, 622): v*(u*v - w)/w, (56, 299): v**3/w,
        (56, 326): -v**2/w, (56, 380): -v**2/w, (56, 407): v**2, (56,
        434): -v, (56, 461): -v, (56, 488): 1, (56, 542): v/w, (56,
        623): -v, (57, 61): 1, (57, 62): -v, (58, 59): 1, (58, 60):
        -v, (58, 103): -v**3, (58, 130): v**2, (58, 208): v**2, (58,
        211): -v**4/w, (58, 235): -v, (58, 238): v**3/w, (59, 60): w,
        (59, 157): -u*v**2*w, (59, 184): u*v*w, (60, 22): -v**2, (60,
        58): 1, (60, 60): u, (60, 73): v, (60, 76): -v**3/w, (60,
        157): -u*v*w, (60, 184): u**2*v, (61, 62): w, (61, 103):
        -u*v**2, (61, 130): u*v, (61, 157): -u**2*v**2, (61, 184):
        u**2*v, (61, 208): u*v, (61, 211): -u*v**3/w, (61, 235): -u,
        (61, 238): u*v**2/w, (62, 57): 1, (62, 62): u, (62, 103):
        -u*v, (62, 130): u**2*v/w, (62, 157): -u**2*v, (62, 184):
        u**3*v/w, (62, 208): u, (62, 211): -u*v**2/w, (62, 235):
        -u**2/w, (62, 238): u**2*v**2/w**2, (63, 36): w, (64, 1):
        -v*(u*v - w)/w, (64, 11): -v, (64, 55): -v**2*(u*v - w)/w**2,
        (64, 65): -v**2/w, (64, 72): 1, (64, 157): v**2*w, (64, 184):
        -v*w, (65, 22): v*w, (65, 37): w, (65, 49): u*v*w, (65, 55):
        u**2*v/w, (65, 65): u, (65, 244): v*(u*v - w), (65, 271):
        -u*v*(u*v - w)/w, (65, 568): -u*v*(u*v - w)/w, (65, 595):
        -u**2*v*(u*v - w)/w, (65, 622): -u*v**2*(u*v - w)/w**2, (66,
        39): w, (67, 40): w, (68, 15): -v, (68, 69): -v**2/w, (68,
        71): 1, (68, 211): u**2*v**2/w, (68, 238): -u**2*v/w, (68,
        299): u*v**4/w**2, (68, 326): -u*v**3/w**2, (68, 380):
        -u*v**3/w**2, (68, 407): u*v**3/w, (68, 434): -u*v**2/w, (68,
        461): -u*v**2/w, (68, 488): u*v/w, (68, 542): u*v**2/w**2,
        (68, 623): -u*v**2/w, (69, 29): -u*v, (69, 41): w, (69, 49):
        u**2*v, (69, 69): u, (69, 103): u*w, (69, 130): -u**2, (69,
        299): -u*v, (69, 326): u, (69, 380): u**2*v/w, (69, 542):
        -u**2/w, (69, 596): u**2*v, (70, 43): w, (70, 49): u**2, (70,
        211): u**2*v/w, (70, 238): -u**2/w, (71, 15): w, (71, 69): v,
        (71, 157): u*v*w, (71, 184): -u*w, (71, 211): -u**2*v, (71,
        238): u**2, (71, 299): -u*v**3/w, (71, 326): u*v**2/w, (71,
        380): u*v**2/w, (71, 407): -u*v**2, (71, 434): u*v, (71, 461):
        u*v, (71, 488): -u, (71, 542): -u*v/w, (71, 623): u*v, (72,
        1): u*v, (72, 11): w, (72, 55): u*v**2/w, (72, 65): v, (73,
        208): -v, (73, 235): 1, (74, 79): 1, (74, 80): -v, (74, 299):
        -v**4/w**2, (74, 326): v**3/w**2, (74, 380): v**3/w**2, (74,
        407): -v**3/w, (74, 434): v**2/w, (74, 461): v**2/w, (74,
        488): -v/w, (74, 542): -v**2/w**2, (74, 623): v**2/w, (75,
        77): 1, (75, 78): -v, (75, 136): u*v, (75, 163): -u, (75,
        211): v**2, (75, 238): -v, (76, 211): -v, (76, 238): 1, (77,
        78): w, (78, 75): 1, (78, 76): v, (78, 78): u, (78, 190):
        -u*v/w, (78, 217): u/w, (79, 80): w, (79, 211): u*v, (79,
        238): -u, (80, 56): v/w, (80, 74): 1, (80, 80): u, (80, 211):
        u, (80, 238): -u**2/w, (81, 0): 1, (81, 81): u, (82, 271):
        v**2/w, (82, 325): -v/w, (82, 514): -v/w, (82, 541): 1/w, (82,
        595): v*(u*v - w)/w, (83, 137): -v, (83, 164): u*v/w, (83,
        191): 1, (83, 218): -u/w, (83, 245): -u*v, (83, 299):
        u**2*v/w, (83, 353): u**2*v/w, (83, 380): -u**2/w, (83, 569):
        u, (84, 88): 1, (84, 89): -v, (85, 19): -v, (85, 86): 1, (85,
        87): -v, (85, 100): -u*v, (85, 265): -v**3, (85, 319): v**2,
        (85, 346): u*v**2*(u*v - w)/w**2, (85, 373): u*v**3/w, (85,
        400): -u*v**2/w, (85, 589): u*v**3/w, (85, 643):
        u**2*v**2*(u*v - w)/w**2, (86, 87): w, (86, 265): u*v**3, (86,
        319): -u*v**2, (86, 373): -u*v**2, (86, 400): u*v, (86, 589):
        -u*v**2, (87, 85): 1, (87, 87): u, (87, 100): v, (87, 265):
        u*v**2, (87, 319): -u**2*v**2/w, (87, 373): -u**2*v**2/w, (87,
        400): u**2*v/w, (87, 427): -v**2, (87, 481): u*v**2/w, (87,
        589): -u*v, (87, 643): -u*v**2*(u*v - w)/w**2, (88, 19): -u,
        (88, 89): w, (88, 100): -u**2, (88, 265): u*v**2*(u*v - w)/w,
        (88, 319): -u*v*(u*v - w)/w, (88, 346): u**2*v*(u*v - w)/w**2,
        (88, 643): u**3*v*(u*v - w)/w**2, (89, 84): 1, (89, 89): u,
        (89, 127): u/w, (89, 265): u*v*(u*v - w)/w, (89, 319):
        -u**2*v*(u*v - w)/w**2, (89, 373): -u**2*v*(u*v - w)/w**2,
        (90, 414): -v, (90, 468): 1, (91, 99): 1, (91, 265): -v**3,
        (91, 319): v**2, (91, 373): v**2, (91, 400): -v, (91, 406):
        -v*(u*v - w)/w, (91, 416): -v, (91, 460): u*v*(u*v - w)/w**2,
        (91, 470): u*v/w, (91, 589): v**2, (91, 622): -u*v*(u*v -
        w)**2/w**3, (91, 632): -u*v*(u*v - w)/w**2, (92, 82):
        u**2*v/w, (92, 92): u, (92, 103): -v**2, (92, 271): -v**2*(u*v
        - w)/w**2, (92, 415): -v, (92, 427): -v*(u*v - w), (92, 469):
        1, (92, 595): -v*(u*v - w)**2/w**2, (92, 622): -u*v*(u*v -
        w)/w**2, (92, 643): u*v*(u*v - w)/w, (93, 417): -v, (93, 471):
        1, (94, 418): -v, (94, 472): 1, (95, 22): -u**2*v/w, (95, 98):
        1, (95, 103): -u**3*v/w, (95, 137): -u*v**2/w, (95, 164):
        u**2*v**2/w**2, (95, 191): u*v/w, (95, 218): -u**2*v/w**2,
        (95, 245): -u**2*v**2/w, (95, 299): u**3*v**2/w**2, (95, 353):
        u**3*v**2/w**2, (95, 380): -u**3*v/w**2, (95, 420): -v, (95,
        474): u*v/w, (95, 569): u**2*v/w, (95, 636): -u*v*(u*v -
        w)/w**2, (96, 96): u, (96, 130): -u*v/w, (96, 265): u*w, (96,
        319): -u**2, (96, 373): -u**2, (96, 400): u**3/w, (96, 407):
        u*v**2/w, (96, 419): -v, (96, 427): -u**2*v**2/w, (96, 434):
        -u*v/w, (96, 461): -u*v/w, (96, 473): 1, (96, 481): u**2*v/w,
        (96, 488): u/w, (96, 589): -u**2, (96, 596): u*v**2/w, (96,
        623): -u*v/w, (97, 22): -u**2/w, (97, 103): -u**3/w, (97,
        421): -v, (97, 427): -u**2*v/w, (97, 475): 1, (97, 481):
        u**2/w, (98, 22): u**2, (98, 103): u**3, (98, 137): u*v, (98,
        164): -u**2*v/w, (98, 191): -u, (98, 218): u**2/w, (98, 245):
        u**2*v, (98, 265): -u*v**2, (98, 299): -u**3*v/w, (98, 319):
        u*v, (98, 353): -u**3*v/w, (98, 373): u*v, (98, 380): u**3/w,
        (98, 400): -u, (98, 420): w, (98, 474): -u, (98, 569): -u**2,
        (98, 589): u*v, (98, 636): u*(u*v - w)/w, (99, 406): u*v, (99,
        416): w, (99, 460): -u**2*v/w, (99, 470): -u, (99, 622):
        u**2*v*(u*v - w)/w**2, (99, 632): u*(u*v - w)/w, (100, 19): 1,
        (100, 100): u, (101, 106): 1, (101, 107): -v, (101, 137):
        v**2/w, (101, 164): -u*v**2/w**2, (101, 191): -v/w, (101,
        218): u*v/w**2, (101, 245): u*v**2/w, (101, 299):
        -u**2*v**2/w**2, (101, 353): -u**2*v**2/w**2, (101, 380):
        u**2*v/w**2, (101, 569): -u*v/w, (102, 22): -v, (102, 103):
        -u*v, (102, 104): 1, (102, 105): -v, (102, 244): -u*v**2/w,
        (102, 298): u*v/w, (102, 352): u*v/w, (102, 379): -u/w, (102,
        568): u*v/w, (103, 22): 1, (103, 103): u, (104, 105): w, (105,
        1): u/w, (105, 82): u**2/w, (105, 102): 1, (105, 103): v,
        (105, 105): u, (106, 22): -u, (106, 103): -u**2, (106, 107):
        w, (107, 83): v/w, (107, 101): 1, (107, 107): u, (107, 130):
        u/w, (108, 81): w, (109, 136): v**2, (109, 163): -v, (109,
        190): -v, (109, 217): 1, (109, 271): v**3/w, (109, 325):
        -v**2/w, (109, 514): -v**2/w, (109, 541): v/w, (109, 595):
        v**2*(u*v - w)/w, (110, 245): -v*w, (110, 299): u*v, (110,
        353): u*v, (110, 380): -u, (110, 569): w, (111, 115): 1, (111,
        116): -v, (112, 100): -v*w, (112, 113): 1, (112, 114): -v,
        (112, 292): -v**3, (112, 346): u*v**3/w, (112, 535): u*v**3/w,
        (112, 562): -u*v**2/w, (112, 616): -v**2*(u*v - w), (112,
        643): u*v**2*(u*v - w)/w, (113, 114): w, (113, 292): u*v**3,
        (113, 346): -u*v**2, (113, 535): -u*v**2, (113, 562): u*v,
        (113, 616): u*v**2*(u*v - w), (114, 112): 1, (114, 114): u,
        (114, 127): v, (114, 292): u*v**2, (114, 346): -u**2*v**2/w,
        (114, 373): -u*v**2*(u*v - w)/w, (114, 454): -v**2, (114,
        508): u*v**2/w, (114, 535): -u*v, (114, 562): u**2*v/w, (114,
        616): v**3, (114, 643): -u*v**3/w, (115, 100): -u*w, (115,
        116): w, (115, 292): u*v**2*(u*v - w)/w, (115, 616): u*v*(u*v
        - w)**2/w, (115, 643): u**2*v*(u*v - w)/w, (116, 19): u, (116,
        111): 1, (116, 116): u, (116, 127): u*v/w, (116, 292):
        u*v*(u*v - w)/w, (116, 346): -u**2*v*(u*v - w)/w**2, (116,
        373): -u**2*v**2*(u*v - w)/w**2, (117, 441): -v, (117, 495):
        1, (117, 603): v**2, (117, 630): -v, (118, 126): 1, (118,
        292): -v**3, (118, 346): v**2, (118, 433): -v*(u*v - w)/w,
        (118, 443): -v, (118, 487): u*v*(u*v - w)/w**2, (118, 497):
        u*v/w, (118, 535): v**2, (118, 562): -v, (118, 595): v**2*(u*v
        - w)/w, (118, 605): v**2, (118, 616): -v**2*(u*v - w), (118,
        622): -u*v**2*(u*v - w)/w**2, (118, 632): -u*v**2/w, (119,
        109): u**2*v/w, (119, 119): u, (119, 130): -v**2, (119, 136):
        -v**2*(u*v - w)/w, (119, 163): v*(u*v - w)/w, (119, 271):
        -v**3*(u*v - w)/w**2, (119, 442): -v, (119, 454): -v*(u*v -
        w), (119, 496): 1, (119, 595): -v**2*(u*v - w)**2/w**2, (119,
        604): v**2, (119, 616): v**2*(u*v - w), (119, 622):
        -u*v**2*(u*v - w)/w**2, (119, 631): -v, (120, 444): -v, (120,
        498): 1, (120, 606): v**2, (120, 633): -v, (121, 445): -v,
        (121, 499): 1, (121, 607): v**2, (121, 634): -v, (122, 103):
        -u**2*v, (122, 125): 1, (122, 245): -u*v**2, (122, 299):
        u**2*v**2/w, (122, 353): u**2*v**2/w, (122, 380): -u**2*v/w,
        (122, 447): -v, (122, 501): u*v/w, (122, 569): u*v, (122,
        609): v**2, (122, 636): -u*v**2/w, (123, 22): -u*v, (123, 29):
        -u*v, (123, 56): u, (123, 123): u, (123, 130): -u*v**2/w,
        (123, 292): u*w, (123, 346): -u**2, (123, 446): -v, (123,
        454): -u**2*v**2/w, (123, 500): 1, (123, 508): u**2*v/w, (123,
        535): -u**2, (123, 562): u**3/w, (123, 608): v**2, (123, 616):
        u**2*v**3/w, (123, 635): -v, (123, 643): -u**2*v**2/w, (124,
        103): -u**2, (124, 448): -v, (124, 454): -u**2*v/w, (124,
        502): 1, (124, 508): u**2/w, (124, 610): v**2, (124, 616):
        u**2*v**2/w, (124, 637): -v, (124, 643): -u**2*v/w, (125,
        103): u**2*w, (125, 245): u*v*w, (125, 292): -u*v**2, (125,
        299): -u**2*v, (125, 346): u*v, (125, 353): -u**2*v, (125,
        380): u**2, (125, 447): w, (125, 501): -u, (125, 535): u*v,
        (125, 562): -u, (125, 569): -u*w, (125, 609): -v*w, (125,
        616): -u*v*(u*v - w), (125, 636): u*v, (126, 433): u*v, (126,
        443): w, (126, 487): -u**2*v/w, (126, 497): -u, (126, 595):
        -u*v**2, (126, 605): -v*w, (126, 622): u**2*v**2/w, (126,
        632): u*v, (127, 100): w, (128, 133): 1, (128, 134): -v, (128,
        245): v**2, (128, 299): -u*v**2/w, (128, 353): -u*v**2/w,
        (128, 380): u*v/w, (128, 569): -v, (129, 103): -v*w, (129,
        131): 1, (129, 132): -v, (129, 271): -u*v**2/w, (129, 325):
        u*v/w, (129, 514): u*v/w, (129, 541): -u/w, (129, 595):
        -u*v*(u*v - w)/w, (130, 103): w, (131, 132): w, (132, 82): u,
        (132, 129): 1, (132, 130): v, (132, 132): u, (133, 103): -u*w,
        (133, 134): w, (134, 22): u, (134, 110): v/w, (134, 128): 1,
        (134, 130): u*v/w, (134, 134): u, (135, 27): 1, (135, 135): u,
        (136, 271): -u*v/w, (136, 460): -v/w, (136, 487): 1/w, (136,
        514): u/w, (136, 568): -u*v/w, (136, 595): -u**2*v/w, (136,
        622): -v/w, (137, 83): 1, (137, 110): -u/w, (137, 137): u,
        (137, 164): -u**2/w, (137, 299): -u*v/w, (137, 353): -u**3/w,
        (137, 434): -u**2/w, (137, 596): u, (138, 142): 1, (138, 143):
        -v, (139, 46): -v, (139, 140): 1, (139, 141): -v, (139, 154):
        -u*v, (139, 265): u*v**2, (139, 292): -u**2*v**2/w, (139,
        346): -u*v**3/w**2, (139, 373): -u**2*v**2/w, (139, 427):
        v**2, (139, 454): -u*v**2/w, (139, 481): -u*v**2/w, (139,
        589): -u**2*v**2/w, (139, 616): -u*v**2*(u**2 - v)/w, (139,
        643): -u**2*v**3/w**2, (140, 141): w, (140, 265): -u**2*v**2,
        (140, 373): u**2*v, (140, 427): -u*v**2, (140, 454): u*v,
        (140, 616): -u*v**2, (141, 139): 1, (141, 141): u, (141, 154):
        v, (141, 265): -v**2, (141, 292): u*v**2/w, (141, 319):
        u*v**2/w, (141, 373): u**3*v/w, (141, 454): u**2*v/w, (141,
        589): u*v**2/w, (141, 616): u*v*(u*v - w)/w, (141, 643):
        u*v**3/w**2, (142, 46): -u, (142, 143): w, (142, 154): -u**2,
        (142, 265): -u**2*v*(u*v - w)/w, (142, 292): -u**3*v/w, (142,
        346): -u**2*v**2/w**2, (142, 427): -u*v*(u*v - w)/w, (142,
        481): -u**2*v/w, (142, 589): -u**3*v/w, (142, 616): -u**4*v/w,
        (142, 643): -u**3*v**2/w**2, (143, 138): 1, (143, 143): u,
        (143, 181): u/w, (143, 319): u*v*(u*v - w)/w**2, (143, 373):
        u**4*v/w**2, (143, 400): u**2*v/w**2, (143, 454): u**3*v/w**2,
        (144, 252): -v, (144, 279): 1, (145, 153): 1, (145, 244):
        -v*(u*v - w)/w, (145, 254): -v, (145, 265): u*v**2, (145,
        271): u*v*(u*v - w)/w**2, (145, 281): u*v/w, (145, 373): -u*v,
        (145, 427): v**2, (145, 454): -v, (145, 568): u*v*(u*v -
        w)/w**2, (145, 578): u*v/w, (145, 595): u**2*v*(u*v - w)/w**2,
        (145, 605): u**2*v/w, (145, 616): v**2, (145, 622):
        u*v**2*(u*v - w)/w**3, (145, 632): u*v**2/w**2, (146, 136):
        u**2*v/w, (146, 146): u, (146, 157): -v**2, (146, 253): -v,
        (146, 265): -v*(u*v - w), (146, 271): u**2*v**2/w**2, (146,
        280): 1, (146, 325): v**2/w**2, (146, 460): u*v**2/w**2, (146,
        568): u**2*v**2/w**2, (146, 589): -u*v, (146, 595):
        u**3*v**2/w**2, (146, 616): -u**2*v, (146, 622): v*(2*u*v -
        w)/w**2, (146, 643): -u*v**2/w, (147, 255): -v, (147, 282): 1,
        (148, 256): -v, (148, 283): 1, (149, 49): -u**2*v/w, (149,
        83): u*v/w, (149, 110): -u**2*v/w**2, (149, 137): u**2*v/w,
        (149, 152): 1, (149, 157): -u**3*v/w, (149, 164):
        -u**3*v/w**2, (149, 258): -v, (149, 285): u*v/w, (149, 299):
        -u**2*v**2/w**2, (149, 353): -u**4*v/w**2, (149, 434):
        -u**3*v/w**2, (149, 582): u*v/w, (149, 596): u**2*v/w, (149,
        609): u**2*v/w, (149, 636): u*v**2/w**2, (150, 150): u, (150,
        184): -u*v/w, (150, 245): u*v**2/w, (150, 257): -v, (150,
        265): -u**2*v**2/w, (150, 272): -u*v/w, (150, 284): 1, (150,
        292): u**2*v/w, (150, 319): u, (150, 353): -u*v/w, (150, 400):
        -u**2/w, (150, 515): u/w, (150, 569): -u*v/w, (150, 596):
        -u**2*v/w, (150, 616): -u**2, (151, 49): -u**2/w, (151, 157):
        -u**3/w, (151, 259): -v, (151, 265): -u**2*v/w, (151, 286): 1,
        (151, 292): u**2/w, (152, 49): u**2, (152, 83): -u, (152,
        110): u**2/w, (152, 137): -u**2, (152, 157): u**3, (152, 164):
        u**3/w, (152, 258): w, (152, 265): u**2*v, (152, 285): -u,
        (152, 299): u**2*v/w, (152, 353): u**4/w, (152, 373): -u**2,
        (152, 427): u*v, (152, 434): u**3/w, (152, 454): -u, (152,
        582): -u, (152, 596): -u**2, (152, 609): -u**2, (152, 616):
        u*v, (152, 636): -u*v/w, (153, 244): u*v, (153, 254): w, (153,
        271): -u**2*v/w, (153, 281): -u, (153, 568): -u**2*v/w, (153,
        578): -u, (153, 595): -u**3*v/w, (153, 605): -u**2, (153,
        622): -u**2*v**2/w**2, (153, 632): -u*v/w, (154, 46): 1, (154,
        154): u, (155, 83): -v/w, (155, 110): u*v/w**2, (155, 137):
        -u*v/w, (155, 160): 1, (155, 161): -v, (155, 164):
        u**2*v/w**2, (155, 299): u*v**2/w**2, (155, 353): u**3*v/w**2,
        (155, 434): u**2*v/w**2, (155, 596): -u*v/w, (156, 49): -v,
        (156, 157): -u*v, (156, 158): 1, (156, 159): -v, (156, 244):
        u**2*v/w, (156, 352): -u**2/w, (156, 406): u*v/w, (156, 433):
        -u/w, (156, 595): u*v/w, (157, 49): 1, (157, 157): u, (158,
        159): w, (159, 28): u/w, (159, 136): u**2/w, (159, 156): 1,
        (159, 157): v, (159, 159): u, (160, 49): -u, (160, 157):
        -u**2, (160, 161): w, (161, 137): v/w, (161, 155): 1, (161,
        161): u, (161, 184): u/w, (162, 135): w, (163, 82): -v, (163,
        109): 1, (163, 136): -u*v, (163, 163): u, (163, 271):
        -u*v**2/w, (163, 460): -v**2/w, (163, 487): v/w, (163, 514):
        u*v/w, (163, 568): -u*v**2/w, (163, 595): -u**2*v**2/w, (163,
        622): -v**2/w, (164, 299): -v, (164, 353): -u**2, (164, 434):
        -u, (164, 596): w, (165, 169): 1, (165, 170): -v, (166, 154):
        -v*w, (166, 167): 1, (166, 168): -v, (166, 346): -v**3/w,
        (166, 508): -u*v**2/w, (166, 535): -u**2*v**2/w, (166, 643):
        -v**2*(u*v - w)/w, (167, 168): w, (167, 292): -u**2*v**2,
        (167, 481): -u*v**2, (167, 508): u*v, (167, 535): u**2*v,
        (167, 589): -u**2*v**2, (167, 616): -u**3*v**2, (167, 643):
        -u*v**2, (168, 166): 1, (168, 168): u, (168, 181): v, (168,
        346): u*v**2/w, (168, 373): v**2*(u**3 - w)/w, (168, 400):
        u*v**2/w, (168, 454): u**2*v**2/w, (168, 535): u*v**2/w, (168,
        562): -u*v/w, (168, 643): v**3/w, (169, 154): -u*w, (169,
        170): w, (169, 292): -u**3*v**2/w, (169, 346): -u*v**2/w,
        (169, 481): -u**2*v**2/w, (169, 589): -u**3*v**2/w, (169,
        616): -u**4*v**2/w, (169, 643): -u*v*(2*u*v - w)/w, (170, 46):
        u, (170, 165): 1, (170, 170): u, (170, 181): u*v/w, (170,
        346): u*v*(u*v - w)/w**2, (170, 373): u**4*v**2/w**2, (170,
        400): u**2*v**2/w**2, (170, 454): u**3*v**2/w**2, (171, 360):
        -v, (171, 522): 1, (171, 576): -v, (171, 603): -u*v, (172,
        180): 1, (172, 292): u*v**2, (172, 352): -v*(u*v - w)/w, (172,
        362): -v, (172, 481): v**2, (172, 508): -v, (172, 514):
        u*v*(u*v - w)/w**2, (172, 524): u*v/w, (172, 535): -u*v, (172,
        589): u*v**2, (172, 616): u**2*v**2, (172, 622): v**2*(u*v -
        w)/w**2, (172, 632): v**2/w, (172, 643): v**2, (173, 82):
        u*v**2/w, (173, 109): -u*v/w, (173, 136): u**2*v**2/w, (173,
        173): u, (173, 184): -v**2, (173, 190): v**2/w, (173, 217):
        -v/w, (173, 271): u**2*v**3/w**2, (173, 325): v**3/w**2, (173,
        361): -v, (173, 373): -v*(u*v - w), (173, 460): u*v**3/w**2,
        (173, 523): 1, (173, 568): u**2*v**3/w**2, (173, 577): -v,
        (173, 589): -u*v**2, (173, 595): u**3*v**3/w**2, (173, 604):
        -u*v, (173, 616): -u**2*v**2, (173, 622): v**2*(2*u*v -
        w)/w**2, (173, 643): -v**2, (174, 363): -v, (174, 525): 1,
        (174, 579): -v, (174, 606): -u*v, (175, 364): -v, (175, 526):
        1, (175, 580): -v, (175, 607): -u*v, (176, 157): -u**2*v,
        (176, 179): 1, (176, 299): -u*v**2/w, (176, 353): -u**3*v/w,
        (176, 366): -v, (176, 434): -u**2*v/w, (176, 528): u*v/w,
        (176, 596): u*v, (176, 636): v**2/w, (177, 2): u, (177, 29):
        u**2, (177, 49): -u*v, (177, 177): u, (177, 184): -u*v**2/w,
        (177, 346): u, (177, 365): -v, (177, 373): -u**2*v**2/w, (177,
        527): 1, (177, 535): u**2*v/w, (177, 562): -u**2/w, (177,
        581): -v, (177, 589): -u**2*v**2/w, (177, 608): -u*v, (177,
        616): -u**3*v**2/w, (178, 157): -u**2, (178, 367): -v, (178,
        373): -u**2*v/w, (178, 529): 1, (178, 535): u**2/w, (178,
        583): -v, (178, 589): -u**2*v/w, (178, 610): -u*v, (178, 616):
        -u**3*v/w, (179, 157): u**2*w, (179, 292): u**2*v, (179, 299):
        u*v, (179, 353): u**3, (179, 366): w, (179, 434): u**2, (179,
        481): u*v, (179, 508): -u, (179, 528): -u, (179, 535): -u**2,
        (179, 589): u**2*v, (179, 596): -u*w, (179, 616): u**3*v,
        (179, 636): -v, (179, 643): u*v, (180, 352): u*v, (180, 362):
        w, (180, 514): -u**2*v/w, (180, 524): -u, (180, 622):
        -u*v**2/w, (180, 632): -v, (181, 154): w, (182, 187): 1, (182,
        188): -v, (182, 299): v**2/w, (182, 353): u**2*v/w, (182,
        434): u*v/w, (182, 596): -v, (183, 157): -v*w, (183, 185): 1,
        (183, 186): -v, (183, 271): u**2*v/w, (183, 460): u*v/w, (183,
        487): -u/w, (183, 514): -u**2/w, (183, 568): u**2*v/w, (183,
        595): u**3*v/w, (183, 622): u*v/w, (184, 157): w, (185, 186):
        w, (186, 136): u, (186, 183): 1, (186, 184): v, (186, 186): u,
        (187, 157): -u*w, (187, 188): w, (188, 49): u, (188, 164):
        v/w, (188, 182): 1, (188, 184): u*v/w, (188, 188): u, (189,
        54): 1, (189, 189): u, (190, 271): -v, (190, 514): 1, (190,
        568): -v, (190, 595): -u*v, (190, 622): -v**2/w, (191, 137):
        w, (191, 164): -u, (191, 299): -u*v**2/w, (191, 353): -u**2,
        (191, 407): -u*v, (191, 623): u, (192, 196): 1, (192, 197):
        -v, (193, 73): -v, (193, 194): 1, (193, 195): -v, (193, 208):
        -u*v, (193, 265): v**2*w, (193, 292): -u*v**2, (193, 346):
        -u*v**4/w**2, (193, 373): -u*v**2, (193, 481): -u*v**3/w,
        (193, 589): -u**2*v**3/w, (193, 616): -u**2*v**2, (193, 643):
        -u*v**3*(u*v - w)/w**2, (194, 195): w, (194, 265): -u*v**2*w,
        (194, 373): u*v*w, (194, 643): -u*v**2, (195, 193): 1, (195,
        195): u, (195, 208): v, (195, 319): v**2*(u*v - w)/w, (195,
        346): u*v**2/w, (195, 373): u**2*v, (195, 427): u*v**2, (195,
        589): u*v**3/w, (195, 616): u*v**2, (195, 643): u*v*(v**3 -
        w**2)/w**2, (196, 73): -u, (196, 197): w, (196, 208): -u**2,
        (196, 265): -u*v*(u*v - w), (196, 292): -u**2*v, (196, 346):
        -u**2*v**3/w**2, (196, 481): -u**2*v**2/w, (196, 589):
        -u**3*v**2/w, (196, 616): -u**3*v, (196, 643):
        -u**3*v**3/w**2, (197, 192): 1, (197, 197): u, (197, 235):
        u/w, (197, 319): u*v**2*(u*v - w)/w**2, (197, 373): u**3*v/w,
        (197, 400): u**2*v**2/w**2, (197, 427): u*v*(u*v - w)/w, (197,
        454): u**2*v/w, (198, 306): -v, (198, 333): 1, (199, 207): 1,
        (199, 265): v**2*w, (199, 298): -v*(u*v - w)/w, (199, 308):
        -v, (199, 325): u*v*(u*v - w)/w**2, (199, 335): u*v/w, (199,
        373): -v*w, (199, 568): u*v**2*(u*v - w)/w**2, (199, 578):
        u*v**2/w, (199, 595): u*v*(u*v - w)/w, (199, 605): u*v, (199,
        622): u*v**3*(u*v - w)/w**3, (199, 632): u*v**3/w**2, (199,
        643): v**2, (200, 190): u**2*v/w, (200, 200): u, (200, 211):
        -v**2, (200, 271): u*v**2/w, (200, 307): -v, (200, 319):
        -v*(u*v - w), (200, 325): v**3/w**2, (200, 334): 1, (200,
        460): v**2/w, (200, 568): v*(2*u*v - w)/w, (200, 589):
        -u*v**2, (200, 595): u**2*v**2/w, (200, 616): -u*v*w, (200,
        622): v**2*(2*u*v - w)/w**2, (200, 643): -u*v**3/w, (201,
        309): -v, (201, 336): 1, (202, 310): -v, (202, 337): 1, (203,
        76): -u**2*v/w, (203, 137): u*v, (203, 164): -u**2*v/w, (203,
        206): 1, (203, 211): -u**3*v/w, (203, 299): -u**2*v**3/w**2,
        (203, 312): -v, (203, 339): u*v/w, (203, 353): -u**3*v/w,
        (203, 407): -u**2*v**2/w, (203, 582): u*v**2/w, (203, 609):
        u*v, (203, 623): u**2*v/w, (203, 636): u*v**3/w**2, (204,
        204): u, (204, 238): -u*v/w, (204, 299): u*v**2/w, (204, 311):
        -v, (204, 319): -u*v*(u*v - w)/w, (204, 326): -u*v/w, (204,
        338): 1, (204, 346): u**2*v/w, (204, 380): -u*v/w, (204, 400):
        -u**2*v/w, (204, 427): u*w, (204, 454): -u**2, (204, 542):
        u/w, (204, 596): -u*v, (204, 643): -u**2, (205, 76): -u**2/w,
        (205, 211): -u**3/w, (205, 313): -v, (205, 319): -u**2*v/w,
        (205, 340): 1, (205, 346): u**2/w, (206, 76): u**2, (206,
        137): -u*w, (206, 164): u**2, (206, 211): u**3, (206, 265):
        u*v*w, (206, 299): u**2*v**2/w, (206, 312): w, (206, 339): -u,
        (206, 353): u**3, (206, 373): -u*w, (206, 407): u**2*v, (206,
        582): -u*v, (206, 609): -u*w, (206, 623): -u**2, (206, 636):
        -u*v**2/w, (206, 643): u*v, (207, 298): u*v, (207, 308): w,
        (207, 325): -u**2*v/w, (207, 335): -u, (207, 568):
        -u**2*v**2/w, (207, 578): -u*v, (207, 595): -u**2*v, (207,
        605): -u*w, (207, 622): -u**2*v**3/w**2, (207, 632):
        -u*v**2/w, (208, 73): 1, (208, 208): u, (209, 137): -v, (209,
        164): u*v/w, (209, 214): 1, (209, 215): -v, (209, 299):
        u*v**3/w**2, (209, 353): u**2*v/w, (209, 407): u*v**2/w, (209,
        623): -u*v/w, (210, 76): -v, (210, 211): -u*v, (210, 212): 1,
        (210, 213): -v, (210, 244): u*v, (210, 352): -u, (210, 622):
        u*v/w, (211, 76): 1, (211, 211): u, (212, 213): w, (213, 55):
        u/w, (213, 190): u**2/w, (213, 210): 1, (213, 211): v, (213,
        213): u, (214, 76): -u, (214, 211): -u**2, (214, 215): w,
        (215, 191): v/w, (215, 209): 1, (215, 215): u, (215, 238):
        u/w, (216, 189): w, (217, 136): -v*w, (217, 163): w, (217,
        271): -v**2, (217, 514): v, (217, 568): -v**2, (217, 595):
        -u*v**2, (217, 622): -v**3/w, (218, 299): -v**2, (218, 353):
        -u*w, (218, 407): -v*w, (218, 623): w, (219, 223): 1, (219,
        224): -v, (220, 208): -v*w, (220, 221): 1, (220, 222): -v,
        (220, 346): -v**4/w, (220, 481): -v**3, (220, 535): -u*v**2,
        (220, 589): -v**2*(u*v - w), (220, 643): -v**3*(u*v - w)/w,
        (221, 222): w, (221, 292): -u*v**2*w, (221, 535): u*v*w, (221,
        589): -u*v**2*w, (221, 616): -u**2*v**2*w, (221, 643):
        -u*v**3, (222, 220): 1, (222, 222): u, (222, 235): v, (222,
        346): u*v**3/w, (222, 373): u**2*v**2, (222, 400): v**2*(u*v -
        w)/w, (222, 454): u*v**2, (222, 481): u*v**2, (222, 508):
        -u*v, (222, 589): v**3, (222, 643): v**4/w, (223, 208): -u*w,
        (223, 224): w, (223, 292): -u**2*v**2, (223, 346): -u*v**3/w,
        (223, 481): -u*v**2, (223, 589): -u*v*(2*u*v - w), (223, 616):
        -u**3*v**2, (223, 643): -u*v**2*(2*u*v - w)/w, (224, 73): u,
        (224, 219): 1, (224, 224): u, (224, 235): u*v/w, (224, 346):
        u*v**2*(u*v - w)/w**2, (224, 373): u**3*v**2/w, (224, 400):
        u**2*v**3/w**2, (224, 454): u**2*v**2/w, (224, 481): u*v*(u*v
        - w)/w, (225, 387): -v, (225, 549): 1, (225, 603): -v*w, (226,
        234): 1, (226, 292): v**2*w, (226, 379): -v*(u*v - w)/w, (226,
        389): -v, (226, 535): -v*w, (226, 541): u*v*(u*v - w)/w**2,
        (226, 551): u*v/w, (226, 568): v**2*(u*v - w)/w, (226, 578):
        v**2, (226, 589): v**2*w, (226, 616): u*v**2*w, (226, 622):
        v**3*(u*v - w)/w**2, (226, 632): v**3/w, (226, 643): v**3,
        (227, 82): v**2, (227, 109): -v, (227, 136): u*v**2, (227,
        163): -u*v, (227, 190): v**3/w, (227, 217): v*(u**2 - v)/w,
        (227, 227): u, (227, 238): -v**2, (227, 271): u*v**3/w, (227,
        325): v**4/w**2, (227, 388): -v, (227, 400): -v*(u*v - w),
        (227, 460): v**3/w, (227, 550): 1, (227, 568): v**2*(2*u*v -
        w)/w, (227, 589): -v**2*w, (227, 595): u**2*v**3/w, (227,
        604): -v*w, (227, 616): -u*v**2*w, (227, 622): v**3*(2*u*v -
        w)/w**2, (227, 643): -v**3, (228, 390): -v, (228, 552): 1,
        (228, 606): -v*w, (229, 391): -v, (229, 553): 1, (229, 607):
        -v*w, (230, 211): -u**2*v, (230, 233): 1, (230, 299):
        -u*v**3/w, (230, 353): -u**2*v, (230, 393): -v, (230, 407):
        -u*v**2, (230, 555): u*v/w, (230, 582): v**2, (230, 623): u*v,
        (230, 636): v**3/w, (231, 29): u*w, (231, 76): -u*v, (231,
        231): u, (231, 238): -u*v**2/w, (231, 346): u*v, (231, 392):
        -v, (231, 400): -u**2*v**2/w, (231, 481): u*w, (231, 508):
        -u**2, (231, 554): 1, (231, 608): -v*w, (231, 616):
        -u**2*v**2, (232, 211): -u**2, (232, 394): -v, (232, 400):
        -u**2*v/w, (232, 556): 1, (232, 562): u**2/w, (232, 610):
        -v*w, (232, 616): -u**2*v, (233, 211): u**2*w, (233, 292):
        u*v*w, (233, 299): u*v**2, (233, 353): u**2*w, (233, 393): w,
        (233, 407): u*v*w, (233, 535): -u*w, (233, 555): -u, (233,
        582): -v*w, (233, 589): u*v*w, (233, 616): u**2*v*w, (233,
        623): -u*w, (233, 636): -v**2, (233, 643): u*v**2, (234, 379):
        u*v, (234, 389): w, (234, 541): -u**2*v/w, (234, 551): -u,
        (234, 568): -u*v**2, (234, 578): -v*w, (234, 622): -u*v**3/w,
        (234, 632): -v**2, (235, 208): w, (236, 241): 1, (236, 242):
        -v, (236, 299): v**3/w, (236, 353): u*v, (236, 407): v**2,
        (236, 623): -v, (237, 211): -v*w, (237, 239): 1, (237, 240):
        -v, (237, 271): u*v, (237, 514): -u, (237, 568): u*v, (237,
        595): u**2*v, (237, 622): u*v**2/w, (238, 211): w, (239, 240):
        w, (240, 190): u, (240, 237): 1, (240, 238): v, (240, 240): u,
        (241, 211): -u*w, (241, 242): w, (242, 76): u, (242, 218):
        v/w, (242, 236): 1, (242, 238): u*v/w, (242, 242): u, (243,
        243): u, (243, 405): 1, (244, 55): 1/w, (244, 190): u/w, (244,
        244): u, (244, 325): u*v/w**2, (244, 460): u/w, (244, 568):
        u**2/w, (244, 622): u**2*v/w**2, (245, 110): 1/w, (245, 164):
        u/w, (245, 245): u, (245, 353): u**2/w, (245, 434): u/w, (246,
        250): 1, (246, 251): -v, (247, 248): 1, (247, 249): -v, (247,
        262): -u*v, (247, 292): u*v**2/w, (247, 373): u*v**2/w, (247,
        424): -v, (247, 454): v**2/w, (247, 616): v**2*(u**2 - v)/w,
        (248, 49): u*v, (248, 157): u**2*v, (248, 249): w, (248, 265):
        u**3*v, (248, 346): u**2*v/w, (248, 427): u**2*v, (248, 643):
        u**3*v/w, (249, 184): -u*v/w, (249, 247): 1, (249, 249): u,
        (249, 262): v, (249, 292): -v**2/w, (249, 319): -u**2*v/w,
        (249, 373): -u**2*v/w, (249, 616): -u*v**2/w, (250, 49):
        u**2*v/w, (250, 157): u**3*v/w, (250, 251): w, (250, 262):
        -u**2, (250, 265): u**4*v/w, (250, 292): u**2*v/w, (250, 346):
        u**3*v/w**2, (250, 373): u**2*v/w, (250, 424): -u, (250, 427):
        u**3*v/w, (250, 454): u*v/w, (250, 616): u*v*(u**2 - v)/w,
        (250, 643): u**4*v/w**2, (251, 184): -u**2*v/w**2, (251, 246):
        1, (251, 251): u, (251, 316): u/w, (251, 319): -u**3*v/w**2,
        (251, 373): -u**3*v/w**2, (251, 616): -u*v/w, (252, 144): 1,
        (252, 252): u, (252, 630): u/w, (253, 49): -v, (253, 157):
        -u*v, (253, 261): 1, (253, 265): -u**2*v, (253, 271): -v*(u*v
        - w)/w**2, (253, 281): -v/w, (253, 346): -u*v/w, (253, 427):
        -u*v, (253, 595): -u*v*(u*v - w)/w**2, (253, 605): -u*v/w,
        (253, 643): -u**2*v/w, (254, 55): -u*v/w**2, (254, 145): 1,
        (254, 157): u*v, (254, 190): -u**2*v/w**2, (254, 253): u,
        (254, 254): u, (254, 265): v*(u**2 - v), (254, 292): v, (254,
        325): -u*v*(u*v + w)/w**3, (254, 352): -v/w, (254, 460):
        -u**2*v/w**2, (254, 568): -u**3*v/w**2, (254, 616): u*v, (254,
        622): -v*(u**3*v + u**2*w - v*w)/w**3, (254, 631): u/w, (254,
        643): u**2*v/w, (255, 147): 1, (255, 255): u, (255, 633): u/w,
        (256, 148): 1, (256, 256): u, (256, 634): u/w, (257, 110):
        u*v/w**2, (257, 164): u**2*v/w**2, (257, 245): u**2*v/w, (257,
        260): 1, (257, 265): -u**3*v/w, (257, 285): -v/w, (257, 353):
        u**3*v/w**2, (257, 427): -u**2*v/w, (257, 434): u**2*v/w**2,
        (257, 609): -u*v/w, (258, 137): -u*v/w, (258, 149): 1, (258,
        157): u**2*v/w, (258, 191): u/w, (258, 245): -u**2*v/w, (258,
        257): u, (258, 258): u, (258, 265): u**3*v/w, (258, 299):
        u**2/w, (258, 319): -u*v/w, (258, 569): u**2/w, (258, 616): u,
        (258, 635): u/w, (258, 643): u**3*v/w**2, (259, 151): 1, (259,
        157): u**2/w, (259, 259): u, (259, 427): -u**2/w, (259, 637):
        u/w, (259, 643): u**3/w**2, (260, 49): -u, (260, 110): -u/w,
        (260, 157): -u**2, (260, 164): -u**2/w, (260, 245): -u**2,
        (260, 285): 1, (260, 346): -u**2/w, (260, 353): -u**3/w, (260,
        434): -u**2/w, (260, 609): u, (260, 643): -u**3/w, (261, 271):
        u*v/w, (261, 281): 1, (261, 595): u**2*v/w, (261, 605): u,
        (262, 262): u, (262, 424): 1, (263, 110): -v/w**2, (263, 164):
        -u*v/w**2, (263, 245): -u*v/w, (263, 268): 1, (263, 269): -v,
        (263, 353): -u**2*v/w**2, (263, 434): -u*v/w**2, (264, 28):
        -u/w, (264, 136): -u**2/w, (264, 244): -u**3/w, (264, 265):
        -u*v, (264, 266): 1, (264, 267): -v, (264, 325): -u**2/w**2,
        (264, 406): -u**2/w, (264, 427): -v, (264, 622): -u**3/w**2,
        (265, 265): u, (265, 427): 1, (266, 267): w, (267, 244):
        u**2/w, (267, 264): 1, (267, 265): v, (267, 267): u, (267,
        406): u/w, (268, 265): -u**2, (268, 269): w, (268, 427): -u,
        (269, 245): v/w, (269, 263): 1, (269, 269): u, (269, 319):
        u/w, (270, 351): u, (270, 432): 1, (270, 594): -v, (271, 82):
        -u, (271, 136): -u**2, (271, 271): -u*(u*v - w)/w, (271, 460):
        (-u*v + w)/w, (271, 568): -u*(u*v - w)/w, (271, 595):
        -u**3*v/w, (272, 2): 1, (272, 29): u, (272, 110): v/w, (272,
        164): u*v/w, (272, 272): u, (272, 353): u**2*v/w, (272, 434):
        u*v/w, (273, 277): 1, (273, 278): -v, (274, 49): v**2, (274,
        157): u*v**2, (274, 275): 1, (274, 276): -v, (274, 292):
        u*v**3/w, (274, 370): -u*v, (274, 373): u*v**3/w, (274, 451):
        -v, (274, 454): v**3/w, (274, 613): v**2, (274, 616):
        v**3*(u**2 - v)/w, (275, 265): u**2*v*w, (275, 276): w, (275,
        292): -u**3*v, (275, 427): u*v*w, (275, 481): -u**2*v, (275,
        589): -u**3*v, (275, 616): -u**4*v, (276, 157): -v**2, (276,
        274): 1, (276, 276): u, (276, 289): v, (276, 292): -v**3/w,
        (276, 319): -u*v, (276, 373): u**2*v*(u**2 - v)/w, (276, 400):
        u**2*v/w, (276, 454): u**3*v/w, (276, 616): -u*v**3/w, (277,
        49): u*v, (277, 157): u**2*v, (277, 265): u**3*v, (277, 278):
        w, (277, 292): -u**2*v*(u**2 - v)/w, (277, 370): -u**2, (277,
        373): u**2*v**2/w, (277, 427): u**2*v, (277, 451): -u, (277,
        454): u*v**2/w, (277, 481): -u**3*v/w, (277, 589): -u**4*v/w,
        (277, 613): u*v, (277, 616): -u*v*(u**4 - u**2*v + v**2)/w,
        (278, 184): -u*v/w, (278, 273): 1, (278, 278): u, (278, 319):
        -u**2*v/w, (278, 370): -u**3/w, (278, 373): u**3*v*(u**2 -
        v)/w**2, (278, 400): u**3*v/w**2, (278, 451): -u**2/w, (278,
        454): u**4*v/w**2, (278, 613): u, (278, 616): -u*v**2/w, (279,
        252): w, (279, 576): -u, (279, 603): -u**2, (280, 136):
        -v*(u*v - w)/w, (280, 146): -v, (280, 265): -u*v*w, (280,
        271): -v**2*(u*v - w)/w**2, (280, 281): -v**2/w, (280, 288):
        1, (280, 292): u**2*v, (280, 427): -v*w, (280, 481): u*v,
        (280, 589): u**2*v, (280, 595): -u*v**2*(u*v - w)/w**2, (280,
        605): -u*v**2/w, (280, 616): u**3*v, (281, 82): u**2*v/w,
        (281, 136): u**3*v/w, (281, 157): v*w, (281, 253): w, (281,
        265): u*v*w, (281, 271): u**3*v**2/w**2, (281, 281): u, (281,
        325): -v/w, (281, 460): u*v*(u*v - w)/w**2, (281, 487):
        u**2*v/w**2, (281, 514): u*v*(u**2 - v)/w**2, (281, 541):
        u*v/w**2, (281, 568): u**2*v*(u*v - w)/w**2, (281, 577): -u,
        (281, 589): -u**2*v, (281, 595): u**4*v**2/w**2, (281, 604):
        -u**2, (281, 616): -u*v*(u**2 - v), (281, 622): -u*v/w, (282,
        255): w, (282, 579): -u, (282, 606): -u**2, (283, 256): w,
        (283, 580): -u, (283, 607): -u**2, (284, 2): u*v/w, (284, 29):
        u**2*v/w, (284, 110): u*v**2/w**2, (284, 150): -v, (284, 164):
        u**2*v**2/w**2, (284, 272): u**2*v/w, (284, 285): -v**2/w,
        (284, 287): 1, (284, 353): u**3*v**2/w**2, (284, 373):
        -u**3*v/w, (284, 434): u**2*v**2/w**2, (284, 454): -u**2*v/w,
        (284, 609): -u*v**2/w, (284, 616): u**2*v**2/w, (285, 110):
        -u**2/w, (285, 164): -u**3/w, (285, 184): u, (285, 245): -u*v,
        (285, 257): w, (285, 265): u**2*v, (285, 285): u, (285, 353):
        -u**4/w, (285, 373): u**3*v/w, (285, 434): -u**3/w, (285,
        454): u**2*v/w, (285, 569): u, (285, 581): -u, (285, 589):
        -u**3*v/w, (285, 596): u**2, (285, 608): -u**2, (285, 616):
        -u**4*v/w, (286, 259): w, (286, 265): u**2, (286, 373):
        -u**3/w, (286, 454): -u**2/w, (286, 583): -u, (286, 589):
        -u**3/w, (286, 610): -u**2, (286, 616): -u**2*(u**2 - v)/w,
        (287, 2): -u, (287, 29): -u**2, (287, 110): -u*v/w, (287,
        150): w, (287, 164): -u**2*v/w, (287, 265): -u**2*w, (287,
        272): -u**2, (287, 285): v, (287, 292): u**3, (287, 353):
        -u**3*v/w, (287, 373): u**3, (287, 427): -u*w, (287, 434):
        -u**2*v/w, (287, 454): u**2, (287, 481): u**2, (287, 589):
        u**3, (287, 609): u*v, (287, 616): u**2*(u**2 - v), (288,
        136): u*v, (288, 146): w, (288, 271): u*v**2/w, (288, 281): v,
        (288, 595): u**2*v**2/w, (288, 605): u*v, (289, 370): u, (289,
        451): 1, (289, 613): -v, (290, 2): -v/w, (290, 29): -u*v/w,
        (290, 110): -v**2/w**2, (290, 164): -u*v**2/w**2, (290, 272):
        -u*v/w, (290, 295): 1, (290, 296): -v, (290, 353):
        -u**2*v**2/w**2, (290, 434): -u*v**2/w**2, (291, 244): -u**2,
        (291, 271): u**3/w, (291, 293): 1, (291, 294): -v, (291, 373):
        -u*v, (291, 406): -u, (291, 454): -v, (291, 460): u**2/w,
        (291, 568): u**3/w, (291, 595): u**4/w, (291, 616): v**2,
        (292, 373): u, (292, 454): 1, (292, 616): -v, (293, 294): w,
        (294, 291): 1, (294, 292): v, (294, 294): u, (294, 352):
        u**2/w, (294, 433): u/w, (294, 595): -u*v/w, (295, 296): w,
        (295, 373): -u**2, (295, 454): -u, (295, 616): u*v, (296,
        272): v/w, (296, 290): 1, (296, 296): u, (296, 373): -u**3/w,
        (296, 454): -u**2/w, (296, 616): u, (297, 243): w, (298, 1):
        1, (298, 55): v/w, (298, 82): u, (298, 190): u*v/w, (298,
        271): u, (298, 298): u, (298, 325): -u*(u*w - v**2)/w**2,
        (298, 460): u*v/w, (298, 568): u**2*v/w, (298, 595): u**2,
        (298, 622): -u**2*(u*w - v**2)/w**2, (299, 164): 1, (299,
        299): u, (299, 353): u, (300, 304): 1, (300, 305): -v, (301,
        262): -v*w, (301, 302): 1, (301, 303): -v, (301, 346):
        u*v**2/w, (301, 373): v**2, (301, 643): v**2*(u**2 - v)/w,
        (302, 76): u*v, (302, 211): u**2*v, (302, 265): u**2*v*w,
        (302, 303): w, (302, 346): u**2*v**2/w, (302, 481): u**2*v,
        (302, 589): u**3*v, (302, 643): u**3*v**2/w, (303, 238):
        -u*v/w, (303, 301): 1, (303, 303): u, (303, 316): v, (303,
        319): -u**2*v**2/w, (303, 346): -v**2/w, (303, 400):
        -u**2*v/w, (303, 427): -u**2*v, (303, 643): -u*v**2/w, (304,
        76): u**2*v/w, (304, 211): u**3*v/w, (304, 262): -u*w, (304,
        265): u**3*v, (304, 305): w, (304, 346): u**2*v*(u*v +
        w)/w**2, (304, 373): u*v, (304, 481): u**3*v/w, (304, 589):
        u**4*v/w, (304, 643): u*v*(u**3*v + u**2*w - v*w)/w**2, (305,
        238): -u**2*v/w**2, (305, 300): 1, (305, 305): u, (305, 316):
        u*v/w, (305, 319): -u**3*v**2/w**2, (305, 400): -u**3*v/w**2,
        (305, 424): u, (305, 427): -u**3*v/w, (305, 643): -u*v/w,
        (306, 198): 1, (306, 306): u, (306, 576): u, (306, 630):
        u*v/w, (307, 76): -v, (307, 211): -u*v, (307, 265): -u*v*w,
        (307, 315): 1, (307, 325): -v*(u*v - w)/w**2, (307, 335):
        -v/w, (307, 346): -u*v**2/w, (307, 481): -u*v, (307, 589):
        -u**2*v, (307, 622): -u*v*(u*v - w)/w**2, (307, 632): -u*v/w,
        (307, 643): -u**2*v**2/w, (308, 1): -u*v/w, (308, 55):
        -u*v**2/w**2, (308, 82): -u**2*v/w, (308, 190):
        -u**2*v**2/w**2, (308, 199): 1, (308, 211): u*v, (308, 271):
        -u**2*v/w, (308, 307): u, (308, 308): u, (308, 319): v*(u**2 -
        v), (308, 325): u*v*(u**2*w - u*v**2 - v*w)/w**3, (308, 346):
        v, (308, 379): -v/w, (308, 460): -u*v*(u*v + w)/w**2, (308,
        568): -v*(u**3*v + u**2*w - v*w)/w**2, (308, 577): u, (308,
        589): u**2*v, (308, 595): -u**3*v/w, (308, 622): v*(u**4*w -
        u**3*v**2 - u**2*v*w + v**2*w)/w**3, (308, 631): u*v/w, (308,
        643): u*v*(u*v + w)/w, (309, 201): 1, (309, 309): u, (309,
        579): u, (309, 633): u*v/w, (310, 202): 1, (310, 310): u,
        (310, 580): u, (310, 634): u*v/w, (311, 164): u*v/w, (311,
        265): -u**2*v, (311, 299): u**2*v/w, (311, 314): 1, (311,
        339): -v/w, (311, 353): u**2*v/w, (311, 636): -u*v/w, (312,
        83): u, (312, 203): 1, (312, 211): u**2*v/w, (312, 311): u,
        (312, 312): u, (312, 319): u*v*(u**2 - v)/w, (312, 407): u**2,
        (312, 427): -u*v, (312, 581): u, (312, 589): u**3*v/w, (312,
        596): u**2, (312, 623): -u**3/w, (312, 635): u*v/w, (312,
        643): u*(u**2*v**2 + w**2)/w**2, (313, 205): 1, (313, 211):
        u**2/w, (313, 265): -u**2, (313, 313): u, (313, 319): u**3/w,
        (313, 583): u, (313, 589): u**3/w, (313, 637): u*v/w, (313,
        643): u**3*v/w**2, (314, 76): -u, (314, 164): -u, (314, 211):
        -u**2, (314, 299): -u**2, (314, 339): 1, (314, 346):
        -u**2*v/w, (314, 353): -u**2, (314, 481): -u**2, (314, 589):
        -u**3, (314, 636): u, (314, 643): -u**3*v/w, (315, 325):
        u*v/w, (315, 335): 1, (315, 622): u**2*v/w, (315, 632): u,
        (316, 262): w, (317, 164): -v/w, (317, 299): -u*v/w, (317,
        322): 1, (317, 323): -v, (317, 353): -u*v/w, (318, 55): -u/w,
        (318, 190): -u**2/w, (318, 244): -u**2, (318, 265): -v*w,
        (318, 320): 1, (318, 321): -v, (318, 325): -u**2*v/w**2, (318,
        460): -u**2/w, (318, 568): -u**3/w, (318, 622): -u**3*v/w**2,
        (319, 265): w, (320, 321): w, (321, 244): u, (321, 318): 1,
        (321, 319): v, (321, 321): u, (322, 265): -u*w, (322, 323): w,
        (323, 299): v/w, (323, 317): 1, (323, 319): u*v/w, (323, 323):
        u, (323, 427): u, (324, 351): w, (324, 621): -v, (325, 136):
        -u*w, (325, 271): -u*v + w, (325, 595): -u*(u*v - w), (325,
        622): -u**2, (326, 29): w, (326, 164): v, (326, 326): u, (326,
        353): u*v, (327, 331): 1, (327, 332): -v, (328, 76): v**2,
        (328, 211): u*v**2, (328, 329): 1, (328, 330): -v, (328, 346):
        u*v**3/w, (328, 370): -v*w, (328, 373): v**3, (328, 640):
        v**2, (328, 643): v**3*(u**2 - v)/w, (329, 265): u*v*w**2,
        (329, 292): -u**2*v*w, (329, 330): w, (329, 616): -u**3*v*w,
        (330, 211): -v**2, (330, 319): -u*v**2, (330, 328): 1, (330,
        330): u, (330, 343): v, (330, 346): -v**3/w, (330, 373):
        u**3*v, (330, 427): -u*v*w, (330, 454): u**2*v, (330, 643):
        -u*v**3/w, (331, 76): u*v, (331, 211): u**2*v, (331, 265):
        u**2*v*w, (331, 292): -u**3*v, (331, 332): w, (331, 346):
        u**2*v**2/w, (331, 370): -u*w, (331, 373): u*v**2, (331, 616):
        -u**4*v, (331, 640): u*v, (331, 643): u*v**2*(u**2 - v)/w,
        (332, 238): -u*v/w, (332, 319): -u**2*v**2/w, (332, 327): 1,
        (332, 332): u, (332, 370): -u**2, (332, 373): u**4*v/w, (332,
        427): -u**2*v, (332, 454): u**3*v/w, (332, 640): u, (332,
        643): -u*v**2/w, (333, 306): w, (333, 603): -u*w, (334, 190):
        -v*(u*v - w)/w, (334, 200): -v, (334, 265): -v*w**2, (334,
        292): u*v*w, (334, 325): -v**2*(u*v - w)/w**2, (334, 335):
        -v**2/w, (334, 342): 1, (334, 616): u**2*v*w, (334, 622):
        -u*v**2*(u*v - w)/w**2, (334, 632): -u*v**2/w, (335, 136):
        u**2*v, (335, 211): v*w, (335, 271): u*v*(u*v - w)/w, (335,
        307): w, (335, 319): u*v*w, (335, 325): v*(u**2 - v)/w, (335,
        335): u, (335, 460): -v, (335, 487): u*v/w, (335, 514):
        u**2*v/w, (335, 568): -u*v, (335, 595): u**2*v*(u*v - w)/w,
        (335, 604): -u*w, (335, 616): -u**2*v*w, (335, 622): u*v*(u**2
        - v)/w, (335, 643): u*v**2, (336, 309): w, (336, 606): -u*w,
        (337, 310): w, (337, 607): -u*w, (338, 29): u*v, (338, 164):
        u*v**2/w, (338, 204): -v, (338, 326): u**2*v/w, (338, 339):
        -v**2/w, (338, 341): 1, (338, 353): u**2*v**2/w, (338, 373):
        -u**2*v, (338, 636): -u*v**2/w, (338, 643): u**2*v**2/w, (339,
        164): -u**2, (339, 238): u, (339, 299): -u*v, (339, 311): w,
        (339, 319): u**2*v, (339, 339): u, (339, 353): -u**3, (339,
        373): u**2*v, (339, 596): u*w, (339, 608): -u*w, (339, 616):
        -u**3*v, (340, 313): w, (340, 319): u**2, (340, 373): -u**2,
        (340, 610): -u*w, (340, 616): -u**3, (340, 643): u**2*v/w,
        (341, 29): -u*w, (341, 164): -u*v, (341, 204): w, (341, 265):
        -u*w**2, (341, 292): u**2*w, (341, 326): -u**2, (341, 339): v,
        (341, 353): -u**2*v, (341, 373): u**2*w, (341, 616): u**3*w,
        (341, 636): u*v, (341, 643): -u**2*v, (342, 190): u*v, (342,
        200): w, (342, 325): u*v**2/w, (342, 335): v, (342, 622):
        u**2*v**2/w, (342, 632): u*v, (343, 370): w, (343, 640): -v,
        (344, 29): -v, (344, 164): -v**2/w, (344, 326): -u*v/w, (344,
        349): 1, (344, 350): -v, (344, 353): -u*v**2/w, (345, 244):
        -u*w, (345, 271): u**2, (345, 347): 1, (345, 348): -v, (345,
        373): -v*w, (345, 595): u**3, (345, 643): v**2, (346, 373): w,
        (346, 643): -v, (347, 348): w, (348, 345): 1, (348, 346): v,
        (348, 348): u, (348, 352): u, (348, 622): -u*v/w, (349, 350):
        w, (349, 373): -u*w, (349, 643): u*v, (350, 326): v/w, (350,
        344): 1, (350, 350): u, (350, 373): -u**2, (350, 643): u,
        (351, 621): 1, (352, 136): v, (352, 244): w, (352, 271): (-u*w
        + v**2)/w, (352, 595): -u*(u*w - v**2)/w, (352, 622): u*v/w,
        (353, 353): u, (353, 434): 1, (354, 358): 1, (354, 359): -v,
        (355, 356): 1, (355, 357): -v, (355, 508): v**2/w, (355, 535):
        u*v**2/w, (355, 640): -v, (356, 157): u*v*w, (356, 292):
        u*v**2, (356, 357): w, (356, 616): u**2*v**2, (356, 643):
        u**2*v, (357, 49): -u*v, (357, 184): -u*v**2/w, (357, 346):
        -u**2*v/w, (357, 355): 1, (357, 357): u, (357, 370): v, (357,
        373): -2*u**2*v**2/w, (357, 454): -u*v**2/w, (357, 535):
        -v**2/w, (358, 157): u**2*v, (358, 292): u**2*v**2/w, (358,
        359): w, (358, 508): u*v/w, (358, 535): u**2*v/w, (358, 616):
        u**3*v**2/w, (358, 640): -u, (358, 643): u**3*v/w, (359, 49):
        -u**2*v/w, (359, 184): -u**2*v**2/w**2, (359, 343): u/w, (359,
        346): -u**3*v/w**2, (359, 354): 1, (359, 359): u, (359, 370):
        u*v/w, (359, 373): -2*u**3*v**2/w**2, (359, 454):
        -u**2*v**2/w**2, (359, 562): -u*v/w**2, (360, 171): 1, (360,
        360): u, (360, 603): v, (361, 157): -v*w, (361, 292): -v**2,
        (361, 369): 1, (361, 514): -v*(u*v - w)/w**2, (361, 524):
        -v/w, (361, 616): -u*v**2, (361, 643): -u*v, (362, 55): -v/w,
        (362, 136): -u*v**2/w, (362, 172): 1, (362, 184): u*v, (362,
        190): -u*v/w, (362, 244): -u*v, (362, 271): u*v*(u*w -
        v**2)/w**2, (362, 325): -u*v**2/w**2, (362, 352): v*(u**2 -
        v)/w, (362, 361): u, (362, 362): u, (362, 373): v*(u**2 - v),
        (362, 487): -v**2/w**2, (362, 514): -u*v**2/w**2, (362, 535):
        v, (362, 595): u**2*v*(u*w - v**2)/w**2, (362, 604): v, (362,
        616): u*v**2, (362, 622): -v**2*(2*u**2 - v)/w**2, (363, 174):
        1, (363, 363): u, (363, 606): v, (364, 175): 1, (364, 364): u,
        (364, 607): v, (365, 353): u**2*v/w, (365, 368): 1, (365,
        434): u*v/w, (365, 528): -v/w, (365, 643): -u**2*v/w, (366,
        176): 1, (366, 184): u**2*v/w, (366, 299): u, (366, 346):
        -u*v/w, (366, 365): u, (366, 366): u, (366, 373): u*v*(u**2 -
        v)/w, (366, 562): u/w, (366, 596): -u**2, (366, 608): v, (366,
        616): u**2*v**2/w, (367, 178): 1, (367, 184): u**2/w, (367,
        367): u, (367, 373): u**3/w, (367, 610): v, (367, 616):
        u**2*v/w, (367, 643): -u**2/w, (368, 157): -u*w, (368, 292):
        -u*v, (368, 353): -u**2, (368, 434): -u, (368, 528): 1, (368,
        616): -u**2*v, (369, 514): u*v/w, (369, 524): 1, (370, 640):
        1, (371, 353): -u*v/w, (371, 376): 1, (371, 377): -v, (371,
        434): -v/w, (372, 136): -u, (372, 271): -u*v/w, (372, 374): 1,
        (372, 375): -v, (372, 595): -u**2*v/w, (372, 622): -u**2/w,
        (372, 643): -v, (373, 643): 1, (374, 375): w, (375, 372): 1,
        (375, 373): v, (375, 375): u, (375, 622): u/w, (376, 377): w,
        (376, 643): -u, (377, 346): u/w, (377, 353): v/w, (377, 371):
        1, (377, 373): u*v/w, (377, 377): u, (378, 567): w, (378,
        621): v, (379, 190): v, (379, 298): w, (379, 325): (-u*w +
        v**2)/w, (379, 568): u*v, (379, 622): -u*(u*w - 2*v**2)/w,
        (380, 353): w, (381, 385): 1, (381, 386): -v, (382, 383): 1,
        (382, 384): -v, (382, 535): v**2, (382, 586): -v*w, (382,
        640): -v**2, (383, 211): u*v*w, (383, 346): u*v**2, (383,
        384): w, (383, 589): u**2*v*w, (383, 643): 2*u**2*v**2, (384,
        76): -u*v, (384, 238): -u*v**2/w, (384, 346): -u**2*v**2/w,
        (384, 373): -u*v**2, (384, 382): 1, (384, 384): u, (384, 397):
        v, (384, 400): -u**2*v**2/w, (384, 481): -u**2*v, (384, 562):
        -v**2/w, (385, 211): u**2*v, (385, 346): u**2*v**2/w, (385,
        386): w, (385, 535): u*v, (385, 586): -u*w, (385, 589):
        u**3*v, (385, 640): -u*v, (385, 643): 2*u**3*v**2/w, (386,
        76): -u**2*v/w, (386, 238): -u**2*v**2/w**2, (386, 343):
        u*v/w, (386, 346): -u**3*v**2/w**2, (386, 373): -u**2*v**2/w,
        (386, 381): 1, (386, 386): u, (386, 397): u*v/w, (386, 400):
        -u**3*v**2/w**2, (386, 478): u, (386, 481): -u**3*v/w, (386,
        508): -u*v/w, (386, 562): -u*v**2/w**2, (387, 225): 1, (387,
        387): u, (387, 630): v, (388, 211): -v*w, (388, 346): -v**2,
        (388, 396): 1, (388, 541): -v*(u*v - w)/w**2, (388, 551):
        -v/w, (388, 589): -u*v*w, (388, 643): -2*u*v**2, (389, 1): -v,
        (389, 55): -v**2/w, (389, 82): -u*v, (389, 190): -2*u*v**2/w,
        (389, 226): 1, (389, 238): u*v, (389, 298): -u*v, (389, 325):
        u*v*(u*w - 2*v**2)/w**2, (389, 379): v*(u**2 - v)/w, (389,
        388): u, (389, 389): u, (389, 400): v*(u**2 - v), (389, 460):
        -u*v**2/w, (389, 514): -v**2/w, (389, 562): v, (389, 568):
        -v**2*(2*u**2 - v)/w, (389, 622): v*(u**3*w - 3*u**2*v**2 +
        v**3)/w**2, (389, 631): v, (389, 643): u*v**2, (390, 228): 1,
        (390, 390): u, (390, 633): v, (391, 229): 1, (391, 391): u,
        (391, 634): v, (392, 353): u*v, (392, 395): 1, (392, 555):
        -v/w, (392, 589): -u**2*v, (392, 643): -u**2*v**2/w, (393,
        230): 1, (393, 238): u**2*v/w, (393, 299): u*v, (393, 346):
        -u*v**2/w, (393, 392): u, (393, 393): u, (393, 400): u*v*(u**2
        - v)/w, (393, 407): u*w, (393, 481): -u*v, (393, 508): u,
        (393, 562): u*v/w, (393, 623): -u**2, (393, 635): v, (393,
        643): u**2*v**2/w, (394, 232): 1, (394, 238): u**2/w, (394,
        394): u, (394, 400): u**3/w, (394, 589): -u**2, (394, 637): v,
        (395, 211): -u*w, (395, 346): -u*v, (395, 353): -u*w, (395,
        555): 1, (395, 643): -u**2*v, (396, 541): u*v/w, (396, 551):
        1, (397, 586): w, (397, 640): v, (398, 353): -v, (398, 403):
        1, (398, 404): -v, (399, 190): -u, (399, 325): -u*v/w, (399,
        401): 1, (399, 402): -v, (399, 568): -u**2, (399, 589): -v*w,
        (399, 622): -2*u**2*v/w, (399, 643): -v**2, (400, 589): w,
        (400, 643): v, (401, 402): w, (402, 399): 1, (402, 400): v,
        (402, 402): u, (402, 568): u, (402, 622): u*v/w, (403, 404):
        w, (403, 589): -u*w, (403, 643): -u*v, (404, 346): u*v/w,
        (404, 380): v/w, (404, 398): 1, (404, 400): u*v/w, (404, 404):
        u, (404, 481): u, (405, 243): -v, (405, 297): 1, (406, 28): 1,
        (406, 55): -u/w, (406, 136): u, (406, 190): -u**2/w, (406,
        325): -u*(u*v - w)/w**2, (406, 406): u, (406, 460): -u**2/w,
        (406, 568): -u**3/w, (406, 622): -u**2*(u*v - w)/w**2, (407,
        164): -v/w, (407, 218): 1/w, (407, 353): -u*v/w, (407, 380):
        u/w, (407, 407): u, (408, 412): 1, (408, 413): -v, (409, 262):
        v**2, (409, 316): -v, (409, 373): -v**3/w, (409, 400): v**2/w,
        (409, 410): 1, (409, 411): -v, (409, 481): u*v**2/w, (409,
        589): v**2*(u**2 - v)/w, (410, 22): u*v, (410, 103): u**2*v,
        (410, 265): -u**2*v**2, (410, 292): u**2*v, (410, 319):
        u**2*v, (410, 346): -u**3*v/w, (410, 411): w, (410, 616):
        u**3*v, (410, 643): -u**4*v/w, (411, 130): -u*v/w, (411, 265):
        -u**2*v, (411, 319): u**3*v/w, (411, 409): 1, (411, 411): u,
        (411, 424): v, (411, 454): -u**2*v/w, (411, 481): -v**2/w,
        (411, 589): -u*v**2/w, (412, 22): u**2*v/w, (412, 103):
        u**3*v/w, (412, 262): u*v, (412, 265): -u**3*v**2/w, (412,
        292): u**3*v/w, (412, 316): -u, (412, 319): u**3*v/w, (412,
        346): -u**4*v/w**2, (412, 373): -u*v**2/w, (412, 400): u*v/w,
        (412, 413): w, (412, 481): u**2*v/w, (412, 589): u*v*(u**2 -
        v)/w, (412, 616): u**4*v/w, (412, 643): -u**5*v/w**2, (413,
        130): -u**2*v/w**2, (413, 262): u, (413, 265): -u**3*v/w,
        (413, 316): -u**2/w, (413, 319): u**4*v/w**2, (413, 408): 1,
        (413, 413): u, (413, 454): -u**3*v/w**2, (413, 589): -u*v/w,
        (414, 90): 1, (414, 414): u, (414, 603): u, (414, 630):
        -u**2/w, (415, 22): -v, (415, 103): -u*v, (415, 265): u*v**2,
        (415, 292): -u*v, (415, 319): -u*v, (415, 346): u**2*v/w,
        (415, 423): 1, (415, 460): -v*(u*v - w)/w**2, (415, 470):
        -v/w, (415, 568): -u*v*(u*v - w)/w**2, (415, 578): -u*v/w,
        (415, 616): -u**2*v, (415, 643): u**3*v/w, (416, 28): -u*v/w,
        (416, 55): u**2*v/w**2, (416, 91): 1, (416, 103): u*v, (416,
        136): -u**2*v/w, (416, 190): u**3*v/w**2, (416, 271): -u*v/w,
        (416, 325): u**3*v**2/w**3, (416, 415): u, (416, 416): u,
        (416, 427): v*(u**2 - v), (416, 433): -v/w, (416, 460):
        u**3*v/w**2, (416, 481): v, (416, 568): u**4*v/w**2, (416,
        589): u*v, (416, 595): -v*(u**2 - v)/w, (416, 604): u, (416,
        616): u**2*v, (416, 622): u*v**2*(u**3 - w)/w**3, (416, 631):
        -u**2/w, (416, 643): -u**3*v/w, (417, 93): 1, (417, 417): u,
        (417, 606): u, (417, 633): -u**2/w, (418, 94): 1, (418, 418):
        u, (418, 607): u, (418, 634): -u**2/w, (419, 164):
        -u*v**2/w**2, (419, 218): u*v/w**2, (419, 265): u**2*v**2/w,
        (419, 319): -u**2*v/w, (419, 353): -u**2*v**2/w**2, (419,
        380): u**2*v/w**2, (419, 407): u**2*v/w, (419, 422): 1, (419,
        474): -v/w, (419, 582): -u*v/w, (420, 83): -u*v/w, (420, 95):
        1, (420, 103): u**2*v/w, (420, 137): u, (420, 191): -u**2/w,
        (420, 245): u**2, (420, 265): -u*v, (420, 299): -u**3/w, (420,
        319): u**2*v/w, (420, 407): -u**2*v/w, (420, 419): u, (420,
        420): u, (420, 427): u**3*v/w, (420, 569): -u**3/w, (420,
        589): u, (420, 596): -u**2*v/w, (420, 608): u, (420, 616):
        u**3*v/w, (420, 623): u**2/w, (420, 635): -u**2/w, (420, 643):
        -u**4*v/w**2, (421, 97): 1, (421, 103): u**2/w, (421, 265):
        u**2*v/w, (421, 319): -u**2/w, (421, 421): u, (421, 427):
        u**3/w, (421, 610): u, (421, 616): u**3/w, (421, 637):
        -u**2/w, (421, 643): -u**4/w**2, (422, 22): -u, (422, 103):
        -u**2, (422, 164): u*v/w, (422, 218): -u/w, (422, 292): -u**2,
        (422, 346): u**3/w, (422, 353): u**2*v/w, (422, 380): -u**2/w,
        (422, 407): -u**2, (422, 474): 1, (422, 582): u, (422, 616):
        -u**3, (422, 643): u**4/w, (423, 460): u*v/w, (423, 470): 1,
        (423, 568): u**2*v/w, (423, 578): u, (424, 262): -v, (424,
        316): 1, (425, 164): v**2/w**2, (425, 218): -v/w**2, (425,
        353): u*v**2/w**2, (425, 380): -u*v/w**2, (425, 407): -u*v/w,
        (425, 430): 1, (425, 431): -v, (426, 1): -u/w, (426, 82):
        -u**2/w, (426, 244): u**2*v/w, (426, 265): v**2, (426, 271):
        -u**2/w, (426, 298): -u**2/w, (426, 319): -v, (426, 325):
        u**3/w**2, (426, 428): 1, (426, 429): -v, (426, 595): -u**3/w,
        (426, 622): u**4/w**2, (427, 265): -v, (427, 319): 1, (428,
        429): w, (429, 244): -u*v/w, (429, 298): u/w, (429, 426): 1,
        (429, 427): v, (429, 429): u, (430, 265): u*v, (430, 319): -u,
        (430, 431): w, (431, 265): u, (431, 319): -u**2/w, (431, 407):
        v/w, (431, 425): 1, (431, 431): u, (432, 594): w, (432, 621):
        -u, (433, 82): v, (433, 406): w, (433, 460): (-u*w + v**2)/w,
        (433, 568): -u*(u*w - v**2)/w, (433, 595): u*v, (433, 622):
        -u**2*v/w, (434, 353): -v, (434, 380): 1, (435, 439): 1, (435,
        440): -v, (436, 437): 1, (436, 438): -v, (436, 535): -v**3/w,
        (436, 562): v**2/w, (436, 613): -v*w, (436, 640): u*v, (437,
        103): u*v*w, (437, 438): w, (437, 481): u*v**2, (437, 589):
        u**2*v**2, (437, 616): u**2*v*w, (437, 643): -u**3*v, (438,
        22): -u*v, (438, 130): -u*v**2/w, (438, 292): -u**2*v, (438,
        346): u**3*v/w, (438, 373): u*v**3/w, (438, 400): -u*v**2/w,
        (438, 436): 1, (438, 438): u, (438, 451): v, (438, 454):
        -u**2*v**2/w, (438, 508): -v**2/w, (439, 103): u**2*v, (439,
        440): w, (439, 481): u**2*v**2/w, (439, 535): -u*v**2/w, (439,
        562): u*v/w, (439, 589): u**3*v**2/w, (439, 613): -u*w, (439,
        616): u**3*v, (439, 640): u**2, (439, 643): -u**4*v/w, (440,
        22): -u**2*v/w, (440, 130): -u**2*v**2/w**2, (440, 289): u,
        (440, 292): -u**3*v/w, (440, 343): -u**2/w, (440, 346):
        u**4*v/w**2, (440, 373): u**2*v**3/w**2, (440, 400):
        -u**2*v**2/w**2, (440, 435): 1, (440, 440): u, (440, 451):
        u*v/w, (440, 454): -u**3*v**2/w**2, (440, 535): -u*v/w, (440,
        562): u**2*v/w**2, (441, 117): 1, (441, 441): u, (441, 576):
        v, (442, 103): -v*w, (442, 450): 1, (442, 481): -v**2, (442,
        487): -v*(u*v - w)/w**2, (442, 497): -v/w, (442, 589):
        -u*v**2, (442, 616): -u*v*w, (442, 643): u**2*v, (443, 28):
        -v, (443, 55): u*v/w, (443, 82): -u*v**2/w, (443, 118): 1,
        (443, 130): u*v, (443, 136): -u*v, (443, 190): u**2*v/w, (443,
        271): -u*v**2/w, (443, 325): u**2*v**2/w**2, (443, 406): -u*v,
        (443, 433): v*(u**2 - v)/w, (443, 442): u, (443, 443): u,
        (443, 454): v*(u**2 - v), (443, 460): u*v*(u*w - v**2)/w**2,
        (443, 508): v, (443, 514): v**3/w**2, (443, 541): -v**2/w**2,
        (443, 568): u**2*v*(u*w - v**2)/w**2, (443, 577): v, (443,
        589): u*v**2, (443, 595): -v**2*(2*u**2 - v)/w, (443, 622):
        u*v**2*(2*u**2 - v)/w**2, (444, 120): 1, (444, 444): u, (444,
        579): v, (445, 121): 1, (445, 445): u, (445, 580): v, (446,
        353): -u*v**2/w, (446, 380): u*v/w, (446, 449): 1, (446, 501):
        -v/w, (446, 616): -u**2*v, (446, 643): u**3*v/w, (447, 122):
        1, (447, 130): u**2*v/w, (447, 245): u*w, (447, 292): -u*v,
        (447, 299): -u**2, (447, 346): u**2*v/w, (447, 446): u, (447,
        447): u, (447, 454): u*v*(u**2 - v)/w, (447, 535): u, (447,
        562): -u**2/w, (447, 569): -u**2, (447, 581): v, (447, 589):
        u**2*v**2/w, (448, 124): 1, (448, 130): u**2/w, (448, 448): u,
        (448, 454): u**3/w, (448, 583): v, (448, 589): u**2*v/w, (448,
        616): -u**2, (448, 643): u**3/w, (449, 103): -u*w, (449, 353):
        u*v, (449, 380): -u, (449, 481): -u*v, (449, 501): 1, (449,
        589): -u**2*v, (450, 487): u*v/w, (450, 497): 1, (451, 613):
        w, (451, 640): -u, (452, 353): v**2/w, (452, 380): -v/w, (452,
        457): 1, (452, 458): -v, (453, 82): -u, (453, 455): 1, (453,
        456): -v, (453, 460): -u*v/w, (453, 568): -u**2*v/w, (453,
        595): -u**2, (453, 616): -v*w, (453, 622): u**3/w, (453, 643):
        u*v, (454, 616): w, (454, 643): -u, (455, 456): w, (456, 453):
        1, (456, 454): v, (456, 456): u, (456, 595): u, (456, 622):
        -u**2/w, (457, 458): w, (457, 616): -u*w, (457, 643): u**2,
        (458, 292): u, (458, 346): -u**2/w, (458, 434): v/w, (458,
        452): 1, (458, 454): u*v/w, (458, 458): u, (459, 351): -v,
        (459, 378): 1, (459, 567): -v, (460, 136): u*v, (460, 190):
        -u, (460, 271): v*(u*v - w)/w, (460, 325): (-u*v + w)/w, (460,
        568): -u**2, (460, 595): u*v*(u*v - w)/w, (460, 622): -u*(u*v
        - w)/w, (461, 29): -v, (461, 56): 1, (461, 164): -v**2/w,
        (461, 218): v/w, (461, 353): -u*v**2/w, (461, 380): u*v/w,
        (461, 461): u, (462, 466): 1, (462, 467): -v, (463, 22): v**2,
        (463, 103): u*v**2, (463, 370): v**2, (463, 373): -v**4/w,
        (463, 397): -v, (463, 400): v**3/w, (463, 464): 1, (463, 465):
        -v, (463, 481): u*v**3/w, (463, 586): v**2, (463, 589):
        v**3*(u**2 - v)/w, (464, 265): -u*v**2*w, (464, 292):
        u**2*v**2, (464, 319): u*v*w, (464, 346): -u**2*v, (464, 465):
        w, (464, 616): u**3*v**2, (464, 643): -u**3*v, (465, 103):
        -v**2, (465, 265): -u*v*w, (465, 319): u**2*v, (465, 373):
        -u**2*v*(u*v - w)/w, (465, 454): -u**2*v**2/w, (465, 463): 1,
        (465, 465): u, (465, 478): v, (465, 481): -v**3/w, (465, 589):
        -u*v**3/w, (466, 22): u*v, (466, 103): u**2*v, (466, 265):
        -u**2*v**2, (466, 292): u**3*v**2/w, (466, 319): u**2*v, (466,
        346): -u**3*v/w, (466, 370): u*v, (466, 373): -u*v**3/w, (466,
        397): -u, (466, 400): u*v**2/w, (466, 467): w, (466, 481):
        u**2*v**2/w, (466, 586): u*v, (466, 589): u*v**2*(u**2 - v)/w,
        (466, 616): u**4*v**2/w, (466, 643): -u**4*v/w, (467, 130):
        -u*v/w, (467, 265): -u**2*v, (467, 319): u**3*v/w, (467, 370):
        u**2*v/w, (467, 373): -u**3*v*(u*v - w)/w**2, (467, 397):
        -u**2/w, (467, 454): -u**3*v**2/w**2, (467, 462): 1, (467,
        467): u, (467, 586): u, (467, 589): -u*v**2/w, (468, 414): w,
        (468, 603): u*v, (468, 630): -u, (469, 82): -v*(u*v - w)/w,
        (469, 92): -v, (469, 265): v**2*w, (469, 292): -u*v**2, (469,
        319): -v*w, (469, 346): u*v, (469, 460): -v**2*(u*v - w)/w**2,
        (469, 470): -v**2/w, (469, 477): 1, (469, 568): -u*v**2*(u*v -
        w)/w**2, (469, 578): -u*v**2/w, (469, 616): -u**2*v**2, (469,
        643): u**2*v, (470, 103): v*w, (470, 136): -u**2*v**2/w, (470,
        190): u**2*v/w, (470, 271): -v*(u**2*v**2 - u*v*w +
        w**2)/w**2, (470, 325): u**2*v**2/w**2, (470, 415): w, (470,
        427): u*v*w, (470, 460): u**2*v/w, (470, 470): u, (470, 487):
        -u*v**2/w**2, (470, 514): -u*v*(u*v - w)/w**2, (470, 568):
        u**3*v/w, (470, 589): u*v**2, (470, 595): -u*v*(u**2*v**2 -
        u*v*w + w**2)/w**2, (470, 604): u*v, (470, 616): u**2*v**2,
        (470, 622): u**3*v**2/w**2, (470, 631): -u, (470, 643):
        -u**2*v, (471, 417): w, (471, 606): u*v, (471, 633): -u, (472,
        418): w, (472, 607): u*v, (472, 634): -u, (473, 29):
        -u*v**2/w, (473, 56): u*v/w, (473, 96): -v, (473, 164):
        -u*v**3/w**2, (473, 218): u*v**2/w**2, (473, 353):
        -u**2*v**3/w**2, (473, 373): u**2*v**2/w, (473, 380):
        u**2*v**2/w**2, (473, 400): -u**2*v/w, (473, 461): u**2*v/w,
        (473, 474): -v**2/w, (473, 476): 1, (473, 582): -u*v**2/w,
        (473, 589): u**2*v**2/w, (474, 130): u, (474, 164): u**2*v/w,
        (474, 218): -u**2/w, (474, 353): u**3*v/w, (474, 373):
        -u**2*v**2/w, (474, 380): -u**3/w, (474, 400): u**2*v/w, (474,
        407): -u*v, (474, 419): w, (474, 427): u**2*v, (474, 474): u,
        (474, 596): -u*v, (474, 608): u*v, (474, 616): u**3*v**2/w,
        (474, 623): u, (474, 635): -u, (474, 643): -u**3*v/w, (475,
        373): u**2*v/w, (475, 400): -u**2/w, (475, 421): w, (475,
        427): u**2, (475, 589): u**2*v/w, (475, 610): u*v, (475, 616):
        u**3*v/w, (475, 637): -u, (475, 643): -u**3/w, (476, 29): u*v,
        (476, 56): -u, (476, 96): w, (476, 164): u*v**2/w, (476, 218):
        -u*v/w, (476, 265): u*v*w, (476, 292): -u**2*v, (476, 319):
        -u*w, (476, 346): u**2, (476, 353): u**2*v**2/w, (476, 373):
        -u**2*v, (476, 380): -u**2*v/w, (476, 400): u**2, (476, 461):
        -u**2, (476, 474): v, (476, 582): u*v, (476, 589): -u**2*v,
        (476, 616): -u**3*v, (476, 643): u**3, (477, 82): u*v, (477,
        92): w, (477, 460): u*v**2/w, (477, 470): v, (477, 568):
        u**2*v**2/w, (477, 578): u*v, (478, 370): -v, (478, 397): 1,
        (478, 586): -v, (479, 29): v**2/w, (479, 56): -v/w, (479,
        164): v**3/w**2, (479, 218): -v**2/w**2, (479, 353):
        u*v**3/w**2, (479, 380): -u*v**2/w**2, (479, 461): -u*v/w,
        (479, 484): 1, (479, 485): -v, (480, 244): u*v, (480, 271):
        -u**2*v/w, (480, 298): -u, (480, 325): u**2/w, (480, 373):
        v**2, (480, 400): -v, (480, 482): 1, (480, 483): -v, (480,
        589): v**2, (480, 595): -u**3*v/w, (480, 622): u**3/w, (481,
        373): -v, (481, 400): 1, (481, 589): -v, (482, 483): w, (483,
        352): -u*v/w, (483, 379): u/w, (483, 480): 1, (483, 481): v,
        (483, 483): u, (483, 568): -u*v/w, (484, 373): u*v, (484,
        400): -u, (484, 485): w, (484, 589): u*v, (485, 373):
        u**2*v/w, (485, 400): -u**2/w, (485, 461): v/w, (485, 479): 1,
        (485, 485): u, (485, 589): u, (486, 513): -v, (486, 540): 1,
        (487, 568): -u*w, (487, 622): -u*v + w, (488, 353): -v**2,
        (488, 380): v, (488, 461): w, (489, 493): 1, (489, 494): -v,
        (490, 103): v**2*w, (490, 481): v**3, (490, 491): 1, (490,
        492): -v, (490, 532): v**2, (490, 535): -v**4/w, (490, 559):
        -v, (490, 562): v**3/w, (490, 589): u*v**3, (491, 492): w,
        (491, 616): u*v*w**2, (491, 643): -u**2*v*w, (492, 130):
        -v**2, (492, 292): -u*v*w, (492, 346): u**2*v, (492, 454):
        -u*v**2, (492, 490): 1, (492, 492): u, (492, 505): v, (492,
        508): -v**3/w, (492, 589): -v**3, (493, 103): u*v*w, (493,
        481): u*v**2, (493, 494): w, (493, 532): u*v, (493, 535):
        -u*v**3/w, (493, 559): -u, (493, 562): u*v**2/w, (493, 589):
        u**2*v**2, (493, 616): u**2*v*w, (493, 643): -u**3*v, (494,
        22): -u*v, (494, 130): -u*v**2/w, (494, 292): -u**2*v, (494,
        346): u**3*v/w, (494, 373): u*v**3/w, (494, 400): -u*v**2/w,
        (494, 454): -u**2*v**2/w, (494, 489): 1, (494, 494): u, (494,
        532): u, (494, 535): -u*v**2/w, (494, 559): -u**2/w, (494,
        562): u**2*v**2/w**2, (495, 441): w, (496, 109): -v*(u*v -
        w)/w, (496, 119): -v, (496, 487): -v**2*(u*v - w)/w**2, (496,
        497): -v**2/w, (496, 504): 1, (496, 568): -v**2*(u*v - w)/w,
        (496, 578): -v**2, (496, 616): -v*w**2, (496, 643): u*v*w,
        (497, 130): v*w, (497, 136): -v*w, (497, 190): u*v, (497,
        271): -v**2, (497, 325): u*v**2/w, (497, 442): w, (497, 454):
        u*v*w, (497, 487): v*(u**2 - v)/w, (497, 497): u, (497, 568):
        u**2*v, (497, 589): v**2*w, (497, 595): -u*v**2, (497, 622):
        u*v*(2*u*v - w)/w, (498, 444): w, (499, 445): w, (500, 123):
        -v, (500, 353): -u*v**3/w, (500, 380): u*v**2/w, (500, 461):
        u*v, (500, 501): -v**2/w, (500, 503): 1, (500, 535):
        u**2*v**2/w, (500, 562): -u**2*v/w, (500, 582): -v**2, (501,
        22): u*w, (501, 130): u*v, (501, 353): u*w, (501, 373):
        -u*v**2, (501, 380): -u**2, (501, 400): u*v, (501, 434): -u*v,
        (501, 446): w, (501, 454): u**2*v, (501, 501): u, (502, 448):
        w, (502, 454): u**2, (502, 535): u**2*v/w, (502, 562):
        -u**2/w, (503, 123): w, (503, 353): u*v**2, (503, 380): -u*v,
        (503, 461): -u*w, (503, 501): v, (503, 535): -u**2*v, (503,
        562): u**2, (503, 582): v*w, (503, 616): -u*w**2, (503, 643):
        u**2*w, (504, 109): u*v, (504, 119): w, (504, 487): u*v**2/w,
        (504, 497): v, (504, 568): u*v**2, (504, 578): v*w, (505,
        532): -v, (505, 559): 1, (506, 353): v**3/w, (506, 380):
        -v**2/w, (506, 461): -v, (506, 511): 1, (506, 512): -v, (507,
        509): 1, (507, 510): -v, (507, 535): v**2, (507, 562): -v,
        (507, 595): -u*w, (507, 622): u**2, (508, 535): -v, (508,
        562): 1, (509, 510): w, (510, 507): 1, (510, 508): v, (510,
        510): u, (510, 514): -u*v/w, (510, 541): u/w, (511, 512): w,
        (511, 535): u*v, (511, 562): -u, (512, 488): v/w, (512, 506):
        1, (512, 512): u, (512, 535): u, (512, 562): -u**2/w, (513,
        486): 1, (513, 513): u, (514, 568): w, (514, 622): v, (515,
        272): w, (515, 353): u*v, (515, 434): v, (516, 520): 1, (516,
        521): -v, (517, 157): v**2*w, (517, 292): v**3, (517, 505):
        -v, (517, 508): v**3/w, (517, 518): 1, (517, 519): -v, (517,
        532): -u*v, (517, 535): u*v**3/w, (517, 616): u*v**3, (518,
        519): w, (518, 643): u*v*w, (519, 184): -v**2, (519, 346):
        -u*v, (519, 373): -u*v**2, (519, 517): 1, (519, 519): u, (519,
        532): v, (519, 535): -v**3/w, (519, 616): -v**3, (520, 157):
        u*v*w, (520, 292): u*v**2, (520, 505): -u, (520, 508):
        u*v**2/w, (520, 521): w, (520, 532): -u**2, (520, 535):
        u**2*v**2/w, (520, 616): u**2*v**2, (520, 643): u**2*v, (521,
        49): -u*v, (521, 184): -u*v**2/w, (521, 346): -u**2*v/w, (521,
        373): -2*u**2*v**2/w, (521, 454): -u*v**2/w, (521, 516): 1,
        (521, 521): u, (521, 559): u/w, (521, 562): -u*v**2/w**2,
        (522, 360): w, (523, 163): -v*(u*v - w)/w, (523, 173): -v,
        (523, 514): -v**2*(u*v - w)/w**2, (523, 524): -v**2/w, (523,
        531): 1, (523, 595): -v**2*(u*v - w)/w, (523, 605): -v**2,
        (523, 643): -v*w, (524, 184): v*w, (524, 190): -v, (524, 325):
        -v**2/w, (524, 361): w, (524, 373): u*v*w, (524, 514): v*(u**2
        - v)/w, (524, 524): u, (524, 568): -u*v, (524, 616): v**2*w,
        (524, 622): -2*u*v**2/w, (525, 363): w, (526, 364): w, (527,
        177): -v, (527, 272): u*v, (527, 353): u**2*v**2/w, (527,
        434): u*v**2/w, (527, 508): -u**2*v/w, (527, 528): -v**2/w,
        (527, 530): 1, (527, 535): -u**3*v/w, (527, 609): -v**2, (528,
        49): u*w, (528, 184): u*v, (528, 353): -u*v, (528, 365): w,
        (528, 373): 2*u**2*v, (528, 380): u, (528, 454): u*v, (528,
        528): u, (529, 367): w, (529, 373): u**2, (529, 508): -u**2/w,
        (529, 535): -u**3/w, (530, 177): w, (530, 272): -u*w, (530,
        353): -u**2*v, (530, 434): -u*v, (530, 508): u**2, (530, 528):
        v, (530, 535): u**3, (530, 609): v*w, (530, 643): -u*w, (531,
        163): u*v, (531, 173): w, (531, 514): u*v**2/w, (531, 524): v,
        (531, 595): u*v**2, (531, 605): v*w, (532, 505): 1, (532,
        532): u, (533, 272): -v, (533, 353): -u*v**2/w, (533, 434):
        -v**2/w, (533, 538): 1, (533, 539): -v, (534, 508): -v, (534,
        535): -u*v, (534, 536): 1, (534, 537): -v, (534, 622): -u,
        (535, 508): 1, (535, 535): u, (536, 537): w, (537, 487): u/w,
        (537, 514): u**2/w, (537, 534): 1, (537, 535): v, (537, 537):
        u, (538, 508): -u, (538, 535): -u**2, (538, 539): w, (539,
        515): v/w, (539, 533): 1, (539, 539): u, (539, 562): u/w,
        (540, 513): w, (541, 568): v*w, (541, 595): w**2, (541, 622):
        -u*w + v**2, (542, 326): w, (542, 353): v*w, (543, 547): 1,
        (543, 548): -v, (544, 211): v**2*w, (544, 346): v**3, (544,
        532): -v*w, (544, 535): v**3, (544, 545): 1, (544, 546): -v,
        (544, 643): u*v**3, (545, 546): w, (545, 589): u*v*w**2, (545,
        643): u*v**2*w, (546, 238): -v**2, (546, 346): -u*v**2, (546,
        400): -u*v**2, (546, 481): -u*v*w, (546, 544): 1, (546, 546):
        u, (546, 559): v, (546, 562): -v**3/w, (546, 643): -v**3,
        (547, 211): u*v*w, (547, 346): u*v**2, (547, 532): -u*w, (547,
        535): u*v**2, (547, 548): w, (547, 589): u**2*v*w, (547, 643):
        2*u**2*v**2, (548, 76): -u*v, (548, 238): -u*v**2/w, (548,
        346): -u**2*v**2/w, (548, 373): -u*v**2, (548, 400):
        -u**2*v**2/w, (548, 481): -u**2*v, (548, 505): u, (548, 508):
        -u*v**2/w, (548, 543): 1, (548, 548): u, (548, 559): u*v/w,
        (548, 562): -u*v**3/w**2, (549, 387): w, (550, 217): -v*(u*v -
        w)/w, (550, 227): -v, (550, 541): -v**2*(u*v - w)/w**2, (550,
        551): -v**2/w, (550, 558): 1, (550, 589): -v*w**2, (550, 622):
        -v**2*(u*v - w)/w, (550, 632): -v**2, (550, 643): -v**2*w,
        (551, 82): -v*w, (551, 190): -v**2, (551, 238): v*w, (551,
        325): -v**3/w, (551, 388): w, (551, 400): u*v*w, (551, 460):
        -v**2, (551, 541): v*(u**2 - v)/w, (551, 551): u, (551, 568):
        -2*u*v**2, (551, 595): -u*v*w, (551, 622): u*v*(u*w -
        2*v**2)/w, (551, 643): v**2*w, (552, 390): w, (553, 391): w,
        (554, 231): -v, (554, 326): u*v, (554, 353): u*v**2, (554,
        535): -u**2*v, (554, 555): -v**2/w, (554, 557): 1, (554, 636):
        -v**2, (555, 76): u*w, (555, 238): u*v, (555, 373): u*v*w,
        (555, 392): w, (555, 400): u**2*v, (555, 434): u*w, (555,
        555): u, (556, 394): w, (556, 400): u**2, (556, 535): -u**2,
        (557, 231): w, (557, 326): -u*w, (557, 353): -u*v*w, (557,
        535): u**2*w, (557, 555): v, (557, 589): -u*w**2, (557, 636):
        v*w, (557, 643): -u*v*w, (558, 217): u*v, (558, 227): w, (558,
        541): u*v**2/w, (558, 551): v, (558, 622): u*v**2, (558, 632):
        v*w, (559, 532): w, (560, 326): -v, (560, 353): -v**2, (560,
        565): 1, (560, 566): -v, (561, 535): -v*w, (561, 563): 1,
        (561, 564): -v, (561, 568): -u*w, (561, 622): -u*v, (562,
        535): w, (563, 564): w, (564, 514): u, (564, 561): 1, (564,
        562): v, (564, 564): u, (565, 535): -u*w, (565, 566): w, (566,
        508): u, (566, 542): v/w, (566, 560): 1, (566, 562): u*v/w,
        (566, 566): u, (567, 459): 1, (567, 567): u, (568, 136): -v,
        (568, 190): 1, (568, 271): -v**2/w, (568, 325): v/w, (568,
        568): u, (568, 595): -u*v**2/w, (568, 622): u*v/w, (569, 245):
        w, (569, 299): -u, (570, 574): 1, (570, 575): -v, (571, 292):
        v**2, (571, 346): -u*v**2/w, (571, 478): -v, (571, 572): 1,
        (571, 573): -v, (571, 586): -u*v, (571, 616): u*v**2, (571,
        643): -u**2*v**2/w, (572, 292): -u*v**2, (572, 346): u*v,
        (572, 573): w, (572, 616): -u**2*v**2, (572, 643): u**2*v,
        (573, 373): u*v*(u*v - w)/w, (573, 454): u*v**2/w, (573, 571):
        1, (573, 573): u, (573, 586): v, (573, 616): -v**2, (573,
        643): u*v**2/w, (574, 292): -u*v*(u*v - w)/w, (574, 478): -u,
        (574, 575): w, (574, 586): -u**2, (574, 616): -u**2*v*(u*v -
        w)/w, (575, 370): -u*v/w, (575, 373): u**2*v*(u*v - w)/w**2,
        (575, 397): u/w, (575, 454): u*v*(u*v - w)/w**2, (575, 570):
        1, (575, 575): u, (576, 603): -v, (576, 630): 1, (577, 292):
        v**2, (577, 346): -v, (577, 585): 1, (577, 595): -v*(u*v -
        w)/w, (577, 605): -v, (577, 616): u*v**2, (577, 622): u*v*(u*v
        - w)/w**2, (577, 632): u*v/w, (577, 643): -u*v, (578, 136):
        u*v**2/w, (578, 190): -u*v/w, (578, 271): u*v**3/w**2, (578,
        325): -u*v**2/w**2, (578, 487): v**2/w**2, (578, 514): v*(u*v
        - w)/w**2, (578, 578): u, (578, 589): -v**2, (578, 595):
        u**2*v**3/w**2, (578, 604): -v, (578, 616): -v*(u*v - w),
        (578, 622): -u**2*v**2/w**2, (578, 631): 1, (579, 606): -v,
        (579, 633): 1, (580, 607): -v, (580, 634): 1, (581, 245): u*v,
        (581, 299): -u**2*v/w, (581, 481): -u**2*v/w, (581, 584): 1,
        (581, 589): -u**3*v/w, (581, 609): -v, (581, 636): u*v/w,
        (582, 164): -u*v/w, (582, 218): u/w, (582, 353): -u**2*v/w,
        (582, 373): u*v**2/w, (582, 380): u**2/w, (582, 400): -u*v/w,
        (582, 454): u, (582, 582): u, (582, 608): -v, (582, 616):
        -u**2*v**2/w, (582, 635): 1, (582, 643): u**2*v/w, (583, 481):
        -u**2/w, (583, 589): -u**3/w, (583, 610): -v, (583, 616):
        -u**2*v/w, (583, 637): 1, (583, 643): u**2/w, (584, 245):
        -u*w, (584, 292): u*v, (584, 299): u**2, (584, 346): -u, (584,
        481): u**2, (584, 589): u**3, (584, 609): w, (584, 616):
        u**2*v, (584, 636): -u, (584, 643): -u**2, (585, 595): u*v,
        (585, 605): w, (585, 622): -u**2*v/w, (585, 632): -u, (586,
        478): 1, (586, 586): u, (587, 245): -v, (587, 299): u*v/w,
        (587, 592): 1, (587, 593): -v, (588, 271): u*v/w, (588, 325):
        -u/w, (588, 481): -v, (588, 589): -u*v, (588, 590): 1, (588,
        591): -v, (588, 595): u**2*v/w, (588, 622): -u**2/w, (589,
        481): 1, (589, 589): u, (590, 591): w, (591, 460): u/w, (591,
        568): u**2/w, (591, 588): 1, (591, 589): v, (591, 591): u,
        (592, 481): -u, (592, 589): -u**2, (592, 593): w, (593, 373):
        -u*v/w, (593, 400): u/w, (593, 569): v/w, (593, 587): 1, (593,
        593): u, (594, 270): 1, (594, 594): u, (595, 82): 1, (595,
        136): u, (595, 271): u*v/w, (595, 460): v/w, (595, 568):
        u*v/w, (595, 595): u*(u*v + w)/w, (596, 299): 1, (597, 601):
        1, (597, 602): -v, (598, 289): -v, (598, 346): v**2/w, (598,
        599): 1, (598, 600): -v, (598, 613): -u*v, (598, 643):
        u*v**2/w, (599, 292): u**2*v, (599, 481): u*v, (599, 589):
        u**2*v, (599, 600): w, (599, 616): u**3*v, (600, 373):
        -u*v*(u**2 - v)/w, (600, 400): -u*v/w, (600, 454): -u**2*v/w,
        (600, 598): 1, (600, 600): u, (600, 613): v, (600, 643):
        -v**2/w, (601, 289): -u, (601, 292): u**3*v/w, (601, 346):
        u*v/w, (601, 481): u**2*v/w, (601, 589): u**3*v/w, (601, 602):
        w, (601, 613): -u**2, (601, 616): u**4*v/w, (601, 643):
        u**2*v/w, (602, 370): u**2/w, (602, 373): -u*v*(u**3 - u*v +
        w)/w**2, (602, 400): -u**2*v/w**2, (602, 451): u/w, (602,
        454): -u**3*v/w**2, (602, 597): 1, (602, 602): u, (603, 576):
        1, (603, 603): u, (604, 292): -u*v, (604, 481): -v, (604,
        589): -u*v, (604, 612): 1, (604, 616): -u**2*v, (604, 622):
        -v*(u*v - w)/w**2, (604, 632): -v/w, (605, 82): -u*v/w, (605,
        136): -u**2*v/w, (605, 271): -u**2*v**2/w**2, (605, 460):
        -u*v**2/w**2, (605, 487): -u*v/w**2, (605, 514): -v*(u**2 -
        v)/w**2, (605, 541): -v/w**2, (605, 568): -u**2*v**2/w**2,
        (605, 577): 1, (605, 589): u*v, (605, 595): -u**3*v**2/w**2,
        (605, 604): u, (605, 605): u, (605, 616): v*(u**2 - v), (605,
        643): v, (606, 579): 1, (606, 606): u, (607, 580): 1, (607,
        607): u, (608, 292): -u**2*v/w, (608, 299): u*v/w, (608, 611):
        1, (608, 616): -u**3*v/w, (608, 636): -v/w, (609, 110): u/w,
        (609, 164): u**2/w, (609, 353): u**3/w, (609, 373): -u*(u*v -
        w)/w, (609, 434): u**2/w, (609, 454): -u*v/w, (609, 581): 1,
        (609, 589): u**2*v/w, (609, 608): u, (609, 609): u, (609,
        616): u**3*v/w, (610, 292): -u**2/w, (610, 583): 1, (610,
        589): u**2/w, (610, 610): u, (611, 299): -u, (611, 481): -u,
        (611, 589): -u**2, (611, 636): 1, (612, 622): u*v/w, (612,
        632): 1, (613, 289): 1, (613, 613): u, (614, 299): -v/w, (614,
        619): 1, (614, 620): -v, (615, 271): -u**2/w, (615, 292): -v,
        (615, 460): -u/w, (615, 568): -u**2/w, (615, 595): -u**3/w,
        (615, 616): -u*v, (615, 617): 1, (615, 618): -v, (616, 292):
        1, (616, 616): u, (617, 618): w, (618, 271): u/w, (618, 595):
        u**2/w, (618, 615): 1, (618, 616): v, (618, 618): u, (619,
        292): -u, (619, 616): -u**2, (619, 620): w, (620, 373):
        u**2/w, (620, 454): u/w, (620, 596): v/w, (620, 614): 1, (620,
        620): u, (621, 324): 1, (621, 621): u, (622, 136): w, (622,
        271): v, (622, 595): u*v, (622, 622): u, (623, 299): v, (623,
        407): w, (624, 628): 1, (624, 629): -v, (625, 343): -v, (625,
        346): v**3/w, (625, 481): v**2, (625, 589): u*v**2, (625,
        626): 1, (625, 627): -v, (625, 640): -u*v, (625, 643):
        u*v**3/w, (626, 292): u*v*w, (626, 616): u**2*v*w, (626, 627):
        w, (627, 373): -u**2*v, (627, 454): -u*v, (627, 589): -v**2,
        (627, 625): 1, (627, 627): u, (627, 640): v, (627, 643):
        -v**3/w, (628, 292): u**2*v, (628, 343): -u, (628, 346):
        u*v**2/w, (628, 481): u*v, (628, 589): u**2*v, (628, 616):
        u**3*v, (628, 629): w, (628, 640): -u**2, (628, 643):
        u**2*v**2/w, (629, 370): u, (629, 373): -u**3*v/w, (629, 400):
        -u*v/w, (629, 454): -u**2*v/w, (629, 624): 1, (629, 629): u,
        (630, 603): w, (631, 292): -v*w, (631, 568): -v*(u*v - w)/w,
        (631, 578): -v, (631, 616): -u*v*w, (631, 622): -v**2*(u*v -
        w)/w**2, (631, 632): -v**2/w, (631, 639): 1, (632, 136): -u*v,
        (632, 271): -u*v**2/w, (632, 487): -v/w, (632, 514): -u*v/w,
        (632, 589): v*w, (632, 595): -u**2*v**2/w, (632, 604): w,
        (632, 616): u*v*w, (632, 632): u, (633, 606): w, (634, 607):
        w, (635, 299): u*v**2/w, (635, 346): -u**2*v/w, (635, 407):
        u*v, (635, 582): -v, (635, 636): -v**2/w, (635, 638): 1, (635,
        643): -u**3*v/w, (636, 164): u, (636, 353): u**2, (636, 373):
        -u*v, (636, 400): u, (636, 608): w, (636, 616): u**2*v, (636,
        636): u, (637, 346): -u**2/w, (637, 610): w, (637, 616): u**2,
        (637, 643): -u**3/w, (638, 292): -u*w, (638, 299): -u*v, (638,
        346): u**2, (638, 407): -u*w, (638, 582): w, (638, 616):
        -u**2*w, (638, 636): v, (638, 643): u**3, (639, 568): u*v,
        (639, 578): w, (639, 622): u*v**2/w, (639, 632): v, (640,
        343): 1, (640, 640): u, (641, 299): -v**2/w, (641, 407): -v,
        (641, 646): 1, (641, 647): -v, (642, 271): -u, (642, 346): -v,
        (642, 595): -u**2, (642, 643): -u*v, (642, 644): 1, (642,
        645): -v, (643, 346): 1, (643, 643): u, (644, 645): w, (645,
        325): u/w, (645, 622): u**2/w, (645, 642): 1, (645, 643): v,
        (645, 645): u, (646, 346): -u, (646, 643): -u**2, (646, 647):
        w, (647, 373): u, (647, 623): v/w, (647, 641): 1, (647, 647):
        u}, {(0, 3): -v, (0, 4): 1, (1, 428): w, (1, 455): -u, (1,
        482): -u, (1, 509): u**2/w, (1, 617): u*v, (1, 644): -u, (2,
        2): u, (2, 17): 1, (2, 25): u, (2, 49): -u*v, (2, 76): u, (3,
        0): 1, (3, 3): u, (4, 3): w, (5, 86): -v, (5, 113): 1, (6,
        100): w, (6, 103): -v**2, (6, 127): -u, (6, 130): u*v**2/w,
        (7, 19): -v, (7, 87): -v, (7, 114): 1, (7, 265): -v**3, (7,
        292): v**2, (7, 319): -u*v**3*(u*v - 2*w)/w**2, (7, 346):
        u*v**2*(u*v - 2*w)/w**2, (7, 373): u*v**3/w, (7, 400):
        -u*v**2/w, (7, 535): -u*v**2/w, (7, 562): u*v/w, (7, 589):
        u*v**3/w, (7, 616): u*v**2*(u*v - w)/w, (8, 89): -v, (8, 116):
        1, (9, 90): -v, (9, 117): 1, (10, 28): -v, (10, 55): u*v/w,
        (10, 91): -v, (10, 99): -v**2/w, (10, 118): 1, (10, 126): v/w,
        (10, 266): v**2, (10, 293): -u*v**2/w, (10, 320): -u*v**2/w,
        (10, 347): u**2*v**2/w**2, (10, 374): -u*v**2/w, (10, 401):
        u**2*v**2/w**2, (10, 536): u**2*v**2/w**2, (10, 563):
        -u**3*v**2/w**3, (10, 590): -u*v**2/w, (11, 1): u, (11, 102):
        w, (11, 103): v*w, (11, 129): -u, (11, 130): -u*v, (11, 428):
        -u*v, (11, 455): u**2*v/w, (11, 482): u**2*v/w, (11, 509):
        -u**3*v/w**2, (11, 617): -u**2*v**2/w, (11, 644): u**2*v/w,
        (12, 83): v, (12, 101): w, (12, 103): u*v, (12, 106): v, (12,
        110): -u*v/w, (12, 128): -u, (12, 130): -u**2*v/w, (12, 133):
        -u*v/w, (13, 21): -v, (13, 92): -v, (13, 119): 1, (13, 265):
        -v**2*(u*v - w), (13, 292): v*(u*v - w), (13, 319):
        u*v**2*(u*v - w)/w, (13, 346): -u*v*(u*v - w)/w, (13, 423):
        -u*v**2/w, (13, 450): u*v/w, (13, 477): u*v/w, (13, 504):
        -u/w, (13, 612): -u*v**2/w, (13, 639): u*v/w, (14, 20): -v,
        (14, 93): -v, (14, 120): 1, (14, 265): -u*v**2*(u*v - w)/w,
        (14, 268): v**2, (14, 269): -v**3, (14, 292): u*v*(u*v - w)/w,
        (14, 295): -v, (14, 296): v**2, (14, 319): u**2*v**2*(u*v -
        w)/w**2, (14, 322): -u*v**2/w, (14, 323): u*v**3/w, (14, 346):
        -u**2*v*(u*v - w)/w**2, (14, 349): u*v/w, (14, 350):
        -u*v**2/w, (14, 376): -u*v**2/w, (14, 377): v**2, (14, 403):
        u**2*v**2/w**2, (14, 404): -u*v**2/w, (14, 538): u*v/w, (14,
        539): -v, (14, 565): -u**2*v/w**2, (14, 566): u*v/w, (14,
        592): -u*v**2/w, (14, 593): v**2, (15, 96): -v, (15, 123): 1,
        (15, 407): u*v, (15, 431): u*v**2, (15, 434): -u**2*v/w, (15,
        458): -u*v, (15, 461): -u, (15, 485): -u*v, (15, 488): u**2/w,
        (15, 512): u, (15, 596): u**2*v**2/w, (15, 620): u*v**2, (15,
        623): -u**2*v/w, (15, 647): -u*v, (16, 97): -v, (16, 103):
        -u**2*v/w, (16, 124): 1, (16, 130): u**2/w, (16, 265):
        -u**2*v**2/w, (16, 292): u**2*v/w, (16, 319): u**3*v**2/w**2,
        (16, 346): -u**3*v/w**2, (16, 373): u**2*v/w, (16, 400):
        -u**3*v/w**2, (16, 535): -u**2/w, (16, 562): u**3/w**2, (16,
        589): u**2*v/w, (17, 2): -v, (17, 268): -u*v**2, (17, 269):
        v**2*w, (17, 295): u*v, (17, 296): -v*w, (17, 322):
        u**2*v**2/w, (17, 323): -u*v**2, (17, 349): -u**2*v/w, (17,
        350): u*v, (17, 376): u*v, (17, 377): -v*w, (17, 403):
        -u**2*v/w, (17, 404): u*v, (17, 427): -u*v**2, (17, 454): u*v,
        (17, 481): u*v, (17, 508): -u, (17, 538): -u, (17, 539): w,
        (17, 565): u**2/w, (17, 566): -u, (17, 592): u*v, (17, 593):
        -v*w, (17, 616): -u*v**2, (17, 643): u*v, (18, 28): w, (18,
        55): -u, (18, 266): -v*w, (18, 293): u*v, (18, 320): u*v, (18,
        347): -u**2*v/w, (18, 374): u*v, (18, 401): -u**2*v/w, (18,
        536): -u**2*v/w, (18, 563): u**3*v/w**2, (18, 590): u*v, (19,
        7): 1, (19, 19): u, (19, 49): u*v*(u*v - w)/w, (20, 14): 1,
        (20, 20): u, (20, 22): u**2*v/w, (21, 13): 1, (21, 21): u,
        (21, 22): u*v, (22, 265): v**2, (22, 292): -v, (22, 319):
        -u*v**2/w, (22, 346): u*v/w, (22, 373): -v, (22, 400): u*v/w,
        (22, 535): 1, (22, 562): -u/w, (22, 589): -v, (23, 23): u,
        (23, 261): -v**3/w, (23, 288): v**2/w, (23, 315): v**2/w, (23,
        342): -v/w, (23, 369): v**2/w, (23, 396): -v/w, (23, 531):
        -v/w, (23, 558): 1/w, (23, 585): v**2/w, (23, 612): v*(u*v -
        w)/w, (24, 51): -v, (24, 78): 1, (25, 268): v**2, (25, 295):
        -v, (25, 322): -u*v**2/w, (25, 349): u*v/w, (25, 376): -v,
        (25, 403): u*v/w, (25, 538): 1, (25, 565): -u/w, (25, 592):
        -v, (26, 245): -v, (26, 272): 1, (26, 299): u*v/w, (26, 326):
        -u/w, (26, 353): u*v/w, (26, 380): -u**2*v/w**2, (26, 515):
        -u/w, (26, 542): u**2/w**2, (26, 569): u*v/w, (27, 30): -v,
        (27, 31): 1, (28, 266): w, (28, 293): -u, (28, 374): -u, (28,
        536): u**2/w, (28, 590): -u, (28, 617): -u**2, (29, 22): u,
        (29, 29): u, (29, 44): 1, (29, 49): u**2, (29, 52): u, (30,
        27): 1, (30, 30): u, (31, 30): w, (32, 140): -v, (32, 167): 1,
        (33, 154): w, (33, 157): -v**2, (33, 181): -u, (33, 184):
        u*v**2/w, (34, 46): -v, (34, 141): -v, (34, 168): 1, (34,
        265): u**2*v**3/w, (34, 292): -u**2*v**2/w, (34, 319):
        v**3*(u*v - w)/w**2, (34, 346): -v**2*(u*v - w)/w**2, (34,
        373): -u**2*v**2/w, (34, 427): u*v**3/w, (34, 454): -u*v**2/w,
        (34, 481): -u*v**2/w, (34, 508): u*v/w, (34, 535): u**2*v/w,
        (34, 589): -u**2*v**2/w, (34, 616): -u*v**2*(u**2 - v)/w, (34,
        643): -u*v**2/w, (35, 143): -v, (35, 170): 1, (36, 144): -v,
        (36, 171): 1, (37, 55): -v/w, (37, 145): -v, (37, 153):
        -v**2/w, (37, 172): 1, (37, 180): v/w, (37, 320): v**2/w, (37,
        347): -u*v**2/w**2, (37, 401): -u*v**2/w**2, (37, 563):
        u**2*v**2/w**3, (37, 617): -u*v**2/w, (38, 28): u, (38, 156):
        w, (38, 157): v*w, (38, 183): -u, (38, 184): -u*v, (38, 266):
        -u*v, (38, 293): u**2*v/w, (38, 374): u**2*v/w, (38, 536):
        -u**3*v/w**2, (38, 590): u**2*v/w, (38, 617): u**3*v/w, (39,
        137): v, (39, 155): w, (39, 157): u*v, (39, 160): v, (39,
        164): -u*v/w, (39, 182): -u, (39, 184): -u**2*v/w, (39, 187):
        -u*v/w, (40, 48): -v, (40, 146): -v, (40, 173): 1, (40, 261):
        -u*v**2/w, (40, 288): u*v/w, (40, 319): -v**2*(u*v - w)/w,
        (40, 346): v*(u*v - w)/w, (40, 369): u*v/w, (40, 531): -u/w,
        (40, 585): u*v/w, (40, 612): u**2*v/w, (41, 47): -v, (41,
        147): -v, (41, 174): 1, (41, 319): -u*v**2*(u*v - w)/w**2,
        (41, 322): v**2/w, (41, 323): -v**3/w, (41, 346): u*v*(u*v -
        w)/w**2, (41, 349): -v/w, (41, 350): v**2/w, (41, 403):
        -u*v**2/w**2, (41, 404): v**2/w, (41, 565): u*v/w**2, (41,
        566): -v/w, (41, 619): -u*v**2/w, (41, 620): v**2, (42, 150):
        -v, (42, 177): 1, (42, 245): u*v, (42, 269): u*v**2, (42,
        272): -u, (42, 296): -u*v, (42, 353): -u**2*v/w, (42, 377):
        -u*v, (42, 515): u**2/w, (42, 539): u, (42, 569): -u**2*v/w,
        (42, 593): -u*v, (42, 596): -u**3*v/w, (42, 620): -u**2*v,
        (43, 151): -v, (43, 157): -u**2*v/w, (43, 178): 1, (43, 184):
        u**2/w, (43, 319): -u**2*v**2/w**2, (43, 346): u**2*v/w**2,
        (43, 400): u**2*v/w**2, (43, 562): -u**2/w**2, (43, 616):
        u**2*v/w, (44, 29): -v, (44, 265): -u*v**2, (44, 292): u*v,
        (44, 322): -u*v**2/w, (44, 323): v**2, (44, 349): u*v/w, (44,
        350): -v, (44, 373): u*v, (44, 403): u*v/w, (44, 404): -v,
        (44, 535): -u, (44, 565): -u/w, (44, 566): 1, (44, 589): u*v,
        (44, 616): u**2*v, (44, 619): u*v, (44, 620): -v*w, (45, 55):
        1, (45, 320): -v, (45, 347): u*v/w, (45, 401): u*v/w, (45,
        563): -u**2*v/w**2, (45, 617): u*v, (46, 22): -u**2*v/w, (46,
        34): 1, (46, 46): u, (46, 49): -u**3*v/w, (46, 76): -u*v/w,
        (47, 41): 1, (47, 47): u, (47, 49): u**2*v/w, (48, 40): 1,
        (48, 48): u, (48, 49): u*v, (49, 319): v**2/w, (49, 346):
        -v/w, (49, 400): -v/w, (49, 562): 1/w, (49, 616): -v, (50,
        50): u, (50, 261): u*v**2/w, (50, 288): -u*v/w, (50, 369):
        -u*v/w, (50, 423): v**2/w, (50, 450): -v/w, (50, 477): -v/w,
        (50, 504): 1/w, (50, 531): u/w, (50, 585): -u*v/w, (50, 612):
        -v*(u**2 - v)/w, (50, 639): -v/w, (51, 24): 1, (51, 51): u,
        (52, 322): v**2/w, (52, 349): -v/w, (52, 403): -v/w, (52,
        565): 1/w, (52, 619): -v, (53, 299): -v/w, (53, 326): 1/w,
        (53, 380): u*v/w**2, (53, 542): -u/w**2, (53, 596): u*v/w,
        (54, 57): -v, (54, 58): 1, (55, 320): w, (55, 347): -u, (55,
        401): -u, (55, 563): u**2/w, (55, 617): -u*w, (56, 49): u*w,
        (56, 56): u, (56, 71): 1, (56, 79): u, (57, 54): 1, (57, 57):
        u, (58, 57): w, (59, 194): -v, (59, 221): 1, (60, 208): w,
        (60, 211): -v**2, (60, 235): -u, (60, 238): u*v**2/w, (61,
        73): -v, (61, 195): -v, (61, 222): 1, (61, 265): u*v**3, (61,
        292): -u*v**2, (61, 319): v**4*(u*v - w)/w**2, (61, 346):
        -v**3*(u*v - w)/w**2, (61, 373): -u*v**2, (61, 427): v**3*(u*v
        - w)/w, (61, 481): -v**2*(u*v - w)/w, (61, 535): u*v, (61,
        589): -u*v**2, (61, 616): -u**2*v**2, (62, 197): -v, (62,
        224): 1, (63, 198): -v, (63, 225): 1, (64, 1): -v, (64, 55):
        -v**2/w, (64, 199): -v, (64, 207): -v**2/w, (64, 226): 1, (64,
        234): v/w, (64, 320): v**3/w, (64, 347): -u*v**3/w**2, (64,
        401): -u*v**3/w**2, (64, 428): v**2, (64, 455): -u*v**2/w,
        (64, 482): -u*v**2/w, (64, 509): u**2*v**2/w**2, (64, 563):
        u**2*v**3/w**3, (64, 644): -u*v**2/w, (65, 55): u, (65, 210):
        w, (65, 211): v*w, (65, 237): -u, (65, 238): -u*v, (65, 320):
        -u*v, (65, 347): u**2*v/w, (65, 401): u**2*v/w, (65, 563):
        -u**3*v/w**2, (65, 617): u**2*v, (66, 191): v, (66, 209): w,
        (66, 211): u*v, (66, 214): v, (66, 218): -u*v/w, (66, 236):
        -u, (66, 238): -u**2*v/w, (66, 241): -u*v/w, (67, 75): -v,
        (67, 200): -v, (67, 227): 1, (67, 315): -u*v**2/w, (67, 319):
        -v**3*(u*v - w)/w, (67, 342): u*v/w, (67, 346): v**2*(u*v -
        w)/w, (67, 396): u*v/w, (67, 427): -v**2*(u*v - w), (67, 481):
        v*(u*v - w), (67, 558): -u/w, (67, 612): u*v, (68, 74): -v,
        (68, 201): -v, (68, 228): 1, (68, 319): -u*v**3*(u*v -
        w)/w**2, (68, 322): v**3/w, (68, 323): -v**4/w, (68, 346):
        u*v**2*(u*v - w)/w**2, (68, 349): -v**2/w, (68, 350): v**3/w,
        (68, 403): -u*v**3/w**2, (68, 404): v**3/w, (68, 427):
        -u*v**2*(u*v - w)/w, (68, 430): v**2, (68, 431): -v**3, (68,
        457): -u*v**2/w, (68, 458): v**2, (68, 481): u*v*(u*v - w)/w,
        (68, 484): -v, (68, 485): v**2, (68, 511): u*v/w, (68, 512):
        -v, (68, 565): u*v**2/w**2, (68, 566): -v**2/w, (68, 646):
        -u*v**2/w, (68, 647): v**2, (69, 204): -v, (69, 231): 1, (69,
        299): u*v, (69, 323): u*v**2, (69, 326): -u, (69, 350): -u*v,
        (69, 380): -u**2*v/w, (69, 404): -u*v, (69, 542): u**2/w, (69,
        566): u, (69, 596): -u**2*v, (69, 620): -u*v*w, (70, 205): -v,
        (70, 211): -u**2*v/w, (70, 232): 1, (70, 238): u**2/w, (70,
        319): -u**2*v**3/w**2, (70, 346): u**2*v**2/w**2, (70, 400):
        u**2*v**2/w**2, (70, 427): -u**2*v**2/w, (70, 454): u**2*v/w,
        (70, 481): u**2*v/w, (70, 508): -u**2/w, (70, 562):
        -u**2*v/w**2, (70, 643): u**2*v/w, (71, 56): -v, (71, 319):
        -u*v**2, (71, 322): -u*v**3/w, (71, 323): v**3, (71, 346):
        u*v, (71, 349): u*v**2/w, (71, 350): -v**2, (71, 400): u*v,
        (71, 403): u*v**2/w, (71, 404): -v**2, (71, 430): -u*v**2,
        (71, 431): v**2*w, (71, 457): u*v, (71, 458): -v*w, (71, 484):
        u*v, (71, 485): -v*w, (71, 511): -u, (71, 512): w, (71, 562):
        -u, (71, 565): -u*v/w, (71, 566): v, (71, 616): u*v*w, (71,
        646): u*v, (71, 647): -v*w, (72, 1): w, (72, 55): v, (72,
        320): -v**2, (72, 347): u*v**2/w, (72, 401): u*v**2/w, (72,
        428): -v*w, (72, 455): u*v, (72, 482): u*v, (72, 509):
        -u**2*v/w, (72, 563): -u**2*v**2/w**2, (72, 644): u*v, (73,
        22): -u*v, (73, 49): -u**2*v, (73, 61): 1, (73, 73): u, (73,
        76): -u*v**2/w, (74, 68): 1, (74, 74): u, (74, 76): u**2*v/w,
        (75, 67): 1, (75, 75): u, (75, 76): u*v, (76, 319): v**3/w,
        (76, 346): -v**2/w, (76, 400): -v**2/w, (76, 427): v**2, (76,
        454): -v, (76, 481): -v, (76, 508): 1, (76, 562): v/w, (76,
        643): -v, (77, 77): u, (77, 261): v**2, (77, 288): -v, (77,
        369): -v, (77, 531): 1, (77, 585): -v, (77, 612): -u*v, (78,
        51): w, (79, 322): v**3/w, (79, 349): -v**2/w, (79, 403):
        -v**2/w, (79, 430): v**2, (79, 457): -v, (79, 484): -v, (79,
        511): 1, (79, 565): v/w, (79, 646): -v, (80, 299): -v**2/w,
        (80, 326): v/w, (80, 380): u*v**2/w**2, (80, 407): -v, (80,
        434): u*v/w, (80, 461): 1, (80, 488): -u/w, (80, 542):
        -u*v/w**2, (80, 623): u*v/w, (81, 84): -v, (81, 85): 1, (82,
        455): 1, (82, 509): -u/w, (82, 617): -v, (82, 644): u*v/w,
        (83, 83): u, (83, 98): 1, (83, 106): u, (83, 427): -u*v, (83,
        481): u, (84, 81): 1, (84, 84): u, (85, 84): w, (86, 5): 1,
        (86, 86): u, (87, 127): 1, (87, 130): -v**2/w, (88, 6): 1,
        (88, 87): u, (88, 100): -v, (88, 157): v**2, (88, 184):
        u*v**2*(u*v - 2*w)/w**2, (88, 211): -u*v**2/w, (88, 238):
        u*v/w, (88, 265): u*v**2, (88, 319): u**2*v**2*(u*v -
        2*w)/w**2, (88, 373): u**2*v**2*(u*v - 2*w)/w**2, (88, 400):
        u**2*v/w, (88, 589): -u**2*v**2/w, (89, 8): 1, (89, 89): u,
        (90, 9): 1, (90, 90): u, (91, 10): 1, (91, 18): v/w, (91, 91):
        u, (91, 99): u*v/w, (91, 293): v**2/w, (91, 347):
        -u*v**2/w**2, (91, 406): -v, (91, 460): u*v/w, (91, 536):
        -u*v**2/w**2, (91, 563): u**2*v**2/w**3, (91, 622): -u*v*(u*v
        - w)/w**2, (92, 82): u, (92, 129): 1, (92, 130): v, (92, 455):
        -u*v/w, (92, 509): u**2*v/w**2, (92, 617): u*v**2/w, (92,
        644): -u**2*v**2/w**2, (93, 110): v/w, (93, 128): 1, (93,
        130): u*v/w, (93, 133): v/w, (94, 11): 1, (94, 45): u*v/w,
        (94, 72): -u/w, (94, 92): u, (94, 102): -v, (94, 157): v*(u*v
        - w), (94, 184): -u*v*(u*v - w)/w, (94, 265): u*v*(u*v - w),
        (94, 319): -u**2*v*(u*v - w)/w, (94, 373): -u**2*v*(u*v -
        w)/w, (94, 423): u**2*v/w, (94, 477): -u**2/w, (95, 12): 1,
        (95, 93): u, (95, 101): -v, (95, 157): u*v*(u*v - w)/w, (95,
        160): -v, (95, 161): v**2, (95, 184): -u**2*v*(u*v - w)/w**2,
        (95, 187): u*v/w, (95, 188): -u*v**2/w, (95, 214): u*v/w, (95,
        215): -v, (95, 241): -u**2*v/w**2, (95, 242): u*v/w, (95,
        265): u**2*v*(u*v - w)/w, (95, 268): -u*v, (95, 269): u*v**2,
        (95, 319): -u**3*v*(u*v - w)/w**2, (95, 322): u**2*v/w, (95,
        323): -u**2*v**2/w, (95, 373): -u**3*v*(u*v - w)/w**2, (95,
        376): u**2*v/w, (95, 377): -u**2*v**2/w, (95, 403):
        -u**3*v/w**2, (95, 404): u**2*v/w, (95, 592): u**2*v/w, (95,
        593): -u*v, (96, 15): 1, (96, 53): -u*v, (96, 80): u, (96,
        96): u, (96, 431): -u**2*v, (96, 434): u*v/w, (96, 485): u**2,
        (96, 488): -u/w, (96, 596): -u*v**2/w, (96, 623): u*v/w, (97,
        16): 1, (97, 22): u**2/w, (97, 97): u, (97, 103): u**3/w, (97,
        157): u**2*v/w, (97, 184): -u**3*v/w**2, (97, 211): -u**2/w,
        (97, 238): u**3/w**2, (97, 265): u**3*v/w, (97, 319):
        -u**4*v/w**2, (97, 373): -u**4*v/w**2, (97, 400): u**4/w**2,
        (97, 589): -u**3/w, (98, 49): u*v, (98, 76): -u, (98, 83): -v,
        (98, 160): u*v, (98, 161): -v*w, (98, 187): -u**2*v/w, (98,
        188): u*v, (98, 214): -u, (98, 215): w, (98, 241): u**2/w,
        (98, 242): -u, (98, 268): u**2*v, (98, 269): -u*v*w, (98,
        322): -u**3*v/w, (98, 323): u**2*v, (98, 376): -u**3*v/w, (98,
        377): u**2*v, (98, 403): u**3/w, (98, 404): -u**2, (98, 427):
        u**2*v, (98, 481): -u**2, (98, 592): -u**2, (98, 593): u*w,
        (99, 293): -v, (99, 347): u*v/w, (99, 406): w, (99, 460): -u,
        (99, 536): u*v/w, (99, 563): -u**2*v/w**2, (99, 622): u*(u*v -
        w)/w, (100, 88): 1, (100, 100): u, (100, 427): u*v*(u*v -
        w)/w, (100, 643): -u**2*v*(u*v - w)/w**2, (101, 95): 1, (101,
        101): u, (101, 103): u**2*v/w, (102, 94): 1, (102, 102): u,
        (102, 103): u*v, (103, 157): -v, (103, 184): u*v/w, (103,
        211): 1, (103, 238): -u/w, (103, 265): -u*v, (103, 319):
        u**2*v/w, (103, 373): u**2*v/w, (103, 400): -u**2/w, (103,
        589): u, (104, 104): u, (104, 153): v**2/w, (104, 180): -v/w,
        (104, 207): -v/w, (104, 234): 1/w, (104, 261): u*v**2/w, (104,
        315): -u*v/w, (104, 369): -u*v/w, (104, 396): u/w, (104, 585):
        -u*v/w, (105, 429): -v, (105, 483): 1, (106, 160): -v, (106,
        187): u*v/w, (106, 214): 1, (106, 241): -u/w, (106, 268):
        -u*v, (106, 322): u**2*v/w, (106, 376): u**2*v/w, (106, 403):
        -u**2/w, (106, 592): u, (107, 137): 1, (107, 164): -u/w, (107,
        191): -u/w, (107, 218): u**2/w**2, (107, 245): u, (107, 299):
        -u**2/w, (107, 353): -u**2/w, (107, 380): u**3/w**2, (107,
        569): -u**2/w, (108, 111): -v, (108, 112): 1, (109, 50): w,
        (109, 77): -u, (109, 455): v, (109, 509): -u*v/w, (109, 617):
        -v**2, (109, 644): u*v**2/w, (110, 110): u, (110, 125): 1,
        (110, 133): u, (110, 454): -u*v, (110, 508): u, (110, 616):
        u*v**2, (110, 643): -u*v, (111, 108): 1, (111, 111): u, (112,
        111): w, (113, 86): w, (114, 19): w, (114, 22): -v**2, (114,
        127): v, (114, 130): -v**3/w, (115, 87): w, (115, 127): -v,
        (115, 265): v**2*w, (115, 319): u*v**2*(u*v - 2*w)/w, (115,
        373): u*v**2*(u*v - 2*w)/w, (115, 400): u*v, (115, 589):
        -u*v**2, (116, 89): w, (117, 90): w, (118, 91): w, (118, 99):
        v, (118, 158): v**2, (118, 185): -u*v**2/w, (118, 212):
        -u*v**2/w, (118, 239): u**2*v**2/w**2, (118, 293): v**3/w,
        (118, 347): -u*v**3/w**2, (118, 433): -v, (118, 487): u*v/w,
        (118, 536): -u*v**3/w**2, (118, 563): u**2*v**3/w**3, (118,
        595): v**2, (118, 622): -u*v**2/w, (119, 21): w, (119, 22):
        v*w, (119, 50): -u*v, (119, 77): u**2*v/w, (119, 109): u,
        (119, 129): v, (119, 130): v**2, (119, 455): -u*v**2/w, (119,
        509): u**2*v**2/w**2, (119, 617): u*v**3/w, (119, 644):
        -u**2*v**3/w**2, (120, 2): v, (120, 20): w, (120, 22): u*v,
        (120, 25): v, (120, 110): v**2/w, (120, 128): v, (120, 130):
        u*v**2/w, (120, 133): v**2/w, (121, 92): w, (121, 129): -v,
        (121, 265): v*w*(u*v - w), (121, 319): -u*v*(u*v - w), (121,
        373): -u*v*(u*v - w), (121, 423): u*v, (121, 477): -u, (122,
        93): w, (122, 128): -v, (122, 265): u*v*(u*v - w), (122, 268):
        -v*w, (122, 269): v**2*w, (122, 319): -u**2*v*(u*v - w)/w,
        (122, 322): u*v, (122, 323): -u*v**2, (122, 373): -u**2*v*(u*v
        - w)/w, (122, 376): u*v, (122, 377): -u*v**2, (122, 403):
        -u**2*v/w, (122, 404): u*v, (122, 592): u*v, (122, 593): -v*w,
        (123, 29): u*v, (123, 56): -u, (123, 96): w, (123, 431):
        -u*v*w, (123, 434): u*v**2/w, (123, 485): u*w, (123, 488):
        -u*v/w, (123, 596): -u*v**3/w, (123, 623): u*v**2/w, (124,
        97): w, (124, 103): u**2, (124, 265): u**2*v, (124, 319):
        -u**3*v/w, (124, 373): -u**3*v/w, (124, 400): u**3/w, (124,
        589): -u**2, (125, 110): -v, (125, 268): u*v*w, (125, 269):
        -v*w**2, (125, 322): -u**2*v, (125, 323): u*v*w, (125, 376):
        -u**2*v, (125, 377): u*v*w, (125, 403): u**2, (125, 404):
        -u*w, (125, 427): u*v*w, (125, 481): -u*w, (125, 592): -u*w,
        (125, 593): w**2, (126, 158): -v*w, (126, 185): u*v, (126,
        212): u*v, (126, 239): -u**2*v/w, (126, 293): -v**2, (126,
        347): u*v**2/w, (126, 433): w, (126, 487): -u, (126, 536):
        u*v**2/w, (126, 563): -u**2*v**2/w**2, (126, 595): -v*w, (126,
        622): u*v, (127, 115): 1, (127, 127): u, (127, 454): u*v*(u*v
        - w)/w, (127, 616): -u*v**2*(u*v - w)/w, (128, 122): 1, (128,
        128): u, (128, 130): u**2*v/w, (129, 121): 1, (129, 129): u,
        (129, 130): u*v, (130, 265): -v*w, (130, 319): u*v, (130,
        373): u*v, (130, 400): -u, (130, 589): w, (131, 131): u, (131,
        261): v**2, (131, 315): -v, (131, 369): -v, (131, 396): 1,
        (131, 585): -v, (132, 456): -v, (132, 510): 1, (132, 618):
        v**2, (132, 645): -v, (133, 268): -v*w, (133, 322): u*v, (133,
        376): u*v, (133, 403): -u, (133, 592): w, (134, 245): w, (134,
        299): -u, (134, 353): -u, (134, 380): u**2/w, (134, 569): -u,
        (135, 138): -v, (135, 139): 1, (136, 374): 1, (136, 536):
        -u/w, (136, 644): -v/w, (137, 137): u, (137, 152): 1, (137,
        160): u, (137, 265): -u*v, (137, 292): u, (138, 135): 1, (138,
        138): u, (139, 138): w, (140, 32): 1, (140, 140): u, (141,
        181): 1, (141, 184): -v**2/w, (142, 33): 1, (142, 130):
        -u*v*(u*v - w)/w**2, (142, 141): u, (142, 154): -v, (142,
        184): -u**2*v*(u*v - w)/w**2, (142, 211): v**2/w, (142, 238):
        -u*v**2/w**2, (142, 265): -u**3*v**2/w, (142, 319):
        -u*v**2*(u*v - w)/w**2, (142, 373): -u**3*v*(u*v - w)/w**2,
        (142, 400): -u**2*v**2/w**2, (142, 427): -u**2*v**2/w, (142,
        454): -u**2*v*(u*v - w)/w**2, (142, 616): -u**2*v**2/w, (143,
        35): 1, (143, 143): u, (144, 36): 1, (144, 144): u, (145, 37):
        1, (145, 45): v/w, (145, 145): u, (145, 153): u*v/w, (145,
        244): -v, (145, 271): u*v/w, (145, 347): v**2/w**2, (145,
        563): -u*v**2/w**3, (145, 568): u*v/w, (145, 595): u**2*v/w,
        (145, 622): u*v**2/w**2, (146, 136): u, (146, 183): 1, (146,
        184): v, (146, 374): -u*v/w, (146, 536): u**2*v/w**2, (146,
        644): u*v**2/w**2, (147, 164): v/w, (147, 182): 1, (147, 184):
        u*v/w, (147, 187): v/w, (148, 18): -u/w, (148, 38): 1, (148,
        45): -u**2/w, (148, 103): -u*v, (148, 130): u**2*v/w, (148,
        146): u, (148, 156): -v, (148, 157): -u**2*v, (148, 184):
        u**3*v/w, (148, 211): -v, (148, 238): u*v/w, (148, 261):
        u**2*v/w, (148, 288): -u**2/w, (148, 319): u*v*(u*v - w)/w,
        (148, 373): u**4*v/w, (148, 400): u**2*v/w, (148, 454):
        u**3*v/w, (149, 39): 1, (149, 103): -u**2*v/w, (149, 107): -v,
        (149, 130): u**3*v/w**2, (149, 134): u*v/w, (149, 147): u,
        (149, 155): -v, (149, 157): -u**3*v/w, (149, 161): -u*v, (149,
        184): u**4*v/w**2, (149, 188): u**2*v/w, (149, 211): -u*v/w,
        (149, 214): -v/w, (149, 238): u**2*v/w**2, (149, 241):
        u*v/w**2, (149, 319): u**2*v*(u*v - w)/w**2, (149, 322):
        -u*v/w, (149, 323): u*v**2/w, (149, 373): u**5*v/w**2, (149,
        377): u**3*v/w, (149, 400): u**3*v/w**2, (149, 403):
        u**2*v/w**2, (149, 454): u**4*v/w**2, (149, 458): u**2*v/w,
        (149, 619): u**2*v/w, (149, 620): -u*v, (150, 26): u, (150,
        42): 1, (150, 53): u**2, (150, 150): u, (150, 269): -u**2*v,
        (150, 296): u**2, (150, 353): u*v/w, (150, 515): -u/w, (150,
        569): u*v/w, (150, 596): u**2*v/w, (151, 43): 1, (151, 49):
        u**2/w, (151, 103): -u**2/w, (151, 130): u**3/w**2, (151,
        151): u, (151, 184): u**4/w**2, (151, 319): u**3*v/w**2, (151,
        373): u**5/w**2, (151, 454): u**4/w**2, (151, 616): -u**3/w,
        (152, 22): -u, (152, 49): -u**2, (152, 106): -u, (152, 107):
        w, (152, 133): u**2/w, (152, 134): -u, (152, 137): -v, (152,
        160): -u**2, (152, 161): u*w, (152, 187): u**3/w, (152, 188):
        -u**2, (152, 265): u**2*v, (152, 292): -u**2, (152, 322):
        u**2*v/w, (152, 323): -u*v, (152, 376): u**4/w, (152, 377):
        -u**3, (152, 457): u**3/w, (152, 458): -u**2, (152, 619):
        -u**2, (152, 620): u*w, (153, 244): w, (153, 271): -u, (153,
        347): -v/w, (153, 563): u*v/w**2, (153, 568): -u, (153, 595):
        -u**2, (153, 622): -u*v/w, (154, 142): 1, (154, 154): u, (154,
        265): u*v*(u*v - w)/w, (154, 589): u**2*v/w, (154, 616):
        u**3*v/w, (154, 643): u**2*v**2/w**2, (155, 149): 1, (155,
        155): u, (155, 157): u**2*v/w, (156, 148): 1, (156, 156): u,
        (156, 157): u*v, (157, 103): 1, (157, 130): -u/w, (157, 157):
        u, (157, 184): -u**2/w, (157, 319): -u*v/w, (157, 373):
        -u**3/w, (157, 454): -u**2/w, (157, 616): u, (158, 99): -v/w,
        (158, 126): 1/w, (158, 153): -u*v/w, (158, 158): u, (158,
        180): u/w, (158, 261): -u**2*v/w, (158, 369): u**2/w, (158,
        423): -u*v/w, (158, 450): u/w, (158, 612): -u*v/w, (159, 267):
        -v, (159, 294): 1, (160, 106): 1, (160, 133): -u/w, (160,
        160): u, (160, 187): -u**2/w, (160, 322): -u*v/w, (160, 376):
        -u**3/w, (160, 457): -u**2/w, (160, 619): u, (161, 191): 1/w,
        (161, 218): -u/w**2, (161, 299): u/w, (161, 380): -u**2/w**2,
        (161, 596): -u**2/w, (162, 165): -v, (162, 166): 1, (163, 77):
        1, (163, 374): v, (163, 536): -u*v/w, (163, 644): -v**2/w,
        (164, 164): u, (164, 179): 1, (164, 187): u, (164, 373): -u*v,
        (164, 535): u, (164, 589): -u*v, (164, 616): -u**2*v, (165,
        162): 1, (165, 165): u, (166, 165): w, (167, 140): w, (168,
        46): w, (168, 49): -v**2, (168, 181): v, (168, 184): -v**3/w,
        (169, 141): w, (169, 181): -v, (169, 265): -u**2*v**2, (169,
        319): -v**2*(u*v - w)/w, (169, 373): -u**2*v*(u*v - w)/w,
        (169, 400): -u*v**2/w, (169, 427): -u*v**2, (169, 454):
        -u*v*(u*v - w)/w, (169, 616): -u*v**2, (170, 143): w, (171,
        144): w, (172, 145): w, (172, 153): v, (172, 212): v**2/w,
        (172, 239): -u*v**2/w**2, (172, 347): v**3/w**2, (172, 352):
        -v, (172, 514): u*v/w, (172, 563): -u*v**3/w**3, (172, 622):
        v**2/w, (173, 48): w, (173, 49): v*w, (173, 77): -u*v/w, (173,
        163): u, (173, 183): v, (173, 184): v**2, (173, 374):
        -u*v**2/w, (173, 536): u**2*v**2/w**2, (173, 644):
        u*v**3/w**2, (174, 29): v, (174, 47): w, (174, 49): u*v, (174,
        52): v, (174, 164): v**2/w, (174, 182): v, (174, 184):
        u*v**2/w, (174, 187): v**2/w, (175, 146): w, (175, 183): -v,
        (175, 261): u*v, (175, 288): -u, (175, 319): v*(u*v - w),
        (175, 373): u**3*v, (175, 400): u*v, (175, 454): u**2*v, (176,
        147): w, (176, 182): -v, (176, 319): u*v*(u*v - w)/w, (176,
        322): -v, (176, 323): v**2, (176, 373): u**4*v/w, (176, 377):
        u**2*v, (176, 400): u**2*v/w, (176, 403): u*v/w, (176, 454):
        u**3*v/w, (176, 458): u*v, (176, 619): u*v, (176, 620): -v*w,
        (177, 2): -u, (177, 29): -u**2, (177, 150): w, (177, 269):
        -u*v*w, (177, 296): u*w, (177, 353): u*v**2/w, (177, 515):
        -u*v/w, (177, 569): u*v**2/w, (177, 596): u**2*v**2/w, (178,
        151): w, (178, 157): u**2, (178, 319): u**2*v/w, (178, 373):
        u**4/w, (178, 454): u**3/w, (178, 616): -u**2, (179, 164): -v,
        (179, 265): u*v*w, (179, 292): -u*w, (179, 322): u*v, (179,
        323): -v*w, (179, 376): u**3, (179, 377): -u**2*w, (179, 457):
        u**2, (179, 458): -u*w, (179, 619): -u*w, (179, 620): w**2,
        (180, 212): -v, (180, 239): u*v/w, (180, 347): -v**2/w, (180,
        352): w, (180, 514): -u, (180, 563): u*v**2/w**2, (180, 622):
        -v, (181, 169): 1, (181, 181): u, (181, 373): u*v*(u*v - w)/w,
        (181, 589): u**2*v**2/w, (181, 616): u**3*v**2/w, (181, 643):
        u*v**2/w, (182, 176): 1, (182, 182): u, (182, 184): u**2*v/w,
        (183, 175): 1, (183, 183): u, (183, 184): u*v, (184, 319): -v,
        (184, 373): -u**2, (184, 454): -u, (184, 616): w, (185, 185):
        u, (185, 261): -u*v, (185, 369): u, (185, 423): -v, (185,
        450): 1, (185, 612): -v, (186, 375): -v, (186, 537): 1, (186,
        591): -v, (186, 618): -u*v, (187, 322): -v, (187, 376): -u**2,
        (187, 457): -u, (187, 619): w, (188, 299): 1, (188, 380):
        -u/w, (188, 596): -u, (189, 192): -v, (189, 193): 1, (190,
        401): 1, (190, 563): -u/w, (190, 590): -v, (190, 644):
        -v**2/w, (191, 191): u, (191, 206): 1, (191, 214): u, (191,
        319): -u*v, (191, 346): u, (192, 189): 1, (192, 192): u, (193,
        192): w, (194, 59): 1, (194, 194): u, (195, 235): 1, (195,
        238): -v**2/w, (196, 60): 1, (196, 103): v**2, (196, 130):
        -u*v**2/w, (196, 184): -u*v*(u*v - w)/w, (196, 195): u, (196,
        208): -v, (196, 211): v**3/w, (196, 238): -u*v**3/w**2, (196,
        265): -u**2*v**2, (196, 319): -u*v**3*(u*v - w)/w**2, (196,
        373): -u**2*v*(u*v - w)/w, (196, 400): -u**2*v**3/w**2, (196,
        427): -u*v**2*(u*v - w)/w, (196, 454): -u**2*v**2/w, (196,
        643): -u**2*v**2/w, (197, 62): 1, (197, 197): u, (198, 63): 1,
        (198, 198): u, (199, 64): 1, (199, 72): v/w, (199, 199): u,
        (199, 207): u*v/w, (199, 298): -v, (199, 325): u*v/w, (199,
        347): v**3/w**2, (199, 482): v**2/w, (199, 509): -u*v**2/w**2,
        (199, 563): -u*v**3/w**3, (199, 568): u*v**2/w, (199, 595):
        u*v, (199, 622): u*v**3/w**2, (200, 190): u, (200, 237): 1,
        (200, 238): v, (200, 401): -u*v/w, (200, 563): u**2*v/w**2,
        (200, 590): u*v**2/w, (200, 644): u*v**3/w**2, (201, 218):
        v/w, (201, 236): 1, (201, 238): u*v/w, (201, 241): v/w, (202,
        45): -u, (202, 65): 1, (202, 103): -v*w, (202, 130): u*v,
        (202, 157): -u*v*w, (202, 184): u**2*v, (202, 200): u, (202,
        210): -v, (202, 211): -v**2, (202, 238): u*v**2/w, (202, 315):
        u**2*v/w, (202, 319): u*v**2*(u*v - w)/w, (202, 342): -u**2/w,
        (202, 373): u**3*v, (202, 400): u**2*v**2/w, (202, 427):
        u*v*(u*v - w), (202, 454): u**2*v, (203, 66): 1, (203, 103):
        -u*v, (203, 106): -v, (203, 130): u**2*v/w, (203, 133): u*v/w,
        (203, 157): -u**2*v, (203, 161): -v*w, (203, 184): u**3*v/w,
        (203, 188): u*v, (203, 201): u, (203, 209): -v, (203, 211):
        -u*v**2/w, (203, 214): -v**2/w, (203, 238): u**2*v**2/w**2,
        (203, 241): u*v**2/w**2, (203, 319): u**2*v**2*(u*v - w)/w**2,
        (203, 322): -u*v**2/w, (203, 323): u*v**3/w, (203, 373):
        u**4*v/w, (203, 377): u**2*v, (203, 400): u**3*v**2/w**2,
        (203, 403): u**2*v**2/w**2, (203, 427): u**2*v*(u*v - w)/w,
        (203, 430): -u*v, (203, 431): u*v**2, (203, 454): u**3*v/w,
        (203, 457): u**2*v/w, (203, 646): u**2*v/w, (203, 647): -u*v,
        (204, 53): u*w, (204, 69): 1, (204, 204): u, (204, 323):
        -u**2*v, (204, 350): u**2, (204, 380): u*v/w, (204, 542):
        -u/w, (204, 596): u*v, (205, 70): 1, (205, 76): u**2/w, (205,
        157): -u**2, (205, 184): u**3/w, (205, 205): u, (205, 211):
        u**3/w, (205, 319): u**3*v**2/w**2, (205, 373): u**4/w, (205,
        427): u**3*v/w, (205, 643): -u**3/w, (206, 49): -u*w, (206,
        160): -u*w, (206, 161): w**2, (206, 187): u**2, (206, 188):
        -u*w, (206, 191): -v, (206, 319): u**2*v, (206, 322):
        u**2*v**2/w, (206, 323): -u*v**2, (206, 346): -u**2, (206,
        376): u**3, (206, 377): -u**2*w, (206, 430): u**2*v, (206,
        431): -u*v*w, (206, 646): -u**2, (206, 647): u*w, (207, 298):
        w, (207, 325): -u, (207, 347): -v**2/w, (207, 482): -v, (207,
        509): u*v/w, (207, 563): u*v**2/w**2, (207, 568): -u*v, (207,
        595): -u*w, (207, 622): -u*v**2/w, (208, 196): 1, (208, 208):
        u, (208, 319): u*v*(u*v - w)/w, (208, 589): u**2*v**2/w, (208,
        616): u**2*v, (208, 643): u**2*v**3/w**2, (209, 203): 1, (209,
        209): u, (209, 211): u**2*v/w, (210, 202): 1, (210, 210): u,
        (210, 211): u*v, (211, 157): w, (211, 184): -u, (211, 319):
        -u*v**2/w, (211, 373): -u**2, (211, 427): -u*v, (211, 643): u,
        (212, 153): -v, (212, 180): 1, (212, 212): u, (212, 261):
        -u*v, (212, 369): u, (212, 639): -u*v/w, (213, 321): -v, (213,
        348): 1, (214, 160): w, (214, 187): -u, (214, 322): -u*v**2/w,
        (214, 376): -u**2, (214, 430): -u*v, (214, 646): u, (215, 83):
        1, (215, 110): -u/w, (215, 191): v/w, (215, 218): -u*v/w**2,
        (215, 299): u*v/w, (215, 380): -u**2*v/w**2, (215, 407): u,
        (215, 434): -u**2/w, (215, 623): -u**2/w, (216, 219): -v,
        (216, 220): 1, (217, 23): w, (217, 77): v, (217, 401): v,
        (217, 563): -u*v/w, (217, 590): -v**2, (217, 644): -v**3/w,
        (218, 218): u, (218, 233): 1, (218, 241): u, (218, 400): -u*v,
        (218, 562): u, (218, 616): -u*v*w, (219, 216): 1, (219, 219):
        u, (220, 219): w, (221, 194): w, (222, 73): w, (222, 76):
        -v**2, (222, 235): v, (222, 238): -v**3/w, (223, 195): w,
        (223, 235): -v, (223, 265): -u*v**2*w, (223, 319): -v**3*(u*v
        - w)/w, (223, 373): -u*v*(u*v - w), (223, 400): -u*v**3/w,
        (223, 427): -v**2*(u*v - w), (223, 454): -u*v**2, (223, 643):
        -u*v**2, (224, 197): w, (225, 198): w, (226, 104): v**2, (226,
        131): -u*v**2/w, (226, 199): w, (226, 207): v, (226, 212):
        v**3/w, (226, 239): -u*v**3/w**2, (226, 347): v**4/w**2, (226,
        379): -v, (226, 482): v**3/w, (226, 509): -u*v**3/w**2, (226,
        541): u*v/w, (226, 563): -u*v**4/w**3, (226, 568): v**2, (226,
        622): v**3/w, (227, 23): -u*v, (227, 75): w, (227, 76): v*w,
        (227, 77): -u*v**2/w, (227, 217): u, (227, 237): v, (227,
        238): v**2, (227, 401): -u*v**2/w, (227, 563): u**2*v**2/w**2,
        (227, 590): u*v**3/w, (227, 644): u*v**4/w**2, (228, 56): v,
        (228, 74): w, (228, 76): u*v, (228, 79): v, (228, 218):
        v**2/w, (228, 236): v, (228, 238): u*v**2/w, (228, 241):
        v**2/w, (229, 200): w, (229, 237): -v, (229, 315): u*v, (229,
        319): v**2*(u*v - w), (229, 342): -u, (229, 373): u**2*v*w,
        (229, 400): u*v**2, (229, 427): v*w*(u*v - w), (229, 454):
        u*v*w, (230, 201): w, (230, 236): -v, (230, 319): u*v**2*(u*v
        - w)/w, (230, 322): -v**2, (230, 323): v**3, (230, 373):
        u**3*v, (230, 377): u*v*w, (230, 400): u**2*v**2/w, (230,
        403): u*v**2/w, (230, 427): u*v*(u*v - w), (230, 430): -v*w,
        (230, 431): v**2*w, (230, 454): u**2*v, (230, 457): u*v, (230,
        646): u*v, (230, 647): -v*w, (231, 29): -u*w, (231, 204): w,
        (231, 323): -u*v*w, (231, 350): u*w, (231, 380): u*v**2/w,
        (231, 542): -u*v/w, (231, 596): u*v**2, (232, 205): w, (232,
        211): u**2, (232, 319): u**2*v**2/w, (232, 373): u**3, (232,
        427): u**2*v, (232, 643): -u**2, (233, 218): -v, (233, 319):
        u*v*w, (233, 322): u*v**2, (233, 323): -v**2*w, (233, 346):
        -u*w, (233, 376): u**2*w, (233, 377): -u*w**2, (233, 430):
        u*v*w, (233, 431): -v*w**2, (233, 646): -u*w, (233, 647):
        w**2, (234, 104): -v*w, (234, 131): u*v, (234, 212): -v**2,
        (234, 239): u*v**2/w, (234, 347): -v**3/w, (234, 379): w,
        (234, 482): -v**2, (234, 509): u*v**2/w, (234, 541): -u, (234,
        563): u*v**3/w**2, (234, 568): -v*w, (234, 622): -v**2, (235,
        223): 1, (235, 235): u, (235, 400): u*v*(u*v - w)/w, (235,
        589): u*v**2, (235, 616): u**2*v**2, (235, 643): u*v**3/w,
        (236, 230): 1, (236, 236): u, (236, 238): u**2*v/w, (237,
        229): 1, (237, 237): u, (237, 238): u*v, (238, 319): -v**2,
        (238, 373): -u*w, (238, 427): -v*w, (238, 643): w, (239, 239):
        u, (239, 261): -v*w, (239, 369): w, (239, 639): -v, (240,
        402): -v, (240, 564): 1, (240, 618): -v*w, (241, 322): -v**2,
        (241, 376): -u*w, (241, 430): -v*w, (241, 646): w, (242, 299):
        v, (242, 380): -u*v/w, (242, 407): w, (242, 434): -u, (242,
        623): -u, (243, 246): -v, (243, 247): 1, (244, 347): 1/w,
        (244, 644): u/w, (245, 157): u, (245, 245): u, (245, 260): 1,
        (245, 265): u**2, (245, 268): u, (245, 643): u**2/w, (246,
        243): 1, (246, 246): u, (247, 246): w, (248, 248): u, (248,
        410): 1, (249, 316): 1, (249, 319): -v**2/w, (250, 22): u*v/w,
        (250, 49): u**2*v/w, (250, 103): u**2*v/w, (250, 130):
        u*v**2/w**2, (250, 157): u**3*v/w, (250, 184): u**2*v**2/w**2,
        (250, 249): u, (250, 262): -v, (250, 265): u**4*v/w, (250,
        292): u**2*v/w, (250, 319): u**2*v/w, (250, 373):
        u**3*v**2/w**2, (250, 411): 1, (250, 427): u**3*v/w, (250,
        454): u**2*v**2/w**2, (250, 589): v**2/w, (250, 616):
        u*v*(u**2 + v)/w, (251, 251): u, (251, 413): 1, (252, 252): u,
        (252, 414): 1, (253, 253): u, (253, 261): u*v/w, (253, 271):
        -v/w, (253, 415): 1, (253, 423): v/w, (253, 595): -u*v/w,
        (253, 644): v**2/w**2, (254, 244): u, (254, 318): 1, (254,
        319): v, (254, 347): -u*v/w**2, (254, 644): -u**2*v/w**2,
        (255, 299): v/w, (255, 317): 1, (255, 319): u*v/w, (255, 322):
        v/w, (256, 99): -u/w, (256, 130): -u*v/w, (256, 153): -u**2/w,
        (256, 184): -u**2*v/w, (256, 254): u, (256, 261): -u**3/w,
        (256, 264): -v, (256, 265): -u**2*v, (256, 373): -u**3*v/w,
        (256, 416): 1, (256, 423): -u**2/w, (256, 454): -u**2*v/w,
        (256, 589): -v, (256, 612): -u**2/w, (256, 616): -u*v, (257,
        130): -u**2*v/w**2, (257, 134): -v/w, (257, 184):
        -u**3*v/w**2, (257, 188): -u*v/w, (257, 255): u, (257, 263):
        -v, (257, 265): -u**3*v/w, (257, 269): -u*v, (257, 373):
        -u**4*v/w**2, (257, 377): -u**2*v/w, (257, 417): 1, (257,
        454): -u**3*v/w**2, (257, 458): -u*v/w, (257, 589): -u*v/w,
        (257, 592): -v/w, (257, 616): -u**2*v/w, (257, 619): -u*v/w,
        (258, 107): u, (258, 161): u**2, (258, 191): -u/w, (258, 258):
        u, (258, 269): u**3, (258, 299): -u**2/w, (258, 420): 1, (258,
        431): u**2, (258, 569): -u**2/w, (258, 620): u**2, (258, 623):
        -u**2*v/w**2, (259, 130): -u**2/w**2, (259, 184): -u**3/w**2,
        (259, 259): u, (259, 373): -u**4/w**2, (259, 421): 1, (259,
        427): u**2/w, (259, 454): -u**3/w**2, (260, 103): -u, (260,
        133): -u/w, (260, 134): 1, (260, 157): -u**2, (260, 187):
        -u**2/w, (260, 188): u, (260, 245): -v, (260, 265): -u**3,
        (260, 268): -u**2, (260, 269): u*w, (260, 376): -u**3/w, (260,
        377): u**2, (260, 427): -u**2, (260, 457): -u**2/w, (260,
        458): u, (260, 616): -u**2, (261, 271): 1, (261, 595): u,
        (261, 644): -v/w, (262, 157): -u**2*v/w, (262, 250): 1, (262,
        262): u, (262, 265): -u**3*v/w, (262, 292): -u*v/w, (262,
        616): -u**2*v/w, (262, 643): -u**3*v/w**2, (263, 257): 1,
        (263, 263): u, (263, 265): u**2*v/w, (264, 256): 1, (264,
        264): u, (264, 265): u*v, (265, 130): 1/w, (265, 184): u/w,
        (265, 265): u, (265, 373): u**2/w, (265, 454): u/w, (266, 18):
        1/w, (266, 45): u/w, (266, 99): u/w, (266, 153): u**2/w, (266,
        261): u*(u**2 - v)/w, (266, 266): u, (266, 288): u/w, (266,
        315): u/w, (266, 423): u**2/w, (266, 612): u**2/w, (267, 159):
        1, (267, 267): u, (267, 645): u/w, (268, 133): 1/w, (268,
        187): u/w, (268, 268): u, (268, 376): u**2/w, (268, 457): u/w,
        (269, 569): 1/w, (269, 596): u/w, (270, 273): -v, (270, 274):
        1, (271, 509): -u/w, (271, 536): -u**2/w, (271, 644): 1, (272,
        265): u*w, (272, 272): u, (272, 287): 1, (272, 295): u, (272,
        589): -u**2, (272, 616): -u**3, (273, 270): 1, (273, 273): u,
        (274, 273): w, (275, 356): u, (275, 437): 1, (275, 599): -v,
        (276, 370): -u**2, (276, 373): u**2*v**2/w, (276, 451): -u,
        (276, 454): u*v**2/w, (276, 613): w, (276, 616): -v**2, (277,
        22): u*v**2/w, (277, 49): u**2*v**2/w, (277, 103): u*v, (277,
        130): u*v**3/w**2, (277, 157): u**2*v, (277, 184):
        u**2*v**3/w**2, (277, 289): -v, (277, 292): u**2*v**2/w, (277,
        357): u, (277, 373): v**3*(u**3 - w)/w**2, (277, 438): 1,
        (277, 454): u**2*v**3/w**2, (277, 535): v**2/w, (277, 600):
        -v, (277, 616): u**2*v, (278, 359): u, (278, 440): 1, (278,
        602): -v, (279, 360): u, (279, 441): 1, (279, 603): -v, (280,
        136): -v, (280, 271): -v**2/w, (280, 361): u, (280, 369):
        u*v/w, (280, 374): v**2/w, (280, 442): 1, (280, 450): v/w,
        (280, 536): -u*v**2/w**2, (280, 595): -u*v**2/w, (280, 604):
        -v, (280, 612): -v**2/w, (281, 271): u, (281, 372): -u**2,
        (281, 373): -u**2*v, (281, 453): -u, (281, 454): -u*v, (281,
        509): u**2*v/w**2, (281, 536): u**3*v/w**2, (281, 615): w,
        (281, 616): v*w, (281, 644): -u*v/w, (282, 353): -u**2*v/w,
        (282, 371): -u**2, (282, 373): -u**3*v/w, (282, 376):
        -u**2*v/w, (282, 434): -u*v/w, (282, 452): -u, (282, 454):
        -u**2*v/w, (282, 457): -u*v/w, (282, 596): v, (282, 614): w,
        (282, 616): u*v, (282, 619): v, (283, 22): -u*v, (283, 49):
        -u**2*v, (283, 126): -u/w, (283, 130): -u*v**2/w, (283, 180):
        -u**2/w, (283, 184): -u**2*v**2/w, (283, 291): -v, (283, 292):
        -u**2*v, (283, 362): u, (283, 369): -u**3/w, (283, 373):
        -v**2*(u**3 - w)/w, (283, 443): 1, (283, 450): -u**2/w, (283,
        454): -u**2*v**2/w, (283, 535): -v, (283, 605): -v, (284, 22):
        -u**2*v/w, (284, 26): -v, (284, 49): -u**3*v/w, (284, 53):
        -u*v, (284, 130): -u**2*v**2/w**2, (284, 134): -v**2/w, (284,
        184): -u**3*v**2/w**2, (284, 188): -u*v**2/w, (284, 290): -v,
        (284, 292): -u**3*v/w, (284, 296): -u*v, (284, 363): u, (284,
        373): -u*v**2*(u**3 - w)/w**2, (284, 376): v**2/w, (284, 377):
        -u**2*v**2/w, (284, 444): 1, (284, 454): -u**3*v**2/w**2,
        (284, 458): -u*v**2/w, (284, 535): -u*v/w, (284, 538): -v/w,
        (284, 606): -v, (285, 110): u**2/w, (285, 134): u, (285, 164):
        u**3/w, (285, 188): u**2, (285, 353): u**4/w, (285, 366): u,
        (285, 377): u**3, (285, 434): u**3/w, (285, 447): 1, (285,
        458): u**2, (285, 569): u*(u*v - w)/w, (285, 596): u**2*(u*v -
        w)/w, (285, 609): -v, (286, 22): -u**2/w, (286, 49): -u**3/w,
        (286, 130): -u**2*v/w**2, (286, 184): -u**3*v/w**2, (286,
        292): -u**3/w, (286, 367): u, (286, 373): -u**3*(u*v -
        w)/w**2, (286, 448): 1, (286, 454): -u**2*(u*v - w)/w**2,
        (286, 610): -v, (286, 616): -u**2*v/w, (287, 25): -u, (287,
        26): w, (287, 52): -u**2, (287, 53): u*w, (287, 130): -u,
        (287, 133): -u*v/w, (287, 134): v, (287, 184): -u**2, (287,
        187): -u**2*v/w, (287, 188): u*v, (287, 272): -v, (287, 295):
        -u**2, (287, 296): u*w, (287, 373): -u**3, (287, 376):
        -u**3*v/w, (287, 377): u**2*v, (287, 454): -u**2, (287, 457):
        -u**2*v/w, (287, 458): u*v, (288, 136): w, (288, 271): v,
        (288, 374): -v, (288, 536): u*v/w, (288, 595): u*v, (289,
        157): -u*v, (289, 265): -u**2*v, (289, 277): 1, (289, 289): u,
        (289, 292): -u*v**2/w, (289, 589): u**3*v/w, (289, 616):
        u**2*v*(u**2 - v)/w, (290, 284): 1, (290, 290): u, (290, 292):
        u**2*v/w, (291, 283): 1, (291, 291): u, (291, 292): u*v, (292,
        22): 1, (292, 49): u, (292, 130): v/w, (292, 184): u*v/w,
        (292, 292): u, (292, 373): u**2*v/w, (292, 454): u*v/w, (293,
        99): 1, (293, 153): u, (293, 293): u, (293, 612): u, (294,
        267): w, (294, 591): -u, (294, 618): -u**2, (295, 25): 1,
        (295, 52): u, (295, 133): v/w, (295, 187): u*v/w, (295, 295):
        u, (295, 376): u**2*v/w, (295, 457): u*v/w, (296, 353): -v/w,
        (296, 515): 1/w, (297, 300): -v, (297, 301): 1, (298, 347):
        v/w, (298, 482): 1, (298, 590): u, (298, 644): u*v/w, (299,
        211): u, (299, 299): u, (299, 314): 1, (299, 319): u**2, (299,
        322): u, (299, 589): u**2, (299, 643): u**2*v/w, (300, 297):
        1, (300, 300): u, (301, 300): w, (302, 248): w, (303, 316): v,
        (303, 319): -v**3/w, (303, 424): w, (303, 427): -v**2, (304,
        49): u*v, (304, 157): u**2*v, (304, 184): u*v**2/w, (304,
        249): w, (304, 265): u**3*v, (304, 316): -v, (304, 319):
        u**2*v**2/w, (304, 346): u**2*v/w, (304, 373): u**2*v**2/w,
        (304, 427): u**2*v, (304, 616): v**2, (304, 643): u**3*v/w,
        (305, 251): w, (306, 252): w, (307, 253): w, (307, 261): v,
        (307, 325): -v/w, (307, 590): v**2/w, (307, 622): -u*v/w,
        (307, 644): v**3/w**2, (308, 298): u, (308, 318): v, (308,
        319): v**2, (308, 347): -u*v**2/w**2, (308, 426): w, (308,
        427): v*w, (308, 482): -u*v/w, (308, 590): -u**2*v/w, (308,
        644): -u**2*v**2/w**2, (309, 299): v**2/w, (309, 317): v,
        (309, 319): u*v**2/w, (309, 322): v**2/w, (309, 407): v, (309,
        425): w, (309, 427): u*v, (309, 430): v, (310, 153): -u, (310,
        184): -u*v, (310, 254): w, (310, 261): -u**2, (310, 318): -v,
        (310, 319): -u**2*v, (310, 373): -u**2*v, (310, 616): -v*w,
        (310, 639): -u**2/w, (311, 184): -u**2*v/w, (311, 188): -v,
        (311, 255): w, (311, 317): -v, (311, 319): -u**3*v/w, (311,
        323): -u*v, (311, 373): -u**3*v/w, (311, 377): -u*v, (311,
        616): -u*v, (311, 619): -v, (312, 83): -u, (312, 161): u*w,
        (312, 191): -u*v/w, (312, 258): w, (312, 269): u**2*w, (312,
        299): -u**2*v/w, (312, 407): -u**2, (312, 569): -u**2*v/w,
        (312, 596): -u**2, (312, 623): u**2*(u*w - v**2)/w**2, (312,
        647): u**2, (313, 184): -u**2/w, (313, 259): w, (313, 265):
        u**2, (313, 319): -u**3/w, (313, 373): -u**3/w, (314, 157):
        -u*w, (314, 187): -u, (314, 188): w, (314, 265): -u**2*w,
        (314, 299): -v, (314, 322): -u**2, (314, 323): u*w, (314,
        376): -u**2, (314, 377): u*w, (314, 643): -u**2, (315, 325):
        1, (315, 590): -v, (315, 622): u, (315, 644): -v**2/w, (316,
        211): -u**2*v/w, (316, 304): 1, (316, 316): u, (316, 319):
        -u**3*v/w, (316, 346): -u*v/w, (316, 589): -u**3*v/w, (316,
        643): -u**2*v*(u*v + w)/w**2, (317, 311): 1, (317, 317): u,
        (317, 319): u**2*v/w, (318, 310): 1, (318, 318): u, (318,
        319): u*v, (319, 184): 1, (319, 319): u, (319, 373): u, (320,
        45): 1, (320, 153): u, (320, 261): u**2, (320, 320): u, (320,
        342): u/w, (320, 423): u, (320, 639): u**2/w, (321, 213): 1,
        (321, 321): u, (321, 591): u, (321, 645): u*v/w, (322, 187):
        1, (322, 322): u, (322, 376): u, (323, 596): 1, (324, 327):
        -v, (324, 328): 1, (325, 536): -u, (325, 590): w, (325, 644):
        v, (326, 319): u*w, (326, 326): u, (326, 341): 1, (326, 349):
        u, (326, 616): -u**2*w, (327, 324): 1, (327, 327): u, (328,
        327): w, (329, 356): w, (329, 626): -v, (330, 370): -u*w,
        (330, 373): u*v**2, (330, 640): w, (330, 643): -v**2, (331,
        49): u*v**2, (331, 157): u*v*w, (331, 184): u*v**3/w, (331,
        343): -v, (331, 346): u**2*v**2/w, (331, 357): w, (331, 373):
        u**2*v**3/w, (331, 400): -v**3/w, (331, 562): v**2/w, (331,
        627): -v, (331, 643): u**2*v, (332, 359): w, (332, 629): -v,
        (333, 360): w, (333, 630): -v, (334, 190): -v, (334, 325):
        -v**2/w, (334, 361): w, (334, 369): v, (334, 401): v**2/w,
        (334, 563): -u*v**2/w**2, (334, 622): -u*v**2/w, (334, 631):
        -v, (334, 639): -v**2/w, (335, 325): u, (335, 372): -u*w,
        (335, 373): -u*v*w, (335, 536): u**2*v/w, (335, 590): -u*v,
        (335, 642): w, (335, 643): v*w, (335, 644): -u*v**2/w, (336,
        353): -u*v, (336, 371): -u*w, (336, 373): -u**2*v, (336, 376):
        -u*v, (336, 623): v, (336, 641): w, (336, 643): u*v, (336,
        646): v, (337, 49): -u*v*w, (337, 180): -u, (337, 184):
        -u*v**2, (337, 345): -v, (337, 346): -u**2*v, (337, 362): w,
        (337, 369): -u**2, (337, 373): -u**2*v**2, (337, 400): v**2,
        (337, 562): -v, (337, 632): -v, (338, 49): -u**2*v, (338, 53):
        -v*w, (338, 184): -u**2*v**2/w, (338, 188): -v**2, (338, 344):
        -v, (338, 346): -u**3*v/w, (338, 350): -u*v, (338, 363): w,
        (338, 373): -u**3*v**2/w, (338, 377): -u*v**2, (338, 400):
        u*v**2/w, (338, 403): v**2/w, (338, 562): -u*v/w, (338, 565):
        -v/w, (338, 633): -v, (339, 164): u**2, (339, 188): u*w, (339,
        353): u**3, (339, 366): w, (339, 377): u**2*w, (339, 596):
        u*(u*v - w), (339, 636): -v, (340, 49): -u**2, (340, 184):
        -u**2*v/w, (340, 346): -u**3/w, (340, 367): w, (340, 373):
        -u**2*(u*v - w)/w, (340, 637): -v, (340, 643): -u**2*v/w,
        (341, 52): -u*w, (341, 53): w**2, (341, 184): -u*w, (341,
        187): -u*v, (341, 188): v*w, (341, 326): -v, (341, 349):
        -u**2, (341, 350): u*w, (341, 373): -u**2*w, (341, 376):
        -u**2*v, (341, 377): u*v*w, (342, 190): w, (342, 325): v,
        (342, 401): -v, (342, 563): u*v/w, (342, 622): u*v, (343,
        211): -u*v, (343, 319): -u**2*v, (343, 331): 1, (343, 343): u,
        (343, 346): -u*v**2/w, (343, 616): u**3*v, (343, 643):
        -u**2*v**2/w, (344, 338): 1, (344, 344): u, (344, 346):
        u**2*v/w, (345, 337): 1, (345, 345): u, (345, 346): u*v, (346,
        49): w, (346, 184): v, (346, 346): u, (346, 373): u*v, (347,
        153): w, (347, 347): u, (347, 639): u, (348, 321): w, (348,
        618): -u*w, (349, 52): w, (349, 187): v, (349, 349): u, (349,
        376): u*v, (350, 380): -v/w, (350, 542): 1/w, (351, 354): -v,
        (351, 355): 1, (352, 212): 1, (352, 347): v/w, (352, 536):
        v/w, (352, 644): u*v/w, (353, 184): u, (353, 353): u, (353,
        368): 1, (353, 373): u**2, (353, 376): u, (353, 616): u*v,
        (354, 351): 1, (354, 354): u, (355, 354): w, (356, 626): 1,
        (357, 343): 1, (357, 346): -v**2/w, (357, 370): v, (357, 373):
        -v**3/w, (358, 292): u*v, (358, 370): -v, (358, 373):
        u**2*v**2/w, (358, 400): v**2/w, (358, 454): u*v**2/w, (358,
        616): u**2*v, (358, 627): 1, (359, 629): 1, (360, 630): 1,
        (361, 239): v**2/w**2, (361, 514): -v/w, (361, 563):
        v**3/w**3, (361, 631): 1, (361, 639): v/w, (361, 644):
        v**3/w**2, (362, 212): -u*v/w, (362, 345): 1, (362, 346): v,
        (362, 347): -u*v**2/w**2, (362, 352): u, (362, 372): v, (362,
        373): v**2, (362, 536): -u*v**2/w**2, (362, 644):
        -u**2*v**2/w**2, (363, 326): v/w, (363, 344): 1, (363, 346):
        u*v/w, (363, 349): v/w, (363, 353): v**2/w, (363, 371): v,
        (363, 373): u*v**2/w, (363, 376): v**2/w, (364, 372): -v,
        (364, 373): -u**2*v, (364, 400): -v, (364, 454): -u*v, (364,
        612): -u, (364, 632): 1, (365, 371): -v, (365, 373):
        -u**3*v/w, (365, 377): -u*v, (365, 400): -u*v/w, (365, 403):
        -v/w, (365, 454): -u**2*v/w, (365, 458): -v, (365, 633): 1,
        (366, 164): -u*v/w, (366, 299): -u, (366, 353): -u**2*v/w,
        (366, 596): u*(u*w - v**2)/w, (366, 620): u*w, (366, 636): 1,
        (367, 373): -u**3/w, (367, 454): -u**2/w, (367, 637): 1, (367,
        643): u**2/w, (368, 353): -v, (368, 376): -u**2, (368, 377):
        u*w, (368, 457): -u, (368, 458): w, (368, 616): -u*w, (369,
        239): -v/w, (369, 514): 1, (369, 563): -v**2/w**2, (369, 644):
        -v**2/w, (370, 184): -u**2*v/w, (370, 358): 1, (370, 370): u,
        (370, 373): -u**3*v/w, (370, 535): -u*v/w, (370, 616):
        -u**2*v**2/w, (371, 365): 1, (371, 371): u, (371, 373):
        u**2*v/w, (372, 364): 1, (372, 372): u, (372, 373): u*v, (373,
        373): u, (373, 454): 1, (374, 288): 1, (374, 374): u, (374,
        612): u, (375, 186): 1, (375, 375): u, (375, 618): v, (376,
        376): u, (376, 457): 1, (377, 380): 1/w, (378, 381): -v, (378,
        382): 1, (379, 104): w, (379, 212): v, (379, 347): v**2/w,
        (379, 482): v, (379, 563): v/w, (379, 590): u*v, (379, 644):
        u*v**2/w, (380, 238): u, (380, 380): u, (380, 395): 1, (380,
        400): u**2, (380, 403): u, (380, 643): u*v, (381, 378): 1,
        (381, 381): u, (382, 381): w, (383, 572): w, (383, 626): v,
        (384, 343): v, (384, 346): -v**3/w, (384, 397): v, (384, 400):
        -v**3/w, (384, 478): w, (384, 481): -v**2, (385, 346): u*v,
        (385, 373): u*v**2, (385, 397): -v, (385, 400): v**3/w, (385,
        454): v**2, (385, 573): w, (385, 627): v, (385, 643): u**2*v,
        (386, 575): w, (386, 629): v, (387, 576): w, (387, 630): v,
        (388, 131): v**2/w, (388, 239): v**3/w**2, (388, 509):
        v**3/w**2, (388, 541): -v/w, (388, 563): v**4/w**3, (388,
        577): w, (388, 585): v, (388, 590): v**3/w, (388, 631): v,
        (388, 639): v**2/w, (388, 644): v**4/w**2, (389, 104): -u*v,
        (389, 212): -u*v**2/w, (389, 345): v, (389, 346): v**2, (389,
        347): -u*v**3/w**2, (389, 379): u, (389, 399): v, (389, 400):
        v**2, (389, 480): w, (389, 481): v*w, (389, 482): -u*v**2/w,
        (389, 563): -u*v**2/w**2, (389, 590): -u**2*v**2/w, (389,
        644): -u**2*v**3/w**2, (390, 326): v**2/w, (390, 344): v,
        (390, 346): u*v**2/w, (390, 349): v**2/w, (390, 380): v**2/w,
        (390, 398): v, (390, 400): u*v**2/w, (390, 403): v**2/w, (390,
        461): v, (390, 479): w, (390, 481): u*v, (390, 484): v, (391,
        373): -u*v*w, (391, 399): -v, (391, 400): -v**2, (391, 454):
        -v*w, (391, 578): w, (391, 632): v, (391, 639): -u, (392,
        373): -u**2*v, (392, 377): -v*w, (392, 398): -v, (392, 400):
        -u*v**2/w, (392, 403): -v**2/w, (392, 454): -u*v, (392, 457):
        -v, (392, 579): w, (392, 633): v, (393, 218): -u*v/w, (393,
        299): -u*v, (393, 380): -u**2*v/w, (393, 407): -u*w, (393,
        582): w, (393, 623): u*(u*w - v**2)/w, (393, 636): v, (393,
        647): u*w, (394, 373): -u**2, (394, 583): w, (394, 589): u**2,
        (394, 637): v, (394, 643): u**2*v/w, (395, 376): -u*w, (395,
        377): w**2, (395, 380): -v, (395, 643): -u*w, (396, 131): -v,
        (396, 239): -v**2/w, (396, 509): -v**2/w, (396, 541): 1, (396,
        563): -v**3/w**2, (396, 590): -v**2, (396, 644): -v**3/w,
        (397, 238): -u**2*v/w, (397, 385): 1, (397, 397): u, (397,
        400): -u**3*v/w, (397, 562): -u*v/w, (397, 643): -u**2*v**2/w,
        (398, 392): 1, (398, 398): u, (398, 400): u**2*v/w, (399,
        391): 1, (399, 399): u, (399, 400): u*v, (400, 373): w, (401,
        342): 1, (401, 401): u, (401, 639): u, (402, 240): 1, (402,
        402): u, (402, 645): v, (403, 376): w, (404, 380): v/w, (404,
        434): 1, (405, 408): -v, (405, 409): 1, (406, 293): 1, (406,
        347): -u/w, (406, 617): u, (406, 644): -u**2/w, (407, 103): u,
        (407, 407): u, (407, 422): 1, (407, 427): u**2, (407, 430): u,
        (407, 616): u**2, (407, 643): -u**3/w, (408, 405): 1, (408,
        408): u, (409, 408): w, (410, 248): -v, (410, 302): 1, (411,
        262): w, (411, 265): -v**2, (411, 316): -u, (411, 319):
        u*v**2/w, (412, 49): -u*v**2/w, (412, 76): u*v/w, (412, 157):
        -u**2*v**2/w, (412, 184): -u*v**3/w**2, (412, 211): u**2*v/w,
        (412, 238): u*v**2/w**2, (412, 249): -v, (412, 265):
        -u**2*v*(u*v - w)/w, (412, 303): 1, (412, 373):
        -u**2*v**3/w**2, (412, 400): u**2*v**2/w**2, (412, 424): -v,
        (412, 481): u**2*v/w, (412, 589): u**3*v/w, (412, 616):
        -v**3/w, (412, 643): v**2/w, (413, 251): -v, (413, 305): 1,
        (414, 252): -v, (414, 306): 1, (415, 253): -v, (415, 261):
        -v**2/w, (415, 307): 1, (415, 315): v/w, (415, 460): -v/w,
        (415, 568): -u*v/w, (415, 617): v**2/w, (415, 644):
        -u*v**2/w**2, (416, 264): w, (416, 265): v*w, (416, 293):
        -u*v/w, (416, 318): -u, (416, 319): -u*v, (416, 347):
        u**2*v/w**2, (416, 406): u, (416, 617): -u**2*v/w, (416, 644):
        u**3*v/w**2, (417, 245): v, (417, 263): w, (417, 265): u*v,
        (417, 268): v, (417, 299): -u*v/w, (417, 317): -u, (417, 319):
        -u**2*v/w, (417, 322): -u*v/w, (418, 153): u*v/w, (418, 184):
        u*v**2/w, (418, 207): -u/w, (418, 238): -u*v/w, (418, 254):
        -v, (418, 261): u**2*v/w, (418, 308): 1, (418, 315): -u**2/w,
        (418, 373): u**2*v**2/w, (418, 400): -u**2*v/w, (418, 426):
        -v, (418, 427): -u**2*v, (418, 585): -u**2/w, (418, 616):
        v**2, (418, 643): -v, (419, 184): u**2*v**2/w**2, (419, 188):
        v**2/w, (419, 238): -u**2*v/w**2, (419, 242): -v/w, (419,
        255): -v, (419, 309): 1, (419, 373): u**3*v**2/w**2, (419,
        377): u*v**2/w, (419, 400): -u**3*v/w**2, (419, 404): -u*v/w,
        (419, 425): -v, (419, 427): -u**3*v/w, (419, 431): -u*v, (419,
        616): u*v**2/w, (419, 619): v**2/w, (419, 643): -u*v/w, (419,
        646): -v/w, (420, 137): -u, (420, 161): -u*v, (420, 191):
        u**2/w, (420, 215): u, (420, 245): -u**2, (420, 258): -v,
        (420, 269): -u**2*v, (420, 299): u**3/w, (420, 312): 1, (420,
        323): u**2, (420, 569): u**3/w, (420, 593): u**2, (420, 623):
        u**2*(u*v - w)/w**2, (421, 184): u**2*v/w**2, (421, 238):
        -u**2/w**2, (421, 259): -v, (421, 265): -u**2*v/w, (421, 313):
        1, (421, 319): u**2/w, (421, 373): u**3*v/w**2, (421, 400):
        -u**3/w**2, (421, 427): -u**3/w, (422, 157): u*v, (422, 187):
        u*v/w, (422, 188): -v, (422, 211): -u, (422, 241): -u/w, (422,
        242): 1, (422, 265): u**2*v, (422, 319): -u**2, (422, 376):
        u**2*v/w, (422, 377): -u*v, (422, 403): -u**2/w, (422, 404):
        u, (422, 407): -v, (422, 430): -u**2, (422, 431): u*w, (422,
        589): -u**2, (423, 460): 1, (423, 568): u, (423, 617): -v,
        (423, 644): u*v/w, (424, 103): -u**2*v/w, (424, 412): 1, (424,
        424): u, (424, 427): -u**3*v/w, (424, 481): -u*v/w, (424,
        589): -u**2*v/w, (424, 616): -u**3*v/w, (424, 643):
        u**4*v/w**2, (425, 419): 1, (425, 425): u, (425, 427):
        u**2*v/w, (426, 418): 1, (426, 426): u, (426, 427): u*v, (427,
        184): -v/w, (427, 238): 1/w, (427, 373): -u*v/w, (427, 400):
        u/w, (427, 427): u, (428, 45): -v/w, (428, 72): 1/w, (428,
        153): -u*v/w, (428, 207): u/w, (428, 261): -u*(u*v - w)/w,
        (428, 423): -u*v/w, (428, 428): u, (428, 477): u/w, (428,
        585): u**2/w, (429, 105): 1, (429, 429): u, (429, 618): u,
        (429, 645): -u**2/w, (430, 187): -v/w, (430, 241): 1/w, (430,
        376): -u*v/w, (430, 403): u/w, (430, 430): u, (431, 596):
        -v/w, (431, 623): 1/w, (432, 435): -v, (432, 436): 1, (433,
        158): w, (433, 212): -u, (433, 293): v, (433, 347): -u*v/w,
        (433, 509): v/w, (433, 617): u*v, (433, 644): -u**2*v/w, (434,
        130): u, (434, 434): u, (434, 449): 1, (434, 454): u**2, (434,
        457): u, (434, 589): u*v, (435, 432): 1, (435, 435): u, (436,
        435): w, (437, 599): w, (437, 626): -u, (438, 289): w, (438,
        292): -v**2, (438, 343): -u, (438, 346): u*v**2/w, (438, 451):
        v, (438, 454): -v**3/w, (439, 373): -v**2*(u*v - w)/w, (439,
        451): -v, (439, 481): u*v, (439, 589): u**2*v, (439, 600): w,
        (439, 627): -u, (440, 602): w, (440, 629): -u, (441, 603): w,
        (441, 630): -u, (442, 185): v**2/w, (442, 239): -u*v**2/w**2,
        (442, 487): -v/w, (442, 536): v**3/w**2, (442, 563):
        -u*v**3/w**3, (442, 604): w, (442, 612): v, (442, 617):
        v**3/w, (442, 631): -u, (442, 639): -u*v/w, (442, 644):
        -u*v**3/w**2, (443, 158): -u*v, (443, 212): u**2*v/w, (443,
        291): w, (443, 292): v*w, (443, 293): -u*v**2/w, (443, 345):
        -u, (443, 346): -u*v, (443, 347): u**2*v**2/w**2, (443, 433):
        u, (443, 453): v, (443, 454): v**2, (443, 509): -u*v**2/w**2,
        (443, 617): -u**2*v**2/w, (443, 644): u**3*v**2/w**2, (444,
        272): v, (444, 290): w, (444, 292): u*v, (444, 295): v, (444,
        326): -u*v/w, (444, 344): -u, (444, 346): -u**2*v/w, (444,
        349): -u*v/w, (444, 434): v**2/w, (444, 452): v, (444, 454):
        u*v**2/w, (444, 457): v**2/w, (445, 373): v*(u*v - w), (445,
        453): -v, (445, 585): -u, (445, 605): w, (445, 632): -u, (446,
        373): u*v*(u*v - w)/w, (446, 376): -v, (446, 377): v**2, (446,
        403): u*v/w, (446, 404): -v, (446, 452): -v, (446, 606): w,
        (446, 633): -u, (447, 110): -u*v/w, (447, 245): -u*w, (447,
        299): u**2, (447, 434): -u**2*v/w, (447, 569): u*(u*w -
        v**2)/w, (447, 593): u*w, (447, 609): w, (447, 636): -u, (448,
        373): u**2*v/w, (448, 400): -u**2/w, (448, 610): w, (448,
        616): u**2, (448, 637): -u, (448, 643): -u**3/w, (449, 376):
        u*v, (449, 377): -v*w, (449, 403): -u, (449, 404): w, (449,
        434): -v, (449, 589): -u*w, (450, 185): -v, (450, 239): u*v/w,
        (450, 487): 1, (450, 536): -v**2/w, (450, 563): u*v**2/w**2,
        (450, 617): -v**2, (450, 644): u*v**2/w, (451, 130):
        -u**2*v/w, (451, 439): 1, (451, 451): u, (451, 454):
        -u**3*v/w, (451, 508): -u*v/w, (451, 589): -u**2*v**2/w, (452,
        446): 1, (452, 452): u, (452, 454): u**2*v/w, (453, 445): 1,
        (453, 453): u, (453, 454): u*v, (454, 373): -v, (454, 400): 1,
        (455, 455): u, (455, 477): 1, (455, 585): u, (456, 132): 1,
        (456, 456): u, (456, 591): v, (457, 376): -v, (457, 403): 1,
        (458, 353): 1, (458, 380): -u/w, (459, 462): -v, (459, 463):
        1, (460, 536): u*v/w, (460, 563): -u/w, (460, 617): w, (460,
        644): -u, (461, 427): u*w, (461, 461): u, (461, 476): 1, (461,
        484): u, (461, 616): u**2*v, (461, 643): -u**2, (462, 459): 1,
        (462, 462): u, (463, 462): w, (464, 356): -v, (464, 383): 1,
        (464, 572): -v, (465, 370): u*v, (465, 373): -u*v**3/w, (465,
        397): -u, (465, 400): u*v**2/w, (465, 586): w, (465, 589):
        -v**2, (466, 49): -u*v**3/w, (466, 76): u*v**2/w, (466, 157):
        -u*v**2, (466, 184): -u*v**4/w**2, (466, 211): u*v, (466,
        238): u*v**3/w**2, (466, 357): -v, (466, 373):
        -u**2*v**4/w**2, (466, 384): 1, (466, 400): u**2*v**3/w**2,
        (466, 454): -v**3/w, (466, 478): -v, (466, 481): u**2*v**2/w,
        (466, 508): v**2/w, (466, 573): -v, (466, 589): u**2*v, (467,
        359): -v, (467, 386): 1, (467, 575): -v, (468, 360): -v, (468,
        387): 1, (468, 576): -v, (469, 82): -v, (469, 361): -v, (469,
        369): -v**2/w, (469, 388): 1, (469, 396): v/w, (469, 455):
        v**2/w, (469, 460): -v**2/w, (469, 509): -u*v**2/w**2, (469,
        568): -u*v**2/w, (469, 577): -v, (469, 585): -v**2/w, (470,
        372): u*v, (470, 373): u*v**2, (470, 399): -u, (470, 400):
        -u*v, (470, 460): u, (470, 536): -u**2*v**2/w**2, (470, 563):
        u**2*v/w**2, (470, 588): w, (470, 589): v*w, (470, 617): -u*v,
        (470, 644): u**2*v/w, (471, 353): u*v**2/w, (471, 371): u*v,
        (471, 373): u**2*v**2/w, (471, 376): u*v**2/w, (471, 380):
        -u*v/w, (471, 398): -u, (471, 400): -u**2*v/w, (471, 403):
        -u*v/w, (471, 569): v, (471, 587): w, (471, 589): u*v, (471,
        592): v, (472, 49): u*v**2, (472, 76): -u*v, (472, 180):
        u*v/w, (472, 184): u*v**3/w, (472, 234): -u/w, (472, 238):
        -u*v**2/w, (472, 362): -v, (472, 369): u**2*v/w, (472, 373):
        u**2*v**3/w, (472, 389): 1, (472, 396): -u**2/w, (472, 400):
        -u**2*v**2/w, (472, 454): v**2, (472, 480): -v, (472, 481):
        -u**2*v, (472, 508): -v, (472, 578): -v, (473, 49):
        u**2*v**2/w, (473, 53): v**2, (473, 76): -u**2*v/w, (473, 80):
        -v, (473, 184): u**2*v**3/w**2, (473, 188): v**3/w, (473,
        238): -u**2*v**2/w**2, (473, 242): -v**2/w, (473, 363): -v,
        (473, 373): u**3*v**3/w**2, (473, 377): u*v**3/w, (473, 390):
        1, (473, 400): -u**3*v**2/w**2, (473, 404): -u*v**2/w, (473,
        454): u*v**2/w, (473, 457): v**2/w, (473, 479): -v, (473,
        481): -u**3*v/w, (473, 485): -u*v, (473, 508): -u*v/w, (473,
        511): -v/w, (473, 579): -v, (474, 164): -u**2*v/w, (474, 188):
        -u*v, (474, 218): u**2/w, (474, 242): u, (474, 353):
        -u**3*v/w, (474, 366): -v, (474, 377): -u**2*v, (474, 380):
        u**3/w, (474, 393): 1, (474, 404): u**2, (474, 582): -v, (474,
        596): -u*v*(u*v - w)/w, (474, 623): u*(u*v - w)/w, (475, 49):
        u**2*v/w, (475, 76): -u**2/w, (475, 184): u**2*v**2/w**2,
        (475, 238): -u**2*v/w**2, (475, 367): -v, (475, 373):
        u**2*v*(u*v - w)/w**2, (475, 394): 1, (475, 400): -u**2*(u*v -
        w)/w**2, (475, 481): -u**3/w, (475, 583): -v, (475, 589):
        -u**2*v/w, (476, 52): u*v, (476, 53): -v*w, (476, 79): -u,
        (476, 80): w, (476, 184): u*v, (476, 187): u*v**2/w, (476,
        188): -v**2, (476, 238): -u, (476, 241): -u*v/w, (476, 242):
        v, (476, 373): u**2*v, (476, 376): u**2*v**2/w, (476, 377):
        -u*v**2, (476, 400): -u**2, (476, 403): -u**2*v/w, (476, 404):
        u*v, (476, 461): -v, (476, 484): -u**2, (476, 485): u*w, (477,
        82): w, (477, 455): -v, (477, 460): v, (477, 509): u*v/w,
        (477, 568): u*v, (478, 103): -u*v, (478, 427): -u**2*v, (478,
        466): 1, (478, 478): u, (478, 481): -u*v**2/w, (478, 589):
        -u**2*v**2/w, (478, 616): -u**3*v**2/w, (478, 643): u**3*v/w,
        (479, 473): 1, (479, 479): u, (479, 481): u**2*v/w, (480,
        472): 1, (480, 480): u, (480, 481): u*v, (481, 49): -v, (481,
        76): 1, (481, 184): -v**2/w, (481, 238): v/w, (481, 373):
        -u*v**2/w, (481, 400): u*v/w, (481, 481): u, (482, 153): -v,
        (482, 207): 1, (482, 482): u, (482, 585): u, (483, 429): w,
        (483, 618): u*v, (483, 645): -u, (484, 52): -v, (484, 79): 1,
        (484, 187): -v**2/w, (484, 241): v/w, (484, 376): -u*v**2/w,
        (484, 403): u*v/w, (484, 484): u, (485, 434): -v/w, (485,
        488): 1/w, (486, 489): -v, (486, 490): 1, (487, 185): w, (487,
        239): -u, (487, 536): v, (487, 563): -u*v/w, (487, 617): v*w,
        (487, 644): -u*v, (488, 454): u*w, (488, 488): u, (488, 503):
        1, (488, 511): u, (489, 486): 1, (489, 489): u, (490, 489): w,
        (491, 518): -v, (491, 545): 1, (492, 532): w, (492, 535):
        -v**2, (492, 559): -u, (492, 562): u*v**2/w, (493, 49): -v**3,
        (493, 76): v**2, (493, 184): -v**4/w, (493, 238): v**3/w,
        (493, 373): -v**3*(2*u*v - w)/w, (493, 400): u*v**3/w, (493,
        454): -v**4/w, (493, 481): u*v**2, (493, 505): -v, (493, 508):
        v**3/w, (493, 519): -v, (493, 546): 1, (493, 589): u*v*w,
        (494, 521): -v, (494, 548): 1, (495, 522): -v, (495, 549): 1,
        (496, 50): v**2, (496, 77): -u*v**2/w, (496, 109): -v, (496,
        185): v**3/w, (496, 239): -u*v**3/w**2, (496, 455): v**3/w,
        (496, 487): -v**2/w, (496, 509): -u*v**3/w**2, (496, 523): -v,
        (496, 531): -v**2/w, (496, 550): 1, (496, 558): v/w, (496,
        563): -v**3*(u*v - w)/w**3, (496, 568): -v**2, (497, 185):
        -u*v, (497, 239): u**2*v/w, (497, 487): u, (497, 534): w,
        (497, 535): v*w, (497, 536): -u*v**2/w, (497, 561): -u, (497,
        562): -u*v, (497, 563): u**2*v**2/w**2, (497, 617): -u*v**2,
        (497, 644): u**2*v**2/w, (498, 515): v, (498, 533): w, (498,
        535): u*v, (498, 538): v, (498, 542): -u*v/w, (498, 560): -u,
        (498, 562): -u**2*v/w, (498, 565): -u*v/w, (499, 49): v**2*w,
        (499, 76): -v*w, (499, 184): v**3, (499, 238): -v**2, (499,
        369): u*v, (499, 373): v**2*(2*u*v - w), (499, 396): -u, (499,
        400): -u*v**2, (499, 454): v**3, (499, 481): -u*v*w, (499,
        507): -v, (499, 508): -v**2, (499, 524): -v, (499, 551): 1,
        (500, 49): u*v**2, (500, 52): v**2, (500, 76): -u*v, (500,
        79): -v, (500, 184): u*v**3/w, (500, 187): v**3/w, (500, 238):
        -u*v**2/w, (500, 241): -v**2/w, (500, 373): u*v**2*(2*u*v -
        w)/w, (500, 376): v**2*(u*v - w)/w, (500, 377): v**3, (500,
        400): -u**2*v**2/w, (500, 404): -v**2, (500, 454): u*v**3/w,
        (500, 457): v**3/w, (500, 481): -u**2*v, (500, 485): -v*w,
        (500, 506): -v, (500, 508): -u*v**2/w, (500, 511): -v**2/w,
        (500, 525): -v, (500, 552): 1, (501, 353): -u*w, (501, 377):
        -u*v*w, (501, 380): u**2, (501, 404): u*w, (501, 528): -v,
        (501, 555): 1, (502, 373): u**2*v**2/w, (502, 400): -u**2*v/w,
        (502, 481): -u**2, (502, 529): -v, (502, 535): -u**2*v/w,
        (502, 556): 1, (502, 562): u**2/w, (503, 373): u*v*w, (503,
        376): u*v**2, (503, 377): -v**2*w, (503, 400): -u*w, (503,
        403): -u*v, (503, 404): v*w, (503, 484): -u*w, (503, 485):
        w**2, (503, 488): -v, (504, 50): -v*w, (504, 77): u*v, (504,
        109): w, (504, 185): -v**2, (504, 239): u*v**2/w, (504, 455):
        -v**2, (504, 487): v, (504, 509): u*v**2/w, (504, 563):
        v**2*(u*v - w)/w**2, (504, 568): v*w, (505, 130): -u*v, (505,
        454): -u**2*v, (505, 493): 1, (505, 505): u, (505, 508):
        -u*v**2/w, (505, 589): -u*v**2, (506, 500): 1, (506, 506): u,
        (506, 508): u**2*v/w, (507, 499): 1, (507, 507): u, (507,
        508): u*v, (508, 373): -v**2, (508, 400): v, (508, 481): w,
        (509, 509): u, (509, 585): w, (510, 456): w, (511, 376):
        -v**2, (511, 403): v, (511, 484): w, (512, 29): -v, (512, 56):
        1, (512, 164): -v**2/w, (512, 218): v/w, (512, 353): -v*(u*v -
        w)/w, (512, 434): -v**2/w, (512, 488): v/w, (513, 516): -v,
        (513, 517): 1, (514, 239): 1, (514, 563): v/w, (514, 644): v,
        (515, 373): u*w, (515, 515): u, (515, 530): 1, (515, 538): u,
        (516, 513): 1, (516, 516): u, (517, 516): w, (518, 491): 1,
        (518, 518): u, (519, 559): 1, (519, 562): -v**2/w, (520, 22):
        v**2, (520, 49): u*v**2, (520, 130): v**3/w, (520, 184):
        u*v**3/w, (520, 292): u*v**2, (520, 373): v**3*(2*u**2 - v)/w,
        (520, 400): v**3/w, (520, 454): 2*u*v**3/w, (520, 492): 1,
        (520, 519): u, (520, 532): -v, (520, 535): v**3/w, (520, 616):
        u*v*w, (521, 494): 1, (521, 521): u, (522, 495): 1, (522,
        522): u, (523, 77): v**2/w, (523, 163): -v, (523, 239):
        v**3/w**2, (523, 374): v**3/w, (523, 496): 1, (523, 504): v/w,
        (523, 509): v**3/w**2, (523, 514): -v**2/w, (523, 523): u,
        (523, 531): u*v/w, (523, 563): v**4/w**3, (523, 595): -v**2,
        (524, 239): -u*v/w, (524, 514): u, (524, 561): 1, (524, 562):
        v, (524, 563): -u*v**2/w**2, (524, 644): -u*v**2/w, (525,
        542): v/w, (525, 560): 1, (525, 562): u*v/w, (525, 565): v/w,
        (526, 22): -v*w, (526, 49): -u*v*w, (526, 130): -v**2, (526,
        184): -u*v**2, (526, 292): -u*v*w, (526, 369): -u**2, (526,
        373): -v**2*(2*u**2 - v), (526, 400): -v**2, (526, 450): -u,
        (526, 454): -2*u*v**2, (526, 497): 1, (526, 524): u, (526,
        534): -v, (526, 535): -v**2, (527, 22): -u*v, (527, 25): -v,
        (527, 49): -u**2*v, (527, 52): -u*v, (527, 130): -u*v**2/w,
        (527, 133): -v**2/w, (527, 184): -u**2*v**2/w, (527, 187):
        -u*v**2/w, (527, 292): -u**2*v, (527, 296): -v*w, (527, 373):
        -u*v**2*(2*u**2 - v)/w, (527, 376): -v**2*(u**2 - v)/w, (527,
        377): -u*v**2, (527, 400): -u*v**2/w, (527, 403): -v**2/w,
        (527, 454): -2*u**2*v**2/w, (527, 457): -u*v**2/w, (527, 458):
        -v**2, (527, 498): 1, (527, 525): u, (527, 533): -v, (527,
        535): -u*v**2/w, (527, 538): -v**2/w, (528, 377): u**2*w,
        (528, 380): -u, (528, 458): u*w, (528, 501): 1, (528, 528): u,
        (529, 292): -u**2, (529, 373): -u**3*v/w, (529, 454):
        -u**2*v/w, (529, 502): 1, (529, 508): u**2/w, (529, 529): u,
        (529, 535): u**3/w, (530, 295): -u*w, (530, 296): w**2, (530,
        373): -u**2*w, (530, 376): -u**2*v, (530, 377): u*v*w, (530,
        454): -u*w, (530, 457): -u*v, (530, 458): v*w, (530, 515): -v,
        (531, 77): -v, (531, 163): w, (531, 239): -v**2/w, (531, 374):
        -v**2, (531, 509): -v**2/w, (531, 514): v, (531, 563):
        -v**3/w**2, (531, 595): v*w, (532, 184): -u*v, (532, 373):
        -u**2*v, (532, 520): 1, (532, 532): u, (532, 535): -u*v**2/w,
        (532, 616): -u*v**2, (533, 527): 1, (533, 533): u, (533, 535):
        u**2*v/w, (534, 526): 1, (534, 534): u, (534, 535): u*v, (535,
        292): w, (535, 373): u*v, (535, 454): v, (536, 536): u, (536,
        612): w, (537, 375): w, (538, 295): w, (538, 376): u*v, (538,
        457): v, (539, 2): 1, (539, 29): u, (539, 110): v/w, (539,
        164): u*v/w, (539, 353): v*(u**2 - v)/w, (539, 380): v/w,
        (539, 434): u*v/w, (539, 515): v/w, (540, 543): -v, (540,
        544): 1, (541, 131): w, (541, 239): v, (541, 509): v, (541,
        563): v**2/w, (541, 590): v*w, (541, 644): v**2, (542, 400):
        u*w, (542, 542): u, (542, 557): 1, (542, 565): u, (543, 540):
        1, (543, 543): u, (544, 543): w, (545, 518): w, (546, 505): w,
        (546, 508): -v**2, (546, 559): v, (546, 562): -v**3/w, (547,
        49): v**2*w, (547, 184): v**3, (547, 346): u*v**2, (547, 373):
        2*u*v**3, (547, 454): v**3, (547, 519): w, (547, 559): -v,
        (547, 562): v**3/w, (547, 643): u*v*w, (548, 521): w, (549,
        522): w, (550, 23): v**2, (550, 77): v**3/w, (550, 131):
        v**3/w, (550, 217): -v, (550, 239): v**4/w**2, (550, 401):
        v**3/w, (550, 509): v**4/w**2, (550, 523): w, (550, 531): v,
        (550, 536): v**3/w, (550, 541): -v**2/w, (550, 563):
        -v**3*(u*w - v**2)/w**3, (550, 622): -v**2, (551, 131): -u*v,
        (551, 239): -u*v**2/w, (551, 507): w, (551, 508): v*w, (551,
        509): -u*v**2/w, (551, 541): u, (551, 561): v, (551, 562):
        v**2, (551, 563): -u*v**3/w**2, (551, 590): -u*v**2, (551,
        644): -u*v**3/w, (552, 488): v, (552, 506): w, (552, 508):
        u*v, (552, 511): v, (552, 542): v**2/w, (552, 560): v, (552,
        562): u*v**2/w, (552, 565): v**2/w, (553, 49): -v*w**2, (553,
        184): -v**2*w, (553, 346): -u*v*w, (553, 369): -u*w, (553,
        373): -2*u*v**2*w, (553, 454): -v**2*w, (553, 524): w, (553,
        561): -v, (553, 562): -v**2, (554, 49): -u*v*w, (554, 52):
        -v*w, (554, 184): -u*v**2, (554, 187): -v**2, (554, 346):
        -u**2*v, (554, 350): -v*w, (554, 373): -2*u**2*v**2, (554,
        376): -u*v**2, (554, 377): -v**2*w, (554, 454): -u*v**2, (554,
        457): -v**2, (554, 525): w, (554, 560): -v, (554, 562):
        -u*v**2/w, (554, 565): -v**2/w, (555, 377): u*w**2, (555,
        380): -u*v, (555, 434): -u*w, (555, 528): w, (556, 346):
        -u**2, (556, 373): -u**2*v, (556, 529): w, (556, 535): u**2,
        (557, 349): -u*w, (557, 350): w**2, (557, 373): -u*w**2, (557,
        376): -u*v*w, (557, 377): v*w**2, (557, 542): -v, (558, 23):
        -v*w, (558, 77): -v**2, (558, 131): -v**2, (558, 217): w,
        (558, 239): -v**3/w, (558, 401): -v**2, (558, 509): -v**3/w,
        (558, 536): -v**2, (558, 541): v, (558, 563): v**2*(u*w -
        v**2)/w**2, (558, 622): v*w, (559, 238): -u*v, (559, 400):
        -u**2*v, (559, 547): 1, (559, 559): u, (559, 562): -u*v**2/w,
        (559, 643): -u*v**2, (560, 554): 1, (560, 560): u, (560, 562):
        u**2*v/w, (561, 553): 1, (561, 561): u, (561, 562): u*v, (562,
        346): w, (562, 373): v*w, (563, 563): u, (563, 639): w, (564,
        402): w, (565, 349): w, (565, 376): v*w, (566, 29): w, (566,
        164): v, (566, 353): u*v, (566, 434): v, (566, 542): v/w,
        (567, 570): -v, (567, 571): 1, (568, 536): -v/w, (568, 563):
        1/w, (569, 569): u, (569, 584): 1, (569, 592): u, (569, 616):
        -u*v, (569, 643): u, (570, 567): 1, (570, 570): u, (571, 570):
        w, (572, 464): 1, (572, 572): u, (573, 370): -v, (573, 373):
        v**3/w, (573, 397): 1, (573, 400): -v**2/w, (574, 130):
        v**2/w, (574, 319): -u*v*(u*v - w)/w, (574, 454): u*v**2/w,
        (574, 465): 1, (574, 573): u, (574, 586): -v, (574, 589):
        v**3/w, (575, 467): 1, (575, 575): u, (576, 468): 1, (576,
        576): u, (577, 469): 1, (577, 477): v/w, (577, 509):
        v**2/w**2, (577, 577): u, (577, 585): u*v/w, (577, 595): -v,
        (577, 622): u*v/w, (578, 372): -v, (578, 373): -v**2, (578,
        399): 1, (578, 400): v, (578, 536): u*v**2/w**2, (578, 563):
        -u*v/w**2, (578, 568): u, (579, 353): -v**2/w, (579, 371): -v,
        (579, 373): -u*v**2/w, (579, 376): -v**2/w, (579, 380): v/w,
        (579, 398): 1, (579, 400): u*v/w, (579, 403): v/w, (580, 130):
        -v, (580, 265): -u*v*w, (580, 319): u**2*v, (580, 423): -u,
        (580, 454): -u*v, (580, 470): 1, (580, 578): u, (580, 588):
        -v, (580, 589): -v**2, (581, 130): -u*v/w, (581, 133): -v/w,
        (581, 265): -u**2*v, (581, 269): -v*w, (581, 319): u**3*v/w,
        (581, 323): u*v, (581, 454): -u**2*v/w, (581, 457): -u*v/w,
        (581, 471): 1, (581, 579): u, (581, 587): -v, (581, 589):
        -u*v**2/w, (581, 592): -v**2/w, (582, 164): u*v/w, (582, 218):
        -u/w, (582, 353): u**2*v/w, (582, 380): -u**2/w, (582, 431):
        u*w, (582, 474): 1, (582, 582): u, (582, 596): u*v**2/w, (582,
        623): -u*v/w, (583, 265): -u**2, (583, 319): u**3/w, (583,
        475): 1, (583, 481): u**2/w, (583, 583): u, (583, 589):
        u**3/w, (584, 268): -u*w, (584, 269): w**2, (584, 322): u**2,
        (584, 323): -u*w, (584, 427): -u*w, (584, 569): -v, (585,
        509): -v/w, (585, 595): w, (585, 622): -u, (586, 574): 1,
        (586, 586): u, (586, 616): u*v*(u*v - w)/w, (587, 581): 1,
        (587, 587): u, (587, 589): u**2*v/w, (588, 580): 1, (588,
        588): u, (588, 589): u*v, (589, 265): w, (589, 319): -u, (590,
        261): -v, (590, 315): 1, (590, 590): u, (591, 618): -v, (591,
        645): 1, (592, 268): w, (592, 322): -u, (593, 110): 1/w, (593,
        434): u/w, (593, 569): v/w, (594, 597): -v, (594, 598): 1,
        (595, 509): 1/w, (595, 536): u/w, (596, 589): u, (596, 596):
        u, (596, 611): 1, (596, 616): u**2, (596, 619): u, (597, 594):
        1, (597, 597): u, (598, 597): w, (599, 275): 1, (599, 599): u,
        (600, 370): u, (600, 373): -u*v**2/w, (600, 451): 1, (600,
        454): -v**2/w, (601, 184): v**2/w, (601, 265): u**2*v, (601,
        276): 1, (601, 319): u*v**2/w, (601, 373): u*v**2/w, (601,
        427): u*v, (601, 600): u, (601, 613): -v, (601, 616): v**3/w,
        (602, 278): 1, (602, 602): u, (603, 279): 1, (603, 603): u,
        (604, 280): 1, (604, 288): v/w, (604, 536): v**2/w**2, (604,
        604): u, (604, 612): u*v/w, (604, 622): -v/w, (605, 372): u,
        (605, 373): u*v, (605, 453): 1, (605, 454): v, (605, 509):
        -u*v/w**2, (605, 536): -u**2*v/w**2, (605, 595): u, (606,
        353): u*v/w, (606, 371): u, (606, 373): u**2*v/w, (606, 376):
        u*v/w, (606, 434): v/w, (606, 452): 1, (606, 454): u*v/w,
        (606, 457): v/w, (607, 184): -v, (607, 261): -u, (607, 281):
        1, (607, 319): -u*v, (607, 373): -u*v, (607, 605): u, (607,
        615): -v, (607, 616): -v**2, (608, 184): -u*v/w, (608, 187):
        -v/w, (608, 282): 1, (608, 319): -u**2*v/w, (608, 323): -v,
        (608, 373): -u**2*v/w, (608, 376): -u*v/w, (608, 606): u,
        (608, 614): -v, (608, 616): -u*v**2/w, (608, 619): -v**2/w,
        (609, 110): -u/w, (609, 164): -u**2/w, (609, 269): u*w, (609,
        285): 1, (609, 353): -u**3/w, (609, 434): -u**2/w, (609, 569):
        -u*v/w, (609, 596): -u**2*v/w, (609, 609): u, (610, 286): 1,
        (610, 292): u**2/w, (610, 319): -u**2/w, (610, 610): u, (610,
        616): u**3/w, (611, 265): -u*w, (611, 322): -u, (611, 323): w,
        (611, 596): -v, (612, 536): -v/w, (612, 622): 1, (613, 589):
        -u**2*v/w, (613, 601): 1, (613, 613): u, (613, 616):
        -u**3*v/w, (613, 643): -u*v/w, (614, 608): 1, (614, 614): u,
        (614, 616): u**2*v/w, (615, 607): 1, (615, 615): u, (615,
        616): u*v, (616, 319): 1, (617, 261): u, (617, 423): 1, (617,
        617): u, (618, 591): 1, (618, 618): u, (619, 322): 1, (620,
        164): 1/w, (620, 353): u/w, (620, 596): v/w, (621, 624): -v,
        (621, 625): 1, (622, 536): 1, (623, 616): u*w, (623, 623): u,
        (623, 638): 1, (623, 646): u, (624, 621): 1, (624, 624): u,
        (625, 624): w, (626, 329): 1, (626, 626): u, (627, 370): w,
        (627, 373): -v**2, (628, 238): v**2/w, (628, 265): u*v*w,
        (628, 319): u*v**3/w, (628, 330): 1, (628, 400): u*v**2/w,
        (628, 427): u*v**2, (628, 627): u, (628, 640): -v, (628, 643):
        v**3/w, (629, 332): 1, (629, 629): u, (630, 333): 1, (630,
        630): u, (631, 334): 1, (631, 342): v/w, (631, 563):
        v**2/w**2, (631, 568): -v, (631, 622): -v**2/w, (631, 631): u,
        (631, 639): u*v/w, (632, 372): w, (632, 373): v*w, (632, 536):
        -u*v/w, (632, 622): u, (633, 353): v, (633, 371): w, (633,
        373): u*v, (633, 376): v, (634, 238): -v, (634, 315): -u,
        (634, 319): -u*v**2, (634, 335): 1, (634, 400): -u*v, (634,
        427): -u*v*w, (634, 632): u, (634, 642): -v, (634, 643):
        -v**2, (635, 238): -u*v/w, (635, 241): -v/w, (635, 319):
        -u**2*v**2/w, (635, 323): -v**2, (635, 336): 1, (635, 400):
        -u**2*v/w, (635, 403): -u*v/w, (635, 427): -u**2*v, (635,
        431): -v*w, (635, 633): u, (635, 641): -v, (635, 643):
        -u*v**2/w, (635, 646): -v**2/w, (636, 164): -u, (636, 323):
        u*w, (636, 339): 1, (636, 353): -u**2, (636, 596): -u*v, (636,
        636): u, (637, 319): -u**2*v/w, (637, 340): 1, (637, 346):
        u**2/w, (637, 427): -u**2, (637, 637): u, (637, 643): u**3/w,
        (638, 319): -u*w, (638, 322): -u*v, (638, 323): v*w, (638,
        430): -u*w, (638, 431): w**2, (638, 623): -v, (639, 563):
        -v/w, (639, 568): w, (639, 622): v, (640, 589): -u*v, (640,
        616): -u**2*v, (640, 628): 1, (640, 640): u, (640, 643):
        -u*v**2/w, (641, 635): 1, (641, 641): u, (641, 643): u**2*v/w,
        (642, 634): 1, (642, 642): u, (642, 643): u*v, (643, 319): v,
        (643, 427): w, (644, 261): w, (644, 644): u, (645, 618): w,
        (646, 322): v, (646, 430): w, (647, 218): 1/w, (647, 380):
        u/w, (647, 623): v/w}]], [[{(0, 27): 1, (0, 54): -u/w, (1,
        28): 1, (1, 55): -u/w, (2, 29): 1, (2, 56): -u/w, (3, 30): 1,
        (3, 57): -u/w, (4, 31): 1, (4, 58): -u/w, (5, 9): -u/w, (5,
        10): 1, (5, 158): -v, (5, 159): u*v**3/w, (5, 185): u*v/w, (5,
        186): -u*v**2/w, (5, 212): u*v/w, (5, 213): -u*v**2/w, (5,
        239): -u**2*v/w**2, (5, 240): u*v/w, (5, 406): -v, (5, 433):
        u*v/w, (5, 460): u*v/w, (5, 487): -u**2*v/w**2, (5, 595):
        -u*v**2/w, (5, 622): u*v/w, (6, 11): -u/w, (6, 12): 1, (6,
        45): -u/w, (6, 51): -v**2/w, (6, 55): u*v*(u*v - w)/w**3, (6,
        72): u**2/w**2, (6, 78): u*v**2/w**2, (6, 160): -v, (6, 161):
        v**2, (6, 187): u*v/w, (6, 188): -u*v**2/w, (6, 214): u*v/w,
        (6, 215): -v, (6, 241): -u**2*v/w**2, (6, 242): u*v/w, (7,
        13): -u/w, (7, 14): 1, (7, 159): u*v**2*(u*v - w)/w**2, (7,
        185): u*(u*v - w)/w**2, (7, 186): -u*v*(u*v - w)/w**2, (7,
        239): -u**2*(u*v - w)/w**3, (7, 460): u**2*v*(u*v - w)/w**3,
        (7, 487): -u**2*(u*v - w)/w**3, (7, 622): -u**2*v*(u*v -
        w)**2/w**4, (8, 15): -u/w, (8, 16): 1, (8, 44): -u/w, (8, 71):
        u**2/w**2, (8, 159): u*v*(u*v - w)/w**2, (8, 187): u*(u*v -
        w)/w**2, (8, 188): -u*v*(u*v - w)/w**2, (8, 240): -u**2*(u*v -
        w)/w**3, (8, 241): -u**2*(u*v - w)/w**3, (8, 242): u*(u*v -
        w)/w**2, (8, 407): u*v/w, (8, 434): -u/w, (8, 461):
        -u**2*v/w**2, (8, 488): u**2/w**2, (8, 596): u*v/w, (8, 623):
        u**2*v*(u*v - 2*w)/w**3, (9, 5): 1, (9, 9): v/w, (9, 45):
        -v**2/w, (9, 50): v, (9, 52): -v**2, (9, 72): v/w, (9, 77):
        -u*v/w, (9, 79): v, (9, 82): v, (9, 109): -u*v/w, (10, 9):
        1/w, (10, 45): -v/w, (10, 72): u*v/w**2, (10, 159): -v**3/w,
        (10, 186): v**2/w, (10, 213): v**2/w, (10, 240): -v/w, (11,
        1): u*v**2/w**2, (11, 6): 1, (11, 11): v/w, (11, 18): u/w,
        (11, 51): v, (11, 53): -v**2, (11, 78): -u*v/w, (11, 80): v,
        (12, 1): u*v/w**2, (12, 11): 1/w, (13, 7): 1, (13, 13): v/w,
        (13, 44): -v**2/w, (13, 50): u*v/w, (13, 52): -u*v**2/w, (13,
        71): v/w, (13, 77): -u**2*v/w**2, (13, 79): u*v/w, (13, 82):
        u**2*v**2/w**2, (13, 105): u*v**2/w, (13, 109): -u**2*v/w**2,
        (13, 132): -u*v/w, (14, 13): 1/w, (14, 44): -v/w, (14, 50):
        u/w, (14, 52): -u*v/w, (14, 71): u*v/w**2, (14, 77):
        -u**2/w**2, (14, 79): u**2*v/w**2, (14, 82): u**2*v/w**2, (14,
        105): u**2*v**2/w**2, (14, 109): -u**2/w**2, (14, 132):
        -u**2*v/w**2, (15, 8): 1, (15, 15): v/w, (15, 17): u/w, (15,
        25): u**2/w, (15, 53): -u*v**2/w, (15, 80): u*v/w, (15, 83):
        -u*v/w, (15, 110): u/w, (15, 159): u, (15, 186): -u**2/w, (15,
        213): -u**2/w, (15, 240): u**3/w**2, (16, 15): 1/w, (16, 53):
        -u*v/w, (16, 80): u/w, (16, 105): u**2*v/w**2, (16, 132):
        -u**2/w**2, (17, 44): 1, (17, 52): u, (17, 71): -u/w, (17,
        79): -u**2/w, (17, 105): -u**2*v/w, (17, 132): u**2/w, (17,
        159): -u*v**2/w, (17, 186): u*v/w, (17, 213): u*v/w, (17,
        240): -u/w, (18, 45): 1, (18, 72): -u/w, (19, 20): 1, (19,
        21): -u/w, (19, 460): -u*v*(u*v - w)/w**3, (19, 487): u*(u*v -
        w)/w**3, (19, 622): u*v*(u*v - w)**2/w**4, (20, 21): 1/w, (20,
        29): -v/w, (20, 56): u*v/w**2, (20, 82): -u*v/w**2, (20, 109):
        u/w**2, (21, 19): 1, (21, 21): v/w, (21, 29): -v**2/w, (21,
        56): v/w, (21, 82): -u*v**2/w**2, (21, 109): u*v/w**2, (22,
        105): -v/w, (22, 132): 1/w, (23, 104): 1, (23, 131): -u/w,
        (24, 24): v/w, (24, 106): 1, (24, 133): -u/w, (25, 22): 1,
        (25, 105): u*v/w, (25, 132): -u/w, (26, 107): 1, (26, 134):
        -u/w, (27, 54): 1/w, (28, 55): 1/w, (29, 56): 1/w, (30, 57):
        1/w, (31, 58): 1/w, (32, 36): -u/w, (32, 37): 1, (32, 105):
        -u*v**2/w, (32, 132): u*v/w, (32, 159): -u**2*v**2/w, (32,
        186): u**2*v/w, (32, 212): -v/w, (32, 239): u*v/w**2, (32,
        244): -v, (32, 271): u*v/w, (32, 352): u*v/w, (32, 514):
        -u**2*v/w**2, (32, 568): u*v/w, (32, 595): u**2*v/w, (33, 1):
        -u*v/w**2, (33, 28): -u**2*v/w**2, (33, 38): -u/w, (33, 39):
        1, (33, 55): -u*v**2/w**3, (33, 72): -u/w**2, (33, 78):
        -v**2/w**2, (33, 107): -v, (33, 134): u*v/w, (33, 161): -u*v,
        (33, 188): u**2*v/w, (33, 214): -v/w, (33, 241): u*v/w**2,
        (34, 40): -u/w, (34, 41): 1, (34, 105): -u**2*v**2/w**2, (34,
        132): u**2*v/w**2, (34, 159): -u**3*v**2/w**2, (34, 186):
        u**3*v/w**2, (34, 213): -u*v**2/w**2, (34, 239): u*(u*v -
        w)/w**3, (34, 240): u*v/w**2, (34, 271): u**2*v*(u*v -
        w)/w**3, (34, 514): -u**2*(u*v - w)/w**3, (34, 568):
        u**2*v*(u*v - w)/w**3, (34, 595): u**3*v*(u*v - w)/w**3, (34,
        622): u**2*v**2*(u*v - w)/w**4, (35, 42): -u/w, (35, 43): 1,
        (35, 71): -u/w**2, (35, 105): -u**2*v/w**2, (35, 132):
        u**2/w**2, (35, 134): u*(u*v - w)/w**2, (35, 159):
        -u**3*v/w**2, (35, 186): u**3/w**2, (35, 188): u**2*(u*v -
        w)/w**2, (35, 213): -u*v/w**2, (35, 240): u**2*v/w**3, (35,
        241): u*(u*v - w)/w**3, (35, 245): u*v/w, (35, 272):
        -u**2*v/w**2, (35, 353): -u/w, (35, 515): u**2/w**2, (35,
        569): -u**2*v/w**2, (35, 596): -u**3*v/w**2, (35, 623):
        -u*v*(u*v - w)/w**3, (36, 18): v/w, (36, 25): v, (36, 32): 1,
        (36, 36): v/w, (36, 45): u*v/w, (36, 52): u*v, (36, 77): v/w,
        (36, 136): v, (36, 163): -u*v/w, (37, 36): 1/w, (37, 72):
        -v/w**2, (37, 105): v**2/w, (37, 132): -v/w, (37, 159):
        u*v**2/w, (37, 186): -u*v/w, (38, 26): v, (38, 28):
        u*v**2/w**2, (38, 33): 1, (38, 38): v/w, (38, 45): u/w, (38,
        53): u*v, (38, 78): v/w, (39, 28): u*v/w**2, (39, 38): 1/w,
        (40, 17): v/w, (40, 25): u*v/w, (40, 34): 1, (40, 40): v/w,
        (40, 44): u*v/w, (40, 52): u**2*v/w, (40, 77): u*v/w**2, (40,
        136): u**2*v**2/w**2, (40, 159): u*v**2/w, (40, 163):
        -u**2*v/w**2, (40, 186): -u*v/w, (41, 40): 1/w, (41, 71):
        -v/w**2, (41, 77): u/w**2, (41, 79): -u*v/w**2, (41, 136):
        u**2*v/w**2, (41, 159): u**2*v**2/w**2, (41, 163): -u**2/w**2,
        (41, 186): -u**2*v/w**2, (42, 26): u*v/w, (42, 35): 1, (42,
        42): v/w, (42, 44): u/w, (42, 52): u**2/w, (42, 53): u**2*v/w,
        (42, 137): -u*v/w, (42, 164): u/w, (42, 213): u/w, (42, 240):
        -u**2/w**2, (43, 26): u/w, (43, 42): 1/w, (43, 53): u**2/w,
        (43, 159): u**2*v/w**2, (43, 186): -u**2/w**2, (44, 71): 1/w,
        (44, 79): u/w, (44, 105): u*v/w, (44, 132): -u/w, (45, 72):
        1/w, (46, 47): 1, (46, 48): -u/w, (46, 271): -u*v*(u*v -
        w)/w**3, (46, 514): u*(u*v - w)/w**3, (46, 568): -u*v*(u*v -
        w)/w**3, (46, 595): -u**2*v*(u*v - w)/w**3, (46, 622):
        -u*v**2*(u*v - w)/w**4, (47, 48): 1/w, (47, 56): -v/w**2, (47,
        136): -u*v/w**2, (47, 163): u/w**2, (48, 2): v/w, (48, 29):
        u*v/w, (48, 46): 1, (48, 48): v/w, (48, 136): -u*v**2/w**2,
        (48, 163): u*v/w**2, (49, 159): -v/w, (49, 186): 1/w, (50,
        158): 1, (50, 185): -u/w, (51, 51): v/w, (51, 160): 1, (51,
        187): -u/w, (52, 49): 1, (52, 159): u*v/w, (52, 186): -u/w,
        (53, 161): 1, (53, 188): -u/w, (54, 0): 1, (54, 54): v/w, (55,
        1): 1, (55, 55): v/w, (56, 2): 1, (56, 56): v/w, (57, 3): 1,
        (57, 57): v/w, (58, 4): 1, (58, 58): v/w, (59, 63): -u/w, (59,
        64): 1, (59, 104): -v, (59, 131): u*v/w, (59, 159): -u*v**2,
        (59, 186): u*v, (59, 212): -v**2/w, (59, 239): u*v**2/w**2,
        (59, 298): -v, (59, 325): u*v/w, (59, 379): u*v/w, (59, 541):
        -u**2*v/w**2, (59, 595): u*v, (60, 1): -u*v**2/w**2, (60, 18):
        -u/w, (60, 24): -v**2/w, (60, 28): -u*v/w, (60, 55):
        -u*v**3/w**3, (60, 65): -u/w, (60, 66): 1, (60, 72):
        -u*v/w**2, (60, 78): -v**3/w**2, (60, 106): -v, (60, 133):
        u*v/w, (60, 161): -v*w, (60, 188): u*v, (60, 214): -v**2/w,
        (60, 241): u*v**2/w**2, (61, 67): -u/w, (61, 68): 1, (61,
        105): -u*v**2/w, (61, 131): u*(u*v - w)/w**2, (61, 132):
        u*v/w, (61, 159): -u**2*v**2/w, (61, 186): u**2*v/w, (61,
        213): -u*v**3/w**2, (61, 239): u*v*(u*v - w)/w**3, (61, 240):
        u*v**2/w**2, (61, 325): u**2*v*(u*v - w)/w**3, (61, 541):
        -u**2*(u*v - w)/w**3, (61, 568): u**2*v**2*(u*v - w)/w**3,
        (61, 595): u**2*v*(u*v - w)/w**2, (61, 622): u**2*v**3*(u*v -
        w)/w**4, (62, 17): -u/w, (62, 69): -u/w, (62, 70): 1, (62,
        71): -u*v/w**2, (62, 105): -u*v/w, (62, 132): u**2*v/w**2,
        (62, 133): u*(u*v - w)/w**2, (62, 159): -u**2*v/w, (62, 186):
        u**2/w, (62, 188): u*(u*v - w)/w, (62, 213): -u*v**2/w**2,
        (62, 240): u**2*v**2/w**3, (62, 241): u*v*(u*v - w)/w**3, (62,
        299): u*v/w, (62, 326): -u**2*v/w**2, (62, 380): -u/w, (62,
        542): u**2/w**2, (62, 569): -u*v*(u*v - w)/w**2, (62, 596):
        -u**2*v/w, (62, 623): -u*v**2*(u*v - w)/w**3, (63, 23): v,
        (63, 45): v, (63, 52): v*w, (63, 59): 1, (63, 63): v/w, (63,
        77): v**2/w, (63, 190): v, (63, 217): -u*v/w, (64, 18): -v/w,
        (64, 63): 1/w, (64, 72): -v**2/w**2, (64, 159): v**2, (64,
        186): -v, (65, 24): v, (65, 53): v*w, (65, 55): u*v**2/w**2,
        (65, 60): 1, (65, 65): v/w, (65, 72): u/w, (65, 78): v**2/w,
        (66, 55): u*v/w**2, (66, 65): 1/w, (67, 23): u*v/w, (67, 44):
        v, (67, 52): u*v, (67, 61): 1, (67, 67): v/w, (67, 77):
        u*v**2/w**2, (67, 190): u**2*v**2/w**2, (67, 213): u*v**2/w,
        (67, 217): -u**2*v/w**2, (67, 240): -u*v/w, (68, 17): -v/w,
        (68, 23): u/w, (68, 25): -u*v/w, (68, 67): 1/w, (68, 71):
        -v**2/w**2, (68, 77): u*v/w**2, (68, 79): -u*v**2/w**2, (68,
        190): u**2*v/w**2, (68, 213): u**2*v**2/w**2, (68, 217):
        -u**2/w**2, (68, 240): -u**2*v/w**2, (69, 53): u*v, (69, 62):
        1, (69, 69): v/w, (69, 71): u/w, (69, 79): u**2/w, (69, 105):
        u, (69, 132): -u**2/w, (69, 191): -u*v/w, (69, 213): u*v/w,
        (69, 218): u/w, (69, 240): -u**2*v/w**2, (70, 53): u, (70,
        69): 1/w, (70, 213): u**2*v/w**2, (70, 240): -u**2/w**2, (71,
        17): 1, (71, 25): u, (71, 71): v/w, (71, 79): u*v/w, (71,
        159): u*v, (71, 186): -u, (71, 213): -u**2*v/w, (71, 240):
        u**2/w, (72, 18): 1, (72, 72): v/w, (73, 74): 1, (73, 75):
        -u/w, (73, 325): -u*v*(u*v - w)/w**3, (73, 541): u*(u*v -
        w)/w**3, (73, 568): -u*v**2*(u*v - w)/w**3, (73, 595):
        -u*v*(u*v - w)/w**2, (73, 622): -u*v**3*(u*v - w)/w**4, (74,
        2): -v/w, (74, 56): -v**2/w**2, (74, 75): 1/w, (74, 190):
        -u*v/w**2, (74, 217): u/w**2, (75, 29): v, (75, 73): 1, (75,
        75): v/w, (75, 190): -u*v**2/w**2, (75, 217): u*v/w**2, (76,
        213): -v/w, (76, 240): 1/w, (77, 212): 1, (77, 239): -u/w,
        (78, 78): v/w, (78, 214): 1, (78, 241): -u/w, (79, 76): 1,
        (79, 213): u*v/w, (79, 240): -u/w, (80, 215): 1, (80, 242):
        -u/w, (81, 405): 1, (81, 459): -u/w, (81, 621): u*(u*v -
        w)/w**2, (82, 406): 1, (82, 460): -u/w, (82, 622): u*(u*v -
        w)/w**2, (83, 407): 1, (83, 461): -u/w, (83, 623): u*(u*v -
        w)/w**2, (84, 408): 1, (84, 462): -u/w, (84, 624): u*(u*v -
        w)/w**2, (85, 409): 1, (85, 463): -u/w, (85, 625): u*(u*v -
        w)/w**2, (86, 90): -u/w, (86, 91): 1, (86, 266): -v, (86,
        267): u*v**3/w, (86, 320): u*v/w, (86, 321): -u*v**2/w, (86,
        374): u*v/w, (86, 375): -u*v**2/w, (86, 401): -u**2*v/w**2,
        (86, 402): u*v/w, (86, 433): -v/w, (86, 487): u*v/w**2, (86,
        590): u*v/w, (86, 591): -u*v**2/w, (86, 595): v**2/w, (86,
        622): -u*v**2/w**2, (87, 92): -u/w, (87, 93): 1, (87, 268):
        -v, (87, 269): v**2, (87, 322): u*v/w, (87, 323): -u*v**2/w,
        (87, 376): u*v/w, (87, 377): -u*v**2/w, (87, 403):
        -u**2*v/w**2, (87, 404): u*v/w, (87, 423): -u/w, (87, 429):
        -v**2/w, (87, 460): u*v*(u*v - w)/w**3, (87, 477): u**2/w**2,
        (87, 483): u*v**2/w**2, (87, 592): u*v/w, (87, 593): -v, (87,
        622): -u**2*v**2*(u*v - w)/w**4, (87, 639): -u**2*(u*v -
        w)/w**3, (87, 645): -u*v**2*(u*v - w)/w**3, (88, 55):
        -u**2*(u*v - w)/w**3, (88, 94): -u/w, (88, 95): 1, (88, 267):
        u*v**2*(u*v - w)/w**2, (88, 320): u*(u*v - w)/w**2, (88, 321):
        -u*v*(u*v - w)/w**2, (88, 347): -u**2*(u*v - w)/w**3, (88,
        348): u**2*v*(u*v - w)/w**3, (88, 401): -u**2*(u*v - w)/w**3,
        (88, 460): -u**3*(u*v - w)/w**3, (88, 622): u**4*v*(u*v -
        w)/w**4, (88, 644): -u**3*(u*v - w)/w**3, (88, 645):
        u**3*v*(u*v - w)/w**3, (89, 29): -u/w, (89, 56): u**2/w**2,
        (89, 96): -u/w, (89, 97): 1, (89, 267): u*v*(u*v - w)/w**2,
        (89, 322): u*(u*v - w)/w**2, (89, 323): -u*v*(u*v - w)/w**2,
        (89, 349): -u**2*(u*v - w)/w**3, (89, 377): -u*v*(u*v -
        w)/w**2, (89, 402): -u**2*(u*v - w)/w**3, (89, 403):
        -u**2*(u*v - w)/w**3, (89, 404): u*(u*v - w)/w**2, (89, 407):
        -u**2/w, (89, 422): -u/w, (89, 461): u**3/w**2, (89, 476):
        u**2/w**2, (89, 623): -u**3*(u*v - w)/w**3, (89, 638):
        -u**2*(u*v - w)/w**3, (89, 646): -u**3*(u*v - w)/w**3, (90,
        86): 1, (90, 90): v/w, (90, 109): v/w, (90, 423): -v**2/w,
        (90, 428): v, (90, 430): -v**2, (90, 477): v/w, (90, 482):
        -u*v/w, (90, 484): v, (90, 644): u*v*(u*v - w)/w**2, (91, 90):
        1/w, (91, 267): -v**3/w, (91, 321): v**2/w, (91, 375): v**2/w,
        (91, 402): -v/w, (91, 423): -v/w, (91, 477): u*v/w**2, (91,
        591): v**2/w, (91, 639): -u*v*(u*v - w)/w**3, (92, 82):
        u*v**2/w**2, (92, 87): 1, (92, 92): v/w, (92, 99): u/w, (92,
        429): v, (92, 431): -v**2, (92, 483): -u*v/w, (92, 485): v,
        (92, 645): u*v*(u*v - w)/w**2, (93, 82): u*v/w**2, (93, 92):
        1/w, (94, 1): -u**2*v/w**2, (94, 24): -u*v/w, (94, 82):
        -u**3*v/w**2, (94, 88): 1, (94, 94): v/w, (94, 105):
        -u**2*v/w, (94, 422): -v**2/w, (94, 428): u*v/w, (94, 430):
        -u*v**2/w, (94, 476): v/w, (94, 482): -u**2*v/w**2, (94, 484):
        u*v/w, (94, 644): u**2*v*(u*v - w)/w**3, (95, 1): -u**2/w**2,
        (95, 24): -u**2*v/w**2, (95, 82): -u**3/w**2, (95, 94): 1/w,
        (95, 105): -u**3*v/w**2, (95, 422): -v/w, (95, 428): u/w, (95,
        430): -u*v/w, (95, 476): u*v/w**2, (95, 482): -u**2/w**2, (95,
        484): u**2*v/w**2, (95, 638): -u*v*(u*v - w)/w**3, (95, 644):
        u**2*(u*v - w)/w**3, (95, 646): -u**2*v*(u*v - w)/w**3, (96,
        2): u/w, (96, 83): u**2/w, (96, 89): 1, (96, 96): v/w, (96,
        98): u/w, (96, 106): u**2/w, (96, 267): u, (96, 321): -u**2/w,
        (96, 375): -u**2/w, (96, 402): u**3/w**2, (96, 431):
        -u*v**2/w, (96, 485): u*v/w, (96, 591): -u**2/w, (97, 24):
        -u**2/w**2, (97, 96): 1/w, (97, 105): -u**3/w**2, (97, 431):
        -u*v/w, (97, 485): u/w, (98, 24): u**2/w, (98, 105): u**3/w,
        (98, 267): -u*v**2/w, (98, 321): u*v/w, (98, 375): u*v/w, (98,
        402): -u/w, (98, 422): 1, (98, 430): u, (98, 476): -u/w, (98,
        484): -u**2/w, (98, 591): u*v/w, (98, 638): u*(u*v - w)/w**2,
        (98, 646): u**2*(u*v - w)/w**2, (99, 423): 1, (99, 477): -u/w,
        (99, 639): u*(u*v - w)/w**2, (100, 55): u*(u*v - w)/w**3,
        (100, 101): 1, (100, 102): -u/w, (100, 460): u**2*(u*v -
        w)/w**3, (100, 622): -u**3*v*(u*v - w)/w**4, (101, 1): u/w**2,
        (101, 82): u**2/w**2, (101, 102): 1/w, (101, 407): -v/w, (101,
        461): u*v/w**2, (101, 623): -u*v*(u*v - w)/w**3, (102, 1):
        u*v/w**2, (102, 82): u**2*v/w**2, (102, 100): 1, (102, 102):
        v/w, (102, 407): -v**2/w, (102, 461): v/w, (103, 24): 1/w,
        (103, 105): u/w, (104, 131): 1/w, (105, 105): v/w, (105, 133):
        1/w, (106, 24): -u/w, (106, 103): 1, (106, 105): -u**2/w,
        (107, 134): 1/w, (108, 432): 1, (108, 486): -u/w, (108, 594):
        -v, (108, 621): u*v/w, (109, 433): 1, (109, 487): -u/w, (109,
        595): -v, (109, 622): u*v/w, (110, 434): 1, (110, 488): -u/w,
        (110, 596): -v, (110, 623): u*v/w, (111, 435): 1, (111, 489):
        -u/w, (111, 597): -v, (111, 624): u*v/w, (112, 436): 1, (112,
        490): -u/w, (112, 598): -v, (112, 625): u*v/w, (113, 28): -v,
        (113, 55): u*v/w, (113, 117): -u/w, (113, 118): 1, (113, 293):
        -v, (113, 294): u*v**3/w, (113, 347): u*v/w, (113, 348):
        -u*v**2/w, (113, 433): -v**2/w, (113, 487): u*v**2/w**2, (113,
        536): u*v/w, (113, 537): -u*v**2/w, (113, 563): -u**2*v/w**2,
        (113, 564): u*v/w, (113, 595): v**3/w, (113, 618): u*v**2*(u*v
        - w)/w, (113, 622): -u*v**3/w**2, (114, 119): -u/w, (114,
        120): 1, (114, 295): -v, (114, 296): v**2, (114, 349): u*v/w,
        (114, 350): -u*v**2/w, (114, 377): -v**2*(u*v - w)/w, (114,
        450): -u/w, (114, 456): -v**2/w, (114, 487): u*v*(u*v -
        w)/w**3, (114, 504): u**2/w**2, (114, 510): u*v**2/w**2, (114,
        538): u*v/w, (114, 539): -v, (114, 565): -u**2*v/w**2, (114,
        566): u*v/w, (114, 612): u*v/w, (114, 618): v**3/w, (114,
        622): -u*v**2*(u*v - w)/w**3, (114, 639): -u**2*v/w**2, (114,
        645): -u*v**3/w**2, (115, 121): -u/w, (115, 122): 1, (115,
        294): u*v**2*(u*v - w)/w**2, (115, 460): -u**2*(u*v - w)/w**2,
        (115, 563): -u**2*(u*v - w)/w**3, (115, 617): u*(u*v - w)/w,
        (115, 618): u*v*(u*v - w)**2/w**2, (115, 622): u**3*v*(u*v -
        w)/w**3, (115, 644): -u**2*(u*v - w)/w**2, (115, 645):
        u**2*v*(u*v - w)/w**2, (116, 123): -u/w, (116, 124): 1, (116,
        294): u*v*(u*v - w)/w**2, (116, 350): -u*v*(u*v - w)/w**2,
        (116, 377): -u*v**2*(u*v - w)/w**2, (116, 407): -u, (116,
        449): -u/w, (116, 461): u**2/w, (116, 503): u**2/w**2, (116,
        564): -u**2*(u*v - w)/w**3, (116, 565): -u**2*(u*v - w)/w**3,
        (116, 566): u*(u*v - w)/w**2, (116, 611): u*v/w, (116, 618):
        u**2*v*(u*v - w)/w**2, (116, 619): u*(u*v - w)/w, (116, 620):
        -u*v*(u*v - w)/w, (116, 623): -u**2*(u*v - w)/w**2, (116,
        638): -u**2*v/w**2, (116, 646): -u**2*(u*v - w)/w**2, (117,
        1): v, (117, 109): v**2/w, (117, 113): 1, (117, 117): v/w,
        (117, 450): -v**2/w, (117, 455): v, (117, 457): -v**2, (117,
        504): v/w, (117, 509): -u*v/w, (117, 511): v, (117, 612):
        v**3/w, (117, 617): -v**2, (117, 619): v**3, (117, 639):
        -v**2/w, (117, 644): u*v**2/w, (117, 646): -v**2, (118, 117):
        1/w, (118, 294): -v**3/w, (118, 348): v**2/w, (118, 450):
        -v/w, (118, 504): u*v/w**2, (118, 537): v**2/w, (118, 564):
        -v/w, (118, 612): v**2/w, (118, 618): -v**2*(u*v - w)/w, (118,
        639): -u*v**2/w**2, (119, 109): u*v**2/w**2, (119, 114): 1,
        (119, 119): v/w, (119, 126): u/w, (119, 456): v, (119, 458):
        -v**2, (119, 510): -u*v/w, (119, 512): v, (119, 618): -v**2,
        (119, 620): v**3, (119, 645): u*v**2/w, (119, 647): -v**2,
        (120, 109): u*v/w**2, (120, 119): 1/w, (121, 82): -u**2*v/w,
        (121, 105): -u*v, (121, 115): 1, (121, 121): v/w, (121, 449):
        -v**2/w, (121, 455): u*v/w, (121, 457): -u*v**2/w, (121, 503):
        v/w, (121, 509): -u**2*v/w**2, (121, 511): u*v/w, (121, 611):
        v**3/w, (121, 617): -u*v**2/w, (121, 619): u*v**3/w, (121,
        638): -v**2/w, (121, 644): u**2*v**2/w**2, (121, 646):
        -u*v**2/w, (122, 82): -u**2/w, (122, 105): -u**2*v/w, (122,
        121): 1/w, (122, 449): -v/w, (122, 455): u/w, (122, 457):
        -u*v/w, (122, 503): u*v/w**2, (122, 509): -u**2/w**2, (122,
        511): u**2*v/w**2, (122, 611): v**2/w, (122, 617): -u*v/w,
        (122, 619): u*v**2/w, (122, 638): -u*v**2/w**2, (122, 644):
        u**2*v/w**2, (122, 646): -u**2*v**2/w**2, (123, 83): u, (123,
        116): 1, (123, 123): v/w, (123, 125): u/w, (123, 133): u**2/w,
        (123, 294): u, (123, 348): -u**2/w, (123, 458): -u*v**2/w,
        (123, 512): u*v/w, (123, 537): -u**2/w, (123, 564): u**3/w**2,
        (123, 620): u*v**3/w, (123, 647): -u*v**2/w, (124, 105):
        -u**2/w, (124, 123): 1/w, (124, 458): -u*v/w, (124, 512): u/w,
        (124, 620): u*v**2/w, (124, 647): -u*v/w, (125, 105): u**2,
        (125, 294): -u*v**2/w, (125, 348): u*v/w, (125, 449): 1, (125,
        457): u, (125, 503): -u/w, (125, 511): -u**2/w, (125, 537):
        u*v/w, (125, 564): -u/w, (125, 611): -v, (125, 618): -u*v*(u*v
        - w)/w, (125, 619): -u*v, (125, 638): u*v/w, (125, 646):
        u**2*v/w, (126, 450): 1, (126, 504): -u/w, (126, 612): -v,
        (126, 639): u*v/w, (127, 128): 1, (127, 129): -u/w, (127,
        460): u*(u*v - w)/w**2, (127, 622): -u**2*v*(u*v - w)/w**3,
        (128, 82): u/w, (128, 129): 1/w, (128, 434): -v/w, (128, 488):
        u*v/w**2, (128, 596): v**2/w, (128, 623): -u*v**2/w**2, (129,
        82): u*v/w, (129, 127): 1, (129, 129): v/w, (129, 434):
        -v**2/w, (129, 488): v/w, (129, 596): v**3/w, (129, 623):
        -v**2/w, (130, 105): 1, (131, 23): 1, (131, 131): v/w, (132,
        25): 1, (132, 132): v/w, (132, 133): v/w, (133, 105): -u,
        (133, 130): 1, (134, 26): 1, (134, 134): v/w, (135, 243): 1,
        (135, 270): -u/w, (135, 567): -u/w, (135, 594): -u**2/w, (135,
        621): -u*v/w**2, (136, 244): 1, (136, 271): -u/w, (136, 568):
        -u/w, (136, 595): -u**2/w, (136, 622): -u*v/w**2, (137, 245):
        1, (137, 272): -u/w, (137, 569): -u/w, (137, 596): -u**2/w,
        (137, 623): -u*v/w**2, (138, 246): 1, (138, 273): -u/w, (138,
        570): -u/w, (138, 597): -u**2/w, (138, 624): -u*v/w**2, (139,
        247): 1, (139, 274): -u/w, (139, 571): -u/w, (139, 598):
        -u**2/w, (139, 625): -u*v/w**2, (140, 144): -u/w, (140, 145):
        1, (140, 267): -u**2*v**2/w, (140, 320): -v/w, (140, 352):
        -v/w, (140, 375): u**2*v/w, (140, 401): u*v/w**2, (140, 429):
        -u*v**2/w, (140, 456): u*v/w, (140, 514): u*v/w**2, (140,
        617): u*v/w, (140, 618): -u*v**2/w, (140, 622): v**2/w**2,
        (141, 146): -u/w, (141, 147): 1, (141, 261): -u/w, (141, 267):
        -v**2/w, (141, 271): u*v*(u*v - w)/w**3, (141, 288):
        u**2/w**2, (141, 294): u*v**2/w**2, (141, 322): -v/w, (141,
        323): v**2/w, (141, 377): u**2*v/w, (141, 403): u*v/w**2,
        (141, 458): u*v/w, (141, 568): u**2*v**2/w**3, (141, 585):
        u**2/w**2, (141, 591): u*v**2/w**2, (141, 595):
        u**3*v**2/w**3, (141, 612): u**3/w**2, (141, 618):
        u**2*v**2/w**2, (141, 619): u*v/w, (141, 620): -v, (141, 622):
        u**2*v**3/w**4, (141, 639): u**2*v/w**3, (141, 645):
        u*v**3/w**3, (142, 1): u**2/w**2, (142, 28): u**3/w**2, (142,
        55): u**2*v/w**3, (142, 148): -u/w, (142, 149): 1, (142, 266):
        -u**2/w, (142, 267): -u**2*v*(u*v - w)/w**2, (142, 271):
        -u**3*(u*v - w)/w**3, (142, 293): u**3/w**2, (142, 294):
        -u**3*v/w**2, (142, 320): -u*v/w**2, (142, 347): u**2*v/w**3,
        (142, 348): -u**2*v**2/w**3, (142, 374): u**3/w**2, (142,
        401): u**2*v/w**3, (142, 428): -u/w, (142, 429): -u*v*(u*v -
        w)/w**2, (142, 455): u**2/w**2, (142, 482): u**2/w**2, (142,
        483): -u**2*v/w**2, (142, 568): -u**4*v/w**3, (142, 590):
        u**3/w**2, (142, 591): -u**3*v/w**2, (142, 595): -u**5*v/w**3,
        (142, 617): u**4/w**2, (142, 618): -u**4*v/w**2, (142, 622):
        -u**4*v**2/w**4, (142, 644): u**3*v/w**3, (142, 645):
        -u**3*v**2/w**3, (143, 56): -u/w**2, (143, 150): -u/w, (143,
        151): 1, (143, 245): -u**2/w, (143, 260): -u/w, (143, 267):
        -u**3*v/w**2, (143, 268): -u**2/w, (143, 269): u**2*v/w, (143,
        272): u**3/w**2, (143, 287): u**2/w**2, (143, 295): u**3/w**2,
        (143, 321): -u*v/w**2, (143, 322): -u*v/w**2, (143, 323):
        u*v**2/w**2, (143, 349): u**2*v/w**3, (143, 375): u**3/w**2,
        (143, 376): u**3/w**2, (143, 377): u**2*(u*v - w)/w**2, (143,
        402): u**2*v/w**3, (143, 403): u**2*v/w**3, (143, 429):
        -u**2*v/w**2, (143, 430): -u/w, (143, 431): u*v/w, (143, 456):
        u**2/w**2, (143, 457): u**2/w**2, (143, 458): u*(u*v -
        w)/w**2, (143, 484): u**2/w**2, (143, 569): u**3/w**2, (143,
        584): u**2/w**2, (143, 592): u**3/w**2, (143, 596): u**4/w**2,
        (143, 611): u**3/w**2, (143, 619): u**4/w**2, (143, 623):
        u**3*v/w**3, (143, 638): u**2*v/w**3, (143, 646): u**3*v/w**3,
        (144, 140): 1, (144, 144): v/w, (144, 163): v/w, (144, 261):
        -v**2/w, (144, 266): v, (144, 268): -v**2, (144, 288): v/w,
        (144, 293): -u*v/w, (144, 295): v, (144, 590): -u*v/w, (144,
        617): -u**2*v/w, (144, 644): -u*v**2/w**2, (145, 144): 1/w,
        (145, 261): -v/w, (145, 267): u*v**2/w, (145, 288): u*v/w**2,
        (145, 375): -u*v/w, (145, 429): v**2/w, (145, 456): -v/w,
        (145, 585): u*v/w**2, (145, 612): u**2*v/w**2, (145, 618):
        v**2/w, (145, 639): u*v**2/w**3, (146, 136): u*v**2/w**2,
        (146, 141): 1, (146, 146): v/w, (146, 153): u/w, (146, 267):
        v, (146, 269): -v**2, (146, 294): -u*v/w, (146, 296): v, (146,
        591): -u*v/w, (146, 618): -u**2*v/w, (146, 645): -u*v**2/w**2,
        (147, 136): u*v/w**2, (147, 146): 1/w, (148, 28):
        -u**2*v/w**2, (148, 51): -u*v/w, (148, 136): -u**3*v/w**2,
        (148, 142): 1, (148, 148): v/w, (148, 159): -u**2*v/w, (148,
        260): -v**2/w, (148, 266): u*v/w, (148, 268): -u*v**2/w, (148,
        287): v/w, (148, 293): -u**2*v/w**2, (148, 295): u*v/w, (148,
        590): -u**2*v/w**2, (148, 617): -u**3*v/w**2, (148, 644):
        -u**2*v**2/w**3, (149, 28): -u**2/w**2, (149, 51):
        -u**2*v/w**2, (149, 136): -u**3/w**2, (149, 148): 1/w, (149,
        159): -u**3*v/w**2, (149, 260): -v/w, (149, 266): u/w, (149,
        268): -u*v/w, (149, 287): u*v/w**2, (149, 293): -u**2/w**2,
        (149, 295): u**2*v/w**2, (149, 584): u*v/w**2, (149, 590):
        -u**2/w**2, (149, 592): u**2*v/w**2, (149, 611): u**2*v/w**2,
        (149, 617): -u**3/w**2, (149, 619): u**3*v/w**2, (149, 638):
        u*v**2/w**3, (149, 644): -u**2*v/w**3, (149, 646):
        u**2*v**2/w**3, (150, 29): u/w, (150, 137): u**2/w, (150,
        143): 1, (150, 150): v/w, (150, 152): u/w, (150, 160): u**2/w,
        (150, 269): -u*v**2/w, (150, 296): u*v/w, (150, 321): u/w,
        (150, 402): -u**2/w**2, (150, 618): -u**2/w, (151, 51):
        -u**2/w**2, (151, 150): 1/w, (151, 159): -u**3/w**2, (151,
        269): -u*v/w, (151, 296): u/w, (152, 51): u**2/w, (152, 159):
        u**3/w, (152, 260): 1, (152, 267): u**2*v/w, (152, 268): u,
        (152, 287): -u/w, (152, 295): -u**2/w, (152, 375): -u**2/w,
        (152, 429): u*v/w, (152, 456): -u/w, (152, 584): -u/w, (152,
        592): -u**2/w, (152, 611): -u**2/w, (152, 618): u*v/w, (152,
        619): -u**3/w, (152, 638): -u*v/w**2, (152, 646):
        -u**2*v/w**2, (153, 261): 1, (153, 288): -u/w, (153, 585):
        -u/w, (153, 612): -u**2/w, (153, 639): -u*v/w**2, (154, 1):
        -u/w**2, (154, 28): -u**2/w**2, (154, 55): -u*v/w**3, (154,
        155): 1, (154, 156): -u/w, (154, 271): u**2*(u*v - w)/w**3,
        (154, 568): u**3*v/w**3, (154, 595): u**4*v/w**3, (154, 622):
        u**3*v**2/w**4, (155, 28): u/w**2, (155, 136): u**2/w**2,
        (155, 156): 1/w, (155, 245): -v/w, (155, 272): u*v/w**2, (155,
        569): u*v/w**2, (155, 596): u**2*v/w**2, (155, 623):
        u*v**2/w**3, (156, 28): u*v/w**2, (156, 136): u**2*v/w**2,
        (156, 154): 1, (156, 156): v/w, (156, 245): -v**2/w, (156,
        272): v/w, (157, 51): 1/w, (157, 159): u/w, (158, 185): 1/w,
        (159, 159): v/w, (159, 187): 1/w, (160, 51): -u/w, (160, 157):
        1, (160, 159): -u**2/w, (161, 188): 1/w, (162, 351): 1, (162,
        513): -u/w, (162, 621): -v/w, (163, 352): 1, (163, 514): -u/w,
        (163, 622): -v/w, (164, 353): 1, (164, 515): -u/w, (164, 623):
        -v/w, (165, 354): 1, (165, 516): -u/w, (165, 624): -v/w, (166,
        355): 1, (166, 517): -u/w, (166, 625): -v/w, (167, 55): -v/w,
        (167, 171): -u/w, (167, 172): 1, (167, 294): -u**2*v**2/w,
        (167, 347): -v/w, (167, 352): -v**2/w, (167, 483): -u*v**2/w,
        (167, 510): u*v/w, (167, 514): u*v**2/w**2, (167, 537):
        u**2*v/w, (167, 563): u*v/w**2, (167, 591): -u**2*v**2/w,
        (167, 618): -u**3*v**2/w, (167, 622): v**3/w**2, (167, 645):
        -u*v**2/w, (168, 173): -u/w, (168, 174): 1, (168, 349): -v/w,
        (168, 350): v**2/w, (168, 369): -u/w, (168, 375): -v**2/w,
        (168, 377): u**2*v**2/w, (168, 404): v**2/w, (168, 458):
        u*v**2/w, (168, 514): u*v*(u*v - w)/w**3, (168, 531):
        u**2/w**2, (168, 537): u*v**2/w**2, (168, 565): u*v/w**2,
        (168, 566): -v/w, (168, 568): u*v**2/w**2, (168, 595):
        u**2*v**2/w**2, (168, 622): u*v**3/w**3, (168, 639): u*v/w**2,
        (168, 645): v**3/w**2, (169, 175): -u/w, (169, 176): 1, (169,
        271): -u**2*(u*v - w)/w**2, (169, 294): -u**3*v**2/w**2, (169,
        348): -u*v**2/w**2, (169, 483): -u**2*v**2/w**2, (169, 509):
        u**2/w**2, (169, 536): u**3/w**2, (169, 563): u**2*v/w**3,
        (169, 568): -u**3*v/w**2, (169, 591): -u**3*v**2/w**2, (169,
        595): -u**4*v/w**2, (169, 618): -u**4*v**2/w**2, (169, 622):
        -u**3*v**2/w**3, (169, 644): u*(u*v - w)/w**2, (169, 645):
        -u*v*(2*u*v - w)/w**2, (170, 177): -u/w, (170, 178): 1, (170,
        245): -u, (170, 272): u**2/w, (170, 294): -u**3*v/w**2, (170,
        296): u**2*v/w, (170, 348): -u*v/w**2, (170, 350):
        u*v**2/w**2, (170, 368): -u/w, (170, 377): u**3*v**2/w**2,
        (170, 404): u*v**2/w**2, (170, 458): u**2*v**2/w**2, (170,
        483): -u**2*v/w**2, (170, 485): u*v/w, (170, 510): u**2/w**2,
        (170, 511): u**2/w**2, (170, 512): -u/w, (170, 530):
        u**2/w**2, (170, 537): u**3/w**2, (170, 538): u**3/w**2, (170,
        539): -u**2/w, (170, 564): u**2*v/w**3, (170, 565):
        u**2*v/w**3, (170, 566): -u*v/w**2, (170, 569): u**2/w, (170,
        591): -u**3*v/w**2, (170, 593): u**2*v/w, (170, 596): u**3/w,
        (170, 618): -u**4*v/w**2, (170, 620): u**3*v/w, (170, 623):
        u**2*v/w**2, (170, 638): u*v/w**2, (170, 645): -u**2*v/w**2,
        (170, 646): u*(u*v - w)/w**2, (170, 647): u*v/w, (171, 28): v,
        (171, 163): v**2/w, (171, 167): 1, (171, 171): v/w, (171,
        369): -v**2/w, (171, 374): v, (171, 376): -v**2, (171, 531):
        v/w, (171, 536): -u*v/w, (171, 538): v, (171, 585): -v**2/w,
        (171, 592): -v**2, (171, 612): -u*v**2/w, (171, 619): -u*v**2,
        (171, 644): -v**2/w, (172, 171): 1/w, (172, 294): u*v**2/w,
        (172, 369): -v/w, (172, 483): v**2/w, (172, 510): -v/w, (172,
        531): u*v/w**2, (172, 537): -u*v/w, (172, 591): u*v**2/w,
        (172, 618): u**2*v**2/w, (172, 639): v**2/w**2, (172, 645):
        v**2/w, (173, 163): u*v**2/w**2, (173, 168): 1, (173, 173):
        v/w, (173, 180): u/w, (173, 375): v, (173, 377): -v**2, (173,
        537): -u*v/w, (173, 539): v, (173, 593): -v**2, (173, 620):
        -u*v**2, (173, 645): -v**2/w, (174, 163): u*v/w**2, (174,
        173): 1/w, (175, 136): -u**2*v/w, (175, 159): -u*v, (175,
        169): 1, (175, 175): v/w, (175, 368): -v**2/w, (175, 374):
        u*v/w, (175, 376): -u*v**2/w, (175, 530): v/w, (175, 536):
        -u**2*v/w**2, (175, 538): u*v/w, (175, 584): -v**2/w, (175,
        592): -u*v**2/w, (175, 611): -u*v**2/w, (175, 619):
        -u**2*v**2/w, (175, 644): -u*v**2/w**2, (176, 136): -u**2/w,
        (176, 159): -u**2*v/w, (176, 175): 1/w, (176, 368): -v/w,
        (176, 374): u/w, (176, 376): -u*v/w, (176, 530): u*v/w**2,
        (176, 536): -u**2/w**2, (176, 538): u**2*v/w**2, (176, 638):
        v**2/w**2, (176, 644): -u*v/w**2, (176, 646): u*v**2/w**2,
        (177, 137): u, (177, 170): 1, (177, 177): v/w, (177, 179):
        u/w, (177, 187): u**2/w, (177, 348): u/w, (177, 377):
        -u*v**2/w, (177, 539): u*v/w, (177, 564): -u**2/w**2, (177,
        593): -u*v**2/w, (177, 620): -u**2*v**2/w, (178, 159):
        -u**2/w, (178, 177): 1/w, (178, 377): -u*v/w, (178, 539): u/w,
        (178, 593): -u*v/w, (178, 620): -u**2*v/w, (179, 159): u**2,
        (179, 294): u**2*v/w, (179, 368): 1, (179, 376): u, (179,
        483): u*v/w, (179, 510): -u/w, (179, 530): -u/w, (179, 537):
        -u**2/w, (179, 538): -u**2/w, (179, 591): u**2*v/w, (179,
        618): u**3*v/w, (179, 638): -v/w, (179, 645): u*v/w, (179,
        646): -u*v/w, (180, 369): 1, (180, 531): -u/w, (180, 639):
        -v/w, (181, 182): 1, (181, 183): -u/w, (181, 271): u*(u*v -
        w)/w**2, (181, 568): u**2*v/w**2, (181, 595): u**3*v/w**2,
        (181, 622): u**2*v**2/w**3, (182, 136): u/w, (182, 183): 1/w,
        (182, 353): -v/w, (182, 515): u*v/w**2, (182, 623): v**2/w**2,
        (183, 136): u*v/w, (183, 181): 1, (183, 183): v/w, (183, 353):
        -v**2/w, (183, 515): v/w, (183, 569): -v**2/w, (183, 596):
        -u*v**2/w, (184, 159): 1, (185, 50): 1, (185, 185): v/w, (186,
        52): 1, (186, 186): v/w, (186, 187): v/w, (187, 159): -u,
        (187, 184): 1, (188, 53): 1, (188, 188): v/w, (189, 297): 1,
        (189, 324): -u/w, (189, 567): -u*v/w, (189, 594): -u, (189,
        621): -u*v**2/w**2, (190, 298): 1, (190, 325): -u/w, (190,
        568): -u*v/w, (190, 595): -u, (190, 622): -u*v**2/w**2, (191,
        299): 1, (191, 326): -u/w, (191, 569): -u*v/w, (191, 596): -u,
        (191, 623): -u*v**2/w**2, (192, 300): 1, (192, 327): -u/w,
        (192, 570): -u*v/w, (192, 597): -u, (192, 624): -u*v**2/w**2,
        (193, 301): 1, (193, 328): -u/w, (193, 571): -u*v/w, (193,
        598): -u, (193, 625): -u*v**2/w**2, (194, 198): -u/w, (194,
        199): 1, (194, 267): -u*v**2, (194, 320): -v**2/w, (194, 375):
        u*v, (194, 379): -v/w, (194, 401): u*v**2/w**2, (194, 428):
        -v, (194, 455): u*v/w, (194, 541): u*v/w**2, (194, 568):
        v**2/w, (194, 622): v**3/w**2, (194, 644): u*v/w, (194, 645):
        -u*v**2/w, (195, 200): -u/w, (195, 201): 1, (195, 315): -u/w,
        (195, 321): -v**2/w, (195, 322): -v**2/w, (195, 323): v**3/w,
        (195, 325): u*v*(u*v - w)/w**3, (195, 342): u**2/w**2, (195,
        348): u*v**2/w**2, (195, 377): u*v, (195, 403): u*v**2/w**2,
        (195, 430): -v, (195, 431): v**2, (195, 457): u*v/w, (195,
        568): u**2*v**3/w**3, (195, 585): u**2*v/w**2, (195, 591):
        u*v**3/w**2, (195, 595): u**2*v**2/w**2, (195, 612): u**2/w,
        (195, 618): u*v**2/w, (195, 622): u**2*v**4/w**4, (195, 639):
        u**2*v**2/w**3, (195, 645): u*v**4/w**3, (195, 646): u*v/w,
        (195, 647): -v, (196, 1): u**2*v/w**2, (196, 28): u**2/w,
        (196, 55): u**2*v**2/w**3, (196, 202): -u/w, (196, 203): 1,
        (196, 266): -u, (196, 267): -u*v*(u*v - w)/w, (196, 293):
        u**2/w, (196, 294): -u**2*v/w, (196, 320): -u*v**2/w**2, (196,
        325): -u**3*(u*v - w)/w**3, (196, 347): u**2*v**2/w**3, (196,
        348): -u**2*v**3/w**3, (196, 374): u**2/w, (196, 401):
        u**2*v**2/w**3, (196, 428): -u*v/w, (196, 455): u**2*v/w**2,
        (196, 482): u**2*v/w**2, (196, 483): -u**2*v**2/w**2, (196,
        568): -u**4*v**2/w**3, (196, 590): u**3*v/w**2, (196, 591):
        -u**3*v**2/w**2, (196, 595): -u**4*v/w**2, (196, 617): u**3/w,
        (196, 618): -u**3*v/w, (196, 622): -u**4*v**3/w**4, (196,
        644): u**3*v**2/w**3, (196, 645): -u**3*v**3/w**3, (197, 2):
        -u/w, (197, 56): -u*v/w**2, (197, 204): -u/w, (197, 205): 1,
        (197, 267): -u**2*v/w, (197, 268): -u, (197, 269): u*v, (197,
        295): u**2/w, (197, 299): -u**2/w, (197, 314): -u/w, (197,
        321): -u*v**2/w**2, (197, 322): -u*v**2/w**2, (197, 323):
        u*v**3/w**2, (197, 326): u**3/w**2, (197, 341): u**2/w**2,
        (197, 349): u**2*v**2/w**3, (197, 375): u**2/w, (197, 376):
        u**2/w, (197, 377): u*(u*v - w)/w, (197, 402): u**2*v**2/w**3,
        (197, 403): u**2*v**2/w**3, (197, 429): -u*v/w, (197, 430):
        -u*v/w, (197, 431): u*v**2/w, (197, 456): u**2*v/w**2, (197,
        457): u**2*v/w**2, (197, 484): u**2*v/w**2, (197, 569):
        u**3*v/w**2, (197, 584): u**2*v/w**2, (197, 592): u**3*v/w**2,
        (197, 596): u**3/w, (197, 611): u**2/w, (197, 619): u**3/w,
        (197, 623): u**3*v**2/w**3, (197, 638): u**2*v**2/w**3, (197,
        646): u**3*v**2/w**3, (198, 194): 1, (198, 198): v/w, (198,
        217): v/w, (198, 315): -v**2/w, (198, 320): v, (198, 322):
        -v**2, (198, 342): v/w, (198, 347): -u*v/w, (198, 349): v,
        (198, 590): -u*v**2/w, (198, 617): -u*v, (198, 644):
        -u*v**3/w**2, (199, 198): 1/w, (199, 267): v**2, (199, 315):
        -v/w, (199, 342): u*v/w**2, (199, 375): -v, (199, 585):
        u*v**2/w**2, (199, 612): u*v/w, (199, 639): u*v**3/w**3, (199,
        645): v**2/w, (200, 190): u*v**2/w**2, (200, 195): 1, (200,
        200): v/w, (200, 207): u/w, (200, 321): v, (200, 323): -v**2,
        (200, 348): -u*v/w, (200, 350): v, (200, 591): -u*v**2/w,
        (200, 618): -u*v, (200, 645): -u*v**3/w**2, (201, 190):
        u*v/w**2, (201, 200): 1/w, (202, 55): -u**2*v/w**2, (202, 78):
        -u*v/w, (202, 190): -u**3*v/w**2, (202, 196): 1, (202, 202):
        v/w, (202, 213): -u**2*v/w, (202, 314): -v**2/w, (202, 320):
        u*v/w, (202, 322): -u*v**2/w, (202, 341): v/w, (202, 347):
        -u**2*v/w**2, (202, 349): u*v/w, (202, 590): -u**2*v**2/w**2,
        (202, 617): -u**2*v/w, (202, 644): -u**2*v**3/w**3, (203, 55):
        -u**2/w**2, (203, 78): -u**2*v/w**2, (203, 190): -u**3/w**2,
        (203, 202): 1/w, (203, 213): -u**3*v/w**2, (203, 314): -v/w,
        (203, 320): u/w, (203, 322): -u*v/w, (203, 341): u*v/w**2,
        (203, 347): -u**2/w**2, (203, 349): u**2*v/w**2, (203, 584):
        u*v**2/w**2, (203, 590): -u**2*v/w**2, (203, 592):
        u**2*v**2/w**2, (203, 611): u*v/w, (203, 617): -u**2/w, (203,
        619): u**2*v/w, (203, 638): u*v**3/w**3, (203, 644):
        -u**2*v**2/w**3, (203, 646): u**2*v**3/w**3, (204, 56): u/w,
        (204, 191): u**2/w, (204, 197): 1, (204, 204): v/w, (204,
        206): u/w, (204, 214): u**2/w, (204, 321): u*v/w, (204, 323):
        -u*v**2/w, (204, 350): u*v/w, (204, 402): -u**2*v/w**2, (204,
        429): u, (204, 456): -u**2/w, (204, 645): -u**2/w, (205, 78):
        -u**2/w**2, (205, 204): 1/w, (205, 213): -u**3/w**2, (205,
        323): -u*v/w, (205, 350): u/w, (206, 78): u**2/w, (206, 213):
        u**3/w, (206, 267): u*v, (206, 314): 1, (206, 322): u, (206,
        341): -u/w, (206, 349): -u**2/w, (206, 375): -u, (206, 584):
        -u*v/w, (206, 592): -u**2*v/w, (206, 611): -u, (206, 619):
        -u**2, (206, 638): -u*v**2/w**2, (206, 645): u*v/w, (206,
        646): -u**2*v**2/w**2, (207, 315): 1, (207, 342): -u/w, (207,
        585): -u*v/w, (207, 612): -u, (207, 639): -u*v**2/w**2, (208,
        1): -u*v/w**2, (208, 28): -u/w, (208, 55): -u*v**2/w**3, (208,
        209): 1, (208, 210): -u/w, (208, 325): u**2*(u*v - w)/w**3,
        (208, 568): u**3*v**2/w**3, (208, 595): u**3*v/w**2, (208,
        622): u**3*v**3/w**4, (209, 55): u/w**2, (209, 190):
        u**2/w**2, (209, 210): 1/w, (209, 299): -v/w, (209, 326):
        u*v/w**2, (209, 569): u*v**2/w**2, (209, 596): u*v/w, (209,
        623): u*v**3/w**3, (210, 55): u*v/w**2, (210, 190):
        u**2*v/w**2, (210, 208): 1, (210, 210): v/w, (210, 299):
        -v**2/w, (210, 326): v/w, (211, 78): 1/w, (211, 213): u/w,
        (212, 239): 1/w, (213, 213): v/w, (213, 241): 1/w, (214, 78):
        -u/w, (214, 211): 1, (214, 213): -u**2/w, (215, 242): 1/w,
        (216, 378): 1, (216, 540): -u/w, (216, 567): -v, (216, 621):
        -v**2/w, (217, 379): 1, (217, 541): -u/w, (217, 568): -v,
        (217, 622): -v**2/w, (218, 380): 1, (218, 542): -u/w, (218,
        569): -v, (218, 623): -v**2/w, (219, 381): 1, (219, 543):
        -u/w, (219, 570): -v, (219, 624): -v**2/w, (220, 382): 1,
        (220, 544): -u/w, (220, 571): -v, (220, 625): -v**2/w, (221,
        1): -v, (221, 55): -v**2/w, (221, 225): -u/w, (221, 226): 1,
        (221, 294): -u*v**2, (221, 347): -v**2/w, (221, 379): -v**2/w,
        (221, 482): -v, (221, 509): u*v/w, (221, 537): u*v, (221,
        541): u*v**2/w**2, (221, 563): u*v**2/w**2, (221, 568):
        v**3/w, (221, 591): -u*v**2, (221, 618): -u**2*v**2, (221,
        622): v**4/w**2, (221, 645): -u*v**3/w, (222, 227): -u/w,
        (222, 228): 1, (222, 349): -v**2/w, (222, 350): v**3/w, (222,
        377): u*v**2, (222, 396): -u/w, (222, 402): -v**2/w, (222,
        404): v**3/w, (222, 458): v**2, (222, 484): -v, (222, 485):
        v**2, (222, 511): u*v/w, (222, 512): -v, (222, 541): u*v*(u*v
        - w)/w**3, (222, 558): u**2/w**2, (222, 564): u*v**2/w**2,
        (222, 565): u*v**2/w**2, (222, 566): -v**2/w, (222, 568):
        u*v**3/w**2, (222, 585): u*v/w, (222, 591): v**3/w, (222,
        595): u*v**2/w, (222, 622): u*v**4/w**3, (222, 639):
        u*v**2/w**2, (222, 645): v**4/w**2, (223, 229): -u/w, (223,
        230): 1, (223, 294): -u**2*v**2/w, (223, 325): -u**2*(u*v -
        w)/w**2, (223, 348): -u*v**3/w**2, (223, 483): -u*v**2/w,
        (223, 509): u**2*v/w**2, (223, 536): u**2/w, (223, 563):
        u**2*v**2/w**3, (223, 568): -u**3*v**2/w**2, (223, 590):
        u*(u*v - w)/w, (223, 591): -u*v*(2*u*v - w)/w, (223, 595):
        -u**3*v/w, (223, 618): -u**3*v**2/w, (223, 622):
        -u**3*v**3/w**3, (223, 644): u*v*(u*v - w)/w**2, (223, 645):
        -u*v**2*(2*u*v - w)/w**2, (224, 231): -u/w, (224, 232): 1,
        (224, 294): -u**2*v/w, (224, 296): u*v, (224, 299): -u, (224,
        326): u**2/w, (224, 348): -u*v**2/w**2, (224, 350):
        u*v**3/w**2, (224, 377): u**2*v**2/w, (224, 395): -u/w, (224,
        404): u*v**3/w**2, (224, 458): u*v**2/w, (224, 483): -u*v/w,
        (224, 485): u*v**2/w, (224, 510): u**2*v/w**2, (224, 511):
        u**2*v/w**2, (224, 512): -u*v/w, (224, 537): u**2/w, (224,
        538): u**2/w, (224, 539): -u, (224, 557): u**2/w**2, (224,
        564): u**2*v**2/w**3, (224, 565): u**2*v**2/w**3, (224, 566):
        -u*v**2/w**2, (224, 569): u**2*v/w, (224, 584): u*v/w, (224,
        591): -u**2*v/w, (224, 592): u*(u*v - w)/w, (224, 593): u*v,
        (224, 596): u**2, (224, 618): -u**3*v/w, (224, 620): u**2*v,
        (224, 623): u**2*v**2/w**2, (224, 638): u*v**2/w**2, (224,
        645): -u**2*v**2/w**2, (224, 646): u*v*(u*v - w)/w**2, (224,
        647): u*v**2/w, (225, 55): v, (225, 217): v**2/w, (225, 221):
        1, (225, 225): v/w, (225, 396): -v**2/w, (225, 401): v, (225,
        403): -v**2, (225, 558): v/w, (225, 563): -u*v/w, (225, 565):
        v, (225, 590): -v**2, (225, 612): -v**2, (225, 619): -v**2*w,
        (225, 644): -v**3/w, (226, 225): 1/w, (226, 294): v**2, (226,
        396): -v/w, (226, 537): -v, (226, 558): u*v/w**2, (226, 585):
        v**2/w, (226, 591): v**2, (226, 618): u*v**2, (226, 639):
        v**3/w**2, (226, 645): v**3/w, (227, 217): u*v**2/w**2, (227,
        222): 1, (227, 227): v/w, (227, 234): u/w, (227, 402): v,
        (227, 404): -v**2, (227, 564): -u*v/w, (227, 566): v, (227,
        591): -v**2, (227, 620): -v**2*w, (227, 645): -v**3/w, (228,
        217): u*v/w**2, (228, 227): 1/w, (229, 190): -u**2*v/w, (229,
        213): -u*v, (229, 223): 1, (229, 229): v/w, (229, 395):
        -v**2/w, (229, 401): u*v/w, (229, 403): -u*v**2/w, (229, 557):
        v/w, (229, 563): -u**2*v/w**2, (229, 565): u*v/w, (229, 590):
        -u*v**2/w, (229, 611): -v**2, (229, 619): -u*v**2, (229, 644):
        -u*v**3/w**2, (230, 190): -u**2/w, (230, 213): -u**2*v/w,
        (230, 229): 1/w, (230, 395): -v/w, (230, 401): u/w, (230,
        403): -u*v/w, (230, 557): u*v/w**2, (230, 563): -u**2/w**2,
        (230, 565): u**2*v/w**2, (230, 584): v**2/w, (230, 590):
        -u*v/w, (230, 592): u*v**2/w, (230, 638): v**3/w**2, (230,
        644): -u*v**2/w**2, (230, 646): u*v**3/w**2, (231, 191): u,
        (231, 224): 1, (231, 231): v/w, (231, 233): u/w, (231, 241):
        u**2/w, (231, 348): u*v/w, (231, 404): -u*v**2/w, (231, 483):
        u, (231, 510): -u**2/w, (231, 564): -u**2*v/w**2, (231, 566):
        u*v/w, (231, 620): -u*v**2, (232, 213): -u**2/w, (232, 231):
        1/w, (232, 404): -u*v/w, (232, 566): u/w, (232, 620): -u*v,
        (233, 213): u**2, (233, 294): u*v, (233, 395): 1, (233, 403):
        u, (233, 537): -u, (233, 557): -u/w, (233, 565): -u**2/w,
        (233, 584): -v, (233, 591): u*v, (233, 592): -u*v, (233, 618):
        u**2*v, (233, 638): -v**2/w, (233, 645): u*v**2/w, (233, 646):
        -u*v**2/w, (234, 396): 1, (234, 558): -u/w, (234, 585): -v,
        (234, 639): -v**2/w, (235, 236): 1, (235, 237): -u/w, (235,
        325): u*(u*v - w)/w**2, (235, 568): u**2*v**2/w**2, (235,
        595): u**2*v/w, (235, 622): u**2*v**3/w**3, (236, 190): u/w,
        (236, 237): 1/w, (236, 380): -v/w, (236, 542): u*v/w**2, (236,
        569): v**2/w, (236, 623): v**3/w**2, (237, 190): u*v/w, (237,
        235): 1, (237, 237): v/w, (237, 380): -v**2/w, (237, 542):
        v/w, (237, 596): -v**2, (238, 213): 1, (239, 77): 1, (239,
        239): v/w, (240, 79): 1, (240, 240): v/w, (240, 241): v/w,
        (241, 213): -u, (241, 238): 1, (242, 80): 1, (242, 242): v/w,
        (243, 270): 1/w, (243, 594): u/w, (244, 271): 1/w, (244, 595):
        u/w, (245, 272): 1/w, (245, 596): u/w, (246, 273): 1/w, (246,
        597): u/w, (247, 274): 1/w, (247, 598): u/w, (248, 51): u*v/w,
        (248, 159): u**2*v/w, (248, 252): -u/w, (248, 253): 1, (248,
        267): u**3*v/w, (248, 325): -v/w**2, (248, 348): u**2*v/w**2,
        (248, 429): u**2*v/w, (248, 617): -v/w, (248, 622): -u*v/w**2,
        (248, 645): u**3*v/w**2, (249, 136): -u*v/w**2, (249, 188):
        -v/w, (249, 244): -u**2*v/w**2, (249, 254): -u/w, (249, 255):
        1, (249, 271): -u*v**2/w**3, (249, 288): -u/w**2, (249, 294):
        -v**2/w**2, (249, 323): -u*v/w, (249, 377): -u*v/w, (249,
        595): -u**2*v**2/w**3, (249, 612): -u**2/w**2, (249, 618):
        -u*v**2/w**2, (249, 619): -v/w, (249, 622): -u**2*v/w**3,
        (250, 51): u**2*v/w**2, (250, 82): u**2/w**2, (250, 136):
        u**3/w**2, (250, 159): u**3*v/w**2, (250, 244): u**4/w**2,
        (250, 256): -u/w, (250, 257): 1, (250, 267): u**4*v/w**2,
        (250, 271): u**3*v/w**3, (250, 293): -u**2/w**2, (250, 294):
        u**2*v/w**2, (250, 348): u**3*v/w**3, (250, 374): -u**2/w**2,
        (250, 375): u**2*v/w**2, (250, 406): u**3/w**2, (250, 429):
        u**3*v/w**2, (250, 455): -u/w**2, (250, 456): u*v/w**2, (250,
        460): u**2*v/w**3, (250, 568): u**3*v/w**3, (250, 595):
        u**3*(u*v + w)/w**3, (250, 617): -u**3/w**2, (250, 618):
        u*v*(u**2 - v)/w**2, (250, 645): u**4*v/w**3, (251, 51):
        u**2/w**2, (251, 53): -u/w, (251, 159): u**3/w**2, (251, 161):
        -u**2/w, (251, 188): -u*v/w**2, (251, 258): -u/w, (251, 259):
        1, (251, 267): u**4/w**2, (251, 269): -u**3/w, (251, 272):
        -u**2/w**2, (251, 287): -u/w**2, (251, 295): -u**2/w**2, (251,
        323): -u**2*v/w**2, (251, 348): u**3/w**3, (251, 350):
        -u**2/w**2, (251, 376): -u**2/w**2, (251, 377): -u**2*v/w**2,
        (251, 429): u**3/w**2, (251, 431): -u**2/w, (251, 457):
        -u/w**2, (251, 461): -u/w**2, (251, 569): -u**2/w**2, (251,
        596): -u**3/w**2, (251, 611): -u**2/w**2, (251, 618):
        -u*v/w**2, (251, 619): -u**3/w**2, (251, 645): u**4/w**3,
        (251, 647): -u**3/w**2, (252, 153): v/w, (252, 160): v, (252,
        248): 1, (252, 252): v/w, (252, 261): u*v/w, (252, 268): u*v,
        (252, 293): v/w, (252, 298): v/w, (252, 617): u*v/w, (252,
        639): u*v/w**2, (252, 646): u*v/w, (253, 51): -v/w, (253,
        159): -u*v/w, (253, 252): 1/w, (253, 267): -u**2*v/w, (253,
        288): -v/w**2, (253, 348): -u*v/w**2, (253, 429): -u*v/w,
        (253, 612): -u*v/w**2, (253, 645): -u**2*v/w**2, (254, 161):
        v, (254, 244): u*v**2/w**2, (254, 249): 1, (254, 254): v/w,
        (254, 261): u/w, (254, 269): u*v, (254, 294): v/w, (254, 618):
        u*v/w, (254, 647): u*v/w, (255, 244): u*v/w**2, (255, 254):
        1/w, (256, 152): v/w, (256, 160): u*v/w, (256, 244):
        -u**3*v/w**2, (256, 250): 1, (256, 256): v/w, (256, 260):
        u*v/w, (256, 267): -u**2*v/w, (256, 268): u**2*v/w, (256,
        293): u*v/w**2, (256, 406): -u**2*v/w**2, (256, 429): -u*v/w,
        (256, 617): u**2*v/w**2, (256, 638): u*v/w**2, (256, 646):
        u**2*v/w**2, (257, 244): -u**3/w**2, (257, 256): 1/w, (257,
        267): -u**3*v/w**2, (257, 287): -v/w**2, (257, 293): u/w**2,
        (257, 295): -u*v/w**2, (257, 406): -u**2/w**2, (257, 429):
        -u**2*v/w**2, (257, 611): -u*v/w**2, (257, 617): u**2/w**2,
        (257, 619): -u**2*v/w**2, (258, 161): u*v/w, (258, 245):
        u**2/w, (258, 251): 1, (258, 258): v/w, (258, 260): u/w, (258,
        268): u**2/w, (258, 269): u**2*v/w, (258, 407): u/w, (258,
        618): u/w, (258, 647): u**2*v/w**2, (259, 161): u/w, (259,
        258): 1/w, (259, 267): -u**3/w**2, (259, 269): u**2/w, (259,
        429): -u**2/w**2, (259, 647): u**2/w**2, (260, 51): -u/w,
        (260, 159): -u**2/w, (260, 287): 1/w, (260, 295): u/w, (260,
        348): -u**2/w**2, (260, 611): u/w, (260, 619): u**2/w, (260,
        645): -u**3/w**2, (261, 288): 1/w, (261, 612): u/w, (262, 82):
        -u/w**2, (262, 136): -u**2/w**2, (262, 244): -u**3/w**2, (262,
        263): 1, (262, 264): -u/w, (262, 271): -u**2*v/w**3, (262,
        406): -u**2/w**2, (262, 460): -u*v/w**3, (262, 568):
        -u**2*v/w**3, (262, 595): -u**2*(u*v + w)/w**3, (263, 244):
        u**2/w**2, (263, 264): 1/w, (263, 272): -v/w**2, (263, 406):
        u/w**2, (263, 596): -u*v/w**2, (264, 137): v/w, (264, 244):
        u**2*v/w**2, (264, 245): u*v/w, (264, 262): 1, (264, 264):
        v/w, (264, 406): u*v/w**2, (264, 623): u*v/w**2, (265, 267):
        u/w, (265, 429): 1/w, (266, 320): 1/w, (267, 267): v/w, (267,
        322): 1/w, (268, 265): 1, (268, 267): -u**2/w, (268, 429):
        -u/w, (269, 323): 1/w, (270, 135): 1, (270, 270): v/w, (270,
        594): u*v/w, (271, 136): 1, (271, 271): v/w, (271, 595):
        u*v/w, (272, 137): 1, (272, 272): v/w, (272, 596): u*v/w,
        (273, 138): 1, (273, 273): v/w, (273, 597): u*v/w, (274, 139):
        1, (274, 274): v/w, (274, 598): u*v/w, (275, 185): -v/w, (275,
        267): u**2*v, (275, 279): -u/w, (275, 280): 1, (275, 294):
        -u**3*v/w, (275, 429): u*v, (275, 483): -u**2*v/w, (275, 487):
        u*v/w**2, (275, 514): u**2*v/w**2, (275, 591): -u**3*v/w,
        (275, 617): -v**2/w, (275, 618): -u**4*v/w, (275, 622): -v/w,
        (276, 136): -u*v**2/w**2, (276, 153): -u/w, (276, 159):
        -v**2/w, (276, 187): -v/w, (276, 244): -u*v/w, (276, 271):
        -u*v**3/w**3, (276, 281): -u/w, (276, 282): 1, (276, 288):
        -u*v/w**2, (276, 294): -v**3/w**2, (276, 323): -v, (276, 377):
        u*v*(u**2 - v)/w, (276, 404): u*v/w, (276, 458): u**2*v/w,
        (276, 568): u**2*v/w**2, (276, 595): u**2*v*(u*w - v**2)/w**3,
        (276, 612): -u**2*v/w**2, (276, 618): -u*v**3/w**2, (276,
        619): -v**2/w, (277, 50): -u/w, (277, 51): u*v/w, (277, 109):
        u**2/w**2, (277, 158): -u**2/w, (277, 159): u**2*v/w, (277,
        163): u**3/w**2, (277, 185): -u*v/w**2, (277, 267): u**3*v/w,
        (277, 283): -u/w, (277, 284): 1, (277, 293): -u**2*v/w**2,
        (277, 294): -u**2*v*(u**2 - v)/w**2, (277, 352): u**4/w**2,
        (277, 374): -u**2*v/w**2, (277, 375): u**2*v**2/w**2, (277,
        429): u**2*v/w, (277, 433): u**3/w**2, (277, 455): -u*v/w**2,
        (277, 456): u*v**2/w**2, (277, 483): -u**3*v/w**2, (277, 487):
        u**2*v/w**3, (277, 514): u**3*v/w**3, (277, 591):
        -u**4*v/w**2, (277, 617): -u**3*v/w**2, (277, 618): -u*v*(u**4
        - u**2*v + v**2)/w**2, (277, 622): -u**2*v**2/w**3, (278, 52):
        -u/w, (278, 152): -u/w, (278, 160): -u**2/w, (278, 186):
        -u*v/w**2, (278, 187): -u*v/w**2, (278, 267): u**3/w, (278,
        269): -u**2, (278, 285): -u/w, (278, 286): 1, (278, 287):
        -u*v/w**2, (278, 294): -u**4/w**2, (278, 295): -u**2*v/w**2,
        (278, 296): u**3/w, (278, 323): -u*v/w, (278, 376):
        -u**2*v/w**2, (278, 377): u**2*v*(u**2 - v)/w**2, (278, 404):
        u**2*v/w**2, (278, 429): u**2/w, (278, 431): -u, (278, 457):
        -u*v/w**2, (278, 458): u**3*v/w**2, (278, 483): -u**3/w**2,
        (278, 485): u**2/w, (278, 488): -u/w**2, (278, 515):
        -u**2/w**2, (278, 591): -u**4/w**2, (278, 593): u**3/w, (278,
        611): -u**2*v/w**2, (278, 618): -u*(u**4 + v**2)/w**2, (278,
        619): -u**3*v/w**2, (278, 620): u**4/w, (278, 623): u*v/w**2,
        (279, 158): v, (279, 261): v, (279, 268): v*w, (279, 275): 1,
        (279, 279): v/w, (279, 293): v**2/w, (279, 352): -u**2*v/w,
        (279, 433): -u*v/w, (279, 585): -u*v/w, (279, 592): -u*v,
        (279, 595): v, (279, 612): -u**2*v/w, (279, 617): u*v**2/w,
        (279, 619): -u**2*v, (280, 153): -v/w, (280, 267): -u*v, (280,
        279): 1/w, (280, 288): -v**2/w**2, (280, 294): u**2*v/w, (280,
        429): -v, (280, 483): u*v/w, (280, 591): u**2*v/w, (280, 612):
        -u*v**2/w**2, (280, 618): u**3*v/w, (281, 159): v, (281, 269):
        v*w, (281, 271): u*v**2/w**2, (281, 276): 1, (281, 281): v/w,
        (281, 288): u/w, (281, 294): v**2/w, (281, 593): -u*v, (281,
        618): u*v**2/w, (281, 620): -u**2*v, (282, 271): u*v/w**2,
        (282, 281): 1/w, (283, 158): u*v/w, (283, 260): v, (283, 268):
        u*v, (283, 277): 1, (283, 283): v/w, (283, 293): u*v**2/w**2,
        (283, 352): -u**3*v/w**2, (283, 375): -u**2*v/w, (283, 433):
        -u**2*v/w**2, (283, 456): -u*v/w, (283, 584): -u*v/w, (283,
        592): -u**2*v/w, (283, 595): u**2*v**2/w**2, (283, 611):
        -u**2*v/w, (283, 617): u**2*v**2/w**2, (283, 618): u*v**2/w,
        (283, 619): -u**3*v/w, (284, 152): -v/w, (284, 158): u/w,
        (284, 160): -u*v/w, (284, 283): 1/w, (284, 287): -v**2/w**2,
        (284, 293): u*v/w**2, (284, 295): -u*v**2/w**2, (284, 352):
        -u**3/w**2, (284, 375): -u**3*v/w**2, (284, 433): -u**2/w**2,
        (284, 456): -u**2*v/w**2, (284, 595): u**2*v/w**2, (284, 611):
        -u*v**2/w**2, (284, 617): u**2*v/w**2, (284, 618):
        u**2*v**2/w**2, (284, 619): -u**2*v**2/w**2, (285, 186): u/w,
        (285, 269): u*v, (285, 278): 1, (285, 285): v/w, (285, 287):
        u/w, (285, 295): u**2/w, (285, 353): u**2/w, (285, 434): u/w,
        (285, 593): -u**2*v/w, (285, 596): -u*v/w, (285, 618): u*v/w,
        (285, 620): -u**3*v/w, (286, 269): u, (286, 285): 1/w, (286,
        375): -u**3/w**2, (286, 456): -u**2/w**2, (286, 593): -u**2/w,
        (286, 618): u**2*v/w**2, (286, 620): -u**3/w, (287, 152): 1,
        (287, 160): u, (287, 267): -u**2, (287, 287): v/w, (287, 294):
        u**3/w, (287, 295): u*v/w, (287, 375): u**3/w, (287, 429): -u,
        (287, 456): u**2/w, (287, 483): u**2/w, (287, 591): u**3/w,
        (287, 611): u*v/w, (287, 618): u**2*(u**2 - v)/w, (287, 619):
        u**2*v/w, (288, 153): 1, (288, 288): v/w, (288, 612): u*v/w,
        (289, 109): -u/w**2, (289, 163): -u**2/w**2, (289, 290): 1,
        (289, 291): -u/w, (289, 352): -u**3/w**2, (289, 433):
        -u**2/w**2, (289, 487): -u*v/w**3, (289, 514): -u**2*v/w**3,
        (289, 622): u*v**2/w**3, (290, 137): -v/w, (290, 272):
        -v**2/w**2, (290, 291): 1/w, (290, 352): u**2/w**2, (290,
        433): u/w**2, (290, 595): -u*v/w**2, (290, 596): -u*v**2/w**2,
        (291, 245): v, (291, 289): 1, (291, 291): v/w, (291, 352):
        u**2*v/w**2, (291, 433): u*v/w**2, (291, 569): -u*v/w, (291,
        595): -u*v**2/w**2, (291, 596): -u**2*v/w, (292, 375): u/w,
        (292, 456): 1/w, (292, 618): -v/w, (293, 374): -u**2/w, (293,
        455): -u/w, (293, 617): 1, (294, 294): v/w, (294, 376):
        -u**2/w, (294, 457): -u/w, (294, 619): 1, (295, 292): 1, (295,
        375): -u**2/w, (295, 456): -u/w, (295, 618): u*v/w, (296,
        377): -u**2/w, (296, 458): -u/w, (296, 620): 1, (297, 324):
        1/w, (297, 621): u/w, (298, 325): 1/w, (298, 622): u/w, (299,
        326): 1/w, (299, 623): u/w, (300, 327): 1/w, (300, 624): u/w,
        (301, 328): 1/w, (301, 625): u/w, (302, 78): u*v/w, (302,
        213): u**2*v/w, (302, 267): u**2*v, (302, 306): -u/w, (302,
        307): 1, (302, 325): -v**2/w**2, (302, 348): u**2*v**2/w**2,
        (302, 460): -v/w, (302, 483): u**2*v/w, (302, 568): -u*v/w,
        (302, 591): u**3*v/w, (302, 622): -u*v**2/w**2, (302, 644):
        -v/w, (302, 645): u**3*v**2/w**2, (303, 190): -u*v/w**2, (303,
        242): -v/w, (303, 298): -u**2*v/w**2, (303, 308): -u/w, (303,
        309): 1, (303, 323): -u*v**2/w, (303, 325): -u*v**2/w**3,
        (303, 342): -u/w**2, (303, 348): -v**2/w**2, (303, 404):
        -u*v/w, (303, 431): -u*v, (303, 568): -u**2*v/w**2, (303,
        622): -2*u**2*v**2/w**3, (303, 639): -u**2/w**2, (303, 645):
        -u*v**2/w**2, (303, 646): -v/w, (304, 78): u**2*v/w**2, (304,
        136): u**2/w, (304, 213): u**3*v/w**2, (304, 244): u**3/w,
        (304, 267): u**3*v/w, (304, 271): u**2*v/w**2, (304, 310):
        -u/w, (304, 311): 1, (304, 347): -u**2/w**2, (304, 348):
        u**2*v*(u*v + w)/w**3, (304, 374): -u/w, (304, 375): u*v/w,
        (304, 483): u**3*v/w**2, (304, 591): u**4*v/w**2, (304, 595):
        u**3*v/w**2, (304, 622): u**3/w**2, (304, 644): -u**3/w**2,
        (304, 645): u*v*(u**3*v + u**2*w - v*w)/w**3, (305, 78):
        u**2/w**2, (305, 80): -u/w, (305, 213): u**3/w**2, (305, 215):
        -u**2/w, (305, 242): -u*v/w**2, (305, 267): u**3/w, (305,
        269): -u**2, (305, 272): -u/w, (305, 312): -u/w, (305, 313):
        1, (305, 323): -u**2*v**2/w**2, (305, 341): -u/w**2, (305,
        348): u**3*v/w**3, (305, 349): -u**2/w**2, (305, 350):
        -u**2*v/w**2, (305, 376): -u/w, (305, 404): -u**2*v/w**2,
        (305, 431): -u**2*v/w, (305, 483): u**3/w**2, (305, 485):
        -u**2/w, (305, 591): u**4/w**2, (305, 593): -u**3/w, (305,
        596): -u**2/w, (305, 638): -u**2/w**2, (305, 645): u*v*(u**3 -
        w)/w**3, (305, 646): -u**3/w**2, (305, 647): -u**3*v/w**2,
        (306, 207): v/w, (306, 214): v, (306, 298): v**2/w, (306,
        302): 1, (306, 306): v/w, (306, 315): u*v/w, (306, 322): u*v,
        (306, 347): v/w, (306, 406): v, (306, 585): u*v/w, (306, 592):
        u*v, (306, 639): u*v**2/w**2, (306, 644): u*v/w, (306, 646):
        u*v**2/w, (307, 78): -v/w, (307, 213): -u*v/w, (307, 267):
        -u*v, (307, 306): 1/w, (307, 342): -v/w**2, (307, 348):
        -u*v**2/w**2, (307, 483): -u*v/w, (307, 591): -u**2*v/w, (307,
        639): -u*v/w**2, (307, 645): -u**2*v**2/w**2, (308, 215): v,
        (308, 298): u*v**2/w**2, (308, 303): 1, (308, 308): v/w, (308,
        315): u/w, (308, 323): u*v, (308, 348): v/w, (308, 593): u*v,
        (308, 645): u*v/w, (308, 647): u*v**2/w, (309, 298): u*v/w**2,
        (309, 308): 1/w, (310, 206): v/w, (310, 214): u*v/w, (310,
        244): -u**2*v/w, (310, 267): -u*v, (310, 304): 1, (310, 310):
        v/w, (310, 314): u*v/w, (310, 322): u**2*v/w, (310, 347):
        u*v/w**2, (310, 584): u*v/w, (310, 592): u**2*v/w, (310, 638):
        u*v**2/w**2, (310, 644): u**2*v/w**2, (310, 646):
        u**2*v**2/w**2, (311, 244): -u**2/w, (311, 267): -u**2*v/w,
        (311, 310): 1/w, (311, 341): -v/w**2, (311, 347): u/w**2,
        (311, 349): -u*v/w**2, (311, 638): -u*v/w**2, (311, 644):
        u**2/w**2, (311, 646): -u**2*v/w**2, (312, 215): u*v/w, (312,
        245): u, (312, 305): 1, (312, 312): v/w, (312, 314): u/w,
        (312, 322): u**2/w, (312, 323): u**2*v/w, (312, 593):
        u**2*v/w, (312, 645): u/w, (312, 647): u**2*v**2/w**2, (313,
        215): u/w, (313, 267): -u**2/w, (313, 312): 1/w, (313, 323):
        u**2/w, (313, 593): u**2/w, (313, 647): u**2*v/w**2, (314,
        78): -u/w, (314, 213): -u**2/w, (314, 341): 1/w, (314, 348):
        -u**2*v/w**2, (314, 349): u/w, (314, 483): -u**2/w, (314,
        591): -u**3/w, (314, 638): u/w, (314, 645): -u**3*v/w**2,
        (314, 646): u**2/w, (315, 342): 1/w, (315, 639): u/w, (316,
        136): -u/w, (316, 244): -u**2/w, (316, 271): -u*v/w**2, (316,
        317): 1, (316, 318): -u/w, (316, 595): -u**2*v/w**2, (316,
        622): -u**2/w**2, (317, 244): u/w, (317, 318): 1/w, (317,
        326): -v/w**2, (317, 623): -u*v/w**2, (318, 191): v/w, (318,
        244): u*v/w, (318, 299): u*v/w, (318, 316): 1, (318, 318):
        v/w, (318, 569): u*v/w, (318, 623): u*v**2/w**2, (319, 267):
        1, (320, 320): v/w, (320, 428): 1, (321, 321): v/w, (321,
        322): v/w, (321, 430): 1, (322, 267): -u, (322, 319): 1, (323,
        323): v/w, (323, 431): 1, (324, 189): 1, (324, 324): v/w,
        (324, 621): u*v/w, (325, 190): 1, (325, 325): v/w, (325, 622):
        u*v/w, (326, 191): 1, (326, 326): v/w, (326, 623): u*v/w,
        (327, 192): 1, (327, 327): v/w, (327, 624): u*v/w, (328, 193):
        1, (328, 328): v/w, (328, 625): u*v/w, (329, 239): -v/w, (329,
        267): u*v*w, (329, 294): -u**2*v, (329, 333): -u/w, (329,
        334): 1, (329, 514): u*v/w, (329, 568): -v, (329, 618):
        -u**3*v, (329, 622): -v**2/w, (329, 644): -v**2/w, (330, 190):
        -u*v**2/w**2, (330, 207): -u/w, (330, 213): -v**2/w, (330,
        241): -v/w, (330, 298): -u*v/w, (330, 323): -v**2, (330, 325):
        -u*v**3/w**3, (330, 335): -u/w, (330, 336): 1, (330, 342):
        -u*v/w**2, (330, 348): -v**3/w**2, (330, 377): u**2*v, (330,
        431): -v*w, (330, 458): u*v, (330, 595): u**2*v/w, (330, 622):
        -u**2*v**3/w**3, (330, 639): -u**2*v/w**2, (330, 645):
        -u*v**3/w**2, (330, 646): -v**2/w, (331, 77): -u/w, (331, 78):
        u*v/w, (331, 163): u**2/w, (331, 212): -u**2/w, (331, 213):
        u**2*v/w, (331, 239): -u*v/w**2, (331, 267): u**2*v, (331,
        294): -u**3*v/w, (331, 337): -u/w, (331, 338): 1, (331, 347):
        -u**2*v/w**2, (331, 348): u**2*v**2/w**2, (331, 352): u**3/w,
        (331, 374): -u*v/w, (331, 375): u*v**2/w, (331, 514):
        u**2*v/w**2, (331, 568): -u**2*v**2/w**2, (331, 618):
        -u**4*v/w, (331, 622): -u**2*v**3/w**3, (331, 644):
        -u**3*v/w**2, (331, 645): u*v**2*(u**2 - v)/w**2, (332, 79):
        -u/w, (332, 206): -u/w, (332, 214): -u**2/w, (332, 240):
        -u*v/w**2, (332, 241): -u*v/w**2, (332, 267): u**2, (332,
        269): -u*w, (332, 294): -u**3/w, (332, 296): u**2, (332, 323):
        -u*v**2/w, (332, 339): -u/w, (332, 340): 1, (332, 341):
        -u*v/w**2, (332, 349): -u**2*v/w**2, (332, 376): -u*v/w, (332,
        377): u**3*v/w, (332, 431): -u*v, (332, 458): u**2*v/w, (332,
        515): -u/w, (332, 569): u*v/w, (332, 618): -u**4/w, (332,
        620): u**3, (332, 623): u*v**2/w**2, (332, 638): -u**2*v/w**2,
        (332, 645): -u*v**2/w**2, (332, 646): -u**3*v/w**2, (333,
        212): v, (333, 315): v, (333, 322): v*w, (333, 329): 1, (333,
        333): v/w, (333, 347): v**2/w, (333, 352): -u*v, (333, 612):
        -u*v, (333, 619): -u*v*w, (333, 622): v, (333, 644): u*v**2/w,
        (334, 207): -v/w, (334, 267): -v*w, (334, 294): u*v, (334,
        333): 1/w, (334, 342): -v**2/w**2, (334, 618): u**2*v, (334,
        639): -u*v**2/w**2, (335, 213): v, (335, 323): v*w, (335,
        325): u*v**2/w**2, (335, 330): 1, (335, 335): v/w, (335, 342):
        u/w, (335, 348): v**2/w, (335, 620): -u*v*w, (335, 645):
        u*v**2/w, (336, 325): u*v/w**2, (336, 335): 1/w, (337, 212):
        u*v/w, (337, 314): v, (337, 322): u*v, (337, 331): 1, (337,
        337): v/w, (337, 347): u*v**2/w**2, (337, 352): -u**2*v/w,
        (337, 375): -u*v, (337, 611): -u*v, (337, 619): -u**2*v, (337,
        622): u**2*v**2/w**2, (337, 644): u**2*v**2/w**2, (337, 645):
        u*v**2/w, (338, 206): -v/w, (338, 212): u/w, (338, 214):
        -u*v/w, (338, 337): 1/w, (338, 341): -v**2/w**2, (338, 347):
        u*v/w**2, (338, 349): -u*v**2/w**2, (338, 352): -u**2/w, (338,
        375): -u**2*v/w, (338, 622): u**2*v/w**2, (338, 638):
        -u*v**2/w**2, (338, 644): u**2*v/w**2, (338, 645):
        u**2*v**2/w**2, (338, 646): -u**2*v**2/w**2, (339, 240): u/w,
        (339, 323): u*v, (339, 332): 1, (339, 339): v/w, (339, 341):
        u/w, (339, 349): u**2/w, (339, 353): u, (339, 620): -u**2*v,
        (339, 623): -u*v/w, (339, 645): u*v/w, (340, 323): u, (340,
        339): 1/w, (340, 375): -u**2/w, (340, 620): -u**2, (340, 645):
        u**2*v/w**2, (341, 206): 1, (341, 214): u, (341, 267): -u*w,
        (341, 294): u**2, (341, 341): v/w, (341, 349): u*v/w, (341,
        375): u**2, (341, 618): u**3, (341, 638): u*v/w, (341, 645):
        -u**2*v/w, (341, 646): u**2*v/w, (342, 207): 1, (342, 342):
        v/w, (342, 639): u*v/w, (343, 163): -u/w, (343, 344): 1, (343,
        345): -u/w, (343, 352): -u**2/w, (343, 514): -u*v/w**2, (343,
        568): u*v**2/w**2, (343, 622): u*v**3/w**3, (344, 191): -v/w,
        (344, 326): -v**2/w**2, (344, 345): 1/w, (344, 352): u/w,
        (344, 622): -u*v/w**2, (344, 623): -u*v**2/w**2, (345, 299):
        v, (345, 343): 1, (345, 345): v/w, (345, 352): u*v/w, (345,
        596): -u*v, (345, 622): -u*v**2/w**2, (346, 375): 1, (346,
        645): -v/w, (347, 374): -u, (347, 644): 1, (348, 348): v/w,
        (348, 376): -u, (348, 646): 1, (349, 346): 1, (349, 375): -u,
        (349, 645): u*v/w, (350, 377): -u, (350, 647): 1, (351, 513):
        1/w, (352, 514): 1/w, (353, 515): 1/w, (354, 516): 1/w, (355,
        517): 1/w, (356, 159): u*v, (356, 190): -v/w, (356, 294):
        u*v**2/w, (356, 325): -v**2/w**2, (356, 360): -u/w, (356,
        361): 1, (356, 514): -v**2/w**2, (356, 563): -v/w**2, (356,
        618): u**2*v**2/w, (356, 622): -u*v**2/w**2, (356, 645):
        u**2*v/w, (357, 53): -v, (357, 163): -u*v/w**2, (357, 188):
        -v**2/w, (357, 350): -u*v/w, (357, 352): -u**2*v/w**2, (357,
        362): -u/w, (357, 363): 1, (357, 377): -2*u*v**2/w, (357,
        458): -v**2/w, (357, 514): -u*v**2/w**3, (357, 531): -u/w**2,
        (357, 537): -v**2/w**2, (357, 565): -v/w**2, (357, 595):
        -u*v**2/w**2, (358, 159): u**2*v/w, (358, 294):
        u**2*v**2/w**2, (358, 364): -u/w, (358, 365): 1, (358, 509):
        -u/w**2, (358, 510): u*v/w**2, (358, 536): -u**2/w**2, (358,
        537): u**2*v/w**2, (358, 563): -u*v/w**3, (358, 568):
        u**2*v/w**2, (358, 595): u**2/w, (358, 618): u**3*v**2/w**2,
        (358, 622): u**2*v**2/w**3, (358, 645): u**3*v/w**2, (359,
        53): -u*v/w, (359, 159): u**2/w, (359, 161): -u, (359, 188):
        -u*v**2/w**2, (359, 294): u**2*v/w**2, (359, 296): -u*v/w,
        (359, 350): -u**2*v/w**2, (359, 366): -u/w, (359, 367): 1,
        (359, 377): -2*u**2*v**2/w**2, (359, 458): -u*v**2/w**2, (359,
        511): -u/w**2, (359, 530): -u/w**2, (359, 538): -u**2/w**2,
        (359, 564): -u*v/w**3, (359, 565): -u*v/w**3, (359, 569):
        -u/w, (359, 618): u**3*v/w**2, (359, 620): -u**2*v/w, (359,
        623): -u*v/w**2, (359, 645): u**3/w**2, (359, 647): -u**2/w,
        (360, 180): v/w, (360, 187): v, (360, 325): v/w, (360, 352):
        v**2/w, (360, 356): 1, (360, 360): v/w, (360, 369): u*v/w,
        (360, 376): u*v, (360, 536): v/w, (360, 612): v**2/w, (360,
        619): v**2, (361, 159): -v, (361, 294): -v**2/w, (361, 360):
        1/w, (361, 531): -v/w**2, (361, 618): -u*v**2/w, (361, 645):
        -u*v/w, (362, 188): v, (362, 352): u*v**2/w**2, (362, 357): 1,
        (362, 362): v/w, (362, 369): u/w, (362, 377): u*v, (362, 537):
        v/w, (362, 620): v**2, (363, 352): u*v/w**2, (363, 362): 1/w,
        (364, 179): v/w, (364, 187): u*v/w, (364, 358): 1, (364, 364):
        v/w, (364, 368): u*v/w, (364, 376): u**2*v/w, (364, 536):
        u*v/w**2, (364, 611): v**2/w, (364, 619): u*v**2/w, (364,
        622): -u**2*v/w**2, (364, 645): -u*v/w, (365, 364): 1/w, (365,
        530): -v/w**2, (365, 536): u/w**2, (365, 538): -u*v/w**2,
        (365, 622): -u**2/w**2, (365, 645): -u**2*v/w**2, (366, 188):
        u*v/w, (366, 359): 1, (366, 366): v/w, (366, 368): u/w, (366,
        376): u**2/w, (366, 377): u**2*v/w, (366, 564): u/w**2, (366,
        620): u*v**2/w, (366, 623): u/w, (367, 188): u/w, (367, 366):
        1/w, (367, 377): u**2/w, (367, 620): u*v/w, (367, 645):
        -u**2/w**2, (368, 159): -u, (368, 294): -u*v/w, (368, 530):
        1/w, (368, 538): u/w, (368, 618): -u**2*v/w, (369, 531): 1/w,
        (370, 371): 1, (370, 372): -u/w, (370, 568): -u*v/w**2, (370,
        595): -u/w, (370, 622): -u*v**2/w**3, (371, 372): 1/w, (371,
        515): -v/w**2, (371, 622): u/w**2, (372, 164): v/w, (372,
        353): u*v/w, (372, 370): 1, (372, 372): v/w, (372, 596):
        v**2/w, (372, 622): u*v/w**2, (373, 645): 1/w, (374, 347):
        1/w, (374, 374): v/w, (375, 349): 1/w, (375, 375): v/w, (375,
        376): v/w, (376, 373): 1, (376, 645): -u/w, (377, 350): 1/w,
        (377, 377): v/w, (378, 540): 1/w, (379, 541): 1/w, (380, 542):
        1/w, (381, 543): 1/w, (382, 544): 1/w, (383, 82): -v, (383,
        190): -v**2/w, (383, 213): u*v, (383, 325): -v**3/w**2, (383,
        348): u*v**2/w, (383, 387): -u/w, (383, 388): 1, (383, 460):
        -v**2/w, (383, 509): -v/w, (383, 541): -v**2/w**2, (383, 563):
        -v**2/w**2, (383, 568): -u*v**2/w, (383, 591): u**2*v, (383,
        622): -u*v**3/w**2, (383, 645): 2*u**2*v**2/w, (384, 80): -v,
        (384, 217): -u*v/w**2, (384, 242): -v**2/w, (384, 350):
        -u*v**2/w, (384, 377): -v**2, (384, 379): -u**2*v/w**2, (384,
        389): -u/w, (384, 390): 1, (384, 404): -u*v**2/w, (384, 485):
        -u*v, (384, 511): -v/w, (384, 541): -u*v**2/w**3, (384, 558):
        -u/w**2, (384, 564): -v**2/w**2, (384, 565): -v**2/w**2, (384,
        622): -u*v**2/w**2, (385, 213): u**2*v/w, (385, 348):
        u**2*v**2/w**2, (385, 391): -u/w, (385, 392): 1, (385, 509):
        -u*v/w**2, (385, 536): -u/w, (385, 537): u*v/w, (385, 563):
        -u*v**2/w**3, (385, 568): u**2*v**2/w**2, (385, 591):
        u**3*v/w, (385, 595): u**2*v/w, (385, 622): -u**2*(u*v*w -
        v**3 - w**2)/w**3, (385, 645): 2*u**3*v**2/w**2, (386, 80):
        -u*v/w, (386, 213): u**2/w, (386, 215): -u, (386, 242):
        -u*v**2/w**2, (386, 348): u**2*v/w**2, (386, 350): -u*v*(u*v +
        w)/w**2, (386, 377): -u*v**2/w, (386, 393): -u/w, (386, 394):
        1, (386, 404): -u**2*v**2/w**2, (386, 485): -u**2*v/w, (386,
        510): -u*v/w**2, (386, 511): -u*v/w**2, (386, 538): -u/w,
        (386, 557): -u/w**2, (386, 564): -u*v**2/w**3, (386, 565):
        -u*v**2/w**3, (386, 569): -u*v/w, (386, 591): u**3/w, (386,
        593): -u**2, (386, 596): -u, (386, 623): u*(u*w - v**2)/w**2,
        (386, 645): 2*u**3*v/w**2, (386, 647): -2*u**2*v/w, (387,
        234): v/w, (387, 241): v, (387, 325): v**2/w, (387, 379):
        v**2/w, (387, 383): 1, (387, 387): v/w, (387, 396): u*v/w,
        (387, 403): u*v, (387, 460): v, (387, 563): v/w, (387, 639):
        v**2/w, (387, 646): v**2, (388, 213): -v, (388, 348): -v**2/w,
        (388, 387): 1/w, (388, 558): -v/w**2, (388, 591): -u*v, (388,
        645): -2*u*v**2/w, (389, 242): v, (389, 379): u*v**2/w**2,
        (389, 384): 1, (389, 389): v/w, (389, 396): u/w, (389, 404):
        u*v, (389, 564): v/w, (389, 647): v**2, (390, 379): u*v/w**2,
        (390, 389): 1/w, (391, 233): v/w, (391, 241): u*v/w, (391,
        385): 1, (391, 391): v/w, (391, 395): u*v/w, (391, 403):
        u**2*v/w, (391, 563): u*v/w**2, (391, 568): -u**2*v/w, (391,
        591): -u*v, (391, 622): -u**2*v**2/w**2, (391, 638): v**2/w,
        (391, 645): -u*v**2/w, (391, 646): u*v**2/w, (392, 391): 1/w,
        (392, 557): -v/w**2, (392, 563): u/w**2, (392, 565):
        -u*v/w**2, (392, 568): -u**2/w, (392, 591): -u**2*v/w, (392,
        622): -u**2*v/w**2, (392, 645): -u**2*v**2/w**2, (393, 242):
        u*v/w, (393, 386): 1, (393, 393): v/w, (393, 395): u/w, (393,
        403): u**2/w, (393, 404): u**2*v/w, (393, 510): u/w, (393,
        564): u*v/w**2, (393, 569): u, (393, 623): u*v/w, (393, 647):
        u*v**2/w, (394, 242): u/w, (394, 393): 1/w, (394, 404):
        u**2/w, (394, 591): -u**2/w, (394, 645): -u**2*v/w**2, (394,
        647): u*v/w, (395, 213): -u, (395, 348): -u*v/w, (395, 557):
        1/w, (395, 565): u/w, (395, 645): -u**2*v/w, (396, 558): 1/w,
        (397, 398): 1, (397, 399): -u/w, (397, 568): -u*v**2/w**2,
        (397, 595): -u*v/w, (397, 622): u*(u*v*w - v**3 - w**2)/w**3,
        (398, 399): 1/w, (398, 542): -v/w**2, (398, 568): u/w, (398,
        622): u*v/w**2, (399, 218): v/w, (399, 380): u*v/w, (399,
        397): 1, (399, 399): v/w, (399, 568): u*v/w, (399, 622):
        u*v**2/w**2, (399, 623): v**2/w, (400, 591): 1, (400, 645):
        v/w, (401, 347): v/w, (401, 401): v/w, (401, 482): 1, (402,
        349): v/w, (402, 402): v/w, (402, 403): v/w, (402, 484): 1,
        (403, 400): 1, (403, 591): -u, (403, 645): -u*v/w, (404, 350):
        v/w, (404, 404): v/w, (404, 485): 1, (405, 459): 1/w, (405,
        567): u/w, (406, 460): 1/w, (406, 568): u/w, (407, 461): 1/w,
        (407, 569): u/w, (408, 462): 1/w, (408, 570): u/w, (409, 463):
        1/w, (409, 571): u/w, (410, 24): u*v/w, (410, 105): u**2*v/w,
        (410, 267): -u**2*v**2/w, (410, 271): -v/w, (410, 294):
        u**2*v/w, (410, 321): u**2*v/w, (410, 325): u*v/w**2, (410,
        348): -u**3*v/w**2, (410, 414): -u/w, (410, 415): 1, (410,
        590): -v/w, (410, 595): -u*v/w, (410, 618): u**3*v/w, (410,
        622): u**2*v/w**2, (410, 645): -u**4*v/w**2, (411, 82):
        -u*v/w**2, (411, 134): -v/w, (411, 269): -u*v, (411, 323):
        u**2*v/w, (411, 406): -u**2*v/w**2, (411, 416): -u/w, (411,
        417): 1, (411, 458): -u*v/w, (411, 460): -u*v**2/w**3, (411,
        477): -u/w**2, (411, 483): -v**2/w**2, (411, 568):
        -u**2*v**2/w**3, (411, 585): -u**2/w**2, (411, 591):
        -u*v**2/w**2, (411, 592): -v/w, (411, 595): -u**2*v/w**2,
        (411, 622): u**3*v/w**3, (412, 24): u**2*v/w**2, (412, 105):
        u**3*v/w**2, (412, 136): -u**2*v/w**2, (412, 190): u**2/w**2,
        (412, 244): -u**3*v/w**2, (412, 267): -u**3*v**2/w**2, (412,
        271): -u**2*v**2/w**3, (412, 294): u**3*v/w**2, (412, 298):
        u**3/w**2, (412, 321): u**3*v/w**2, (412, 325): u**2*v/w**3,
        (412, 348): -u**4*v/w**3, (412, 374): u*v/w**2, (412, 375):
        -u*v**2/w**2, (412, 401): -u/w**2, (412, 402): u*v/w**2, (412,
        418): -u/w, (412, 419): 1, (412, 482): -u**2/w**2, (412, 483):
        u**2*v/w**2, (412, 568): u**3/w**2, (412, 590): -u**3/w**2,
        (412, 591): u*v*(u**2 - v)/w**2, (412, 595): -u**3*v**2/w**3,
        (412, 618): u**4*v/w**2, (412, 622): u**3*v/w**3, (412, 645):
        -u**5*v/w**3, (413, 24): u**2/w**2, (413, 26): -u/w, (413,
        105): u**3/w**2, (413, 107): -u**2/w, (413, 134): -u*v/w**2,
        (413, 267): -u**3*v/w**2, (413, 272): u*v/w**2, (413, 294):
        u**3/w**2, (413, 296): -u**2/w, (413, 321): u**3/w**2, (413,
        323): u**2*(u*v - w)/w**2, (413, 326): -u/w**2, (413, 348):
        -u**4/w**3, (413, 350): u**3/w**2, (413, 376): u*v/w**2, (413,
        403): -u/w**2, (413, 420): -u/w, (413, 421): 1, (413, 458):
        -u**2*v/w**2, (413, 476): -u/w**2, (413, 484): -u**2/w**2,
        (413, 584): -u**2/w**2, (413, 591): -u*v/w**2, (413, 592):
        -u**3/w**2, (413, 596): u**2*v/w**2, (413, 618): u**4/w**2,
        (413, 620): -u**3/w, (413, 623): -u**2/w**2, (413, 645):
        -u**5/w**3, (413, 647): u**4/w**2, (414, 99): v/w, (414, 106):
        v, (414, 244): v, (414, 298): -u*v/w, (414, 410): 1, (414,
        414): v/w, (414, 423): u*v/w, (414, 430): u*v, (414, 482):
        v/w, (414, 590): u*v/w, (414, 612): u*v/w, (414, 619): u*v,
        (414, 639): -u**2*v/w**2, (414, 646): -u**2*v/w, (415, 24):
        -v/w, (415, 105): -u*v/w, (415, 267): u*v**2/w, (415, 294):
        -u*v/w, (415, 321): -u*v/w, (415, 348): u**2*v/w**2, (415,
        414): 1/w, (415, 477): -v/w**2, (415, 585): -u*v/w**2, (415,
        618): -u**2*v/w, (415, 645): u**3*v/w**2, (416, 107): v, (416,
        406): u*v**2/w**2, (416, 411): 1, (416, 416): v/w, (416, 423):
        u/w, (416, 431): u*v, (416, 483): v/w, (416, 591): u*v/w,
        (416, 620): u*v, (416, 647): -u**2*v/w, (417, 406): u*v/w**2,
        (417, 416): 1/w, (418, 98): v/w, (418, 106): u*v/w, (418,
        244): u**2*v**2/w**2, (418, 267): u*v**2/w, (418, 298):
        -u**2*v/w**2, (418, 321): -u*v/w, (418, 412): 1, (418, 418):
        v/w, (418, 422): u*v/w, (418, 430): u**2*v/w, (418, 482):
        u*v/w**2, (418, 590): u**2*v/w**2, (418, 611): u*v/w, (418,
        619): u**2*v/w, (418, 638): -u**2*v/w**2, (418, 646):
        -u**3*v/w**2, (419, 244): u**2*v/w**2, (419, 267):
        u**2*v**2/w**2, (419, 298): -u**2/w**2, (419, 321):
        -u**2*v/w**2, (419, 418): 1/w, (419, 476): -v/w**2, (419,
        482): u/w**2, (419, 484): -u*v/w**2, (419, 584): -u*v/w**2,
        (419, 590): u**2/w**2, (419, 592): -u**2*v/w**2, (420, 107):
        u*v/w, (420, 245): -u*v/w, (420, 299): u/w, (420, 413): 1,
        (420, 420): v/w, (420, 422): u/w, (420, 430): u**2/w, (420,
        431): u**2*v/w, (420, 591): u/w, (420, 620): u**2*v/w, (420,
        647): -u**3*v/w**2, (421, 107): u/w, (421, 267): u**2*v/w**2,
        (421, 321): -u**2/w**2, (421, 420): 1/w, (421, 431): u**2/w,
        (421, 620): u**2/w, (421, 647): -u**3/w**2, (422, 24): -u/w,
        (422, 105): -u**2/w, (422, 294): -u**2/w, (422, 348):
        u**3/w**2, (422, 476): 1/w, (422, 484): u/w, (422, 584): u/w,
        (422, 592): u**2/w, (422, 618): -u**3/w, (422, 645):
        u**4/w**2, (423, 477): 1/w, (423, 585): u/w, (424, 136):
        u*v/w**2, (424, 190): -u/w**2, (424, 244): u**2*v/w**2, (424,
        271): u*v**2/w**3, (424, 298): -u**2/w**2, (424, 325):
        -u*v/w**3, (424, 425): 1, (424, 426): -u/w, (424, 568):
        -u**2/w**2, (424, 595): u**2*v**2/w**3, (424, 622):
        -u**2*v/w**3, (425, 244): -u*v/w**2, (425, 298): u/w**2, (425,
        426): 1/w, (425, 461): -v/w**2, (425, 569): -u*v/w**2, (426,
        83): v/w, (426, 244): -u*v**2/w**2, (426, 298): u*v/w**2,
        (426, 407): u*v/w, (426, 424): 1, (426, 426): v/w, (426, 596):
        u*v/w, (426, 623): -u**2*v/w**2, (427, 267): -v/w, (427, 321):
        1/w, (428, 266): 1, (428, 320): -u/w, (429, 268): 1, (429,
        322): -u/w, (429, 429): v/w, (430, 267): u*v/w, (430, 321):
        -u/w, (430, 427): 1, (431, 269): 1, (431, 323): -u/w, (432,
        486): 1/w, (433, 487): 1/w, (434, 488): 1/w, (435, 489): 1/w,
        (436, 490): 1/w, (437, 105): u*v, (437, 136): -v, (437, 190):
        u*v/w, (437, 271): -v**2/w, (437, 325): u*v**2/w**2, (437,
        441): -u/w, (437, 442): 1, (437, 483): u*v**2/w, (437, 487):
        -v**2/w**2, (437, 536): -v/w, (437, 563): u*v/w**2, (437,
        591): u**2*v**2/w, (437, 595): -u*v**2/w, (437, 618): u**2*v,
        (437, 622): u**2*v**2/w**2, (437, 645): -u**3*v/w, (438, 26):
        -v, (438, 109): -u*v/w**2, (438, 134): -v**2/w, (438, 296):
        -u*v, (438, 350): u**2*v/w, (438, 377): v**3/w, (438, 404):
        -v**2/w, (438, 433): -u**2*v/w**2, (438, 443): -u/w, (438,
        444): 1, (438, 458): -u*v**2/w, (438, 487): -u*v**2/w**3,
        (438, 504): -u/w**2, (438, 510): -v**2/w**2, (438, 538): -v/w,
        (438, 565): u*v/w**2, (438, 568): -u*v**2/w**2, (439, 105):
        u**2*v/w, (439, 445): -u/w, (439, 446): 1, (439, 483):
        u**2*v**2/w**2, (439, 537): -u*v**2/w**2, (439, 563): u*(u*v -
        w)/w**3, (439, 564): u*v/w**2, (439, 568): -u**2*(u*v -
        w)/w**2, (439, 591): u**3*v**2/w**2, (439, 618): u**3*v/w,
        (439, 622): -u**2*v*(u*v - w)/w**3, (439, 645): -u**4*v/w**2,
        (440, 26): -u*v/w, (440, 105): u**2/w, (440, 107): -u, (440,
        134): -u*v**2/w**2, (440, 296): -u**2*v/w, (440, 350):
        u**3*v/w**2, (440, 377): u*v**3/w**2, (440, 404):
        -u*v**2/w**2, (440, 447): -u/w, (440, 448): 1, (440, 458):
        -u**2*v**2/w**2, (440, 483): u**2*v/w**2, (440, 485): -u*v/w,
        (440, 503): -u/w**2, (440, 537): -u*v/w**2, (440, 564):
        u**2*v/w**3, (440, 565): u*(u*v - w)/w**3, (440, 569): u**2/w,
        (440, 591): u**3*v/w**2, (440, 593): -u**2*v/w, (440, 618):
        u**3/w, (440, 620): -u**2, (440, 623): u*(u*v - w)/w**2, (440,
        645): -u**4/w**2, (440, 647): u**3/w, (441, 126): v/w, (441,
        133): v, (441, 271): v, (441, 325): -u*v/w, (441, 433):
        v**2/w, (441, 437): 1, (441, 441): v/w, (441, 450): u*v/w,
        (441, 457): u*v, (441, 509): v/w, (441, 585): v**2/w, (441,
        592): v**2, (442, 105): -v, (442, 441): 1/w, (442, 483):
        -v**2/w, (442, 504): -v/w**2, (442, 591): -u*v**2/w, (442,
        618): -u*v, (442, 645): u**2*v/w, (443, 134): v, (443, 433):
        u*v**2/w**2, (443, 438): 1, (443, 443): v/w, (443, 450): u/w,
        (443, 458): u*v, (443, 510): v/w, (443, 593): v**2, (444,
        433): u*v/w**2, (444, 443): 1/w, (445, 125): v/w, (445, 133):
        u*v/w, (445, 439): 1, (445, 445): v/w, (445, 449): u*v/w,
        (445, 457): u**2*v/w, (445, 509): u*v/w**2, (445, 584):
        v**2/w, (445, 592): u*v**2/w, (445, 595): -u**2*v/w, (445,
        618): -u*v, (445, 622): u**3*v/w**2, (445, 645): u**2*v/w,
        (446, 445): 1/w, (446, 503): -v/w**2, (446, 509): u/w**2,
        (446, 511): -u*v/w**2, (446, 595): -u**2/w, (446, 618):
        -u**2*v/w, (446, 622): u**3/w**2, (446, 645): u**3*v/w**2,
        (447, 134): u*v/w, (447, 440): 1, (447, 447): v/w, (447, 449):
        u/w, (447, 457): u**2/w, (447, 458): u**2*v/w, (447, 537):
        u/w, (447, 564): -u**2/w**2, (447, 593): u*v**2/w, (447, 596):
        u, (447, 623): -u**2/w, (448, 134): u/w, (448, 447): 1/w,
        (448, 458): u**2/w, (448, 593): u*v/w, (448, 618): -u**2/w,
        (448, 645): u**3/w**2, (449, 105): -u, (449, 483): -u*v/w,
        (449, 503): 1/w, (449, 511): u/w, (449, 591): -u**2*v/w, (450,
        504): 1/w, (451, 452): 1, (451, 453): -u/w, (451, 568): u*(u*v
        - w)/w**2, (451, 622): u*v*(u*v - w)/w**3, (452, 453): 1/w,
        (452, 488): -v/w**2, (452, 595): u/w, (452, 622): -u**2/w**2,
        (453, 110): v/w, (453, 434): u*v/w, (453, 451): 1, (453, 453):
        v/w, (453, 569): v**2/w, (453, 595): u*v/w, (453, 622):
        -u**2*v/w**2, (454, 618): 1, (454, 645): -u/w, (455, 293): 1,
        (455, 347): -u/w, (455, 455): v/w, (456, 295): 1, (456, 349):
        -u/w, (456, 456): v/w, (456, 457): v/w, (457, 454): 1, (457,
        618): -u, (457, 645): u**2/w, (458, 296): 1, (458, 350): -u/w,
        (458, 458): v/w, (459, 81): 1, (459, 459): v/w, (459, 567):
        u*v/w, (460, 82): 1, (460, 460): v/w, (460, 568): u*v/w, (461,
        83): 1, (461, 461): v/w, (461, 569): u*v/w, (462, 84): 1,
        (462, 462): v/w, (462, 570): u*v/w, (463, 85): 1, (463, 463):
        v/w, (463, 571): u*v/w, (464, 131): -v/w, (464, 267): -u*v**2,
        (464, 294): u**2*v**2/w, (464, 321): u*v, (464, 348):
        -u**2*v/w, (464, 468): -u/w, (464, 469): 1, (464, 514):
        -u*v**2/w**2, (464, 541): u*v/w**2, (464, 590): -v**2/w, (464,
        595): -v, (464, 618): u**3*v**2/w, (464, 622): u*v/w, (464,
        645): -u**3*v/w, (465, 82): -u*v**2/w**2, (465, 99): -u/w,
        (465, 105): -v**2/w, (465, 133): -v/w, (465, 269): -v*w, (465,
        323): u*v, (465, 377): -u*v*(u*v - w)/w, (465, 406): -u*v/w,
        (465, 458): -u*v**2/w, (465, 460): -u*v**3/w**3, (465, 470):
        -u/w, (465, 471): 1, (465, 477): -u*v/w**2, (465, 483):
        -v**3/w**2, (465, 568): -u**2*v**3/w**3, (465, 585):
        -u**2*v/w**2, (465, 591): -u*v**3/w**2, (465, 592): -v**2/w,
        (465, 595): -u**2*v**2/w**2, (465, 622): u**2*v/w**2, (466,
        23): -u/w, (466, 24): u*v/w, (466, 104): -u**2/w, (466, 105):
        u**2*v/w, (466, 131): -u*v/w**2, (466, 163): -u**2*v/w**2,
        (466, 217): u**2/w**2, (466, 267): -u**2*v**2/w, (466, 294):
        u**3*v**2/w**2, (466, 321): u**2*v/w, (466, 348):
        -u**3*v/w**2, (466, 352): -u**3*v/w**2, (466, 374):
        u*v**2/w**2, (466, 375): -u*v**3/w**2, (466, 379): u**3/w**2,
        (466, 401): -u*v/w**2, (466, 402): u*v**2/w**2, (466, 472):
        -u/w, (466, 473): 1, (466, 482): -u**2*v/w**2, (466, 483):
        u**2*v**2/w**2, (466, 514): -u**2*v**2/w**3, (466, 541):
        u**2*v/w**3, (466, 590): -u**3*v/w**2, (466, 591):
        u*v**2*(u**2 - v)/w**2, (466, 595): -u**2*v**2/w**2, (466,
        618): u**4*v**2/w**2, (466, 622): u**3*v**2/w**3, (466, 645):
        -u**4*v/w**2, (467, 25): -u/w, (467, 98): -u/w, (467, 106):
        -u**2/w, (467, 132): -u*v/w**2, (467, 133): -u*v/w**2, (467,
        267): -u**2*v/w, (467, 294): u**3*v/w**2, (467, 296):
        -u**2*v/w, (467, 321): u**2/w, (467, 323): u*(u*v - w)/w,
        (467, 348): -u**3/w**2, (467, 350): u**2/w, (467, 376):
        u*v**2/w**2, (467, 377): -u**2*v*(u*v - w)/w**2, (467, 403):
        -u*v/w**2, (467, 458): -u**2*v**2/w**2, (467, 474): -u/w,
        (467, 475): 1, (467, 476): -u*v/w**2, (467, 484):
        -u**2*v/w**2, (467, 515): u*v/w**2, (467, 542): -u/w**2, (467,
        584): -u**2*v/w**2, (467, 591): -u*v**2/w**2, (467, 592):
        -u**3*v/w**2, (467, 596): u*v/w, (467, 618): u**4*v/w**2,
        (467, 620): -u**3*v/w, (467, 623): -u**2*v/w**2, (467, 645):
        -u**4/w**2, (467, 647): u**3/w, (468, 104): v, (468, 352):
        u*v**2/w, (468, 379): -u*v/w, (468, 423): v, (468, 430): v*w,
        (468, 464): 1, (468, 468): v/w, (468, 482): v**2/w, (468,
        568): v, (468, 590): u*v**2/w, (468, 612): u*v**2/w, (468,
        619): u*v**2, (468, 639): -u*v/w, (468, 646): -u*v, (469, 99):
        -v/w, (469, 267): v**2, (469, 294): -u*v**2/w, (469, 321): -v,
        (469, 348): u*v/w, (469, 468): 1/w, (469, 477): -v**2/w**2,
        (469, 585): -u*v**2/w**2, (469, 618): -u**2*v**2/w, (469,
        645): u**2*v/w, (470, 105): v, (470, 431): v*w, (470, 460):
        u*v**2/w**2, (470, 465): 1, (470, 470): v/w, (470, 477): u/w,
        (470, 483): v**2/w, (470, 591): u*v**2/w, (470, 620): u*v**2,
        (470, 647): -u*v, (471, 460): u*v/w**2, (471, 470): 1/w, (472,
        104): u*v/w, (472, 352): u**2*v**2/w**2, (472, 375): u*v**2/w,
        (472, 379): -u**2*v/w**2, (472, 402): -u*v/w, (472, 422): v,
        (472, 430): u*v, (472, 466): 1, (472, 472): v/w, (472, 482):
        u*v**2/w**2, (472, 568): u**2*v**2/w**2, (472, 590):
        u**2*v**2/w**2, (472, 591): u*v**2/w, (472, 611): u*v**2/w,
        (472, 619): u**2*v**2/w, (472, 638): -u*v/w, (472, 646):
        -u**2*v/w, (473, 98): -v/w, (473, 104): u/w, (473, 106):
        -u*v/w, (473, 352): u**2*v/w**2, (473, 375): u**2*v**2/w**2,
        (473, 379): -u**2/w**2, (473, 402): -u**2*v/w**2, (473, 472):
        1/w, (473, 476): -v**2/w**2, (473, 482): u*v/w**2, (473, 484):
        -u*v**2/w**2, (473, 568): u**2*v/w**2, (473, 584):
        -u*v**2/w**2, (473, 590): u**2*v/w**2, (473, 591):
        u**2*v**2/w**2, (473, 592): -u**2*v**2/w**2, (474, 132): u/w,
        (474, 353): -u*v/w, (474, 380): u/w, (474, 431): u*v, (474,
        467): 1, (474, 474): v/w, (474, 476): u/w, (474, 484): u**2/w,
        (474, 569): -u*v/w, (474, 591): u*v/w, (474, 620):
        u**2*v**2/w, (474, 647): -u**2*v/w, (475, 375): u**2*v/w**2,
        (475, 402): -u**2/w**2, (475, 431): u, (475, 474): 1/w, (475,
        591): u**2*v/w**2, (475, 620): u**2*v/w, (475, 647): -u**2/w,
        (476, 98): 1, (476, 106): u, (476, 267): u*v, (476, 294):
        -u**2*v/w, (476, 321): -u, (476, 348): u**2/w, (476, 375):
        -u**2*v/w, (476, 402): u**2/w, (476, 476): v/w, (476, 484):
        u*v/w, (476, 584): u*v/w, (476, 591): -u**2*v/w, (476, 592):
        u**2*v/w, (476, 618): -u**3*v/w, (476, 645): u**3/w, (477,
        99): 1, (477, 477): v/w, (477, 585): u*v/w, (478, 163):
        u*v/w**2, (478, 217): -u/w**2, (478, 352): u**2*v/w**2, (478,
        379): -u**2/w**2, (478, 479): 1, (478, 480): -u/w, (478, 514):
        u*v**2/w**3, (478, 541): -u*v/w**3, (478, 595): u*v**2/w**2,
        (478, 622): -u**2*v**2/w**3, (479, 83): -v/w, (479, 352):
        -u*v/w**2, (479, 379): u/w**2, (479, 461): -v**2/w**2, (479,
        480): 1/w, (479, 568): -u*v/w**2, (479, 569): -u*v**2/w**2,
        (480, 352): -u*v**2/w**2, (480, 379): u*v/w**2, (480, 407): v,
        (480, 478): 1, (480, 480): v/w, (480, 568): -u*v**2/w**2,
        (480, 596): u*v**2/w, (480, 623): -u*v/w, (481, 375): -v/w,
        (481, 402): 1/w, (481, 591): -v/w, (482, 374): u*v/w, (482,
        401): -u/w, (482, 590): 1, (483, 376): u*v/w, (483, 403):
        -u/w, (483, 483): v/w, (483, 592): 1, (484, 375): u*v/w, (484,
        402): -u/w, (484, 481): 1, (484, 591): u*v/w, (485, 377):
        u*v/w, (485, 404): -u/w, (485, 593): 1, (486, 108): 1, (486,
        486): v/w, (486, 567): v, (487, 109): 1, (487, 487): v/w,
        (487, 568): v, (488, 110): 1, (488, 488): v/w, (488, 569): v,
        (489, 111): 1, (489, 489): v/w, (489, 570): v, (490, 112): 1,
        (490, 490): v/w, (490, 571): v, (491, 23): -v, (491, 131):
        -v**2/w, (491, 163): -v, (491, 217): u*v/w, (491, 374):
        v**3/w, (491, 401): -v**2/w, (491, 495): -u/w, (491, 496): 1,
        (491, 514): -v**2/w, (491, 536): -v**2/w, (491, 541):
        u*v**2/w**2, (491, 563): u*v**2/w**2, (491, 595): -v**2, (491,
        618): u*v*w, (491, 622): u*v**2/w, (491, 645): -u**2*v, (492,
        25): -v, (492, 109): -u*v**2/w**2, (492, 126): -u/w, (492,
        132): -v**2/w, (492, 133): -v**2/w, (492, 296): -v*w, (492,
        350): u*v, (492, 376): v**3/w, (492, 403): -v**2/w, (492,
        433): -u*v/w, (492, 458): -v**2, (492, 487): -u*v**3/w**3,
        (492, 497): -u/w, (492, 498): 1, (492, 504): -u*v/w**2, (492,
        510): -v**3/w**2, (492, 538): -v**2/w, (492, 565):
        u*v**2/w**2, (492, 568): -u*v**3/w**2, (492, 585): -u*v/w,
        (492, 591): -v**3/w, (493, 23): -u*v/w, (493, 104): -u, (493,
        105): u*v, (493, 131): -u*v**2/w**2, (493, 163):
        -u**2*v**2/w**2, (493, 217): u**2*v/w**2, (493, 352):
        -u**2*v/w, (493, 374): u*v**3/w**2, (493, 379): u**2/w, (493,
        401): -u*v**2/w**2, (493, 482): -u*v/w, (493, 483): u*v**2/w,
        (493, 499): -u/w, (493, 500): 1, (493, 514): -u**2*v**3/w**3,
        (493, 537): -u*v**3/w**2, (493, 541): u**2*v**2/w**3, (493,
        563): u*v*(u*v - w)/w**3, (493, 564): u*v**2/w**2, (493, 590):
        -u**2*v/w, (493, 591): u**2*v**2/w, (493, 595):
        -u**2*v**3/w**2, (493, 618): u**2*v, (493, 622):
        u**2*v**2/w**2, (493, 645): -u**3*v/w, (494, 24): -u*v/w,
        (494, 25): -u*v/w, (494, 106): -u, (494, 125): -u/w, (494,
        132): -u*v**2/w**2, (494, 133): -u*v**2/w**2, (494, 164):
        u*v/w, (494, 218): -u/w, (494, 296): -u*v, (494, 350):
        u**2*v/w, (494, 375): u*v**3/w**2, (494, 376): u*v**3/w**2,
        (494, 402): -u*v**2/w**2, (494, 403): -u*v**2/w**2, (494,
        458): -u*v**2/w, (494, 484): -u*v/w, (494, 501): -u/w, (494,
        502): 1, (494, 503): -u*v/w**2, (494, 515): u*v**2/w**2, (494,
        537): -u*v**2/w**2, (494, 542): -u*v/w**2, (494, 564):
        u**2*v**2/w**3, (494, 565): u*v*(u*v - w)/w**3, (494, 584):
        -u*v/w, (494, 592): -u**2*v/w, (494, 596): u*v**2/w, (494,
        618): u**2, (494, 620): -u*w, (494, 623): -u*v/w, (494, 645):
        -u**3/w, (494, 647): u**2, (495, 131): v, (495, 450): v, (495,
        457): v*w, (495, 491): 1, (495, 495): v/w, (495, 509): v**2/w,
        (495, 514): v, (495, 541): -u*v/w, (495, 590): v**2, (496,
        126): -v/w, (496, 495): 1/w, (496, 504): -v**2/w**2, (496,
        585): -v**2/w, (496, 618): -v*w, (496, 645): u*v, (497, 132):
        v, (497, 458): v*w, (497, 487): u*v**2/w**2, (497, 492): 1,
        (497, 497): v/w, (497, 504): u/w, (497, 510): v**2/w, (497,
        591): v**2, (498, 487): u*v/w**2, (498, 497): 1/w, (499, 131):
        u*v/w, (499, 449): v, (499, 457): u*v, (499, 493): 1, (499,
        499): v/w, (499, 509): u*v**2/w**2, (499, 514):
        u**2*v**2/w**2, (499, 537): u*v**2/w, (499, 541):
        -u**2*v/w**2, (499, 564): -u*v/w, (499, 590): u*v**2/w, (500,
        125): -v/w, (500, 131): u/w, (500, 133): -u*v/w, (500, 499):
        1/w, (500, 503): -v**2/w**2, (500, 509): u*v/w**2, (500, 511):
        -u*v**2/w**2, (500, 514): u**2*v/w**2, (500, 537):
        u**2*v**2/w**2, (500, 541): -u**2/w**2, (500, 564):
        -u**2*v/w**2, (500, 584): -v**2/w, (500, 590): u*v/w, (500,
        592): -u*v**2/w, (501, 24): u, (501, 132): u*v/w, (501, 375):
        -u*v**2/w, (501, 402): u*v/w, (501, 458): u*v, (501, 494): 1,
        (501, 501): v/w, (501, 503): u/w, (501, 511): u**2/w, (501,
        515): -u*v/w, (501, 537): u*v/w, (501, 542): u/w, (501, 564):
        -u**2*v/w**2, (502, 458): u, (502, 501): 1/w, (502, 537):
        u**2*v/w**2, (502, 564): -u**2/w**2, (503, 125): 1, (503,
        133): u, (503, 503): v/w, (503, 511): u*v/w, (503, 537):
        -u**2*v/w, (503, 564): u**2/w, (503, 584): v, (503, 592): u*v,
        (503, 618): -u*w, (503, 645): u**2, (504, 126): 1, (504, 504):
        v/w, (504, 585): v, (505, 163): u*v**2/w**2, (505, 217):
        -u*v/w**2, (505, 352): u*v/w, (505, 379): -u/w, (505, 506): 1,
        (505, 507): -u/w, (505, 514): u*v**3/w**3, (505, 541):
        -u*v**2/w**3, (505, 595): u*v**3/w**2, (505, 622):
        -u*v**2/w**2, (506, 110): -v/w, (506, 488): -v**2/w**2, (506,
        507): 1/w, (506, 514): -u*v/w**2, (506, 541): u/w**2, (506,
        569): -v**2/w, (507, 434): v, (507, 505): 1, (507, 507): v/w,
        (507, 514): -u*v**2/w**2, (507, 541): u*v/w**2, (508, 537):
        -v/w, (508, 564): 1/w, (509, 536): 1, (509, 563): -u/w, (510,
        510): v/w, (510, 538): 1, (510, 565): -u/w, (511, 508): 1,
        (511, 537): u*v/w, (511, 564): -u/w, (512, 539): 1, (512,
        566): -u/w, (513, 162): 1, (513, 513): v/w, (513, 594): v,
        (514, 163): 1, (514, 514): v/w, (514, 595): v, (515, 164): 1,
        (515, 515): v/w, (515, 596): v, (516, 165): 1, (516, 516):
        v/w, (516, 597): v, (517, 166): 1, (517, 517): v/w, (517,
        598): v, (518, 50): -v, (518, 185): -v**2/w, (518, 217): -v/w,
        (518, 374): -u*v**2/w, (518, 455): -v**2/w, (518, 522): -u/w,
        (518, 523): 1, (518, 541): -v**2/w**2, (518, 563): -v**2/w**2,
        (518, 622): -v**2/w, (518, 645): u*v, (519, 52): -v, (519,
        163): -u*v**2/w**2, (519, 180): -u/w, (519, 186): -v**2/w,
        (519, 187): -v**2/w, (519, 350): -v, (519, 352): -u*v/w, (519,
        376): -u*v**2/w, (519, 377): -v**2, (519, 457): -v**2/w, (519,
        514): -u*v**3/w**3, (519, 524): -u/w, (519, 525): 1, (519,
        531): -u*v/w**2, (519, 537): -v**3/w**2, (519, 565):
        -v**2/w**2, (519, 595): -u*v**3/w**2, (519, 612): -u*v/w,
        (519, 618): -v**3/w, (520, 50): -u*v/w, (520, 109):
        u**2*v/w**2, (520, 158): -u, (520, 159): u*v, (520, 163):
        u**3*v/w**2, (520, 185): -u*v**2/w**2, (520, 293): -u*v/w,
        (520, 294): u*v**2/w, (520, 352): u**3/w, (520, 374):
        -u**2*v**2/w**2, (520, 433): u**2/w, (520, 455): -u*v**2/w**2,
        (520, 487): u**2*v**2/w**3, (520, 509): -u*v/w**2, (520, 510):
        u*v**2/w**2, (520, 514): u**3*v**2/w**3, (520, 526): -u/w,
        (520, 527): 1, (520, 536): -u**2*v/w**2, (520, 537):
        u**2*v**2/w**2, (520, 563): -u*v**2/w**3, (520, 568):
        u**2*v**2/w**2, (520, 595): u**3*v**2/w**2, (520, 617):
        -u**2*v/w, (520, 618): u**2*v**2/w, (520, 645): u**2*v/w,
        (521, 51): -u*v/w, (521, 52): -u*v/w, (521, 110): -u/w, (521,
        160): -u, (521, 164): -u**2/w, (521, 179): -u/w, (521, 186):
        -u*v**2/w**2, (521, 187): -u*v**2/w**2, (521, 295): -u*v/w,
        (521, 350): -u*v/w, (521, 375): -u**2*v**2/w**2, (521, 376):
        -u**2*v**2/w**2, (521, 377): -u*v**2/w, (521, 456):
        -u*v**2/w**2, (521, 457): -u*v**2/w**2, (521, 488): -u*v/w**2,
        (521, 511): -u*v/w**2, (521, 515): -u**2*v/w**2, (521, 528):
        -u/w, (521, 529): 1, (521, 530): -u*v/w**2, (521, 538):
        -u**2*v/w**2, (521, 564): -u*v**2/w**3, (521, 565):
        -u*v**2/w**3, (521, 569): -u*v/w, (521, 596): -u**2*v/w, (521,
        611): -u*v/w, (521, 619): -u**2*v/w, (521, 645): u**2/w, (521,
        647): -u, (522, 185): v, (522, 369): v, (522, 376): v*w, (522,
        518): 1, (522, 522): v/w, (522, 536): v**2/w, (522, 541): v/w,
        (522, 617): v**2, (523, 180): -v/w, (523, 522): 1/w, (523,
        531): -v**2/w**2, (523, 612): -v**2/w, (523, 645): -v, (524,
        186): v, (524, 377): v*w, (524, 514): u*v**2/w**2, (524, 519):
        1, (524, 524): v/w, (524, 531): u/w, (524, 537): v**2/w, (524,
        618): v**2, (525, 514): u*v/w**2, (525, 524): 1/w, (526, 185):
        u*v/w, (526, 368): v, (526, 376): u*v, (526, 487):
        -u**2*v/w**2, (526, 510): -u*v/w, (526, 514): -u**3*v/w**2,
        (526, 520): 1, (526, 526): v/w, (526, 536): u*v**2/w**2, (526,
        537): -u**2*v/w, (526, 617): u*v**2/w, (527, 179): -v/w, (527,
        185): u/w, (527, 187): -u*v/w, (527, 487): -u**2/w**2, (527,
        510): -u**2*v/w**2, (527, 514): -u**3/w**2, (527, 526): 1/w,
        (527, 530): -v**2/w**2, (527, 536): u*v/w**2, (527, 537):
        -u**3*v/w**2, (527, 538): -u*v**2/w**2, (527, 611): -v**2/w,
        (527, 617): u*v/w, (527, 619): -u*v**2/w, (528, 51): u, (528,
        186): u*v/w, (528, 375): u**2*v/w, (528, 377): u*v, (528,
        456): u*v/w, (528, 488): u/w, (528, 515): u**2/w, (528, 521):
        1, (528, 528): v/w, (528, 530): u/w, (528, 538): u**2/w, (528,
        564): u*v/w**2, (529, 377): u, (529, 510): -u**2/w**2, (529,
        528): 1/w, (529, 537): -u**3/w**2, (530, 179): 1, (530, 187):
        u, (530, 510): u**2/w, (530, 530): v/w, (530, 537): u**3/w,
        (530, 538): u*v/w, (530, 611): v, (530, 619): u*v, (530, 645):
        -u, (531, 180): 1, (531, 531): v/w, (531, 612): v, (532, 109):
        -u*v/w**2, (532, 163): -u**2*v/w**2, (532, 352): -u**2/w,
        (532, 433): -u/w, (532, 487): -u*v**2/w**3, (532, 514):
        -u**2*v**2/w**3, (532, 533): 1, (532, 534): -u/w, (532, 568):
        -u*v**2/w**2, (532, 595): -u**2*v**2/w**2, (533, 164): -v/w,
        (533, 487): u/w**2, (533, 514): u**2/w**2, (533, 515):
        -v**2/w**2, (533, 534): 1/w, (533, 596): -v**2/w, (534, 353):
        v, (534, 487): u*v/w**2, (534, 514): u**2*v/w**2, (534, 532):
        1, (534, 534): v/w, (535, 510): 1/w, (535, 537): u/w, (536,
        563): 1/w, (537, 537): v/w, (537, 565): 1/w, (538, 510): -u/w,
        (538, 535): 1, (538, 537): -u**2/w, (539, 566): 1/w, (540,
        216): 1, (540, 540): v/w, (540, 621): v, (541, 217): 1, (541,
        541): v/w, (541, 622): v, (542, 218): 1, (542, 542): v/w,
        (542, 623): v, (543, 219): 1, (543, 543): v/w, (543, 624): v,
        (544, 220): 1, (544, 544): v/w, (544, 625): v, (545, 77): -v,
        (545, 109): -v, (545, 217): -v**2/w, (545, 239): -v**2/w,
        (545, 374): -v**2, (545, 487): -v**2/w, (545, 509): -v**2/w,
        (545, 541): -v**3/w**2, (545, 549): -u/w, (545, 550): 1, (545,
        563): -v**3/w**2, (545, 568): -v**2, (545, 591): u*v*w, (545,
        622): -v**3/w, (545, 645): u*v**2, (546, 79): -v, (546, 217):
        -u*v**2/w**2, (546, 234): -u/w, (546, 240): -v**2/w, (546,
        241): -v**2/w, (546, 350): -v**2, (546, 376): -v**2, (546,
        379): -u*v/w, (546, 404): -v**2, (546, 485): -v*w, (546, 511):
        -v**2/w, (546, 541): -u*v**3/w**3, (546, 551): -u/w, (546,
        552): 1, (546, 558): -u*v/w**2, (546, 564): -v**3/w**2, (546,
        565): -v**3/w**2, (546, 622): -u*v**3/w**2, (546, 639):
        -u*v/w, (546, 645): -v**3/w, (547, 77): -u*v/w, (547, 163):
        u**2*v/w, (547, 212): -u, (547, 213): u*v, (547, 239):
        -u*v**2/w**2, (547, 347): -u*v/w, (547, 348): u*v**2/w, (547,
        352): u**2, (547, 374): -u*v**2/w, (547, 509): -u*v**2/w**2,
        (547, 514): u**2*v**2/w**2, (547, 536): -u*v/w, (547, 537):
        u*v**2/w, (547, 553): -u/w, (547, 554): 1, (547, 563):
        -u*v**3/w**3, (547, 591): u**2*v, (547, 595): u**2*v**2/w,
        (547, 644): -u**2*v/w, (547, 645): 2*u**2*v**2/w, (548, 78):
        -u*v/w, (548, 79): -u*v/w, (548, 164): -u, (548, 214): -u,
        (548, 233): -u/w, (548, 240): -u*v**2/w**2, (548, 241):
        -u*v**2/w**2, (548, 349): -u*v/w, (548, 350): -u*v**2/w, (548,
        375): -u*v**2/w, (548, 376): -u*v**2/w, (548, 404): -u*v**2/w,
        (548, 485): -u*v, (548, 510): -u*v**2/w**2, (548, 511):
        -u*v**2/w**2, (548, 515): -u*v/w, (548, 538): -u*v/w, (548,
        555): -u/w, (548, 556): 1, (548, 557): -u*v/w**2, (548, 564):
        -u*v**3/w**3, (548, 565): -u*v**3/w**3, (548, 591): u**2,
        (548, 593): -u*w, (548, 596): -u*v, (548, 638): -u*v/w, (548,
        645): u**2*v/w, (548, 646): -u**2*v/w, (548, 647): -u*v, (549,
        239): v, (549, 396): v, (549, 403): v*w, (549, 487): v, (549,
        541): v**2/w, (549, 545): 1, (549, 549): v/w, (549, 563):
        v**2/w, (549, 644): v**2, (550, 234): -v/w, (550, 549): 1/w,
        (550, 558): -v**2/w**2, (550, 591): -v*w, (550, 639): -v**2/w,
        (550, 645): -v**2, (551, 240): v, (551, 404): v*w, (551, 541):
        u*v**2/w**2, (551, 546): 1, (551, 551): v/w, (551, 558): u/w,
        (551, 564): v**2/w, (551, 645): v**2, (552, 541): u*v/w**2,
        (552, 551): 1/w, (553, 239): u*v/w, (553, 395): v, (553, 403):
        u*v, (553, 514): -u**2*v/w, (553, 537): -u*v, (553, 547): 1,
        (553, 553): v/w, (553, 563): u*v**2/w**2, (553, 644):
        u*v**2/w, (554, 233): -v/w, (554, 239): u/w, (554, 241):
        -u*v/w, (554, 514): -u**2/w, (554, 537): -u**2*v/w, (554,
        553): 1/w, (554, 557): -v**2/w**2, (554, 563): u*v/w**2, (554,
        565): -u*v**2/w**2, (554, 638): -v**2/w, (554, 644): u*v/w,
        (554, 646): -u*v**2/w, (555, 78): u, (555, 240): u*v/w, (555,
        375): u*v, (555, 404): u*v, (555, 510): u*v/w, (555, 515): u,
        (555, 548): 1, (555, 555): v/w, (555, 557): u/w, (555, 564):
        u*v**2/w**2, (555, 565): u**2/w, (556, 404): u, (556, 537):
        -u**2/w, (556, 555): 1/w, (557, 233): 1, (557, 241): u, (557,
        537): u**2, (557, 557): v/w, (557, 565): u*v/w, (557, 591):
        -u*w, (557, 638): v, (557, 645): -u*v, (557, 646): u*v, (558,
        234): 1, (558, 558): v/w, (558, 639): v, (559, 163): -u*v/w,
        (559, 352): -u, (559, 514): -u*v**2/w**2, (559, 560): 1, (559,
        561): -u/w, (559, 595): -u*v**2/w, (560, 218): -v/w, (560,
        514): u/w, (560, 542): -v**2/w**2, (560, 561): 1/w, (560,
        623): -v**2/w, (561, 380): v, (561, 514): u*v/w, (561, 559):
        1, (561, 561): v/w, (562, 537): 1, (563, 509): 1, (563, 563):
        v/w, (564, 511): 1, (564, 564): v/w, (564, 565): v/w, (565,
        537): -u, (565, 562): 1, (566, 512): 1, (566, 566): v/w, (567,
        594): 1, (567, 621): -u/w, (568, 595): 1, (568, 622): -u/w,
        (569, 596): 1, (569, 623): -u/w, (570, 597): 1, (570, 624):
        -u/w, (571, 598): 1, (571, 625): -u/w, (572, 294): -u*v**2/w,
        (572, 348): u*v/w, (572, 455): -v/w, (572, 514): v**2/w**2,
        (572, 541): -v/w**2, (572, 576): -u/w, (572, 577): 1, (572,
        618): -u**2*v**2/w, (572, 645): u**2*v/w, (573, 377): v*(u*v -
        w)/w, (573, 457): -v/w, (573, 458): v**2/w, (573, 578): -u/w,
        (573, 579): 1, (573, 612): -u/w, (573, 618): -v**2/w, (573,
        622): u*v*(u*v - w)/w**3, (573, 639): u**2/w**2, (573, 645):
        u*v**2/w**2, (574, 82): u**2*v/w**2, (574, 293): -u/w, (574,
        294): -u*v*(u*v - w)/w**2, (574, 347): u**2/w**2, (574, 406):
        u**2/w, (574, 455): -u*v/w**2, (574, 460): u**2*v**2/w**3,
        (574, 568): u**3*v**2/w**3, (574, 580): -u/w, (574, 581): 1,
        (574, 595): u**3*v/w**2, (574, 617): -u**2/w, (574, 618):
        -u**2*v*(u*v - w)/w**2, (574, 622): -u**4*v/w**3, (574, 644):
        u**3/w**2, (575, 83): -u/w, (575, 294): -u**2*v/w**2, (575,
        295): -u/w, (575, 296): u*v/w, (575, 348): u**2/w**2, (575,
        349): u**2/w**2, (575, 350): -u/w, (575, 377): u*v*(u*v -
        w)/w**2, (575, 456): -u*v/w**2, (575, 457): -u*v/w**2, (575,
        458): u*v**2/w**2, (575, 461): -u*v/w**2, (575, 569):
        -u**2*v/w**2, (575, 582): -u/w, (575, 583): 1, (575, 596):
        -u**2/w, (575, 611): -u/w, (575, 618): -u**3*v/w**2, (575,
        619): -u**2/w, (575, 620): u**2*v/w, (575, 623): u**3/w**2,
        (575, 638): u**2/w**2, (575, 645): u**3/w**2, (575, 646):
        u**3/w**2, (575, 647): -u**2/w, (576, 352): -v**2/w, (576,
        379): v/w, (576, 572): 1, (576, 576): v/w, (576, 612):
        -v**2/w, (576, 617): v, (576, 619): -v**2, (576, 639): v/w,
        (576, 644): -u*v/w, (576, 646): v, (577, 294): v**2/w, (577,
        348): -v/w, (577, 576): 1/w, (577, 612): -v/w, (577, 618):
        u*v**2/w, (577, 639): u*v/w**2, (577, 645): -u*v/w, (578,
        568): u*v**2/w**2, (578, 573): 1, (578, 578): v/w, (578, 585):
        u/w, (578, 618): v, (578, 620): -v**2, (578, 645): -u*v/w,
        (578, 647): v, (579, 568): u*v/w**2, (579, 578): 1/w, (580,
        460): -u**2*v/w**2, (580, 483): -u*v/w, (580, 568):
        -u**3*v/w**2, (580, 574): 1, (580, 580): v/w, (580, 591):
        -u**2*v/w, (580, 611): -v**2/w, (580, 617): u*v/w, (580, 619):
        -u*v**2/w, (580, 638): v/w, (580, 644): -u**2*v/w**2, (580,
        646): u*v/w, (581, 460): -u**2/w**2, (581, 483): -u**2*v/w**2,
        (581, 568): -u**3/w**2, (581, 580): 1/w, (581, 591):
        -u**3*v/w**2, (581, 611): -v/w, (581, 617): u/w, (581, 619):
        -u*v/w, (581, 638): u*v/w**2, (581, 644): -u**2/w**2, (581,
        646): u**2*v/w**2, (582, 456): u/w, (582, 461): u/w, (582,
        569): u**2/w, (582, 575): 1, (582, 582): v/w, (582, 584): u/w,
        (582, 592): u**2/w, (582, 620): -u*v**2/w, (582, 647): u*v/w,
        (583, 483): -u**2/w**2, (583, 582): 1/w, (583, 591):
        -u**3/w**2, (583, 620): -u*v/w, (583, 647): u/w, (584, 294):
        u*v/w, (584, 348): -u/w, (584, 483): u**2/w, (584, 591):
        u**3/w, (584, 611): 1, (584, 618): u**2*v/w, (584, 619): u,
        (584, 638): -u/w, (584, 645): -u**2/w, (584, 646): -u**2/w,
        (585, 612): 1, (585, 639): -u/w, (586, 82): -u*v/w**2, (586,
        406): -u/w, (586, 460): -u*v**2/w**3, (586, 568):
        -u**2*v**2/w**3, (586, 587): 1, (586, 588): -u/w, (586, 595):
        -u**2*v/w**2, (586, 622): u**3*v/w**3, (587, 460): u/w**2,
        (587, 568): u**2/w**2, (587, 588): 1/w, (587, 596): -v/w,
        (587, 623): u*v/w**2, (588, 460): u*v/w**2, (588, 568):
        u**2*v/w**2, (588, 586): 1, (588, 588): v/w, (588, 596):
        -v**2/w, (588, 623): v/w, (589, 483): 1/w, (589, 591): u/w,
        (590, 374): -v/w, (590, 401): 1/w, (591, 376): -v/w, (591,
        403): 1/w, (591, 591): v/w, (592, 483): -u/w, (592, 589): 1,
        (592, 591): -u**2/w, (593, 377): -v/w, (593, 404): 1/w, (594,
        621): 1/w, (595, 622): 1/w, (596, 623): 1/w, (597, 624): 1/w,
        (598, 625): 1/w, (599, 294): u**2*v/w, (599, 374): -v/w, (599,
        483): u*v/w, (599, 487): -v/w**2, (599, 514): -u*v/w**2, (599,
        591): u**2*v/w, (599, 603): -u/w, (599, 604): 1, (599, 618):
        u**3*v/w, (600, 376): -v/w, (600, 377): -v*(u**2 - v)/w, (600,
        404): -v/w, (600, 458): -u*v/w, (600, 568): -u*v/w**2, (600,
        595): -u**2*v/w**2, (600, 605): -u/w, (600, 606): 1, (600,
        622): -u*v**2/w**3, (600, 639): -u/w**2, (600, 645):
        -v**2/w**2, (601, 136): u**2*v/w**2, (601, 244): u**2/w, (601,
        271): u**2*v**2/w**3, (601, 294): u**3*v/w**2, (601, 347):
        -u/w**2, (601, 348): u*v/w**2, (601, 374): -u*v/w**2, (601,
        483): u**2*v/w**2, (601, 591): u**3*v/w**2, (601, 595):
        u**3*v**2/w**3, (601, 607): -u/w, (601, 608): 1, (601, 618):
        u**4*v/w**2, (601, 622): u**3*v/w**3, (601, 644): -u**2/w**2,
        (601, 645): u**2*v/w**2, (602, 137): -u/w, (602, 272):
        -u*v/w**2, (602, 294): u**3/w**2, (602, 296): -u**2/w, (602,
        349): -u/w**2, (602, 375): -u*v/w**2, (602, 376): -u*v/w**2,
        (602, 377): -u*v*(u**2 - v)/w**2, (602, 404): -u*v/w**2, (602,
        458): -u**2*v/w**2, (602, 483): u**2/w**2, (602, 485): -u/w,
        (602, 591): u**3/w**2, (602, 593): -u**2/w, (602, 596):
        -u**2*v/w**2, (602, 609): -u/w, (602, 610): 1, (602, 618):
        u**4/w**2, (602, 620): -u**3/w, (602, 623): -u**2/w**2, (602,
        638): -u/w**2, (602, 646): -u**2/w**2, (603, 352): u*v/w,
        (603, 433): v/w, (603, 585): v/w, (603, 592): v, (603, 599):
        1, (603, 603): v/w, (603, 612): u*v/w, (603, 619): u*v, (603,
        644): v/w, (604, 294): -u*v/w, (604, 483): -v/w, (604, 591):
        -u*v/w, (604, 603): 1/w, (604, 618): -u**2*v/w, (604, 639):
        -v/w**2, (605, 593): v, (605, 595): u*v**2/w**2, (605, 600):
        1, (605, 605): v/w, (605, 612): u/w, (605, 620): u*v, (605,
        645): v/w, (606, 595): u*v/w**2, (606, 605): 1/w, (607, 271):
        -u**2*v/w**2, (607, 294): -u*v/w, (607, 584): v/w, (607, 592):
        u*v/w, (607, 595): -u**3*v/w**2, (607, 601): 1, (607, 607):
        v/w, (607, 611): u*v/w, (607, 618): -u**2*v/w, (607, 619):
        u**2*v/w, (607, 644): u*v/w**2, (608, 271): -u**2/w**2, (608,
        294): -u**2*v/w**2, (608, 595): -u**3/w**2, (608, 607): 1/w,
        (608, 618): -u**3*v/w**2, (608, 638): -v/w**2, (608, 644):
        u/w**2, (608, 646): -u*v/w**2, (609, 272): u/w, (609, 375):
        u/w, (609, 593): u*v/w, (609, 596): u**2/w, (609, 602): 1,
        (609, 609): v/w, (609, 611): u/w, (609, 619): u**2/w, (609,
        620): u**2*v/w, (610, 294): -u**2/w**2, (610, 593): u/w, (610,
        609): 1/w, (610, 618): -u**3/w**2, (610, 620): u**2/w, (611,
        483): -u/w, (611, 591): -u**2/w, (611, 638): 1/w, (611, 646):
        u/w, (612, 639): 1/w, (613, 136): -u*v/w**2, (613, 244): -u/w,
        (613, 271): -u*v**2/w**3, (613, 595): -u**2*v**2/w**3, (613,
        614): 1, (613, 615): -u/w, (613, 622): -u**2*v/w**3, (614,
        271): u/w**2, (614, 595): u**2/w**2, (614, 615): 1/w, (614,
        623): -v/w**2, (615, 271): u*v/w**2, (615, 569): v/w, (615,
        595): u**2*v/w**2, (615, 596): u*v/w, (615, 613): 1, (615,
        615): v/w, (616, 294): 1/w, (616, 618): u/w, (617, 374): u/w,
        (617, 455): 1/w, (618, 376): u/w, (618, 457): 1/w, (618, 618):
        v/w, (619, 294): -u/w, (619, 616): 1, (619, 618): -u**2/w,
        (620, 377): u/w, (620, 458): 1/w, (621, 567): 1, (621, 621):
        v/w, (622, 568): 1, (622, 622): v/w, (623, 569): 1, (623,
        623): v/w, (624, 570): 1, (624, 624): v/w, (625, 571): 1,
        (625, 625): v/w, (626, 294): u*v, (626, 401): -v/w, (626,
        514): -v/w, (626, 618): u**2*v, (626, 630): -u/w, (626, 631):
        1, (627, 377): -u*v, (627, 403): -v/w, (627, 458): -v, (627,
        568): -u*v**2/w**2, (627, 585): -u/w, (627, 591): -v**2/w,
        (627, 595): -u*v/w, (627, 622): -u*v**3/w**3, (627, 632):
        -u/w, (627, 633): 1, (627, 639): -u*v/w**2, (627, 645):
        -v**3/w**2, (628, 190): u**2*v/w**2, (628, 294): u**2*v/w,
        (628, 298): u**2/w, (628, 325): u**2*v**2/w**3, (628, 347):
        -u*v/w**2, (628, 348): u*v**2/w**2, (628, 401): -u*v/w**2,
        (628, 482): -u/w, (628, 483): u*v/w, (628, 568): u**3*v/w**2,
        (628, 590): -u**2/w, (628, 591): u**2*v/w, (628, 618):
        u**3*v/w, (628, 622): 2*u**3*v**2/w**3, (628, 634): -u/w,
        (628, 635): 1, (628, 644): -u**2*v/w**2, (628, 645):
        u**2*v**2/w**2, (629, 191): -u/w, (629, 294): u**2/w, (629,
        296): -u, (629, 326): -u*v/w**2, (629, 349): -u*v/w**2, (629,
        377): -u**2*v/w, (629, 402): -u*v/w**2, (629, 403): -u*v/w**2,
        (629, 458): -u*v/w, (629, 484): -u/w, (629, 569): -u**2/w,
        (629, 584): -u/w, (629, 592): -u**2/w, (629, 618): u**3/w,
        (629, 620): -u**2, (629, 623): -2*u**2*v/w**2, (629, 636):
        -u/w, (629, 637): 1, (629, 638): -u*v/w**2, (629, 646):
        -u**2*v/w**2, (630, 352): v, (630, 590): v, (630, 612): v,
        (630, 619): v*w, (630, 626): 1, (630, 630): v/w, (630, 644):
        v**2/w, (631, 294): -v, (631, 585): -v/w, (631, 618): -u*v,
        (631, 630): 1/w, (631, 639): -v**2/w**2, (632, 591): v, (632,
        620): v*w, (632, 622): u*v**2/w**2, (632, 627): 1, (632, 632):
        v/w, (632, 639): u/w, (632, 645): v**2/w, (633, 622):
        u*v/w**2, (633, 632): 1/w, (634, 325): -u**2*v/w**2, (634,
        348): -u*v/w, (634, 590): u*v/w, (634, 611): v, (634, 619):
        u*v, (634, 622): -u**3*v/w**2, (634, 628): 1, (634, 634): v/w,
        (634, 644): u*v**2/w**2, (634, 645): -u**2*v/w, (635, 325):
        -u**2/w**2, (635, 348): -u**2*v/w**2, (635, 584): -v/w, (635,
        590): u/w, (635, 592): -u*v/w, (635, 622): -u**3/w**2, (635,
        634): 1/w, (635, 638): -v**2/w**2, (635, 644): u*v/w**2, (635,
        645): -u**3*v/w**2, (635, 646): -u*v**2/w**2, (636, 326): u/w,
        (636, 402): u/w, (636, 620): u*v, (636, 623): u**2/w, (636,
        629): 1, (636, 636): v/w, (636, 638): u/w, (636, 646): u**2/w,
        (637, 348): -u**2/w**2, (637, 620): u, (637, 636): 1/w, (637,
        645): -u**3/w**2, (638, 294): -u, (638, 348): u**2/w, (638,
        584): 1, (638, 592): u, (638, 618): -u**2, (638, 638): v/w,
        (638, 645): u**3/w, (638, 646): u*v/w, (639, 585): 1, (639,
        639): v/w, (640, 190): -u*v/w**2, (640, 298): -u/w, (640,
        325): -u*v**2/w**3, (640, 568): -u**2*v/w**2, (640, 622):
        -2*u**2*v**2/w**3, (640, 641): 1, (640, 642): -u/w, (641,
        325): u/w**2, (641, 569): -v/w, (641, 622): u**2/w**2, (641,
        623): -v**2/w**2, (641, 642): 1/w, (642, 325): u*v/w**2, (642,
        596): v, (642, 622): u**2*v/w**2, (642, 640): 1, (642, 642):
        v/w, (643, 348): 1/w, (643, 645): u/w, (644, 374): 1, (645,
        376): 1, (645, 645): v/w, (646, 348): -u/w, (646, 643): 1,
        (646, 645): -u**2/w, (647, 377): 1}, {(0, 81): 1, (0, 108):
        -u/w, (1, 244): -v, (1, 271): u*v/w, (1, 298): 1, (1, 325):
        -u/w, (1, 352): u*v/w, (1, 379): -u/w, (1, 514): -u**2*v/w**2,
        (1, 541): u**2/w**2, (1, 568): u*v/w, (1, 595): u*(u*v - w)/w,
        (2, 245): -v, (2, 272): 1, (2, 299): u*v/w, (2, 326): -u/w,
        (2, 353): u*v/w, (2, 380): -u**2*v/w**2, (2, 515): -u/w, (2,
        542): u**2/w**2, (2, 569): u*v/w, (3, 7): -u/w, (3, 8): 1, (3,
        127): u*(u*v - w)/w**2, (3, 184): u*v*(u*v - w)**2/w**3, (4,
        5): -u/w, (4, 6): 1, (4, 100): -v, (4, 127): u*v/w, (4, 157):
        v**2, (4, 184): u*v**2*(u*v - 2*w)/w**2, (4, 211): -u*v**2/w,
        (4, 238): u*v/w, (5, 4): 1, (5, 5): v/w, (5, 19): v, (5, 49):
        v**2*(u*v - w)/w, (6, 5): 1/w, (6, 49): u*v**2/w, (6, 76):
        -u*v/w, (7, 3): 1, (7, 7): v/w, (7, 19): u*v/w, (7, 49):
        u*v**2*(u*v - w)/w**2, (8, 7): 1/w, (8, 19): u/w, (8, 49):
        u*v*(u*v - w)/w**2, (9, 36): 1, (9, 63): -u/w, (10, 18): -u/w,
        (10, 38): 1, (10, 65): -u/w, (10, 157): v**2, (10, 184):
        -u*v**2/w, (10, 211): -v, (10, 238): u*v/w, (10, 433): -v*(u*v
        - w)/w**2, (10, 487): u*v*(u*v - w)/w**3, (10, 595): v**2*(u*v
        - w)/w**2, (10, 622): -u*v**2*(u*v - w)/w**3, (11, 45): -v/w,
        (11, 72): 1/w, (11, 244): u*v**2/w, (11, 271):
        -u**2*v**2/w**2, (11, 298): -u*v/w, (11, 325): u**2*v/w**2,
        (11, 352): -u**2*v**2/w**2, (11, 379): u**2*v/w**2, (11, 514):
        u**3*v**2/w**3, (11, 541): -u**3*v/w**3, (11, 568):
        -u**2*v**2/w**2, (11, 595): -u**2*v*(u*v - w)/w**2, (12, 39):
        1, (12, 66): -u/w, (13, 40): 1, (13, 67): -u/w, (14, 17):
        -u/w, (14, 42): 1, (14, 69): -u/w, (14, 103): -u**2*v/w, (14,
        130): u**2/w, (14, 184): -u*v*(u*v - w)/w**2, (14, 238):
        u*(u*v - w)/w**2, (14, 245): -u*v**2/w, (14, 272): u*v/w, (14,
        299): u**2*v**2/w**2, (14, 326): -u**2*v/w**2, (14, 353):
        u*v/w, (14, 380): -u**2*v/w**2, (14, 515): -u/w, (14, 542):
        u**2/w**2, (14, 569): u*v/w, (15, 22): -u*v/w, (15, 29):
        -u*v/w, (15, 44): -v/w, (15, 49): u, (15, 56): u/w, (15, 71):
        1/w, (15, 76): -u**2/w, (16, 43): 1, (16, 49): u**2/w, (16,
        70): -u/w, (16, 76): -u**3/w**2, (16, 103): -u**2/w, (16,
        130): u**3/w**2, (17, 14): 1, (17, 17): v/w, (17, 49):
        -u*v**2/w, (17, 76): u*v/w, (18, 10): 1, (18, 18): v/w, (18,
        49): -v**2, (18, 76): v, (18, 406): -v, (18, 433): u*v/w, (18,
        460): u*v/w, (18, 487): -u**2*v/w**2, (18, 595): -u*v**2/w,
        (18, 622): u*v/w, (19, 100): 1, (19, 127): -u/w, (20, 25):
        -u/w, (20, 26): 1, (20, 130): u*(u*v - w)/w**2, (20, 245):
        v**2/w, (20, 272): -v/w, (20, 299): -u*v**2/w**2, (20, 326):
        u*v/w**2, (20, 353): -u*v**2/w**2, (20, 380): u**2*v**2/w**3,
        (20, 515): u*v/w**2, (20, 542): -u**2*v/w**3, (20, 569):
        -u*v**2/w**2, (21, 23): -u/w, (21, 24): 1, (21, 103): -v, (21,
        130): u*v/w, (21, 136): u*v/w, (21, 163): -u/w, (21, 190):
        -u**2*v/w**2, (21, 217): u**2/w**2, (22, 103): 1, (22, 130):
        -u/w, (23, 21): 1, (23, 22): v, (23, 23): v/w, (23, 82):
        -u*v/w, (23, 109): u/w, (24, 23): 1/w, (25, 2): v/w, (25, 20):
        1, (25, 22): u*v/w, (25, 25): v/w, (26, 22): u/w, (26, 25):
        1/w, (27, 135): 1, (27, 162): -u/w, (28, 244): u, (28, 271):
        -u**2/w, (28, 352): -u**2/w, (28, 406): 1, (28, 433): -u/w,
        (28, 460): -u/w, (28, 487): u**2/w**2, (28, 514): u**3/w**2,
        (28, 568): -u**2/w, (28, 595): -u*(u**2 - v)/w, (28, 622):
        -u/w, (29, 299): -v/w, (29, 326): 1/w, (29, 380): u*v/w**2,
        (29, 542): -u/w**2, (29, 596): u*v/w, (30, 34): -u/w, (30,
        35): 1, (30, 130): -u**2*v*(u*v - w)/w**3, (30, 181): u*(u*v -
        w)/w**2, (30, 184): -u**3*v*(u*v - w)/w**3, (30, 238):
        -u*v*(u*v - w)/w**3, (31, 32): -u/w, (31, 33): 1, (31, 130):
        -u*v*(u*v - w)/w**2, (31, 154): -v, (31, 181): u*v/w, (31,
        184): -u**2*v*(u*v - w)/w**2, (31, 211): v**2/w, (31, 238):
        -u*v**2/w**2, (32, 22): -u*v**2/w, (32, 31): 1, (32, 32): v/w,
        (32, 46): v, (32, 49): -u**2*v**2/w, (32, 76): -v**2/w, (33,
        22): -u*v/w, (33, 32): 1/w, (33, 49): -u**2*v/w, (34, 22):
        -u**2*v**2/w**2, (34, 30): 1, (34, 34): v/w, (34, 46): u*v/w,
        (34, 49): -u**3*v**2/w**2, (34, 76): -u*v**2/w**2, (35, 22):
        -u**2*v/w**2, (35, 34): 1/w, (35, 46): u/w, (35, 49):
        -u**3*v/w**2, (35, 76): -u*v/w**2, (36, 63): 1/w, (37, 45):
        -u/w, (37, 65): 1/w, (37, 103): -v, (37, 130): u*v/w, (37,
        157): -u*v, (37, 184): u**2*v/w, (37, 352): -v*(u*v - w)/w**2,
        (37, 514): u*v*(u*v - w)/w**3, (37, 622): v**2*(u*v - w)/w**3,
        (38, 18): 1/w, (38, 45): u/w, (38, 244): -u**2*v/w, (38, 271):
        u**3*v/w**2, (38, 352): u**3*v/w**2, (38, 406): -u*v/w, (38,
        433): u**2*v/w**2, (38, 460): u**2*v/w**2, (38, 487):
        -u**3*v/w**3, (38, 514): -u**4*v/w**3, (38, 568): u**3*v/w**2,
        (38, 595): u**2*v*(u**2 - v)/w**2, (38, 622): u**2*v/w**2,
        (39, 66): 1/w, (40, 67): 1/w, (41, 44): -u/w, (41, 69): 1/w,
        (41, 130): u*(u*v - w)/w**2, (41, 157): -u**2*v/w, (41, 184):
        u**3*v/w**2, (41, 299): -u*v**2/w**2, (41, 326): u*v/w**2,
        (41, 380): u*v/w**2, (41, 542): -u/w**2, (41, 596): u*v/w,
        (42, 2): u/w, (42, 17): 1/w, (42, 29): u**2/w, (42, 44): u/w,
        (42, 49): -u*v/w, (42, 76): u/w, (43, 70): 1/w, (43, 76):
        u**2/w**2, (43, 157): -u**2/w, (43, 184): u**3/w**2, (44, 22):
        u*v/w, (44, 41): 1, (44, 44): v/w, (44, 49): u**2*v/w, (45,
        22): v, (45, 37): 1, (45, 45): v/w, (45, 49): u*v, (45, 244):
        -v, (45, 271): u*v/w, (45, 352): u*v/w, (45, 514):
        -u**2*v/w**2, (45, 568): u*v/w, (45, 595): u**2*v/w, (46,
        154): 1, (46, 181): -u/w, (47, 52): -u/w, (47, 53): 1, (47,
        184): u*(u*v - w)/w**2, (47, 299): v**2/w**2, (47, 326):
        -v/w**2, (47, 380): -u*v**2/w**3, (47, 542): u*v/w**3, (47,
        596): -u*v**2/w**2, (48, 50): -u/w, (48, 51): 1, (48, 157):
        -v, (48, 184): u*v/w, (48, 190): u*v/w**2, (48, 217): -u/w**2,
        (49, 157): 1, (49, 184): -u/w, (50, 48): 1, (50, 49): v, (50,
        50): v/w, (50, 136): -u*v/w, (50, 163): u/w, (51, 50): 1/w,
        (52, 29): v/w, (52, 47): 1, (52, 49): u*v/w, (52, 52): v/w,
        (53, 49): u/w, (53, 52): 1/w, (54, 189): 1, (54, 216): -u/w,
        (55, 244): w, (55, 271): -u, (55, 352): -u, (55, 514): u**2/w,
        (55, 568): -u, (55, 595): -u**2, (56, 299): -v**2/w, (56,
        326): v/w, (56, 380): u*v**2/w**2, (56, 407): -v, (56, 434):
        u*v/w, (56, 461): 1, (56, 488): -u/w, (56, 542): -u*v/w**2,
        (56, 623): u*v/w, (57, 61): -u/w, (57, 62): 1, (57, 130):
        -u*v*(u*v - w)/w**2, (57, 184): -u**2*v*(u*v - w)/w**2, (57,
        235): u*(u*v - w)/w**2, (57, 238): -u*v**2*(u*v - w)/w**3,
        (58, 59): -u/w, (58, 60): 1, (58, 103): v**2, (58, 130):
        -u*v**2/w, (58, 184): -u*v*(u*v - w)/w, (58, 208): -v, (58,
        211): v**3/w, (58, 235): u*v/w, (58, 238): -u*v**3/w**2, (59,
        22): -v**2, (59, 49): -u*v**2, (59, 58): 1, (59, 59): v/w,
        (59, 73): v, (59, 76): -v**3/w, (60, 49): -u*v, (60, 59): 1/w,
        (61, 22): -u*v**2/w, (61, 49): -u**2*v**2/w, (61, 57): 1, (61,
        61): v/w, (61, 73): u*v/w, (61, 76): -u*v**3/w**2, (62, 22):
        -u*v/w, (62, 49): -u**2*v/w, (62, 61): 1/w, (62, 73): u/w,
        (62, 76): -u*v**2/w**2, (63, 9): 1, (63, 63): v/w, (64, 11):
        1, (64, 65): v/w, (64, 72): -u/w, (64, 157): -v*w, (64, 184):
        u*v, (64, 379): -v*(u*v - w)/w**2, (64, 541): u*v*(u*v -
        w)/w**3, (64, 568): v**2*(u*v - w)/w**2, (64, 622): v**3*(u*v
        - w)/w**3, (65, 45): 1, (65, 244): -u*v, (65, 271): u**2*v/w,
        (65, 352): u**2*v/w, (65, 514): -u**3*v/w**2, (65, 568):
        u**2*v/w, (65, 595): u**3*v/w, (66, 12): 1, (66, 66): v/w,
        (67, 13): 1, (67, 67): v/w, (68, 15): 1, (68, 69): v/w, (68,
        71): -u/w, (68, 184): u*(u*v - w)/w, (68, 211): -u**2*v/w,
        (68, 238): u**2/w, (68, 299): -u*v**3/w**2, (68, 326):
        u*v**2/w**2, (68, 380): u*v**2/w**2, (68, 407): -u*v**2/w,
        (68, 434): u*v/w, (68, 461): u*v/w, (68, 488): -u/w, (68,
        542): -u*v/w**2, (68, 623): u*v/w, (69, 22): u, (69, 29): u,
        (69, 44): 1, (70, 16): 1, (70, 22): u**2/w, (70, 70): v/w,
        (70, 76): u**2*v/w**2, (70, 211): -u**2/w, (70, 238):
        u**3/w**2, (71, 49): u*v, (71, 68): 1, (71, 71): v/w, (72,
        49): v*w, (72, 64): 1, (72, 72): v/w, (72, 298): -v, (72,
        325): u*v/w, (72, 379): u*v/w, (72, 541): -u**2*v/w**2, (72,
        595): u*v, (73, 208): 1, (73, 235): -u/w, (74, 79): -u/w, (74,
        80): 1, (74, 238): u*(u*v - w)/w**2, (74, 299): v**3/w**2,
        (74, 326): -v**2/w**2, (74, 380): -u*v**3/w**3, (74, 407):
        v**2/w, (74, 434): -u*v**2/w**2, (74, 461): -v/w, (74, 488):
        u*v/w**2, (74, 542): u*v**2/w**3, (74, 623): -u*v**2/w**2,
        (75, 77): -u/w, (75, 78): 1, (75, 82): u*v/w, (75, 109): -u/w,
        (75, 190): u*v**2/w**2, (75, 211): -v, (75, 217): -u*v/w**2,
        (75, 238): u*v/w, (76, 211): 1, (76, 238): -u/w, (77, 75): 1,
        (77, 76): v, (77, 77): v/w, (77, 190): -u*v/w, (77, 217): u/w,
        (78, 77): 1/w, (79, 56): v/w, (79, 74): 1, (79, 76): u*v/w,
        (79, 79): v/w, (80, 76): u/w, (80, 79): 1/w, (81, 108): 1/w,
        (82, 271): -v/w, (82, 325): u*v/w**2, (82, 514): u*v/w**2,
        (82, 541): -u/w**2, (82, 595): (-u*v + w)/w, (82, 622): u*(u*v
        - w)/w**2, (83, 137): 1, (83, 164): -u/w, (83, 191): -u/w,
        (83, 218): u**2/w**2, (83, 245): u, (83, 299): -u**2/w, (83,
        353): -u**2/w, (83, 380): u**3/w**2, (83, 569): -u**2/w, (84,
        19): -u/w, (84, 88): -u/w, (84, 89): 1, (84, 100): -u**2/w,
        (84, 127): -u*v/w**2, (84, 319): u*v*(u*v - w)**2/w**3, (84,
        346): u**2*v*(u*v - w)/w**3, (84, 373): u**2*v**2*(u*v -
        w)/w**3, (84, 643): u**3*v*(u*v - w)/w**3, (85, 86): -u/w,
        (85, 87): 1, (85, 127): -v/w, (85, 265): v**2, (85, 319):
        u*v**2*(u*v - 2*w)/w**2, (85, 373): u*v**2*(u*v - 2*w)/w**2,
        (85, 400): u*v/w, (85, 589): -u*v**2/w, (86, 85): 1, (86, 86):
        v/w, (86, 100): v, (86, 427): v**2*(u*v - w)/w, (86, 643):
        -u*v**2*(u*v - w)/w**2, (87, 86): 1/w, (87, 427): u*v**2/w,
        (87, 481): -u*v/w, (88, 84): 1, (88, 88): v/w, (88, 100):
        u*v/w, (88, 427): u*v**2*(u*v - w)/w**2, (88, 643):
        -u**2*v**2*(u*v - w)/w**3, (89, 88): 1/w, (89, 100): u/w, (89,
        427): u*v*(u*v - w)/w**2, (89, 643): -u**2*v*(u*v - w)/w**3,
        (90, 414): 1, (90, 468): -u/w, (90, 630): u*(u*v - w)/w**2,
        (91, 28): v/w, (91, 55): -u*v/w**2, (91, 99): -u/w, (91, 265):
        v**2, (91, 319): -u*v**2/w, (91, 373): -u*v**2/w, (91, 400):
        u*v/w, (91, 406): u*v/w, (91, 416): 1, (91, 433): v**2/w**2,
        (91, 460): -u**2*v/w**2, (91, 470): -u/w, (91, 487):
        -u*v**2/w**3, (91, 589): -v, (91, 595): -v**3/w**2, (91, 622):
        u*v*(u**2*v - u*w + v**2)/w**3, (91, 632): u*(u*v - w)/w**2,
        (92, 271): u*v**2/w**2, (92, 325): -u**2*v**2/w**3, (92, 423):
        -v/w, (92, 477): 1/w, (92, 514): -u**2*v**2/w**3, (92, 541):
        u**2*v/w**3, (92, 595): u*v*(u*v - w)/w**2, (92, 622):
        -u**2*v*(u*v - w)/w**3, (93, 417): 1, (93, 471): -u/w, (93,
        633): u*(u*v - w)/w**2, (94, 418): 1, (94, 472): -u/w, (94,
        634): u*(u*v - w)/w**2, (95, 22): u**2/w, (95, 98): -u/w, (95,
        103): u**3/w, (95, 137): u*v/w, (95, 164): -u**2*v/w**2, (95,
        191): -u/w, (95, 218): u**2/w**2, (95, 245): u**2*v/w, (95,
        299): -u**3*v/w**2, (95, 319): -u*v*(u*v - w)/w**2, (95, 353):
        -u**3*v/w**2, (95, 373): -u*v*(u*v - w)/w**2, (95, 380):
        u**3/w**2, (95, 400): u*(u*v - w)/w**2, (95, 420): 1, (95,
        474): -u/w, (95, 569): -u**2/w, (95, 636): u*(u*v - w)/w**2,
        (96, 103): -u*v/w, (96, 407): -u*v/w, (96, 422): -v/w, (96,
        427): u, (96, 461): u/w, (96, 476): 1/w, (96, 481): -u**2/w,
        (96, 643): u**2*(u*v - w)/w**2, (97, 130): -u**2/w**2, (97,
        421): 1, (97, 427): u**2/w, (97, 475): -u/w, (97, 481):
        -u**3/w**2, (97, 637): u*(u*v - w)/w**2, (97, 643): u**3*(u*v
        - w)/w**3, (98, 95): 1, (98, 98): v/w, (98, 427): -u*v**2/w,
        (98, 481): u*v/w, (99, 91): 1, (99, 99): v/w, (99, 427):
        -v**2, (99, 433): -v/w, (99, 481): v, (99, 487): u*v/w**2,
        (99, 595): v**2/w, (99, 622): -u*v**2/w**2, (100, 127): 1/w,
        (101, 22): -u/w, (101, 103): -u**2/w, (101, 106): -u/w, (101,
        107): 1, (101, 130): -u*v/w**2, (101, 137): -v/w, (101, 164):
        u*v/w**2, (101, 191): u*v/w**2, (101, 218): -u**2*v/w**3,
        (101, 245): -u*v/w, (101, 299): u**2*v/w**2, (101, 353):
        u**2*v/w**2, (101, 380): -u**3*v/w**3, (101, 569):
        u**2*v/w**2, (102, 104): -u/w, (102, 105): 1, (102, 130):
        -v/w, (102, 244): u*v/w, (102, 298): -u/w, (102, 325):
        -u**2*(u*v - w)/w**3, (102, 352): -u**2*v/w**2, (102, 379):
        u**2/w**2, (102, 568): -u**2*v/w**2, (102, 622): -u**3*(u*v -
        w)/w**3, (103, 130): 1/w, (104, 1): u/w, (104, 82): u**2/w,
        (104, 102): 1, (104, 103): v, (104, 104): v/w, (105, 104):
        1/w, (106, 83): v/w, (106, 101): 1, (106, 103): u*v/w, (106,
        106): v/w, (107, 103): u/w, (107, 106): 1/w, (108, 0): 1,
        (108, 108): v/w, (109, 136): -v, (109, 163): 1, (109, 190):
        u*v/w, (109, 217): -u/w, (109, 271): -v**2/w, (109, 325):
        u*v**2/w**2, (109, 514): u*v**2/w**2, (109, 541): -u*v/w**2,
        (109, 595): -v*(u*v - w)/w, (109, 622): u*v*(u*v - w)/w**2,
        (110, 245): w, (110, 299): -u, (110, 353): -u, (110, 380):
        u**2/w, (110, 569): -u, (111, 19): -u*v/w, (111, 100): -u,
        (111, 115): -u/w, (111, 116): 1, (111, 127): -u*v**2/w**2,
        (111, 346): u**2*v**2*(u*v - w)/w**3, (111, 373):
        u**2*v**3*(u*v - w)/w**3, (111, 616): u*v*(u*v - w)**2/w**2,
        (111, 643): u**2*v*(u*v - w)/w**2, (112, 19): -v, (112, 113):
        -u/w, (112, 114): 1, (112, 127): -v**2/w, (112, 292): v**2,
        (112, 346): u*v**2*(u*v - 2*w)/w**2, (112, 373): u*v**3*(u*v -
        w)/w**2, (112, 535): -u*v**2/w, (112, 562): u*v/w, (112, 616):
        u*v**2*(u*v - w)/w, (113, 112): 1, (113, 113): v/w, (113,
        127): v, (113, 454): v**2*(u*v - w)/w, (113, 616): -v**3*(u*v
        - w)/w, (114, 113): 1/w, (114, 454): u*v**2/w, (114, 508):
        -u*v/w, (114, 616): -u*v**3/w, (114, 643): u*v**2/w, (115,
        111): 1, (115, 115): v/w, (115, 127): u*v/w, (115, 454):
        u*v**2*(u*v - w)/w**2, (115, 616): -u*v**3*(u*v - w)/w**2,
        (116, 115): 1/w, (116, 127): u/w, (116, 454): u*v*(u*v -
        w)/w**2, (116, 616): -u*v**2*(u*v - w)/w**2, (117, 441): 1,
        (117, 495): -u/w, (117, 603): -v, (117, 630): u*v/w, (118,
        28): v**2/w, (118, 55): -u*v**2/w**2, (118, 126): -u/w, (118,
        292): v**2, (118, 346): -u*v**2/w, (118, 373): -v**2*(u*v -
        w)/w, (118, 406): v, (118, 433): v**3/w**2, (118, 443): 1,
        (118, 460): -u*v/w, (118, 487): -u*v**3/w**3, (118, 497):
        -u/w, (118, 535): -v, (118, 562): u*v/w, (118, 595):
        -v**4/w**2, (118, 605): -v, (118, 622): u*v*(u*v*w + v**3 -
        w**2)/w**3, (118, 632): u*v/w, (119, 136): u*v**2/w, (119,
        163): -u*v/w, (119, 190): -u**2*v**2/w**2, (119, 217):
        u**2*v/w**2, (119, 271): u*v**3/w**2, (119, 325):
        -u**2*v**3/w**3, (119, 450): -v/w, (119, 504): 1/w, (119,
        514): -u**2*v**3/w**3, (119, 541): u**2*v**2/w**3, (119, 595):
        u*v**2*(u*v - w)/w**2, (119, 612): v**2/w, (119, 622):
        -u**2*v**2*(u*v - w)/w**3, (119, 639): -v/w, (120, 444): 1,
        (120, 498): -u/w, (120, 606): -v, (120, 633): u*v/w, (121,
        445): 1, (121, 499): -u/w, (121, 607): -v, (121, 634): u*v/w,
        (122, 103): u**2, (122, 125): -u/w, (122, 245): u*v, (122,
        299): -u**2*v/w, (122, 346): -u*v*(u*v - w)/w**2, (122, 353):
        -u**2*v/w, (122, 373): -u*v**2*(u*v - w)/w**2, (122, 380):
        u**2/w, (122, 447): 1, (122, 501): -u/w, (122, 562): u*(u*v -
        w)/w**2, (122, 569): -u, (122, 609): -v, (122, 616): -u*v*(u*v
        - w)/w, (122, 636): u*v/w, (123, 130): -u*v/w, (123, 434):
        -u*v/w, (123, 449): -v/w, (123, 454): u, (123, 488): u/w,
        (123, 503): 1/w, (123, 508): -u**2/w, (123, 596): u*v**2/w,
        (123, 611): v**2/w, (123, 616): -u*v, (123, 623): -u*v/w,
        (123, 638): -v/w, (123, 643): u**2*v/w, (124, 22): -u**2/w,
        (124, 130): -u**2*v/w**2, (124, 448): 1, (124, 454): u**2/w,
        (124, 502): -u/w, (124, 508): -u**3/w**2, (124, 610): -v,
        (124, 616): -u**2*v/w, (124, 637): u*v/w, (124, 643):
        u**3*v/w**2, (125, 122): 1, (125, 125): v/w, (125, 454):
        -u*v**2/w, (125, 508): u*v/w, (125, 616): u*v**3/w, (125,
        643): -u*v**2/w, (126, 28): -v, (126, 55): u*v/w, (126, 118):
        1, (126, 126): v/w, (126, 433): -v**2/w, (126, 454): -v**2,
        (126, 487): u*v**2/w**2, (126, 508): v, (126, 595): v**3/w,
        (126, 616): v**3, (126, 622): -u*v**3/w**2, (126, 643): -v**2,
        (127, 19): 1, (127, 127): v/w, (128, 22): -u*v/w, (128, 103):
        -u, (128, 130): -u*v**2/w**2, (128, 133): -u/w, (128, 134): 1,
        (128, 245): -v, (128, 299): u*v/w, (128, 353): u*v/w, (128,
        380): -u**2*v/w**2, (128, 569): u*v/w, (129, 22): -v, (129,
        130): -v**2/w, (129, 131): -u/w, (129, 132): 1, (129, 271):
        u*v/w, (129, 325): -u**2*v/w**2, (129, 514): -u**2*v/w**2,
        (129, 541): u**2/w**2, (129, 595): u*(u*v - w)/w, (129, 622):
        -u**2*(u*v - w)/w**2, (130, 22): 1, (130, 130): v/w, (131,
        82): u, (131, 129): 1, (131, 130): v, (131, 131): v/w, (132,
        131): 1/w, (133, 110): v/w, (133, 128): 1, (133, 130): u*v/w,
        (133, 133): v/w, (134, 130): u/w, (134, 133): 1/w, (135, 162):
        1/w, (136, 325): -v/w**2, (136, 487): -u/w**2, (136, 514):
        -u**2/w**2, (136, 622): (-u*v + w)/w**2, (137, 191): 1/w,
        (137, 218): -u/w**2, (137, 299): u/w, (137, 380): -u**2/w**2,
        (137, 596): -u**2/w, (138, 46): -u/w, (138, 142): -u/w, (138,
        143): 1, (138, 154): -u**2/w, (138, 181): -u*v/w**2, (138,
        265): -u**2*v*(u*v - w)/w**2, (138, 292): -u**3*v/w**2, (138,
        319): -u*v**2*(u*v - w)/w**3, (138, 346): -u**2*v**2/w**3,
        (138, 373): -u**4*v**2/w**3, (138, 400): -u**2*v**2/w**3,
        (138, 427): -u*v*(u*v - w)/w**2, (138, 454): -u**3*v**2/w**3,
        (138, 481): -u**2*v/w**2, (138, 589): -u**3*v/w**2, (138,
        616): -u**4*v/w**2, (138, 643): -u**3*v**2/w**3, (139, 140):
        -u/w, (139, 141): 1, (139, 181): -v/w, (139, 265):
        -u**2*v**2/w, (139, 319): -v**2*(u*v - w)/w**2, (139, 373):
        -u**2*v*(u*v - w)/w**2, (139, 400): -u*v**2/w**2, (139, 427):
        -u*v**2/w, (139, 454): -u*v*(u*v - w)/w**2, (139, 616):
        -u*v**2/w, (140, 139): 1, (140, 140): v/w, (140, 154): v,
        (140, 265): v**2*(u*v - w)/w, (140, 589): u*v**2/w, (140,
        616): u**2*v**2/w, (140, 643): u*v**3/w**2, (141, 140): 1/w,
        (141, 265): u*v**2/w, (141, 292): -u*v/w, (142, 138): 1, (142,
        142): v/w, (142, 154): u*v/w, (142, 265): u*v**2*(u*v -
        w)/w**2, (142, 589): u**2*v**2/w**2, (142, 616):
        u**3*v**2/w**2, (142, 643): u**2*v**3/w**3, (143, 142): 1/w,
        (143, 154): u/w, (143, 265): u*v*(u*v - w)/w**2, (143, 589):
        u**2*v/w**2, (143, 616): u**3*v/w**2, (143, 643):
        u**2*v**2/w**3, (144, 252): 1, (144, 279): -u/w, (144, 576):
        -u/w, (144, 603): -u**2/w, (144, 630): -u*v/w**2, (145, 55):
        v/w**2, (145, 153): -u/w, (145, 244): u*v/w, (145, 254): 1,
        (145, 271): -u**2*v/w**2, (145, 281): -u/w, (145, 319):
        v**2/w, (145, 352): v**2/w**2, (145, 373): u**2*v/w, (145,
        454): u*v/w, (145, 514): -u*v**2/w**3, (145, 568):
        -u**2*v/w**2, (145, 578): -u/w, (145, 595): -u**3*v/w**2,
        (145, 605): -u**2/w, (145, 616): -v, (145, 622): -v**2*(u**2 +
        v)/w**3, (145, 632): -u*v/w**2, (146, 261): -v/w, (146, 288):
        1/w, (146, 325): u*v**2/w**3, (146, 487): u**2*v/w**3, (146,
        514): u**3*v/w**3, (146, 622): u*v*(u*v - w)/w**3, (147, 255):
        1, (147, 282): -u/w, (147, 579): -u/w, (147, 606): -u**2/w,
        (147, 633): -u*v/w**2, (148, 256): 1, (148, 283): -u/w, (148,
        580): -u/w, (148, 607): -u**2/w, (148, 634): -u*v/w**2, (149,
        49): u**2/w, (149, 83): -u/w, (149, 110): u**2/w**2, (149,
        137): -u**2/w, (149, 152): -u/w, (149, 157): u**3/w, (149,
        164): u**3/w**2, (149, 258): 1, (149, 265): u**2*v/w, (149,
        285): -u/w, (149, 299): u**2*v/w**2, (149, 319): u*v**2/w**2,
        (149, 353): u**4/w**2, (149, 373): u**2*(u*v - w)/w**2, (149,
        427): u*v/w, (149, 434): u**3/w**2, (149, 454): u*(u*v -
        w)/w**2, (149, 582): -u/w, (149, 596): -u**2/w, (149, 609):
        -u**2/w, (149, 636): -u*v/w**2, (150, 157): -u*v/w, (150,
        245): -u*v/w, (150, 260): -v/w, (150, 265): u, (150, 272):
        u/w, (150, 287): 1/w, (150, 292): -u**2/w, (150, 589):
        -u**2/w, (150, 616): -u**3/w, (150, 643): -u**2*v/w**2, (151,
        184): -u**2/w**2, (151, 259): 1, (151, 265): u**2/w, (151,
        286): -u/w, (151, 292): -u**3/w**2, (151, 583): -u/w, (151,
        589): -u**3/w**2, (151, 610): -u**2/w, (151, 616): -u**4/w**2,
        (151, 637): -u*v/w**2, (151, 643): -u**3*v/w**3, (152, 149):
        1, (152, 152): v/w, (152, 265): -u*v**2/w, (152, 292): u*v/w,
        (153, 145): 1, (153, 153): v/w, (153, 265): -v**2, (153, 292):
        v, (153, 352): -v/w, (153, 514): u*v/w**2, (153, 622):
        v**2/w**2, (154, 181): 1/w, (155, 49): -u/w, (155, 157):
        -u**2/w, (155, 160): -u/w, (155, 161): 1, (155, 184):
        -u*v/w**2, (155, 191): -v/w**2, (155, 218): u*v/w**3, (155,
        299): -u*v/w**2, (155, 380): u**2*v/w**3, (155, 596):
        u**2*v/w**2, (156, 158): -u/w, (156, 159): 1, (156, 184):
        -v/w, (156, 244): -u**2/w, (156, 271): u**3/w**2, (156, 325):
        u**2*v/w**3, (156, 352): u**3/w**2, (156, 406): -u/w, (156,
        433): u**2/w**2, (156, 460): u**2/w**2, (156, 568): u**3/w**2,
        (156, 595): u**2*(u**2 - v)/w**2, (156, 622): u**3*v/w**3,
        (157, 184): 1/w, (158, 28): u/w, (158, 136): u**2/w, (158,
        156): 1, (158, 157): v, (158, 158): v/w, (159, 158): 1/w,
        (160, 137): v/w, (160, 155): 1, (160, 157): u*v/w, (160, 160):
        v/w, (161, 157): u/w, (161, 160): 1/w, (162, 27): 1, (162,
        162): v/w, (163, 190): -v/w, (163, 217): 1/w, (163, 325):
        -v**2/w**2, (163, 487): -u*v/w**2, (163, 514): -u**2*v/w**2,
        (163, 622): -v*(u*v - w)/w**2, (164, 299): 1, (164, 380):
        -u/w, (164, 596): -u, (165, 46): -u*v/w, (165, 154): -u, (165,
        169): -u/w, (165, 170): 1, (165, 181): -u*v**2/w**2, (165,
        292): -u**3*v**2/w**2, (165, 346): -u**2*v**3/w**3, (165,
        373): -u**4*v**3/w**3, (165, 400): -u**2*v**3/w**3, (165,
        454): -u**3*v**3/w**3, (165, 481): -u**2*v**2/w**2, (165,
        589): -u**3*v**2/w**2, (165, 616): -u**4*v**2/w**2, (165,
        643): -u*v*(2*u*v - w)/w**2, (166, 46): -v, (166, 167): -u/w,
        (166, 168): 1, (166, 181): -v**2/w, (166, 292): -u**2*v**2/w,
        (166, 346): -v**2*(u*v - w)/w**2, (166, 373): -u**3*v**3/w**2,
        (166, 400): -u*v**3/w**2, (166, 454): -u**2*v**3/w**2, (166,
        481): -u*v**2/w, (166, 508): u*v/w, (166, 535): u**2*v/w,
        (166, 589): -u**2*v**2/w, (166, 616): -u**3*v**2/w, (166,
        643): -u*v**2/w, (167, 166): 1, (167, 167): v/w, (167, 181):
        v, (167, 373): v**2*(u*v - w)/w, (167, 589): u*v**3/w, (167,
        616): u**2*v**3/w, (167, 643): v**3/w, (168, 167): 1/w, (168,
        373): u*v**2/w, (168, 535): -u*v/w, (168, 589): u*v**2/w,
        (168, 616): u**2*v**2/w, (169, 165): 1, (169, 169): v/w, (169,
        181): u*v/w, (169, 373): u*v**2*(u*v - w)/w**2, (169, 589):
        u**2*v**3/w**2, (169, 616): u**3*v**3/w**2, (169, 643):
        u*v**3/w**2, (170, 169): 1/w, (170, 181): u/w, (170, 373):
        u*v*(u*v - w)/w**2, (170, 589): u**2*v**2/w**2, (170, 616):
        u**3*v**2/w**2, (170, 643): u*v**2/w**2, (171, 360): 1, (171,
        522): -u/w, (171, 630): -v/w, (172, 55): v**2/w**2, (172,
        180): -u/w, (172, 244): v, (172, 271): -u*v/w, (172, 346):
        v**2/w, (172, 352): v**3/w**2, (172, 362): 1, (172, 373):
        u**2*v**2/w, (172, 400): v**2/w, (172, 454): u*v**2/w, (172,
        514): -u*v**3/w**3, (172, 524): -u/w, (172, 562): -v/w, (172,
        568): -u*v/w, (172, 595): -u**2*v/w, (172, 622): -v**2*(u*w +
        v**2)/w**3, (172, 632): -v/w, (173, 190): u*v**2/w**2, (173,
        217): -u*v/w**2, (173, 325): u*v**3/w**3, (173, 369): -v/w,
        (173, 487): u**2*v**2/w**3, (173, 514): u**3*v**2/w**3, (173,
        531): 1/w, (173, 585): -v/w, (173, 612): -u*v/w, (173, 622):
        u*v**2*(u*v - w)/w**3, (174, 363): 1, (174, 525): -u/w, (174,
        633): -v/w, (175, 364): 1, (175, 526): -u/w, (175, 634): -v/w,
        (176, 157): u**2, (176, 179): -u/w, (176, 292): u**2*v/w,
        (176, 299): u*v/w, (176, 346): u*v**2/w**2, (176, 353):
        u**3/w, (176, 366): 1, (176, 373): u**3*v**2/w**2, (176, 400):
        u*v**2/w**2, (176, 434): u**2/w, (176, 454): u**2*v**2/w**2,
        (176, 481): u*v/w, (176, 508): -u/w, (176, 528): -u/w, (176,
        535): -u**2/w, (176, 562): -u*v/w**2, (176, 589): u**2*v/w,
        (176, 596): -u, (176, 616): u**3*v/w, (176, 636): -v/w, (176,
        643): u*v/w, (177, 184): -u*v/w, (177, 353): -u*v/w, (177,
        368): -v/w, (177, 373): u, (177, 515): u/w, (177, 530): 1/w,
        (177, 535): -u**2/w, (177, 569): -u*v/w, (177, 584): -v/w,
        (177, 596): -u**2*v/w, (177, 611): -u*v/w, (177, 643): -u*v/w,
        (178, 49): -u**2/w, (178, 184): -u**2*v/w**2, (178, 367): 1,
        (178, 373): u**2/w, (178, 529): -u/w, (178, 535): -u**3/w**2,
        (178, 637): -v/w, (178, 643): -u**2*v/w**2, (179, 176): 1,
        (179, 179): v/w, (179, 373): -u*v**2/w, (179, 535): u*v/w,
        (179, 589): -u*v**2/w, (179, 616): -u**2*v**2/w, (180, 55):
        -v/w, (180, 172): 1, (180, 180): v/w, (180, 352): -v**2/w,
        (180, 373): -v**2, (180, 514): u*v**2/w**2, (180, 535): v,
        (180, 589): -v**2, (180, 616): -u*v**2, (180, 622): v**3/w**2,
        (181, 46): 1, (181, 181): v/w, (182, 49): -u*v/w, (182, 157):
        -u, (182, 184): -u*v**2/w**2, (182, 187): -u/w, (182, 188): 1,
        (182, 299): -v/w, (182, 380): u*v/w**2, (182, 596): u*v/w,
        (183, 49): -v, (183, 184): -v**2/w, (183, 185): -u/w, (183,
        186): 1, (183, 325): u*v/w**2, (183, 487): u**2/w**2, (183,
        514): u**3/w**2, (183, 622): u*(u*v - w)/w**2, (184, 49): 1,
        (184, 184): v/w, (185, 136): u, (185, 183): 1, (185, 184): v,
        (185, 185): v/w, (186, 185): 1/w, (187, 164): v/w, (187, 182):
        1, (187, 184): u*v/w, (187, 187): v/w, (188, 184): u/w, (188,
        187): 1/w, (189, 216): 1/w, (190, 325): -v**2/w**2, (190,
        460): -v/w, (190, 514): -u/w, (190, 568): (-u*v + w)/w, (190,
        622): -v*(u*v - w)/w**2, (191, 83): 1, (191, 110): -u/w, (191,
        191): v/w, (191, 218): -u*v/w**2, (191, 299): u*v/w, (191,
        380): -u**2*v/w**2, (191, 407): u, (191, 434): -u**2/w, (191,
        623): -u**2/w, (192, 73): -u/w, (192, 196): -u/w, (192, 197):
        1, (192, 208): -u**2/w, (192, 235): -u*v/w**2, (192, 265):
        -u*v*(u*v - w)/w, (192, 292): -u**2*v/w, (192, 319):
        -u*v**3*(u*v - w)/w**3, (192, 346): -u**2*v**3/w**3, (192,
        373): -u**3*v**2/w**2, (192, 400): -u**2*v**3/w**3, (192,
        427): -u*v**2*(u*v - w)/w**2, (192, 454): -u**2*v**2/w**2,
        (192, 481): -u**2*v**2/w**2, (192, 589): -u**3*v**2/w**2,
        (192, 616): -u**3*v/w, (192, 643): -u**3*v**3/w**3, (193,
        194): -u/w, (193, 195): 1, (193, 235): -v/w, (193, 265):
        -u*v**2, (193, 319): -v**3*(u*v - w)/w**2, (193, 373):
        -u*v*(u*v - w)/w, (193, 400): -u*v**3/w**2, (193, 427):
        -v**2*(u*v - w)/w, (193, 454): -u*v**2/w, (193, 643):
        -u*v**2/w, (194, 193): 1, (194, 194): v/w, (194, 208): v,
        (194, 319): v**2*(u*v - w)/w, (194, 589): u*v**3/w, (194,
        616): u*v**2, (194, 643): u*v**4/w**2, (195, 194): 1/w, (195,
        319): u*v**2/w, (195, 346): -u*v/w, (196, 192): 1, (196, 196):
        v/w, (196, 208): u*v/w, (196, 319): u*v**2*(u*v - w)/w**2,
        (196, 589): u**2*v**3/w**2, (196, 616): u**2*v**2/w, (196,
        643): u**2*v**4/w**3, (197, 196): 1/w, (197, 208): u/w, (197,
        319): u*v*(u*v - w)/w**2, (197, 589): u**2*v**2/w**2, (197,
        616): u**2*v/w, (197, 643): u**2*v**3/w**3, (198, 306): 1,
        (198, 333): -u/w, (198, 576): -u*v/w, (198, 603): -u, (198,
        630): -u*v**2/w**2, (199, 1): v/w, (199, 55): v**2/w**2, (199,
        207): -u/w, (199, 298): u*v/w, (199, 308): 1, (199, 319):
        v**3/w, (199, 325): -u**2*v/w**2, (199, 335): -u/w, (199,
        373): u*v, (199, 379): v**2/w**2, (199, 427): v**2, (199,
        541): -u*v**2/w**3, (199, 568): -v**2*(u**2 + v)/w**2, (199,
        578): -u*v/w, (199, 595): -u**2*v/w, (199, 605): -u, (199,
        622): -v**3*(u**2 + v)/w**3, (199, 632): -u*v**2/w**2, (199,
        643): -v, (200, 315): -v/w, (200, 325): u*v**3/w**3, (200,
        342): 1/w, (200, 460): u*v**2/w**2, (200, 514): u**2*v/w**2,
        (200, 568): u*v*(u*v - w)/w**2, (200, 622): u*v**2*(u*v -
        w)/w**3, (201, 309): 1, (201, 336): -u/w, (201, 579): -u*v/w,
        (201, 606): -u, (201, 633): -u*v**2/w**2, (202, 310): 1, (202,
        337): -u/w, (202, 580): -u*v/w, (202, 607): -u, (202, 634):
        -u*v**2/w**2, (203, 76): u**2/w, (203, 137): -u, (203, 164):
        u**2/w, (203, 206): -u/w, (203, 211): u**3/w, (203, 265): u*v,
        (203, 299): u**2*v**2/w**2, (203, 312): 1, (203, 319):
        u*v**3/w**2, (203, 339): -u/w, (203, 353): u**3/w, (203, 373):
        u*(u*v - w)/w, (203, 407): u**2*v/w, (203, 427): u*v**2/w,
        (203, 582): -u*v/w, (203, 609): -u, (203, 623): -u**2/w, (203,
        636): -u*v**2/w**2, (204, 211): -u*v/w, (204, 299): -u*v/w,
        (204, 314): -v/w, (204, 319): u, (204, 326): u/w, (204, 341):
        1/w, (204, 346): -u**2/w, (204, 589): -u**2*v/w, (204, 616):
        -u**2, (204, 643): -u**2*v**2/w**2, (205, 238): -u**2/w**2,
        (205, 313): 1, (205, 319): u**2/w, (205, 340): -u/w, (205,
        346): -u**3/w**2, (205, 583): -u*v/w, (205, 589):
        -u**3*v/w**2, (205, 610): -u, (205, 616): -u**3/w, (205, 637):
        -u*v**2/w**2, (205, 643): -u**3*v**2/w**3, (206, 203): 1,
        (206, 206): v/w, (206, 319): -u*v**2/w, (206, 346): u*v/w,
        (207, 199): 1, (207, 207): v/w, (207, 319): -v**2, (207, 346):
        v, (207, 379): -v/w, (207, 541): u*v/w**2, (207, 568): v**2/w,
        (207, 622): v**3/w**2, (208, 235): 1/w, (209, 76): -u/w, (209,
        83): -v/w, (209, 110): u*v/w**2, (209, 191): -v**2/w**2, (209,
        211): -u**2/w, (209, 214): -u/w, (209, 215): 1, (209, 218):
        u*v**2/w**3, (209, 238): -u*v/w**2, (209, 299): -u*v**2/w**2,
        (209, 380): u**2*v**2/w**3, (209, 407): -u*v/w, (209, 434):
        u**2*v/w**2, (209, 623): u**2*v/w**2, (210, 212): -u/w, (210,
        213): 1, (210, 238): -v/w, (210, 244): -u, (210, 271): u**2/w,
        (210, 325): u**2*v**2/w**3, (210, 352): u**2/w, (210, 460):
        u**2*v/w**2, (210, 568): u**3*v/w**2, (210, 595): u**3/w,
        (210, 622): u**2*v*(u*v - w)/w**3, (211, 238): 1/w, (212, 55):
        u/w, (212, 190): u**2/w, (212, 210): 1, (212, 211): v, (212,
        212): v/w, (213, 212): 1/w, (214, 191): v/w, (214, 209): 1,
        (214, 211): u*v/w, (214, 214): v/w, (215, 211): u/w, (215,
        214): 1/w, (216, 54): 1, (216, 216): v/w, (217, 82): -v, (217,
        109): 1, (217, 190): -v**2/w, (217, 217): v/w, (217, 325):
        -v**3/w**2, (217, 460): -v**2/w, (217, 514): -u*v/w, (217,
        568): -v*(u*v - w)/w, (217, 622): -v**2*(u*v - w)/w**2, (218,
        299): v, (218, 380): -u*v/w, (218, 407): w, (218, 434): -u,
        (218, 623): -u, (219, 73): -u*v/w, (219, 208): -u, (219, 223):
        -u/w, (219, 224): 1, (219, 235): -u*v**2/w**2, (219, 292):
        -u**2*v**2/w, (219, 346): -u**2*v**4/w**3, (219, 373):
        -u**3*v**3/w**2, (219, 400): -u**2*v**4/w**3, (219, 454):
        -u**2*v**3/w**2, (219, 481): -u**2*v**3/w**2, (219, 589):
        -u*v*(2*u*v - w)/w, (219, 616): -u**3*v**2/w, (219, 643):
        -u*v**2*(2*u*v - w)/w**2, (220, 73): -v, (220, 221): -u/w,
        (220, 222): 1, (220, 235): -v**2/w, (220, 292): -u*v**2, (220,
        346): -v**3*(u*v - w)/w**2, (220, 373): -u**2*v**3/w, (220,
        400): -u*v**4/w**2, (220, 454): -u*v**3/w, (220, 481):
        -v**2*(u*v - w)/w, (220, 535): u*v, (220, 589): -u*v**2, (220,
        616): -u**2*v**2, (220, 643): -u*v**3/w, (221, 220): 1, (221,
        221): v/w, (221, 235): v, (221, 400): v**2*(u*v - w)/w, (221,
        589): v**3, (221, 616): u*v**3, (221, 643): v**4/w, (222,
        221): 1/w, (222, 400): u*v**2/w, (222, 562): -u*v/w, (222,
        616): u*v**2, (223, 219): 1, (223, 223): v/w, (223, 235):
        u*v/w, (223, 400): u*v**2*(u*v - w)/w**2, (223, 589):
        u*v**3/w, (223, 616): u**2*v**3/w, (223, 643): u*v**4/w**2,
        (224, 223): 1/w, (224, 235): u/w, (224, 400): u*v*(u*v -
        w)/w**2, (224, 589): u*v**2/w, (224, 616): u**2*v**2/w, (224,
        643): u*v**3/w**2, (225, 387): 1, (225, 549): -u/w, (225,
        576): -v, (225, 630): -v**2/w, (226, 1): v**2/w, (226, 55):
        v**3/w**2, (226, 234): -u/w, (226, 298): v, (226, 325):
        -u*v/w, (226, 346): v**3/w, (226, 373): u*v**2, (226, 379):
        v**3/w**2, (226, 389): 1, (226, 400): v**3/w, (226, 454):
        v**2, (226, 481): v**2, (226, 508): -v, (226, 541):
        -u*v**3/w**3, (226, 551): -u/w, (226, 562): -v**2/w, (226,
        568): -v**2*(u*w + v**2)/w**2, (226, 578): -v, (226, 595):
        -u*v, (226, 622): -v**3*(u*w + v**2)/w**3, (226, 632):
        -v**2/w, (227, 82): u*v**2/w, (227, 109): -u*v/w, (227, 190):
        u*v**3/w**2, (227, 217): -u*v**2/w**2, (227, 325):
        u*v**4/w**3, (227, 396): -v/w, (227, 460): u*v**3/w**2, (227,
        514): u**2*v**2/w**2, (227, 558): 1/w, (227, 568): u*v**2*(u*v
        - w)/w**2, (227, 612): -v, (227, 622): u*v**3*(u*v - w)/w**3,
        (228, 390): 1, (228, 552): -u/w, (228, 579): -v, (228, 633):
        -v**2/w, (229, 391): 1, (229, 553): -u/w, (229, 580): -v,
        (229, 634): -v**2/w, (230, 211): u**2, (230, 233): -u/w, (230,
        292): u*v, (230, 299): u*v**2/w, (230, 346): u*v**3/w**2,
        (230, 353): u**2, (230, 373): u**2*v**2/w, (230, 393): 1,
        (230, 400): u*v**3/w**2, (230, 407): u*v, (230, 454):
        u*v**2/w, (230, 481): u*v**2/w, (230, 508): -u*v/w, (230,
        535): -u, (230, 555): -u/w, (230, 562): -u*v**2/w**2, (230,
        582): -v, (230, 589): u*v, (230, 616): u**2*v, (230, 623): -u,
        (230, 636): -v**2/w, (230, 643): u*v**2/w, (231, 238): -u*v/w,
        (231, 380): -u*v/w, (231, 395): -v/w, (231, 400): u, (231,
        542): u/w, (231, 557): 1/w, (231, 562): -u**2/w, (231, 589):
        -u*v, (231, 596): -u*v, (231, 611): -v, (231, 643): -u*v**2/w,
        (232, 76): -u**2/w, (232, 238): -u**2*v/w**2, (232, 394): 1,
        (232, 400): u**2/w, (232, 556): -u/w, (232, 562): -u**3/w**2,
        (232, 583): -v, (232, 589): -u**2*v/w, (232, 637): -v**2/w,
        (232, 643): -u**2*v**2/w**2, (233, 230): 1, (233, 233): v/w,
        (233, 400): -u*v**2/w, (233, 562): u*v/w, (233, 616): -u*v**2,
        (234, 1): -v, (234, 55): -v**2/w, (234, 226): 1, (234, 234):
        v/w, (234, 379): -v**2/w, (234, 400): -v**2, (234, 541):
        u*v**2/w**2, (234, 562): v, (234, 568): v**3/w, (234, 616):
        -v**2*w, (234, 622): v**4/w**2, (235, 73): 1, (235, 235): v/w,
        (236, 76): -u*v/w, (236, 211): -u, (236, 238): -u*v**2/w**2,
        (236, 241): -u/w, (236, 242): 1, (236, 299): -v**2/w, (236,
        380): u*v**2/w**2, (236, 407): -v, (236, 434): u*v/w, (236,
        623): u*v/w, (237, 76): -v, (237, 238): -v**2/w, (237, 239):
        -u/w, (237, 240): 1, (237, 325): u*v**2/w**2, (237, 460):
        u*v/w, (237, 514): u**2/w, (237, 568): u*(u*v - w)/w, (237,
        622): u*v*(u*v - w)/w**2, (238, 76): 1, (238, 238): v/w, (239,
        190): u, (239, 237): 1, (239, 238): v, (239, 239): v/w, (240,
        239): 1/w, (241, 218): v/w, (241, 236): 1, (241, 238): u*v/w,
        (241, 241): v/w, (242, 238): u/w, (242, 241): 1/w, (243, 297):
        1/w, (244, 325): u/w**2, (244, 352): 1/w, (244, 622): (u**2 -
        v)/w**2, (245, 569): 1/w, (245, 596): u/w, (246, 49):
        u**2*v/w**2, (246, 157): u**3*v/w**2, (246, 184):
        u**2*v**2/w**3, (246, 250): -u/w, (246, 251): 1, (246, 262):
        -u**2/w, (246, 265): u**4*v/w**2, (246, 292): u**2*v/w**2,
        (246, 316): -u*v/w**2, (246, 319): u**3*v**2/w**3, (246, 346):
        u**3*v/w**3, (246, 373): u**2*v*(u*v + w)/w**3, (246, 424):
        -u/w, (246, 427): u**3*v/w**2, (246, 454): u*v/w**2, (246,
        616): u**3*v/w**2, (246, 643): u**4*v/w**3, (247, 49): u*v/w,
        (247, 157): u**2*v/w, (247, 184): u*v**2/w**2, (247, 248):
        -u/w, (247, 249): 1, (247, 265): u**3*v/w, (247, 316): -v/w,
        (247, 319): u**2*v**2/w**2, (247, 346): u**2*v/w**2, (247,
        373): u**2*v**2/w**2, (247, 427): u**2*v/w, (247, 616):
        v**2/w, (247, 643): u**3*v/w**2, (248, 157): -u*v**2/w, (248,
        247): 1, (248, 248): v/w, (248, 262): v, (248, 265):
        -u**2*v**2/w, (248, 292): -v**2/w, (248, 616): -u*v**2/w,
        (248, 643): -u**2*v**2/w**2, (249, 157): -u*v/w, (249, 248):
        1/w, (249, 265): -u**2*v/w, (249, 643): -u**2*v/w**2, (250,
        157): -u**2*v**2/w**2, (250, 246): 1, (250, 250): v/w, (250,
        262): u*v/w, (250, 265): -u**3*v**2/w**2, (250, 292):
        -u*v**2/w**2, (250, 616): -u**2*v**2/w**2, (250, 643):
        -u**3*v**2/w**3, (251, 157): -u**2*v/w**2, (251, 250): 1/w,
        (251, 262): u/w, (251, 265): -u**3*v/w**2, (251, 292):
        -u*v/w**2, (251, 616): -u**2*v/w**2, (251, 643): -u**3*v/w**3,
        (252, 279): 1/w, (252, 603): u/w, (253, 184): -v/w, (253,
        261): -u/w, (253, 271): u*v/w**2, (253, 281): 1/w, (253, 319):
        -u*v/w, (253, 325): v**2/w**3, (253, 373): -u*v/w, (253, 460):
        v/w**2, (253, 568): u*v/w**2, (253, 595): u**2*v/w**2, (253,
        605): u/w, (253, 622): u*v**2/w**3, (254, 153): 1/w, (254,
        261): u/w, (254, 325): -u**2*v/w**3, (254, 352): -u*v/w**2,
        (254, 622): -u*v*(u**2 - v)/w**3, (254, 639): u/w**2, (255,
        282): 1/w, (255, 606): u/w, (256, 283): 1/w, (256, 607): u/w,
        (257, 49): -u/w, (257, 110): -u/w**2, (257, 157): -u**2/w,
        (257, 164): -u**2/w**2, (257, 184): -u*v/w**2, (257, 245):
        -u**2/w, (257, 260): -u/w, (257, 285): 1/w, (257, 319):
        -u**2*v/w**2, (257, 346): -u**2/w**2, (257, 353): -u**3/w**2,
        (257, 373): -u**2*v/w**2, (257, 434): -u**2/w**2, (257, 609):
        u/w, (257, 643): -u**3/w**2, (258, 137): u/w, (258, 152): 1/w,
        (258, 245): u**2/w, (258, 260): u/w, (258, 265): -u*v/w, (258,
        292): u/w, (258, 616): u**2/w, (258, 623): u**2/w**2, (258,
        638): u/w**2, (259, 286): 1/w, (259, 292): u**2/w**2, (259,
        319): -u**2/w**2, (259, 610): u/w, (259, 616): u**3/w**2,
        (260, 157): u*v/w, (260, 257): 1, (260, 260): v/w, (260, 265):
        u**2*v/w, (260, 643): u**2*v/w**2, (261, 157): v, (261, 253):
        1, (261, 261): v/w, (261, 265): u*v, (261, 325): -v/w**2,
        (261, 622): -u*v/w**2, (261, 643): u*v/w, (262, 316): 1/w,
        (263, 265): -u**2/w, (263, 268): -u/w, (263, 269): 1, (263,
        319): -u*v/w**2, (263, 427): -u/w, (263, 569): -v/w**2, (263,
        596): -u*v/w**2, (264, 266): -u/w, (264, 267): 1, (264, 271):
        -u**2/w**2, (264, 319): -v/w, (264, 352): -u**2/w**2, (264,
        433): -u/w**2, (264, 595): -u*(u**2 - v)/w**2, (265, 319):
        1/w, (266, 244): u**2/w, (266, 264): 1, (266, 265): v, (266,
        266): v/w, (266, 406): u/w, (267, 266): 1/w, (268, 245): v/w,
        (268, 263): 1, (268, 265): u*v/w, (268, 268): v/w, (269, 265):
        u/w, (269, 268): 1/w, (270, 351): -u**2/w, (270, 432): -u/w,
        (270, 594): 1, (271, 325): 1/w, (271, 487): -u**2/w**2, (271,
        514): -u*(u**2 - v)/w**2, (271, 541): -u/w**2, (271, 622):
        u/w, (272, 353): -v/w, (272, 515): 1/w, (273, 49): u*v/w,
        (273, 157): u**2*v/w, (273, 184): u*v**2/w**2, (273, 265):
        u**3*v/w, (273, 277): -u/w, (273, 278): 1, (273, 292):
        -u**2*v*(u**2 - v)/w**2, (273, 319): u**2*v**2/w**2, (273,
        370): u**2*(u*v - w)/w**2, (273, 373): -u**2*v**2*(u**3 - u*v
        - w)/w**3, (273, 400): -u**3*v**2/w**3, (273, 427): u**2*v/w,
        (273, 451): u*(u*v - w)/w**2, (273, 454): -u*v**2*(u**3 -
        w)/w**3, (273, 481): -u**3*v/w**2, (273, 589): -u**4*v/w**2,
        (273, 616): -u**3*v*(u**2 - v)/w**2, (274, 184): v**2/w, (274,
        265): u**2*v, (274, 275): -u/w, (274, 276): 1, (274, 292):
        -u**3*v/w, (274, 319): u*v**2/w, (274, 370): u**2*v/w, (274,
        373): -u**2*v**2*(u**2 - v)/w**2, (274, 400): -u**2*v**2/w**2,
        (274, 427): u*v, (274, 451): u*v/w, (274, 454):
        -u**3*v**2/w**2, (274, 481): -u**2*v/w, (274, 589): -u**3*v/w,
        (274, 613): -v, (274, 616): -v*(u**2 - v)*(u**2 + v)/w, (275,
        157): -v**2, (275, 265): -u*v**2, (275, 274): 1, (275, 275):
        v/w, (275, 289): v, (275, 292): -v**3/w, (275, 589):
        u**2*v**2/w, (275, 616): u*v**2*(u**2 - v)/w, (276, 265):
        -u*v, (276, 275): 1/w, (276, 589): u**2*v/w, (276, 616):
        u**3*v/w, (277, 157): -u*v**2/w, (277, 265): -u**2*v**2/w,
        (277, 273): 1, (277, 277): v/w, (277, 289): u*v/w, (277, 292):
        -u*v**3/w**2, (277, 589): u**3*v**2/w**2, (277, 616):
        u**2*v**2*(u**2 - v)/w**2, (278, 157): -u*v/w, (278, 265):
        -u**2*v/w, (278, 277): 1/w, (278, 289): u/w, (278, 292):
        -u*v**2/w**2, (278, 589): u**3*v/w**2, (278, 616):
        u**2*v*(u**2 - v)/w**2, (279, 144): 1, (279, 279): v/w, (279,
        603): u*v/w, (280, 146): 1, (280, 281): v/w, (280, 288): -u/w,
        (280, 319): -v, (280, 373): u*v*(u**2 - v)/w, (280, 400):
        u*v/w, (280, 454): u**2*v/w, (280, 487): -v*(u*v - w)/w**3,
        (280, 514): -u*v*(u*v - w)/w**3, (280, 605): u*v/w, (281,
        261): 1, (281, 325): -u*v/w**2, (281, 487): u**3*v/w**3, (281,
        514): u**2*v*(u**2 - v)/w**3, (281, 541): u**2*v/w**3, (281,
        585): -u/w, (281, 612): -u**2/w, (281, 622): -u**2*v/w**2,
        (282, 147): 1, (282, 282): v/w, (282, 606): u*v/w, (283, 148):
        1, (283, 283): v/w, (283, 607): u*v/w, (284, 2): -u/w, (284,
        29): -u**2/w, (284, 110): -u*v/w**2, (284, 150): 1, (284,
        164): -u**2*v/w**2, (284, 265): -u**2, (284, 272): -u**2/w,
        (284, 285): v/w, (284, 287): -u/w, (284, 292): u**3/w, (284,
        319): -u*v/w, (284, 353): -u**3*v/w**2, (284, 373):
        u**2*(u**2*v + u*w - v**2)/w**2, (284, 400): u**2*v/w**2,
        (284, 427): -u, (284, 434): -u**2*v/w**2, (284, 454):
        u**2*(u*v + w)/w**2, (284, 481): u**2/w, (284, 589): u**3/w,
        (284, 609): u*v/w, (284, 616): u**2*(u**2 - v)/w, (285, 157):
        u, (285, 245): u, (285, 260): 1, (285, 569): -u**2/w, (285,
        584): -u/w, (285, 596): -u**3/w, (285, 611): -u**2/w, (285,
        616): u**2*v/w, (286, 151): 1, (286, 157): u**2/w, (286, 286):
        v/w, (286, 292): u**2*v/w**2, (286, 373): u**4/w**2, (286,
        454): u**3/w**2, (286, 610): u*v/w, (286, 616): u**2*(u*v -
        w)/w**2, (287, 265): u*v, (287, 284): 1, (287, 287): v/w,
        (287, 589): -u**2*v/w, (287, 616): -u**3*v/w, (288, 265): v*w,
        (288, 280): 1, (288, 288): v/w, (288, 487): u*v/w**2, (288,
        514): u**2*v/w**2, (288, 589): -u*v, (288, 616): -u**2*v,
        (288, 622): -v/w, (289, 370): -u**2/w, (289, 451): -u/w, (289,
        613): 1, (290, 295): -u/w, (290, 296): 1, (290, 353):
        v**2/w**2, (290, 373): u**2*(u*v - w)/w**2, (290, 454): u*(u*v
        - w)/w**2, (290, 515): -v/w**2, (291, 28): -u/w, (291, 136):
        -u**2/w, (291, 271): -u**2*v/w**2, (291, 293): -u/w, (291,
        294): 1, (291, 352): -u**2*v/w**2, (291, 373): u**2*v/w, (291,
        433): -u*v/w**2, (291, 454): u*v/w, (291, 595): -u*v*(u**2 -
        v)/w**2, (291, 616): -v, (292, 373): -u**2/w, (292, 454):
        -u/w, (292, 616): 1, (293, 291): 1, (293, 292): v, (293, 293):
        v/w, (293, 352): u**2/w, (293, 433): u/w, (293, 595): -u*v/w,
        (294, 293): 1/w, (295, 272): v/w, (295, 290): 1, (295, 292):
        u*v/w, (295, 295): v/w, (296, 292): u/w, (296, 295): 1/w,
        (297, 297): v/w, (297, 405): 1, (298, 325): u*v/w**2, (298,
        379): 1/w, (298, 460): u/w, (298, 568): (u**2 - v)/w, (298,
        622): v*(u**2 - v)/w**2, (299, 596): 1, (300, 76):
        u**2*v/w**2, (300, 211): u**3*v/w**2, (300, 238):
        u**2*v**2/w**3, (300, 262): -u, (300, 265): u**3*v/w, (300,
        304): -u/w, (300, 305): 1, (300, 316): -u*v**2/w**2, (300,
        319): u**3*v**3/w**3, (300, 346): u**2*v*(u*v + w)/w**3, (300,
        373): u*v/w, (300, 400): u**3*v**2/w**3, (300, 424): -u*v/w,
        (300, 427): u**3*v**2/w**2, (300, 481): u**3*v/w**2, (300,
        589): u**4*v/w**2, (300, 643): u**3*v*(u*v + w)/w**3, (301,
        76): u*v/w, (301, 211): u**2*v/w, (301, 238): u*v**2/w**2,
        (301, 265): u**2*v, (301, 302): -u/w, (301, 303): 1, (301,
        316): -v**2/w, (301, 319): u**2*v**3/w**2, (301, 346):
        u**2*v**2/w**2, (301, 400): u**2*v**2/w**2, (301, 424): -v,
        (301, 427): u**2*v**2/w, (301, 481): u**2*v/w, (301, 589):
        u**3*v/w, (301, 643): v**2*(u**3 + w)/w**2, (302, 211):
        -u*v**2/w, (302, 301): 1, (302, 302): v/w, (302, 316): v,
        (302, 319): -u**2*v**2/w, (302, 346): -v**2/w, (302, 589):
        -u**2*v**2/w, (302, 643): -u*v**2*(u*v + w)/w**2, (303, 211):
        -u*v/w, (303, 302): 1/w, (303, 319): -u**2*v/w, (303, 589):
        -u**2*v/w, (303, 643): -u**2*v**2/w**2, (304, 211):
        -u**2*v**2/w**2, (304, 300): 1, (304, 304): v/w, (304, 316):
        u*v/w, (304, 319): -u**3*v**2/w**2, (304, 346): -u*v**2/w**2,
        (304, 589): -u**3*v**2/w**2, (304, 643): -u**2*v**2*(u*v +
        w)/w**3, (305, 211): -u**2*v/w**2, (305, 304): 1/w, (305,
        316): u/w, (305, 319): -u**3*v/w**2, (305, 346): -u*v/w**2,
        (305, 589): -u**3*v/w**2, (305, 643): -u**2*v*(u*v + w)/w**3,
        (306, 333): 1/w, (306, 630): u/w, (307, 238): -v/w, (307,
        271): v/w, (307, 315): -u/w, (307, 319): -u*v**2/w, (307,
        325): v**3/w**3, (307, 335): 1/w, (307, 400): -u*v/w, (307,
        427): -u*v, (307, 460): v**2/w**2, (307, 568): u*v**2/w**2,
        (307, 595): u*v/w, (307, 622): u*v**3/w**3, (307, 632): u/w,
        (308, 207): 1/w, (308, 315): u/w, (308, 325): -u**2*v**2/w**3,
        (308, 379): -u*v/w**2, (308, 460): -u**2*v/w**2, (308, 568):
        -u*v*(u**2 - v)/w**2, (308, 585): u/w, (308, 622):
        -u*v**2*(u**2 - v)/w**3, (308, 639): u*v/w**2, (309, 336):
        1/w, (309, 633): u/w, (310, 337): 1/w, (310, 634): u/w, (311,
        76): -u/w, (311, 164): -u/w, (311, 211): -u**2/w, (311, 238):
        -u*v/w**2, (311, 299): -u**2/w, (311, 314): -u/w, (311, 319):
        -u**2*v**2/w**2, (311, 339): 1/w, (311, 346): -u**2*v/w**2,
        (311, 353): -u**2/w, (311, 400): -u**2*v/w**2, (311, 427):
        -u**2*v/w, (311, 481): -u**2/w, (311, 589): -u**3/w, (311,
        636): u/w, (311, 643): -u**3*v/w**2, (312, 191): u/w, (312,
        206): 1/w, (312, 299): u**2/w, (312, 314): u/w, (312, 319):
        -u*v/w, (312, 346): u/w, (312, 569): u**2/w, (312, 584): u/w,
        (312, 623): u**2*v/w**2, (312, 638): u*v/w**2, (312, 643):
        u**2/w, (313, 319): -u**2*v/w**2, (313, 340): 1/w, (313, 346):
        u**2/w**2, (313, 427): -u**2/w, (313, 637): u/w, (313, 643):
        u**3/w**2, (314, 211): u*v/w, (314, 311): 1, (314, 314): v/w,
        (314, 319): u**2*v/w, (314, 589): u**2*v/w, (314, 643):
        u**2*v**2/w**2, (315, 211): v, (315, 307): 1, (315, 315): v/w,
        (315, 319): u*v, (315, 325): -v**2/w**2, (315, 460): -v/w,
        (315, 568): -u*v/w, (315, 589): u*v, (315, 622): -u*v**2/w**2,
        (315, 643): u*v**2/w, (316, 316): v/w, (316, 424): 1, (317,
        265): -u, (317, 319): -u*v**2/w**2, (317, 322): -u/w, (317,
        323): 1, (317, 427): -u*v/w, (317, 596): -v/w, (318, 319):
        -v**2/w, (318, 320): -u/w, (318, 321): 1, (318, 325):
        -u**2/w**2, (318, 352): -u/w, (318, 427): -v, (318, 622):
        -u*(u**2 - v)/w**2, (319, 319): v/w, (319, 427): 1, (320,
        244): u, (320, 318): 1, (320, 319): v, (320, 320): v/w, (321,
        320): 1/w, (322, 299): v/w, (322, 317): 1, (322, 319): u*v/w,
        (322, 322): v/w, (323, 319): u/w, (323, 322): 1/w, (324, 351):
        -u, (324, 621): 1, (325, 325): v/w, (325, 460): 1, (325, 487):
        -u/w, (325, 514): -u**2/w, (325, 568): u, (325, 622): u*v/w,
        (326, 380): -v/w, (326, 542): 1/w, (327, 76): u*v/w, (327,
        211): u**2*v/w, (327, 238): u*v**2/w**2, (327, 265): u**2*v,
        (327, 292): -u**3*v/w, (327, 319): u**2*v**3/w**2, (327, 331):
        -u/w, (327, 332): 1, (327, 346): u**2*v**2/w**2, (327, 370):
        u*(u*v - w)/w, (327, 373): -u*v**2*(u**3 - w)/w**2, (327,
        427): u**2*v**2/w, (327, 454): -u**3*v**2/w**2, (327, 616):
        -u**4*v/w, (327, 643): u**3*v**2/w**2, (328, 238): v**2/w,
        (328, 265): u*v*w, (328, 292): -u**2*v, (328, 319): u*v**3/w,
        (328, 329): -u/w, (328, 330): 1, (328, 370): u*v, (328, 373):
        -u**3*v**2/w, (328, 427): u*v**2, (328, 454): -u**2*v**2/w,
        (328, 616): -u**3*v, (328, 640): -v, (328, 643): v**3/w, (329,
        211): -v**2, (329, 319): -u*v**2, (329, 328): 1, (329, 329):
        v/w, (329, 343): v, (329, 346): -v**3/w, (329, 616):
        u**2*v**2, (329, 643): -u*v**3/w, (330, 319): -u*v, (330,
        329): 1/w, (330, 616): u**2*v, (331, 211): -u*v**2/w, (331,
        319): -u**2*v**2/w, (331, 327): 1, (331, 331): v/w, (331,
        343): u*v/w, (331, 346): -u*v**3/w**2, (331, 616):
        u**3*v**2/w, (331, 643): -u**2*v**3/w**2, (332, 211): -u*v/w,
        (332, 319): -u**2*v/w, (332, 331): 1/w, (332, 343): u/w, (332,
        346): -u*v**2/w**2, (332, 616): u**3*v/w, (332, 643):
        -u**2*v**2/w**2, (333, 198): 1, (333, 333): v/w, (333, 630):
        u*v/w, (334, 200): 1, (334, 319): -v**2, (334, 335): v/w,
        (334, 342): -u/w, (334, 373): u**2*v, (334, 427): -v*w, (334,
        454): u*v, (334, 514): -v*(u*v - w)/w**2, (334, 632): u*v/w,
        (335, 315): 1, (335, 325): -u*v**2/w**2, (335, 460): -u*v/w,
        (335, 487): u**2*v/w**2, (335, 514): u**3*v/w**2, (335, 568):
        -u**2*v/w, (335, 612): -u, (335, 622): -u**2*v**2/w**2, (336,
        201): 1, (336, 336): v/w, (336, 633): u*v/w, (337, 202): 1,
        (337, 337): v/w, (337, 634): u*v/w, (338, 29): -u, (338, 164):
        -u*v/w, (338, 204): 1, (338, 265): -u*w, (338, 292): u**2,
        (338, 319): -u*v**2/w, (338, 326): -u**2/w, (338, 339): v/w,
        (338, 341): -u/w, (338, 353): -u**2*v/w, (338, 373): u**2*(u*v
        + w)/w, (338, 427): -u*v, (338, 454): u**2*v/w, (338, 616):
        u**3, (338, 636): u*v/w, (338, 643): -u**2*v/w, (339, 211): u,
        (339, 299): u, (339, 314): 1, (339, 596): -u**2, (339, 611):
        -u, (339, 643): u**2*v/w, (340, 205): 1, (340, 211): u**2/w,
        (340, 340): v/w, (340, 346): u**2*v/w**2, (340, 373): u**3/w,
        (340, 637): u*v/w, (340, 643): u**2*(u*v - w)/w**2, (341,
        319): u*v, (341, 338): 1, (341, 341): v/w, (341, 616):
        -u**2*v, (342, 319): v*w, (342, 334): 1, (342, 342): v/w,
        (342, 514): u*v/w, (342, 568): -v, (342, 616): -u*v*w, (342,
        622): -v**2/w, (343, 370): -u, (343, 640): 1, (344, 349):
        -u/w, (344, 350): 1, (344, 373): u*(u*v - w)/w, (344, 380):
        v**2/w**2, (344, 542): -v/w**2, (345, 55): -u/w, (345, 190):
        -u**2/w, (345, 325): -u**2*v/w**2, (345, 347): -u/w, (345,
        348): 1, (345, 352): -u*v/w, (345, 373): u*v, (345, 622):
        -u*v*(u**2 - v)/w**2, (345, 643): -v, (346, 373): -u, (346,
        643): 1, (347, 345): 1, (347, 346): v, (347, 347): v/w, (347,
        352): u, (347, 622): -u*v/w, (348, 347): 1/w, (349, 326): v/w,
        (349, 344): 1, (349, 346): u*v/w, (349, 349): v/w, (350, 346):
        u/w, (350, 349): 1/w, (351, 324): 1/w, (351, 351): v/w, (352,
        55): 1/w, (352, 190): u/w, (352, 325): u*v/w**2, (352, 352):
        v/w, (352, 487): v/w**2, (352, 514): u*v/w**2, (352, 622):
        v*(u**2 - v)/w**2, (353, 380): 1/w, (354, 49): u**2*v**2/w**2,
        (354, 157): u**2*v/w, (354, 184): u**2*v**3/w**3, (354, 292):
        u**2*v**2/w**2, (354, 343): -u*v/w**2, (354, 346):
        u**3*v**2/w**3, (354, 358): -u/w, (354, 359): 1, (354, 370):
        -u*v**2/w**2, (354, 373): 2*u**3*v**3/w**3, (354, 454):
        u**2*v**3/w**3, (354, 508): u*v/w**2, (354, 535): u**2*v/w**2,
        (354, 562): u*v**2/w**3, (354, 616): u**3*v**2/w**2, (354,
        640): -u/w, (354, 643): u**3*v/w**2, (355, 49): u*v**2/w,
        (355, 157): u*v, (355, 184): u*v**3/w**2, (355, 292):
        u*v**2/w, (355, 343): -v/w, (355, 346): u**2*v**2/w**2, (355,
        356): -u/w, (355, 357): 1, (355, 370): -v**2/w, (355, 373):
        2*u**2*v**3/w**2, (355, 454): u*v**3/w**2, (355, 562):
        v**2/w**2, (355, 616): u**2*v**2/w, (355, 643): u**2*v/w,
        (356, 184): -u*v**2/w, (356, 355): 1, (356, 356): v/w, (356,
        370): v, (356, 373): -u**2*v**2/w, (356, 535): -v**2/w, (356,
        616): -u*v**3/w, (357, 184): -u*v/w, (357, 356): 1/w, (357,
        373): -u**2*v/w, (357, 616): -u*v**2/w, (358, 184):
        -u**2*v**2/w**2, (358, 354): 1, (358, 358): v/w, (358, 370):
        u*v/w, (358, 373): -u**3*v**2/w**2, (358, 535): -u*v**2/w**2,
        (358, 616): -u**2*v**3/w**2, (359, 184): -u**2*v/w**2, (359,
        358): 1/w, (359, 370): u/w, (359, 373): -u**3*v/w**2, (359,
        535): -u*v/w**2, (359, 616): -u**2*v**2/w**2, (360, 522): 1/w,
        (361, 49): -v, (361, 184): -v**2/w, (361, 190): v**2/w**2,
        (361, 325): v**3/w**3, (361, 346): -u*v/w, (361, 369): -u/w,
        (361, 373): -2*u*v**2/w, (361, 454): -v**2/w, (361, 514):
        v**3/w**3, (361, 524): 1/w, (361, 568): v/w, (361, 622):
        v**2*(u*v + w)/w**3, (362, 55): -u*v/w**2, (362, 180): 1/w,
        (362, 190): -u**2*v/w**2, (362, 325): -u**2*v**2/w**3, (362,
        352): -u*v**2/w**2, (362, 369): u/w, (362, 487): -u*v**2/w**3,
        (362, 514): -u**2*v**2/w**3, (362, 612): v/w, (362, 622):
        -u*v**2*(u**2 - v)/w**3, (363, 525): 1/w, (364, 526): 1/w,
        (365, 49): -u*v/w, (365, 157): -u, (365, 184): -u*v**2/w**2,
        (365, 292): -u*v/w, (365, 346): -u**2*v/w**2, (365, 353):
        -u**2/w, (365, 368): -u/w, (365, 373): -2*u**2*v**2/w**2,
        (365, 434): -u/w, (365, 454): -u*v**2/w**2, (365, 528): 1/w,
        (365, 616): -u**2*v/w, (366, 164): u/w, (366, 179): 1/w, (366,
        353): u**2/w, (366, 368): u/w, (366, 373): -u*v/w, (366, 535):
        u/w, (366, 596): u*v/w, (366, 611): v/w, (367, 346):
        -u**2/w**2, (367, 373): -u**2*v/w**2, (367, 529): 1/w, (367,
        535): u**2/w**2, (368, 184): u*v/w, (368, 365): 1, (368, 368):
        v/w, (368, 373): u**2*v/w, (368, 616): u*v**2/w, (369, 184):
        v, (369, 190): -v/w, (369, 325): -v**2/w**2, (369, 361): 1,
        (369, 369): v/w, (369, 373): u*v, (369, 514): -v**2/w**2,
        (369, 616): v**2, (369, 622): -u*v**2/w**2, (370, 343): 1/w,
        (370, 370): v/w, (371, 346): -u*v/w**2, (371, 373):
        -u*v**2/w**2, (371, 376): -u/w, (371, 377): 1, (371, 380):
        -v/w**2, (371, 643): -u/w, (372, 346): -v/w, (372, 373):
        -v**2/w, (372, 374): -u/w, (372, 375): 1, (372, 487): -u/w**2,
        (372, 514): -u**2/w**2, (373, 346): 1/w, (373, 373): v/w,
        (374, 372): 1, (374, 373): v, (374, 374): v/w, (374, 622):
        u/w, (375, 374): 1/w, (376, 353): v/w, (376, 371): 1, (376,
        373): u*v/w, (376, 376): v/w, (377, 373): u/w, (377, 376):
        1/w, (378, 324): v/w, (378, 378): v/w, (378, 459): 1, (379,
        1): 1, (379, 55): v/w, (379, 82): u, (379, 190): u*v/w, (379,
        325): u*v**2/w**2, (379, 379): v/w, (379, 460): u*v/w, (379,
        514): v/w, (379, 568): v*(u**2 - v)/w, (379, 622): v**2*(u**2
        - v)/w**2, (380, 380): v/w, (380, 434): 1, (381, 76):
        u**2*v**2/w**2, (381, 211): u**2*v/w, (381, 238):
        u**2*v**3/w**3, (381, 343): -u*v**2/w**2, (381, 346):
        u**2*v**2*(u*v + w)/w**3, (381, 373): u**2*v**3/w**2, (381,
        385): -u/w, (381, 386): 1, (381, 397): -u*v**2/w**2, (381,
        400): u**3*v**3/w**3, (381, 478): -u*v/w, (381, 481):
        u**3*v**2/w**2, (381, 508): u*v**2/w**2, (381, 535): u*v/w,
        (381, 562): u*v**3/w**3, (381, 586): -u, (381, 589): u**3*v/w,
        (381, 640): -u*v/w, (381, 643): 2*u**3*v**2/w**2, (382, 76):
        u*v**2/w, (382, 211): u*v, (382, 238): u*v**3/w**2, (382,
        343): -v**2/w, (382, 346): u*v**2*(u*v + w)/w**2, (382, 373):
        u*v**3/w, (382, 383): -u/w, (382, 384): 1, (382, 397):
        -v**2/w, (382, 400): u**2*v**3/w**2, (382, 478): -v, (382,
        481): u**2*v**2/w, (382, 508): v**2/w, (382, 562): v**3/w**2,
        (382, 589): u**2*v, (382, 643): 2*u**2*v**2/w, (383, 238):
        -u*v**2/w, (383, 382): 1, (383, 383): v/w, (383, 397): v,
        (383, 400): -u**2*v**2/w, (383, 562): -v**2/w, (383, 643):
        -u*v**3/w, (384, 238): -u*v/w, (384, 383): 1/w, (384, 400):
        -u**2*v/w, (384, 643): -u*v**2/w, (385, 238): -u**2*v**2/w**2,
        (385, 381): 1, (385, 385): v/w, (385, 397): u*v/w, (385, 400):
        -u**3*v**2/w**2, (385, 562): -u*v**2/w**2, (385, 643):
        -u**2*v**3/w**2, (386, 238): -u**2*v/w**2, (386, 385): 1/w,
        (386, 397): u/w, (386, 400): -u**3*v/w**2, (386, 562):
        -u*v/w**2, (386, 643): -u**2*v**2/w**2, (387, 549): 1/w, (388,
        76): -v, (388, 82): v**2/w, (388, 190): v**3/w**2, (388, 238):
        -v**2/w, (388, 325): v**4/w**3, (388, 346): -u*v**2/w, (388,
        373): -v**2, (388, 396): -u/w, (388, 400): -u*v**2/w, (388,
        460): v**3/w**2, (388, 481): -u*v, (388, 541): v**3/w**3,
        (388, 551): 1/w, (388, 568): v**2*(u*v + w)/w**2, (388, 595):
        v, (388, 622): v*(u*v**3 - u*w**2 + v**2*w)/w**3, (389, 1):
        -u*v/w, (389, 55): -u*v**2/w**2, (389, 82): -u**2*v/w, (389,
        190): -u**2*v**2/w**2, (389, 234): 1/w, (389, 325):
        -u**2*v**3/w**3, (389, 379): -u*v**2/w**2, (389, 396): u/w,
        (389, 460): -u**2*v**2/w**2, (389, 514): -u*v**2/w**2, (389,
        568): -u*v**2*(u**2 - v)/w**2, (389, 622): -u*v**3*(u**2 -
        v)/w**3, (389, 639): v/w, (390, 552): 1/w, (391, 553): 1/w,
        (392, 76): -u*v/w, (392, 211): -u, (392, 238): -u*v**2/w**2,
        (392, 346): -u*v*(u*v + w)/w**2, (392, 353): -u, (392, 373):
        -u*v**2/w, (392, 395): -u/w, (392, 400): -u**2*v**2/w**2,
        (392, 481): -u**2*v/w, (392, 555): 1/w, (392, 643): -u**2*v/w,
        (393, 218): u/w, (393, 233): 1/w, (393, 380): u**2/w, (393,
        395): u/w, (393, 400): -u*v/w, (393, 562): u/w, (393, 623):
        u*v/w, (393, 638): v/w, (394, 346): -u**2*v/w**2, (394, 400):
        -u**2*v/w**2, (394, 481): -u**2/w, (394, 556): 1/w, (394,
        562): u**2/w**2, (395, 238): u*v/w, (395, 392): 1, (395, 395):
        v/w, (395, 400): u**2*v/w, (395, 643): u*v**2/w, (396, 82):
        -v, (396, 190): -v**2/w, (396, 238): v, (396, 325):
        -v**3/w**2, (396, 388): 1, (396, 396): v/w, (396, 400): u*v,
        (396, 460): -v**2/w, (396, 541): -v**2/w**2, (396, 568):
        -u*v**2/w, (396, 622): -u*v**3/w**2, (396, 643): v**2, (397,
        343): v/w, (397, 397): v/w, (397, 478): 1, (398, 346):
        -u*v**2/w**2, (398, 380): -v**2/w**2, (398, 400):
        -u*v**2/w**2, (398, 403): -u/w, (398, 404): 1, (398, 434):
        -v/w, (398, 481): -u*v/w, (398, 589): -u, (398, 643): -u*v/w,
        (399, 346): -v**2/w, (399, 400): -v**2/w, (399, 401): -u/w,
        (399, 402): 1, (399, 481): -v, (399, 514): -u/w, (400, 346):
        v/w, (400, 400): v/w, (400, 481): 1, (401, 399): 1, (401,
        400): v, (401, 401): v/w, (401, 568): u, (401, 622): u*v/w,
        (402, 401): 1/w, (403, 380): v/w, (403, 398): 1, (403, 400):
        u*v/w, (403, 403): v/w, (404, 400): u/w, (404, 403): 1/w,
        (405, 243): 1, (405, 297): -u/w, (406, 271): u/w, (406, 325):
        -u**2/w**2, (406, 433): 1/w, (406, 595): (u**2 - v)/w, (406,
        622): -u*(u**2 - v)/w**2, (407, 596): -v/w, (407, 623): 1/w,
        (408, 22): u**2*v/w**2, (408, 103): u**3*v/w**2, (408, 130):
        u**2*v**2/w**3, (408, 292): u**3*v/w**2, (408, 316): u*(u*v -
        w)/w**2, (408, 319): -u**3*v*(u*v - w)/w**3, (408, 346):
        -u**4*v/w**3, (408, 373): -u*v**2/w**2, (408, 400): u*v/w**2,
        (408, 412): -u/w, (408, 413): 1, (408, 454): u**3*v**2/w**3,
        (408, 481): u**2*v/w**2, (408, 589): u**3*v/w**2, (408, 616):
        u**4*v/w**2, (408, 643): -u**5*v/w**3, (409, 22): u*v/w, (409,
        103): u**2*v/w, (409, 130): u*v**2/w**2, (409, 262): -v, (409,
        292): u**2*v/w, (409, 316): u*v/w, (409, 319): -u**2*v*(u*v -
        w)/w**2, (409, 346): -u**3*v/w**2, (409, 410): -u/w, (409,
        411): 1, (409, 454): u**2*v**2/w**2, (409, 589): v**2/w, (409,
        616): u**3*v/w, (409, 643): -u**4*v/w**2, (410, 103):
        -u*v**2/w, (410, 409): 1, (410, 410): v/w, (410, 424): v,
        (410, 427): -u**2*v**2/w, (410, 481): -v**2/w, (410, 589):
        -u*v**2/w, (410, 616): -u**2*v**2/w, (410, 643):
        u**3*v**2/w**2, (411, 103): -u*v/w, (411, 410): 1/w, (411,
        427): -u**2*v/w, (411, 616): -u**2*v/w, (411, 643):
        u**3*v/w**2, (412, 103): -u**2*v**2/w**2, (412, 408): 1, (412,
        412): v/w, (412, 424): u*v/w, (412, 427): -u**3*v**2/w**2,
        (412, 481): -u*v**2/w**2, (412, 589): -u**2*v**2/w**2, (412,
        616): -u**3*v**2/w**2, (412, 643): u**4*v**2/w**3, (413, 103):
        -u**2*v/w**2, (413, 412): 1/w, (413, 424): u/w, (413, 427):
        -u**3*v/w**2, (413, 481): -u*v/w**2, (413, 589): -u**2*v/w**2,
        (413, 616): -u**3*v/w**2, (413, 643): u**4*v/w**3, (414, 468):
        1/w, (414, 576): u/w, (415, 130): -v/w, (415, 265): -u*v,
        (415, 319): u**2*v/w, (415, 325): -v*(u*v - w)/w**3, (415,
        423): -u/w, (415, 454): -u*v/w, (415, 470): 1/w, (415, 578):
        u/w, (415, 622): -u*v*(u*v - w)/w**3, (416, 99): 1/w, (416,
        271): -u**2*v/w**2, (416, 325): u**3*v/w**3, (416, 423): u/w,
        (416, 433): -u*v/w**2, (416, 595): -u*v*(u**2 - v)/w**2, (416,
        612): u/w, (416, 622): u**2*v*(u**2 - v)/w**3, (416, 639):
        -u**2/w**2, (417, 471): 1/w, (417, 579): u/w, (418, 472): 1/w,
        (418, 580): u/w, (419, 22): -u/w, (419, 103): -u**2/w, (419,
        130): -u*v/w**2, (419, 164): u*v/w**2, (419, 218): -u/w**2,
        (419, 265): -u**2*v/w, (419, 292): -u**2/w, (419, 319):
        u**3*v/w**2, (419, 346): u**3/w**2, (419, 353): u**2*v/w**2,
        (419, 380): -u**2/w**2, (419, 407): -u**2/w, (419, 422): -u/w,
        (419, 454): -u**2*v/w**2, (419, 474): 1/w, (419, 582): u/w,
        (419, 616): -u**3/w, (419, 643): u**4/w**2, (420, 83): u/w,
        (420, 98): 1/w, (420, 407): u**2/w, (420, 422): u/w, (420,
        427): -u*v/w, (420, 481): u/w, (420, 589): u**2/w, (420, 596):
        u**2/w, (420, 611): u/w, (420, 623): -u**3/w**2, (420, 638):
        -u**2/w**2, (421, 265): -u**2/w, (421, 319): u**3/w**2, (421,
        475): 1/w, (421, 481): u**2/w**2, (421, 583): u/w, (421, 589):
        u**3/w**2, (422, 103): u*v/w, (422, 419): 1, (422, 422): v/w,
        (422, 427): u**2*v/w, (422, 616): u**2*v/w, (422, 643):
        -u**3*v/w**2, (423, 103): v, (423, 271): -v/w, (423, 325):
        u*v/w**2, (423, 415): 1, (423, 423): v/w, (423, 427): u*v,
        (423, 595): -u*v/w, (423, 616): u*v, (423, 622): u**2*v/w**2,
        (423, 643): -u**2*v/w, (424, 262): 1, (424, 316): -u/w, (425,
        319): u*(u*v - w)/w**2, (425, 430): -u/w, (425, 431): 1, (425,
        596): v**2/w**2, (425, 623): -v/w**2, (426, 265): -v, (426,
        319): u*v/w, (426, 352): u*v/w**2, (426, 379): -u/w**2, (426,
        428): -u/w, (426, 429): 1, (426, 460): -u**2/w**2, (426, 568):
        -u*(u**2 - v)/w**2, (427, 265): 1, (427, 319): -u/w, (428,
        244): -u*v/w, (428, 298): u/w, (428, 426): 1, (428, 427): v,
        (428, 428): v/w, (429, 428): 1/w, (430, 407): v/w, (430, 425):
        1, (430, 427): u*v/w, (430, 430): v/w, (431, 427): u/w, (431,
        430): 1/w, (432, 270): 1, (432, 324): -u/w, (432, 432): v/w,
        (433, 28): 1, (433, 55): -u/w, (433, 136): u, (433, 190):
        -u**2/w, (433, 271): u*v/w, (433, 325): -u**2*v/w**2, (433,
        433): v/w, (433, 514): -v**2/w**2, (433, 541): v/w**2, (433,
        595): v*(u**2 - v)/w, (433, 622): -u*v*(u**2 - v)/w**2, (434,
        353): 1, (434, 380): -u/w, (435, 22): u**2*v**2/w**2, (435,
        103): u**2*v/w, (435, 130): u**2*v**3/w**3, (435, 289):
        -u*v/w, (435, 292): u**3*v**2/w**2, (435, 343): u**2*v/w**2,
        (435, 346): -u**4*v**2/w**3, (435, 373): -u**2*v**4/w**3,
        (435, 400): u**2*v**3/w**3, (435, 439): -u/w, (435, 440): 1,
        (435, 451): -u*v**2/w**2, (435, 454): u**3*v**3/w**3, (435,
        481): u**2*v**2/w**2, (435, 562): -u*v*(u*v - w)/w**3, (435,
        589): u**3*v**2/w**2, (435, 613): -u, (435, 616): u**3*v/w,
        (435, 640): u**2/w, (435, 643): -u**4*v/w**2, (436, 22):
        u*v**2/w, (436, 103): u*v, (436, 130): u*v**3/w**2, (436,
        289): -v, (436, 292): u**2*v**2/w, (436, 343): u*v/w, (436,
        346): -u**3*v**2/w**2, (436, 373): -u*v**4/w**2, (436, 400):
        u*v**3/w**2, (436, 437): -u/w, (436, 438): 1, (436, 451):
        -v**2/w, (436, 454): u**2*v**3/w**2, (436, 481): u*v**2/w,
        (436, 535): v**2/w, (436, 562): -u*v**2/w**2, (436, 589):
        u**2*v**2/w, (436, 616): u**2*v, (436, 643): -u**3*v/w, (437,
        130): -u*v**2/w, (437, 436): 1, (437, 437): v/w, (437, 451):
        v, (437, 454): -u**2*v**2/w, (437, 508): -v**2/w, (437, 589):
        -u*v**3/w, (438, 130): -u*v/w, (438, 437): 1/w, (438, 454):
        -u**2*v/w, (438, 589): -u*v**2/w, (439, 130): -u**2*v**2/w**2,
        (439, 435): 1, (439, 439): v/w, (439, 451): u*v/w, (439, 454):
        -u**3*v**2/w**2, (439, 508): -u*v**2/w**2, (439, 589):
        -u**2*v**3/w**2, (440, 130): -u**2*v/w**2, (440, 439): 1/w,
        (440, 451): u/w, (440, 454): -u**3*v/w**2, (440, 508):
        -u*v/w**2, (440, 589): -u**2*v**2/w**2, (441, 495): 1/w, (442,
        22): -v, (442, 130): -v**2/w, (442, 136): v**2/w, (442, 190):
        -u*v**2/w**2, (442, 271): v**3/w**2, (442, 292): -u*v, (442,
        325): -u*v**3/w**3, (442, 346): u**2*v/w, (442, 373): v**3/w,
        (442, 400): -v**2/w, (442, 450): -u/w, (442, 454): -u*v**2/w,
        (442, 487): v**3/w**3, (442, 497): 1/w, (442, 568): -u*v/w,
        (442, 595): u*v**3/w**2, (442, 622): -v*(u**2*v**2 + u*v*w -
        w**2)/w**3, (443, 28): -u*v/w, (443, 55): u**2*v/w**2, (443,
        126): 1/w, (443, 136): -u**2*v/w, (443, 190): u**3*v/w**2,
        (443, 271): -u**2*v**2/w**2, (443, 325): u**3*v**2/w**3, (443,
        433): -u*v**2/w**2, (443, 450): u/w, (443, 514): u*v**3/w**3,
        (443, 541): -u*v**2/w**3, (443, 585): v/w, (443, 595):
        -u*v**2*(u**2 - v)/w**2, (443, 622): u**2*v**2*(u**2 -
        v)/w**3, (444, 498): 1/w, (445, 499): 1/w, (446, 22): -u*v/w,
        (446, 103): -u, (446, 130): -u*v**2/w**2, (446, 292):
        -u**2*v/w, (446, 346): u**3*v/w**2, (446, 353): u*v/w, (446,
        373): u*v**3/w**2, (446, 380): -u/w, (446, 400): -u*v**2/w**2,
        (446, 449): -u/w, (446, 454): -u**2*v**2/w**2, (446, 481):
        -u*v/w, (446, 501): 1/w, (446, 589): -u**2*v/w, (447, 110):
        u/w, (447, 125): 1/w, (447, 434): u**2/w, (447, 449): u/w,
        (447, 454): -u*v/w, (447, 508): u/w, (447, 569): u*v/w, (447,
        584): v/w, (448, 292): -u**2/w, (448, 346): u**3/w**2, (448,
        454): -u**2*v/w**2, (448, 502): 1/w, (448, 508): u**2/w**2,
        (449, 130): u*v/w, (449, 446): 1, (449, 449): v/w, (449, 454):
        u**2*v/w, (449, 589): u*v**2/w, (450, 130): v, (450, 136): -v,
        (450, 190): u*v/w, (450, 271): -v**2/w, (450, 325):
        u*v**2/w**2, (450, 442): 1, (450, 450): v/w, (450, 454): u*v,
        (450, 487): -v**2/w**2, (450, 589): v**2, (450, 595):
        -u*v**2/w, (450, 622): u**2*v**2/w**2, (451, 289): 1, (451,
        343): -u/w, (451, 451): v/w, (452, 292): -u*v/w, (452, 346):
        u**2*v/w**2, (452, 353): -v/w, (452, 380): u*v/w**2, (452,
        454): -u*v**2/w**2, (452, 457): -u/w, (452, 458): 1, (452,
        616): -u, (452, 643): u**2/w, (453, 292): -v, (453, 346):
        u*v/w, (453, 454): -v**2/w, (453, 455): -u/w, (453, 456): 1,
        (453, 514): u*v/w**2, (453, 541): -u/w**2, (454, 292): 1,
        (454, 346): -u/w, (454, 454): v/w, (455, 453): 1, (455, 454):
        v, (455, 455): v/w, (455, 595): u, (455, 622): -u**2/w, (456,
        455): 1/w, (457, 434): v/w, (457, 452): 1, (457, 454): u*v/w,
        (457, 457): v/w, (458, 454): u/w, (458, 457): 1/w, (459, 351):
        u*v/w, (459, 378): -u/w, (459, 567): 1, (460, 271): 1, (460,
        325): -u/w, (460, 487): u*v/w**2, (460, 514): u*(u*v -
        w)/w**2, (460, 595): u, (460, 622): -u**2/w, (461, 434): -v/w,
        (461, 488): 1/w, (462, 22): u*v/w, (462, 103): u**2*v/w, (462,
        130): u*v**2/w**2, (462, 292): u**3*v**2/w**2, (462, 319):
        -u**2*v*(u*v - w)/w**2, (462, 346): -u**3*v/w**2, (462, 370):
        -u*v*(u*v - w)/w**2, (462, 373): u*v**2*(u**3*v - u**2*w -
        v*w)/w**3, (462, 397): u*(u*v - w)/w**2, (462, 400):
        u*v**2/w**2, (462, 454): u**3*v**3/w**3, (462, 466): -u/w,
        (462, 467): 1, (462, 481): u**2*v**2/w**2, (462, 589):
        u**3*v**2/w**2, (462, 616): u**4*v**2/w**2, (462, 643):
        -u**4*v/w**2, (463, 130): v**2/w, (463, 292): u**2*v**2/w,
        (463, 319): -u*v*(u*v - w)/w, (463, 346): -u**2*v/w, (463,
        370): -u*v**2/w, (463, 373): u**2*v**2*(u*v - w)/w**2, (463,
        397): u*v/w, (463, 454): u**2*v**3/w**2, (463, 464): -u/w,
        (463, 465): 1, (463, 586): -v, (463, 589): v**3/w, (463, 616):
        u**3*v**2/w, (463, 643): -u**3*v/w, (464, 103): -v**2, (464,
        427): -u*v**2, (464, 463): 1, (464, 464): v/w, (464, 478): v,
        (464, 481): -v**3/w, (464, 589): -u*v**3/w, (464, 616):
        -u**2*v**3/w, (464, 643): u**2*v**2/w, (465, 427): -u*v, (465,
        464): 1/w, (465, 616): -u**2*v**2/w, (465, 643): u**2*v/w,
        (466, 103): -u*v**2/w, (466, 427): -u**2*v**2/w, (466, 462):
        1, (466, 466): v/w, (466, 478): u*v/w, (466, 481):
        -u*v**3/w**2, (466, 589): -u**2*v**3/w**2, (466, 616):
        -u**3*v**3/w**2, (466, 643): u**3*v**2/w**2, (467, 103):
        -u*v/w, (467, 427): -u**2*v/w, (467, 466): 1/w, (467, 478):
        u/w, (467, 481): -u*v**2/w**2, (467, 589): -u**2*v**2/w**2,
        (467, 616): -u**3*v**2/w**2, (467, 643): u**3*v/w**2, (468,
        90): 1, (468, 468): v/w, (468, 576): u*v/w, (469, 92): 1,
        (469, 265): -v*w, (469, 319): u*v, (469, 373): -u*v*(u*v -
        w)/w, (469, 454): -u*v**2/w, (469, 470): v/w, (469, 477):
        -u/w, (469, 514): v**2*(u*v - w)/w**3, (469, 541): -v*(u*v -
        w)/w**3, (469, 578): u*v/w, (470, 271): -u*v/w, (470, 325):
        u**2*v/w**2, (470, 423): 1, (470, 487): -u**2*v**2/w**3, (470,
        514): -u**2*v*(u*v - w)/w**3, (470, 595): -u**2*v/w, (470,
        612): u*v/w, (470, 622): u**3*v/w**2, (470, 639): -u/w, (471,
        93): 1, (471, 471): v/w, (471, 579): u*v/w, (472, 94): 1,
        (472, 472): v/w, (472, 580): u*v/w, (473, 29): u*v/w, (473,
        56): -u/w, (473, 96): 1, (473, 164): u*v**2/w**2, (473, 218):
        -u*v/w**2, (473, 292): -u**2*v/w, (473, 319): u*(u*v - w)/w,
        (473, 346): u**2/w, (473, 353): u**2*v**2/w**2, (473, 373):
        -u**3*v**2/w**2, (473, 380): -u**2*v/w**2, (473, 400): u**2/w,
        (473, 454): -u**2*v**2/w**2, (473, 461): -u**2/w, (473, 474):
        v/w, (473, 476): -u/w, (473, 582): u*v/w, (473, 589):
        -u**2*v/w, (473, 616): -u**3*v/w, (473, 643): u**3/w, (474,
        103): u, (474, 407): u, (474, 422): 1, (474, 589): u**2*v/w,
        (474, 596): u**2*v/w, (474, 611): u*v/w, (474, 623): -u**2/w,
        (474, 638): -u/w, (475, 97): 1, (475, 103): u**2/w, (475,
        373): -u**3*v/w**2, (475, 400): u**3/w**2, (475, 475): v/w,
        (475, 481): u**2*v/w**2, (475, 583): u*v/w, (475, 589):
        u**2*(u*v - w)/w**2, (476, 427): u*v, (476, 473): 1, (476,
        476): v/w, (476, 616): u**2*v**2/w, (476, 643): -u**2*v/w,
        (477, 427): v*w, (477, 469): 1, (477, 477): v/w, (477, 514):
        -u*v**2/w**2, (477, 541): u*v/w**2, (477, 595): -v, (477,
        616): u*v**2, (477, 622): u*v/w, (477, 643): -u*v, (478, 370):
        u*v/w, (478, 397): -u/w, (478, 586): 1, (479, 373): -u*v*(u*v
        - w)/w**2, (479, 400): u*(u*v - w)/w**2, (479, 434):
        v**2/w**2, (479, 484): -u/w, (479, 485): 1, (479, 488):
        -v/w**2, (480, 1): -u/w, (480, 82): -u**2/w, (480, 352):
        u*v**2/w**2, (480, 373): -u*v**2/w, (480, 379): -u*v/w**2,
        (480, 400): u*v/w, (480, 460): -u**2*v/w**2, (480, 482): -u/w,
        (480, 483): 1, (480, 568): -u*v*(u**2 - v)/w**2, (480, 589):
        -v, (481, 373): u*v/w, (481, 400): -u/w, (481, 589): 1, (482,
        352): -u*v/w, (482, 379): u/w, (482, 480): 1, (482, 481): v,
        (482, 482): v/w, (482, 568): -u*v/w, (483, 482): 1/w, (484,
        461): v/w, (484, 479): 1, (484, 481): u*v/w, (484, 484): v/w,
        (485, 481): u/w, (485, 484): 1/w, (486, 513): 1, (486, 540):
        -u/w, (487, 136): w, (487, 190): -u, (487, 271): v, (487,
        325): -u*v/w, (487, 487): v/w, (487, 595): u*v, (487, 622):
        -u**2*v/w, (488, 29): -v, (488, 56): 1, (488, 164): -v**2/w,
        (488, 218): v/w, (488, 353): -v*(u*v - w)/w, (488, 434):
        -v**2/w, (488, 488): v/w, (489, 22): u*v**2/w, (489, 103):
        u*v, (489, 130): u*v**3/w**2, (489, 292): u**2*v**2/w, (489,
        346): -u**3*v**2/w**2, (489, 373): -u*v**4/w**2, (489, 400):
        u*v**3/w**2, (489, 454): u**2*v**3/w**2, (489, 481): u*v**2/w,
        (489, 493): -u/w, (489, 494): 1, (489, 559): u*(u*v - w)/w**2,
        (489, 562): -u*v**2*(u*v - w)/w**3, (489, 589): u**2*v**2/w,
        (489, 616): u**2*v, (489, 643): -u**3*v/w, (490, 22): v**2,
        (490, 130): v**3/w, (490, 292): u*v**2, (490, 346):
        -u**2*v**2/w, (490, 373): -v**4/w, (490, 400): v**3/w, (490,
        454): u*v**3/w, (490, 491): -u/w, (490, 492): 1, (490, 532):
        -v, (490, 535): v**3/w, (490, 559): u*v/w, (490, 562):
        -u*v**3/w**2, (490, 616): u*v*w, (490, 643): -u**2*v, (491,
        130): -v**2, (491, 454): -u*v**2, (491, 490): 1, (491, 491):
        v/w, (491, 505): v, (491, 508): -v**3/w, (491, 589): -v**3,
        (492, 454): -u*v, (492, 491): 1/w, (493, 130): -u*v**2/w,
        (493, 454): -u**2*v**2/w, (493, 489): 1, (493, 493): v/w,
        (493, 505): u*v/w, (493, 508): -u*v**3/w**2, (493, 589):
        -u*v**3/w, (494, 130): -u*v/w, (494, 454): -u**2*v/w, (494,
        493): 1/w, (494, 505): u/w, (494, 508): -u*v**2/w**2, (494,
        589): -u*v**2/w, (495, 117): 1, (495, 495): v/w, (495, 576):
        v, (496, 119): 1, (496, 217): -v*(u*v - w)/w**2, (496, 292):
        -v*w, (496, 346): u*v, (496, 454): -v**2, (496, 497): v/w,
        (496, 504): -u/w, (496, 541): -v**2*(u*v - w)/w**3, (496,
        578): v, (496, 622): -v**2*(u*v - w)/w**2, (497, 136): -u*v,
        (497, 190): u**2*v/w, (497, 271): -u*v**2/w, (497, 325):
        u**2*v**2/w**2, (497, 450): 1, (497, 487): -u*v**2/w**2, (497,
        595): -u**2*v**2/w, (497, 622): u**3*v**2/w**2, (498, 120): 1,
        (498, 498): v/w, (498, 579): v, (499, 121): 1, (499, 499):
        v/w, (499, 580): v, (500, 123): 1, (500, 292): -u*v, (500,
        346): u**2*v/w, (500, 353): u*v**2/w, (500, 380): -u*v/w,
        (500, 454): -u*v**2/w, (500, 461): -u, (500, 501): v/w, (500,
        503): -u/w, (500, 535): -u**2*v/w, (500, 562): u**2/w, (500,
        582): v, (500, 616): -u*w, (500, 643): u**2, (501, 130): u,
        (501, 434): u, (501, 449): 1, (501, 589): u*v, (502, 124): 1,
        (502, 130): u**2/w, (502, 502): v/w, (502, 508): u**2*v/w**2,
        (502, 535): -u**2/w, (502, 562): u**3/w**2, (502, 583): v,
        (502, 589): u**2*v/w, (503, 454): u*v, (503, 500): 1, (503,
        503): v/w, (504, 163): -v, (504, 217): u*v/w, (504, 454): v*w,
        (504, 496): 1, (504, 504): v/w, (504, 514): -v**2/w, (504,
        541): u*v**2/w**2, (504, 595): -v**2, (504, 622): u*v**2/w,
        (505, 532): 1, (505, 559): -u/w, (506, 29): v**2/w, (506, 56):
        -v/w, (506, 164): v**3/w**2, (506, 218): -v**2/w**2, (506,
        353): v**2*(u*v - w)/w**2, (506, 434): v**3/w**2, (506, 488):
        -v**2/w**2, (506, 511): -u/w, (506, 512): 1, (506, 562):
        u*(u*v - w)/w**2, (507, 82): -u, (507, 460): -u*v/w, (507,
        509): -u/w, (507, 510): 1, (507, 514): u*v**2/w**2, (507,
        535): -v, (507, 541): -u*v/w**2, (507, 562): u*v/w, (507,
        568): -u**2*v/w, (508, 535): 1, (508, 562): -u/w, (509, 507):
        1, (509, 508): v, (509, 509): v/w, (509, 514): -u*v/w, (509,
        541): u/w, (510, 509): 1/w, (511, 488): v/w, (511, 506): 1,
        (511, 508): u*v/w, (511, 511): v/w, (512, 508): u/w, (512,
        511): 1/w, (513, 540): 1/w, (514, 190): 1, (514, 325): v/w,
        (514, 514): v/w, (514, 622): u*v/w, (515, 2): 1, (515, 29): u,
        (515, 110): v/w, (515, 164): u*v/w, (515, 353): v*(u**2 -
        v)/w, (515, 380): v/w, (515, 434): u*v/w, (515, 515): v/w,
        (516, 49): u*v**2/w, (516, 157): u*v, (516, 184): u*v**3/w**2,
        (516, 292): u*v**2/w, (516, 346): u**2*v**2/w**2, (516, 373):
        2*u**2*v**3/w**2, (516, 454): u*v**3/w**2, (516, 505): -u/w,
        (516, 508): u*v**2/w**2, (516, 520): -u/w, (516, 521): 1,
        (516, 532): -u**2/w, (516, 535): u**2*v**2/w**2, (516, 559):
        -u*v/w**2, (516, 562): u*v**3/w**3, (516, 616): u**2*v**2/w,
        (516, 643): u**2*v/w, (517, 49): v**2, (517, 184): v**3/w,
        (517, 346): u*v**2/w, (517, 373): 2*u*v**3/w, (517, 454):
        v**3/w, (517, 518): -u/w, (517, 519): 1, (517, 559): -v/w,
        (517, 562): v**3/w**2, (517, 643): u*v, (518, 184): -v**2,
        (518, 373): -u*v**2, (518, 517): 1, (518, 518): v/w, (518,
        532): v, (518, 535): -v**3/w, (518, 616): -v**3, (519, 373):
        -u*v, (519, 518): 1/w, (520, 184): -u*v**2/w, (520, 373):
        -u**2*v**2/w, (520, 516): 1, (520, 520): v/w, (520, 532):
        u*v/w, (520, 535): -u*v**3/w**2, (520, 616): -u*v**3/w, (521,
        184): -u*v/w, (521, 373): -u**2*v/w, (521, 520): 1/w, (521,
        532): u/w, (521, 535): -u*v**2/w**2, (521, 616): -u*v**2/w,
        (522, 171): 1, (522, 522): v/w, (522, 603): v, (523, 109):
        v/w, (523, 163): u*v/w, (523, 173): 1, (523, 217): v**2/w**2,
        (523, 346): -v, (523, 373): -v**2, (523, 487): v**2/w**2,
        (523, 514): u*v**2/w**2, (523, 524): v/w, (523, 531): -u/w,
        (523, 541): v**3/w**3, (523, 568): v**2/w, (523, 595):
        u*v**2/w, (523, 605): v, (523, 622): v**3/w**2, (524, 190):
        -u*v/w, (524, 325): -u*v**2/w**2, (524, 369): 1, (524, 514):
        -u*v**2/w**2, (524, 622): -u**2*v**2/w**2, (525, 174): 1,
        (525, 525): v/w, (525, 606): v, (526, 175): 1, (526, 526):
        v/w, (526, 607): v, (527, 177): 1, (527, 272): -u, (527, 346):
        -u*v/w, (527, 353): -u**2*v/w, (527, 373): -u*v**2/w, (527,
        434): -u*v/w, (527, 508): u**2/w, (527, 528): v/w, (527, 530):
        -u/w, (527, 535): u**3/w, (527, 609): v, (527, 643): -u, (528,
        184): u, (528, 353): u, (528, 368): 1, (528, 616): u*v, (529,
        178): 1, (529, 184): u**2/w, (529, 529): v/w, (529, 535):
        u**2*v/w**2, (529, 562): -u**2/w**2, (529, 610): v, (529,
        616): u**2*v/w, (530, 373): u*v, (530, 527): 1, (530, 530):
        v/w, (531, 217): -v/w, (531, 373): v*w, (531, 523): 1, (531,
        531): v/w, (531, 541): -v**2/w**2, (531, 622): -v**2/w, (532,
        559): 1/w, (533, 2): -v/w, (533, 29): -u*v/w, (533, 110):
        -v**2/w**2, (533, 164): -u*v**2/w**2, (533, 353): -v**2*(u**2
        - v)/w**2, (533, 380): -v**2/w**2, (533, 434): -u*v**2/w**2,
        (533, 508): -u/w, (533, 515): -v**2/w**2, (533, 535): -u**2/w,
        (533, 538): -u/w, (533, 539): 1, (533, 562): -u*v/w**2, (534,
        136): -u, (534, 271): -u*v/w, (534, 487): -u*v/w**2, (534,
        514): -u**2*v/w**2, (534, 536): -u/w, (534, 537): 1, (534,
        562): -v/w, (534, 595): -u**2*v/w, (535, 562): 1/w, (536,
        487): u/w, (536, 514): u**2/w, (536, 534): 1, (536, 535): v,
        (536, 536): v/w, (537, 536): 1/w, (538, 515): v/w, (538, 533):
        1, (538, 535): u*v/w, (538, 538): v/w, (539, 535): u/w, (539,
        538): 1/w, (540, 486): 1, (540, 540): v/w, (541, 82): w, (541,
        190): v, (541, 325): v**2/w, (541, 460): v, (541, 541): v/w,
        (541, 568): u*v, (541, 622): u*v**2/w, (542, 29): w, (542,
        164): v, (542, 353): u*v, (542, 434): v, (542, 542): v/w,
        (543, 76): u*v**2/w, (543, 211): u*v, (543, 238): u*v**3/w**2,
        (543, 346): u*v**2*(u*v + w)/w**2, (543, 373): u*v**3/w, (543,
        400): u**2*v**3/w**2, (543, 481): u**2*v**2/w, (543, 505):
        -u*v/w, (543, 508): u*v**3/w**2, (543, 532): -u, (543, 535):
        u*v**2/w, (543, 547): -u/w, (543, 548): 1, (543, 559):
        -u*v**2/w**2, (543, 562): u*v**4/w**3, (543, 589): u**2*v,
        (543, 643): 2*u**2*v**2/w, (544, 76): v**2, (544, 238):
        v**3/w, (544, 346): u*v**3/w, (544, 373): v**3, (544, 400):
        u*v**3/w, (544, 481): u*v**2, (544, 505): -v, (544, 508):
        v**3/w, (544, 545): -u/w, (544, 546): 1, (544, 559): -v**2/w,
        (544, 562): v**4/w**2, (544, 589): u*v*w, (544, 643): u*v**2,
        (545, 238): -v**2, (545, 400): -u*v**2, (545, 544): 1, (545,
        545): v/w, (545, 559): v, (545, 562): -v**3/w, (545, 643):
        -v**3, (546, 400): -u*v, (546, 545): 1/w, (547, 238):
        -u*v**2/w, (547, 400): -u**2*v**2/w, (547, 543): 1, (547,
        547): v/w, (547, 559): u*v/w, (547, 562): -u*v**3/w**2, (547,
        643): -u*v**3/w, (548, 238): -u*v/w, (548, 400): -u**2*v/w,
        (548, 547): 1/w, (548, 559): u/w, (548, 562): -u*v**2/w**2,
        (548, 643): -u*v**2/w, (549, 225): 1, (549, 549): v/w, (549,
        630): v, (550, 109): v**2/w, (550, 163): v, (550, 217):
        v**3/w**2, (550, 227): 1, (550, 346): -v**2, (550, 400):
        -v**2, (550, 481): -v*w, (550, 487): v**3/w**2, (550, 514):
        v**2/w, (550, 541): v**4/w**3, (550, 551): v/w, (550, 558):
        -u/w, (550, 568): v**3/w, (550, 595): v**2, (550, 622):
        v**4/w**2, (550, 632): v, (551, 82): -u*v, (551, 190):
        -u*v**2/w, (551, 325): -u*v**3/w**2, (551, 396): 1, (551,
        460): -u*v**2/w, (551, 541): -u*v**2/w**2, (551, 568):
        -u**2*v**2/w, (551, 622): -u**2*v**3/w**2, (552, 228): 1,
        (552, 552): v/w, (552, 633): v, (553, 229): 1, (553, 553):
        v/w, (553, 634): v, (554, 231): 1, (554, 326): -u, (554, 346):
        -u*v**2/w, (554, 353): -u*v, (554, 400): -u*v**2/w, (554,
        481): -u*v, (554, 535): u**2, (554, 555): v/w, (554, 557):
        -u/w, (554, 589): -u*w, (554, 636): v, (554, 643): -u*v, (555,
        238): u, (555, 380): u, (555, 395): 1, (555, 643): u*v, (556,
        232): 1, (556, 238): u**2/w, (556, 508): -u**2/w, (556, 556):
        v/w, (556, 637): v, (556, 643): u**2*v/w, (557, 400): u*v,
        (557, 554): 1, (557, 557): v/w, (558, 109): -v, (558, 217):
        -v**2/w, (558, 400): v*w, (558, 487): -v**2/w, (558, 541):
        -v**3/w**2, (558, 550): 1, (558, 558): v/w, (558, 568): -v**2,
        (558, 622): -v**3/w, (559, 505): 1, (559, 559): v/w, (560,
        29): -v, (560, 164): -v**2/w, (560, 353): -u*v**2/w, (560,
        434): -v**2/w, (560, 508): -u*v/w, (560, 535): -u, (560, 542):
        -v**2/w**2, (560, 562): -u*v**2/w**2, (560, 565): -u/w, (560,
        566): 1, (561, 190): -u, (561, 325): -u*v/w, (561, 508): -v,
        (561, 514): -u*v/w, (561, 562): -v**2/w, (561, 563): -u/w,
        (561, 564): 1, (561, 622): -u**2*v/w, (562, 508): 1, (562,
        562): v/w, (563, 514): u, (563, 561): 1, (563, 562): v, (563,
        563): v/w, (564, 563): 1/w, (565, 542): v/w, (565, 560): 1,
        (565, 562): u*v/w, (565, 565): v/w, (566, 562): u/w, (566,
        565): 1/w, (567, 351): -v/w, (567, 378): 1/w, (568, 487):
        -v/w**2, (568, 514): (-u*v + w)/w**2, (569, 110): 1/w, (569,
        434): u/w, (569, 569): v/w, (570, 292): -u*v*(u*v - w)/w**2,
        (570, 370): u*v**2/w**2, (570, 373): -u**2*v**2*(u*v -
        w)/w**3, (570, 397): -u*v/w**2, (570, 454): -u*v**2*(u*v -
        w)/w**3, (570, 478): -u/w, (570, 574): -u/w, (570, 575): 1,
        (570, 586): -u**2/w, (570, 616): -u**2*v*(u*v - w)/w**2, (571,
        292): -u*v**2/w, (571, 346): u*v/w, (571, 370): v**2/w, (571,
        373): -u*v**2*(u*v - w)/w**2, (571, 397): -v/w, (571, 454):
        -v**2*(u*v - w)/w**2, (571, 572): -u/w, (571, 573): 1, (571,
        616): -u**2*v**2/w, (571, 643): u**2*v/w, (572, 571): 1, (572,
        572): v/w, (572, 586): v, (572, 616): v**2*(u*v - w)/w, (573,
        572): 1/w, (573, 616): u*v**2/w, (573, 643): -u*v/w, (574,
        570): 1, (574, 574): v/w, (574, 586): u*v/w, (574, 616):
        u*v**2*(u*v - w)/w**2, (575, 574): 1/w, (575, 586): u/w, (575,
        616): u*v*(u*v - w)/w**2, (576, 603): 1, (576, 630): -u/w,
        (577, 82): v/w, (577, 373): v*(u*v - w)/w, (577, 454): v**2/w,
        (577, 460): v**2/w**2, (577, 514): -v**3/w**3, (577, 541):
        v**2/w**3, (577, 568): u*v**2/w**2, (577, 585): -u/w, (577,
        595): u*v/w, (577, 605): 1, (577, 622): -u**2*v/w**2, (577,
        632): -u/w, (578, 487): u*v**2/w**3, (578, 514): u*v*(u*v -
        w)/w**3, (578, 612): -v/w, (578, 639): 1/w, (579, 606): 1,
        (579, 633): -u/w, (580, 607): 1, (580, 634): -u/w, (581, 245):
        -u, (581, 292): u*v/w, (581, 299): u**2/w, (581, 346): -u/w,
        (581, 373): u*v*(u*v - w)/w**2, (581, 454): u*v**2/w**2, (581,
        481): u**2/w, (581, 584): -u/w, (581, 589): u**3/w, (581,
        609): 1, (581, 616): u**2*v/w, (581, 636): -u/w, (581, 643):
        -u**2/w, (582, 589): -u*v/w, (582, 596): -u*v/w, (582, 611):
        -v/w, (582, 616): u, (582, 623): u/w, (582, 638): 1/w, (582,
        643): -u**2/w, (583, 373): u**2*v/w**2, (583, 400):
        -u**2/w**2, (583, 610): 1, (583, 616): u**2/w, (583, 637):
        -u/w, (583, 643): -u**3/w**2, (584, 581): 1, (584, 584): v/w,
        (584, 616): -u*v**2/w, (584, 643): u*v/w, (585, 514):
        v**2/w**2, (585, 541): -v/w**2, (585, 577): 1, (585, 585):
        v/w, (585, 616): -v**2, (585, 643): v, (586, 370): -v/w, (586,
        397): 1/w, (587, 110): -v/w**2, (587, 373): u*v**2/w**2, (587,
        400): -u*v/w**2, (587, 434): -u*v/w**2, (587, 481): -u/w,
        (587, 569): -v**2/w**2, (587, 589): -u**2/w, (587, 592): -u/w,
        (587, 593): 1, (588, 271): -u/w, (588, 325): u**2/w**2, (588,
        373): v**2/w, (588, 400): -v/w, (588, 590): -u/w, (588, 591):
        1, (588, 595): -u**2/w, (588, 622): u**3/w**2, (589, 373):
        -v/w, (589, 400): 1/w, (590, 460): u/w, (590, 568): u**2/w,
        (590, 588): 1, (590, 589): v, (590, 590): v/w, (591, 590):
        1/w, (592, 569): v/w, (592, 587): 1, (592, 589): u*v/w, (592,
        592): v/w, (593, 589): u/w, (593, 592): 1/w, (594, 351): u/w,
        (594, 432): 1/w, (595, 487): u/w**2, (595, 514): (u**2 -
        v)/w**2, (595, 541): w**(-2), (596, 164): 1/w, (596, 353):
        u/w, (596, 596): v/w, (597, 289): -u/w, (597, 292):
        u**3*v/w**2, (597, 346): u*v/w**2, (597, 370): -u**2*v/w**2,
        (597, 373): u*v**2*(u**3 - u*v + w)/w**3, (597, 400):
        u**2*v**2/w**3, (597, 451): -u*v/w**2, (597, 454):
        u**3*v**2/w**3, (597, 481): u**2*v/w**2, (597, 589):
        u**3*v/w**2, (597, 601): -u/w, (597, 602): 1, (597, 613):
        -u**2/w, (597, 616): u**4*v/w**2, (597, 643): u**2*v/w**2,
        (598, 292): u**2*v/w, (598, 370): -u*v/w, (598, 373):
        v**2*(u**3 - u*v + w)/w**2, (598, 400): u*v**2/w**2, (598,
        451): -v/w, (598, 454): u**2*v**2/w**2, (598, 481): u*v/w,
        (598, 589): u**2*v/w, (598, 599): -u/w, (598, 600): 1, (598,
        616): u**3*v/w, (599, 589): -u*v**2/w, (599, 598): 1, (599,
        599): v/w, (599, 613): v, (599, 616): -u**2*v**2/w, (599,
        643): -v**2/w, (600, 589): -u*v/w, (600, 599): 1/w, (600,
        616): -u**2*v/w, (601, 589): -u**2*v**2/w**2, (601, 597): 1,
        (601, 601): v/w, (601, 613): u*v/w, (601, 616):
        -u**3*v**2/w**2, (601, 643): -u*v**2/w**2, (602, 589):
        -u**2*v/w**2, (602, 601): 1/w, (602, 613): u/w, (602, 616):
        -u**3*v/w**2, (602, 643): -u*v/w**2, (603, 630): 1/w, (604,
        136): v/w, (604, 271): v**2/w**2, (604, 373): -v*(u**2 - v)/w,
        (604, 400): -v/w, (604, 454): -u*v/w, (604, 487): v**2/w**3,
        (604, 514): u*v**2/w**3, (604, 595): u*v**2/w**2, (604, 612):
        -u/w, (604, 622): u*v/w**2, (604, 632): 1/w, (605, 487):
        -u**2*v/w**3, (605, 514): -u*v*(u**2 - v)/w**3, (605, 541):
        -u*v/w**3, (605, 585): 1/w, (605, 612): u/w, (606, 633): 1/w,
        (607, 634): 1/w, (608, 299): -u/w, (608, 373): -u*v*(u**2 -
        v)/w**2, (608, 400): -u*v/w**2, (608, 454): -u**2*v/w**2,
        (608, 481): -u/w, (608, 589): -u**2/w, (608, 611): -u/w, (608,
        636): 1/w, (609, 569): u/w, (609, 584): 1/w, (609, 596):
        u**2/w, (609, 611): u/w, (609, 616): -u*v/w, (609, 643): u/w,
        (610, 373): -u**3/w**2, (610, 454): -u**2/w**2, (610, 637):
        1/w, (610, 643): u**2/w**2, (611, 589): u*v/w, (611, 608): 1,
        (611, 611): v/w, (611, 616): u**2*v/w, (612, 487): -v/w**2,
        (612, 514): -u*v/w**2, (612, 589): v, (612, 604): 1, (612,
        612): v/w, (612, 616): u*v, (613, 370): u/w, (613, 451): 1/w,
        (614, 164): -v/w**2, (614, 292): -u/w, (614, 353): -u*v/w**2,
        (614, 373): -u**2*v/w**2, (614, 454): -u*v/w**2, (614, 596):
        -v**2/w**2, (614, 616): -u**2/w, (614, 619): -u/w, (614, 620):
        1, (615, 325): -u/w**2, (615, 373): -u*v/w, (615, 454): -v/w,
        (615, 617): -u/w, (615, 618): 1, (615, 622): -u**2/w**2, (616,
        373): u/w, (616, 454): 1/w, (617, 271): u/w, (617, 595):
        u**2/w, (617, 615): 1, (617, 616): v, (617, 617): v/w, (618,
        617): 1/w, (619, 596): v/w, (619, 614): 1, (619, 616): u*v/w,
        (619, 619): v/w, (620, 616): u/w, (620, 619): 1/w, (621, 351):
        1, (622, 487): 1/w, (622, 514): u/w, (623, 218): 1/w, (623,
        380): u/w, (623, 623): v/w, (624, 292): u**2*v/w, (624, 343):
        -u/w, (624, 346): u*v**2/w**2, (624, 370): -u*v/w, (624, 373):
        u**3*v**2/w**2, (624, 400): u*v**2/w**2, (624, 454):
        u**2*v**2/w**2, (624, 481): u*v/w, (624, 589): u**2*v/w, (624,
        616): u**3*v/w, (624, 628): -u/w, (624, 629): 1, (624, 640):
        -u**2/w, (624, 643): u**2*v**2/w**2, (625, 292): u*v, (625,
        370): -v, (625, 373): u**2*v**2/w, (625, 400): v**2/w, (625,
        454): u*v**2/w, (625, 616): u**2*v, (625, 626): -u/w, (625,
        627): 1, (626, 589): -v**2, (626, 616): -u*v**2, (626, 625):
        1, (626, 626): v/w, (626, 640): v, (626, 643): -v**3/w, (627,
        616): -u*v, (627, 626): 1/w, (628, 589): -u*v**2/w, (628,
        616): -u**2*v**2/w, (628, 624): 1, (628, 628): v/w, (628,
        640): u*v/w, (628, 643): -u*v**3/w**2, (629, 589): -u*v/w,
        (629, 616): -u**2*v/w, (629, 628): 1/w, (629, 640): u/w, (629,
        643): -u*v**2/w**2, (630, 576): 1, (630, 630): v/w, (631,
        190): v/w, (631, 325): v**2/w**2, (631, 373): -u*v, (631,
        454): -v, (631, 514): v**2/w**2, (631, 568): u*v/w, (631,
        578): 1, (631, 622): 2*u*v**2/w**2, (631, 632): v/w, (631,
        639): -u/w, (632, 487): -u*v/w**2, (632, 514): -u**2*v/w**2,
        (632, 612): 1, (633, 579): 1, (633, 633): v/w, (634, 580): 1,
        (634, 634): v/w, (635, 292): -u, (635, 299): -u*v/w, (635,
        346): u**2/w, (635, 373): -u**2*v/w, (635, 407): -u, (635,
        454): -u*v/w, (635, 582): 1, (635, 616): -u**2, (635, 636):
        v/w, (635, 638): -u/w, (635, 643): u**3/w, (636, 589): u,
        (636, 596): u, (636, 611): 1, (637, 373): -u**2/w, (637, 583):
        1, (637, 589): u**2/w, (637, 637): v/w, (637, 643):
        u**2*v/w**2, (638, 616): u*v, (638, 635): 1, (638, 638): v/w,
        (639, 514): -v/w, (639, 616): v*w, (639, 631): 1, (639, 639):
        v/w, (640, 370): 1, (641, 218): -v/w**2, (641, 346): -u/w,
        (641, 373): -u*v/w, (641, 380): -u*v/w**2, (641, 623):
        -v**2/w**2, (641, 643): -u**2/w, (641, 646): -u/w, (641, 647):
        1, (642, 325): -u*v/w**2, (642, 373): -v, (642, 460): -u/w,
        (642, 568): -u**2/w, (642, 622): -u**2*v/w**2, (642, 644):
        -u/w, (642, 645): 1, (643, 373): 1, (644, 325): u/w, (644,
        622): u**2/w, (644, 642): 1, (644, 643): v, (644, 644): v/w,
        (645, 644): 1/w, (646, 623): v/w, (646, 641): 1, (646, 643):
        u*v/w, (646, 646): v/w, (647, 643): u/w, (647, 646): 1/w},
        {(0, 3): 1, (0, 4): -u/w, (1, 1): v/w, (1, 45): -v/w, (1, 72):
        1/w, (2, 269): v**2, (2, 296): -v, (2, 323): -u*v**2/w, (2,
        350): u*v/w, (2, 377): -v, (2, 404): u*v/w, (2, 539): 1, (2,
        566): -u/w, (2, 593): -v, (3, 4): 1/w, (4, 0): 1, (4, 4): v/w,
        (5, 86): 1, (5, 113): -u/w, (6, 6): v/w, (6, 88): 1, (6, 103):
        u*v**2/w, (6, 115): -u/w, (6, 130): -u**2*v**2/w**2, (6, 157):
        v**3/w, (6, 184): -u*v**3/w**2, (6, 211): -v**2/w, (6, 238):
        u*v**2/w**2, (6, 427): u*v*(u*v - w)/w, (6, 454): -u**2*v*(u*v
        - w)/w**2, (6, 616): u**2*v**2*(u*v - w)/w**2, (6, 643):
        -u**2*v*(u*v - w)/w**2, (7, 19): 1, (7, 87): u*v/w, (7, 114):
        -u/w, (7, 265): u*v**3/w, (7, 292): -u*v**2/w, (7, 319):
        -u*v**2/w, (7, 346): u*v/w, (7, 373): -u**2*v**3/w**2, (7,
        400): u**2*v**2/w**2, (7, 535): u**2*v**2/w**2, (7, 562):
        -u**2*v/w**2, (7, 589): -u**2*v**3/w**2, (7, 616):
        -u**2*v**2*(u*v - w)/w**2, (8, 89): 1, (8, 116): -u/w, (9,
        90): 1, (9, 117): -u/w, (10, 28): u*v/w, (10, 55):
        -u**2*v/w**2, (10, 91): 1, (10, 99): v/w, (10, 118): -u/w,
        (10, 126): -u*v/w**2, (10, 266): -v, (10, 293): u*v/w, (10,
        320): u*v/w, (10, 347): -u**2*v/w**2, (10, 374): u*v/w, (10,
        401): -u**2*v/w**2, (10, 536): -u**2*v/w**2, (10, 563):
        u**3*v/w**3, (10, 590): u*v/w, (11, 1): -u**2/w, (11, 11):
        v/w, (11, 45): u*v**2/w**2, (11, 72): -u*v/w**2, (11, 94): 1,
        (11, 121): -u/w, (11, 157): -v**2, (11, 184): u*v**2/w, (11,
        211): v, (11, 238): -u*v/w, (11, 428): u, (11, 455): -u**2/w,
        (11, 482): -u**2/w, (11, 509): u**3/w**2, (11, 617): u**2*v/w,
        (11, 644): -u**2/w, (12, 12): v/w, (12, 95): 1, (12, 98): v/w,
        (12, 122): -u/w, (12, 125): -u*v/w**2, (12, 157): -u*v**2/w,
        (12, 160): -v**2/w, (12, 184): u**2*v**2/w**2, (12, 187):
        u*v**2/w**2, (12, 211): u*v/w, (12, 214): v/w, (12, 238):
        -u**2*v/w**2, (12, 241): -u*v/w**2, (12, 427): -u*v**2/w, (12,
        454): u**2*v**2/w**2, (12, 481): u*v/w, (12, 508):
        -u**2*v/w**2, (12, 616): -u**2*v**3/w**2, (12, 643):
        u**2*v**2/w**2, (13, 21): 1, (13, 92): u*v/w, (13, 119): -u/w,
        (13, 423): u**2*v**2/w**2, (13, 450): -u**2*v/w**2, (13, 477):
        -u**2*v/w**2, (13, 504): u**2/w**2, (13, 612): u**2*v**2/w**2,
        (13, 639): -u**2*v/w**2, (14, 20): 1, (14, 93): u*v/w, (14,
        120): -u/w, (14, 268): -u*v**2/w, (14, 269): u*v**3/w, (14,
        295): u*v/w, (14, 296): -u*v**2/w, (14, 322): u**2*v**2/w**2,
        (14, 323): -u**2*v**3/w**2, (14, 349): -u**2*v/w**2, (14,
        350): u**2*v**2/w**2, (14, 376): u**2*v**2/w**2, (14, 377):
        -u*v**2/w, (14, 403): -u**3*v**2/w**3, (14, 404):
        u**2*v**2/w**2, (14, 538): -u**2*v/w**2, (14, 539): u*v/w,
        (14, 565): u**3*v/w**3, (14, 566): -u**2*v/w**2, (14, 592):
        u**2*v**2/w**2, (14, 593): -u*v**2/w, (15, 53): u*v**2/w, (15,
        80): -u*v/w, (15, 96): 1, (15, 103): u**2*v/w, (15, 123):
        -u/w, (15, 130): -u**3*v/w**2, (15, 422): u*v/w, (15, 427):
        u**2*(u*v - w)/w, (15, 430): u**2*v/w, (15, 431): -u*v, (15,
        449): -u**2*v/w**2, (15, 454): -u**3*(u*v - w)/w**2, (15,
        457): -u**3*v/w**2, (15, 458): u**2*v/w, (15, 476): -u/w, (15,
        484): -u**2/w, (15, 485): u, (15, 503): u**2/w**2, (15, 511):
        u**3/w**2, (15, 512): -u**2/w, (15, 611): u**2*v**2/w**2, (15,
        616): u**3*v*(u*v - w)/w**2, (15, 619): u**3*v**2/w**2, (15,
        620): -u**2*v**2/w, (15, 638): -u**2*v/w**2, (15, 643):
        -u**3*(u*v - w)/w**2, (15, 646): -u**3*v/w**2, (15, 647):
        u**2*v/w, (16, 97): 1, (16, 103): u**2/w, (16, 124): -u/w,
        (16, 130): -u**3/w**2, (16, 265): u**2*v/w, (16, 292):
        -u**2/w, (16, 319): -u**3*v/w**2, (16, 346): u**3/w**2, (16,
        373): -u**3*v/w**2, (16, 400): u**4*v/w**3, (16, 535):
        u**3/w**2, (16, 562): -u**4/w**3, (16, 589): -u**3*v/w**2,
        (17, 2): 1, (17, 268): u*v, (17, 269): -u*v**2, (17, 295): -u,
        (17, 296): u*v, (17, 322): -u**2*v/w, (17, 323): u**2*v**2/w,
        (17, 349): u**2/w, (17, 350): -u**2*v/w, (17, 376): -u**2*v/w,
        (17, 377): u*v, (17, 403): u**3*v/w**2, (17, 404): -u**2*v/w,
        (17, 427): u*v, (17, 454): -u**2*v/w, (17, 481): -u, (17,
        508): u**2/w, (17, 538): u**2/w, (17, 539): -u, (17, 565):
        -u**3/w**2, (17, 566): u**2/w, (17, 592): -u**2*v/w, (17,
        593): u*v, (17, 616): u**2*v**2/w, (17, 643): -u**2*v/w, (18,
        28): -u, (18, 55): u**2/w, (18, 266): w, (18, 293): -u, (18,
        320): -u, (18, 347): u**2/w, (18, 374): -u, (18, 401): u**2/w,
        (18, 536): u**2/w, (18, 563): -u**3/w**2, (18, 590): -u, (19,
        87): -v/w, (19, 114): 1/w, (19, 265): -v**3/w, (19, 292):
        v**2/w, (19, 319): u*v**3/w**2, (19, 346): -u*v**2/w**2, (19,
        373): u*v**3/w**2, (19, 400): -u**2*v**3/w**3, (19, 535):
        -u*v**2/w**2, (19, 562): u**2*v**2/w**3, (19, 589):
        u*v**3/w**2, (20, 93): -v/w, (20, 120): 1/w, (20, 265):
        u*v**2/w, (20, 268): v**2/w, (20, 269): -v**3/w, (20, 292):
        -u*v/w, (20, 295): -v/w, (20, 296): v**2/w, (20, 319):
        -u**2*v**2/w**2, (20, 322): -u*v**2/w**2, (20, 323):
        u*v**3/w**2, (20, 346): u**2*v/w**2, (20, 349): u*v/w**2, (20,
        350): -u*v**2/w**2, (20, 373): -u**2*v**2/w**2, (20, 376):
        -u*v**2/w**2, (20, 377): v**2/w, (20, 400): u**3*v**2/w**3,
        (20, 403): u**2*v**2/w**3, (20, 404): -u*v**2/w**2, (20, 535):
        u**2*v/w**2, (20, 538): u*v/w**2, (20, 539): -v/w, (20, 562):
        -u**3*v/w**3, (20, 565): -u**2*v/w**3, (20, 566): u*v/w**2,
        (20, 589): -u**2*v**2/w**2, (20, 592): -u*v**2/w**2, (20,
        593): v**2/w, (21, 92): -v/w, (21, 119): 1/w, (21, 265): v**2,
        (21, 292): -v, (21, 319): -u*v**2/w, (21, 346): u*v/w, (21,
        373): -u*v**2/w, (21, 400): u**2*v**2/w**2, (21, 423):
        -u*v**2/w**2, (21, 450): u*v/w**2, (21, 477): u*v/w**2, (21,
        504): -u/w**2, (21, 535): u*v/w, (21, 562): -u**2*v/w**2, (21,
        589): -u*v**2/w, (21, 612): -u*v**2/w**2, (21, 639): u*v/w**2,
        (22, 265): -v, (22, 292): 1, (22, 319): u*v/w, (22, 346):
        -u/w, (22, 373): u*v/w, (22, 400): -u**2*v/w**2, (22, 535):
        -u/w, (22, 562): u**2/w**2, (22, 589): u*v/w, (23, 136):
        v**2/w, (23, 163): -v/w, (23, 190): -v/w, (23, 217): 1/w, (24,
        51): 1, (24, 78): -u/w, (25, 268): -v, (25, 295): 1, (25,
        322): u*v/w, (25, 349): -u/w, (25, 376): u*v/w, (25, 403):
        -u**2*v/w**2, (25, 538): -u/w, (25, 565): u**2/w**2, (25,
        592): u*v/w, (26, 26): v/w, (26, 157): -u*v/w, (26, 184):
        u**2*v/w**2, (26, 211): u**2*v/w**2, (26, 238): -u**3*v/w**3,
        (26, 260): -v/w, (26, 265): -u*(u*v - w)/w, (26, 268): -u*v/w,
        (26, 287): 1/w, (26, 295): u/w, (26, 314): u*v/w**2, (26,
        319): u**2*(u*v - w)/w**2, (26, 322): u**2*v/w**2, (26, 341):
        -u/w**2, (26, 349): -u**2/w**2, (26, 368): u*v/w**2, (26,
        373): u**2*(u*v - w)/w**2, (26, 376): u**2*v/w**2, (26, 395):
        -u**2*v/w**3, (26, 400): -u**3*(u*v - w)/w**3, (26, 403):
        -u**3*v/w**3, (26, 530): -u/w**2, (26, 538): -u**2/w**2, (26,
        557): u**2/w**3, (26, 565): u**3/w**3, (26, 584): u*v/w**2,
        (26, 589): u**2*(u*v - w)/w**2, (26, 592): u**2*v/w**2, (27,
        30): 1, (27, 31): -u/w, (28, 18): 1/w, (28, 28): v/w, (28,
        45): u/w, (29, 323): v**2/w, (29, 350): -v/w, (29, 404): -v/w,
        (29, 566): 1/w, (29, 620): -v, (30, 31): 1/w, (31, 27): 1,
        (31, 31): v/w, (32, 140): 1, (32, 167): -u/w, (33, 33): v/w,
        (33, 103): -v**2/w, (33, 130): u*v**2/w**2, (33, 142): 1, (33,
        169): -u/w, (33, 265): u*v*(u*v - w)/w, (33, 373):
        -u**2*v*(u*v - w)/w**2, (33, 589): -u**2*v*(u*v - w)/w**2,
        (33, 616): -u**3*v*(u*v - w)/w**2, (34, 46): 1, (34, 141):
        u*v/w, (34, 168): -u/w, (34, 265): -u**2*v**2/w, (34, 292):
        u**2*v/w, (34, 373): u**3*v**2/w**2, (34, 427): -u*v**2/w,
        (34, 454): u**2*v**2/w**2, (34, 481): u*v/w, (34, 508):
        -u**2*v/w**2, (34, 535): -u**3*v/w**2, (34, 589):
        u**3*v**2/w**2, (34, 616): u**2*v**2*(u**2 - v)/w**2, (34,
        643): u**2*v**2/w**2, (35, 143): 1, (35, 170): -u/w, (36,
        144): 1, (36, 171): -u/w, (37, 55): u*v/w**2, (37, 145): 1,
        (37, 153): v/w, (37, 172): -u/w, (37, 180): -u*v/w**2, (37,
        320): -v/w, (37, 347): u*v/w**2, (37, 401): u*v/w**2, (37,
        563): -u**2*v/w**3, (37, 617): u*v/w, (38, 18): -u*v/w**2,
        (38, 28): -u**2/w, (38, 38): v/w, (38, 45): -u**2*v/w**2, (38,
        103): v, (38, 130): -u*v/w, (38, 148): 1, (38, 157): u*v, (38,
        175): -u/w, (38, 184): -u**2*v/w, (38, 266): u, (38, 293):
        -u**2/w, (38, 374): -u**2/w, (38, 536): u**3/w**2, (38, 590):
        -u**2/w, (38, 617): -u**3/w, (39, 39): v/w, (39, 103): u*v/w,
        (39, 106): v/w, (39, 130): -u**2*v/w**2, (39, 133): -u*v/w**2,
        (39, 149): 1, (39, 152): v/w, (39, 157): u**2*v/w, (39, 160):
        u*v/w, (39, 176): -u/w, (39, 179): -u*v/w**2, (39, 184):
        -u**3*v/w**2, (39, 187): -u**2*v/w**2, (39, 265): -u*v**2/w,
        (39, 292): u*v/w, (39, 373): u**2*v**2/w**2, (39, 535):
        -u**2*v/w**2, (39, 589): u**2*v**2/w**2, (39, 616):
        u**3*v**2/w**2, (40, 48): 1, (40, 146): u*v/w, (40, 173):
        -u/w, (40, 261): u**2*v**2/w**2, (40, 288): -u**2*v/w**2, (40,
        369): -u**2*v/w**2, (40, 531): u**2/w**2, (40, 585):
        -u**2*v/w**2, (40, 612): -u**3*v/w**2, (41, 47): 1, (41, 147):
        u*v/w, (41, 174): -u/w, (41, 322): -u*v**2/w**2, (41, 323):
        u*v**3/w**2, (41, 349): u*v/w**2, (41, 350): -u*v**2/w**2,
        (41, 403): u**2*v**2/w**3, (41, 404): -u*v**2/w**2, (41, 565):
        -u**2*v/w**3, (41, 566): u*v/w**2, (41, 619): u**2*v**2/w**2,
        (41, 620): -u*v**2/w, (42, 26): -u*v/w, (42, 53): -u**2*v/w,
        (42, 150): 1, (42, 157): u**2*v/w, (42, 177): -u/w, (42, 184):
        -u**3*v/w**2, (42, 260): u*v/w, (42, 265): u**2*(u*v - w)/w,
        (42, 268): u**2*v/w, (42, 269): -u*v, (42, 287): -u/w, (42,
        295): -u**2/w, (42, 296): u, (42, 368): -u**2*v/w**2, (42,
        373): -u**3*(u*v - w)/w**2, (42, 376): -u**3*v/w**2, (42,
        377): u**2*v/w, (42, 530): u**2/w**2, (42, 538): u**3/w**2,
        (42, 539): -u**2/w, (42, 584): -u**2*v/w**2, (42, 589):
        -u**3*(u*v - w)/w**2, (42, 592): -u**3*v/w**2, (42, 593):
        u**2*v/w, (42, 611): -u**3*v/w**2, (42, 616): -u**4*(u*v -
        w)/w**2, (42, 619): -u**4*v/w**2, (42, 620): u**3*v/w, (43,
        151): 1, (43, 157): u**2/w, (43, 178): -u/w, (43, 184):
        -u**3/w**2, (43, 319): u**2*v/w**2, (43, 346): -u**2/w**2,
        (43, 400): -u**3*v/w**3, (43, 562): u**3/w**3, (43, 616):
        -u**3*v/w**2, (44, 29): 1, (44, 265): u*v, (44, 292): -u, (44,
        322): u*v/w, (44, 323): -u*v**2/w, (44, 349): -u/w, (44, 350):
        u*v/w, (44, 373): -u**2*v/w, (44, 403): -u**2*v/w**2, (44,
        404): u*v/w, (44, 535): u**2/w, (44, 565): u**2/w**2, (44,
        566): -u/w, (44, 589): -u**2*v/w, (44, 616): -u**3*v/w, (44,
        619): -u**2*v/w, (44, 620): u*v, (45, 55): -u/w, (45, 320): 1,
        (45, 347): -u/w, (45, 401): -u/w, (45, 563): u**2/w**2, (45,
        617): -u, (46, 141): -v/w, (46, 168): 1/w, (46, 319):
        -v**3/w**2, (46, 346): v**2/w**2, (46, 400): u*v**3/w**3, (46,
        562): -u*v**2/w**3, (46, 616): u*v**3/w**2, (47, 147): -v/w,
        (47, 174): 1/w, (47, 319): u*v**2/w**2, (47, 322): v**2/w**2,
        (47, 323): -v**3/w**2, (47, 346): -u*v/w**2, (47, 349):
        -v/w**2, (47, 350): v**2/w**2, (47, 400): -u**2*v**2/w**3,
        (47, 403): -u*v**2/w**3, (47, 404): v**2/w**2, (47, 562):
        u**2*v/w**3, (47, 565): u*v/w**3, (47, 566): -v/w**2, (47,
        616): -u**2*v**2/w**2, (47, 619): -u*v**2/w**2, (47, 620):
        v**2/w, (48, 146): -v/w, (48, 173): 1/w, (48, 261):
        -u*v**2/w**2, (48, 288): u*v/w**2, (48, 319): v**2/w, (48,
        346): -v/w, (48, 369): u*v/w**2, (48, 400): -u*v**2/w**2, (48,
        531): -u/w**2, (48, 562): u*v/w**2, (48, 585): u*v/w**2, (48,
        612): u**2*v/w**2, (48, 616): -u*v**2/w, (49, 319): -v/w, (49,
        346): 1/w, (49, 400): u*v/w**2, (49, 562): -u/w**2, (49, 616):
        u*v/w, (50, 82): -v/w, (50, 109): 1/w, (50, 136): -u*v/w, (50,
        163): u/w, (51, 78): 1/w, (52, 322): -v/w, (52, 349): 1/w,
        (52, 403): u*v/w**2, (52, 565): -u/w**2, (52, 619): u*v/w,
        (53, 53): v/w, (53, 211): -u*v/w**2, (53, 238): u**2*v/w**3,
        (53, 314): -v/w**2, (53, 319): -u*(u*v - w)/w**2, (53, 322):
        -u*v/w**2, (53, 341): w**(-2), (53, 349): u/w**2, (53, 395):
        u*v/w**3, (53, 400): u**2*(u*v - w)/w**3, (53, 403):
        u**2*v/w**3, (53, 557): -u/w**3, (53, 565): -u**2/w**3, (53,
        611): u*v/w**2, (53, 616): u**2*(u*v - w)/w**2, (53, 619):
        u**2*v/w**2, (54, 57): 1, (54, 58): -u/w, (55, 45): 1, (55,
        55): v/w, (56, 323): v**3/w, (56, 350): -v**2/w, (56, 404):
        -v**2/w, (56, 431): v**2, (56, 458): -v, (56, 485): -v, (56,
        512): 1, (56, 566): v/w, (56, 647): -v, (57, 58): 1/w, (58,
        54): 1, (58, 58): v/w, (59, 194): 1, (59, 221): -u/w, (60,
        60): v/w, (60, 157): -v**2, (60, 184): u*v**2/w, (60, 196): 1,
        (60, 211): u*v**2/w, (60, 223): -u/w, (60, 238):
        -u**2*v**2/w**2, (60, 319): u*v*(u*v - w)/w, (60, 400):
        -u**2*v*(u*v - w)/w**2, (60, 616): -u**2*v*(u*v - w)/w, (61,
        73): 1, (61, 195): u*v/w, (61, 222): -u/w, (61, 265): -u*v**2,
        (61, 292): u*v, (61, 373): u**2*v**2/w, (61, 535): -u**2*v/w,
        (61, 589): u**2*v**2/w, (61, 616): u**3*v**2/w, (62, 197): 1,
        (62, 224): -u/w, (63, 198): 1, (63, 225): -u/w, (64, 1):
        u*v/w, (64, 55): u*v**2/w**2, (64, 199): 1, (64, 207): v/w,
        (64, 226): -u/w, (64, 234): -u*v/w**2, (64, 320): -v**2/w,
        (64, 347): u*v**2/w**2, (64, 401): u*v**2/w**2, (64, 428): -v,
        (64, 455): u*v/w, (64, 482): u*v/w, (64, 509): -u**2*v/w**2,
        (64, 563): -u**2*v**2/w**3, (64, 644): u*v/w, (65, 45):
        -u*v/w, (65, 55): -u**2/w, (65, 65): v/w, (65, 157): v*w, (65,
        184): -u*v, (65, 202): 1, (65, 229): -u/w, (65, 320): u, (65,
        347): -u**2/w, (65, 401): -u**2/w, (65, 563): u**3/w**2, (65,
        617): -u**2, (66, 66): v/w, (66, 157): u*v, (66, 160): v, (66,
        184): -u**2*v/w, (66, 187): -u*v/w, (66, 203): 1, (66, 206):
        v/w, (66, 230): -u/w, (66, 233): -u*v/w**2, (66, 319):
        -u*v**2/w, (66, 346): u*v/w, (66, 400): u**2*v**2/w**2, (66,
        562): -u**2*v/w**2, (66, 616): u**2*v**2/w, (67, 75): 1, (67,
        200): u*v/w, (67, 227): -u/w, (67, 315): u**2*v**2/w**2, (67,
        342): -u**2*v/w**2, (67, 396): -u**2*v/w**2, (67, 558):
        u**2/w**2, (67, 612): -u**2*v/w, (68, 74): 1, (68, 201):
        u*v/w, (68, 228): -u/w, (68, 322): -u*v**3/w**2, (68, 323):
        u*v**4/w**2, (68, 349): u*v**2/w**2, (68, 350): -u*v**3/w**2,
        (68, 403): u**2*v**3/w**3, (68, 404): -u*v**3/w**2, (68, 430):
        -u*v**2/w, (68, 431): u*v**3/w, (68, 457): u**2*v**2/w**2,
        (68, 458): -u*v**2/w, (68, 484): u*v/w, (68, 485): -u*v**2/w,
        (68, 511): -u**2*v/w**2, (68, 512): u*v/w, (68, 565):
        -u**2*v**2/w**3, (68, 566): u*v**2/w**2, (68, 646):
        u**2*v**2/w**2, (68, 647): -u*v**2/w, (69, 53): -u*v, (69,
        204): 1, (69, 211): u**2*v/w, (69, 231): -u/w, (69, 238):
        -u**3*v/w**2, (69, 314): u*v/w, (69, 319): u**2*(u*v - w)/w,
        (69, 322): u**2*v/w, (69, 323): -u*v, (69, 341): -u/w, (69,
        349): -u**2/w, (69, 350): u, (69, 395): -u**2*v/w**2, (69,
        400): -u**3*(u*v - w)/w**2, (69, 403): -u**3*v/w**2, (69,
        404): u**2*v/w, (69, 557): u**2/w**2, (69, 565): u**3/w**2,
        (69, 566): -u**2/w, (69, 611): -u**2*v/w, (69, 616):
        -u**3*(u*v - w)/w, (69, 619): -u**3*v/w, (69, 620): u**2*v,
        (70, 205): 1, (70, 211): u**2/w, (70, 232): -u/w, (70, 238):
        -u**3/w**2, (70, 319): u**2*v**2/w**2, (70, 346):
        -u**2*v/w**2, (70, 400): -u**3*v**2/w**3, (70, 427): u**2*v/w,
        (70, 454): -u**3*v/w**2, (70, 481): -u**2/w, (70, 508):
        u**3/w**2, (70, 562): u**3*v/w**3, (70, 643): -u**3*v/w**2,
        (71, 56): 1, (71, 319): u*v, (71, 322): u*v**2/w, (71, 323):
        -u*v**3/w, (71, 346): -u, (71, 349): -u*v/w, (71, 350):
        u*v**2/w, (71, 400): -u**2*v/w, (71, 403): -u**2*v**2/w**2,
        (71, 404): u*v**2/w, (71, 430): u*v, (71, 431): -u*v**2, (71,
        457): -u**2*v/w, (71, 458): u*v, (71, 484): -u, (71, 485):
        u*v, (71, 511): u**2/w, (71, 512): -u, (71, 562): u**2/w, (71,
        565): u**2*v/w**2, (71, 566): -u*v/w, (71, 616): -u**2*v, (71,
        646): -u**2*v/w, (71, 647): u*v, (72, 1): -u, (72, 55):
        -u*v/w, (72, 320): v, (72, 347): -u*v/w, (72, 401): -u*v/w,
        (72, 428): w, (72, 455): -u, (72, 482): -u, (72, 509): u**2/w,
        (72, 563): u**2*v/w**2, (72, 644): -u, (73, 195): -v/w, (73,
        222): 1/w, (73, 319): -v**4/w**2, (73, 346): v**3/w**2, (73,
        400): u*v**4/w**3, (73, 427): -v**3/w, (73, 454): u*v**3/w**2,
        (73, 481): v**2/w, (73, 508): -u*v**2/w**2, (73, 562):
        -u*v**3/w**3, (73, 643): u*v**3/w**2, (74, 201): -v/w, (74,
        228): 1/w, (74, 319): u*v**3/w**2, (74, 322): v**3/w**2, (74,
        323): -v**4/w**2, (74, 346): -u*v**2/w**2, (74, 349):
        -v**2/w**2, (74, 350): v**3/w**2, (74, 400): -u**2*v**3/w**3,
        (74, 403): -u*v**3/w**3, (74, 404): v**3/w**2, (74, 427):
        u*v**2/w, (74, 430): v**2/w, (74, 431): -v**3/w, (74, 454):
        -u**2*v**2/w**2, (74, 457): -u*v**2/w**2, (74, 458): v**2/w,
        (74, 481): -u*v/w, (74, 484): -v/w, (74, 485): v**2/w, (74,
        508): u**2*v/w**2, (74, 511): u*v/w**2, (74, 512): -v/w, (74,
        562): u**2*v**2/w**3, (74, 565): u*v**2/w**3, (74, 566):
        -v**2/w**2, (74, 643): -u**2*v**2/w**2, (74, 646):
        -u*v**2/w**2, (74, 647): v**2/w, (75, 200): -v/w, (75, 227):
        1/w, (75, 315): -u*v**2/w**2, (75, 319): v**3/w, (75, 342):
        u*v/w**2, (75, 346): -v**2/w, (75, 396): u*v/w**2, (75, 400):
        -u*v**3/w**2, (75, 427): v**2, (75, 454): -u*v**2/w, (75,
        481): -v, (75, 508): u*v/w, (75, 558): -u/w**2, (75, 562):
        u*v**2/w**2, (75, 612): u*v/w, (75, 643): -u*v**2/w, (76,
        319): -v**2/w, (76, 346): v/w, (76, 400): u*v**2/w**2, (76,
        427): -v, (76, 454): u*v/w, (76, 481): 1, (76, 508): -u/w,
        (76, 562): -u*v/w**2, (76, 643): u*v/w, (77, 136): -v, (77,
        163): 1, (78, 24): 1, (78, 78): v/w, (79, 322): -v**2/w, (79,
        349): v/w, (79, 403): u*v**2/w**2, (79, 430): -v, (79, 457):
        u*v/w, (79, 484): 1, (79, 511): -u/w, (79, 565): -u*v/w**2,
        (79, 646): u*v/w, (80, 80): v/w, (80, 103): -u*v/w, (80, 130):
        u**2*v/w**2, (80, 211): -u*v**2/w**2, (80, 238):
        u**2*v**2/w**3, (80, 314): -v**2/w**2, (80, 319): -u*v*(u*v -
        w)/w**2, (80, 322): -u*v**2/w**2, (80, 341): v/w**2, (80,
        349): u*v/w**2, (80, 395): u*v**2/w**3, (80, 400): u**2*v*(u*v
        - w)/w**3, (80, 403): u**2*v**2/w**3, (80, 422): -v/w, (80,
        427): -u*(u*v - w)/w, (80, 430): -u*v/w, (80, 449): u*v/w**2,
        (80, 454): u**2*(u*v - w)/w**2, (80, 457): u**2*v/w**2, (80,
        476): 1/w, (80, 484): u/w, (80, 503): -u/w**2, (80, 511):
        -u**2/w**2, (80, 557): -u*v/w**3, (80, 565): -u**2*v/w**3,
        (80, 638): u*v/w**2, (80, 643): u**2*(u*v - w)/w**2, (80,
        646): u**2*v/w**2, (81, 84): 1, (81, 85): -u/w, (82, 82): v/w,
        (82, 423): -v/w, (82, 477): 1/w, (83, 161): -v, (83, 188):
        u*v/w, (83, 215): 1, (83, 242): -u/w, (83, 269): -u*v, (83,
        323): u**2*v/w, (83, 377): u**2*v/w, (83, 404): -u**2/w, (83,
        593): u, (84, 85): 1/w, (85, 81): 1, (85, 85): v/w, (86, 113):
        1/w, (87, 87): v/w, (87, 115): 1/w, (87, 130): u*v**2/w**2,
        (87, 265): v**3/w, (87, 319): -u*v**3/w**2, (87, 373):
        -u*v**3/w**2, (87, 400): u*v**2/w**2, (87, 454): u*v*(u*v -
        w)/w**2, (87, 589): -v**2/w, (87, 616): -u*v**2*(u*v -
        w)/w**2, (88, 6): -u/w, (88, 87): -u**2/w, (88, 100): 1, (88,
        157): -u*v**2/w, (88, 184): u**2*v**2/w**2, (88, 211):
        u**2*v**2/w**2, (88, 238): -u**2*v/w**2, (88, 265):
        -u**2*v**2/w, (88, 319): u**3*v**2/w**2, (88, 373):
        u**3*v**2/w**2, (88, 400): -u**3*v/w**2, (88, 589):
        u**3*v**2/w**2, (88, 616): u*v**2*(u*v - w)/w**2, (88, 643):
        u*v*(u*v - w)**2/w**3, (89, 116): 1/w, (90, 117): 1/w, (91,
        118): 1/w, (91, 126): v/w**2, (91, 293): -v/w, (91, 347):
        u*v/w**2, (91, 406): u*v/w, (91, 460): -u**2*v/w**2, (91,
        536): u*v/w**2, (91, 563): -u**2*v/w**3, (91, 622):
        u**2*v*(u*v - w)/w**3, (92, 82): -u**2/w, (92, 92): v/w, (92,
        121): 1/w, (92, 265): -v**2, (92, 319): u*v**2/w, (92, 373):
        u*v**2/w, (92, 400): -u*v/w, (92, 423): u*v**2/w**2, (92,
        455): u/w, (92, 477): -u*v/w**2, (92, 509): -u**2/w**2, (92,
        589): v, (92, 617): -u*v/w, (92, 644): u**2*v/w**2, (93, 93):
        v/w, (93, 122): 1/w, (93, 125): v/w**2, (93, 265): -u*v**2/w,
        (93, 268): -v**2/w, (93, 319): u**2*v**2/w**2, (93, 322):
        u*v**2/w**2, (93, 373): u**2*v**2/w**2, (93, 376):
        u*v**2/w**2, (93, 400): -u**2*v/w**2, (93, 403): -u*v/w**2,
        (93, 454): -u*v**2/w**2, (93, 508): u*v/w**2, (93, 589):
        u*v/w, (93, 592): v/w, (93, 616): u*v**3/w**2, (93, 643):
        -u*v**2/w**2, (94, 11): -u/w, (94, 45): -u**2*v/w**2, (94,
        72): u**2/w**2, (94, 92): -u**2/w, (94, 102): 1, (94, 423):
        -u**3*v/w**2, (94, 477): u**3/w**2, (95, 12): -u/w, (95, 93):
        -u**2/w, (95, 101): 1, (95, 160): u*v/w, (95, 161): -u*v**2/w,
        (95, 187): -u**2*v/w**2, (95, 188): u**2*v**2/w**2, (95, 214):
        -u**2*v/w**2, (95, 215): u*v/w, (95, 241): u**3*v/w**3, (95,
        242): -u**2*v/w**2, (95, 268): u**2*v/w, (95, 269):
        -u**2*v**2/w, (95, 322): -u**3*v/w**2, (95, 323):
        u**3*v**2/w**2, (95, 376): -u**3*v/w**2, (95, 377):
        u**3*v**2/w**2, (95, 403): u**4*v/w**3, (95, 404):
        -u**3*v/w**2, (95, 592): -u**3*v/w**2, (95, 593): u**2*v/w,
        (96, 123): 1/w, (96, 130): u**2*v/w**2, (96, 431): u*v**2/w,
        (96, 449): u*v/w**2, (96, 454): u**2*(u*v - w)/w**2, (96,
        457): u**2*v/w**2, (96, 458): -u*v/w, (96, 485): -u*v/w, (96,
        503): -u/w**2, (96, 511): -u**2/w**2, (96, 512): u/w, (96,
        611): -u*v**2/w**2, (96, 616): -u**2*v*(u*v - w)/w**2, (96,
        619): -u**2*v**2/w**2, (96, 620): u*v**2/w, (96, 638):
        u*v/w**2, (96, 646): u**2*v/w**2, (96, 647): -u*v/w, (97,
        124): 1/w, (97, 130): u**2/w**2, (97, 157): -u**2/w, (97,
        184): u**3/w**2, (97, 211): u**3/w**2, (97, 238): -u**4/w**3,
        (97, 265): -u**3/w, (97, 319): u**4/w**2, (97, 373):
        u**4/w**2, (97, 400): -u**5/w**3, (97, 589): u**4/w**2, (98,
        83): 1, (98, 160): -u, (98, 161): u*v, (98, 187): u**2/w, (98,
        188): -u**2*v/w, (98, 214): u**2/w, (98, 215): -u, (98, 241):
        -u**3/w**2, (98, 242): u**2/w, (98, 268): -u**2, (98, 269):
        u**2*v, (98, 322): u**3/w, (98, 323): -u**3*v/w, (98, 376):
        u**3/w, (98, 377): -u**3*v/w, (98, 403): -u**4/w**2, (98,
        404): u**3/w, (98, 454): u*v/w, (98, 508): -u/w, (98, 592):
        u**3/w, (98, 593): -u**2, (98, 616): -u*v**2/w, (98, 643):
        u*v/w, (99, 293): 1, (99, 347): -u/w, (99, 406): -u, (99,
        460): u**2/w, (99, 536): -u/w, (99, 563): u**2/w**2, (99,
        622): -u**2*(u*v - w)/w**2, (100, 6): 1/w, (100, 87): u/w,
        (100, 157): v**2/w, (100, 184): -u*v**2/w**2, (100, 211):
        -u*v**2/w**2, (100, 238): u**2*v**2/w**3, (100, 265):
        u*v**2/w, (100, 319): -u**2*v**2/w**2, (100, 373):
        -u**2*v**2/w**2, (100, 400): u**3*v**2/w**3, (100, 589):
        -u**2*v**2/w**2, (101, 12): 1/w, (101, 93): u/w, (101, 157):
        -u*v/w, (101, 160): -v/w, (101, 161): v**2/w, (101, 184):
        u**2*v/w**2, (101, 187): u*v/w**2, (101, 188): -u*v**2/w**2,
        (101, 211): u**2*v/w**2, (101, 214): u*v/w**2, (101, 215):
        -v/w, (101, 238): -u**3*v/w**3, (101, 241): -u**2*v/w**3,
        (101, 242): u*v/w**2, (101, 265): -u**2*v/w, (101, 268):
        -u*v/w, (101, 269): u*v**2/w, (101, 319): u**3*v/w**2, (101,
        322): u**2*v/w**2, (101, 323): -u**2*v**2/w**2, (101, 373):
        u**3*v/w**2, (101, 376): u**2*v/w**2, (101, 377):
        -u**2*v**2/w**2, (101, 400): -u**4*v/w**3, (101, 403):
        -u**3*v/w**3, (101, 404): u**2*v/w**2, (101, 589):
        u**3*v/w**2, (101, 592): u**2*v/w**2, (101, 593): -u*v/w,
        (102, 11): 1/w, (102, 45): u*v/w**2, (102, 72): -u/w**2, (102,
        92): u/w, (102, 157): -v, (102, 184): u*v/w, (102, 211):
        u*v/w, (102, 238): -u**2*v/w**2, (102, 265): -u*v, (102, 319):
        u**2*v/w, (102, 373): u**2*v/w, (102, 400): -u**3*v/w**2,
        (102, 423): u**2*v/w**2, (102, 477): -u**2/w**2, (102, 589):
        u**2*v/w, (103, 157): 1, (103, 184): -u/w, (103, 211): -u/w,
        (103, 238): u**2/w**2, (103, 265): u, (103, 319): -u**2/w,
        (103, 373): -u**2/w, (103, 400): u**3/w**2, (103, 589):
        -u**2/w, (104, 244): v**2/w, (104, 298): -v/w, (104, 352):
        -v/w, (104, 379): 1/w, (104, 568): -v/w, (105, 429): 1, (105,
        483): -u/w, (105, 645): u*(u*v - w)/w**2, (106, 160): 1, (106,
        187): -u/w, (106, 214): -u/w, (106, 241): u**2/w**2, (106,
        268): u, (106, 322): -u**2/w, (106, 376): -u**2/w, (106, 403):
        u**3/w**2, (106, 592): -u**2/w, (107, 107): v/w, (107, 152):
        1/w, (107, 157): u**2/w, (107, 160): u/w, (107, 179): -u/w**2,
        (107, 184): -u**3/w**2, (107, 187): -u**2/w**2, (107, 206):
        -u/w**2, (107, 211): -u**3/w**2, (107, 214): -u**2/w**2, (107,
        233): u**2/w**3, (107, 238): u**4/w**3, (107, 241): u**3/w**3,
        (107, 260): u/w, (107, 265): u*(u**2 - v)/w, (107, 268):
        u**2/w, (107, 292): u/w, (107, 314): -u**2/w**2, (107, 319):
        -u**2*(u**2 - v)/w**2, (107, 322): -u**3/w**2, (107, 346):
        -u**2/w**2, (107, 368): -u**2/w**2, (107, 373): -u**2*(u**2 -
        v)/w**2, (107, 376): -u**3/w**2, (107, 395): u**3/w**3, (107,
        400): u**3*(u**2 - v)/w**3, (107, 403): u**4/w**3, (107, 535):
        -u**2/w**2, (107, 562): u**3/w**3, (107, 584): -u**2/w**2,
        (107, 589): -u**2*(u**2 - v)/w**2, (107, 592): -u**3/w**2,
        (108, 111): 1, (108, 112): -u/w, (109, 109): v/w, (109, 450):
        -v/w, (109, 504): 1/w, (109, 612): v**2/w, (109, 639): -v/w,
        (110, 269): -v*w, (110, 323): u*v, (110, 377): u*v, (110,
        404): -u, (110, 593): w, (111, 112): 1/w, (112, 108): 1, (112,
        112): v/w, (113, 5): 1, (113, 113): v/w, (114, 7): 1, (114,
        22): u*v**2/w, (114, 49): u*v*(u*v - w)/w, (114, 114): v/w,
        (114, 115): v/w, (114, 130): u*v**3/w**2, (114, 292): v**3/w,
        (114, 346): -u*v**3/w**2, (114, 373): -v**3*(u*v - w)/w**2,
        (114, 454): u*v**2*(u*v - w)/w**2, (114, 535): -v**2/w, (114,
        562): u*v**2/w**2, (114, 616): -u*v**3*(u*v - w)/w**2, (115,
        87): -u, (115, 127): 1, (115, 184): u*v**2*(u*v - w)/w**2,
        (115, 265): -u*v**2, (115, 319): u**2*v**2/w, (115, 373):
        u*v*(u**2*v**2 - u*v*w + w**2)/w**2, (115, 400): -u**2*v/w,
        (115, 589): u**2*v**2/w, (115, 616): u*v**3*(u*v - w)/w**2,
        (116, 8): 1, (116, 116): v/w, (117, 9): 1, (117, 117): v/w,
        (118, 10): 1, (118, 18): v/w, (118, 118): v/w, (118, 126):
        v**2/w**2, (118, 158): -v, (118, 185): u*v/w, (118, 212):
        u*v/w, (118, 239): -u**2*v/w**2, (118, 293): -v**2/w, (118,
        347): u*v**2/w**2, (118, 433): u*v/w, (118, 487):
        -u**2*v/w**2, (118, 536): u*v**2/w**2, (118, 563):
        -u**2*v**2/w**3, (118, 595): -u*v**2/w, (118, 622):
        u**2*v**2/w**2, (119, 13): 1, (119, 50): u, (119, 77):
        -u**2/w, (119, 109): -u**2/w, (119, 119): v/w, (119, 121):
        v/w, (119, 292): -v**2, (119, 346): u*v**2/w, (119, 373):
        v**2*(u*v - w)/w, (119, 450): u*v**2/w**2, (119, 455): u*v/w,
        (119, 504): -u*v/w**2, (119, 509): -u**2*v/w**2, (119, 535):
        v, (119, 562): -u*v/w, (119, 612): -u*v**3/w**2, (119, 617):
        -u*v**2/w, (119, 639): u*v**2/w**2, (119, 644):
        u**2*v**2/w**2, (120, 14): 1, (120, 17): v/w, (120, 49):
        -u*v**2/w, (120, 76): u*v/w, (120, 120): v/w, (120, 122): v/w,
        (120, 125): v**2/w**2, (120, 292): -u*v**2/w, (120, 295):
        -v**2/w, (120, 346): u**2*v**2/w**2, (120, 349): u*v**2/w**2,
        (120, 373): u*v**2*(u*v - w)/w**2, (120, 376): v**2*(u*v -
        w)/w**2, (120, 454): -u*v**3/w**2, (120, 508): u*v**2/w**2,
        (120, 535): u*v/w, (120, 538): v/w, (120, 562): -u**2*v/w**2,
        (120, 565): -u*v/w**2, (120, 616): u*v**4/w**2, (120, 643):
        -u*v**3/w**2, (121, 92): -u, (121, 129): 1, (121, 423):
        -u**2*v/w, (121, 477): u**2/w, (122, 93): -u, (122, 128): 1,
        (122, 268): u*v, (122, 269): -u*v**2, (122, 322): -u**2*v/w,
        (122, 323): u**2*v**2/w, (122, 376): -u**2*v/w, (122, 377):
        u**2*v**2/w, (122, 403): u**3*v/w**2, (122, 404): -u**2*v/w,
        (122, 592): -u**2*v/w, (122, 593): u*v, (123, 15): 1, (123,
        22): u**2*v/w, (123, 44): u*v/w, (123, 49): u**2*(u*v - w)/w,
        (123, 52): u**2*v/w, (123, 53): -u*v, (123, 71): -u/w, (123,
        79): -u**2/w, (123, 80): u, (123, 123): v/w, (123, 130):
        u**2*v**2/w**2, (123, 449): u*v**2/w**2, (123, 454):
        u**2*v*(u*v - w)/w**2, (123, 457): u**2*v**2/w**2, (123, 503):
        -u*v/w**2, (123, 511): -u**2*v/w**2, (123, 611): -u*v**3/w**2,
        (123, 616): -u**2*v**2*(u*v - w)/w**2, (123, 619):
        -u**2*v**3/w**2, (123, 638): u*v**2/w**2, (123, 646):
        u**2*v**2/w**2, (124, 16): 1, (124, 22): u**2/w, (124, 124):
        v/w, (124, 130): u**2*v/w**2, (124, 265): -u**2, (124, 319):
        u**3/w, (124, 373): u**3/w, (124, 400): -u**4/w**2, (124,
        589): u**3/w, (125, 49): u*v, (125, 76): -u, (125, 110): 1,
        (125, 268): -u*w, (125, 269): u*v*w, (125, 322): u**2, (125,
        323): -u**2*v, (125, 376): u**2, (125, 377): -u**2*v, (125,
        403): -u**3/w, (125, 404): u**2, (125, 454): u*v**2/w, (125,
        508): -u*v/w, (125, 592): u**2, (125, 593): -u*w, (125, 616):
        -u*v**3/w, (125, 643): u*v**2/w, (126, 158): w, (126, 185):
        -u, (126, 212): -u, (126, 239): u**2/w, (126, 293): v, (126,
        347): -u*v/w, (126, 433): -u, (126, 487): u**2/w, (126, 536):
        -u*v/w, (126, 563): u**2*v/w**2, (126, 595): u*v, (126, 622):
        -u**2*v/w, (127, 87): 1, (127, 265): v**2, (127, 319):
        -u*v**2/w, (127, 373): -u*v**2/w, (127, 400): u**2*v**2/w**2,
        (127, 589): -u*v**2/w, (128, 93): 1, (128, 265): -u*v, (128,
        268): -v, (128, 269): v**2, (128, 319): u**2*v/w, (128, 322):
        u*v/w, (128, 323): -u*v**2/w, (128, 373): u**2*v/w, (128,
        376): u*v/w, (128, 377): -u*v**2/w, (128, 400): -u**3*v/w**2,
        (128, 403): -u**2*v/w**2, (128, 404): u*v/w, (128, 589):
        u**2*v/w, (128, 592): u*v/w, (128, 593): -v, (129, 92): 1,
        (129, 265): -v*w, (129, 319): u*v, (129, 373): u*v, (129,
        400): -u**2*v/w, (129, 423): u*v/w, (129, 477): -u/w, (129,
        589): u*v, (130, 265): w, (130, 319): -u, (130, 373): -u,
        (130, 400): u**2/w, (130, 589): -u, (131, 271): v**2/w, (131,
        325): -v/w, (131, 514): -v/w, (131, 541): 1/w, (131, 595):
        v*(u*v - w)/w, (132, 456): 1, (132, 510): -u/w, (132, 618):
        -v, (132, 645): u*v/w, (133, 268): w, (133, 322): -u, (133,
        376): -u, (133, 403): u**2/w, (133, 592): -u, (134, 134): v/w,
        (134, 157): u, (134, 184): -u**2/w, (134, 211): -u**2/w, (134,
        238): u**3/w**2, (134, 260): 1, (134, 265): u**2, (134, 268):
        u, (134, 314): -u/w, (134, 319): -u**3/w, (134, 322): -u**2/w,
        (134, 368): -u/w, (134, 373): -u**3/w, (134, 376): -u**2/w,
        (134, 395): u**2/w**2, (134, 400): u**4/w**2, (134, 403):
        u**3/w**2, (134, 584): -u/w, (134, 589): -u**3/w, (134, 592):
        -u**2/w, (135, 138): 1, (135, 139): -u/w, (136, 136): v/w,
        (136, 261): -v/w, (136, 288): 1/w, (137, 107): 1, (137, 134):
        -u/w, (137, 161): u, (137, 188): -u**2/w, (137, 323): -u*v/w,
        (137, 377): -u**3/w, (137, 458): -u**2/w, (137, 620): u, (138,
        139): 1/w, (139, 135): 1, (139, 139): v/w, (140, 167): 1/w,
        (141, 141): v/w, (141, 169): 1/w, (141, 184): u*v**2/w**2,
        (141, 319): v**3/w**2, (141, 373): u*v*(2*u*v - w)/w**2, (141,
        454): u*v**2/w**2, (141, 589): u**2*v**2/w**2, (141, 616):
        v**2*(u**3 - w)/w**2, (141, 643): u*v**2/w**2, (142, 33):
        -u/w, (142, 130): -u**2*v/w**2, (142, 141): -u**2/w, (142,
        154): 1, (142, 184): -u**3*v/w**2, (142, 211): -u*v**2/w**2,
        (142, 319): -u**2*v**2/w**2, (142, 373): -u**4*v/w**2, (142,
        454): -u**3*v/w**2, (142, 589): -u*v*(2*u*v - w)/w**2, (142,
        616): -u**2*v*(u*v - w)/w**2, (142, 643): -u**2*v**3/w**3,
        (143, 170): 1/w, (144, 171): 1/w, (145, 172): 1/w, (145, 180):
        v/w**2, (145, 244): u*v/w, (145, 271): -u**2*v/w**2, (145,
        347): -v/w**2, (145, 563): u*v/w**3, (145, 568): -u**2*v/w**2,
        (145, 595): -u**3*v/w**2, (145, 622): -u**2*v**2/w**3, (146,
        136): -u**2/w, (146, 146): v/w, (146, 175): 1/w, (146, 261):
        u*v**2/w**2, (146, 288): -u*v/w**2, (146, 319): -v**2/w, (146,
        373): -u**2*v/w, (146, 374): u/w, (146, 454): -u*v/w, (146,
        536): -u**2/w**2, (146, 616): v, (146, 644): -u*v/w**2, (147,
        147): v/w, (147, 176): 1/w, (147, 179): v/w**2, (147, 319):
        -u*v**2/w**2, (147, 322): -v**2/w**2, (147, 373): -u*v*(u**2 +
        v)/w**2, (147, 376): -u**2*v/w**2, (147, 454): -u**2*v/w**2,
        (147, 457): -u*v/w**2, (147, 535): u*v/w**2, (147, 589):
        -u*v**2/w**2, (147, 616): -u*v*(u*v - w)/w**2, (147, 619):
        v/w, (148, 18): u**2/w**2, (148, 38): -u/w, (148, 45):
        u**3/w**2, (148, 146): -u**2/w, (148, 156): 1, (148, 261):
        -u**3*v/w**2, (148, 288): u**3/w**2, (149, 39): -u/w, (149,
        107): u*v/w, (149, 134): -u**2*v/w**2, (149, 147): -u**2/w,
        (149, 155): 1, (149, 161): u**2*v/w, (149, 188): -u**3*v/w**2,
        (149, 214): u*v/w**2, (149, 241): -u**2*v/w**3, (149, 322):
        u**2*v/w**2, (149, 323): -u**2*v**2/w**2, (149, 377):
        -u**4*v/w**2, (149, 403): -u**3*v/w**3, (149, 458):
        -u**3*v/w**2, (149, 619): -u**3*v/w**2, (149, 620): u**2*v/w,
        (150, 177): 1/w, (150, 184): u**2*v/w**2, (150, 269):
        u*v**2/w, (150, 296): -u*v/w, (150, 368): u*v/w**2, (150,
        373): u**2*(u*v - w)/w**2, (150, 376): u**2*v/w**2, (150,
        377): -u*v/w, (150, 530): -u/w**2, (150, 538): -u**2/w**2,
        (150, 539): u/w, (150, 584): u*v/w**2, (150, 589):
        u**3*v/w**2, (150, 592): u**2*v/w**2, (150, 593): -u*v/w,
        (150, 611): u**2*v/w**2, (150, 616): u**4*v/w**2, (150, 619):
        u**3*v/w**2, (150, 620): -u**2*v/w, (150, 643): u**2*v/w**2,
        (151, 178): 1/w, (151, 184): u**2/w**2, (151, 211):
        -u**2/w**2, (151, 238): u**3/w**3, (151, 319): -u**3/w**2,
        (151, 400): u**4/w**3, (151, 616): u**4/w**2, (152, 107): -u,
        (152, 134): u**2/w, (152, 137): 1, (152, 161): -u**2, (152,
        188): u**3/w, (152, 214): -u/w, (152, 241): u**2/w**2, (152,
        322): -u**2/w, (152, 323): u**2*v/w, (152, 373): u*v/w, (152,
        377): u**4/w, (152, 403): u**3/w**2, (152, 458): u**3/w, (152,
        535): -u/w, (152, 589): u*v/w, (152, 616): u**2*v/w, (152,
        619): u**3/w, (152, 620): -u**2, (153, 244): -u, (153, 271):
        u**2/w, (153, 347): 1/w, (153, 563): -u/w**2, (153, 568):
        u**2/w, (153, 595): u**3/w, (153, 622): u**2*v/w**2, (154,
        33): 1/w, (154, 141): u/w, (154, 211): v**2/w**2, (154, 238):
        -u*v**2/w**3, (154, 319): u*v**2/w**2, (154, 400):
        -u**2*v**2/w**3, (154, 616): -u**2*v**2/w**2, (155, 39): 1/w,
        (155, 107): -v/w, (155, 134): u*v/w**2, (155, 147): u/w, (155,
        161): -u*v/w, (155, 188): u**2*v/w**2, (155, 211): -u*v/w**2,
        (155, 214): -v/w**2, (155, 238): u**2*v/w**3, (155, 241):
        u*v/w**3, (155, 319): -u**2*v/w**2, (155, 322): -u*v/w**2,
        (155, 323): u*v**2/w**2, (155, 377): u**3*v/w**2, (155, 400):
        u**3*v/w**3, (155, 403): u**2*v/w**3, (155, 458): u**2*v/w**2,
        (155, 616): u**3*v/w**2, (155, 619): u**2*v/w**2, (155, 620):
        -u*v/w, (156, 18): -u/w**2, (156, 38): 1/w, (156, 45):
        -u**2/w**2, (156, 146): u/w, (156, 211): -v/w, (156, 238):
        u*v/w**2, (156, 261): u**2*v/w**2, (156, 288): -u**2/w**2,
        (156, 319): -u*v/w, (156, 400): u**2*v/w**2, (156, 616):
        u**2*v/w, (157, 211): 1/w, (157, 238): -u/w**2, (157, 319):
        u/w, (157, 400): -u**2/w**2, (157, 616): -u**2/w, (158, 244):
        -u*v/w, (158, 352): u/w, (158, 406): -v/w, (158, 433): 1/w,
        (158, 595): -v/w, (159, 267): 1, (159, 294): -u/w, (159, 591):
        -u/w, (159, 618): -u**2/w, (159, 645): -u*v/w**2, (160, 214):
        1/w, (160, 241): -u/w**2, (160, 322): u/w, (160, 403):
        -u**2/w**2, (160, 619): -u**2/w, (161, 161): v/w, (161, 206):
        w**(-2), (161, 211): u**2/w**2, (161, 214): u/w**2, (161,
        233): -u/w**3, (161, 238): -u**3/w**3, (161, 241): -u**2/w**3,
        (161, 314): u/w**2, (161, 319): u*(u**2 - v)/w**2, (161, 322):
        u**2/w**2, (161, 346): u/w**2, (161, 395): -u**2/w**3, (161,
        400): -u**2*(u**2 - v)/w**3, (161, 403): -u**3/w**3, (161,
        562): -u**2/w**3, (161, 611): -u**2/w**2, (161, 616):
        -u**2*(u**2 - v)/w**2, (161, 619): -u**3/w**2, (162, 165): 1,
        (162, 166): -u/w, (163, 163): v/w, (163, 369): -v/w, (163,
        531): 1/w, (163, 585): -v/w, (163, 612): -u*v/w, (164, 323):
        -v, (164, 377): -u**2, (164, 458): -u, (164, 620): w, (165,
        166): 1/w, (166, 162): 1, (166, 166): v/w, (167, 32): 1, (167,
        167): v/w, (168, 22): -u**2*v/w, (168, 34): 1, (168, 49):
        -u*v*(u**2 - v)/w, (168, 76): -u*v/w, (168, 168): v/w, (168,
        169): v/w, (168, 184): u*v**3/w**2, (168, 346): v**3/w**2,
        (168, 373): u*v**2*(2*u*v - w)/w**2, (168, 400): v**3/w**2,
        (168, 454): u*v**3/w**2, (168, 562): -v**2/w**2, (168, 589):
        u**2*v**3/w**2, (168, 616): u**3*v**3/w**2, (168, 643):
        u*v**3/w**2, (169, 130): -u**2*v**2/w**2, (169, 141): -u,
        (169, 181): 1, (169, 184): -u**3*v**2/w**2, (169, 238):
        -u*v**2/w**2, (169, 319): -u*v**2/w, (169, 373):
        -u**4*v**2/w**2, (169, 400): -u*v*(u*v - w)/w**2, (169, 454):
        -u**3*v**2/w**2, (169, 589): -u**2*v**3/w**2, (169, 616):
        -u**2*v**2*(u*v - w)/w**2, (169, 643): -u*v**3/w**2, (170,
        35): 1, (170, 170): v/w, (171, 36): 1, (171, 171): v/w, (172,
        37): 1, (172, 45): v/w, (172, 172): v/w, (172, 180):
        v**2/w**2, (172, 212): -v/w, (172, 239): u*v/w**2, (172, 347):
        -v**2/w**2, (172, 352): u*v/w, (172, 514): -u**2*v/w**2, (172,
        563): u*v**2/w**3, (172, 622): -u*v**2/w**2, (173, 40): 1,
        (173, 77): u/w, (173, 163): -u**2/w, (173, 173): v/w, (173,
        175): v/w, (173, 346): -v**2/w, (173, 369): u*v**2/w**2, (173,
        373): -u**2*v**2/w, (173, 374): u*v/w, (173, 400): -v**2/w,
        (173, 454): -u*v**2/w, (173, 531): -u*v/w**2, (173, 536):
        -u**2*v/w**2, (173, 562): v/w, (173, 585): u*v**2/w**2, (173,
        612): u**2*v**2/w**2, (173, 644): -u*v**2/w**2, (174, 22):
        u*v/w, (174, 41): 1, (174, 44): v/w, (174, 49): u**2*v/w,
        (174, 174): v/w, (174, 176): v/w, (174, 179): v**2/w**2, (174,
        346): -u*v**2/w**2, (174, 349): -v**2/w**2, (174, 373):
        -u*v**2*(u**2 + v)/w**2, (174, 376): -u**2*v**2/w**2, (174,
        400): -u*v**2/w**2, (174, 403): -v**2/w**2, (174, 454):
        -u**2*v**2/w**2, (174, 457): -u*v**2/w**2, (174, 535):
        u*v**2/w**2, (174, 562): u*v/w**2, (174, 565): v/w**2, (174,
        589): -u*v**3/w**2, (174, 616): -u**2*v**3/w**2, (175, 146):
        -u, (175, 183): 1, (175, 261): -u**2*v/w, (175, 288): u**2/w,
        (176, 147): -u, (176, 182): 1, (176, 322): u*v/w, (176, 323):
        -u*v**2/w, (176, 377): -u**3*v/w, (176, 403): -u**2*v/w**2,
        (176, 458): -u**2*v/w, (176, 619): -u**2*v/w, (176, 620): u*v,
        (177, 17): -u/w, (177, 22): -u**3/w, (177, 25): -u**2/w, (177,
        26): u, (177, 42): 1, (177, 44): -u**2/w, (177, 49):
        -u**2*(u**2 - v)/w, (177, 52): -u**3/w, (177, 53): u**2, (177,
        76): -u**2/w, (177, 177): v/w, (177, 184): u**2*v**2/w**2,
        (177, 368): u*v**2/w**2, (177, 373): u**2*v*(u*v - w)/w**2,
        (177, 376): u**2*v**2/w**2, (177, 530): -u*v/w**2, (177, 538):
        -u**2*v/w**2, (177, 584): u*v**2/w**2, (177, 589):
        u**3*v**2/w**2, (177, 592): u**2*v**2/w**2, (177, 611):
        u**2*v**2/w**2, (177, 616): u**4*v**2/w**2, (177, 619):
        u**3*v**2/w**2, (177, 643): u**2*v**2/w**2, (178, 43): 1,
        (178, 49): u**2/w, (178, 178): v/w, (178, 184): u**2*v/w**2,
        (178, 319): -u**2/w, (178, 400): u**3/w**2, (178, 616):
        u**3/w, (179, 22): -u, (179, 49): -u**2, (179, 164): 1, (179,
        322): -u, (179, 323): u*v, (179, 373): u*v**2/w, (179, 377):
        u**3, (179, 403): u**2/w, (179, 458): u**2, (179, 535):
        -u*v/w, (179, 589): u*v**2/w, (179, 616): u**2*v**2/w, (179,
        619): u**2, (179, 620): -u*w, (180, 212): 1, (180, 239): -u/w,
        (180, 347): v/w, (180, 352): -u, (180, 514): u**2/w, (180,
        563): -u*v/w**2, (180, 622): u*v/w, (181, 141): 1, (181, 319):
        v**2/w, (181, 400): -u*v**2/w**2, (181, 616): -u*v**2/w, (182,
        147): 1, (182, 319): -u*v/w, (182, 322): -v/w, (182, 323):
        v**2/w, (182, 377): u**2*v/w, (182, 400): u**2*v/w**2, (182,
        403): u*v/w**2, (182, 458): u*v/w, (182, 616): u**2*v/w, (182,
        619): u*v/w, (182, 620): -v, (183, 146): 1, (183, 261): u*v/w,
        (183, 288): -u/w, (183, 319): -v, (183, 400): u*v/w, (183,
        616): u*v, (184, 319): 1, (184, 400): -u/w, (184, 616): -u,
        (185, 271): -u*v/w, (185, 460): -v/w, (185, 487): 1/w, (185,
        514): u/w, (185, 568): -u*v/w, (185, 595): -u**2*v/w, (185,
        622): -v/w, (186, 375): 1, (186, 537): -u/w, (186, 645): -v/w,
        (187, 322): 1, (187, 403): -u/w, (187, 619): -u, (188, 188):
        v/w, (188, 211): u/w, (188, 238): -u**2/w**2, (188, 314): 1/w,
        (188, 319): u**2/w, (188, 322): u/w, (188, 395): -u/w**2,
        (188, 400): -u**3/w**2, (188, 403): -u**2/w**2, (188, 611):
        -u/w, (188, 616): -u**3/w, (188, 619): -u**2/w, (189, 192): 1,
        (189, 193): -u/w, (190, 190): v/w, (190, 315): -v/w, (190,
        342): 1/w, (191, 161): w, (191, 188): -u, (191, 323):
        -u*v**2/w, (191, 377): -u**2, (191, 431): -u*v, (191, 647): u,
        (192, 193): 1/w, (193, 189): 1, (193, 193): v/w, (194, 221):
        1/w, (195, 195): v/w, (195, 223): 1/w, (195, 238):
        u*v**2/w**2, (195, 319): v**4/w**2, (195, 373): u*v**2/w,
        (195, 400): u*v*(u*v - w)/w**2, (195, 427): v**3/w, (195,
        589): u*v**2/w, (195, 616): u**2*v**2/w, (195, 643): v**2*(u*v
        - w)/w**2, (196, 60): -u/w, (196, 103): -u*v**2/w, (196, 184):
        -u**2*v/w, (196, 195): -u**2/w, (196, 208): 1, (196, 211):
        -u*v**3/w**2, (196, 319): -u**2*v**3/w**2, (196, 373):
        -u**3*v/w, (196, 427): -u**2*v**2/w, (196, 589):
        -u**2*v**3/w**2, (196, 616): -u*v*(2*u*v - w)/w, (196, 643):
        u**2*v**2*(u*w - v**2)/w**3, (197, 224): 1/w, (198, 225): 1/w,
        (199, 226): 1/w, (199, 234): v/w**2, (199, 298): u*v/w, (199,
        325): -u**2*v/w**2, (199, 347): -v**2/w**2, (199, 482): -v/w,
        (199, 509): u*v/w**2, (199, 563): u*v**2/w**3, (199, 568):
        -u**2*v**2/w**2, (199, 595): -u**2*v/w, (199, 622):
        -u**2*v**3/w**3, (200, 190): -u**2/w, (200, 200): v/w, (200,
        229): 1/w, (200, 315): u*v**2/w**2, (200, 319): -v**3/w, (200,
        342): -u*v/w**2, (200, 373): -u*v, (200, 401): u/w, (200,
        427): -v**2, (200, 563): -u**2/w**2, (200, 590): -u*v/w, (200,
        643): v, (200, 644): -u*v**2/w**2, (201, 201): v/w, (201,
        230): 1/w, (201, 233): v/w**2, (201, 319): -u*v**3/w**2, (201,
        322): -v**3/w**2, (201, 373): -u**2*v/w, (201, 376): -u*v/w,
        (201, 400): -u*v**2/w**2, (201, 427): -u*v**2/w, (201, 430):
        -v**2/w, (201, 562): u*v/w**2, (201, 616): -u*v**2/w, (201,
        643): u*v/w, (201, 646): v/w, (202, 45): u**2/w, (202, 65):
        -u/w, (202, 200): -u**2/w, (202, 210): 1, (202, 315):
        -u**3*v/w**2, (202, 342): u**3/w**2, (203, 66): -u/w, (203,
        106): u*v/w, (203, 133): -u**2*v/w**2, (203, 161): u*v, (203,
        188): -u**2*v/w, (203, 201): -u**2/w, (203, 209): 1, (203,
        214): u*v**2/w**2, (203, 241): -u**2*v**2/w**3, (203, 322):
        u**2*v**2/w**2, (203, 323): -u**2*v**3/w**2, (203, 377):
        -u**3*v/w, (203, 403): -u**3*v**2/w**3, (203, 430): u**2*v/w,
        (203, 431): -u**2*v**2/w, (203, 457): -u**3*v/w**2, (203,
        646): -u**3*v/w**2, (203, 647): u**2*v/w, (204, 231): 1/w,
        (204, 238): u**2*v/w**2, (204, 323): u*v**2/w, (204, 350):
        -u*v/w, (204, 395): u*v/w**2, (204, 400): u**2*(u*v - w)/w**2,
        (204, 403): u**2*v/w**2, (204, 404): -u*v/w, (204, 557):
        -u/w**2, (204, 565): -u**2/w**2, (204, 566): u/w, (204, 589):
        u**2*v/w, (204, 611): u*v/w, (204, 616): u**3*v/w, (204, 619):
        u**2*v/w, (204, 620): -u*v, (204, 643): u**2*v**2/w**2, (205,
        103): -u**2/w, (205, 130): u**3/w**2, (205, 211):
        -u**2*v/w**2, (205, 232): 1/w, (205, 238): u**2*(u*v +
        w)/w**3, (205, 319): -u**3*v/w**2, (205, 400): u**4*v/w**3,
        (205, 427): -u**3/w, (205, 454): u**4/w**2, (205, 643):
        u**4/w**2, (206, 106): -u, (206, 133): u**2/w, (206, 161):
        -u*w, (206, 188): u**2, (206, 191): 1, (206, 214): -u*v/w,
        (206, 241): u**2*v/w**2, (206, 322): -u**2*v/w, (206, 323):
        u**2*v**2/w, (206, 377): u**3, (206, 400): u*v/w, (206, 403):
        u**3*v/w**2, (206, 430): -u**2, (206, 431): u**2*v, (206,
        457): u**3/w, (206, 562): -u/w, (206, 616): u*v, (206, 646):
        u**3/w, (206, 647): -u**2, (207, 298): -u, (207, 325): u**2/w,
        (207, 347): v/w, (207, 482): 1, (207, 509): -u/w, (207, 563):
        -u*v/w**2, (207, 568): u**2*v/w, (207, 595): u**2, (207, 622):
        u**2*v**2/w**2, (208, 60): 1/w, (208, 103): v**2/w, (208,
        130): -u*v**2/w**2, (208, 195): u/w, (208, 211): v**3/w**2,
        (208, 238): -u*v**3/w**3, (208, 319): u*v**3/w**2, (208, 400):
        -u**2*v**3/w**3, (208, 427): u*v**2/w, (208, 454):
        -u**2*v**2/w**2, (208, 643): -u**2*v**2/w**2, (209, 66): 1/w,
        (209, 103): -u*v/w, (209, 106): -v/w, (209, 130): u**2*v/w**2,
        (209, 133): u*v/w**2, (209, 161): -v, (209, 188): u*v/w, (209,
        201): u/w, (209, 211): -u*v**2/w**2, (209, 214): -v**2/w**2,
        (209, 238): u**2*v**2/w**3, (209, 241): u*v**2/w**3, (209,
        319): -u**2*v**2/w**2, (209, 322): -u*v**2/w**2, (209, 323):
        u*v**3/w**2, (209, 377): u**2*v/w, (209, 400): u**3*v**2/w**3,
        (209, 403): u**2*v**2/w**3, (209, 427): -u**2*v/w, (209, 430):
        -u*v/w, (209, 431): u*v**2/w, (209, 454): u**3*v/w**2, (209,
        457): u**2*v/w**2, (209, 643): u**3*v/w**2, (209, 646):
        u**2*v/w**2, (209, 647): -u*v/w, (210, 45): -u/w, (210, 65):
        1/w, (210, 103): -v, (210, 130): u*v/w, (210, 200): u/w, (210,
        211): -v**2/w, (210, 238): u*v**2/w**2, (210, 315):
        u**2*v/w**2, (210, 319): -u*v**2/w, (210, 342): -u**2/w**2,
        (210, 400): u**2*v**2/w**2, (210, 427): -u*v, (210, 454):
        u**2*v/w, (210, 643): u**2*v/w, (211, 103): 1, (211, 130):
        -u/w, (211, 211): v/w, (211, 238): -u*v/w**2, (211, 319):
        u*v/w, (211, 400): -u**2*v/w**2, (211, 427): u, (211, 454):
        -u**2/w, (211, 643): -u**2/w, (212, 244): -v, (212, 352): 1,
        (212, 622): -v/w, (213, 321): 1, (213, 348): -u/w, (213, 591):
        -u*v/w, (213, 618): -u, (213, 645): -u*v**2/w**2, (214, 106):
        1, (214, 133): -u/w, (214, 214): v/w, (214, 241): -u*v/w**2,
        (214, 322): u*v/w, (214, 403): -u**2*v/w**2, (214, 430): u,
        (214, 457): -u**2/w, (214, 646): -u**2/w, (215, 98): 1/w,
        (215, 103): u**2/w, (215, 106): u/w, (215, 125): -u/w**2,
        (215, 130): -u**3/w**2, (215, 133): -u**2/w**2, (215, 206):
        v/w**2, (215, 211): u**2*v/w**2, (215, 214): u*v/w**2, (215,
        215): v/w, (215, 233): -u*v/w**3, (215, 238): -u**3*v/w**3,
        (215, 241): -u**2*v/w**3, (215, 314): u*v/w**2, (215, 319):
        u*v*(u**2 - v)/w**2, (215, 322): u**2*v/w**2, (215, 346):
        u*v/w**2, (215, 395): -u**2*v/w**3, (215, 400): -u**2*v*(u**2
        - v)/w**3, (215, 403): -u**3*v/w**3, (215, 422): u/w, (215,
        427): u*(u**2 - v)/w, (215, 430): u**2/w, (215, 449):
        -u**2/w**2, (215, 454): -u**2*(u**2 - v)/w**2, (215, 457):
        -u**3/w**2, (215, 481): u/w, (215, 508): -u**2/w**2, (215,
        562): -u**2*v/w**3, (215, 638): -u**2/w**2, (215, 643):
        -u**2*(u**2 - v)/w**2, (215, 646): -u**3/w**2, (216, 219): 1,
        (216, 220): -u/w, (217, 217): v/w, (217, 396): -v/w, (217,
        558): 1/w, (217, 612): -v, (218, 323): -v**2, (218, 377):
        -u*w, (218, 431): -v*w, (218, 647): w, (219, 220): 1/w, (220,
        216): 1, (220, 220): v/w, (221, 59): 1, (221, 221): v/w, (222,
        22): -u*v, (222, 49): -u**2*v, (222, 61): 1, (222, 222): v/w,
        (222, 223): v/w, (222, 238): u*v**3/w**2, (222, 346):
        v**4/w**2, (222, 373): u*v**3/w, (222, 400): v**2*(u**2*v -
        u*w + v**2)/w**2, (222, 454): v**3/w, (222, 481): v**3/w,
        (222, 508): -v**2/w, (222, 562): -v**3/w**2, (222, 589):
        u*v**3/w, (222, 616): u**2*v**3/w, (222, 643): u*v**4/w**2,
        (223, 130): -u*v**2/w, (223, 184): -u**2*v**2/w, (223, 195):
        -u, (223, 235): 1, (223, 238): -u*v**3/w**2, (223, 319):
        -u*v**3/w, (223, 373): -u**3*v**2/w, (223, 400): -u*v**2*(u*v
        - w)/w**2, (223, 427): -u*v**2, (223, 454): -u*v*(u*v - w)/w,
        (223, 589): -u*v**3/w, (223, 616): -u**2*v**3/w, (223, 643):
        u*v**2*(u*w - v**2)/w**2, (224, 62): 1, (224, 224): v/w, (225,
        63): 1, (225, 225): v/w, (226, 64): 1, (226, 72): v/w, (226,
        104): -v, (226, 131): u*v/w, (226, 212): -v**2/w, (226, 226):
        v/w, (226, 234): v**2/w**2, (226, 239): u*v**2/w**2, (226,
        347): -v**3/w**2, (226, 379): u*v/w, (226, 482): -v**2/w,
        (226, 509): u*v**2/w**2, (226, 541): -u**2*v/w**2, (226, 563):
        u*v**3/w**3, (226, 568): -u*v**2/w, (226, 622): -u*v**3/w**2,
        (227, 23): u, (227, 67): 1, (227, 77): u*v/w, (227, 217):
        -u**2/w, (227, 227): v/w, (227, 229): v/w, (227, 346):
        -v**3/w, (227, 373): -u*v**2, (227, 396): u*v**2/w**2, (227,
        400): -v**3/w, (227, 401): u*v/w, (227, 454): -v**2, (227,
        481): -v**2, (227, 508): v, (227, 558): -u*v/w**2, (227, 562):
        v**2/w, (227, 563): -u**2*v/w**2, (227, 590): -u*v**2/w, (227,
        612): u*v**2/w, (227, 644): -u*v**3/w**2, (228, 49): u*v,
        (228, 68): 1, (228, 71): v/w, (228, 228): v/w, (228, 230):
        v/w, (228, 233): v**2/w**2, (228, 346): -u*v**3/w**2, (228,
        349): -v**3/w**2, (228, 373): -u**2*v**2/w, (228, 376):
        -u*v**2/w, (228, 400): -2*u*v**3/w**2, (228, 403): -v**3/w**2,
        (228, 454): -u*v**2/w, (228, 457): -v**2/w, (228, 481):
        -u*v**2/w, (228, 484): -v**2/w, (228, 508): u*v/w, (228, 511):
        v/w, (228, 562): 2*u*v**2/w**2, (228, 565): v**2/w**2, (228,
        616): -u*v**3/w, (229, 200): -u, (229, 237): 1, (229, 315):
        -u**2*v/w, (229, 342): u**2/w, (230, 201): -u, (230, 236): 1,
        (230, 322): u*v**2/w, (230, 323): -u*v**3/w, (230, 377):
        -u**2*v, (230, 403): -u**2*v**2/w**2, (230, 430): u*v, (230,
        431): -u*v**2, (230, 457): -u**2*v/w, (230, 646): -u**2*v/w,
        (230, 647): u*v, (231, 22): -u**2, (231, 44): -u, (231, 49):
        -u**3, (231, 52): -u**2, (231, 53): u*w, (231, 69): 1, (231,
        231): v/w, (231, 238): u**2*v**2/w**2, (231, 395):
        u*v**2/w**2, (231, 400): u**2*v*(u*v - w)/w**2, (231, 403):
        u**2*v**2/w**2, (231, 557): -u*v/w**2, (231, 565):
        -u**2*v/w**2, (231, 589): u**2*v**2/w, (231, 611): u*v**2/w,
        (231, 616): u**3*v**2/w, (231, 619): u**2*v**2/w, (231, 643):
        u**2*v**3/w**2, (232, 70): 1, (232, 76): u**2/w, (232, 232):
        v/w, (232, 238): u**2*v/w**2, (232, 319): -u**2*v/w, (232,
        400): u**3*v/w**2, (232, 427): -u**2, (232, 454): u**3/w,
        (232, 643): u**3/w, (233, 49): -u*w, (233, 218): 1, (233,
        322): -u*v, (233, 323): u*v**2, (233, 377): u**2*w, (233,
        400): u*v**2/w, (233, 403): u**2*v/w, (233, 430): -u*w, (233,
        431): u*v*w, (233, 457): u**2, (233, 562): -u*v/w, (233, 616):
        u*v**2, (233, 646): u**2, (233, 647): -u*w, (234, 104): w,
        (234, 131): -u, (234, 212): v, (234, 239): -u*v/w, (234, 347):
        v**2/w, (234, 379): -u, (234, 482): v, (234, 509): -u*v/w,
        (234, 541): u**2/w, (234, 563): -u*v**2/w**2, (234, 568): u*v,
        (234, 622): u*v**2/w, (235, 195): 1, (235, 319): v**3/w, (235,
        400): -u*v**3/w**2, (235, 427): v**2, (235, 454): -u*v**2/w,
        (235, 643): -u*v**2/w, (236, 201): 1, (236, 319): -u*v**2/w,
        (236, 322): -v**2/w, (236, 323): v**3/w, (236, 377): u*v,
        (236, 400): u**2*v**2/w**2, (236, 403): u*v**2/w**2, (236,
        427): -u*v, (236, 430): -v, (236, 431): v**2, (236, 454):
        u**2*v/w, (236, 457): u*v/w, (236, 643): u**2*v/w, (236, 646):
        u*v/w, (236, 647): -v, (237, 200): 1, (237, 315): u*v/w, (237,
        319): -v**2, (237, 342): -u/w, (237, 400): u*v**2/w, (237,
        427): -v*w, (237, 454): u*v, (237, 643): u*v, (238, 319): v,
        (238, 400): -u*v/w, (238, 427): w, (238, 454): -u, (238, 643):
        -u, (239, 271): -v, (239, 514): 1, (239, 568): -v, (239, 595):
        -u*v, (239, 622): -v**2/w, (240, 402): 1, (240, 564): -u/w,
        (240, 591): -v, (240, 645): -v**2/w, (241, 322): v, (241,
        403): -u*v/w, (241, 430): w, (241, 457): -u, (241, 646): -u,
        (242, 103): u, (242, 130): -u**2/w, (242, 211): u*v/w, (242,
        238): -u**2*v/w**2, (242, 242): v/w, (242, 314): v/w, (242,
        319): u**2*v/w, (242, 322): u*v/w, (242, 395): -u*v/w**2,
        (242, 400): -u**3*v/w**2, (242, 403): -u**2*v/w**2, (242,
        422): 1, (242, 427): u**2, (242, 430): u, (242, 449): -u/w,
        (242, 454): -u**3/w, (242, 457): -u**2/w, (242, 638): -u/w,
        (242, 643): -u**3/w, (242, 646): -u**2/w, (243, 246): 1, (243,
        247): -u/w, (244, 153): 1/w, (244, 244): v/w, (244, 261): u/w,
        (244, 639): u/w**2, (245, 134): 1/w, (245, 188): u/w, (245,
        269): u, (245, 377): u**2/w, (245, 458): u/w, (246, 247): 1/w,
        (247, 243): 1, (247, 247): v/w, (248, 302): 1/w, (249, 184):
        -v**2/w**2, (249, 211): -u**2*v/w**2, (249, 249): v/w, (249,
        304): 1/w, (249, 319): -u**3*v/w**2, (249, 346): -u*v/w**2,
        (249, 373): -u*v**2/w**2, (249, 589): -u**3*v/w**2, (249,
        643): -u**2*v*(u*v + w)/w**3, (250, 184): u**2*v/w**2, (250,
        211): u**2*v/w**2, (250, 249): -u**2/w, (250, 262): 1, (250,
        319): u**3*v/w**2, (250, 373): u*v*(u**2 - v)/w**2, (250,
        411): -u/w, (250, 535): u*v/w**2, (250, 589): u*v*(u**2 -
        v)/w**2, (250, 643): u**3*v**2/w**3, (251, 305): 1/w, (252,
        306): 1/w, (253, 271): u*v/w**2, (253, 307): 1/w, (253, 315):
        v/w**2, (253, 595): u**2*v/w**2, (253, 644): -v/w**2, (254,
        153): -u*v/w**2, (254, 184): v/w, (254, 244): -u**2/w, (254,
        254): v/w, (254, 261): -u**2*v/w**2, (254, 310): 1/w, (254,
        319): u*v/w, (254, 347): u/w**2, (254, 373): u*v/w, (254,
        639): -u**2*v/w**3, (254, 644): u**2/w**2, (255, 184):
        u*v/w**2, (255, 187): v/w**2, (255, 211): u*v/w**2, (255,
        255): v/w, (255, 311): 1/w, (255, 314): v/w**2, (255, 319):
        2*u**2*v/w**2, (255, 322): u*v/w**2, (255, 373): u**2*v/w**2,
        (255, 376): u*v/w**2, (255, 589): u**2*v/w**2, (255, 643):
        u**2*v**2/w**3, (256, 99): u**2/w**2, (256, 153): u**3/w**2,
        (256, 254): -u**2/w, (256, 261): u**4/w**2, (256, 264): 1,
        (256, 416): -u/w, (256, 423): u**3/w**2, (256, 612):
        u**3/w**2, (257, 134): u*v/w**2, (257, 188): u**2*v/w**2,
        (257, 255): -u**2/w, (257, 263): 1, (257, 269): u**2*v/w,
        (257, 377): u**3*v/w**2, (257, 417): -u/w, (257, 458):
        u**2*v/w**2, (257, 592): u*v/w**2, (257, 619): u**2*v/w**2,
        (258, 161): -u*v/w, (258, 206): -u/w**2, (258, 211):
        -u**3/w**2, (258, 214): -u**2/w**2, (258, 215): u/w, (258,
        269): -u**2*v/w, (258, 312): 1/w, (258, 314): -u**2/w**2,
        (258, 319): -u**2*(u**2 - v)/w**2, (258, 322): -u**3/w**2,
        (258, 323): u**2/w, (258, 346): -u**2/w**2, (258, 584):
        -u**2/w**2, (258, 589): -u**4/w**2, (258, 592): -u**3/w**2,
        (258, 593): u**2/w, (258, 638): -u**2*v/w**3, (258, 643):
        -u**3*(u*v + w)/w**3, (258, 646): -u**3*v/w**3, (259, 313):
        1/w, (259, 319): u**2/w**2, (259, 589): -u**2/w**2, (259,
        616): -u**3/w**2, (260, 134): -u/w, (260, 188): -u**2/w, (260,
        211): -u/w, (260, 245): 1, (260, 269): -u**2, (260, 319):
        -u**2/w, (260, 377): -u**3/w, (260, 458): -u**2/w, (260, 589):
        -u**2/w, (260, 592): -u/w, (260, 619): -u**2/w, (260, 643):
        -u**2*v/w**2, (261, 271): -u/w, (261, 595): -u**2/w, (261,
        644): 1/w, (262, 249): u/w, (262, 411): 1/w, (262, 589):
        v**2/w**2, (262, 616): u*v**2/w**2, (263, 134): -v/w**2, (263,
        188): -u*v/w**2, (263, 255): u/w, (263, 269): -u*v/w, (263,
        377): -u**2*v/w**2, (263, 417): 1/w, (263, 458): -u*v/w**2,
        (263, 589): -u*v/w**2, (263, 592): -v/w**2, (263, 616):
        -u**2*v/w**2, (263, 619): -u*v/w**2, (264, 99): -u/w**2, (264,
        153): -u**2/w**2, (264, 254): u/w, (264, 261): -u**3/w**2,
        (264, 416): 1/w, (264, 423): -u**2/w**2, (264, 589): -v/w,
        (264, 612): -u**2/w**2, (264, 616): -u*v/w, (265, 589): 1/w,
        (265, 616): u/w, (266, 28): 1/w, (266, 136): u/w, (266, 244):
        u**2/w, (266, 325): u/w**2, (266, 406): u/w, (266, 622):
        u**2/w**2, (267, 294): 1/w, (267, 618): u/w, (268, 592): 1/w,
        (268, 619): u/w, (269, 269): v/w, (269, 584): w**(-2), (269,
        589): u**2/w**2, (269, 592): u/w**2, (269, 611): u/w**2, (269,
        616): u*(u**2 - v)/w**2, (269, 619): u**2/w**2, (269, 643):
        u/w**2, (270, 273): 1, (270, 274): -u/w, (271, 261): 1, (271,
        271): v/w, (271, 585): -u/w, (271, 612): -u**2/w, (272, 26):
        1, (272, 53): u, (272, 134): v/w, (272, 188): u*v/w, (272,
        296): u, (272, 377): u**2*v/w, (272, 458): u*v/w, (273, 274):
        1/w, (274, 270): 1, (274, 274): v/w, (275, 356): -u**2/w,
        (275, 437): -u/w, (275, 599): 1, (276, 130): u**3*v/w**2,
        (276, 184): u**4*v/w**2, (276, 276): v/w, (276, 319): -v**2/w,
        (276, 358): -u**2/w, (276, 373): u*v*(u**2 - v)*(u**2 +
        v)/w**2, (276, 400): u*v**2/w**2, (276, 439): -u/w, (276,
        454): u**4*v/w**2, (276, 508): u**2*v/w**2, (276, 535):
        u**3*v/w**2, (276, 589): u**2*v*(u*v - w)/w**2, (276, 601): 1,
        (276, 616): u*v*(u**3*v - u**2*w + v*w)/w**2, (276, 643):
        -u*v/w, (277, 130): -u**3*v/w**2, (277, 184): -u**2*v*(u**2 -
        v)/w**2, (277, 211): u*v/w, (277, 238): -u**2*v/w**2, (277,
        289): 1, (277, 319): u**2*v/w, (277, 357): -u**2/w, (277,
        373): -u**3*v*(u**2 - v)/w**2, (277, 400): -u**3*v/w**2, (277,
        438): -u/w, (277, 454): -u**4*v/w**2, (277, 589): -u**2*v*(u*v
        - w)/w**2, (277, 600): u*v/w, (277, 616): -u**2*v**2*(u**2 -
        v)/w**2, (278, 359): -u**2/w, (278, 440): -u/w, (278, 602): 1,
        (279, 360): -u**2/w, (279, 441): -u/w, (279, 603): 1, (280,
        136): u*v/w, (280, 271): u*v**2/w**2, (280, 361): -u**2/w,
        (280, 369): -u**2*v/w**2, (280, 374): -v/w, (280, 442): -u/w,
        (280, 450): -u*v/w**2, (280, 536): u*v/w**2, (280, 595):
        u**2*v**2/w**2, (280, 604): 1, (280, 612): v/w, (281, 261):
        -u*v/w, (281, 271): -u**2/w, (281, 281): v/w, (281, 319): v,
        (281, 364): -u**2/w, (281, 373): -u*v*(u**2 - v)/w, (281,
        400): -u*v/w, (281, 445): -u/w, (281, 454): -u**2*v/w, (281,
        509): -u**2/w**2, (281, 536): -u**3/w**2, (281, 585):
        u**2*v/w**2, (281, 607): 1, (281, 612): u**3*v/w**2, (281,
        644): u/w, (282, 130): -u**2*v/w**2, (282, 184): -u**3*v/w**2,
        (282, 282): v/w, (282, 319): u*v/w, (282, 322): v/w, (282,
        365): -u**2/w, (282, 368): -u**2*v/w**2, (282, 373):
        -u**2*v*(2*u**2 - v)/w**2, (282, 376): -u*v*(u**2 - v)/w**2,
        (282, 400): -u**2*v/w**2, (282, 403): -u*v/w**2, (282, 446):
        -u/w, (282, 449): -u*v/w**2, (282, 454): -2*u**3*v/w**2, (282,
        457): -u**2*v/w**2, (282, 589): -u*v*(u*v - w)/w**2, (282,
        608): 1, (282, 611): v/w, (282, 616): -u**2*v*(u*v - w)/w**2,
        (283, 126): u**2/w**2, (283, 180): u**3/w**2, (283, 291): 1,
        (283, 362): -u**2/w, (283, 369): u**4/w**2, (283, 443): -u/w,
        (283, 450): u**3/w**2, (283, 605): u*v/w, (284, 26): u*v/w,
        (284, 53): u**2*v/w, (284, 134): u*v**2/w**2, (284, 188):
        u**2*v**2/w**2, (284, 290): 1, (284, 296): u**2*v/w, (284,
        363): -u**2/w, (284, 376): -u*v**2/w**2, (284, 377):
        u**3*v**2/w**2, (284, 444): -u/w, (284, 458): u**2*v**2/w**2,
        (284, 538): u*v/w**2, (284, 606): u*v/w, (285, 125):
        u**2/w**2, (285, 130): u**4/w**2, (285, 133): u**3/w**2, (285,
        134): -u**2/w, (285, 179): u**3/w**2, (285, 184): u**5/w**2,
        (285, 187): u**4/w**2, (285, 188): -u**3/w, (285, 269): -u*v,
        (285, 366): -u**2/w, (285, 368): u**4/w**2, (285, 373):
        u**4*(u**2 - v)/w**2, (285, 376): u**5/w**2, (285, 377):
        -u**4/w, (285, 447): -u/w, (285, 449): u**3/w**2, (285, 454):
        u**3*(u**2 - v)/w**2, (285, 457): u**4/w**2, (285, 458):
        -u**3/w, (285, 508): u**3/w**2, (285, 535): u**4/w**2, (285,
        584): u*(u*v - w)/w**2, (285, 589): u**3*(u*v - w)/w**2, (285,
        592): u**2*(u*v - w)/w**2, (285, 593): u, (285, 609): 1, (285,
        611): u**2*(u*v - w)/w**2, (285, 616): u**2*(u**3*v - u**2*w +
        v*w)/w**2, (285, 619): u**3*(u*v - w)/w**2, (285, 620): u**2,
        (285, 643): -u**2/w, (286, 367): -u**2/w, (286, 373):
        -u**2*(u**2 - v)/w**2, (286, 448): -u/w, (286, 454):
        -u**3/w**2, (286, 535): -u**2/w**2, (286, 610): 1, (286, 616):
        u**2/w, (287, 26): -u, (287, 53): -u**2, (287, 130): u**2/w,
        (287, 134): -u*v/w, (287, 184): u**3/w, (287, 188): -u**2*v/w,
        (287, 272): 1, (287, 296): -u**2, (287, 373): u**4/w, (287,
        376): u*v/w, (287, 377): -u**3*v/w, (287, 454): u**3/w, (287,
        458): -u**2*v/w, (287, 538): -u/w, (287, 589): u*(u*v - w)/w,
        (287, 616): u**2*(u*v - w)/w, (288, 136): -u, (288, 271):
        -u*v/w, (288, 374): 1, (288, 536): -u/w, (288, 595):
        -u**2*v/w, (289, 357): u/w, (289, 373): -v**3/w**2, (289,
        438): 1/w, (289, 535): v**2/w**2, (289, 600): -v/w, (290, 26):
        -v/w, (290, 53): -u*v/w, (290, 134): -v**2/w**2, (290, 188):
        -u*v**2/w**2, (290, 296): -u*v/w, (290, 363): u/w, (290, 373):
        u*v**2/w**2, (290, 376): v**2/w**2, (290, 377):
        -u**2*v**2/w**2, (290, 444): 1/w, (290, 458): -u*v**2/w**2,
        (290, 535): -u*v/w**2, (290, 538): -v/w**2, (290, 606): -v/w,
        (291, 126): -u/w**2, (291, 180): -u**2/w**2, (291, 362): u/w,
        (291, 369): -u**3/w**2, (291, 373): v**2/w, (291, 443): 1/w,
        (291, 450): -u**2/w**2, (291, 535): -v/w, (291, 605): -v/w,
        (292, 373): -v/w, (292, 535): 1/w, (293, 244): u, (293, 271):
        -u**2/w, (293, 406): 1, (293, 460): -u/w, (293, 568): -u**2/w,
        (293, 595): -u**3/w, (294, 159): 1, (294, 294): v/w, (294,
        618): u*v/w, (295, 376): -v/w, (295, 538): 1/w, (296, 184):
        -u*v/w**2, (296, 296): v/w, (296, 368): -v/w**2, (296, 373):
        -u*(u*v - w)/w**2, (296, 376): -u*v/w**2, (296, 530): w**(-2),
        (296, 538): u/w**2, (296, 616): -u*v**2/w**2, (297, 300): 1,
        (297, 301): -u/w, (298, 207): 1/w, (298, 298): v/w, (298,
        315): u/w, (298, 585): u/w, (298, 639): u*v/w**2, (299, 188):
        1, (299, 323): u, (299, 377): u, (300, 301): 1/w, (301, 297):
        1, (301, 301): v/w, (302, 302): v/w, (302, 410): 1, (303,
        103): -u**2*v/w, (303, 211): -u**2*v**2/w**2, (303, 238):
        -v**2/w**2, (303, 303): v/w, (303, 304): v/w, (303, 319):
        -u**3*v**2/w**2, (303, 346): -u*v**2/w**2, (303, 400):
        -u*v**2/w**2, (303, 412): 1, (303, 427): -u**3*v/w, (303,
        481): -u*v/w, (303, 589): -u**2*v*(u*v + w)/w**2, (303, 616):
        -u**3*v/w, (303, 643): u**2*v*(u**2*w - u*v**2 - v*w)/w**3,
        (304, 103): u**2*v/w, (304, 211): u**2*v**2/w**2, (304, 238):
        u**2*v/w**2, (304, 249): -u, (304, 316): 1, (304, 319):
        u**3*v**2/w**2, (304, 400): u*v*(u**2 - v)/w**2, (304, 427):
        u**3*v/w, (304, 562): u*v/w**2, (304, 589): u**3*v**2/w**2,
        (304, 616): u*v*(u**2 - v)/w, (304, 643): -u**2*v*(u**2*w -
        u*v**2 - v*w)/w**3, (305, 305): v/w, (305, 413): 1, (306,
        306): v/w, (306, 414): 1, (307, 307): v/w, (307, 315):
        v**2/w**2, (307, 325): u*v/w**2, (307, 415): 1, (307, 423):
        v/w, (307, 590): -v/w, (307, 622): u**2*v/w**2, (307, 644):
        -v**2/w**2, (308, 207): -u*v/w**2, (308, 238): v/w, (308,
        298): -u**2/w, (308, 308): v/w, (308, 310): v/w, (308, 315):
        -u**2*v/w**2, (308, 319): u*v**2/w, (308, 347): u*v/w**2,
        (308, 400): u*v/w, (308, 418): 1, (308, 427): u*v, (308, 482):
        u/w, (308, 585): -u**2*v/w**2, (308, 590): u**2/w, (308, 639):
        -u**2*v**2/w**3, (308, 644): u**2*v/w**2, (309, 103): u*v/w,
        (309, 211): u*v**2/w**2, (309, 238): u*v/w**2, (309, 241):
        v/w**2, (309, 309): v/w, (309, 311): v/w, (309, 314):
        v**2/w**2, (309, 319): 2*u**2*v**2/w**2, (309, 322):
        u*v**2/w**2, (309, 400): u**2*v/w**2, (309, 403): u*v/w**2,
        (309, 419): 1, (309, 422): v/w, (309, 427): 2*u**2*v/w, (309,
        430): u*v/w, (309, 589): u**2*v**2/w**2, (309, 616): u**2*v/w,
        (309, 643): -u**2*v*(u*w - v**2)/w**3, (310, 153): u**2/w,
        (310, 254): -u, (310, 261): u**3/w, (310, 318): 1, (310, 639):
        u**3/w**2, (311, 188): u*v/w, (311, 255): -u, (311, 317): 1,
        (311, 323): u**2*v/w, (311, 377): u**2*v/w, (311, 619): u*v/w,
        (312, 98): -u/w, (312, 103): -u**3/w, (312, 106): -u**2/w,
        (312, 107): u, (312, 206): -u*v/w**2, (312, 211):
        -u**3*v/w**2, (312, 214): -u**2*v/w**2, (312, 312): v/w, (312,
        314): -u**2*v/w**2, (312, 319): -u**2*v*(u**2 - v)/w**2, (312,
        322): -u**3*v/w**2, (312, 346): -u**2*v/w**2, (312, 420): 1,
        (312, 422): -u**2/w, (312, 427): -u**2*(u**2 - v)/w, (312,
        430): -u**3/w, (312, 431): u**2, (312, 481): -u**2/w, (312,
        584): -u**2*v/w**2, (312, 589): -u**3*(u*v + w)/w**2, (312,
        592): -u**3*v/w**2, (312, 611): -u**2/w, (312, 616): -u**4/w,
        (312, 619): -u**3/w, (312, 620): u**2, (312, 638): u**2*(u*w -
        v**2)/w**3, (312, 643): u**3*(u**2*w - u*v**2 - v*w)/w**3,
        (312, 646): u**3*(u*w - v**2)/w**3, (312, 647): -u**3/w, (313,
        313): v/w, (313, 319): u**2*v/w**2, (313, 421): 1, (313, 427):
        u**2/w, (313, 616): -u**2/w, (314, 103): -u, (314, 188): -u,
        (314, 211): -u*v/w, (314, 299): 1, (314, 319): -u**2*v/w,
        (314, 323): -u**2, (314, 377): -u**2, (314, 427): -u**2, (314,
        589): -u**2*v/w, (314, 616): -u**2, (314, 619): -u, (314,
        643): u**2*(u*w - v**2)/w**2, (315, 325): -u/w, (315, 590): 1,
        (315, 622): -u**2/w, (315, 644): v/w, (316, 249): 1, (316,
        616): v**2/w, (317, 188): -v/w, (317, 255): 1, (317, 323):
        -u*v/w, (317, 377): -u*v/w, (317, 616): -u*v/w, (317, 619):
        -v/w, (318, 153): -u/w, (318, 254): 1, (318, 261): -u**2/w,
        (318, 616): -v, (318, 639): -u**2/w**2, (319, 616): 1, (320,
        55): 1/w, (320, 190): u/w, (320, 244): u, (320, 325):
        u*v/w**2, (320, 460): u/w, (320, 568): u**2/w, (320, 622):
        u**2*v/w**2, (321, 348): 1/w, (321, 645): u/w, (322, 619): 1,
        (323, 323): v/w, (323, 589): u/w, (323, 611): 1/w, (323, 616):
        u**2/w, (323, 619): u/w, (324, 327): 1, (324, 328): -u/w,
        (325, 315): 1, (325, 325): v/w, (325, 612): -u, (326, 53): w,
        (326, 188): v, (326, 350): u, (326, 377): u*v, (327, 328):
        1/w, (328, 324): 1, (328, 328): v/w, (329, 356): -u, (329,
        626): 1, (330, 184): u**3*v/w, (330, 319): -v**3/w, (330,
        330): v/w, (330, 358): -u, (330, 373): u**4*v/w, (330, 427):
        -v**2, (330, 454): u*v**2/w, (330, 535): u**2*v/w, (330, 589):
        -u*v, (330, 616): u**2*v*(u*v - w)/w, (330, 628): 1, (331,
        103): u*v, (331, 130): -u**2*v/w, (331, 184): -u**3*v/w, (331,
        211): u*v**2/w, (331, 319): u**2*v**2/w, (331, 343): 1, (331,
        357): -u, (331, 373): -u**4*v/w, (331, 427): u**2*v, (331,
        454): -u**3*v/w, (331, 616): -u**2*v*(u*v - w)/w, (331, 627):
        u*v/w, (331, 643): -u**2*v*(u*w - v**2)/w**2, (332, 359): -u,
        (332, 629): 1, (333, 360): -u, (333, 630): 1, (334, 190):
        u*v/w, (334, 325): u*v**2/w**2, (334, 361): -u, (334, 369):
        -u*v/w, (334, 401): -v/w, (334, 563): u*v/w**2, (334, 622):
        u**2*v**2/w**2, (334, 631): 1, (334, 639): v/w, (335, 315):
        -u*v/w, (335, 319): v**2, (335, 325): -u**2/w, (335, 335):
        v/w, (335, 364): -u, (335, 373): -u**2*v, (335, 427): v*w,
        (335, 454): -u*v, (335, 536): -u**2/w, (335, 590): u, (335,
        612): u**2*v/w, (335, 634): 1, (335, 644): u*v/w, (336, 184):
        -u**2*v/w, (336, 319): u*v**2/w, (336, 322): v**2/w, (336,
        336): v/w, (336, 365): -u, (336, 368): -u*v/w, (336, 373):
        -2*u**3*v/w, (336, 376): -u**2*v/w, (336, 427): u*v, (336,
        430): v, (336, 454): -u**2*v/w, (336, 457): -u*v/w, (336,
        616): -u*v*(u*v - w)/w, (336, 635): 1, (336, 638): v/w, (337,
        180): u**2/w, (337, 345): 1, (337, 362): -u, (337, 369):
        u**3/w, (337, 632): u*v/w, (338, 53): u*v, (338, 188):
        u*v**2/w, (338, 344): 1, (338, 350): u**2*v/w, (338, 363): -u,
        (338, 377): u**2*v**2/w, (338, 403): -u*v**2/w**2, (338, 565):
        u*v/w**2, (338, 633): u*v/w, (339, 179): u**2/w, (339, 184):
        u**4/w, (339, 187): u**3/w, (339, 188): -u**2, (339, 323):
        -u*v, (339, 366): -u, (339, 368): u**3/w, (339, 373):
        u**3*(u**2 - v)/w, (339, 376): u**4/w, (339, 377): -u**3,
        (339, 535): u**3/w, (339, 589): -u**2, (339, 611): u*(u*v -
        w)/w, (339, 616): u**3*(u*v - w)/w, (339, 619): u**2*(u*v -
        w)/w, (339, 620): u*w, (339, 636): 1, (340, 367): -u, (340,
        373): -u**3/w, (340, 400): u**2*v/w**2, (340, 562):
        -u**2/w**2, (340, 637): 1, (340, 643): u**2/w, (341, 53):
        -u*w, (341, 184): u**2, (341, 188): -u*v, (341, 326): 1, (341,
        350): -u**2, (341, 373): u**3, (341, 377): -u**2*v, (341,
        403): u*v/w, (341, 565): -u/w, (341, 616): u*(u*v - w), (342,
        190): -u, (342, 325): -u*v/w, (342, 401): 1, (342, 563): -u/w,
        (342, 622): -u**2*v/w, (343, 357): 1, (343, 400): -v**3/w**2,
        (343, 562): v**2/w**2, (343, 627): -v/w, (344, 53): -v, (344,
        188): -v**2/w, (344, 350): -u*v/w, (344, 363): 1, (344, 377):
        -u*v**2/w, (344, 400): u*v**2/w**2, (344, 403): v**2/w**2,
        (344, 562): -u*v/w**2, (344, 565): -v/w**2, (344, 633): -v/w,
        (345, 180): -u/w, (345, 362): 1, (345, 369): -u**2/w, (345,
        400): v**2/w, (345, 562): -v/w, (345, 632): -v/w, (346, 400):
        -v/w, (346, 562): 1/w, (347, 244): w, (347, 271): -u, (347,
        595): -u**2, (348, 213): 1, (348, 348): v/w, (348, 645):
        u*v/w, (349, 403): -v/w, (349, 565): 1/w, (350, 238):
        -u*v/w**2, (350, 350): v/w, (350, 395): -v/w**2, (350, 400):
        -u*(u*v - w)/w**2, (350, 403): -u*v/w**2, (350, 557): w**(-2),
        (350, 565): u/w**2, (350, 643): -u*v**2/w**2, (351, 354): 1,
        (351, 355): -u/w, (352, 180): 1/w, (352, 352): v/w, (352,
        369): u/w, (352, 612): v/w, (353, 377): u, (353, 458): 1,
        (354, 355): 1/w, (355, 351): 1, (355, 355): v/w, (356, 329):
        1/w, (356, 356): v/w, (357, 49): -v**2/w, (357, 184):
        -v**2*(u**2 + v)/w**2, (357, 211): -u*v/w, (357, 319):
        -u**2*v/w, (357, 331): 1/w, (357, 346): -u*v**2/w**2, (357,
        357): v/w, (357, 358): v/w, (357, 373): -u*v**2*(u**2 +
        v)/w**2, (357, 454): -v**3/w**2, (357, 535): -u*v**2/w**2,
        (357, 616): u**2*v*(u*w - v**2)/w**2, (357, 643):
        -u**2*v**2/w**2, (358, 22): u*v/w, (358, 49): u**2*v/w, (358,
        130): u*v**2/w**2, (358, 184): 2*u**2*v**2/w**2, (358, 319):
        u**2*v/w, (358, 370): 1, (358, 373): u*v**2*(2*u**2 - v)/w**2,
        (358, 454): u**2*v**2/w**2, (358, 535): u*v**2/w**2, (358,
        616): -u**2*v*(u*w - v**2)/w**2, (358, 627): -u/w, (359, 332):
        1/w, (359, 359): v/w, (360, 333): 1/w, (360, 360): v/w, (361,
        239): -v/w**2, (361, 334): 1/w, (361, 342): v/w**2, (361,
        361): v/w, (361, 369): v**2/w**2, (361, 514): u*v/w**2, (361,
        563): -v**2/w**3, (361, 644): -v**2/w**2, (362, 49): v, (362,
        180): -u*v/w**2, (362, 184): v**2/w, (362, 212): u/w, (362,
        337): 1/w, (362, 346): u*v/w, (362, 347): u*v/w**2, (362,
        352): -u**2/w, (362, 362): v/w, (362, 364): v/w, (362, 369):
        -u**2*v/w**2, (362, 373): 2*u*v**2/w, (362, 454): v**2/w,
        (362, 536): u*v/w**2, (362, 612): -u*v**2/w**2, (362, 644):
        u**2*v/w**2, (363, 49): u*v/w, (363, 52): v/w, (363, 184):
        2*u*v**2/w**2, (363, 187): v**2/w**2, (363, 319): u*v/w, (363,
        338): 1/w, (363, 341): v/w**2, (363, 346): u**2*v/w**2, (363,
        349): u*v/w**2, (363, 363): v/w, (363, 365): v/w, (363, 368):
        v**2/w**2, (363, 373): 3*u**2*v**2/w**2, (363, 376):
        2*u*v**2/w**2, (363, 454): u*v**2/w**2, (363, 457): v**2/w**2,
        (363, 616): -u*v*(u*w - v**2)/w**2, (364, 372): 1, (364, 612):
        u**2/w, (364, 632): -u/w, (365, 371): 1, (365, 377): u**2*v/w,
        (365, 403): u*v/w**2, (365, 458): u*v/w, (365, 633): -u/w,
        (366, 179): -u*v/w**2, (366, 184): -u**3*v/w**2, (366, 187):
        -u**2*v/w**2, (366, 211): -u**2/w, (366, 314): -u/w, (366,
        319): -u**3/w, (366, 322): -u**2/w, (366, 323): u, (366, 339):
        1/w, (366, 366): v/w, (366, 368): -u**2*v/w**2, (366, 373):
        -u**2*v*(u**2 - v)/w**2, (366, 376): -u**3*v/w**2, (366, 535):
        -u**2*v/w**2, (366, 611): u*(u*w - v**2)/w**2, (366, 616):
        u**3*(u*w - v**2)/w**2, (366, 619): u**2*(u*w - v**2)/w**2,
        (366, 620): -u**2, (366, 643): -u**3*v/w**2, (367, 340): 1/w,
        (367, 346): u**2/w**2, (367, 367): v/w, (367, 373):
        u**2*v/w**2, (367, 400): -u**2/w**2, (368, 184): -u*v/w, (368,
        319): -u, (368, 353): 1, (368, 373): -u**2*v/w, (368, 377):
        -u**2, (368, 403): -u/w, (368, 458): -u, (368, 616): u*(u*w -
        v**2)/w, (369, 239): 1/w, (369, 514): -u/w, (369, 563):
        v/w**2, (369, 644): v/w, (370, 400): v**2/w**2, (370, 627):
        1/w, (371, 377): -u*v/w, (371, 400): -u*v/w**2, (371, 403):
        -v/w**2, (371, 458): -v/w, (371, 633): 1/w, (372, 400): -v/w,
        (372, 612): -u/w, (372, 632): 1/w, (373, 400): 1/w, (374,
        136): 1, (374, 271): v/w, (374, 595): u*v/w, (374, 622): u/w,
        (375, 537): 1/w, (376, 403): 1/w, (377, 238): u/w**2, (377,
        377): v/w, (377, 395): w**(-2), (377, 400): u**2/w**2, (377,
        403): u/w**2, (377, 643): u*v/w**2, (378, 381): 1, (378, 382):
        -u/w, (379, 234): 1/w, (379, 379): v/w, (379, 396): u/w, (379,
        639): v/w, (380, 377): w, (381, 382): 1/w, (382, 378): 1,
        (382, 382): v/w, (383, 329): v/w, (383, 383): v/w, (383, 464):
        1, (384, 76): -v**2/w, (384, 103): -u*v, (384, 211):
        -u*v**2/w, (384, 238): -v**2*(u**2 + v)/w**2, (384, 319):
        -u**2*v**2/w, (384, 331): v/w, (384, 346): -u*v**3/w**2, (384,
        373): -v**3/w, (384, 384): v/w, (384, 385): v/w, (384, 400):
        -u**3*v**2/w**2, (384, 427): -u**2*v, (384, 466): 1, (384,
        481): -u*v**2/w, (384, 562): -u*v**2/w**2, (384, 589):
        -u**2*v**2/w, (384, 643): u**2*v*(u*w - 2*v**2)/w**2, (385,
        49): u*v, (385, 184): u*v**2/w, (385, 238): u**2*v**2/w**2,
        (385, 319): u**2*v**2/w, (385, 373): u**2*v**2/w, (385, 397):
        1, (385, 400): u*v**2*(u**2 - v)/w**2, (385, 427): u**2*v,
        (385, 562): u*v**2/w**2, (385, 573): -u, (385, 627): -u*v/w,
        (385, 643): -u**2*v*(u*w - v**2)/w**2, (386, 332): v/w, (386,
        386): v/w, (386, 467): 1, (387, 333): v/w, (387, 387): v/w,
        (387, 468): 1, (388, 131): -v/w, (388, 239): -v**2/w**2, (388,
        334): v/w, (388, 342): v**2/w**2, (388, 388): v/w, (388, 396):
        v**2/w**2, (388, 469): 1, (388, 477): v/w, (388, 509):
        -v**2/w**2, (388, 541): u*v/w**2, (388, 563): -v**3/w**3,
        (388, 590): -v**2/w, (388, 644): -v**3/w**2, (389, 76): v,
        (389, 104): u, (389, 212): u*v/w, (389, 234): -u*v/w**2, (389,
        238): v**2/w, (389, 337): v/w, (389, 346): u*v**2/w, (389,
        347): u*v**2/w**2, (389, 373): v**2, (389, 379): -u**2/w,
        (389, 389): v/w, (389, 391): v/w, (389, 396): -u**2*v/w**2,
        (389, 400): u*v**2/w, (389, 472): 1, (389, 481): u*v, (389,
        482): u*v/w, (389, 563): u*v/w**2, (389, 590): u**2*v/w, (389,
        639): -u*v**2/w**2, (389, 644): u**2*v**2/w**2, (390, 76):
        u*v/w, (390, 79): v/w, (390, 238): 2*u*v**2/w**2, (390, 241):
        v**2/w**2, (390, 319): u*v**2/w, (390, 338): v/w, (390, 341):
        v**2/w**2, (390, 346): u**2*v**2/w**2, (390, 349):
        u*v**2/w**2, (390, 373): u*v**2/w, (390, 376): v**2/w, (390,
        390): v/w, (390, 392): v/w, (390, 395): v**2/w**2, (390, 400):
        2*u**2*v**2/w**2, (390, 403): u*v**2/w**2, (390, 427): u*v,
        (390, 473): 1, (390, 476): v/w, (390, 481): u**2*v/w, (390,
        484): u*v/w, (390, 643): -u*v*(u*w - v**2)/w**2, (391, 399):
        1, (391, 578): -u, (391, 632): -u*v/w, (391, 639): u**2/w,
        (392, 377): u*v, (392, 398): 1, (392, 403): u*v**2/w**2, (392,
        457): u*v/w, (392, 579): -u, (392, 633): -u*v/w, (393, 103):
        -u**2, (393, 211): -u**2*v/w, (393, 233): -u*v/w**2, (393,
        238): -u**3*v/w**2, (393, 241): -u**2*v/w**2, (393, 314):
        -u*v/w, (393, 319): -u**3*v/w, (393, 322): -u**2*v/w, (393,
        323): u*v, (393, 339): v/w, (393, 393): v/w, (393, 395):
        -u**2*v/w**2, (393, 400): -u**2*v*(u**2 - v)/w**2, (393, 403):
        -u**3*v/w**2, (393, 422): -u, (393, 427): -u**3, (393, 430):
        -u**2, (393, 431): u*w, (393, 474): 1, (393, 562):
        -u**2*v/w**2, (393, 589): -u**3*v/w, (393, 638): u*(u*w -
        v**2)/w**2, (393, 643): u**3*(u*w - 2*v**2)/w**2, (393, 646):
        u**2*(u*w - v**2)/w**2, (393, 647): -u**2, (394, 340): v/w,
        (394, 346): u**2*v/w**2, (394, 394): v/w, (394, 454): -u**2/w,
        (394, 475): 1, (394, 481): u**2/w, (395, 238): -u*v/w, (395,
        319): -u*v, (395, 377): -u*w, (395, 380): 1, (395, 400):
        -u**2*v/w, (395, 403): -u*v/w, (395, 427): -u*w, (395, 457):
        -u, (395, 643): u*(u*w - v**2)/w, (396, 131): 1, (396, 239):
        v/w, (396, 509): v/w, (396, 541): -u/w, (396, 563): v**2/w**2,
        (396, 590): v, (396, 644): v**2/w, (397, 400): v**3/w**2,
        (397, 454): v**2/w, (397, 573): 1, (397, 627): v/w, (398,
        377): -v, (398, 400): -u*v**2/w**2, (398, 403): -v**2/w**2,
        (398, 454): -u*v/w, (398, 457): -v/w, (398, 579): 1, (398,
        633): v/w, (399, 400): -v**2/w, (399, 454): -v, (399, 578): 1,
        (399, 632): v/w, (399, 639): -u/w, (400, 400): v/w, (400,
        454): 1, (401, 190): 1, (401, 325): v/w, (401, 568): u, (401,
        622): 2*u*v/w, (402, 564): 1/w, (403, 403): v/w, (403, 457):
        1, (404, 130): u/w, (404, 238): u*v/w**2, (404, 395): v/w**2,
        (404, 400): u**2*v/w**2, (404, 403): u*v/w**2, (404, 404):
        v/w, (404, 449): 1/w, (404, 454): u**2/w, (404, 457): u/w,
        (404, 589): u*v/w, (404, 643): u*v**2/w**2, (405, 408): 1,
        (405, 409): -u/w, (406, 99): 1/w, (406, 406): v/w, (406, 423):
        u/w, (406, 612): u/w, (406, 639): -u**2/w**2, (407, 188):
        -v/w, (407, 242): 1/w, (407, 377): -u*v/w, (407, 404): u/w,
        (407, 431): u, (408, 409): 1/w, (409, 405): 1, (409, 409):
        v/w, (410, 248): 1, (410, 302): -u/w, (411, 130): -v**2/w**2,
        (411, 157): -u**2*v/w, (411, 211): u**3*v/w**2, (411, 250): 1,
        (411, 265): -u**3*v/w, (411, 292): -u*v/w, (411, 304): -u/w,
        (411, 319): u**4*v/w**2, (411, 346): u**2*v/w**2, (411, 411):
        v/w, (411, 454): -u*v**2/w**2, (411, 589): u**4*v/w**2, (411,
        616): -u**2*v/w, (411, 643): u**4*v**2/w**3, (412, 130):
        u**2*v/w**2, (412, 157): u**2*v/w, (412, 211): -u**3*v/w**2,
        (412, 249): u*v/w, (412, 265): u**3*v/w, (412, 303): -u/w,
        (412, 319): -u**4*v/w**2, (412, 424): 1, (412, 454): u*v*(u**2
        - v)/w**2, (412, 508): u*v/w**2, (412, 589): -u**2*v*(u**2 -
        v)/w**2, (412, 616): u*v**3/w**2, (412, 643): -u*v*(u**3*v -
        u**2*w + v*w)/w**3, (413, 251): 1, (413, 305): -u/w, (414,
        252): 1, (414, 306): -u/w, (415, 253): 1, (415, 261): v/w,
        (415, 307): -u/w, (415, 315): -u*v/w**2, (415, 460): u*v/w**2,
        (415, 568): u**2*v/w**2, (415, 617): -v/w, (415, 644):
        u*v/w**2, (416, 99): -u*v/w**2, (416, 130): v/w, (416, 256):
        1, (416, 265): u*v, (416, 293): u/w, (416, 310): -u/w, (416,
        319): -u**2*v/w, (416, 347): -u**2/w**2, (416, 406): -u**2/w,
        (416, 416): v/w, (416, 423): -u**2*v/w**2, (416, 454): u*v/w,
        (416, 612): -u**2*v/w**2, (416, 617): u**2/w, (416, 639):
        u**3*v/w**3, (416, 644): -u**3/w**2, (417, 130): u*v/w**2,
        (417, 133): v/w**2, (417, 157): u*v/w, (417, 211):
        -u**2*v/w**2, (417, 257): 1, (417, 260): v/w, (417, 265):
        2*u**2*v/w, (417, 268): u*v/w, (417, 311): -u/w, (417, 314):
        -u*v/w**2, (417, 319): -2*u**3*v/w**2, (417, 322):
        -u**2*v/w**2, (417, 417): v/w, (417, 454): u**2*v/w**2, (417,
        457): u*v/w**2, (417, 589): -u**3*v/w**2, (417, 643):
        -u**2*v*(u*v - w)/w**3, (418, 153): -u**2*v/w**2, (418, 207):
        u**2/w**2, (418, 254): u*v/w, (418, 261): -u**3*v/w**2, (418,
        308): -u/w, (418, 315): u**3/w**2, (418, 426): 1, (418, 585):
        u**3/w**2, (419, 188): -u*v**2/w**2, (419, 242): u*v/w**2,
        (419, 255): u*v/w, (419, 309): -u/w, (419, 377):
        -u**2*v**2/w**2, (419, 404): u**2*v/w**2, (419, 425): 1, (419,
        431): u**2*v/w, (419, 619): -u*v**2/w**2, (419, 646):
        u*v/w**2, (420, 107): -u*v/w, (420, 152): -u/w, (420, 157):
        -u**3/w, (420, 160): -u**2/w, (420, 161): u, (420, 206):
        u**2/w**2, (420, 211): u**4/w**2, (420, 214): u**3/w**2, (420,
        215): -u**2/w, (420, 258): 1, (420, 260): -u**2/w, (420, 265):
        -u**2*(u**2 - v)/w, (420, 268): -u**3/w, (420, 269): u**2,
        (420, 292): -u**2/w, (420, 312): -u/w, (420, 314): u**3/w**2,
        (420, 319): u**3*(u**2 - v)/w**2, (420, 322): u**4/w**2, (420,
        323): -u**3/w, (420, 346): u**3/w**2, (420, 431): -u**2*v/w,
        (420, 584): u**3/w**2, (420, 589): u**5/w**2, (420, 592):
        u**4/w**2, (420, 593): -u**3/w, (420, 616): -u**3/w, (420,
        620): -u**2*v/w, (420, 638): u**2*(u*v - w)/w**3, (420, 643):
        u**5*v/w**3, (420, 646): u**3*(u*v - w)/w**3, (420, 647):
        u**2/w, (421, 259): 1, (421, 265): u**2/w, (421, 313): -u/w,
        (421, 319): -u**3/w**2, (421, 616): u**2*v/w**2, (421, 643):
        -u**2/w**2, (422, 157): -u, (422, 188): u*v/w, (422, 211):
        u**2/w, (422, 242): -u/w, (422, 265): -u**2, (422, 319):
        u**3/w, (422, 377): u**2*v/w, (422, 404): -u**2/w, (422, 407):
        1, (422, 431): -u**2, (422, 589): u**3/w, (422, 619): u*v/w,
        (422, 643): u**2*(u*v - w)/w**2, (422, 646): -u/w, (423, 460):
        -u/w, (423, 568): -u**2/w, (423, 617): 1, (423, 644): -u/w,
        (424, 249): -v/w, (424, 303): 1/w, (424, 616): -v**3/w**2,
        (424, 643): v**2/w**2, (425, 188): v**2/w**2, (425, 242):
        -v/w**2, (425, 255): -v/w, (425, 309): 1/w, (425, 377):
        u*v**2/w**2, (425, 404): -u*v/w**2, (425, 431): -u*v/w, (425,
        616): u*v**2/w**2, (425, 619): v**2/w**2, (425, 643):
        -u*v/w**2, (425, 646): -v/w**2, (426, 153): u*v/w**2, (426,
        207): -u/w**2, (426, 254): -v/w, (426, 261): u**2*v/w**2,
        (426, 308): 1/w, (426, 315): -u**2/w**2, (426, 585):
        -u**2/w**2, (426, 616): v**2/w, (426, 643): -v/w, (427, 616):
        -v/w, (427, 643): 1/w, (428, 1): 1/w, (428, 82): u/w, (428,
        244): -u*v/w, (428, 271): u/w, (428, 298): u/w, (428, 325):
        -u**2/w**2, (428, 595): u**2/w, (428, 622): -u**3/w**2, (429,
        483): 1/w, (429, 591): u/w, (430, 619): -v/w, (430, 646): 1/w,
        (431, 431): v/w, (431, 589): -u*v/w**2, (431, 611): -v/w**2,
        (431, 616): -u*(u*v - w)/w**2, (431, 619): -u*v/w**2, (431,
        638): w**(-2), (431, 646): u/w**2, (432, 435): 1, (432, 436):
        -u/w, (433, 126): 1/w, (433, 433): v/w, (433, 450): u/w, (433,
        585): v/w, (434, 377): -v, (434, 404): 1, (435, 436): 1/w,
        (436, 432): 1, (436, 436): v/w, (437, 275): 1, (437, 329):
        -u/w, (437, 437): v/w, (438, 22): -v**2/w, (438, 130):
        -v**2*(u**2 + v)/w**2, (438, 157): -u*v, (438, 211): u**2*v/w,
        (438, 265): -u**2*v, (438, 277): 1, (438, 292): -u*v**2/w,
        (438, 319): u**3*v/w, (438, 331): -u/w, (438, 346):
        u**2*v**2/w**2, (438, 373): v**4/w**2, (438, 400): -v**3/w**2,
        (438, 438): v/w, (438, 439): v/w, (438, 454): -u**3*v**2/w**2,
        (438, 508): -u*v**2/w**2, (438, 589): u**2*v*(u*w -
        v**2)/w**2, (438, 616): -u**2*v**2/w, (438, 643):
        u**3*v**2/w**2, (439, 49): -u*v**2/w, (439, 76): u*v/w, (439,
        130): u**2*v**2/w**2, (439, 184): -u*v**3/w**2, (439, 238):
        u*v**2/w**2, (439, 265): u**2*v, (439, 319): -u**3*v/w, (439,
        373): -u**2*v**3/w**2, (439, 400): u**2*v**2/w**2, (439, 451):
        1, (439, 454): u*v**2*(u**2 - v)/w**2, (439, 508):
        u*v**2/w**2, (439, 589): -u**2*v*(u*w - v**2)/w**2, (439,
        600): -u, (439, 627): u**2/w, (440, 278): 1, (440, 332): -u/w,
        (440, 440): v/w, (441, 279): 1, (441, 333): -u/w, (441, 441):
        v/w, (442, 185): -v/w, (442, 239): u*v/w**2, (442, 280): 1,
        (442, 288): v/w, (442, 334): -u/w, (442, 342): -u*v/w**2,
        (442, 442): v/w, (442, 450): v**2/w**2, (442, 487): u*v/w**2,
        (442, 536): -v**2/w**2, (442, 563): u*v**2/w**3, (442, 617):
        -v**2/w, (442, 644): u*v**2/w**2, (443, 22): v, (443, 126):
        -u*v/w**2, (443, 130): v**2/w, (443, 158): u, (443, 212):
        -u**2/w, (443, 283): 1, (443, 292): u*v, (443, 293): u*v/w,
        (443, 337): -u/w, (443, 346): -u**2*v/w, (443, 347):
        -u**2*v/w**2, (443, 373): -v**3/w, (443, 400): v**2/w, (443,
        433): -u**2/w, (443, 443): v/w, (443, 445): v/w, (443, 450):
        -u**2*v/w**2, (443, 454): u*v**2/w, (443, 509): u*v/w**2,
        (443, 585): -u*v**2/w**2, (443, 617): u**2*v/w, (443, 644):
        -u**3*v/w**2, (444, 22): u*v/w, (444, 25): v/w, (444, 130):
        2*u*v**2/w**2, (444, 133): v**2/w**2, (444, 265): u*v, (444,
        284): 1, (444, 287): v/w, (444, 292): u**2*v/w, (444, 295):
        u*v/w, (444, 319): -u**2*v/w, (444, 338): -u/w, (444, 341):
        -u*v/w**2, (444, 346): -u**3*v/w**2, (444, 349): -u**2*v/w**2,
        (444, 373): -u*v**3/w**2, (444, 376): -v**3/w**2, (444, 400):
        u*v**2/w**2, (444, 403): v**2/w**2, (444, 444): v/w, (444,
        446): v/w, (444, 449): v**2/w**2, (444, 454):
        2*u**2*v**2/w**2, (444, 457): u*v**2/w**2, (444, 589):
        -u*v*(u*w - v**2)/w**2, (445, 453): 1, (445, 585): u**2/w,
        (445, 605): -u, (445, 632): u**2/w, (446, 376): u*v/w, (446,
        377): -u*v**2/w, (446, 403): -u**2*v/w**2, (446, 404): u*v/w,
        (446, 452): 1, (446, 606): -u, (446, 633): u**2/w, (447, 125):
        -u*v/w**2, (447, 130): -u**3*v/w**2, (447, 133): -u**2*v/w**2,
        (447, 157): -u**2, (447, 211): u**3/w, (447, 260): -u, (447,
        265): -u**3, (447, 268): -u**2, (447, 269): u*w, (447, 285):
        1, (447, 314): u**2/w, (447, 319): u**4/w, (447, 322): u**3/w,
        (447, 323): -u**2, (447, 339): -u/w, (447, 447): v/w, (447,
        449): -u**2*v/w**2, (447, 454): -u**2*v*(u**2 - v)/w**2, (447,
        457): -u**3*v/w**2, (447, 508): -u**2*v/w**2, (447, 584):
        u*(u*w - v**2)/w**2, (447, 589): u**3*(u*w - v**2)/w**2, (447,
        592): u**2*(u*w - v**2)/w**2, (447, 593): -u**2, (447, 616):
        -u**3*v/w, (447, 643): u**4*v/w**2, (448, 286): 1, (448, 292):
        u**2/w, (448, 340): -u/w, (448, 346): -u**3/w**2, (448, 373):
        -u**2/w, (448, 400): u**3/w**2, (448, 448): v/w, (448, 454):
        u**2*v/w**2, (449, 130): -u*v/w, (449, 265): -u*w, (449, 319):
        u**2, (449, 376): -u, (449, 377): u*v, (449, 403): u**2/w,
        (449, 404): -u, (449, 434): 1, (449, 454): -u**2*v/w, (449,
        589): u*(u*w - v**2)/w, (450, 185): 1, (450, 239): -u/w, (450,
        487): -u/w, (450, 536): v/w, (450, 563): -u*v/w**2, (450,
        617): v, (450, 644): -u*v/w, (451, 373): v**2/w, (451, 400):
        -u*v**2/w**2, (451, 600): 1, (451, 627): -u/w, (452, 373):
        -u*v/w, (452, 376): -v/w, (452, 377): v**2/w, (452, 400):
        u**2*v/w**2, (452, 403): u*v/w**2, (452, 404): -v/w, (452,
        606): 1, (452, 633): -u/w, (453, 373): -v, (453, 400): u*v/w,
        (453, 585): -u/w, (453, 605): 1, (453, 632): -u/w, (454, 373):
        1, (454, 400): -u/w, (455, 82): 1, (455, 460): v/w, (455,
        568): u*v/w, (455, 595): u, (455, 622): -u**2/w, (456, 510):
        1/w, (457, 376): 1, (457, 403): -u/w, (458, 184): u/w, (458,
        238): -u**2/w**2, (458, 368): 1/w, (458, 373): u**2/w, (458,
        376): u/w, (458, 395): -u/w**2, (458, 400): -u**3/w**2, (458,
        403): -u**2/w**2, (458, 458): v/w, (458, 616): u*v/w, (458,
        643): -u**2*v/w**2, (459, 462): 1, (459, 463): -u/w, (460,
        423): 1, (460, 460): v/w, (460, 612): u*v/w, (460, 639): -u/w,
        (461, 53): -v, (461, 80): 1, (461, 188): -v**2/w, (461, 242):
        v/w, (461, 377): -u*v**2/w, (461, 404): u*v/w, (461, 485): u,
        (462, 463): 1/w, (463, 459): 1, (463, 463): v/w, (464, 356):
        u*v/w, (464, 383): -u/w, (464, 572): 1, (465, 184):
        -u**3*v**2/w**2, (465, 238): u**3*v/w**2, (465, 265): -v**2,
        (465, 319): u*v**2/w, (465, 358): u*v/w, (465, 373):
        -u*v**2*(u**3 - w)/w**2, (465, 385): -u/w, (465, 400):
        u**2*v*(u**2 - v)/w**2, (465, 454): -u*v**3/w**2, (465, 465):
        v/w, (465, 535): -u**2*v**2/w**2, (465, 562): u**2*v/w**2,
        (465, 574): 1, (465, 589): u*v**2/w, (465, 616):
        -u*v*(u**2*v**2 - u*v*w + w**2)/w**2, (465, 643):
        u**3*v**2/w**2, (466, 130): u**2*v**2/w**2, (466, 157): u*v,
        (466, 184): u**2*v*(u*v - w)/w**2, (466, 211): -u**2*v/w,
        (466, 265): u**2*v, (466, 319): -u**3*v/w, (466, 357): u*v/w,
        (466, 373): u**3*v*(u*v - w)/w**2, (466, 384): -u/w, (466,
        454): u**3*v**2/w**2, (466, 478): 1, (466, 573): u*v/w, (466,
        589): -u**2*v*(u*w - v**2)/w**2, (466, 616): u**2*v**2*(u*v -
        w)/w**2, (466, 643): -u**2*v*(u*v - w)/w**2, (467, 359):
        u*v/w, (467, 386): -u/w, (467, 575): 1, (468, 360): u*v/w,
        (468, 387): -u/w, (468, 576): 1, (469, 82): u*v/w, (469, 361):
        u*v/w, (469, 369): u*v**2/w**2, (469, 388): -u/w, (469, 396):
        -u*v/w**2, (469, 455): -v/w, (469, 460): u*v**2/w**2, (469,
        509): u*v/w**2, (469, 568): u**2*v**2/w**2, (469, 577): 1,
        (469, 585): v/w, (470, 265): v*w, (470, 319): -u*v, (470,
        364): u*v/w, (470, 373): u*v*(u*v - w)/w, (470, 391): -u/w,
        (470, 423): -u*v/w, (470, 454): u*v**2/w, (470, 460): -u**2/w,
        (470, 470): v/w, (470, 536): u**2*v/w**2, (470, 563):
        -u**2/w**2, (470, 580): 1, (470, 612): -u**2*v**2/w**2, (470,
        617): u, (470, 639): u**2*v/w**2, (470, 644): -u**2/w, (471,
        184): u**2*v**2/w**2, (471, 238): -u**2*v/w**2, (471, 265):
        u*v, (471, 268): v, (471, 319): -u**2*v/w, (471, 322): -u*v/w,
        (471, 365): u*v/w, (471, 368): u*v**2/w**2, (471, 373):
        u**2*v*(2*u*v - w)/w**2, (471, 376): u*v*(u*v - w)/w**2, (471,
        392): -u/w, (471, 395): -u*v/w**2, (471, 400): -u**3*v/w**2,
        (471, 454): u**2*v**2/w**2, (471, 457): u*v**2/w**2, (471,
        471): v/w, (471, 581): 1, (471, 584): v/w, (471, 616):
        u*v**2*(u*v - w)/w**2, (471, 643): -u*v*(u*v - w)/w**2, (472,
        180): -u**2*v/w**2, (472, 234): u**2/w**2, (472, 362): u*v/w,
        (472, 369): -u**3*v/w**2, (472, 389): -u/w, (472, 396):
        u**3/w**2, (472, 480): 1, (472, 578): u*v/w, (473, 53):
        -u*v**2/w, (473, 80): u*v/w, (473, 188): -u*v**3/w**2, (473,
        242): u*v**2/w**2, (473, 363): u*v/w, (473, 377):
        -u**2*v**3/w**2, (473, 390): -u/w, (473, 404): u**2*v**2/w**2,
        (473, 457): -u*v**2/w**2, (473, 479): 1, (473, 485): u**2*v/w,
        (473, 511): u*v/w**2, (473, 579): u*v/w, (474, 179):
        -u**2*v/w**2, (474, 184): -u**4*v/w**2, (474, 187):
        -u**3*v/w**2, (474, 188): u**2*v/w, (474, 233): u**2/w**2,
        (474, 238): u**4/w**2, (474, 241): u**3/w**2, (474, 242):
        -u**2/w, (474, 366): u*v/w, (474, 368): -u**3*v/w**2, (474,
        373): -u**3*v*(u**2 - v)/w**2, (474, 376): -u**4*v/w**2, (474,
        377): u**3*v/w, (474, 393): -u/w, (474, 395): u**3/w**2, (474,
        400): u**3*(u**2 - v)/w**2, (474, 403): u**4/w**2, (474, 404):
        -u**3/w, (474, 431): -u*v, (474, 535): -u**3*v/w**2, (474,
        562): u**3/w**2, (474, 582): 1, (474, 589): u**2*v/w, (474,
        611): -u*v*(u*v - w)/w**2, (474, 616): -u**2*(u**2*v**2 -
        u*v*w + w**2)/w**2, (474, 619): -u**2*v*(u*v - w)/w**2, (474,
        620): -u*v, (474, 638): u*(u*v - w)/w**2, (474, 643):
        u**4*v/w**2, (474, 646): u**2*(u*v - w)/w**2, (474, 647): u,
        (475, 367): u*v/w, (475, 373): u**3*v/w**2, (475, 394): -u/w,
        (475, 400): -u**3/w**2, (475, 454): u**2*v/w**2, (475, 508):
        -u**2/w**2, (475, 583): 1, (475, 589): u**2/w, (476, 53): u*v,
        (476, 80): -u, (476, 184): -u**2*v/w, (476, 188): u*v**2/w,
        (476, 238): u**2/w, (476, 242): -u*v/w, (476, 373): -u**3*v/w,
        (476, 377): u**2*v**2/w, (476, 400): u**3/w, (476, 404):
        -u**2*v/w, (476, 457): u*v/w, (476, 461): 1, (476, 485):
        -u**2, (476, 511): -u/w, (476, 616): -u*v*(u*v - w)/w, (476,
        643): u*(u*v - w)/w, (477, 82): -u, (477, 455): 1, (477, 460):
        -u*v/w, (477, 509): -u/w, (477, 568): -u**2*v/w, (478, 357):
        -v/w, (478, 384): 1/w, (478, 454): -v**3/w**2, (478, 508):
        v**2/w**2, (478, 573): -v/w, (479, 53): v**2/w, (479, 80):
        -v/w, (479, 188): v**3/w**2, (479, 242): -v**2/w**2, (479,
        363): -v/w, (479, 377): u*v**3/w**2, (479, 390): 1/w, (479,
        404): -u*v**2/w**2, (479, 454): u*v**2/w**2, (479, 457):
        v**2/w**2, (479, 485): -u*v/w, (479, 508): -u*v/w**2, (479,
        511): -v/w**2, (479, 579): -v/w, (480, 180): u*v/w**2, (480,
        234): -u/w**2, (480, 362): -v/w, (480, 369): u**2*v/w**2,
        (480, 389): 1/w, (480, 396): -u**2/w**2, (480, 454): v**2/w,
        (480, 508): -v/w, (480, 578): -v/w, (481, 454): -v/w, (481,
        508): 1/w, (482, 244): -v, (482, 271): u*v/w, (482, 298): 1,
        (482, 325): -u/w, (482, 595): u**2*v/w, (482, 622): -u**2/w,
        (483, 105): 1, (483, 483): v/w, (483, 591): u*v/w, (484, 457):
        -v/w, (484, 511): 1/w, (485, 130): -u*v/w**2, (485, 449):
        -v/w**2, (485, 454): -u*(u*v - w)/w**2, (485, 457): -u*v/w**2,
        (485, 485): v/w, (485, 503): w**(-2), (485, 511): u/w**2,
        (485, 589): -u*v**2/w**2, (486, 489): 1, (486, 490): -u/w,
        (487, 450): 1, (487, 487): v/w, (488, 377): -v**2, (488, 404):
        v, (488, 485): w, (489, 490): 1/w, (490, 486): 1, (490, 490):
        v/w, (491, 518): 1, (491, 545): -u/w, (492, 184): -u*v, (492,
        238): u**2*v/w, (492, 292): -v**2, (492, 346): u*v**2/w, (492,
        373): -u**2*v, (492, 400): u**3*v/w, (492, 454): -v**3/w,
        (492, 492): v/w, (492, 520): 1, (492, 547): -u/w, (492, 616):
        -u*v**2, (492, 643): u**2*v**2/w, (493, 130): u*v**2/w, (493,
        265): u*v*w, (493, 319): -u**2*v, (493, 454): u**2*v**2/w,
        (493, 505): 1, (493, 519): u*v/w, (493, 546): -u/w, (493,
        589): -u*v*(u*w - v**2)/w, (494, 521): 1, (494, 548): -u/w,
        (495, 522): 1, (495, 549): -u/w, (496, 50): -v, (496, 77):
        u*v/w, (496, 109): u*v/w, (496, 185): -v**2/w, (496, 239):
        u*v**2/w**2, (496, 455): -v**2/w, (496, 487): u*v**2/w**2,
        (496, 509): u*v**2/w**2, (496, 523): 1, (496, 531): v/w, (496,
        550): -u/w, (496, 558): -u*v/w**2, (496, 563): v**2*(u*v -
        w)/w**3, (496, 568): u*v**2/w, (497, 185): u, (497, 239):
        -u**2/w, (497, 292): v*w, (497, 346): -u*v, (497, 450):
        -u*v/w, (497, 454): v**2, (497, 487): -u**2/w, (497, 497):
        v/w, (497, 526): 1, (497, 536): u*v/w, (497, 553): -u/w, (497,
        563): -u**2*v/w**2, (497, 617): u*v, (497, 644): -u**2*v/w,
        (498, 292): u*v, (498, 295): v, (498, 346): -u**2*v/w, (498,
        349): -u*v/w, (498, 373): u*v, (498, 400): -u**2*v/w, (498,
        454): u*v**2/w, (498, 457): v**2/w, (498, 498): v/w, (498,
        527): 1, (498, 530): v/w, (498, 554): -u/w, (498, 557):
        -u*v/w**2, (499, 369): -u**2*v/w, (499, 396): u**2/w, (499,
        507): 1, (499, 524): u*v/w, (499, 551): -u/w, (500, 52):
        -u*v**2/w, (500, 79): u*v/w, (500, 187): -u*v**3/w**2, (500,
        241): u*v**2/w**2, (500, 376): -u*v**2*(u*v - w)/w**2, (500,
        377): -u*v**3/w, (500, 404): u*v**2/w, (500, 457):
        -u*v**3/w**2, (500, 485): u*v, (500, 506): 1, (500, 511):
        u*v**2/w**2, (500, 525): u*v/w, (500, 552): -u/w, (501, 184):
        -u**2, (501, 238): u**3/w, (501, 368): -u, (501, 373): -u**3,
        (501, 376): -u**2, (501, 377): u*w, (501, 395): u**2/w, (501,
        400): u**4/w, (501, 403): u**3/w, (501, 404): -u**2, (501,
        458): -u*v, (501, 528): 1, (501, 555): -u/w, (501, 616):
        -u**2*v, (501, 643): u**3*v/w, (502, 49): u**2*v/w, (502, 76):
        -u**2/w, (502, 184): u**2*v**2/w**2, (502, 238): -u**2*v/w**2,
        (502, 373): u**2*v*(u*v - w)/w**2, (502, 454): u**2*v**2/w**2,
        (502, 508): -u**2*v/w**2, (502, 529): 1, (502, 535): u**2/w,
        (502, 556): -u/w, (502, 562): -u**3/w**2, (503, 52): u*v,
        (503, 79): -u, (503, 187): u*v**2/w, (503, 241): -u*v/w, (503,
        373): -u*w, (503, 376): u*v*(u*v - w)/w, (503, 377): u*v**2,
        (503, 400): u**2, (503, 404): -u*v, (503, 457): u*v**2/w,
        (503, 485): -u*w, (503, 488): 1, (503, 511): -u*v/w, (504,
        50): w, (504, 77): -u, (504, 109): -u, (504, 185): v, (504,
        239): -u*v/w, (504, 455): v, (504, 487): -u*v/w, (504, 509):
        -u*v/w, (504, 563): -v*(u*v - w)/w**2, (504, 568): -u*v, (505,
        49): -v**3/w, (505, 76): v**2/w, (505, 184): -v**4/w**2, (505,
        238): v**3/w**2, (505, 373): -v**3*(u*v - w)/w**2, (505, 454):
        -v**4/w**2, (505, 508): v**3/w**2, (505, 519): -v/w, (505,
        546): 1/w, (506, 49): u*v**2/w, (506, 52): v**2/w, (506, 76):
        -u*v/w, (506, 79): -v/w, (506, 184): u*v**3/w**2, (506, 187):
        v**3/w**2, (506, 238): -u*v**2/w**2, (506, 241): -v**2/w**2,
        (506, 373): u*v**2*(u*v - w)/w**2, (506, 376): v**2*(u*v -
        w)/w**2, (506, 377): v**3/w, (506, 404): -v**2/w, (506, 454):
        u*v**3/w**2, (506, 457): v**3/w**2, (506, 485): -v, (506,
        508): -u*v**2/w**2, (506, 511): -v**2/w**2, (506, 525): -v/w,
        (506, 552): 1/w, (507, 49): v**2, (507, 76): -v, (507, 184):
        v**3/w, (507, 238): -v**2/w, (507, 369): u*v/w, (507, 373):
        v**2*(u*v - w)/w, (507, 396): -u/w, (507, 454): v**3/w, (507,
        508): -v**2/w, (507, 524): -v/w, (507, 551): 1/w, (508, 49):
        -v, (508, 76): 1, (508, 184): -v**2/w, (508, 238): v/w, (508,
        373): -v*(u*v - w)/w, (508, 454): -v**2/w, (508, 508): v/w,
        (509, 595): w, (509, 622): -u, (510, 132): 1, (510, 510): v/w,
        (510, 591): v, (511, 52): -v, (511, 79): 1, (511, 187):
        -v**2/w, (511, 241): v/w, (511, 376): -v*(u*v - w)/w, (511,
        457): -v**2/w, (511, 511): v/w, (512, 22): -u*v/w, (512, 44):
        -v/w, (512, 49): -u*(u*v - w)/w, (512, 52): -u*v/w, (512, 71):
        1/w, (512, 79): u/w, (512, 130): -u*v**2/w**2, (512, 179):
        -v**2/w**2, (512, 184): -u*v*(u*v - w)/w**2, (512, 187):
        -u*v**2/w**2, (512, 233): v/w**2, (512, 241): u*v/w**2, (512,
        368): -v*(u*v - w)/w**2, (512, 373): -u*v*(u**2*v - u*w -
        v**2)/w**2, (512, 376): -u*v*(u*v - w)/w**2, (512, 400):
        -u*v**2/w**2, (512, 449): -v**2/w**2, (512, 454): -u*v*(u*v -
        w)/w**2, (512, 457): -u*v**2/w**2, (512, 503): v/w**2, (512,
        511): u*v/w**2, (512, 512): v/w, (512, 535): -u*v**2/w**2,
        (512, 562): u*v/w**2, (513, 516): 1, (513, 517): -u/w, (514,
        369): 1, (514, 514): v/w, (515, 296): w, (515, 377): u*v,
        (515, 458): v, (516, 517): 1/w, (517, 513): 1, (517, 517):
        v/w, (518, 545): 1/w, (519, 238): -u*v/w, (519, 346): -v**2/w,
        (519, 373): -v**3/w, (519, 400): -u**2*v/w, (519, 519): v/w,
        (519, 547): 1/w, (519, 643): -u*v**2/w, (520, 184): u*v**2/w,
        (520, 319): u*v, (520, 373): u**2*v**2/w, (520, 492): -u/w,
        (520, 519): -u**2/w, (520, 532): 1, (520, 616): -u*v*(u*w -
        v**2)/w, (521, 548): 1/w, (522, 549): 1/w, (523, 77): -v/w,
        (523, 163): u*v/w, (523, 239): -v**2/w**2, (523, 374):
        -v**2/w, (523, 509): -v**2/w**2, (523, 514): u*v**2/w**2,
        (523, 550): 1/w, (523, 558): v/w**2, (523, 563): -v**3/w**3,
        (523, 595): u*v**2/w, (524, 239): u/w, (524, 346): v, (524,
        369): -u*v/w, (524, 373): v**2, (524, 514): -u**2/w, (524,
        524): v/w, (524, 553): 1/w, (524, 563): u*v/w**2, (524, 644):
        u*v/w, (525, 346): u*v/w, (525, 349): v/w, (525, 373):
        u*v**2/w, (525, 376): v**2/w, (525, 400): u*v/w, (525, 525):
        v/w, (525, 554): 1/w, (525, 557): v/w**2, (526, 369): u**3/w,
        (526, 450): u**2/w, (526, 497): -u/w, (526, 524): -u**2/w,
        (526, 534): 1, (527, 25): u*v/w, (527, 52): u**2*v/w, (527,
        133): u*v**2/w**2, (527, 187): u**2*v**2/w**2, (527, 296):
        u*v, (527, 376): u*v**2*(u**2 - v)/w**2, (527, 377):
        u**2*v**2/w, (527, 403): u*v**2/w**2, (527, 457):
        u**2*v**2/w**2, (527, 458): u*v**2/w, (527, 498): -u/w, (527,
        525): -u**2/w, (527, 533): 1, (527, 538): u*v**2/w**2, (528,
        238): -u**2/w, (528, 377): -u*v, (528, 395): -u/w, (528, 400):
        -u**3/w, (528, 403): -u**2/w, (528, 404): u, (528, 555): 1/w,
        (528, 643): -u**2*v/w, (529, 22): -u**2/w, (529, 49): -u**3/w,
        (529, 130): -u**2*v/w**2, (529, 184): -u**3*v/w**2, (529,
        373): -u**2*v*(u**2 - v)/w**2, (529, 400): -u**2*v/w**2, (529,
        454): -u**3*v/w**2, (529, 535): -u**2*v/w**2, (529, 556): 1/w,
        (529, 562): u**2/w**2, (530, 25): -u, (530, 52): -u**2, (530,
        133): -u*v/w, (530, 187): -u**2*v/w, (530, 296): -u*w, (530,
        376): -u*v*(u**2 - v)/w, (530, 377): -u**2*v, (530, 400): -u,
        (530, 403): -u*v/w, (530, 457): -u**2*v/w, (530, 458): -u*v,
        (530, 515): 1, (530, 538): -u*v/w, (531, 77): 1, (531, 163):
        -u, (531, 239): v/w, (531, 374): v, (531, 509): v/w, (531,
        514): -u*v/w, (531, 563): v**2/w**2, (531, 595): -u*v, (532,
        22): v**2/w, (532, 49): u*v**2/w, (532, 130): v**3/w**2, (532,
        184): u*v**3/w**2, (532, 373): v**3*(u**2 - v)/w**2, (532,
        400): v**3/w**2, (532, 454): u*v**3/w**2, (532, 492): 1/w,
        (532, 519): u/w, (532, 535): v**3/w**2, (533, 22): -u*v/w,
        (533, 25): -v/w, (533, 49): -u**2*v/w, (533, 52): -u*v/w,
        (533, 130): -u*v**2/w**2, (533, 133): -v**2/w**2, (533, 184):
        -u**2*v**2/w**2, (533, 187): -u*v**2/w**2, (533, 296): -v,
        (533, 373): -u*v**2*(u**2 - v)/w**2, (533, 376): -v**2*(u**2 -
        v)/w**2, (533, 377): -u*v**2/w, (533, 400): -u*v**2/w**2,
        (533, 403): -v**2/w**2, (533, 454): -u**2*v**2/w**2, (533,
        457): -u*v**2/w**2, (533, 458): -v**2/w, (533, 498): 1/w,
        (533, 525): u/w, (533, 535): -u*v**2/w**2, (533, 538):
        -v**2/w**2, (534, 22): -v, (534, 49): -u*v, (534, 130):
        -v**2/w, (534, 184): -u*v**2/w, (534, 369): -u**2/w, (534,
        373): -v**2*(u**2 - v)/w, (534, 400): -v**2/w, (534, 450):
        -u/w, (534, 454): -u*v**2/w, (534, 497): 1/w, (534, 524): u/w,
        (534, 535): -v**2/w, (535, 22): 1, (535, 49): u, (535, 130):
        v/w, (535, 184): u*v/w, (535, 373): v*(u**2 - v)/w, (535,
        400): v/w, (535, 454): u*v/w, (535, 535): v/w, (536, 622): 1,
        (537, 186): 1, (537, 537): v/w, (537, 618): v, (538, 25): 1,
        (538, 52): u, (538, 133): v/w, (538, 187): u*v/w, (538, 376):
        v*(u**2 - v)/w, (538, 403): v/w, (538, 457): u*v/w, (538,
        538): v/w, (539, 17): 1/w, (539, 22): u**2/w, (539, 25): u/w,
        (539, 44): u/w, (539, 49): u*(u**2 - v)/w, (539, 52): u**2/w,
        (539, 76): u/w, (539, 125): v/w**2, (539, 130): u**2*v/w**2,
        (539, 133): u*v/w**2, (539, 179): u*v/w**2, (539, 184):
        u*v*(u**2 - v)/w**2, (539, 187): u**2*v/w**2, (539, 238):
        u*v/w**2, (539, 368): v*(u**2 - v)/w**2, (539, 373): u*v*(u**3
        - 2*u*v + w)/w**2, (539, 376): u*v*(u**2 - v)/w**2, (539,
        395): v/w**2, (539, 400): u**2*v/w**2, (539, 403): u*v/w**2,
        (539, 449): u*v/w**2, (539, 454): u*v*(u**2 - v)/w**2, (539,
        457): u**2*v/w**2, (539, 508): u*v/w**2, (539, 530): v/w**2,
        (539, 535): u**2*v/w**2, (539, 538): u*v/w**2, (539, 539):
        v/w, (540, 543): 1, (540, 544): -u/w, (541, 396): 1, (541,
        541): v/w, (542, 350): w, (542, 377): v*w, (543, 544): 1/w,
        (544, 540): 1, (544, 544): v/w, (545, 491): 1, (545, 545):
        v/w, (546, 130): -u*v, (546, 238): -u*v**2/w, (546, 346):
        -v**3/w, (546, 400): -v**2*(u**2 + v)/w, (546, 454): -u**2*v,
        (546, 481): -v**2, (546, 493): 1, (546, 546): v/w, (546, 547):
        v/w, (546, 589): -u*v**2, (546, 643): -u*v**3/w, (547, 238):
        u*v**2/w, (547, 319): u*v**2, (547, 400): u**2*v**2/w, (547,
        427): u*v*w, (547, 519): -u, (547, 559): 1, (547, 643):
        -u*v*(u*w - v**2)/w, (548, 494): 1, (548, 548): v/w, (549,
        495): 1, (549, 549): v/w, (550, 23): -v, (550, 77): -v**2/w,
        (550, 131): -v**2/w, (550, 217): u*v/w, (550, 239):
        -v**3/w**2, (550, 401): -v**2/w, (550, 496): 1, (550, 504):
        v/w, (550, 509): -v**3/w**2, (550, 536): -v**2/w, (550, 541):
        u*v**2/w**2, (550, 550): v/w, (550, 558): v**2/w**2, (550,
        563): v**2*(u*w - v**2)/w**3, (550, 622): u*v**2/w, (551,
        131): u, (551, 239): u*v/w, (551, 346): v**2, (551, 396):
        -u*v/w, (551, 400): v**2, (551, 481): v*w, (551, 499): 1,
        (551, 509): u*v/w, (551, 541): -u**2/w, (551, 551): v/w, (551,
        553): v/w, (551, 563): u*v**2/w**2, (551, 590): u*v, (551,
        644): u*v**2/w, (552, 346): u*v**2/w, (552, 349): v**2/w,
        (552, 400): 2*u*v**2/w, (552, 403): v**2/w, (552, 454): u*v,
        (552, 481): u*v, (552, 484): v, (552, 500): 1, (552, 503):
        v/w, (552, 552): v/w, (552, 554): v/w, (552, 557): v**2/w**2,
        (553, 369): u**2, (553, 524): -u, (553, 561): 1, (554, 52):
        u*v, (554, 187): u*v**2/w, (554, 350): u*v, (554, 376):
        u**2*v**2/w, (554, 377): u*v**2, (554, 457): u*v**2/w, (554,
        525): -u, (554, 560): 1, (554, 565): u*v**2/w**2, (555, 130):
        -u**2, (555, 238): -u**2*v/w, (555, 395): -u*v/w, (555, 400):
        -u**3*v/w, (555, 403): -u**2*v/w, (555, 449): -u, (555, 454):
        -u**3, (555, 457): -u**2, (555, 458): u*w, (555, 501): 1,
        (555, 555): v/w, (555, 589): -u**2*v, (555, 643):
        -u**2*v**2/w, (556, 49): -u**2, (556, 184): -u**2*v/w, (556,
        373): -u**3*v/w, (556, 454): -u**2*v/w, (556, 502): 1, (556,
        508): u**2/w, (556, 556): v/w, (557, 52): -u*w, (557, 187):
        -u*v, (557, 350): -u*w, (557, 376): -u**2*v, (557, 377):
        -u*v*w, (557, 400): -u*v, (557, 454): -u*w, (557, 457): -u*v,
        (557, 542): 1, (557, 565): -u*v/w, (558, 23): w, (558, 77): v,
        (558, 131): v, (558, 217): -u, (558, 239): v**2/w, (558, 401):
        v, (558, 509): v**2/w, (558, 536): v, (558, 541): -u*v/w,
        (558, 563): v*(-u*w + v**2)/w**2, (558, 622): -u*v, (559, 49):
        v**2, (559, 184): v**3/w, (559, 373): u*v**3/w, (559, 454):
        v**3/w, (559, 519): 1, (559, 562): v**3/w**2, (560, 49): -u*v,
        (560, 52): -v, (560, 184): -u*v**2/w, (560, 187): -v**2/w,
        (560, 350): -v, (560, 373): -u**2*v**2/w, (560, 376):
        -u*v**2/w, (560, 377): -v**2, (560, 454): -u*v**2/w, (560,
        457): -v**2/w, (560, 525): 1, (560, 562): -u*v**2/w**2, (560,
        565): -v**2/w**2, (561, 49): -v*w, (561, 184): -v**2, (561,
        369): -u, (561, 373): -u*v**2, (561, 454): -v**2, (561, 524):
        1, (561, 562): -v**2/w, (562, 49): w, (562, 184): v, (562,
        373): u*v, (562, 454): v, (562, 562): v/w, (563, 568): w,
        (563, 622): v, (564, 240): 1, (564, 564): v/w, (564, 645): v,
        (565, 52): w, (565, 187): v, (565, 376): u*v, (565, 457): v,
        (565, 565): v/w, (566, 22): u, (566, 44): 1, (566, 49): u**2,
        (566, 52): u, (566, 130): u*v/w, (566, 179): v/w, (566, 184):
        u**2*v/w, (566, 187): u*v/w, (566, 368): u*v/w, (566, 373):
        u*v*(u**2 - v)/w, (566, 376): u**2*v/w, (566, 400): u*v/w,
        (566, 449): v/w, (566, 454): u**2*v/w, (566, 457): u*v/w,
        (566, 535): u*v/w, (566, 557): v/w**2, (566, 565): u*v/w**2,
        (566, 566): v/w, (567, 570): 1, (567, 571): -u/w, (568, 568):
        v/w, (568, 612): -v/w, (568, 639): 1/w, (569, 269): w, (569,
        323): -u, (570, 571): 1/w, (571, 567): 1, (571, 571): v/w,
        (572, 356): -v/w, (572, 383): 1/w, (573, 184): u**2*v**2/w**2,
        (573, 238): -u**2*v/w**2, (573, 358): -v/w, (573, 373):
        v**2*(u**3 - w)/w**2, (573, 385): 1/w, (573, 400): -u*v*(u**2
        - v)/w**2, (573, 454): v**3/w**2, (573, 535): u*v**2/w**2,
        (573, 562): -u*v/w**2, (573, 573): v/w, (573, 616):
        u**2*v**3/w**2, (573, 643): -u**2*v**2/w**2, (574, 130):
        -u*v**2/w**2, (574, 184): -u*v*(u*v - w)/w**2, (574, 373):
        -u**2*v*(u*v - w)/w**2, (574, 454): -u**2*v**2/w**2, (574,
        465): -u/w, (574, 573): -u**2/w, (574, 586): 1, (574, 589):
        -u*v**3/w**2, (574, 616): -u*v**2*(u*v - w)/w**2, (575, 359):
        -v/w, (575, 386): 1/w, (576, 360): -v/w, (576, 387): 1/w,
        (577, 361): -v/w, (577, 369): -v**2/w**2, (577, 388): 1/w,
        (577, 396): v/w**2, (577, 509): -v/w**2, (577, 595): u*v/w,
        (577, 622): -u**2*v/w**2, (578, 364): -v/w, (578, 373):
        -v*(u*v - w)/w, (578, 391): 1/w, (578, 454): -v**2/w, (578,
        536): -u*v/w**2, (578, 563): u/w**2, (578, 568): -u**2/w,
        (578, 578): v/w, (578, 612): u*v**2/w**2, (578, 639):
        -u*v/w**2, (579, 184): -u*v**2/w**2, (579, 238): u*v/w**2,
        (579, 365): -v/w, (579, 368): -v**2/w**2, (579, 373):
        -u*v*(2*u*v - w)/w**2, (579, 376): -v*(u*v - w)/w**2, (579,
        392): 1/w, (579, 395): v/w**2, (579, 400): u**2*v/w**2, (579,
        454): -u*v**2/w**2, (579, 457): -v**2/w**2, (579, 579): v/w,
        (579, 616): -u*v**3/w**2, (579, 643): u*v**2/w**2, (580, 423):
        u**2/w, (580, 470): -u/w, (580, 578): -u**2/w, (580, 588): 1,
        (581, 133): u*v/w**2, (581, 269): u*v, (581, 323): -u**2*v/w,
        (581, 457): u**2*v/w**2, (581, 471): -u/w, (581, 579):
        -u**2/w, (581, 587): 1, (581, 592): u*v**2/w**2, (582, 179):
        u*v/w**2, (582, 184): u**3*v/w**2, (582, 187): u**2*v/w**2,
        (582, 188): -u*v/w, (582, 233): -u/w**2, (582, 238):
        -u**3/w**2, (582, 241): -u**2/w**2, (582, 242): u/w, (582,
        366): -v/w, (582, 368): u**2*v/w**2, (582, 373): u**2*v*(u**2
        - v)/w**2, (582, 376): u**3*v/w**2, (582, 377): -u**2*v/w,
        (582, 393): 1/w, (582, 395): -u**2/w**2, (582, 400):
        -u**2*(u**2 - v)/w**2, (582, 403): -u**3/w**2, (582, 404):
        u**2/w, (582, 535): u**2*v/w**2, (582, 562): -u**2/w**2, (582,
        611): u*v**2/w**2, (582, 616): u**3*v**2/w**2, (582, 619):
        u**2*v**2/w**2, (582, 638): -u*v/w**2, (582, 643):
        -u**3*v/w**2, (582, 646): -u**2*v/w**2, (583, 130):
        -u**2/w**2, (583, 367): -v/w, (583, 373): -u**2*v/w**2, (583,
        394): 1/w, (583, 400): u**2/w**2, (583, 454): -u**3/w**2,
        (583, 589): -u**2*v/w**2, (584, 133): -u/w, (584, 184): u*v/w,
        (584, 238): -u/w, (584, 269): -u*w, (584, 323): u**2, (584,
        373): u**2*v/w, (584, 400): -u**2/w, (584, 457): -u**2/w,
        (584, 569): 1, (584, 592): -u*v/w, (584, 616): u*v**2/w, (584,
        643): -u*v/w, (585, 509): 1/w, (585, 595): -u, (585, 622):
        u**2/w, (586, 130): v**2/w**2, (586, 454): u*v**2/w**2, (586,
        465): 1/w, (586, 573): u/w, (586, 589): v**3/w**2, (587, 130):
        -u*v/w**2, (587, 133): -v/w**2, (587, 269): -v, (587, 323):
        u*v/w, (587, 454): -u**2*v/w**2, (587, 457): -u*v/w**2, (587,
        471): 1/w, (587, 579): u/w, (587, 589): -u*v**2/w**2, (587,
        592): -v**2/w**2, (588, 130): -v/w, (588, 423): -u/w, (588,
        454): -u*v/w, (588, 470): 1/w, (588, 578): u/w, (588, 589):
        -v**2/w, (589, 130): 1/w, (589, 454): u/w, (589, 589): v/w,
        (590, 271): -v/w, (590, 325): 1/w, (590, 595): -u*v/w, (590,
        622): u/w, (591, 618): 1, (591, 645): -u/w, (592, 133): 1/w,
        (592, 457): u/w, (592, 592): v/w, (593, 125): w**(-2), (593,
        130): u**2/w**2, (593, 133): u/w**2, (593, 449): u/w**2, (593,
        454): u*(u**2 - v)/w**2, (593, 457): u**2/w**2, (593, 508):
        u/w**2, (593, 584): v/w**2, (593, 589): u**2*v/w**2, (593,
        592): u*v/w**2, (593, 593): v/w, (594, 597): 1, (594, 598):
        -u/w, (595, 585): 1/w, (595, 595): v/w, (595, 612): u/w, (596,
        323): 1, (597, 598): 1/w, (598, 594): 1, (598, 598): v/w,
        (599, 356): u/w, (599, 437): 1/w, (600, 130): -u**2*v/w**2,
        (600, 184): -u**3*v/w**2, (600, 358): u/w, (600, 373):
        -v*(u**2 - v)*(u**2 + v)/w**2, (600, 400): -v**2/w**2, (600,
        439): 1/w, (600, 454): -u**3*v/w**2, (600, 508): -u*v/w**2,
        (600, 535): -u**2*v/w**2, (600, 589): -u**2*v**2/w**2, (600,
        600): v/w, (600, 616): -u**3*v**2/w**2, (601, 130):
        u**2*v/w**2, (601, 184): u*v*(u**2 - v)/w**2, (601, 238):
        u*v/w**2, (601, 276): -u/w, (601, 373): u**2*v*(u**2 -
        v)/w**2, (601, 400): u**2*v/w**2, (601, 454): u**3*v/w**2,
        (601, 589): u**2*v**2/w**2, (601, 600): -u**2/w, (601, 613):
        1, (601, 616): u*v**2*(u**2 - v)/w**2, (601, 643):
        u*v**2/w**2, (602, 359): u/w, (602, 440): 1/w, (603, 360):
        u/w, (603, 441): 1/w, (604, 361): u/w, (604, 369): u*v/w**2,
        (604, 442): 1/w, (604, 450): v/w**2, (604, 536): -v/w**2,
        (604, 622): u*v/w**2, (605, 364): u/w, (605, 373): v*(u**2 -
        v)/w, (605, 400): v/w, (605, 445): 1/w, (605, 454): u*v/w,
        (605, 509): u/w**2, (605, 536): u**2/w**2, (605, 585):
        -u*v/w**2, (605, 595): -u**2/w, (605, 605): v/w, (605, 612):
        -u**2*v/w**2, (606, 130): u*v/w**2, (606, 184): u**2*v/w**2,
        (606, 365): u/w, (606, 368): u*v/w**2, (606, 373): u*v*(2*u**2
        - v)/w**2, (606, 376): v*(u**2 - v)/w**2, (606, 400):
        u*v/w**2, (606, 403): v/w**2, (606, 446): 1/w, (606, 449):
        v/w**2, (606, 454): 2*u**2*v/w**2, (606, 457): u*v/w**2, (606,
        589): u*v**2/w**2, (606, 606): v/w, (606, 616):
        u**2*v**2/w**2, (607, 261): u**2/w, (607, 281): -u/w, (607,
        605): -u**2/w, (607, 615): 1, (608, 187): u*v/w**2, (608,
        282): -u/w, (608, 323): u*v/w, (608, 376): u**2*v/w**2, (608,
        606): -u**2/w, (608, 614): 1, (608, 619): u*v**2/w**2, (609,
        125): -u/w**2, (609, 130): -u**3/w**2, (609, 133): -u**2/w**2,
        (609, 134): u/w, (609, 179): -u**2/w**2, (609, 184):
        -u**4/w**2, (609, 187): -u**3/w**2, (609, 188): u**2/w, (609,
        366): u/w, (609, 368): -u**3/w**2, (609, 373): -u**3*(u**2 -
        v)/w**2, (609, 376): -u**4/w**2, (609, 377): u**3/w, (609,
        447): 1/w, (609, 449): -u**2/w**2, (609, 454): -u**2*(u**2 -
        v)/w**2, (609, 457): -u**3/w**2, (609, 458): u**2/w, (609,
        508): -u**2/w**2, (609, 535): -u**3/w**2, (609, 584):
        -u*v/w**2, (609, 589): -u**3*v/w**2, (609, 592): -u**2*v/w**2,
        (609, 611): -u**2*v/w**2, (609, 616): -u**4*v/w**2, (609,
        619): -u**3*v/w**2, (610, 184): -u**2/w**2, (610, 367): u/w,
        (610, 448): 1/w, (610, 454): u**2/w**2, (610, 616):
        -u**2*v/w**2, (611, 130): -u/w, (611, 184): -u**2/w, (611,
        187): -u/w, (611, 323): -u, (611, 373): -u**3/w, (611, 376):
        -u**2/w, (611, 454): -u**2/w, (611, 589): -u*v/w, (611, 596):
        1, (611, 616): -u**2*v/w, (611, 619): -u*v/w, (612, 536): 1/w,
        (612, 622): -u/w, (613, 184): v**2/w**2, (613, 276): 1/w,
        (613, 373): u*v**2/w**2, (613, 600): u/w, (613, 616):
        v**3/w**2, (614, 184): -u*v/w**2, (614, 187): -v/w**2, (614,
        282): 1/w, (614, 323): -v/w, (614, 373): -u**2*v/w**2, (614,
        376): -u*v/w**2, (614, 606): u/w, (614, 616): -u*v**2/w**2,
        (614, 619): -v**2/w**2, (615, 184): -v/w, (615, 261): -u/w,
        (615, 281): 1/w, (615, 373): -u*v/w, (615, 605): u/w, (615,
        616): -v**2/w, (616, 184): 1/w, (616, 373): u/w, (616, 616):
        v/w, (617, 271): u/w, (617, 460): 1/w, (617, 568): u/w, (617,
        595): u**2/w, (618, 645): 1/w, (619, 187): 1/w, (619, 376):
        u/w, (619, 619): v/w, (620, 179): w**(-2), (620, 184):
        u**2/w**2, (620, 187): u/w**2, (620, 368): u/w**2, (620, 373):
        u*(u**2 - v)/w**2, (620, 376): u**2/w**2, (620, 535): u/w**2,
        (620, 611): v/w**2, (620, 616): u**2*v/w**2, (620, 619):
        u*v/w**2, (620, 620): v/w, (621, 624): 1, (621, 625): -u/w,
        (622, 612): 1, (622, 622): v/w, (623, 323): v, (623, 431): w,
        (624, 625): 1/w, (625, 621): 1, (625, 625): v/w, (626, 356):
        1, (627, 184): -u**2*v/w, (627, 358): 1, (627, 373):
        -u**3*v/w, (627, 454): -v**2/w, (627, 535): -u*v/w, (627,
        616): -u**2*v**2/w, (627, 627): v/w, (628, 130): u*v/w, (628,
        184): u**2*v/w, (628, 330): -u/w, (628, 373): u**3*v/w, (628,
        454): u**2*v/w, (628, 589): u*v**2/w, (628, 616): u**2*v**2/w,
        (628, 627): -u**2/w, (628, 640): 1, (629, 359): 1, (630, 360):
        1, (631, 361): 1, (631, 369): v/w, (631, 563): -v/w**2, (631,
        568): u*v/w, (631, 622): u*v**2/w**2, (632, 364): 1, (632,
        373): u*v, (632, 454): v, (632, 536): u/w, (632, 612): -u*v/w,
        (632, 622): -u**2/w, (632, 632): v/w, (633, 184): u*v/w, (633,
        365): 1, (633, 368): v/w, (633, 373): 2*u**2*v/w, (633, 376):
        u*v/w, (633, 454): u*v/w, (633, 457): v/w, (633, 616):
        u*v**2/w, (633, 633): v/w, (634, 315): u**2/w, (634, 335):
        -u/w, (634, 632): -u**2/w, (634, 642): 1, (635, 241):
        u*v/w**2, (635, 323): u*v**2/w, (635, 336): -u/w, (635, 403):
        u**2*v/w**2, (635, 431): u*v, (635, 633): -u**2/w, (635, 641):
        1, (635, 646): u*v**2/w**2, (636, 179): -u/w, (636, 184):
        -u**3/w, (636, 187): -u**2/w, (636, 188): u, (636, 366): 1,
        (636, 368): -u**2/w, (636, 373): -u**2*(u**2 - v)/w, (636,
        376): -u**3/w, (636, 377): u**2, (636, 535): -u**2/w, (636,
        611): -u*v/w, (636, 616): -u**3*v/w, (636, 619): -u**2*v/w,
        (637, 238): -u**2/w**2, (637, 367): 1, (637, 373): u**2/w,
        (637, 400): -u**3/w**2, (637, 643): -u**2*v/w**2, (638, 184):
        -u, (638, 241): -u/w, (638, 323): -u*v, (638, 373): -u**2,
        (638, 403): -u**2/w, (638, 431): -u*w, (638, 616): -u*v, (638,
        623): 1, (638, 646): -u*v/w, (639, 563): 1/w, (639, 568): -u,
        (639, 622): -u*v/w, (640, 238): v**2/w**2, (640, 330): 1/w,
        (640, 400): u*v**2/w**2, (640, 627): u/w, (640, 643):
        v**3/w**2, (641, 238): -u*v/w**2, (641, 241): -v/w**2, (641,
        323): -v**2/w, (641, 336): 1/w, (641, 400): -u**2*v/w**2,
        (641, 403): -u*v/w**2, (641, 431): -v, (641, 633): u/w, (641,
        643): -u*v**2/w**2, (641, 646): -v**2/w**2, (642, 238): -v/w,
        (642, 315): -u/w, (642, 335): 1/w, (642, 400): -u*v/w, (642,
        632): u/w, (642, 643): -v**2/w, (643, 238): 1/w, (643, 400):
        u/w, (643, 643): v/w, (644, 271): 1, (644, 595): u, (645,
        591): 1, (645, 645): v/w, (646, 241): 1/w, (646, 403): u/w,
        (646, 646): v/w, (647, 233): w**(-2), (647, 238): u**2/w**2,
        (647, 241): u/w**2, (647, 395): u/w**2, (647, 400): u*(u**2 -
        v)/w**2, (647, 403): u**2/w**2, (647, 562): u/w**2, (647,
        638): v/w**2, (647, 643): u**2*v/w**2, (647, 646): u*v/w**2,
        (647, 647): v/w}]])
    return data

