/*
 * Decompiled with CFR 0.152.
 */
package org.parosproxy.paros.model;

import java.util.Comparator;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import org.parosproxy.paros.model.SiteNode;
import org.parosproxy.paros.model.SiteNodeStringComparator;

class SortedTreeModel
extends DefaultTreeModel {
    private static final long serialVersionUID = 4130060741120936997L;
    private Comparator<SiteNode> comparator;

    public SortedTreeModel(TreeNode node, SiteNodeStringComparator siteNodeStringComparator) {
        super(node);
        this.comparator = siteNodeStringComparator;
    }

    public SortedTreeModel(TreeNode node) {
        super(node);
        this.comparator = new SiteNodeStringComparator();
    }

    public SortedTreeModel(TreeNode node, boolean asksAllowsChildren, Comparator<SiteNode> aComparator) {
        super(node, asksAllowsChildren);
        this.comparator = aComparator;
    }

    public void insertNodeInto(SiteNode child, SiteNode parent) {
        int index = this.findIndexFor(child, parent);
        super.insertNodeInto(child, parent, index);
    }

    public void insertNodeInto(SiteNode child, SiteNode parent, int i) {
        this.insertNodeInto(child, parent);
    }

    private int findIndexFor(SiteNode child, SiteNode parent) {
        int childCount = parent.getChildCount();
        if (childCount == 0) {
            return 0;
        }
        if (childCount == 1) {
            return this.comparator.compare(child, (SiteNode)parent.getChildAt(0)) <= 0 ? 0 : 1;
        }
        return this.findIndexFor(child, parent, 0, childCount - 1);
    }

    private int findIndexFor(SiteNode child, SiteNode parent, int idx1, int idx2) {
        if (idx1 == idx2) {
            return this.comparator.compare(child, (SiteNode)parent.getChildAt(idx1)) <= 0 ? idx1 : idx1 + 1;
        }
        int half = (idx1 + idx2) / 2;
        if (this.comparator.compare(child, (SiteNode)parent.getChildAt(half)) <= 0) {
            return this.findIndexFor(child, parent, idx1, half);
        }
        return this.findIndexFor(child, parent, half + 1, idx2);
    }
}

